/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.MainCanvas;
import sk.inlogic.RMSObjects;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.coords.Coords;
import sk.inlogic.powV2.PowV2ScoreItem;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.table.Table;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenScore
implements IScreen {
    MainCanvas mainCanvas;
    Coords coords;
    Table table;
    boolean isComplete;
    private Rectangle rectText;
    private static PreparedText preparedText1;
    private static PreparedText preparedText2;
    String scoreText1;
    String scoreText2;
    public static final int SPR_YES = 12;
    public static final int SPR_SCORE2 = 0;
    Rectangle rectItems;
    public int posX;
    public int posYUp;
    public int posYDown;
    public int tilesX;
    public int tilesY;
    Image imgBtnDown;
    Image imgCircle;
    Sprite sprTable;
    Sprite sprIconUp;
    Sprite sprIconDown;
    boolean isPressed;
    boolean isOnBtn;
    boolean isLoadingFlag;
    boolean fromMenu;

    public ScreenScore(MainCanvas mainCanvas, boolean fromMenu) {
        this.mainCanvas = mainCanvas;
        this.fromMenu = fromMenu;
    }

    public void beforeShow() {
        this.isLoadingFlag = true;
        this.checkLowMem();
        this.coords = new Coords();
        this.table = new Table();
        this.imgBtnDown = Resources.resImgs[73];
        this.imgCircle = Resources.resImgs[75];
        this.sprTable = Resources.resSprs[1];
        this.sprIconUp = Resources.resSprs[15];
        this.sprIconUp.setFrame(0);
        this.sprIconDown = Resources.resSprs[14];
        this.sprIconDown.setFrame(12);
        Resources.loadGFont(this.coords.gfontMain);
        Resources.loadGFont(this.coords.gfontMain2);
        this.calculatePositions();
        this.calculateTable();
        this.calculateContent();
        if (this.coords.isBigScore) {
            preparedText1 = new PreparedText(Resources.resGFonts[this.coords.gfontMain]);
            preparedText2 = new PreparedText(Resources.resGFonts[this.coords.gfontMain]);
        } else {
            preparedText1 = new PreparedText(Resources.resGFonts[this.coords.gfontMain2]);
            preparedText2 = new PreparedText(Resources.resGFonts[this.coords.gfontMain2]);
        }
        this.loadScore();
        this.prepareScoreList();
        preparedText1.prepareText(this.scoreText1, this.rectText.width);
        preparedText2.prepareText(this.scoreText2, this.rectText.width);
        this.isLoadingFlag = false;
    }

    public void loadScore() {
        RMSObjects.createRMSConnect(1);
        if (!RMSObjects.rmsConnects[1].load()) {
            RMSObjects.rmsConnects[1].create();
        }
        RMSObjects.freeRMSConnect(1);
    }

    public void checkLowMem() {
        this.isComplete = false;
    }

    public void afterHide() {
    }

    public void beforeInteruption() {
        if (MainCanvas.soundManager.IsSoundOn()) {
            MainCanvas.soundManager.Stop();
        }
    }

    public void afterInteruption() {
        if (MainCanvas.soundManager.IsSoundOn()) {
            while (!MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1)) {
                for (int counterPlaySounds = 0; counterPlaySounds < 10; ++counterPlaySounds) {
                }
            }
        }
    }

    private void calculatePositions() {
        this.posX = MainCanvas.WIDTH >> 1;
        this.posYDown = MainCanvas.HEIGHT - (this.coords.shiftBtnDown + this.coords.shiftMaster);
        this.tilesX = (MainCanvas.WIDTH - this.sprTable.getWidth()) / this.sprTable.getWidth();
        this.tilesY = !MainCanvas.isRotated ? this.posYDown / this.sprTable.getHeight() : (this.posYDown - this.sprTable.getHeight()) / this.sprTable.getHeight();
        this.posYUp = this.posYDown - this.tilesY * this.sprTable.getHeight() + (this.sprTable.getHeight() >> 2);
        this.rectItems = new Rectangle(this.posX - (this.imgBtnDown.getWidth() >> 1), this.posYDown - (this.imgBtnDown.getHeight() >> 1), this.imgBtnDown.getWidth(), this.imgBtnDown.getHeight());
    }

    public void calculateTable() {
        int x = MainCanvas.WIDTH - this.tilesX * this.sprTable.getWidth() >> 1;
        int y = this.posYDown - this.tilesY * this.sprTable.getHeight();
        this.table.set(x, y, this.tilesX, this.tilesY, this.sprTable);
    }

    public void calculateContent() {
        int contentYUp = this.posYUp + this.sprIconUp.getHeight() + (this.sprTable.getHeight() >> 2);
        int contentYDown = this.posYDown - (this.imgBtnDown.getHeight() >> 1) - (this.sprTable.getHeight() >> 2);
        int textMarginLeft = (MainCanvas.WIDTH - this.tilesX * this.sprTable.getWidth() >> 1) + this.tilesX / 4 * this.sprTable.getWidth();
        int textMarginTop = contentYUp;
        int textWidth = MainCanvas.WIDTH - (textMarginLeft << 1);
        int textHeight = contentYDown - contentYUp;
        this.rectText = new Rectangle(textMarginLeft, textMarginTop + this.coords.shiftScoreUp, textWidth, textHeight - this.coords.shiftScoreDown);
    }

    private void prepareScoreList() {
        RMSObjects.createRMSConnect(1);
        if (!RMSObjects.rmsConnects[1].load()) {
            RMSObjects.rmsConnects[1].create();
        }
        this.scoreText1 = "";
        this.scoreText2 = "";
        int scoresCount = 0;
        Vector scores = RMSObjects.localScores.getScoresForGame(0);
        if (scores != null) {
            scoresCount = scores.size();
            PowV2ScoreItem scoreItem = null;
            for (int i = 0; i < scoresCount; ++i) {
                scoreItem = (PowV2ScoreItem)scores.elementAt(i);
                String userName = new String(scoreItem.userName);
                String scoreTextLine1 = scoreItem.scorePos + "";
                String scoreTextLine2 = userName + "" + scoreItem.scoreValue;
                if (this.coords.isBigScore) {
                    while (Resources.resGFonts[this.coords.gfontMain].stringWidth((scoreTextLine2 + " ").toCharArray()) < this.rectText.width) {
                        userName = userName + " ";
                        scoreTextLine2 = userName + "" + scoreItem.scoreValue;
                    }
                } else {
                    while (Resources.resGFonts[this.coords.gfontMain2].stringWidth((scoreTextLine2 + " ").toCharArray()) < this.rectText.width) {
                        userName = userName + " ";
                        scoreTextLine2 = userName + "" + scoreItem.scoreValue;
                    }
                }
                this.scoreText1 = this.scoreText1 + scoreTextLine1 + (i == scoresCount - 1 ? "" : "\n");
                this.scoreText2 = this.scoreText2 + scoreTextLine2 + (i == scoresCount - 1 ? "" : "\n");
            }
        }
        RMSObjects.freeRMSConnect(1);
        if (scoresCount < 10) {
            if (scoresCount > 0) {
                this.scoreText1 = this.scoreText1 + "\n";
                this.scoreText2 = this.scoreText2 + "\n";
            }
            for (int i = scoresCount; i < 10; ++i) {
                String userName = "";
                String scoreTextLine1 = i + 1 + "";
                String scoreTextLine2 = userName + "0";
                if (this.coords.isBigScore) {
                    while (Resources.resGFonts[this.coords.gfontMain].stringWidth((scoreTextLine2 + " ").toCharArray()) < this.rectText.width) {
                        userName = userName + " ";
                        scoreTextLine2 = userName + "0";
                    }
                } else {
                    while (Resources.resGFonts[this.coords.gfontMain2].stringWidth((scoreTextLine2 + " ").toCharArray()) < this.rectText.width) {
                        userName = userName + " ";
                        scoreTextLine2 = userName + "0";
                    }
                }
                this.scoreText1 = this.scoreText1 + scoreTextLine1 + (i == 9 ? "" : "\n");
                this.scoreText2 = this.scoreText2 + scoreTextLine2 + (i == 9 ? "" : "\n");
            }
        }
    }

    public void update(long lastRunLenght) {
    }

    public void paint(Graphics g) {
        if (!this.isComplete) {
            g.setColor(0);
            g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        }
        this.paintDialog(g);
    }

    private void paintDialog(Graphics g) {
        this.table.draw(g);
        g.drawImage(this.imgCircle, this.posX, this.posYDown + this.coords.shiftDownCircle, 3);
        g.drawImage(this.imgBtnDown, this.posX, this.posYDown, 3);
        this.paintDialogItems(g);
    }

    private void paintDialogItems(Graphics g) {
        this.sprIconUp.setPosition(this.posX - (this.sprIconUp.getWidth() >> 1), this.posYUp);
        this.sprIconUp.paint(g);
        this.sprIconDown.setPosition(this.posX - (this.sprIconDown.getWidth() >> 1), this.posYDown - (this.sprIconDown.getHeight() >> 1));
        this.sprIconDown.paint(g);
        int rectTextHeight = this.rectText.height;
        int textHeight = preparedText1.getTextHeight();
        int textOffsetY = 0;
        if (textHeight < rectTextHeight) {
            textOffsetY = -(rectTextHeight >> 1) + (textHeight >> 1);
        }
        preparedText1.drawText(g, this.rectText, textOffsetY, 20);
        preparedText2.drawText(g, this.rectText, textOffsetY, 24);
    }

    public void keyPressed(int keyCode) {
        if (!MainCanvas.touchActivated && !this.isPressed && Keys.isActionGeneratedByKey(5, keyCode)) {
            this.press();
        }
    }

    public void keyReleased(int keyCode) {
        if (!MainCanvas.touchActivated && Keys.isActionGeneratedByKey(5, keyCode)) {
            this.isOnBtn = true;
            this.release();
        }
    }

    public void pointerPressed(int x, int y) {
        if (this.rectItems.contains(x, y)) {
            this.isOnBtn = true;
            this.press();
        }
    }

    public void pointerDragged(int x, int y) {
        if (!this.rectItems.contains(x, y)) {
            this.isOnBtn = false;
            this.release();
        }
    }

    public void pointerReleased(int x, int y) {
        if (this.rectItems.contains(x, y) && this.isPressed && this.isOnBtn) {
            this.release();
        }
    }

    public void press() {
        this.isPressed = true;
    }

    public void release() {
        this.isPressed = false;
        if (this.isOnBtn) {
            this.confirm();
        }
    }

    public void confirm() {
        if (this.fromMenu) {
            this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 1, false));
        } else {
            this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0, false));
        }
        this.mainCanvas.repaint();
    }
}

