/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.MainCanvas;
import sk.inlogic.RMSObjects;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.coords.Coords;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenOptions;
import sk.inlogic.table.Table;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenReset
implements IScreen {
    MainCanvas mainCanvas;
    Coords coords;
    Table table;
    boolean isComplete;
    public static final int COMP_ID_YES = 0;
    public static final int COMP_ID_NO = 1;
    public static final int TOTAL_COMP_IDS = 2;
    public static final int SPR_YES = 12;
    public static final int SPR_NO = 13;
    public static final int[] SPR_ITEMS = new int[]{12, 13};
    Rectangle[] rectItems = new Rectangle[2];
    private Rectangle rectText;
    private static PreparedText preparedText;
    private int selectedItem;
    public int posX;
    public int posYMaster;
    public int posYBtnUp;
    public int posYBtnMain;
    public int posYBtnDown;
    public int btnMain;
    public int btnUp;
    public int btnDown;
    public int timerPressed;
    public int timerReleased;
    public int timerSelected;
    public int timerScrolled;
    public int posYUp;
    public int tilesX;
    public int tilesY;
    boolean isPressed;
    boolean isOnMainBtn;
    boolean isLoadingFlag;
    Image imgBtnMain;
    Image imgBtnDown;
    Image imgCircle;
    Sprite sprTable;
    Sprite sprIconMain;
    Sprite sprIconDown;

    public ScreenReset(MainCanvas mainCanvas) {
        this.mainCanvas = mainCanvas;
    }

    public void beforeShow() {
        this.isLoadingFlag = true;
        this.checkLowMem();
        this.coords = new Coords();
        this.table = new Table();
        this.imgBtnDown = Resources.resImgs[73];
        this.imgBtnMain = Resources.resImgs[74];
        this.imgCircle = Resources.resImgs[75];
        this.sprTable = Resources.resSprs[1];
        this.sprIconMain = Resources.resSprs[14];
        this.sprIconDown = Resources.resSprs[14];
        Resources.loadGFont(this.coords.gfontMain2);
        this.calculatePositions();
        this.calculateTable();
        this.calculateContent();
        preparedText = new PreparedText(Resources.resGFonts[this.coords.gfontMain2]);
        if (!this.coords.isShortText) {
            preparedText.prepareText(Resources.resTexts[0].getHashedString(11).toUpperCase(), this.rectText.width);
        } else {
            preparedText.prepareText(Resources.resTexts[0].getHashedString(75).toUpperCase(), this.rectText.width);
        }
        this.isLoadingFlag = false;
    }

    public void checkLowMem() {
        this.isComplete = false;
    }

    public void afterHide() {
    }

    public void beforeInteruption() {
        if (MainCanvas.soundManager.IsSoundOn()) {
            MainCanvas.soundManager.Stop();
        }
    }

    public void afterInteruption() {
        if (MainCanvas.soundManager.IsSoundOn()) {
            while (!MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1)) {
                for (int counterPlaySounds = 0; counterPlaySounds < 10; ++counterPlaySounds) {
                }
            }
        }
    }

    private void calculatePositions() {
        this.selectedItem = 1;
        this.timerPressed = 0;
        this.timerReleased = 0;
        this.timerSelected = 0;
        this.timerScrolled = 0;
        this.isPressed = false;
        this.posX = MainCanvas.WIDTH >> 1;
        this.posYBtnDown = MainCanvas.HEIGHT - (this.coords.shiftBtnDown + this.coords.shiftMaster);
        this.posYBtnMain = MainCanvas.HEIGHT - (this.coords.shiftBtnMain + this.coords.shiftMaster);
        this.posYBtnUp = MainCanvas.HEIGHT - (this.coords.shiftBtnUp + this.coords.shiftMaster);
        this.tilesX = (MainCanvas.WIDTH - this.sprTable.getWidth()) / this.sprTable.getWidth();
        this.tilesY = !MainCanvas.isRotated ? (this.posYBtnMain - this.imgBtnDown.getHeight()) / this.sprTable.getHeight() : (this.posYBtnMain - this.imgBtnDown.getHeight() - this.sprTable.getHeight()) / this.sprTable.getHeight();
        this.posYUp = this.posYBtnMain - this.imgBtnDown.getHeight() - this.tilesY * this.sprTable.getHeight();
        if (!this.isComplete) {
            this.rectItems[0] = new Rectangle(this.posX - (this.imgBtnMain.getWidth() >> 1), this.posYBtnMain - (this.imgBtnMain.getHeight() >> 1), this.imgBtnMain.getWidth(), this.imgBtnMain.getHeight());
        }
        this.rectItems[1] = new Rectangle(this.posX - (this.imgBtnDown.getWidth() >> 1), this.posYBtnDown - (this.imgBtnDown.getHeight() >> 1), this.imgBtnDown.getWidth(), this.imgBtnDown.getHeight());
    }

    public void calculateTable() {
        int x = MainCanvas.WIDTH - this.tilesX * this.sprTable.getWidth() >> 1;
        int y = this.posYBtnMain - this.imgBtnDown.getHeight() - this.tilesY * this.sprTable.getHeight();
        this.table.set(x, y, this.tilesX, this.tilesY, this.sprTable);
    }

    public void calculateContent() {
        int contentYUp = this.posYUp + (this.sprTable.getHeight() >> 2);
        int contentYDown = this.posYBtnMain - this.imgBtnDown.getHeight();
        int textMarginLeft = (MainCanvas.WIDTH - this.tilesX * this.sprTable.getWidth() >> 1) + (this.sprTable.getWidth() >> 1);
        int textMarginTop = contentYUp;
        int textWidth = MainCanvas.WIDTH - (textMarginLeft << 1);
        int textHeight = contentYDown - contentYUp;
        this.rectText = new Rectangle(textMarginLeft, textMarginTop, textWidth, textHeight);
    }

    public void update(long lastRunLenght) {
    }

    public void paint(Graphics g) {
        if (!this.isComplete) {
            g.setColor(0);
            g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        }
        this.paintDialog(g);
    }

    public void paintDialog(Graphics g) {
        g.drawImage(this.imgBtnMain, this.posX, this.posYBtnMain, 3);
        g.drawImage(this.imgBtnDown, this.posX, this.posYBtnDown, 3);
        this.paintDialogItems(g);
    }

    public void paintDialogItems(Graphics g) {
        this.sprIconMain.setFrame(SPR_ITEMS[this.selectedItem]);
        this.sprIconMain.setPosition(this.posX - (this.sprIconMain.getWidth() >> 1), this.posYBtnMain - (this.sprIconMain.getHeight() >> 1));
        this.sprIconMain.paint(g);
        if (this.selectedItem == 1) {
            this.sprIconDown.setFrame(SPR_ITEMS[0]);
        } else {
            this.sprIconDown.setFrame(SPR_ITEMS[this.selectedItem + 1]);
        }
        this.sprIconDown.setPosition(this.posX - (this.sprIconDown.getWidth() >> 1), this.posYBtnDown - (this.sprIconDown.getHeight() >> 1));
        this.sprIconDown.paint(g);
        this.table.draw(g);
        int rectTextHeight = this.rectText.height;
        int textHeight = preparedText.getTextHeight();
        preparedText.drawText(g, this.rectText, -(rectTextHeight >> 1) + (textHeight >> 1), 17);
    }

    public void keyPressed(int keyCode) {
        if (!(MainCanvas.touchActivated || this.isLoadingFlag || this.isPressed)) {
            if (Keys.isActionGeneratedByKey(1, keyCode) || Keys.isActionGeneratedByKey(2, keyCode)) {
                this.setDown();
            }
            if (Keys.isActionGeneratedByKey(5, keyCode)) {
                this.press();
            }
        }
    }

    public void keyReleased(int keyCode) {
        if (!MainCanvas.touchActivated && Keys.isActionGeneratedByKey(5, keyCode)) {
            this.isOnMainBtn = true;
            this.release();
        }
    }

    public void setDown() {
        this.selectedItem = (this.selectedItem + 1) % 2;
        this.mainCanvas.repaint();
    }

    public void pointerPressed(int x, int y) {
        if (this.rectItems[0].contains(x, y)) {
            this.isOnMainBtn = true;
            this.press();
        } else if (this.rectItems[1].contains(x, y)) {
            this.setDown();
        }
    }

    public void pointerDragged(int x, int y) {
        if (!this.rectItems[0].contains(x, y)) {
            this.isOnMainBtn = false;
            this.release();
        }
    }

    public void pointerReleased(int x, int y) {
        if (this.rectItems[0].contains(x, y) && this.isPressed && this.isOnMainBtn) {
            this.release();
        }
    }

    public void press() {
        this.isPressed = true;
        this.mainCanvas.repaint();
    }

    public void release() {
        this.isPressed = false;
        this.mainCanvas.repaint();
        this.mainCanvas.serviceRepaints();
        if (this.isOnMainBtn) {
            this.select();
        }
    }

    public void select() {
        this.isOnMainBtn = false;
        switch (this.selectedItem) {
            case 0: {
                this.deleteAll();
                this.mainCanvas.changeLastActiveScreen(new ScreenOptions(this.mainCanvas, 1));
                break;
            }
            case 1: {
                this.mainCanvas.changeLastActiveScreen(new ScreenOptions(this.mainCanvas, 1));
            }
        }
        this.mainCanvas.repaint();
    }

    public void deleteAll() {
        this.deleteSavedGame();
        this.deleteAchievements();
        this.deleteScore();
    }

    public void deleteSavedGame() {
        RMSObjects.createRMSConnect(3);
        if (RMSObjects.rmsConnects[3].isExist()) {
            RMSObjects.rmsConnects[3].delete();
        }
        RMSObjects.freeRMSConnect(3);
    }

    public void deleteAchievements() {
        RMSObjects.createRMSConnect(2);
        if (RMSObjects.rmsConnects[2].isExist()) {
            RMSObjects.rmsConnects[2].delete();
        }
        RMSObjects.freeRMSConnect(2);
    }

    public void deleteScore() {
        RMSObjects.createRMSConnect(1);
        if (RMSObjects.rmsConnects[1].isExist()) {
            RMSObjects.rmsConnects[1].delete();
        }
        RMSObjects.freeRMSConnect(1);
    }
}

