/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.MainCanvas;
import sk.inlogic.RMSObjects;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.coords.Coords;
import sk.inlogic.gamedefines.AchievementsDefines;
import sk.inlogic.gamedefines.DragonDefines;
import sk.inlogic.gamedefines.EnvironmentsDefines;
import sk.inlogic.gamedefines.GameDefines;
import sk.inlogic.graphics.ImageScaler;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenFinalText;
import sk.inlogic.screen.ScreenPause;
import sk.inlogic.screen.ScreenSummary;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Particles;
import sk.inlogic.util.RandomNum;
import sk.inlogic.util.Rectangle;

public class ScreenGame
implements IScreen {
    MainCanvas mainCanvas;
    Coords coords;
    GameDefines gd;
    DragonDefines dd;
    EnvironmentsDefines ed;
    AchievementsDefines ad;
    boolean isComplete;
    boolean isLowFrameRate;
    boolean isLoadAll;
    private Rectangle rectTextCoins1;
    private Rectangle rectTextCoins2;
    private Rectangle rectTextCoins3;
    private Rectangle rectTextSlides1;
    private Rectangle rectTextSlides2;
    private static PreparedText preparedTextCoins1;
    private static PreparedText preparedTextCoins2;
    private static PreparedText preparedTextCoins3;
    private static PreparedText preparedTextSlides1;
    private static PreparedText preparedTextSlides2;
    private Rectangle rectTextCountdown;
    private static PreparedText preparedTextCountdown;
    private Rectangle rectText;
    private Rectangle rectText1;
    private Rectangle rectText2;
    private Rectangle rectText3;
    private Rectangle rectText4;
    private static PreparedText preparedText;
    private static PreparedText preparedText1;
    private static PreparedText preparedText2;
    private static PreparedText preparedText3;
    private static PreparedText preparedText4;
    public static final int INT_NULL = -9999;
    public int maxCoords;
    public int[] COORDS;
    public int[] ITEMS;
    public int[] ITEMS_HEIGHT;
    public int[] ITEMS_DISAPPEARING_STEPS;
    int bbFireCounter = 0;
    boolean isBg;
    boolean isMoon;
    boolean isCloudsA;
    boolean isMountains1;
    boolean isMountains2;
    boolean isCloudsB;
    boolean isObjects;
    boolean isCloudsC;
    boolean isCloudsD;
    boolean isHills;
    boolean isEffect;
    boolean isCoins;
    boolean isEnergy;
    boolean isSushi;
    boolean isClock;
    boolean isLastHillStart;
    boolean isLastHillTop;
    boolean isLastHillEnd;
    boolean isIslandEnd;
    boolean isLevelEnd;
    boolean isGeneratedEnd;
    boolean isEnd;
    boolean isTimeUp;
    boolean isPullingDownLeft;
    boolean isPullingDownRight;
    boolean isAddingCoins;
    boolean isGate;
    boolean isControllable;
    boolean isSliding;
    boolean isLoadingNewLevel;
    boolean isLastCurve;
    boolean isInfinite;
    boolean isLoadingFlag;
    boolean isPlaying;
    boolean isPressedAction;
    boolean isFlying;
    boolean isLanding;
    boolean isAccelerating;
    boolean isSlowingDown;
    boolean isGameOver;
    boolean isWaiting;
    boolean isRemovedPart;
    boolean isRemoved1;
    boolean isRemoved2;
    boolean isRemoved3;
    boolean isDragonBall;
    boolean isTutorial;
    boolean isTutorialStopped;
    boolean isTutorialPushed;
    boolean isNewLevelIndicator;
    boolean isNewLevelLoading;
    boolean isPause;
    boolean isEnergyAccelerating;
    boolean isSparkling;
    boolean isStartSparkling;
    boolean isSparkler;
    boolean isBigSparkler;
    boolean isTimeAdd;
    boolean isAchievement;
    boolean isGameCompleted;
    boolean isCountdown;
    boolean isGeneratingLastHill;
    boolean isPauseAchievement;
    boolean isBackToLevel1;
    boolean isRepeated;
    boolean isLevel1Indicator;
    boolean isGeneratingClocks;
    boolean isAddingClocks;
    boolean isAddedClocks;
    boolean isGoodSlides;
    boolean isFalling;
    Image imgLista;
    Image imgPause;
    Image imgCollector;
    Image imgAchievement;
    Image imgGate1;
    Image imgGate2;
    Image imgMountains2;
    Image imgHead;
    Image imgSushi;
    Image imgGoldOff;
    Image imgEnergyOff;
    Image imgOff;
    Image imgGold;
    Image imgEnergy;
    Image imgClock;
    Image imgDragonBall;
    Image imgHead1;
    Image imgSushi1;
    Image imgGoldOff1;
    Image imgEnergyOff1;
    Image imgOff1;
    Image imgCollector1;
    Image imgHead2;
    Image imgSushi2;
    Image imgGoldOff2;
    Image imgEnergyOff2;
    Image imgOff2;
    Image imgCollector2;
    Image imgHead3;
    Image imgSushi3;
    Image imgGoldOff3;
    Image imgEnergyOff3;
    Image imgOff3;
    Image imgCollector3;
    Sprite sprSnura;
    Sprite sprTutorial;
    Sprite sprTabulka;
    Sprite sprCoinScore;
    Sprite sprFire;
    Sprite sprIconGold;
    Sprite sprGold;
    Sprite sprEnergy;
    Sprite sprClock;
    Sprite sprDragonBall;
    Sprite sprGold1;
    Sprite sprEnergy1;
    Sprite sprClock1;
    Sprite sprDragonBall1;
    Sprite sprGold2;
    Sprite sprEnergy2;
    Sprite sprClock2;
    Sprite sprDragonBall2;
    Sprite sprGold3;
    Sprite sprEnergy3;
    Sprite sprClock3;
    Sprite sprDragonBall3;

    public ScreenGame(MainCanvas mainCanvas, boolean isLoadAll) {
        this.mainCanvas = mainCanvas;
        this.isLoadAll = isLoadAll;
    }

    public void loadAll() {
        Resources.loadGFont(this.coords.gfontMain);
        Resources.loadGFont(this.coords.gfontMain2);
        Resources.loadGFont(this.coords.gfontGame);
        this.loadAllImages();
        this.loadAllSprites();
    }

    public void loadAllImages() {
        Resources.loadImages(new int[]{17, 15, 16, 56, 11, 12, 13, 14, 18, 19, 20, 63, 21, 22, 23});
        this.imgLista = Resources.resImgs[17];
        this.imgPause = Resources.resImgs[15];
        this.imgAchievement = Resources.resImgs[16];
    }

    public void loadImages() {
        this.imgGate1 = Resources.resImgs[21];
        this.imgGate2 = Resources.resImgs[22];
        this.imgMountains2 = Resources.resImgs[23];
    }

    public void freeAll() {
        this.freeAllImages();
        this.freeAllSprites();
    }

    public void freeAllImages() {
        Resources.freeImages(new int[]{17, 15, 16, 56, 11, 12, 13, 14, 18, 19, 20, 63, 21, 22, 23});
    }

    public void freeAllSprites() {
        Resources.freeSprites(new int[]{5, 4, 6, 7, 3, 1, 20});
    }

    public void loadAllSprites() {
        Resources.loadSprites(new int[]{5, 4, 6, 7, 3, 1, 20});
        this.sprIconGold = Resources.resSprs[5];
        this.sprFire = Resources.resSprs[3];
        if (!this.isComplete) {
            this.sprCoinScore = Resources.resSprs[5];
        }
        this.sprTabulka = Resources.resSprs[1];
        this.sprSnura = Resources.resSprs[20];
    }

    public void initArrays() {
        if (MainCanvas.isRotated) {
            this.maxCoords = (MainCanvas.HEIGHT << 2) + (MainCanvas.HEIGHT << 1);
            this.ITEMS_DISAPPEARING_STEPS = new int[MainCanvas.HEIGHT];
        }
        this.COORDS = new int[this.maxCoords];
        this.ITEMS = new int[this.maxCoords];
        this.ITEMS_HEIGHT = new int[this.maxCoords];
    }

    public void beforeShow() {
        this.isLoadingFlag = true;
        this.initArrays();
        this.checkLowMem();
        this.checkLowFrameRate();
        this.coords = new Coords();
        this.gd = new GameDefines();
        this.dd = new DragonDefines();
        this.ed = new EnvironmentsDefines();
        this.ad = new AchievementsDefines();
        this.countParameters();
        this.loadAll();
        this.loadSavedAchievements();
        this.prepareImages();
        this.prepareSprites();
        this.loadSavedAchievements();
        this.loadSavedGame();
        Particles.resetParticles();
        this.playSounds();
        this.isLoadingFlag = false;
    }

    public void countParameters() {
        if (MainCanvas.isRotated) {
            this.gd.mainMaxAcc = 60 * MainCanvas.WIDTH / 240;
            this.gd.mainLevelLength = 13750 * MainCanvas.WIDTH / 240;
            this.gd.mainSpeedForTakeoff = 20 * MainCanvas.WIDTH / 240;
            this.gd.mainMaxZoom1 = 30 * MainCanvas.WIDTH / 240;
            this.gd.mainMaxZoom2 = 90 * MainCanvas.WIDTH / 240;
            this.gd.mainSpeed = 2 * MainCanvas.WIDTH / 240;
            this.gd.mainMaxJumpSpeed = 120 * MainCanvas.WIDTH / 240;
            this.gd.mainJumpSpeedStep = (int)((double)(3 * MainCanvas.WIDTH / 240) + 0.5);
            this.gd.mainJumpSpeedStepSlow = (int)((double)(1 * MainCanvas.WIDTH / 240) + 0.5);
            this.gd.mainJumpSpeedStepPressed = (int)((double)(20 * MainCanvas.WIDTH / 240) + 0.5);
            this.gd.mainLevelLengthReserve = 1000 * MainCanvas.WIDTH / 240;
        }
        if (this.gd.mainMaxAcc < 1) {
            this.gd.mainMaxAcc = 1;
        }
        if (this.gd.mainLevelLength < 1) {
            this.gd.mainLevelLength = 1;
        }
        if (this.gd.mainSpeedForTakeoff < 1) {
            this.gd.mainSpeedForTakeoff = 1;
        }
        if (this.gd.mainMaxZoom1 < 1) {
            this.gd.mainMaxZoom1 = 1;
        }
        if (this.gd.mainMaxZoom2 < 1) {
            this.gd.mainMaxZoom1 = 1;
        }
        if (this.gd.mainSpeed < 1) {
            this.gd.mainSpeed = 1;
        }
        if (this.gd.mainMaxJumpSpeed < 1) {
            this.gd.mainMaxJumpSpeed = 1;
        }
        if (this.gd.mainJumpSpeedStep < 2) {
            this.gd.mainJumpSpeedStep = 2;
        }
        if (this.gd.mainJumpSpeedStepSlow < 1) {
            this.gd.mainJumpSpeedStepSlow = 1;
        }
        if (this.gd.mainJumpSpeedStepPressed < 1) {
            this.gd.mainJumpSpeedStepPressed = 1;
        }
        if (this.gd.mainLevelLengthReserve < 1) {
            this.gd.mainLevelLengthReserve = 1;
        }
    }

    public void prepareImages() {
        int scale2 = 950;
        int scale3 = 900;
        this.imgSushi1 = Resources.resImgs[14];
        this.imgGoldOff1 = Resources.resImgs[11];
        this.imgEnergyOff1 = Resources.resImgs[12];
        this.imgOff1 = Resources.resImgs[13];
        this.imgCollector1 = Resources.resImgs[56];
        this.imgSushi2 = ImageScaler.resizeImage(this.imgSushi1, scale2);
        this.imgGoldOff2 = ImageScaler.resizeImage(this.imgGoldOff1, scale2);
        this.imgEnergyOff2 = ImageScaler.resizeImage(this.imgEnergyOff1, scale2);
        this.imgOff2 = ImageScaler.resizeImage(this.imgOff1, scale2);
        this.imgCollector2 = ImageScaler.resizeImage(this.imgCollector1, scale2);
        this.imgSushi3 = ImageScaler.resizeImage(this.imgSushi1, scale3);
        this.imgGoldOff3 = ImageScaler.resizeImage(this.imgGoldOff1, scale3);
        this.imgEnergyOff3 = ImageScaler.resizeImage(this.imgEnergyOff1, scale3);
        this.imgOff3 = ImageScaler.resizeImage(this.imgOff1, scale3);
        this.imgCollector3 = ImageScaler.resizeImage(this.imgCollector1, scale3);
        this.imgSushi = this.imgSushi1;
        this.imgGoldOff = this.imgGoldOff1;
        this.imgEnergyOff = this.imgEnergyOff1;
        this.imgOff = this.imgOff1;
        this.imgCollector = this.imgCollector1;
        this.setHeadColor();
        this.imgHead = this.imgHead1;
    }

    public void setHeadColor() {
        int scale2 = 950;
        int scale3 = 900;
        if (!this.isComplete) {
            this.imgHead1 = Resources.resImgs[DragonDefines.DRAGON_HEADS[0]];
        }
        this.imgHead2 = ImageScaler.resizeImage(this.imgHead1, scale2);
        this.imgHead3 = ImageScaler.resizeImage(this.imgHead1, scale3);
    }

    public void prepareSprites() {
        int scale2 = 950;
        int scale3 = 900;
        this.imgGold = Resources.resImgs[18];
        this.imgEnergy = Resources.resImgs[19];
        this.imgClock = Resources.resImgs[20];
        int regionWidth1 = this.imgGold.getWidth() / 8;
        int regionWidth2 = regionWidth1 * scale2 / 1000;
        int regionWidth3 = regionWidth1 * scale3 / 1000;
        int regionHeight1 = this.imgGold.getHeight();
        int regionHeight2 = regionHeight1 * scale2 / 1000;
        int regionHeight3 = regionHeight1 * scale3 / 1000;
        this.sprGold1 = new Sprite(this.imgGold, regionWidth1, regionHeight1);
        Image img = ImageScaler.resizeImage(this.imgGold, scale2);
        while (img.getWidth() != regionWidth2 * 8) {
            if (img.getWidth() > regionWidth2 * 8) {
                img = ImageScaler.resizeImage(img, 999, 1000, 0);
            }
            if (img.getWidth() >= regionWidth2 * 8) continue;
            img = ImageScaler.resizeImage(img, 1001, 1000, 0);
        }
        this.sprGold2 = new Sprite(img, regionWidth2, regionHeight2);
        img = ImageScaler.resizeImage(this.imgGold, scale3);
        while (img.getWidth() != regionWidth3 * 8) {
            if (img.getWidth() > regionWidth3 * 8) {
                img = ImageScaler.resizeImage(img, 999, 1000, 0);
            }
            if (img.getWidth() >= regionWidth3 * 8) continue;
            img = ImageScaler.resizeImage(img, 1001, 1000, 0);
        }
        this.sprGold3 = new Sprite(img, regionWidth3, regionHeight3);
        regionWidth1 = this.imgEnergy.getWidth() / 8;
        regionWidth2 = regionWidth1 * scale2 / 1000;
        regionWidth3 = regionWidth1 * scale3 / 1000;
        regionHeight1 = this.imgEnergy.getHeight();
        regionHeight2 = regionHeight1 * scale2 / 1000;
        regionHeight3 = regionHeight1 * scale3 / 1000;
        this.sprEnergy1 = new Sprite(this.imgEnergy, regionWidth1, regionHeight1);
        img = ImageScaler.resizeImage(this.imgEnergy, scale2);
        while (img.getWidth() != regionWidth2 * 8) {
            if (img.getWidth() > regionWidth2 * 8) {
                img = ImageScaler.resizeImage(img, 999, 1000, 0);
            }
            if (img.getWidth() >= regionWidth2 * 8) continue;
            img = ImageScaler.resizeImage(img, 1001, 1000, 0);
        }
        this.sprEnergy2 = new Sprite(img, regionWidth2, regionHeight2);
        img = ImageScaler.resizeImage(this.imgEnergy, scale3);
        while (img.getWidth() != regionWidth3 * 8) {
            if (img.getWidth() > regionWidth3 * 8) {
                img = ImageScaler.resizeImage(img, 999, 1000, 0);
            }
            if (img.getWidth() >= regionWidth3 * 8) continue;
            img = ImageScaler.resizeImage(img, 1001, 1000, 0);
        }
        this.sprEnergy3 = new Sprite(img, regionWidth3, regionHeight3);
        regionWidth1 = this.imgClock.getWidth() / 5;
        regionWidth2 = regionWidth1 * scale2 / 1000;
        regionWidth3 = regionWidth1 * scale3 / 1000;
        regionHeight1 = this.imgClock.getHeight();
        regionHeight2 = regionHeight1 * scale2 / 1000;
        regionHeight3 = regionHeight1 * scale3 / 1000;
        this.sprClock1 = new Sprite(this.imgClock, regionWidth1, regionHeight1);
        img = ImageScaler.resizeImage(this.imgClock, scale2);
        while (img.getWidth() != regionWidth2 * 5) {
            if (img.getWidth() > regionWidth2 * 5) {
                img = ImageScaler.resizeImage(img, 999, 1000, 0);
            }
            if (img.getWidth() >= regionWidth2 * 5) continue;
            img = ImageScaler.resizeImage(img, 1001, 1000, 0);
        }
        this.sprClock2 = new Sprite(img, regionWidth2, regionHeight2);
        img = ImageScaler.resizeImage(this.imgClock, scale3);
        while (img.getWidth() != regionWidth3 * 5) {
            if (img.getWidth() > regionWidth3 * 5) {
                img = ImageScaler.resizeImage(img, 999, 1000, 0);
            }
            if (img.getWidth() >= regionWidth3 * 5) continue;
            img = ImageScaler.resizeImage(img, 1001, 1000, 0);
        }
        this.sprClock3 = new Sprite(img, regionWidth3, regionHeight3);
        this.setDragonBallColor();
    }

    public void setDragonBallColor() {
        int scale2 = 950;
        int scale3 = 900;
        if (!this.isComplete) {
            this.imgDragonBall = Resources.resImgs[DragonDefines.DRAGON_BALLS[0]];
        }
        int regionWidth1 = this.imgDragonBall.getWidth() / 4;
        int regionWidth2 = regionWidth1 * scale2 / 1000;
        int regionWidth3 = regionWidth1 * scale3 / 1000;
        int regionHeight1 = this.imgDragonBall.getHeight();
        int regionHeight2 = regionHeight1 * scale2 / 1000;
        int regionHeight3 = regionHeight1 * scale3 / 1000;
        this.sprDragonBall1 = new Sprite(this.imgDragonBall, regionWidth1, regionHeight1);
        Image img = ImageScaler.resizeImage(this.imgDragonBall, scale2);
        while (img.getWidth() != regionWidth2 * 4) {
            if (img.getWidth() > regionWidth2 * 4) {
                img = ImageScaler.resizeImage(img, 999, 1000, 0);
            }
            if (img.getWidth() >= regionWidth2 * 4) continue;
            img = ImageScaler.resizeImage(img, 1001, 1000, 0);
        }
        this.sprDragonBall2 = new Sprite(img, regionWidth2, regionHeight2);
        img = ImageScaler.resizeImage(this.imgDragonBall, scale3);
        while (img.getWidth() != regionWidth3 * 4) {
            if (img.getWidth() > regionWidth3 * 4) {
                img = ImageScaler.resizeImage(img, 999, 1000, 0);
            }
            if (img.getWidth() >= regionWidth3 * 4) continue;
            img = ImageScaler.resizeImage(img, 1001, 1000, 0);
        }
        this.sprDragonBall3 = new Sprite(img, regionWidth3, regionHeight3);
    }

    public void playSounds() {
        block7: {
            block9: {
                block8: {
                    if (!MainCanvas.soundManager.IsSoundOn()) break block7;
                    if (this.gd.level == 0 || this.gd.level == 5 || this.gd.level == 10) {
                        MainCanvas.soundManager.Stop();
                    }
                    if (this.gd.level < 0 || this.gd.level >= 5) break block8;
                    while (!MainCanvas.soundManager.Play(Sounds.SOUND_GAME1, -1)) {
                        for (int counterPlaySounds = 0; counterPlaySounds < 10; ++counterPlaySounds) {
                        }
                    }
                    break block7;
                }
                if (this.gd.level < 5 || this.gd.level >= 10) break block9;
                while (!MainCanvas.soundManager.Play(Sounds.SOUND_GAME2, -1)) {
                    for (int counterPlaySounds = 0; counterPlaySounds < 10; ++counterPlaySounds) {
                    }
                }
                break block7;
            }
            if (this.gd.level < 10 || this.gd.level >= 15) break block7;
            while (!MainCanvas.soundManager.Play(Sounds.SOUND_GAME3, -1)) {
                for (int counterPlaySounds = 0; counterPlaySounds < 10; ++counterPlaySounds) {
                }
            }
        }
    }

    public void loadSavedGame() {
        RMSObjects.createRMSConnect(3);
        if (RMSObjects.rmsConnects[3].load()) {
            this.loadGame();
            this.initFrames();
            this.isPause = false;
            this.isSparkler = true;
            this.loadImages();
            this.initThings();
            this.initEnv(0);
            this.initSparkler();
            this.setItems();
            this.calculate();
            this.calculateDragon();
            this.initTexts(0);
            if (!this.isInfinite) {
                if (this.isPauseAchievement) {
                    this.initAchievement();
                }
                if (this.isGameOver) {
                    this.initText(1);
                } else if (this.isNewLevelIndicator) {
                    this.initText(0);
                } else if (this.isLevel1Indicator) {
                    this.initText(2);
                }
            } else {
                this.isFalling = true;
                this.isEnd = false;
                if (this.gd.levelCounter == 15) {
                    this.initNewLevelIndicator();
                } else {
                    if (this.isPauseAchievement) {
                        this.initAchievement();
                    }
                    if (this.isGameOver) {
                        this.initText(1);
                    } else if (this.isNewLevelIndicator) {
                        this.initText(0);
                    } else if (this.isLevel1Indicator) {
                        this.initText(2);
                    }
                }
            }
            this.isCountdown = false;
            this.isPlaying = false;
            this.initTextCountdown();
        } else {
            this.initDragonBody();
            this.initParams();
            this.initStartingLevel();
            this.initFrames();
            this.initTimeAndLevelLength();
            this.loadImages();
            this.shiftDragon();
            this.initThings();
            this.initEnv(0);
            this.initTerrain();
            this.initSparkler();
            this.stopEffect();
            this.setItems();
            this.dd.headHeight = this.COORDS[this.dd.headShift + this.dd.halfHeadWidth] + this.dd.dragonHeadShift;
            this.setHeights();
            this.calculate();
            this.calculateDragon();
            this.initTexts(1);
        }
        RMSObjects.freeRMSConnect(3);
    }

    public void changeEnvironment() {
        if (!this.isComplete) {
            this.gd.environment = 0;
        }
    }

    public void initTexts(int i) {
        if (i == 0) {
            if (this.isNewLevelIndicator) {
                this.initNewLevelIndicator();
            }
        } else if (i == 1) {
            this.initNewLevelIndicator();
        }
        this.initTextCoins();
        this.initTextSlides();
    }

    public void loadSavedAchievements() {
        RMSObjects.createRMSConnect(2);
        if (RMSObjects.rmsConnects[2].load()) {
            RMSObjects.freeRMSConnect(2);
            this.loadAchievements();
        } else {
            RMSObjects.rmsConnects[2].create();
            RMSObjects.freeRMSConnect(2);
            this.initAchievementParams();
        }
    }

    public void initAchievementParams() {
        this.ad.achievement1 = 0;
        this.ad.achievement2 = 0;
        this.ad.achievement3 = 0;
        this.ad.aSushi = 0;
        this.ad.aGoodSlides = 0;
        this.ad.aCoins = 0;
        this.ad.aEnergy = 0;
        this.ad.aClocks = 0;
        this.ad.aDragonBalls = 0;
        this.ad.aSegments = 0;
        this.ad.aImpacts = 0;
        this.ad.aInputTime = 0;
        this.ad.aDistance = 0;
    }

    public void initFrames() {
        this.gd.frameGold = 0;
        this.gd.frameDragonBall = 0;
        if (!this.isComplete) {
            this.gd.frameEnergy = 0;
            this.gd.frameClock = 2;
            this.gd.frameFire = 2;
        }
    }

    public void initText(int i) {
        int fontHeight = Resources.resGFonts[this.coords.gfontGame].getHeight() >> 1;
        int textMarginLeft = 0;
        int textMarginTop = 0;
        int textWidth = MainCanvas.WIDTH;
        int textHeight = MainCanvas.HEIGHT;
        this.rectText = new Rectangle(textMarginLeft, textMarginTop, textWidth, textHeight);
        if (MainCanvas.isRotated) {
            this.rectText1 = new Rectangle(textMarginLeft + (fontHeight + (fontHeight << 1)), textMarginTop, textWidth, textHeight);
            this.rectText2 = new Rectangle(textMarginLeft + fontHeight, textMarginTop, textWidth, textHeight);
            this.rectText3 = new Rectangle(textMarginLeft - fontHeight, textMarginTop, textWidth, textHeight);
            this.rectText4 = new Rectangle(textMarginLeft - (fontHeight + (fontHeight << 1)), textMarginTop, textWidth, textHeight);
        }
        if (i == 0 || i == 1) {
            Resources.loadGFont(this.coords.gfontGame);
            preparedText = new PreparedText(Resources.resGFonts[this.coords.gfontGame]);
        } else if (i == 2) {
            Resources.loadGFont(this.coords.gfontGame);
            preparedText1 = new PreparedText(Resources.resGFonts[this.coords.gfontGame]);
            preparedText2 = new PreparedText(Resources.resGFonts[this.coords.gfontGame]);
            preparedText3 = new PreparedText(Resources.resGFonts[this.coords.gfontGame]);
            preparedText4 = new PreparedText(Resources.resGFonts[this.coords.gfontGame]);
        }
        if (i == 0) {
            preparedText.prepareText(Resources.resTexts[0].getHashedString(46).toUpperCase() + " " + (this.gd.levelCounter + 1), this.rectText.width);
        } else if (i == 1) {
            preparedText.prepareText(Resources.resTexts[0].getHashedString(47).toUpperCase(), this.rectText.width);
        } else if (i == 2) {
            preparedText1.prepareText(Resources.resTexts[0].getHashedString(42).toUpperCase(), this.rectText1.width);
            preparedText2.prepareText(Resources.resTexts[0].getHashedString(43).toUpperCase(), this.rectText2.width);
            preparedText3.prepareText(Resources.resTexts[0].getHashedString(44).toUpperCase(), this.rectText3.width);
            preparedText4.prepareText(Resources.resTexts[0].getHashedString(45).toUpperCase(), this.rectText4.width);
        }
    }

    public void initTextCountdown() {
        int posunY;
        int posunX;
        this.gd.countdownTimer = 3;
        if (!this.isDragonBall) {
            posunX = this.imgHead.getWidth() << 1;
            posunY = this.imgHead.getHeight() >> 2;
        } else {
            posunX = this.sprDragonBall.getWidth() << 1;
            posunY = this.sprDragonBall.getHeight() >> 2;
        }
        if (MainCanvas.isRotated) {
            int textMarginLeft = MainCanvas.WIDTH - (this.dd.headHeight - posunY + (this.sprTabulka.getWidth() >> 2) + (this.sprTabulka.getWidth() >> 2));
            int textMarginTop = this.dd.headShift + posunX - (this.sprTabulka.getHeight() >> 2) - (this.sprTabulka.getHeight() >> 3);
            int textWidth = this.sprTabulka.getWidth();
            int textHeight = this.sprTabulka.getHeight();
            this.rectTextCountdown = new Rectangle(textMarginLeft, textMarginTop, textWidth, textHeight);
        }
        Resources.loadGFont(this.coords.gfontGame);
        preparedTextCountdown = new PreparedText(Resources.resGFonts[this.coords.gfontGame]);
        preparedTextCountdown.prepareText(this.gd.countdownTimer + "", this.rectTextCountdown.width);
        this.isCountdown = true;
    }

    public void setTextCountdown() {
        if (this.gd.countdownTimer > 0) {
            if (this.gd.updateCounter % 20 == 0) {
                --this.gd.countdownTimer;
                preparedTextCountdown.prepareText(this.gd.countdownTimer + "", this.rectTextCountdown.width);
            }
        } else {
            this.isCountdown = false;
            this.actionPlay();
        }
    }

    public void initDragonBody() {
        for (int i = 0; i < 5; ++i) {
            this.dd.BODY_SHIFT[i] = -9999;
            this.dd.BODY_SHIFT2[i] = -9999;
            this.dd.BODY_HEIGHT[i] = -9999;
        }
    }

    public void checkLowMem() {
        this.isComplete = false;
    }

    public void checkLowFrameRate() {
        this.isLowFrameRate = true;
    }

    public void afterHide() {
    }

    public void beforeInteruption() {
        if (MainCanvas.soundManager.IsSoundOn()) {
            MainCanvas.soundManager.Stop();
        }
        if (!this.isGameOver) {
            this.actionPause();
        } else {
            this.gameOver();
        }
    }

    public void afterInteruption() {
        this.loadAchievements();
        this.loadGame();
        this.playSounds();
    }

    public void keyPressed(int keyCode) {
        if (!MainCanvas.touchActivated && MainCanvas.isRotated && Keys.isKeyPressed(-6) && !this.isTimeUp && !this.isGameOver) {
            this.achievement(2, 0);
            this.actionPause();
        }
    }

    public void gameOver() {
        this.saveAchievements(0);
        this.deleteSavedGame();
        this.freeAll();
        this.mainCanvas.changeLastActiveScreen(new ScreenSummary(this.mainCanvas, this.gd.coins, this.gd.distance, this.gd.levelCounter, true, false));
        this.mainCanvas.repaint();
        this.mainCanvas.serviceRepaints();
    }

    public void keyReleased(int keyCode) {
        if (!MainCanvas.touchActivated) {
            this.isPressedAction = false;
        }
    }

    public void actionPause() {
        this.isPause = true;
        this.isPlaying = false;
        this.isPressedAction = false;
        this.saveAchievements(0);
        this.saveGame();
        this.freeAll();
        this.mainCanvas.changeLastActiveScreen(new ScreenPause(this.mainCanvas, 0, true));
        this.mainCanvas.repaint();
        this.mainCanvas.serviceRepaints();
    }

    public void actionFire() {
        if (this.isControllable && !this.isFalling) {
            this.isPressedAction = true;
        }
        if (!this.isPlaying && !this.isPause) {
            this.isPlaying = true;
        } else {
            this.isPause = false;
            this.isPlaying = true;
        }
        this.isSparkling = true;
    }

    public void actionPlay() {
        if (!this.isPlaying && !this.isPause) {
            this.isPlaying = true;
        } else {
            this.isPause = false;
            this.isPlaying = true;
        }
        this.isSparkling = true;
    }

    public void update(long lastRunLenght) {
        if (this.bbFireCounter > 0) {
            --this.bbFireCounter;
            this.actionFire();
        }
        if (!MainCanvas.touchActivated && Keys.isActionPressed(5)) {
            if (!(this.isLoadingFlag || this.isStartSparkling || this.isCountdown)) {
                this.actionFire();
            }
            if (this.isLevel1Indicator) {
                this.isLevel1Indicator = false;
                this.gd.level1Timer = 0;
                this.gd.glidingTimer = 0;
            }
        }
        ++this.gd.updateCounter;
        this.set0();
        if (!this.isPause) {
            if (this.isPlaying && !this.isGameOver) {
                this.set1();
            }
            Particles.update();
        }
        this.set2();
        if (this.isLowFrameRate) {
            this.mainCanvas.repaint();
        } else if (this.gd.updateCounter % 2 == 0) {
            this.mainCanvas.repaint();
        }
    }

    public void initParams() {
        this.isInfinite = false;
        this.isTutorialPushed = true;
        this.isTutorialStopped = false;
        this.isPlaying = false;
        this.isPressedAction = false;
        this.isFlying = false;
        this.isAccelerating = false;
        this.isSlowingDown = false;
        this.isPause = false;
        this.isDragonBall = false;
        this.isGameOver = false;
        this.isGeneratedEnd = false;
        this.isEnd = false;
        this.isAddingCoins = false;
        this.isGate = false;
        this.isControllable = true;
        this.isPullingDownLeft = false;
        this.isPullingDownRight = false;
        this.isSliding = false;
        this.isLoadingNewLevel = false;
        this.isWaiting = false;
        this.isLanding = false;
        this.isEffect = false;
        this.isRemovedPart = false;
        this.isEnergyAccelerating = false;
        this.isSparkling = false;
        this.isStartSparkling = false;
        this.isSparkler = true;
        this.isBigSparkler = false;
        this.isTimeAdd = false;
        this.isAchievement = false;
        this.isLastHillStart = false;
        this.isLastHillTop = false;
        this.isLastHillEnd = false;
        this.isIslandEnd = false;
        this.isGameCompleted = false;
        this.isCountdown = false;
        this.isGeneratingLastHill = false;
        this.isPauseAchievement = false;
        this.isBackToLevel1 = false;
        this.isRepeated = false;
        this.isLevel1Indicator = false;
        this.isGeneratingClocks = true;
        this.isAddingClocks = false;
        this.isAddedClocks = false;
        this.isGoodSlides = false;
        this.isFalling = false;
        int n = this.gd.hillsPartWidth = this.isComplete ? 1 : 3;
        if (MainCanvas.isRotated) {
            this.gd.floor = MainCanvas.WIDTH - MainCanvas.WIDTH / 24;
            this.gd.ceiling = MainCanvas.WIDTH / 3;
            this.gd.radius = MainCanvas.WIDTH / 18;
            this.gd.size0 = MainCanvas.WIDTH / 6;
            this.gd.size1 = MainCanvas.WIDTH / 5;
            this.gd.size2 = MainCanvas.WIDTH / 4;
            this.gd.size3 = MainCanvas.WIDTH / 3;
            this.gd.size4 = MainCanvas.WIDTH / 2;
            this.gd.size5 = MainCanvas.WIDTH / 3 << 1;
        }
        this.dd.bodyParts = 3;
        this.dd.dragonHeadShift = !this.isDragonBall ? -(this.gd.radius << 1) + (this.gd.radius >> 3) : 0;
        this.dd.dragonBodyShift = -(this.gd.radius << 1) + (this.gd.radius >> 3);
        this.gd.ceilingDragon = 20;
        this.gd.hillsShift = 0;
        this.gd.acceleration = 0;
        this.gd.move = 0;
        this.gd.movePom = 0;
        this.gd.jumpSpeed = 0;
        this.gd.jumpHeight = 0;
        this.gd.originalAcceleration = 0;
        this.gd.direction = 1;
        this.gd.updateCounter = 0;
        this.gd.zoom = 0;
        this.gd.zoomCounter = 0;
        this.gd.type = 1;
        this.resetDragonBall();
        this.gd.gateX = 0;
        this.gd.gateY = 0;
        this.gd.fallingStep = this.isPressedAction ? this.gd.radius << 1 : this.gd.radius >> 1;
        this.gd.goodSlidingStarter = 0;
        this.gd.shift = 0;
        this.gd.gameOverTimer = 0;
        this.gd.timeAdd = 0;
        this.gd.maxTime = 0;
        this.gd.postupnost = 0;
        this.gd.maxZoom = this.gd.mainMaxZoom1;
        this.changeEnvironment();
        this.gd.coins = 0;
        this.gd.distance = 0;
        this.goodSlidesNull();
        this.badImpactsNull();
        this.gd.generatingLastHill = 0;
        this.gd.timerWidth = 0;
        this.gd.level1Timer = 0;
        this.gd.clocksCount = 0;
        this.gd.levelLengthPom = 0;
    }

    public void initStartingLevel() {
        this.gd.levelCounter = this.gd.level = 0;
        this.changeEnvironment();
    }

    public void set0() {
        if (this.isStartSparkling) {
            this.setStartSparkler();
        }
        if (!this.isControllable) {
            this.isPressedAction = false;
        }
    }

    public void calculate() {
        this.calculate1();
        this.calculate2();
        this.calculate3();
        this.calculate4();
        this.calculate5();
        this.calculate6();
        this.calculate7();
        this.calculate8();
    }

    public void calculate1() {
        if (!this.isEnd) {
            if (this.dd.headHeight > this.COORDS[this.dd.headShift + this.dd.halfHeadWidth] + this.dd.dragonHeadShift && this.isWaiting) {
                this.isWaiting = false;
            }
            if (this.isFlying || this.COORDS[this.dd.headShift + this.dd.halfHeadWidth] + this.dd.dragonHeadShift <= this.dd.headHeight && this.COORDS[this.dd.BODY_SHIFT[0]] + this.dd.dragonBodyShift <= this.dd.BODY_HEIGHT[0]) {
                this.isLanding = false;
            }
            if (this.dd.headHeight > this.COORDS[this.dd.headShift + this.dd.halfHeadWidth] + this.dd.dragonHeadShift) {
                this.dd.headHeight = this.COORDS[this.dd.headShift + this.dd.halfHeadWidth] + this.dd.dragonHeadShift;
            }
        }
    }

    public void calculate2() {
        if (this.isAccelerating) {
            this.accelerate();
        }
        if (this.isSlowingDown) {
            this.slowdown();
        }
        if (this.gd.acceleration > this.gd.mainMaxAcc) {
            this.gd.acceleration = this.gd.mainMaxAcc;
        }
    }

    public void calculate3() {
        if (this.isPullingDownLeft) {
            this.pullingDownLeft();
        }
        if (this.isPullingDownRight) {
            this.pullingDownRight();
        }
        if (this.isSliding) {
            this.sliding();
        }
        if (this.isRemovedPart) {
            this.setRemovedPart();
        }
    }

    public void calculate4() {
        if (this.isEnergyAccelerating) {
            this.setEnergyAcceleration();
        }
        if (this.isTimeAdd) {
            this.setTimeAdd();
        }
        if (this.isSparkling) {
            this.setSparkler();
        }
        if (!(this.isEnd || this.isWaiting || this.isGameCompleted || this.isGameOver || this.isBackToLevel1)) {
            this.setTimeAndLevelLength();
        }
        if (this.isGeneratingClocks) {
            if (this.gd.clocksCount >= 2) {
                this.isGeneratingClocks = false;
            }
            if (this.dd.dragonLevel >= 4 && this.gd.level >= 10 && this.gd.time <= 15 && this.gd.levelLength > this.gd.levelLengthPom >> 1 && !this.isAddingClocks && !this.isAddedClocks) {
                this.isAddingClocks = true;
            }
        }
    }

    public void calculate5() {
        for (int i = 0; i < MainCanvas.WIDTH; ++i) {
            if (this.ITEMS_DISAPPEARING_STEPS[i] > 0) {
                int n = i;
                this.ITEMS_DISAPPEARING_STEPS[n] = this.ITEMS_DISAPPEARING_STEPS[n] - 1;
                if (this.ITEMS[i] != 6) continue;
                int n2 = i;
                this.ITEMS_HEIGHT[n2] = this.ITEMS_HEIGHT[n2] - 10;
                continue;
            }
            if (this.ITEMS_DISAPPEARING_STEPS[i] != 0 || this.ITEMS[i] != 6 && this.ITEMS[i] != 9 && this.ITEMS[i] != 7 && this.ITEMS[i] != 8) continue;
            this.ITEMS[i] = -9999;
        }
    }

    public void calculate8() {
        if (this.isGeneratingLastHill) {
            this.specialItemsCollisionDetection();
        }
        if (this.isGeneratedEnd) {
            this.setGate();
        }
        if (this.gd.zoom <= 5) {
            this.itemsCollisionDetection();
        }
        if (this.isClock) {
            this.clocksCollisionDetection();
        }
    }

    public void calculate6() {
        if (this.isFlying && !this.isSliding) {
            this.jump();
        } else if (!this.isFlying) {
            this.control();
        }
    }

    public void calculate7() {
        this.setShifts();
        this.setCollector();
        this.setEnvironment();
        this.setHeights();
    }

    public void set1() {
        this.roll0();
        this.roll1();
        this.setItems();
        this.calculate();
        this.calculateDragon();
    }

    public void set2() {
        if (this.isAchievement) {
            this.setAchievement();
        }
        if (this.isCountdown) {
            this.setTextCountdown();
        }
        if (this.isGameOver) {
            this.setGameOver();
        }
        if (this.isNewLevelIndicator) {
            this.setNewLevelIndicator();
        }
        if (this.isLevel1Indicator) {
            this.setBackToLevel1Indicator();
        }
    }

    public void setShifts() {
        if (this.gd.zoom > 0) {
            this.gd.shift = this.gd.zoom << 2;
            this.gd.hillsShift = this.gd.zoom + (this.gd.zoom >> 1);
            this.gd.dragonShift = this.gd.maxZoom == this.gd.mainMaxZoom1 ? this.gd.zoom >> 3 : this.gd.zoom >> 5;
        } else {
            this.gd.shift = 0;
            this.gd.hillsShift = 0;
            this.gd.dragonShift = 0;
        }
    }

    public void setEnvironment() {
        if (this.gd.environment == 0) {
            if (this.isMountains2) {
                this.setMountains2();
            }
        } else if (this.gd.environment == 1 || this.gd.environment == 2) {
            // empty if block
        }
    }

    public void initThings() {
        this.isBg = true;
        this.isHills = true;
        this.isCoins = true;
        if (this.gd.environment == 0) {
            if (this.gd.level >= 0) {
                this.isMountains2 = true;
                this.isEnergy = true;
                this.isSushi = false;
            }
            if (this.gd.level >= 1) {
                // empty if block
            }
            if (this.gd.level >= 2) {
                this.isSushi = true;
            }
        }
        if (this.gd.environment == 1 || this.gd.environment == 2) {
            this.isMountains2 = false;
            this.isEnergy = true;
            this.isSushi = true;
            this.isClock = true;
        }
    }

    public void initEnv(int i) {
        if (this.gd.environment == 0) {
            this.initEnvironment0();
        } else if (this.gd.environment == 1 || this.gd.environment == 2) {
            // empty if block
        }
    }

    public void initEnvironment0() {
        if (this.isMountains2) {
            this.initMountains2();
        }
    }

    public void setItems() {
        if (this.gd.zoom < (this.gd.maxZoom >> 2) + (this.gd.maxZoom >> 3)) {
            this.imgHead = this.imgHead1;
            this.imgSushi = this.imgSushi1;
            this.imgGoldOff = this.imgGoldOff1;
            this.imgEnergyOff = this.imgEnergyOff1;
            this.imgOff = this.imgOff1;
            this.imgCollector = this.imgCollector1;
            this.sprGold = this.sprGold1;
            this.sprEnergy = this.sprEnergy1;
            this.sprClock = this.sprClock1;
            this.sprDragonBall = this.sprDragonBall1;
        } else if (this.gd.zoom < (this.gd.maxZoom >> 1) + (this.gd.maxZoom >> 2)) {
            this.imgHead = this.imgHead2;
            this.imgSushi = this.imgSushi2;
            this.imgGoldOff = this.imgGoldOff2;
            this.imgEnergyOff = this.imgEnergyOff2;
            this.imgOff = this.imgOff2;
            this.imgCollector = this.imgCollector2;
            this.sprGold = this.sprGold2;
            this.sprEnergy = this.sprEnergy2;
            this.sprClock = this.sprClock2;
            this.sprDragonBall = this.sprDragonBall2;
        } else {
            this.imgHead = this.imgHead3;
            this.imgSushi = this.imgSushi3;
            this.imgGoldOff = this.imgGoldOff3;
            this.imgEnergyOff = this.imgEnergyOff3;
            this.imgOff = this.imgOff3;
            this.imgCollector = this.imgCollector3;
            this.sprGold = this.sprGold3;
            this.sprEnergy = this.sprEnergy3;
            this.sprClock = this.sprClock3;
            this.sprDragonBall = this.sprDragonBall3;
        }
    }

    public void calculateDragon() {
        if (MainCanvas.isRotated) {
            this.dd.tail1[0] = MainCanvas.WIDTH - (this.dd.tailHeight + this.gd.radius - (this.gd.radius >> 2));
            this.dd.tail1[1] = this.dd.tailShift + (this.gd.dragonShift << 1);
            this.dd.tail1[2] = MainCanvas.WIDTH - (this.dd.BODY_HEIGHT[0] + this.gd.radius + this.gd.dragonShift - (this.gd.dragonShift >> 2));
            this.dd.tail1[3] = this.dd.tailShift2 + this.gd.dragonShift;
            this.dd.tail1[4] = MainCanvas.WIDTH - (this.dd.BODY_HEIGHT[0] + (this.gd.radius << 1) - (this.gd.radius >> 2));
            this.dd.tail1[5] = this.dd.tailShift2 + this.gd.dragonShift;
            this.dd.tail2[0] = MainCanvas.WIDTH - (this.dd.tailHeight2 + this.gd.radius + (this.gd.radius >> 1));
            this.dd.tail2[1] = this.dd.tailShift + (this.gd.radius >> 1) + (this.gd.dragonShift << 1);
            this.dd.tail2[2] = MainCanvas.WIDTH - (this.dd.BODY_HEIGHT[0] + this.gd.radius + (this.gd.radius >> 2) + (this.gd.dragonShift >> 1));
            this.dd.tail2[3] = this.dd.tailShift2 + this.gd.dragonShift;
            this.dd.tail2[4] = MainCanvas.WIDTH - (this.dd.BODY_HEIGHT[0] + (this.gd.radius << 1) - (this.gd.radius >> 2) - (this.gd.dragonShift >> 1));
            this.dd.tail2[5] = this.dd.tailShift2 + this.gd.dragonShift;
            if (this.dd.bodyParts >= 1) {
                this.dd.body5[0] = MainCanvas.WIDTH - (this.dd.BODY_HEIGHT[this.dd.bodyParts - 1] + (this.gd.radius << 1) - this.gd.dragonShift);
                this.dd.body5[1] = this.dd.BODY_SHIFT[this.dd.bodyParts - 1] + this.gd.dragonShift;
                this.dd.body5[2] = MainCanvas.WIDTH - (this.dd.BODY_HEIGHT[this.dd.bodyParts - 1] + (this.gd.radius >> 1) + (this.gd.radius >> 2) + this.gd.dragonShift);
                this.dd.body5[3] = this.dd.BODY_SHIFT[this.dd.bodyParts - 1] + this.gd.dragonShift;
                this.dd.body5[4] = MainCanvas.WIDTH - (this.dd.headHeight + this.gd.radius + (this.gd.radius >> 2));
                this.dd.body5[5] = this.dd.BODY_SHIFT2[this.dd.bodyParts - 1] + (this.gd.dragonShift >> 1);
                this.dd.line5[0] = MainCanvas.WIDTH - (this.dd.BODY_HEIGHT[this.dd.bodyParts - 1] + (this.gd.dragonShift >> 1) + this.gd.radius);
                this.dd.line5[1] = this.dd.BODY_SHIFT[this.dd.bodyParts - 1] + this.gd.dragonShift + (this.gd.radius >> 2);
                this.dd.line5[2] = MainCanvas.WIDTH - (this.dd.BODY_HEIGHT[this.dd.bodyParts - 1] + (this.gd.dragonShift >> 1) + this.gd.radius + (this.gd.radius >> 2));
                this.dd.line5[3] = this.dd.BODY_SHIFT[this.dd.bodyParts - 1] + this.gd.dragonShift + (this.gd.radius >> 2);
                this.dd.line5[4] = MainCanvas.WIDTH - (this.dd.headHeight + this.gd.radius + (this.gd.radius >> 1));
                this.dd.line5[5] = this.dd.BODY_SHIFT2[this.dd.bodyParts - 1] + (this.gd.dragonShift >> 1) - (this.gd.radius >> 2);
            }
            if (this.dd.bodyParts >= 2) {
                this.dd.body4[0] = MainCanvas.WIDTH - (this.dd.BODY_HEIGHT[this.dd.bodyParts - 2] + (this.gd.radius << 1) - this.gd.dragonShift);
                this.dd.body4[1] = this.dd.BODY_SHIFT[this.dd.bodyParts - 2] + this.gd.dragonShift;
                this.dd.body4[2] = MainCanvas.WIDTH - (this.dd.BODY_HEIGHT[this.dd.bodyParts - 2] + (this.gd.radius >> 1) + (this.gd.radius >> 2) + this.gd.dragonShift);
                this.dd.body4[3] = this.dd.BODY_SHIFT[this.dd.bodyParts - 2] + this.gd.dragonShift;
                this.dd.body4[4] = MainCanvas.WIDTH - ((this.dd.BODY_HEIGHT[this.dd.bodyParts - 2 + 1] + this.dd.headHeight >> 1) + this.gd.radius + (this.gd.radius >> 1));
                this.dd.body4[5] = this.dd.BODY_SHIFT2[this.dd.bodyParts - 2] + this.gd.dragonShift;
                this.dd.line4[0] = MainCanvas.WIDTH - (this.dd.BODY_HEIGHT[this.dd.bodyParts - 2] + (this.gd.dragonShift >> 1) + this.gd.radius);
                this.dd.line4[1] = this.dd.BODY_SHIFT[this.dd.bodyParts - 2] + this.gd.dragonShift + (this.gd.radius >> 2);
                this.dd.line4[2] = MainCanvas.WIDTH - (this.dd.BODY_HEIGHT[this.dd.bodyParts - 2] + (this.gd.dragonShift >> 1) + this.gd.radius + (this.gd.radius >> 2));
                this.dd.line4[3] = this.dd.BODY_SHIFT[this.dd.bodyParts - 2] + this.gd.dragonShift + (this.gd.radius >> 2);
                this.dd.line4[4] = MainCanvas.WIDTH - ((this.dd.BODY_HEIGHT[this.dd.bodyParts - 2 + 1] + this.dd.headHeight >> 1) + this.gd.radius + (this.gd.radius >> 1));
                this.dd.line4[5] = this.dd.BODY_SHIFT2[this.dd.bodyParts - 2] + this.gd.dragonShift - (this.gd.radius >> 2);
            }
            if (this.dd.bodyParts >= 3) {
                this.dd.body3[0] = MainCanvas.WIDTH - (this.dd.BODY_HEIGHT[this.dd.bodyParts - 3] + (this.gd.radius << 1) - this.gd.dragonShift);
                this.dd.body3[1] = this.dd.BODY_SHIFT[this.dd.bodyParts - 3] + this.gd.dragonShift;
                this.dd.body3[2] = MainCanvas.WIDTH - (this.dd.BODY_HEIGHT[this.dd.bodyParts - 3] + (this.gd.radius >> 1) + (this.gd.radius >> 2) + this.gd.dragonShift);
                this.dd.body3[3] = this.dd.BODY_SHIFT[this.dd.bodyParts - 3] + this.gd.dragonShift;
                this.dd.body3[4] = MainCanvas.WIDTH - ((this.dd.BODY_HEIGHT[this.dd.bodyParts - 3 + 1] + this.dd.BODY_HEIGHT[this.dd.bodyParts - 3 + 2] >> 1) + this.gd.radius + (this.gd.radius >> 1));
                this.dd.body3[5] = this.dd.BODY_SHIFT2[this.dd.bodyParts - 3] + this.gd.dragonShift;
                this.dd.line3[0] = MainCanvas.WIDTH - (this.dd.BODY_HEIGHT[this.dd.bodyParts - 3] + (this.gd.dragonShift >> 1) + this.gd.radius);
                this.dd.line3[1] = this.dd.BODY_SHIFT[this.dd.bodyParts - 3] + this.gd.dragonShift + (this.gd.radius >> 2);
                this.dd.line3[2] = MainCanvas.WIDTH - (this.dd.BODY_HEIGHT[this.dd.bodyParts - 3] + (this.gd.dragonShift >> 1) + this.gd.radius + (this.gd.radius >> 2));
                this.dd.line3[3] = this.dd.BODY_SHIFT[this.dd.bodyParts - 3] + this.gd.dragonShift + (this.gd.radius >> 2);
                this.dd.line3[4] = MainCanvas.WIDTH - ((this.dd.BODY_HEIGHT[this.dd.bodyParts - 3 + 1] + this.dd.BODY_HEIGHT[this.dd.bodyParts - 3 + 2] >> 1) + this.gd.radius + (this.gd.radius >> 1));
                this.dd.line3[5] = this.dd.BODY_SHIFT2[this.dd.bodyParts - 3] + this.gd.dragonShift - (this.gd.radius >> 2);
            }
            if (this.dd.bodyParts >= 4) {
                this.dd.body2[0] = MainCanvas.WIDTH - (this.dd.BODY_HEIGHT[this.dd.bodyParts - 4] + (this.gd.radius << 1) - this.gd.dragonShift);
                this.dd.body2[1] = this.dd.BODY_SHIFT[this.dd.bodyParts - 4] + this.gd.dragonShift;
                this.dd.body2[2] = MainCanvas.WIDTH - (this.dd.BODY_HEIGHT[this.dd.bodyParts - 4] + (this.gd.radius >> 1) + (this.gd.radius >> 2) + this.gd.dragonShift);
                this.dd.body2[3] = this.dd.BODY_SHIFT[this.dd.bodyParts - 4] + this.gd.dragonShift;
                this.dd.body2[4] = MainCanvas.WIDTH - ((this.dd.BODY_HEIGHT[this.dd.bodyParts - 4 + 1] + this.dd.BODY_HEIGHT[this.dd.bodyParts - 4 + 2] >> 1) + this.gd.radius + (this.gd.radius >> 1));
                this.dd.body2[5] = this.dd.BODY_SHIFT2[this.dd.bodyParts - 4] + this.gd.dragonShift;
                this.dd.line2[0] = MainCanvas.WIDTH - (this.dd.BODY_HEIGHT[this.dd.bodyParts - 4] + (this.gd.dragonShift >> 1) + this.gd.radius);
                this.dd.line2[1] = this.dd.BODY_SHIFT[this.dd.bodyParts - 4] + this.gd.dragonShift + (this.gd.radius >> 2);
                this.dd.line2[2] = MainCanvas.WIDTH - (this.dd.BODY_HEIGHT[this.dd.bodyParts - 4] + (this.gd.dragonShift >> 1) + this.gd.radius + (this.gd.radius >> 2));
                this.dd.line2[3] = this.dd.BODY_SHIFT[this.dd.bodyParts - 4] + this.gd.dragonShift + (this.gd.radius >> 2);
                this.dd.line2[4] = MainCanvas.WIDTH - ((this.dd.BODY_HEIGHT[this.dd.bodyParts - 4 + 1] + this.dd.BODY_HEIGHT[this.dd.bodyParts - 4 + 2] >> 1) + this.gd.radius + (this.gd.radius >> 1));
                this.dd.line2[5] = this.dd.BODY_SHIFT2[this.dd.bodyParts - 4] + this.gd.dragonShift - (this.gd.radius >> 2);
            }
            if (this.dd.bodyParts >= 5) {
                this.dd.body1[0] = MainCanvas.WIDTH - (this.dd.BODY_HEIGHT[this.dd.bodyParts - 5] + (this.gd.radius << 1) - this.gd.dragonShift);
                this.dd.body1[1] = this.dd.BODY_SHIFT[this.dd.bodyParts - 5] + this.gd.dragonShift;
                this.dd.body1[2] = MainCanvas.WIDTH - (this.dd.BODY_HEIGHT[this.dd.bodyParts - 5] + (this.gd.radius >> 1) + (this.gd.radius >> 2) + this.gd.dragonShift);
                this.dd.body1[3] = this.dd.BODY_SHIFT[this.dd.bodyParts - 5] + this.gd.dragonShift;
                this.dd.body1[4] = MainCanvas.WIDTH - ((this.dd.BODY_HEIGHT[this.dd.bodyParts - 5 + 1] + this.dd.BODY_HEIGHT[this.dd.bodyParts - 5 + 2] >> 1) + this.gd.radius + (this.gd.radius >> 1));
                this.dd.body1[5] = this.dd.BODY_SHIFT2[this.dd.bodyParts - 5] + this.gd.dragonShift;
                this.dd.line1[0] = MainCanvas.WIDTH - (this.dd.BODY_HEIGHT[this.dd.bodyParts - 5] + (this.gd.dragonShift >> 1) + this.gd.radius);
                this.dd.line1[1] = this.dd.BODY_SHIFT[this.dd.bodyParts - 5] + this.gd.dragonShift + (this.gd.radius >> 2);
                this.dd.line1[2] = MainCanvas.WIDTH - (this.dd.BODY_HEIGHT[this.dd.bodyParts - 5] + (this.gd.dragonShift >> 1) + this.gd.radius + (this.gd.radius >> 2));
                this.dd.line1[3] = this.dd.BODY_SHIFT[this.dd.bodyParts - 5] + this.gd.dragonShift + (this.gd.radius >> 2);
                this.dd.line1[4] = MainCanvas.WIDTH - ((this.dd.BODY_HEIGHT[this.dd.bodyParts - 5 + 1] + this.dd.BODY_HEIGHT[this.dd.bodyParts - 5 + 2] >> 1) + this.gd.radius + (this.gd.radius >> 1));
                this.dd.line1[5] = this.dd.BODY_SHIFT2[this.dd.bodyParts - 5] + this.gd.dragonShift - (this.gd.radius >> 2);
            }
            this.dd.head[0] = MainCanvas.WIDTH - (this.dd.headHeight + (this.gd.radius >> 3));
            this.dd.head[1] = this.dd.headShift - (this.gd.radius >> 2);
            this.dd.dragonball[0] = this.dd.head[0] - (this.imgHead.getWidth() + (this.imgHead.getWidth() >> 3));
            this.dd.dragonball[1] = this.dd.head[1] - (this.imgHead.getHeight() >> 3);
        }
    }

    public void setCollector() {
        if (MainCanvas.isRotated) {
            this.gd.collectorX1 = this.dd.headShift;
            this.gd.collectorX2 = this.dd.headShift + this.imgCollector.getHeight();
        }
    }

    public void setMountains2() {
        this.ed.mountains2X1Buffer += this.gd.move;
        this.ed.mountains2X1Inc = this.ed.mountains2X1Buffer >> 4;
        this.ed.mountains2X1Buffer %= 16;
        this.ed.mountains2X1 -= this.ed.mountains2X1Inc;
        this.ed.mountains2X2Buffer += this.gd.move;
        this.ed.mountains2X2Inc = this.ed.mountains2X2Buffer >> 4;
        this.ed.mountains2X2Buffer %= 16;
        this.ed.mountains2X2 -= this.ed.mountains2X2Inc;
        if (this.ed.mountains2X1 <= -this.ed.mountains2Shift) {
            this.ed.mountains2X1 += this.ed.mountains2Shift << 1;
        }
        if (this.ed.mountains2X2 <= -this.ed.mountains2Shift) {
            this.ed.mountains2X2 += this.ed.mountains2Shift << 1;
        }
        if (MainCanvas.isRotated) {
            this.ed.mountains2X1a = this.ed.mountains2X1;
            this.ed.mountains2X1b = this.ed.mountains2X1a + this.imgMountains2.getHeight();
            this.ed.mountains2X2a = this.ed.mountains2X2;
            this.ed.mountains2X2b = this.ed.mountains2X2a + this.imgMountains2.getHeight();
        }
        this.ed.mountains2YaShift = this.ed.mountains2Ya + this.gd.shift;
        this.ed.mountains2YbShift = this.ed.mountains2Yb + this.gd.shift;
    }

    public void sliding() {
        if (this.gd.acceleration < this.gd.mainMaxAcc) {
            ++this.gd.acceleration;
        }
    }

    public void accelerate() {
        if (this.gd.acceleration < this.gd.mainMaxAcc) {
            ++this.gd.acceleration;
        }
        this.isAccelerating = false;
    }

    public void slowdown() {
        if (this.gd.acceleration > 0) {
            --this.gd.acceleration;
        }
        this.isSlowingDown = false;
    }

    public void pullingDownLeft() {
        this.isWaiting = false;
        this.resetDragonBall();
        if (this.COORDS[this.dd.headShift + this.dd.halfHeadWidth] + this.dd.dragonHeadShift > this.dd.headHeight) {
            if (this.gd.jumpSpeed > 0) {
                this.gd.jumpSpeed = 0;
            }
            this.gd.jumpSpeed -= this.gd.mainJumpSpeedStep;
            this.zoomDec();
        } else {
            this.isPullingDownLeft = false;
            this.isFlying = false;
            this.zoomNull();
            this.stopEffect();
        }
    }

    public void pullingDownRight() {
        this.isPullingDownLeft = false;
        this.isWaiting = false;
        this.resetDragonBall();
        if (this.COORDS[this.dd.headShift + this.dd.halfHeadWidth] + this.dd.dragonHeadShift > this.dd.headHeight) {
            if (this.gd.jumpSpeed > 0) {
                this.gd.jumpSpeed = 0;
            }
            this.gd.jumpSpeed -= this.gd.mainJumpSpeedStepPressed >> 1;
            if (this.gd.zoom > 0) {
                this.zoomDec();
            }
        } else {
            this.isPullingDownRight = false;
            this.isFlying = false;
            this.zoomNull();
            this.stopEffect();
            this.isSliding = true;
        }
    }

    public void resetDragonBall() {
        this.isDragonBall = false;
        this.gd.dragonBallStarter = 0;
        this.gd.dragonBallJumps = 0;
        this.gd.dragonBallJumpsAllowed = 0;
    }

    public void initAchievement() {
        this.ad.achievementTimer = 6;
        this.isAchievement = true;
    }

    public void setAchievement() {
        if (this.ad.achievementTimer > 0) {
            if (this.gd.updateCounter % 10 == 0) {
                --this.ad.achievementTimer;
            }
        } else {
            this.isAchievement = false;
            if (this.isPauseAchievement) {
                this.isPauseAchievement = false;
            }
        }
    }

    public void initTimeAndLevelLength() {
        this.isTimeUp = false;
        this.gd.time = GameDefines.LEVEL_TIME[this.gd.level];
        if (this.dd.dragonLevel == 1) {
            this.gd.time += GameDefines.LEVEL_TIME[0] / 20;
        } else if (this.dd.dragonLevel == 2) {
            this.gd.time += GameDefines.LEVEL_TIME[0] / 20 + GameDefines.LEVEL_TIME[this.gd.level] / 20;
        } else if (this.dd.dragonLevel == 3) {
            this.gd.time += GameDefines.LEVEL_TIME[0] / 20 + GameDefines.LEVEL_TIME[this.gd.level] / 20;
        } else if (this.dd.dragonLevel == 4) {
            this.gd.time += GameDefines.LEVEL_TIME[0] / 10 + GameDefines.LEVEL_TIME[this.gd.level] / 20;
        } else if (this.dd.dragonLevel == 5) {
            this.gd.time += GameDefines.LEVEL_TIME[0] / 10 + GameDefines.LEVEL_TIME[this.gd.level] / 10;
        } else if (this.dd.dragonLevel == 6) {
            this.gd.time += GameDefines.LEVEL_TIME[0] / 6 + GameDefines.LEVEL_TIME[this.gd.level] / 10;
        }
        this.gd.maxTime = this.gd.time;
        this.isLevelEnd = false;
        this.gd.levelLength = this.gd.mainLevelLength;
        this.gd.levelLengthPom = this.gd.mainLevelLength;
    }

    public void setTimeAndLevelLength() {
        if (this.gd.time > 0) {
            if (this.gd.updateCounter % 20 == 0) {
                --this.gd.time;
            }
        } else {
            this.isTimeUp = true;
            this.initGameOver();
        }
        if (this.gd.levelLength - this.gd.move > 0) {
            this.gd.levelLength -= this.gd.move;
            if (!this.isLevelEnd && this.gd.levelLength < this.gd.mainLevelLengthReserve) {
                this.isLevelEnd = true;
            }
        } else {
            this.gd.levelLength = 0;
        }
    }

    public void initTimeAndLevelLength2() {
        this.isTimeUp = false;
        this.gd.timeAdd = !this.isInfinite ? GameDefines.LEVEL_TIME[this.gd.level] : GameDefines.LEVEL_TIME[this.gd.level] - 7;
        if (this.dd.dragonLevel == 1) {
            this.gd.maxTime = this.gd.time + this.gd.timeAdd + GameDefines.LEVEL_TIME[0] / 20;
        }
        if (this.dd.dragonLevel == 2) {
            this.gd.maxTime = this.gd.time + this.gd.timeAdd + GameDefines.LEVEL_TIME[0] / 20 + GameDefines.LEVEL_TIME[this.gd.level] / 20;
        }
        if (this.dd.dragonLevel == 3) {
            this.gd.maxTime = this.gd.time + this.gd.timeAdd + GameDefines.LEVEL_TIME[0] / 20 + GameDefines.LEVEL_TIME[this.gd.level] / 20;
        }
        if (this.dd.dragonLevel == 4) {
            this.gd.maxTime = this.gd.time + this.gd.timeAdd + GameDefines.LEVEL_TIME[0] / 10 + GameDefines.LEVEL_TIME[this.gd.level] / 20;
        }
        if (this.dd.dragonLevel == 5) {
            this.gd.maxTime = this.gd.time + this.gd.timeAdd + GameDefines.LEVEL_TIME[0] / 10 + GameDefines.LEVEL_TIME[this.gd.level] / 10;
        }
        this.gd.maxTime = this.dd.dragonLevel == 6 ? this.gd.time + this.gd.timeAdd + GameDefines.LEVEL_TIME[0] / 6 + GameDefines.LEVEL_TIME[this.gd.level] / 10 : this.gd.time + this.gd.timeAdd;
        this.isTimeAdd = true;
        this.isLevelEnd = false;
        this.gd.levelLength = this.gd.mainLevelLength;
        this.gd.levelLengthPom = this.gd.mainLevelLength;
    }

    public void initTimeAdd() {
        this.gd.timeAdd += 7;
        this.isTimeAdd = true;
    }

    public void initTimeNewDragonLevel(int t) {
        this.gd.timeAdd += t;
        this.isTimeAdd = true;
    }

    public void setTimeAdd() {
        if (this.gd.timeAdd > 0 && this.gd.time < this.gd.maxTime) {
            --this.gd.timeAdd;
            ++this.gd.time;
            if (this.gd.time == this.gd.maxTime) {
                this.isTimeAdd = false;
            }
        } else {
            this.isTimeAdd = false;
            this.gd.timeAdd = 0;
        }
    }

    public void initTextSlides() {
        if (MainCanvas.isRotated) {
            int fontHeight = Resources.resGFonts[this.coords.gfontGame].getHeight();
            int textMarginLeft = MainCanvas.WIDTH - this.imgLista.getWidth();
            int textMarginTop = this.coords.getStatusBar2(this.imgLista.getHeight()) + (this.gd.radius >> 2);
            int textWidth = this.imgLista.getWidth() - this.coords.statusBarShift;
            int textHeight = MainCanvas.HEIGHT - textMarginTop;
            this.rectTextSlides1 = new Rectangle(textMarginLeft, textMarginTop, textWidth, textHeight);
            this.rectTextSlides2 = new Rectangle(textMarginLeft, textMarginTop + fontHeight, textWidth, textHeight);
        }
        Resources.loadGFont(this.coords.gfontGame);
        preparedTextSlides1 = new PreparedText(Resources.resGFonts[this.coords.gfontGame]);
        preparedTextSlides2 = new PreparedText(Resources.resGFonts[this.coords.gfontGame]);
        this.textSlides();
    }

    public void textSlides() {
        if (!this.isDragonBall) {
            this.gd.textSlides1 = this.gd.goodSlides;
        } else if (this.gd.dragonBallJumps == 0) {
            this.gd.textSlides1 = 3;
        } else if (this.gd.dragonBallJumps == 1) {
            this.gd.textSlides1 = 2;
        } else if (this.gd.dragonBallJumps == 2) {
            this.gd.textSlides1 = 1;
        }
        if (this.gd.textSlides1 > 3) {
            this.gd.textSlides1 = 3;
        }
        preparedTextSlides1.prepareText(this.gd.textSlides1 + "", this.rectTextSlides1.width);
        preparedTextSlides2.prepareText("X", this.rectTextSlides2.width);
    }

    public void initTextCoins() {
        int fontHeight = Resources.resGFonts[this.coords.gfontGame].getHeight();
        if (MainCanvas.isRotated) {
            int textMarginLeft = MainCanvas.WIDTH - this.imgLista.getWidth();
            int textMarginTop = this.coords.getStatusBar1(this.imgLista.getHeight()) - (this.gd.radius >> 1) - (fontHeight << 1) - (fontHeight >> 2);
            int textWidth = this.imgLista.getWidth() - this.coords.statusBarShift;
            int textHeight = this.coords.getStatusBar1(this.imgLista.getHeight()) - textMarginTop;
            this.rectTextCoins1 = new Rectangle(textMarginLeft, textMarginTop, textWidth, textHeight);
            this.rectTextCoins2 = new Rectangle(textMarginLeft, textMarginTop + fontHeight - (fontHeight >> 2), textWidth, textHeight);
            this.rectTextCoins3 = new Rectangle(textMarginLeft, textMarginTop + fontHeight + (fontHeight >> 1), textWidth, textHeight);
        }
        Resources.loadGFont(this.coords.gfontGame);
        preparedTextCoins1 = new PreparedText(Resources.resGFonts[this.coords.gfontGame]);
        preparedTextCoins2 = new PreparedText(Resources.resGFonts[this.coords.gfontGame]);
        preparedTextCoins3 = new PreparedText(Resources.resGFonts[this.coords.gfontGame]);
        this.textCoins();
    }

    public void textCoins() {
        if (this.gd.coins >= 1000) {
            this.gd.textCoins1 = 9;
            this.gd.textCoins2 = 9;
            this.gd.textCoins3 = 9;
        } else if (this.gd.coins >= 100) {
            this.gd.textCoins1 = this.gd.coins / 100;
            this.gd.textCoins2 = (this.gd.coins - this.gd.textCoins1 * 100) / 10;
            this.gd.textCoins3 = this.gd.coins - this.gd.textCoins1 * 100 - this.gd.textCoins2 * 10;
        } else if (this.gd.coins >= 10) {
            this.gd.textCoins1 = 0;
            this.gd.textCoins2 = this.gd.coins / 10;
            this.gd.textCoins3 = this.gd.coins - this.gd.textCoins2 * 10;
        } else {
            this.gd.textCoins1 = 0;
            this.gd.textCoins2 = 0;
            this.gd.textCoins3 = this.gd.coins;
        }
        preparedTextCoins1.prepareText(this.gd.textCoins1 + "", this.rectTextCoins1.width);
        preparedTextCoins2.prepareText(this.gd.textCoins2 + "", this.rectTextCoins2.width);
        preparedTextCoins3.prepareText(this.gd.textCoins3 + "", this.rectTextCoins3.width);
    }

    public void sparklerCalculate() {
        if (MainCanvas.isRotated) {
            this.gd.timerWidth = this.coords.getStatusBar2(this.imgLista.getHeight()) - this.coords.getStatusBar1(this.imgLista.getHeight());
        }
        int pom = (this.gd.timerWidth - 5) * 100 / this.gd.maxTime;
        this.gd.sparklerMaxX = pom * this.gd.maxTime / 100;
        this.gd.sparklerStep = this.gd.sparklerMaxX * 100 / this.gd.maxTime;
    }

    public void initSparkler() {
        this.gd.sparklerX = 0;
        if (MainCanvas.isRotated) {
            this.gd.sparklerY = this.imgLista.getWidth() >> 1;
        }
        this.sparklerCalculate();
        this.isBigSparkler = false;
        this.isSparkling = false;
        this.isStartSparkling = true;
    }

    public void setStartSparkler() {
        if (this.gd.sparklerX + (this.gd.sparklerMaxX >> 4) < this.gd.time * this.gd.sparklerStep / 100) {
            this.gd.sparklerX += this.gd.sparklerMaxX >> 4;
        } else {
            this.gd.sparklerX = this.gd.time * this.gd.sparklerStep / 100;
            this.isStartSparkling = false;
        }
    }

    public void setSparkler() {
        if (this.gd.time > 0) {
            if (!this.isLoadingNewLevel || this.gd.sparklerX < this.gd.time * this.gd.sparklerStep / 100) {
                this.gd.sparklerX = this.gd.time * this.gd.sparklerStep / 100;
            }
        } else {
            this.gd.sparklerX = 1;
            this.isSparkler = false;
            this.isBigSparkler = true;
        }
    }

    public void setGate() {
        if (MainCanvas.isRotated) {
            if (this.gd.cursorX > 0) {
                this.gd.gateX = this.gd.cursorX - (this.imgGate2.getHeight() >> 1);
                this.gd.gateY = MainCanvas.WIDTH;
                this.isGate = true;
            } else {
                this.isGate = false;
            }
        }
    }

    public void addBodyPart() {
        if (this.dd.bodyParts < 5) {
            ++this.dd.bodyParts;
            this.achievement(3, 0);
            this.shiftDragon();
            this.dd.BODY_HEIGHT[this.dd.bodyParts - 1] = this.dd.BODY_HEIGHT[this.dd.bodyParts - 2];
        }
    }

    public void removeBodyPart() {
        if (this.dd.bodyParts > 1) {
            --this.dd.bodyParts;
            this.shiftDragon();
            this.gd.removedTime1 = 10 + RandomNum.getRandomUInt(10);
            this.gd.removedTime2 = 10 + RandomNum.getRandomUInt(10);
            this.gd.removedTime3 = 10 + RandomNum.getRandomUInt(10);
            this.gd.removedX1 = this.dd.headShift + this.gd.radius;
            this.gd.removedY1 = this.dd.headHeight + this.gd.radius;
            this.gd.removedX2 = this.gd.removedX1;
            this.gd.removedY2 = this.gd.removedY1;
            this.gd.removedX3 = this.gd.removedX1;
            this.gd.removedY3 = this.gd.removedY1;
            this.isRemoved1 = true;
            this.isRemoved2 = true;
            this.isRemoved3 = true;
            this.isRemovedPart = true;
        } else {
            this.gd.move = this.gd.mainSpeed;
            this.isPlaying = false;
            this.isPause = true;
            this.initGameOver();
        }
        ++this.ad.aSegments;
    }

    public void shiftDragon() {
        this.dd.tailShift = this.gd.radius >> 1;
        this.dd.tailShift2 = this.dd.tailShift + (this.gd.radius << 1);
        this.dd.BODY_SHIFT[0] = this.dd.tailShift2 - (this.gd.radius >> 2);
        this.dd.BODY_SHIFT2[0] = this.dd.BODY_SHIFT[0] + (this.gd.radius << 1);
        if (this.dd.bodyParts > 1) {
            for (int i = 1; i < this.dd.bodyParts; ++i) {
                this.dd.BODY_SHIFT[i] = this.dd.BODY_SHIFT[i - 1] + this.gd.radius;
                this.dd.BODY_SHIFT2[i] = this.dd.BODY_SHIFT2[i - 1] + this.gd.radius;
            }
        }
        this.dd.headShift = this.dd.BODY_SHIFT[this.dd.bodyParts - 1] + this.gd.radius;
        this.dd.halfHeadWidth = this.imgHead.getWidth() >> 1;
    }

    public void initGameOver() {
        this.initText(1);
        this.gd.gameOverTimer = 5;
        this.isGameOver = true;
    }

    public void setGameOver() {
        if (this.gd.gameOverTimer > 0) {
            if (this.gd.updateCounter % 20 == 0) {
                --this.gd.gameOverTimer;
            }
        } else {
            this.gameOver();
        }
    }

    public void initCursorY() {
        if (MainCanvas.isRotated) {
            this.gd.cursorY = (MainCanvas.WIDTH >> 1) + (MainCanvas.WIDTH >> 3);
        }
    }

    public void initTerrain() {
        int i;
        this.gd.cursorX = this.dd.headShift;
        this.initCursorY();
        this.gd.lastX = this.gd.cursorX + this.gd.radius;
        for (i = 0; i <= this.gd.lastX; ++i) {
            this.COORDS[i] = this.gd.cursorY;
        }
        for (i = this.gd.lastX + 1; i < this.maxCoords; ++i) {
            this.COORDS[i] = -9999;
        }
        for (i = 0; i < this.maxCoords; ++i) {
            this.ITEMS[i] = -9999;
            this.ITEMS_HEIGHT[i] = -9999;
        }
        if (MainCanvas.isRotated) {
            for (i = 0; i < MainCanvas.HEIGHT; ++i) {
                this.ITEMS_DISAPPEARING_STEPS[i] = -9999;
            }
        }
        this.gd.direction = 1;
        this.generateCurve(this.gd.floor - this.gd.cursorY << 1, this.gd.floor - this.gd.cursorY);
        if (this.gd.level == 5) {
            this.initLevel6();
        }
        this.generateHills();
        this.generateHills();
    }

    public void reloadTerrain() {
        int i;
        this.gd.cursorX = this.dd.headShift;
        if (MainCanvas.isRotated) {
            this.gd.cursorY = (MainCanvas.WIDTH >> 1) + (MainCanvas.WIDTH >> 3);
        }
        this.gd.lastX = this.gd.cursorX + this.gd.radius;
        for (i = 0; i <= this.gd.lastX; ++i) {
            this.COORDS[i] = this.gd.cursorY;
        }
        for (i = this.gd.lastX + 1; i < this.maxCoords; ++i) {
            this.COORDS[i] = -9999;
        }
        for (i = 0; i < this.maxCoords; ++i) {
            this.ITEMS[i] = -9999;
            this.ITEMS_HEIGHT[i] = -9999;
        }
        for (i = 0; i < MainCanvas.WIDTH; ++i) {
            this.ITEMS_DISAPPEARING_STEPS[i] = -9999;
        }
        this.gd.direction = 1;
        this.generateCurve(this.gd.size4, this.gd.size4 >> 1);
        if (this.gd.level == 5) {
            this.initLevel6();
        }
        this.generateHills();
        this.generateHills();
    }

    public void initLevel6() {
        this.generateCurve(this.gd.cursorY - this.gd.ceiling << 1, this.gd.cursorY - this.gd.ceiling);
        this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
    }

    public void setRemovedPart() {
        if (this.isRemoved1) {
            if (this.gd.removedTime1 > 0) {
                --this.gd.removedTime1;
                this.gd.removedX1 -= this.gd.move >> 1;
                ++this.gd.removedY1;
            } else {
                this.isRemoved1 = false;
            }
        }
        if (this.isRemoved2) {
            if (this.gd.removedTime2 > 0) {
                --this.gd.removedTime2;
                this.gd.removedX2 -= this.gd.move >> 1;
                --this.gd.removedY2;
            } else {
                this.isRemoved2 = false;
            }
        }
        if (this.isRemoved3) {
            if (this.gd.removedTime3 > 0) {
                --this.gd.removedTime3;
                this.gd.removedX3 -= this.gd.move >> 2;
                --this.gd.removedY3;
            } else {
                this.isRemoved3 = false;
            }
        }
        if (!(this.isRemoved1 || this.isRemoved2 || this.isRemoved3)) {
            this.isRemovedPart = false;
        }
    }

    public void initMountains2() {
        this.ed.mountains2X1Buffer = 0;
        this.ed.mountains2X1Inc = 0;
        this.ed.mountains2X2Buffer = 0;
        this.ed.mountains2X2Inc = 0;
        if (MainCanvas.isRotated) {
            this.ed.mountains2Shift = this.imgMountains2.getHeight() << 1;
            this.ed.mountains2X1 = 0;
            this.ed.mountains2X2 = this.ed.mountains2Shift;
            this.ed.mountains2Ya = MainCanvas.WIDTH;
            this.ed.mountains2Yb = MainCanvas.WIDTH;
        }
    }

    public void goodSlidesInc() {
        ++this.gd.goodSlides;
        this.textSlides();
        this.isGoodSlides = true;
    }

    public void goodSlidesNull() {
        if (this.gd.goodSlides > 0) {
            this.gd.goodSlides = 0;
        }
        this.isGoodSlides = false;
    }

    public void badImpactsNull() {
        if (this.gd.badImpacts > 0) {
            this.gd.badImpacts = 0;
        }
    }

    public void postupnostNull() {
        if (this.gd.postupnost > 0) {
            this.gd.postupnost = 0;
        }
    }

    public void gameCompleted() {
        this.isGameCompleted = false;
        this.isInfinite = true;
        this.saveAchievements(0);
        this.isPause = true;
        this.isPlaying = false;
        this.isPressedAction = false;
        this.saveGame();
        this.freeAll();
        this.mainCanvas.changeLastActiveScreen(new ScreenFinalText(this.mainCanvas, this.gd.coins, this.gd.distance, this.gd.levelCounter - 1, true));
        this.mainCanvas.repaint();
        this.mainCanvas.serviceRepaints();
    }

    public void backToLevel1() {
        this.isControllable = true;
        this.initNewLevel();
        this.isBackToLevel1 = false;
    }

    public void initLevel() {
        this.isGeneratedEnd = false;
        this.initCursorY();
        this.gd.direction = 1;
        this.postupnostNull();
        this.goodSlidesNull();
        this.badImpactsNull();
        this.resetDragonBall();
        this.gd.goodSlidingStarter = 1;
        this.isLoadingNewLevel = false;
        this.isEnd = false;
        this.isLastHillStart = false;
        this.isLastHillTop = false;
        this.isLastHillEnd = false;
        this.isIslandEnd = false;
        this.isGeneratingLastHill = false;
        this.gd.generatingLastHill = 0;
        this.loadImages();
        this.initThings();
        this.initEnv(1);
        this.setEnvironment();
        this.reloadTerrain();
        this.isFalling = true;
        this.isWaiting = true;
    }

    public void initLevelEnd() {
        this.isGeneratedEnd = false;
        this.initCursorY();
        this.gd.direction = 1;
        this.postupnostNull();
        this.goodSlidesNull();
        this.badImpactsNull();
        this.resetDragonBall();
        this.gd.goodSlidingStarter = 1;
        this.isLoadingNewLevel = false;
        this.isEnd = false;
        this.isLastHillStart = false;
        this.isLastHillTop = false;
        this.isLastHillEnd = false;
        this.isIslandEnd = false;
        this.isGeneratingLastHill = false;
        this.gd.generatingLastHill = 0;
        this.loadImages();
        this.initThings();
        this.initEnv(1);
        this.setEnvironment();
        this.reloadTerrain();
        this.isFalling = true;
        this.isWaiting = true;
    }

    public void initNewLevel() {
        this.initLevel();
        this.isControllable = true;
        this.initNewLevelIndicator();
        this.gd.glidingTimer = 3;
        this.gd.clocksCount = 0;
        this.isAddedClocks = false;
        this.isGeneratingClocks = true;
    }

    public void setSounds() {
        if (!this.isInfinite) {
            if (this.gd.level == 0 || this.gd.level == 5 || this.gd.level == 10) {
                this.playSounds();
            }
        } else {
            this.playSounds();
        }
    }

    public void initGameEnd() {
        this.initLevelEnd();
        this.isControllable = true;
        this.gd.glidingTimer = 0;
    }

    public void initBackToLevel1() {
        this.initLevel();
        this.gd.glidingTimer = 10;
        this.gd.clocksCount = 0;
        this.isAddedClocks = false;
        this.isGeneratingClocks = true;
        this.playSounds();
    }

    public void loadNewLevel() {
        if (!this.isInfinite) {
            if (this.gd.level == 14) {
                this.achievement(3, 5);
                this.initTimeAndLevelLength2();
                this.sparklerCalculate();
                ++this.gd.levelCounter;
                this.gd.level = RandomNum.getRandomUInt(15);
                this.changeEnvironment();
                this.ad.aSegments = 0;
                this.ad.aImpacts = 0;
                this.ad.aInputTime = this.gd.time;
                this.isGameCompleted = true;
                this.initGameEnd();
            } else if (this.gd.level == 11 && this.dd.dragonLevel < 3) {
                this.isRepeated = true;
                this.gd.level = 0;
                this.gd.levelCounter = 0;
                this.changeEnvironment();
                this.isBackToLevel1 = true;
                this.initBackToLevel1Indicator();
                this.initBackToLevel1();
            } else {
                this.gd.level = (this.gd.level + 1) % 15;
                ++this.gd.levelCounter;
                this.ad.aSegments = 0;
                this.ad.aImpacts = 0;
                this.ad.aInputTime = this.gd.time;
                this.changeEnvironment();
                this.initNewLevel();
                this.setSounds();
            }
        } else {
            ++this.gd.levelCounter;
            this.gd.level = RandomNum.getRandomUInt(15);
            this.ad.aSegments = 0;
            this.ad.aImpacts = 0;
            this.ad.aInputTime = this.gd.time;
            this.changeEnvironment();
            this.initNewLevel();
            this.setSounds();
        }
    }

    public void initBackToLevel1Indicator() {
        this.initText(2);
        this.gd.level1Timer = 10;
        this.isLevel1Indicator = true;
    }

    public void setBackToLevel1Indicator() {
        if (this.gd.level1Timer > 0) {
            if (this.gd.updateCounter % 20 == 0) {
                --this.gd.level1Timer;
            }
        } else {
            this.isLevel1Indicator = false;
        }
    }

    public void initNewLevelIndicator() {
        this.initText(0);
        this.gd.newLevelTimer = 3;
        this.isNewLevelIndicator = true;
    }

    public void setNewLevelIndicator() {
        if (this.gd.newLevelTimer > 0) {
            if (this.gd.updateCounter % 20 == 0) {
                --this.gd.newLevelTimer;
            }
        } else {
            this.achievement(2, 2);
            this.achievement(3, 4);
            this.isNewLevelIndicator = false;
        }
    }

    public void setHeights() {
        if (this.isEnd) {
            if (this.gd.zoom < this.gd.maxZoom / 3) {
                this.dd.tailHeight -= this.dd.tailHeight - this.dd.BODY_HEIGHT[0] >> 1;
                this.dd.tailHeight2 -= this.dd.tailHeight2 - this.dd.BODY_HEIGHT[0] >> 1;
            } else if (this.gd.jumpSpeed > this.gd.mainJumpSpeedStep) {
                this.dd.tailHeight = this.dd.BODY_HEIGHT[0] + (this.gd.radius >> 2);
                this.dd.tailHeight2 = this.dd.BODY_HEIGHT[0] + (this.gd.radius >> 2);
            } else if (this.gd.jumpSpeed < -this.gd.mainJumpSpeedStep) {
                this.dd.tailHeight = this.dd.BODY_HEIGHT[0] - (this.gd.radius >> 2);
                this.dd.tailHeight2 = this.dd.BODY_HEIGHT[0] - (this.gd.radius >> 2);
            } else {
                this.dd.tailHeight = this.dd.BODY_HEIGHT[0];
                this.dd.tailHeight2 = this.dd.BODY_HEIGHT[0];
            }
            if (this.dd.bodyParts > 1) {
                for (int i = 0; i < this.dd.bodyParts - 1; ++i) {
                    if (this.gd.zoom < this.gd.maxZoom / 3) {
                        int n = i;
                        this.dd.BODY_HEIGHT[n] = this.dd.BODY_HEIGHT[n] - (this.dd.BODY_HEIGHT[i] - this.dd.BODY_HEIGHT[i + 1] >> 1);
                        continue;
                    }
                    this.dd.BODY_HEIGHT[i] = this.gd.jumpSpeed > this.gd.mainJumpSpeedStep ? this.dd.BODY_HEIGHT[i + 1] + (this.gd.radius >> 2) : (this.gd.jumpSpeed < -this.gd.mainJumpSpeedStep ? this.dd.BODY_HEIGHT[i + 1] - (this.gd.radius >> 2) : this.dd.BODY_HEIGHT[i + 1]);
                }
            }
            if (this.gd.zoom < this.gd.maxZoom / 3) {
                int n = this.dd.bodyParts - 1;
                this.dd.BODY_HEIGHT[n] = this.dd.BODY_HEIGHT[n] - ((this.dd.BODY_HEIGHT[this.dd.bodyParts - 1] - this.dd.headHeight >> 2) + (this.dd.BODY_HEIGHT[this.dd.bodyParts - 1] - this.dd.headHeight >> 3));
            } else {
                this.dd.BODY_HEIGHT[this.dd.bodyParts - 1] = this.gd.jumpSpeed > this.gd.mainJumpSpeedStep ? this.dd.headHeight + (this.gd.radius >> 2) : (this.gd.jumpSpeed < -this.gd.mainJumpSpeedStep ? this.dd.headHeight - (this.gd.radius >> 2) : this.dd.headHeight);
            }
        } else if (this.isSliding || !this.isFlying && !this.isLanding) {
            this.dd.tailHeight = this.COORDS[this.dd.tailShift] + this.dd.dragonBodyShift;
            this.dd.tailHeight2 = this.COORDS[this.dd.tailShift] + this.dd.dragonBodyShift;
            for (int i = 0; i < this.dd.bodyParts; ++i) {
                this.dd.BODY_HEIGHT[i] = this.COORDS[this.dd.BODY_SHIFT[i]] + this.dd.dragonBodyShift;
            }
        } else {
            int n = this.gd.fallingStep = this.isPressedAction ? this.gd.radius << 1 : this.gd.radius >> 1;
            if (this.COORDS[this.dd.BODY_SHIFT[0]] + this.dd.dragonBodyShift > this.dd.BODY_HEIGHT[0] && this.dd.tailHeight - (this.dd.tailHeight - this.dd.BODY_HEIGHT[0] >> 1) < this.COORDS[this.dd.tailShift]) {
                if (this.gd.zoom < this.gd.maxZoom / 3) {
                    this.dd.tailHeight -= this.dd.tailHeight - this.dd.BODY_HEIGHT[0] >> 1;
                    this.dd.tailHeight2 -= this.dd.tailHeight2 - this.dd.BODY_HEIGHT[0] >> 1;
                } else if (this.gd.jumpSpeed > this.gd.mainJumpSpeedStep) {
                    this.dd.tailHeight = this.dd.BODY_HEIGHT[0] + (this.gd.radius >> 2);
                    this.dd.tailHeight2 = this.dd.BODY_HEIGHT[0] + (this.gd.radius >> 2);
                } else if (this.gd.jumpSpeed < -this.gd.mainJumpSpeedStep) {
                    this.dd.tailHeight = this.dd.BODY_HEIGHT[0] - (this.gd.radius >> 2);
                    this.dd.tailHeight2 = this.dd.BODY_HEIGHT[0] - (this.gd.radius >> 2);
                } else {
                    this.dd.tailHeight = this.dd.BODY_HEIGHT[0];
                    this.dd.tailHeight2 = this.dd.BODY_HEIGHT[0];
                }
            } else if (this.COORDS[this.dd.tailShift] + this.dd.dragonBodyShift - this.dd.tailHeight > this.gd.fallingStep) {
                this.dd.tailHeight += this.gd.fallingStep;
                this.dd.tailHeight2 += this.gd.fallingStep;
            } else {
                this.dd.tailHeight = this.COORDS[this.dd.tailShift] + this.dd.dragonBodyShift;
                this.dd.tailHeight2 = this.COORDS[this.dd.tailShift2] + this.dd.dragonBodyShift;
            }
            if (this.dd.bodyParts > 1) {
                for (int i = 0; i < this.dd.bodyParts - 1; ++i) {
                    if (this.COORDS[this.dd.BODY_SHIFT[i + 1]] + this.dd.dragonBodyShift > this.dd.BODY_HEIGHT[i + 1] && this.dd.BODY_HEIGHT[i] - (this.dd.BODY_HEIGHT[i] - this.dd.BODY_HEIGHT[i + 1] >> 1) < this.COORDS[this.dd.BODY_SHIFT[i]] + this.dd.dragonBodyShift) {
                        if (this.gd.zoom < this.gd.maxZoom / 3) {
                            int n2 = i;
                            this.dd.BODY_HEIGHT[n2] = this.dd.BODY_HEIGHT[n2] - (this.dd.BODY_HEIGHT[i] - this.dd.BODY_HEIGHT[i + 1] >> 1);
                            continue;
                        }
                        if (this.gd.jumpSpeed > this.gd.mainJumpSpeedStep) {
                            this.dd.BODY_HEIGHT[i] = this.dd.BODY_HEIGHT[i + 1] + (this.gd.radius >> 2);
                            continue;
                        }
                        if (this.gd.jumpSpeed < -this.gd.mainJumpSpeedStep) {
                            this.dd.BODY_HEIGHT[i] = this.dd.BODY_HEIGHT[i + 1] - (this.gd.radius >> 2);
                            continue;
                        }
                        this.dd.BODY_HEIGHT[i] = this.dd.BODY_HEIGHT[i + 1];
                        continue;
                    }
                    if (this.COORDS[this.dd.BODY_SHIFT[i]] + this.dd.dragonBodyShift - this.dd.BODY_HEIGHT[i] > this.gd.fallingStep) {
                        int n3 = i;
                        this.dd.BODY_HEIGHT[n3] = this.dd.BODY_HEIGHT[n3] + this.gd.fallingStep;
                        continue;
                    }
                    this.dd.BODY_HEIGHT[i] = this.COORDS[this.dd.BODY_SHIFT[i]] + this.dd.dragonBodyShift;
                }
            }
            if (this.COORDS[this.dd.headShift + this.dd.halfHeadWidth] + this.dd.dragonHeadShift > this.dd.headHeight && this.dd.BODY_HEIGHT[this.dd.bodyParts - 1] - (this.dd.BODY_HEIGHT[this.dd.bodyParts - 1] - this.dd.headHeight >> 1) < this.COORDS[this.dd.BODY_SHIFT[this.dd.bodyParts - 1]] + this.dd.dragonBodyShift) {
                if (this.dd.BODY_HEIGHT[this.dd.bodyParts - 1] >= this.dd.headHeight && this.COORDS[this.dd.BODY_SHIFT[this.dd.bodyParts - 1]] + this.dd.dragonBodyShift < this.dd.BODY_HEIGHT[this.dd.bodyParts - 1]) {
                    int n4 = this.dd.bodyParts - 1;
                    this.dd.BODY_HEIGHT[n4] = this.dd.BODY_HEIGHT[n4] - ((this.dd.BODY_HEIGHT[this.dd.bodyParts - 1] - this.dd.headHeight >> 2) + (this.dd.BODY_HEIGHT[this.dd.bodyParts - 1] - this.dd.headHeight >> 3));
                } else if (this.gd.zoom < this.gd.maxZoom / 3) {
                    int n5 = this.dd.bodyParts - 1;
                    this.dd.BODY_HEIGHT[n5] = this.dd.BODY_HEIGHT[n5] - (this.dd.BODY_HEIGHT[this.dd.bodyParts - 1] - this.dd.headHeight >> 1);
                } else {
                    this.dd.BODY_HEIGHT[this.dd.bodyParts - 1] = this.gd.jumpSpeed > this.gd.mainJumpSpeedStep ? this.dd.headHeight + (this.gd.radius >> 2) : (this.gd.jumpSpeed < -this.gd.mainJumpSpeedStep ? this.dd.headHeight - (this.gd.radius >> 2) : this.dd.headHeight);
                }
            } else if (this.COORDS[this.dd.BODY_SHIFT[this.dd.bodyParts - 1]] + this.dd.dragonBodyShift - this.dd.BODY_HEIGHT[this.dd.bodyParts - 1] >= this.gd.fallingStep) {
                int n6 = this.dd.bodyParts - 1;
                this.dd.BODY_HEIGHT[n6] = this.dd.BODY_HEIGHT[n6] + this.gd.fallingStep;
            } else {
                this.dd.BODY_HEIGHT[this.dd.bodyParts - 1] = this.COORDS[this.dd.BODY_SHIFT[this.dd.bodyParts - 1]] + this.dd.dragonBodyShift;
            }
        }
    }

    public void clocksCollisionDetection() {
        for (int i = this.gd.collectorX1; i < this.gd.collectorX2; ++i) {
            if (this.ITEMS[i] != 3 || !MainCanvas.isRotated || this.dd.headHeight >= this.ITEMS_HEIGHT[i] - (this.sprClock.getWidth() >> 1) - (this.sprClock.getWidth() >> 2) - (this.sprClock.getWidth() >> 4) + this.gd.shift || this.dd.headHeight + this.imgCollector.getWidth() <= this.ITEMS_HEIGHT[i] - this.sprClock.getWidth() - (this.sprClock.getWidth() >> 1) + (this.sprClock.getWidth() >> 3) + this.gd.shift) continue;
            this.ITEMS[i] = 9;
            this.ITEMS_DISAPPEARING_STEPS[i] = 5;
            this.achievement(3, 2);
            this.initTimeAdd();
        }
    }

    public void itemsCollisionDetection() {
        block7: {
            block8: {
                if (!MainCanvas.isRotated) break block7;
                if (this.COORDS[this.dd.headShift + this.dd.halfHeadWidth] + this.dd.dragonHeadShift - this.dd.headHeight >= this.imgCollector.getWidth() + (this.imgCollector.getWidth() >> 2)) break block8;
                for (int i = this.gd.collectorX1; i < this.gd.collectorX2; ++i) {
                    if (this.ITEMS[i] == 0) {
                        this.ITEMS[i] = 6;
                        this.ITEMS_DISAPPEARING_STEPS[i] = 5;
                        this.ITEMS_HEIGHT[i] = this.COORDS[i];
                        this.gd.score += 50;
                        ++this.gd.coins;
                        this.achievement(1, 1);
                        this.achievement(1, 3);
                        this.achievement(1, 5);
                        if (this.gd.coins % 33 == 0) {
                            this.addBodyPart();
                        }
                        if (this.gd.coins == 1000) {
                            this.initTimeAdd();
                            while (this.dd.bodyParts < 5) {
                                this.addBodyPart();
                            }
                        }
                        this.textCoins();
                    }
                    if (this.ITEMS[i] == 1) {
                        this.ITEMS[i] = 7;
                        this.ITEMS_DISAPPEARING_STEPS[i] = 5;
                        this.gd.score += 200;
                        this.achievement(3, 1);
                        this.initEnergyAcceleration();
                    }
                    if (this.ITEMS[i] != 2) continue;
                    this.ITEMS[i] = 8;
                    this.ITEMS_DISAPPEARING_STEPS[i] = 5;
                    this.gd.score += 100;
                    this.achievement(3, 3);
                    this.addBodyPart();
                }
                break block7;
            }
            if (this.COORDS[this.dd.headShift + this.dd.halfHeadWidth] + this.dd.dragonHeadShift - this.dd.headHeight >= this.imgCollector.getWidth() + (this.imgCollector.getWidth() >> 1)) break block7;
            for (int i = this.gd.collectorX1; i < this.gd.collectorX2; ++i) {
                if (this.ITEMS[i] != 2) continue;
                this.ITEMS[i] = 8;
                this.ITEMS_DISAPPEARING_STEPS[i] = 5;
                this.gd.score += 100;
                this.achievement(3, 3);
                this.addBodyPart();
            }
        }
    }

    public void specialItemsCollisionDetection() {
        for (int i = this.gd.collectorX1; i < this.gd.collectorX2; ++i) {
            if (!this.isLastHillStart && this.ITEMS[i] == 10) {
                this.isLastHillStart = true;
                this.ITEMS[i] = -9999;
                this.isTutorialStopped = true;
                this.isPullingDownLeft = true;
                this.isControllable = false;
            }
            if (!this.isLastHillTop && this.ITEMS[i] == 11) {
                this.isLastHillTop = true;
                this.ITEMS[i] = -9999;
                this.isPullingDownLeft = false;
                this.isPullingDownRight = true;
                this.isControllable = false;
            }
            if (!this.isLastHillEnd && this.ITEMS[i] == 12) {
                this.isLastHillEnd = true;
                this.ITEMS[i] = -9999;
                this.isControllable = false;
                this.resetDragonBall();
            }
            if (this.isIslandEnd || this.ITEMS[i] != 13) continue;
            this.achievement(2, 3);
            this.achievement(2, 4);
            this.achievement(2, 5);
            this.isIslandEnd = true;
            this.ITEMS[i] = -9999;
            this.gd.maxZoom = this.gd.mainMaxZoom2;
            this.isSliding = false;
            this.goodSlidesNull();
            this.badImpactsNull();
            this.gd.goodSlidingStarter = 1;
            this.resetDragonBall();
            this.isEnd = true;
            this.gd.originalAcceleration = this.gd.acceleration;
            this.gd.acceleration = this.gd.mainMaxAcc;
            this.setLevelEndJumpSpeed();
            this.isLanding = false;
            this.isFlying = true;
            this.startEffect();
            this.isLoadingNewLevel = true;
            if ((this.gd.level >= 14 || this.isInfinite) && !this.isInfinite) continue;
            this.initTimeAndLevelLength2();
            this.sparklerCalculate();
        }
    }

    public void setLevelEndJumpSpeed() {
        if (MainCanvas.isRotated) {
            this.gd.jumpSpeed = MainCanvas.WIDTH + (MainCanvas.WIDTH >> 2);
        }
    }

    public void initEnergyAcceleration() {
        this.gd.energyAcceleratingTimer = 30;
        this.isEnergyAccelerating = true;
        this.startEffect();
        ++this.gd.dragonBallStarter;
    }

    public void setEnergyAcceleration() {
        if (this.gd.energyAcceleratingTimer >= 1) {
            --this.gd.energyAcceleratingTimer;
            if (this.gd.acceleration + 1 <= this.gd.mainMaxAcc) {
                ++this.gd.acceleration;
            } else {
                this.isEnergyAccelerating = false;
            }
        } else {
            this.isEnergyAccelerating = false;
        }
    }

    public void zoomInc() {
        if (this.gd.zoom < this.gd.maxZoom) {
            ++this.gd.zoom;
        }
    }

    public void zoomDec() {
        if (this.gd.zoom > 0) {
            --this.gd.zoom;
        }
    }

    public void zoomNull() {
        this.gd.zoom = 0;
    }

    public void setDragonBall(boolean isBall) {
        this.isDragonBall = isBall;
    }

    public int calculateJumpType() {
        int delta;
        int y1 = 0;
        int y0 = y1 = this.COORDS[this.dd.headShift + this.dd.halfHeadWidth];
        for (int i = this.dd.headShift + this.gd.radius - 1; i >= 0; --i) {
            if (this.COORDS[i] >= y0) {
                y0 = this.COORDS[i];
                continue;
            }
            i = -1;
        }
        int n = delta = y1 >= y0 ? y1 - y0 : y0 - y1;
        if (delta >= 0 && delta < 23) {
            this.gd.type = 2;
        } else if (delta >= 23 && delta <= 45) {
            this.gd.type = 1;
        } else if (delta > 45) {
            this.gd.type = 0;
        }
        return this.gd.type;
    }

    public void jump() {
        this.gd.jumpHeight = this.dd.headHeight * 10;
        this.gd.jumpHeight -= this.gd.jumpSpeed;
        if (this.isControllable) {
            if (this.isPressedAction) {
                if (!this.isDragonBall) {
                    this.jumpPressedAndControllable();
                } else {
                    this.jumpPressedAndControllableDragonBall();
                }
            } else if (!this.isDragonBall) {
                this.jumpControllable();
            } else {
                this.jumpControllableDragonBall();
            }
            if (this.gd.zoom < this.gd.maxZoom && this.isNewLevelLoading) {
                this.isNewLevelLoading = false;
            }
        } else {
            this.jumpEnd();
            if (this.gd.zoom == this.gd.maxZoom && !this.isNewLevelLoading) {
                this.isNewLevelLoading = true;
            }
            if (this.isGameCompleted) {
                if (this.gd.glidingTimer > 0) {
                    if (this.gd.updateCounter % 20 == 0) {
                        --this.gd.glidingTimer;
                    }
                } else {
                    this.gameCompleted();
                }
            }
            if (this.isBackToLevel1) {
                if (this.gd.glidingTimer > 0) {
                    if (this.gd.updateCounter % 20 == 0) {
                        --this.gd.glidingTimer;
                    }
                } else {
                    this.backToLevel1();
                }
            }
        }
        if (!this.isEnd) {
            if (!this.isDragonBall) {
                this.controller();
            } else {
                this.controllerDragonBall();
            }
        } else {
            this.controllerEnd();
        }
    }

    public void jumpPressedAndControllable() {
        this.isWaiting = false;
        this.zoomDec();
        if (this.gd.jumpSpeed > 0) {
            this.gd.jumpSpeed = 0;
        }
        if (this.gd.jumpSpeed > -this.gd.mainMaxJumpSpeed) {
            this.gd.jumpSpeed -= this.gd.mainJumpSpeedStepPressed;
        }
        if (this.gd.acceleration < this.gd.mainMaxAcc && this.gd.updateCounter % 2 == 0) {
            ++this.gd.acceleration;
        }
    }

    public void jumpPressedAndControllableDragonBall() {
        this.isWaiting = false;
        if (this.gd.jumpSpeed > 0) {
            this.gd.jumpSpeed = 0;
        } else {
            this.zoomDec();
            if (this.gd.jumpSpeed > -this.gd.mainMaxJumpSpeed) {
                this.gd.jumpSpeed -= this.gd.mainJumpSpeedStepPressed;
            }
            if (this.gd.acceleration < this.gd.mainMaxAcc && this.gd.updateCounter % 2 == 0) {
                ++this.gd.acceleration;
            }
        }
    }

    public void jumpControllable() {
        if (this.gd.goodSlides < 3) {
            if (this.gd.jumpSpeed >= 0) {
                this.gd.jumpSpeed -= this.gd.mainJumpSpeedStep;
            } else if (this.gd.jumpSpeed < 0) {
                if (this.isWaiting) {
                    if (this.gd.updateCounter % 2 == 0 && this.gd.acceleration > this.gd.originalAcceleration) {
                        this.slowdown();
                    }
                    if (this.gd.glidingTimer > 0) {
                        if (this.gd.updateCounter % 20 == 0) {
                            --this.gd.glidingTimer;
                        }
                    } else if (!this.isGameCompleted && !this.isBackToLevel1 && this.gd.updateCounter % 2 == 0) {
                        this.gd.jumpSpeed -= this.gd.mainJumpSpeedStepSlow;
                        this.zoomDec();
                    }
                    if (this.gd.zoom < this.gd.maxZoom >> 1) {
                        this.isFalling = false;
                    }
                } else {
                    this.isFalling = false;
                    this.gd.jumpSpeed -= this.gd.mainJumpSpeedStep;
                    this.zoomDec();
                }
            }
        } else if (this.gd.jumpSpeed >= 0) {
            this.gd.jumpSpeed -= this.gd.mainJumpSpeedStep;
        } else {
            this.gd.badImpacts = 0;
            this.startEffect();
            this.gd.jumpSpeed -= this.gd.mainJumpSpeedStep;
            this.zoomDec();
            if (this.gd.goodSlides == 3) {
                this.goodSlidesNull();
            }
        }
    }

    public void jumpControllableDragonBall() {
        this.gd.jumpSpeed -= this.gd.mainJumpSpeedStep;
        if (this.gd.jumpSpeed < 0) {
            this.zoomDec();
        }
    }

    public void jumpEnd() {
        if (this.isEnd) {
            this.startEffect();
            if (this.gd.jumpSpeed >= 0) {
                this.gd.jumpSpeed -= this.gd.mainJumpSpeedStep;
                if (this.gd.acceleration < this.gd.mainMaxAcc) {
                    this.accelerate();
                }
            } else {
                this.loadNewLevel();
            }
        }
    }

    public void controller() {
        if (this.gd.zoom == 0 && this.COORDS[this.dd.headShift + this.dd.halfHeadWidth] + this.dd.dragonHeadShift > this.gd.jumpHeight / 10 || this.gd.zoom > 0) {
            if (this.gd.jumpHeight / 10 <= this.gd.ceilingDragon) {
                this.dd.headHeight = this.gd.ceilingDragon;
                if (this.gd.jumpSpeed > 0) {
                    this.zoomInc();
                }
                if (this.gd.glidingTimer == 0 && this.gd.jumpSpeed < 0) {
                    this.zoomDec();
                }
            } else {
                this.dd.headHeight = this.gd.jumpHeight / 10;
                if (this.gd.jumpSpeed < 0) {
                    this.zoomDec();
                }
            }
        } else {
            this.isWaiting = false;
            this.zoomNull();
            this.gd.maxZoom = this.gd.mainMaxZoom1;
            if (!(this.isPullingDownLeft || this.COORDS[this.dd.headShift + this.dd.halfHeadWidth] <= this.COORDS[this.dd.headShift + this.dd.halfHeadWidth + (this.gd.radius >> 1)] && this.COORDS[this.dd.headShift + this.dd.halfHeadWidth] <= this.COORDS[this.dd.headShift + this.dd.halfHeadWidth + (this.gd.radius >> 2)] || this.COORDS[this.dd.headShift + this.dd.halfHeadWidth] >= this.COORDS[this.dd.headShift + this.dd.halfHeadWidth - (this.gd.radius >> 1)] && this.COORDS[this.dd.headShift + this.dd.halfHeadWidth] >= this.COORDS[this.dd.headShift + this.dd.halfHeadWidth - (this.gd.radius >> 2)])) {
                if (this.gd.goodSlidingStarter == 1 && this.gd.acceleration > this.gd.mainMaxAcc >> 1) {
                    this.gd.acceleration -= this.gd.acceleration >> 1;
                    this.gd.goodSlidingStarter = 0;
                    this.resetDragonBall();
                    this.goodSlidesNull();
                    this.stopEffect();
                    ++this.gd.badImpacts;
                    if (this.gd.badImpacts == 3) {
                        this.badImpactsNull();
                        this.removeBodyPart();
                    }
                    ++this.ad.aImpacts;
                } else {
                    this.gd.acceleration = 0;
                    this.gd.goodSlidingStarter = 0;
                    this.resetDragonBall();
                    this.goodSlidesNull();
                    this.stopEffect();
                }
            } else if (this.gd.goodSlidingStarter == 1) {
                this.gd.goodSlidingStarter = 2;
            }
            this.isFlying = false;
            this.isLanding = true;
        }
    }

    public void controllerDragonBall() {
        if (this.gd.zoom == 0 && (!MainCanvas.isRotated && this.COORDS[this.dd.headShift + this.dd.halfHeadWidth] + this.dd.dragonHeadShift > this.gd.jumpHeight / 10 || MainCanvas.isRotated && this.COORDS[this.dd.headShift + this.dd.halfHeadWidth] + this.dd.dragonHeadShift > this.gd.jumpHeight / 10) || this.gd.zoom > 0) {
            if (this.gd.jumpHeight / 10 <= this.gd.ceilingDragon) {
                this.dd.headHeight = this.gd.ceilingDragon;
                if (this.gd.jumpSpeed > 0) {
                    this.zoomInc();
                }
                if (this.gd.jumpSpeed < 0) {
                    this.zoomDec();
                }
            } else {
                this.dd.headHeight = this.gd.jumpHeight / 10;
                if (this.gd.jumpSpeed < 0) {
                    this.zoomDec();
                }
            }
        } else {
            this.isWaiting = false;
            this.zoomNull();
            this.gd.maxZoom = this.gd.mainMaxZoom1;
            this.gd.goodSlidingStarter = 0;
            this.goodSlidesNull();
            this.badImpactsNull();
            if (this.gd.dragonBallJumpsAllowed == 1) {
                this.gd.dragonBallJumpsAllowed = 0;
                ++this.gd.dragonBallJumps;
                this.textSlides();
            }
            if (this.gd.dragonBallJumps >= 3) {
                this.isDragonBall = false;
                this.gd.dragonBallJumps = 0;
                this.textSlides();
            }
            this.isFlying = false;
        }
    }

    public void controllerEnd() {
        if (this.gd.jumpHeight / 10 <= this.gd.ceilingDragon) {
            this.dd.headHeight = this.gd.ceilingDragon;
            if (this.gd.jumpSpeed > 0) {
                this.zoomInc();
            }
            if (this.gd.glidingTimer == 0 && this.gd.jumpSpeed < 0) {
                this.zoomDec();
            }
        } else {
            this.dd.headHeight = this.gd.jumpHeight / 10;
            if (this.gd.jumpSpeed < 0) {
                this.zoomDec();
            }
        }
    }

    public void control1() {
        if (this.isControllable && this.COORDS[this.dd.headShift + this.dd.halfHeadWidth] <= this.COORDS[this.dd.headShift + this.dd.halfHeadWidth + (this.gd.radius >> 1)] && this.gd.updateCounter % 30 == 0) {
            this.isAccelerating = true;
        }
        if (this.isControllable && this.COORDS[this.dd.headShift + this.dd.halfHeadWidth] > this.COORDS[this.dd.headShift + this.dd.halfHeadWidth + (this.gd.radius >> 1)] && this.gd.updateCounter % 5 == 0) {
            this.isSlowingDown = true;
        }
        if (this.gd.goodSlidingStarter == 0) {
            this.goodSlidesNull();
        }
        if (this.gd.goodSlidingStarter == 1) {
            this.gd.goodSlidingStarter = 0;
            this.goodSlidesNull();
        }
        if (this.gd.goodSlidingStarter == 4) {
            this.gd.goodSlidingStarter = 5;
        } else if (this.gd.goodSlidingStarter == 3) {
            this.gd.goodSlidingStarter = 4;
        } else if (this.gd.goodSlidingStarter == 2) {
            this.gd.goodSlidingStarter = 3;
        }
        if (!(this.COORDS[this.dd.headShift + this.dd.halfHeadWidth] + this.dd.dragonHeadShift > this.dd.headHeight || this.gd.acceleration <= this.gd.mainSpeedForTakeoff || this.COORDS[this.dd.headShift + this.dd.halfHeadWidth] >= this.COORDS[this.dd.headShift + this.dd.halfHeadWidth - (this.gd.radius >> 2)] && this.COORDS[this.dd.headShift + this.dd.halfHeadWidth] >= this.COORDS[this.dd.headShift + this.dd.halfHeadWidth - (this.gd.radius >> 1)] && this.COORDS[this.dd.headShift + this.dd.halfHeadWidth] >= this.COORDS[this.dd.headShift + this.dd.halfHeadWidth - this.gd.radius] || this.COORDS[this.dd.headShift + this.dd.halfHeadWidth] > this.COORDS[this.dd.headShift + this.dd.halfHeadWidth + this.gd.radius] && this.COORDS[this.dd.headShift + this.dd.halfHeadWidth] > this.COORDS[this.dd.headShift + this.dd.halfHeadWidth + (this.gd.radius << 1)] && this.COORDS[this.dd.headShift + this.dd.halfHeadWidth] > this.COORDS[this.dd.headShift + this.dd.halfHeadWidth + (this.gd.radius << 2)])) {
            if (this.gd.goodSlidingStarter == 5) {
                this.gd.goodSlidingStarter = 0;
                this.goodSlidesInc();
                this.achievement(1, 0);
            } else {
                this.goodSlidesNull();
            }
            this.gd.goodSlidingStarter = 1;
            if (this.gd.goodSlides >= 3) {
                this.badImpactsNull();
                ++this.gd.dragonBallStarter;
                if (this.gd.dragonBallStarter >= 2) {
                    this.gd.dragonBallStarter = 0;
                    this.setDragonBall(true);
                    this.achievement(2, 1);
                    this.controlDragonBall();
                } else {
                    this.startEffect();
                }
            }
            if (this.gd.goodSlides > 0) {
                this.gd.acceleration += this.gd.acceleration >> 3;
            }
            if (this.gd.acceleration > this.gd.mainMaxAcc) {
                this.gd.acceleration = this.gd.mainMaxAcc;
            }
            this.gd.jumpSpeed = this.gd.acceleration + (this.gd.acceleration >> 1);
            this.gd.originalAcceleration = this.gd.acceleration;
            if (!(this.isPullingDownLeft || this.isPullingDownRight || this.isSliding)) {
                this.isFlying = true;
            }
        }
    }

    public void control2() {
        if (this.gd.goodSlidingStarter == 0) {
            this.goodSlidesNull();
        }
        if (this.gd.goodSlidingStarter == 1) {
            this.gd.goodSlidingStarter = 0;
            this.goodSlidesNull();
        }
        if (this.gd.goodSlidingStarter == 4) {
            this.gd.goodSlidingStarter = 5;
        } else if (this.gd.goodSlidingStarter == 3) {
            this.gd.goodSlidingStarter = 4;
        } else if (this.gd.goodSlidingStarter == 2) {
            this.gd.goodSlidingStarter = 3;
        }
        if (this.isControllable && this.COORDS[this.dd.headShift + this.dd.halfHeadWidth] <= this.COORDS[this.dd.headShift + this.dd.halfHeadWidth + this.gd.radius]) {
            this.isAccelerating = true;
        }
        if (this.isControllable && this.COORDS[this.dd.headShift + this.dd.halfHeadWidth] > this.COORDS[this.dd.headShift + this.dd.halfHeadWidth + this.gd.radius] && this.COORDS[this.dd.headShift + this.dd.halfHeadWidth] < this.COORDS[this.dd.headShift + this.dd.halfHeadWidth - this.gd.radius] && this.gd.acceleration >= 3) {
            this.gd.acceleration -= 3;
        }
    }

    public void controlDragonBall() {
        this.gd.acceleration += this.gd.mainMaxAcc - this.gd.acceleration >> 1;
        if (this.gd.acceleration > this.gd.mainMaxAcc) {
            this.gd.acceleration = this.gd.mainMaxAcc;
        }
        this.gd.jumpSpeed = this.gd.acceleration << 1;
        this.gd.originalAcceleration = this.gd.acceleration;
        this.gd.dragonBallJumpsAllowed = 1;
        if (!(this.isPullingDownLeft || this.isPullingDownRight || this.isSliding)) {
            this.isFlying = true;
        }
    }

    public void control() {
        this.dd.headHeight = this.COORDS[this.dd.headShift + this.dd.halfHeadWidth] + this.dd.dragonHeadShift;
        if (!this.isDragonBall) {
            if (!this.isPressedAction) {
                this.control1();
            } else {
                this.control2();
            }
        } else {
            this.controlDragonBall();
        }
        if (this.gd.updateCounter % 120 == 0 && this.gd.acceleration >= 5 && !this.isEnd && !this.isGeneratedEnd) {
            --this.gd.acceleration;
        }
    }

    public void startEffect() {
        this.isEffect = true;
    }

    public void stopEffect() {
        if (!this.isEnd && !this.isDragonBall) {
            this.isEffect = false;
        }
    }

    public void roll0() {
        int i;
        if (this.gd.cursorX > 0) {
            this.gd.move = this.gd.mainSpeed + (this.gd.acceleration >> 2);
            this.gd.cursorX -= this.gd.move;
            this.gd.distance += this.gd.move;
            this.achievement(1, 2);
            this.achievement(1, 4);
        }
        for (i = this.gd.move; i < this.maxCoords; ++i) {
            this.COORDS[i - this.gd.move] = this.COORDS[i];
            this.ITEMS[i - this.gd.move] = this.ITEMS[i];
            this.ITEMS_HEIGHT[i - this.gd.move] = this.ITEMS_HEIGHT[i];
        }
        for (i = this.maxCoords - this.gd.move; i < this.maxCoords; ++i) {
            this.COORDS[i] = -9999;
            this.ITEMS[i] = -9999;
            this.ITEMS_HEIGHT[i] = -9999;
        }
        for (i = this.gd.move; i < MainCanvas.WIDTH; ++i) {
            if (this.ITEMS_DISAPPEARING_STEPS[i] == -9999) continue;
            this.ITEMS_DISAPPEARING_STEPS[i - this.gd.move] = this.ITEMS_DISAPPEARING_STEPS[i];
        }
        for (i = MainCanvas.WIDTH - this.gd.move; i < MainCanvas.WIDTH; ++i) {
            this.ITEMS_DISAPPEARING_STEPS[i] = -9999;
        }
    }

    public void roll1() {
        if (this.gd.cursorX <= this.maxCoords >> 1) {
            if (!this.isLevelEnd) {
                if (this.maxCoords - this.gd.cursorX > this.gd.size5 << 1) {
                    if (this.gd.direction > 0) {
                        if (this.gd.cursorY > this.gd.floor) {
                            this.gd.direction = -this.gd.direction;
                        }
                    } else if (this.gd.cursorY < this.gd.ceiling) {
                        this.gd.direction = -this.gd.direction;
                    }
                    this.generateHills();
                }
            } else if (!this.isGeneratingLastHill) {
                if (this.gd.cursorY < this.gd.floor && this.gd.cursorY > this.gd.ceiling) {
                    if (this.maxCoords - this.gd.cursorX > this.gd.floor - this.gd.cursorY << 1) {
                        if (this.gd.direction < 0) {
                            if (this.gd.floor - this.gd.cursorY > this.gd.size3) {
                                this.gd.direction = 1;
                                this.generateCurve(this.gd.floor - this.gd.cursorY << 1, this.gd.floor - this.gd.cursorY);
                            }
                            this.isGeneratingLastHill = true;
                            this.gd.generatingLastHill = 0;
                        } else if (this.gd.direction > 0) {
                            this.generateCurve(this.gd.floor - this.gd.cursorY << 1, this.gd.floor - this.gd.cursorY);
                            this.isGeneratingLastHill = true;
                            this.gd.generatingLastHill = 0;
                        }
                    }
                } else {
                    this.isGeneratingLastHill = true;
                    this.gd.generatingLastHill = 0;
                }
            } else if (this.gd.generatingLastHill == 0) {
                if (this.maxCoords - this.gd.cursorX > this.gd.cursorY - this.gd.ceiling << 1) {
                    this.generateLastHill1();
                }
            } else if (this.gd.generatingLastHill == 1) {
                if (this.maxCoords - this.gd.cursorX > this.gd.floor - this.gd.cursorY << 2) {
                    this.generateLastHill2();
                }
            } else if (this.gd.generatingLastHill == 2 && this.maxCoords - this.gd.cursorX > this.gd.size3 << 2) {
                this.generateLastHill3();
            }
        }
    }

    public void generateLastHill1() {
        this.gd.lastX = this.gd.cursorX;
        for (int i = 0; i < 12; ++i) {
            this.ITEMS[this.gd.cursorX + i] = 10;
        }
        this.generateCurve(this.gd.cursorY - this.gd.ceiling << 1, this.gd.cursorY - this.gd.ceiling);
        this.gd.generatingLastHill = 1;
    }

    public void generateLastHill2() {
        this.gd.lastX = this.gd.cursorX;
        this.isAddingCoins = true;
        for (int i = 0; i < 12; ++i) {
            this.ITEMS[this.gd.cursorX + i] = 11;
        }
        this.generateCurve(this.gd.floor - this.gd.cursorY << 2, this.gd.floor - this.gd.cursorY);
        this.isAddingCoins = false;
        this.gd.generatingLastHill = 2;
    }

    public void generateLastHill3() {
        int i;
        this.gd.lastX = this.gd.cursorX;
        for (i = 0; i < 12; ++i) {
            this.ITEMS[this.gd.cursorX + i] = 12;
        }
        this.ITEMS[this.gd.cursorX + (this.gd.radius << 1)] = 1;
        this.isLastCurve = true;
        this.generateCurve(this.gd.size4 << 2, this.gd.size5);
        for (i = 0; i < 12; ++i) {
            this.ITEMS[this.gd.cursorX + i] = 13;
        }
        this.isLastCurve = false;
        this.isGeneratedEnd = true;
        this.gd.generatingLastHill = 3;
    }

    public void generateCurve(int curveWidth, int curveHeight) {
        if (!this.isGeneratedEnd && (this.gd.direction > 0 && this.gd.cursorY <= this.gd.floor && this.gd.floor - this.gd.cursorY >= curveHeight >> 1 || this.gd.direction < 0 && this.gd.cursorY >= this.gd.ceiling && this.gd.cursorY - this.gd.ceiling >= curveHeight >> 1)) {
            int cWidth = curveWidth;
            int cHeight = curveHeight;
            if (cWidth % 2 != 0) {
                ++cWidth;
                ++cHeight;
            }
            if (cHeight % 2 != 0) {
                ++cHeight;
                cWidth += 2;
            }
            int ymid = this.gd.direction > 0 ? this.gd.cursorY + this.gd.cursorY + cHeight >> 1 : this.gd.cursorY + this.gd.cursorY - cHeight >> 1;
            int ampl = cHeight >> 1;
            if (!this.isLastCurve) {
                for (int i = 0; i < cWidth + 1; i += this.gd.hillsPartWidth) {
                    this.gd.cursorY = this.gd.direction > 0 ? (int)((double)ymid - (double)ampl * Math.cos(Math.PI * (double)i / (double)cWidth)) : (int)((double)ymid + (double)ampl * Math.cos(Math.PI * (double)i / (double)cWidth));
                    this.COORDS[this.gd.cursorX] = this.gd.cursorY;
                    if (this.isAddingCoins) {
                        this.generateCoins();
                    } else if (this.isAddingClocks) {
                        this.generateClocks();
                    } else if (!this.isLevelEnd) {
                        this.generateItems();
                    }
                    if (this.gd.hillsPartWidth > 1) {
                        for (int j = 0; j < this.gd.hillsPartWidth - 1; ++j) {
                            ++this.gd.cursorX;
                            this.COORDS[this.gd.cursorX] = this.gd.cursorY;
                            if (this.isAddingCoins) {
                                this.generateCoins();
                                continue;
                            }
                            if (this.isAddingClocks) {
                                this.generateClocks();
                                continue;
                            }
                            if (this.isLevelEnd) continue;
                            this.generateItems();
                        }
                    }
                    ++this.gd.cursorX;
                }
            } else {
                for (int i = 0; i < (cWidth >> 1) + 1; i += this.gd.hillsPartWidth) {
                    this.gd.cursorY = this.gd.direction > 0 ? (int)((double)ymid - (double)ampl * Math.cos(Math.PI * (double)i / (double)cWidth)) : (int)((double)ymid + (double)ampl * Math.cos(Math.PI * (double)i / (double)cWidth));
                    this.COORDS[this.gd.cursorX] = this.gd.cursorY;
                    if (this.gd.hillsPartWidth > 1) {
                        for (int j = 0; j < this.gd.hillsPartWidth - 1; ++j) {
                            ++this.gd.cursorX;
                            this.COORDS[this.gd.cursorX] = this.gd.cursorY;
                        }
                    }
                    ++this.gd.cursorX;
                }
            }
            this.gd.direction = -this.gd.direction;
        }
    }

    public void generateItems() {
        if (this.gd.cursorX > this.dd.headShift << 1 && this.gd.cursorX % (this.gd.radius + (this.gd.radius << 1)) == 0) {
            int selection = RandomNum.getRandomUInt(10);
            if (selection == 0 && this.isCoins) {
                this.ITEMS[this.gd.cursorX] = 0;
            } else if (selection == 1 && this.isEnergy) {
                if (RandomNum.getRandomUInt(16) == 0) {
                    this.ITEMS[this.gd.cursorX] = 1;
                }
            } else if (selection == 2 && this.isSushi) {
                if (RandomNum.getRandomUInt(24) == 0) {
                    this.ITEMS[this.gd.cursorX] = 2;
                }
            } else if (selection == 3 && this.isClock && this.isGeneratingClocks && RandomNum.getRandomUInt(10) == 0) {
                this.ITEMS[this.gd.cursorX] = 3;
                this.ITEMS_HEIGHT[this.gd.cursorX] = RandomNum.getRandomUInt((this.COORDS[this.gd.cursorX] >> 1) + (this.COORDS[this.gd.cursorX] >> 2));
            }
        }
    }

    public void generateCoins() {
        if (this.gd.cursorX > this.dd.headShift << 1 && this.gd.cursorX % (this.gd.radius + (this.gd.radius << 1)) == 0) {
            this.ITEMS[this.gd.cursorX] = 0;
        }
    }

    public void generateClocks() {
        if (this.gd.generatedClocks < 3) {
            if (this.gd.cursorX > this.dd.headShift << 1 && this.gd.cursorX % ((this.gd.radius << 2) + this.gd.radius) == 0) {
                this.ITEMS[this.gd.cursorX] = 3;
                this.ITEMS_HEIGHT[this.gd.cursorX] = 100;
                ++this.gd.generatedClocks;
            }
        } else {
            this.isAddedClocks = true;
            this.isAddingClocks = false;
            this.gd.generatedClocks = 0;
        }
    }

    public void generateHills() {
        int differenceY = this.gd.direction > 0 ? this.gd.floor - this.gd.cursorY : this.gd.cursorY - this.gd.ceiling;
        this.gd.lastX = this.gd.cursorX;
        if (this.gd.level == 0) {
            if (this.gd.distance < this.gd.mainLevelLength >> 1) {
                if (differenceY > this.gd.size3 >> 1) {
                    this.level1a();
                }
            } else {
                int selection = RandomNum.getRandomUInt(5);
                if (selection == 0) {
                    if (differenceY > this.gd.size4 >> 1) {
                        this.level1b();
                    }
                } else if (differenceY > this.gd.size3 >> 1) {
                    this.level1a();
                }
            }
        }
        if (this.gd.level == 1 && differenceY > this.gd.size4 >> 1) {
            this.level2();
        }
        if (this.gd.level == 2 && differenceY > this.gd.size4 >> 1) {
            this.level3();
        }
        if (this.gd.level == 3 && differenceY > this.gd.size4 >> 1) {
            this.level4();
        }
        if (this.gd.level == 4) {
            this.level5();
        }
        if (this.gd.level == 5) {
            if (this.gd.cursorY + (this.gd.size0 >> 2) > this.gd.floor) {
                this.initLevel6();
            }
            if (this.gd.direction > 0) {
                differenceY = this.gd.floor - this.gd.cursorY;
            }
            if (this.gd.direction < 0) {
                differenceY = this.gd.cursorY - this.gd.ceiling;
            }
            if (differenceY > this.gd.size3 >> 1) {
                this.level6a();
            } else if (differenceY > this.gd.size2 >> 1) {
                this.level6b();
            } else if (differenceY > this.gd.size1 >> 1) {
                this.level6c();
            }
        }
        if (this.gd.level == 6) {
            if (this.gd.direction > 0 && this.gd.cursorY + (this.gd.size3 >> 1) > this.gd.floor) {
                this.gd.direction = -1;
                differenceY = this.gd.cursorY - this.gd.ceiling;
            }
            if (this.gd.direction < 0 && this.gd.cursorY - (this.gd.size3 >> 1) < this.gd.ceiling) {
                this.gd.direction = 1;
                differenceY = this.gd.floor - this.gd.cursorY;
            }
            if (differenceY > this.gd.size3 >> 1) {
                this.level7a();
            } else if (differenceY > this.gd.size2 >> 1) {
                this.level7b();
            } else if (differenceY > this.gd.size1 >> 1) {
                this.level7c();
            }
        }
        if (this.gd.level == 7) {
            this.level8();
        }
        if (this.gd.level == 8) {
            if (this.gd.direction > 0 && this.gd.cursorY + (this.gd.size4 >> 1) > this.gd.floor) {
                this.gd.direction = -1;
                differenceY = this.gd.cursorY - this.gd.ceiling;
            }
            if (this.gd.direction < 0 && this.gd.cursorY - (this.gd.size4 >> 1) < this.gd.ceiling) {
                this.gd.direction = 1;
                differenceY = this.gd.floor - this.gd.cursorY;
            }
            if (differenceY > this.gd.size4 >> 1) {
                this.level9a();
            } else if (differenceY > this.gd.size3 >> 1) {
                this.level9b();
            } else if (differenceY > this.gd.size2 >> 1) {
                this.level9c();
            } else if (differenceY > this.gd.size1 >> 1) {
                this.level9d();
            }
        }
        if (this.gd.level == 9) {
            if (this.gd.direction > 0 && this.gd.cursorY + (this.gd.size4 >> 1) > this.gd.floor) {
                this.gd.direction = -1;
                differenceY = this.gd.cursorY - this.gd.ceiling;
            }
            if (this.gd.direction < 0 && this.gd.cursorY - (this.gd.size4 >> 1) < this.gd.ceiling) {
                this.gd.direction = 1;
                differenceY = this.gd.floor - this.gd.cursorY;
            }
            if (differenceY > this.gd.size4 >> 1) {
                this.level10a();
            } else if (differenceY > this.gd.size3 >> 1) {
                this.level10b();
            } else if (differenceY > this.gd.size2 >> 1) {
                this.level10c();
            } else if (differenceY > this.gd.size1 >> 1) {
                this.level10d();
            }
        }
        if (this.gd.level == 10) {
            this.level11();
        }
        if (this.gd.level == 11) {
            if (this.gd.direction > 0 && this.gd.cursorY + (this.gd.size4 >> 1) > this.gd.floor) {
                this.gd.direction = -1;
                differenceY = this.gd.cursorY - this.gd.ceiling;
            }
            if (this.gd.direction < 0 && this.gd.cursorY - (this.gd.size4 >> 1) < this.gd.ceiling) {
                this.gd.direction = 1;
                differenceY = this.gd.floor - this.gd.cursorY;
            }
            if (differenceY > this.gd.size4 >> 1) {
                this.level12a();
            } else if (differenceY > this.gd.size3 >> 1) {
                this.level12b();
            } else if (differenceY > this.gd.size2 >> 1) {
                this.level12c();
            } else if (differenceY > this.gd.size1 >> 1) {
                this.level12d();
            }
        }
        if (this.gd.level == 12) {
            if (this.gd.direction > 0 && this.gd.cursorY + (this.gd.size3 >> 1) > this.gd.floor) {
                this.gd.direction = -1;
                differenceY = this.gd.cursorY - this.gd.ceiling;
            }
            if (this.gd.direction < 0 && this.gd.cursorY - (this.gd.size3 >> 1) < this.gd.ceiling) {
                this.gd.direction = 1;
                differenceY = this.gd.floor - this.gd.cursorY;
            }
            if (differenceY > this.gd.size4 >> 1) {
                this.level13a();
            } else if (differenceY > this.gd.size3 >> 1) {
                this.level13b();
            } else if (differenceY > this.gd.size2 >> 1) {
                this.level13c();
            } else if (differenceY > this.gd.size1 >> 1) {
                this.level13d();
            }
        }
        if (this.gd.level == 13) {
            if (this.gd.direction > 0 && this.gd.cursorY + (this.gd.size3 >> 1) > this.gd.floor) {
                this.gd.direction = -1;
                differenceY = this.gd.cursorY - this.gd.ceiling;
            }
            if (this.gd.direction < 0 && this.gd.cursorY - (this.gd.size3 >> 1) < this.gd.ceiling) {
                this.gd.direction = 1;
                differenceY = this.gd.floor - this.gd.cursorY;
            }
            if (differenceY > this.gd.size4 >> 1) {
                this.level14a();
            } else if (differenceY > this.gd.size3 >> 1) {
                this.level14b();
            } else if (differenceY > this.gd.size2 >> 1) {
                this.level14c();
            } else if (differenceY > this.gd.size1 >> 1) {
                this.level14d();
            }
        }
        if (this.gd.level == 14) {
            this.level15();
        }
    }

    public void level1a() {
        this.generateCurve(this.gd.size4, this.gd.size3 >> 1);
        this.generateCurve(this.gd.size4, this.gd.floor - this.gd.cursorY);
        this.generateCurve(this.gd.size3, this.gd.size2 >> 1);
        this.generateCurve(this.gd.size3, this.gd.floor - this.gd.cursorY);
    }

    public void level1b() {
        this.generateCurve(this.gd.size4, this.gd.size4 >> 1);
        this.generateCurve(this.gd.size4, this.gd.floor - this.gd.cursorY);
    }

    public void level2() {
        int selection = RandomNum.getRandomUInt(4);
        if (selection == 0) {
            this.generateCurve(this.gd.size4, this.gd.size4 >> 1);
            this.generateCurve(this.gd.size4, this.gd.floor - this.gd.cursorY);
        } else if (selection == 1) {
            this.generateCurve(this.gd.size3, this.gd.size3 >> 1);
            this.generateCurve(this.gd.size3, this.gd.floor - this.gd.cursorY);
        } else if (selection == 2) {
            this.generateCurve(this.gd.size4, this.gd.size3 >> 1);
            this.generateCurve(this.gd.size4, this.gd.floor - this.gd.cursorY);
        } else if (selection == 3) {
            this.generateCurve(this.gd.size2, this.gd.size1 >> 1);
            this.generateCurve(this.gd.size2, this.gd.floor - this.gd.cursorY);
        }
    }

    public void level3() {
        int selection = RandomNum.getRandomUInt(5);
        if (selection == 0) {
            this.generateCurve(this.gd.size4, this.gd.size4 >> 1);
            this.generateCurve(this.gd.size4, this.gd.floor - this.gd.cursorY);
        } else if (selection == 1) {
            this.generateCurve(this.gd.size3, this.gd.size3 >> 1);
            this.generateCurve(this.gd.size3, this.gd.floor - this.gd.cursorY);
        } else if (selection == 2) {
            this.generateCurve(this.gd.size4, this.gd.size3 >> 1);
            this.generateCurve(this.gd.size4, this.gd.floor - this.gd.cursorY);
        } else if (selection == 3) {
            this.generateCurve(this.gd.size2, this.gd.size1 >> 1);
            this.generateCurve(this.gd.size2, this.gd.floor - this.gd.cursorY);
        } else if (selection == 4) {
            this.generateCurve(this.gd.size3, this.gd.size4 >> 1);
            this.generateCurve(this.gd.size3, this.gd.floor - this.gd.cursorY);
        }
    }

    public void level4() {
        int selection = RandomNum.getRandomUInt(8);
        if (selection == 0) {
            this.generateCurve(this.gd.size3, this.gd.size4 >> 1);
            this.generateCurve(this.gd.size4, this.gd.floor - this.gd.cursorY);
        } else if (selection == 1) {
            this.generateCurve(this.gd.size2, this.gd.size3 >> 1);
            this.generateCurve(this.gd.size3, this.gd.floor - this.gd.cursorY);
        } else if (selection == 2) {
            this.generateCurve(this.gd.size3, this.gd.size3 >> 1);
            this.generateCurve(this.gd.size4, this.gd.floor - this.gd.cursorY);
        } else if (selection == 3) {
            this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
            this.generateCurve(this.gd.size2, this.gd.floor - this.gd.cursorY);
        } else if (selection == 4) {
            this.generateCurve(this.gd.size2, this.gd.size4 >> 1);
            this.generateCurve(this.gd.size4, this.gd.floor - this.gd.cursorY);
        } else if (selection == 5) {
            this.generateCurve(this.gd.size1, this.gd.size3 >> 1);
            this.generateCurve(this.gd.size3, this.gd.floor - this.gd.cursorY);
        } else if (selection == 6) {
            this.generateCurve(this.gd.size2, this.gd.size3 >> 1);
            this.generateCurve(this.gd.size4, this.gd.floor - this.gd.cursorY);
        } else if (selection == 7) {
            this.generateCurve(this.gd.size0, this.gd.size1 >> 1);
            this.generateCurve(this.gd.size2, this.gd.floor - this.gd.cursorY);
        }
    }

    public void level5() {
        if (this.gd.postupnost == 0) {
            this.level5a();
        } else if (this.gd.postupnost == 1) {
            this.level5b();
        } else if (this.gd.postupnost == 2) {
            this.level5b();
        } else if (this.gd.postupnost == 3) {
            this.level5a();
        } else if (this.gd.postupnost == 4) {
            this.generateCurve(this.gd.cursorY - this.gd.ceiling << 1, this.gd.cursorY - this.gd.ceiling);
            this.generateCurve(this.gd.floor - this.gd.cursorY << 1, this.gd.floor - this.gd.cursorY >> 1);
        } else if (this.gd.postupnost == 5) {
            this.generateCurve(this.gd.cursorY - this.gd.ceiling, this.gd.cursorY - this.gd.ceiling);
            this.generateCurve(this.gd.size3, this.gd.size4 >> 1);
        } else if (this.gd.postupnost == 6) {
            this.generateCurve(this.gd.size2, this.gd.size3 >> 1);
            this.generateCurve(this.gd.size2, this.gd.size3 >> 1);
        } else if (this.gd.postupnost == 7) {
            this.generateCurve(this.gd.size3, this.gd.size4 >> 1);
            this.generateCurve(this.gd.size1, this.gd.size3 >> 1);
        } else if (this.gd.postupnost == 8) {
            this.generateCurve(this.gd.cursorY - this.gd.ceiling << 1, this.gd.cursorY - this.gd.ceiling);
            this.generateCurve(this.gd.floor - this.gd.cursorY << 1, this.gd.floor - this.gd.cursorY);
        } else if (this.gd.postupnost == 9) {
            this.level5b();
        } else if (this.gd.postupnost == 10) {
            this.level5b();
        } else if (this.gd.postupnost == 11) {
            this.level5b();
        } else if (this.gd.postupnost == 12) {
            this.level5a();
        } else if (this.gd.postupnost == 13) {
            this.level5a();
        } else if (this.gd.postupnost == 14) {
            this.level5b();
        } else if (this.gd.postupnost == 15) {
            this.level5a();
        } else if (this.gd.postupnost == 16) {
            this.level5b();
        } else if (this.gd.postupnost == 17) {
            this.generateCurve(this.gd.cursorY - this.gd.ceiling << 1, this.gd.cursorY - this.gd.ceiling);
            this.generateCurve(this.gd.floor - this.gd.cursorY << 1, this.gd.floor - this.gd.cursorY >> 1);
        } else if (this.gd.postupnost == 18) {
            this.generateCurve(this.gd.cursorY - this.gd.ceiling, this.gd.cursorY - this.gd.ceiling);
            this.generateCurve(this.gd.size3, this.gd.size4 >> 1);
        } else if (this.gd.postupnost == 19) {
            this.generateCurve(this.gd.size2, this.gd.size3 >> 1);
            this.generateCurve(this.gd.size2, this.gd.size4 >> 1);
        } else if (this.gd.postupnost == 20) {
            this.generateCurve(this.gd.cursorY - this.gd.ceiling << 1, this.gd.cursorY - this.gd.ceiling);
            this.generateCurve(this.gd.floor - this.gd.cursorY << 1, this.gd.floor - this.gd.cursorY);
        } else if (this.gd.postupnost == 21) {
            this.level5b();
        } else if (this.gd.postupnost == 22) {
            this.level5b();
        } else if (this.gd.postupnost == 23) {
            this.level5a();
        } else if (this.gd.postupnost == 24) {
            this.level5a();
        } else if (this.gd.postupnost == 25) {
            this.level5a();
        } else if (this.gd.postupnost == 26) {
            this.level5b();
        } else if (this.gd.postupnost == 27) {
            this.level5a();
        } else if (this.gd.postupnost == 28) {
            this.level5b();
        } else if (this.gd.postupnost == 29) {
            this.level5b();
        } else if (this.gd.postupnost == 30) {
            this.level5a();
        }
        ++this.gd.postupnost;
        if (this.gd.postupnost > 30) {
            this.gd.postupnost = 0;
        }
    }

    public void level5a() {
        int selection = RandomNum.getRandomUInt(5);
        if (selection == 0) {
            this.generateCurve(this.gd.size4, this.gd.size4 >> 1);
            this.generateCurve(this.gd.size4, this.gd.floor - this.gd.cursorY);
        } else if (selection == 1) {
            this.generateCurve(this.gd.size3, this.gd.size3 >> 1);
            this.generateCurve(this.gd.size3, this.gd.floor - this.gd.cursorY);
        } else if (selection == 2) {
            this.generateCurve(this.gd.size4, this.gd.size3 >> 1);
            this.generateCurve(this.gd.size4, this.gd.floor - this.gd.cursorY);
        } else if (selection == 3) {
            this.generateCurve(this.gd.size2, this.gd.size1 >> 1);
            this.generateCurve(this.gd.size2, this.gd.floor - this.gd.cursorY);
        } else if (selection == 4) {
            this.generateCurve(this.gd.size3, this.gd.size4 >> 1);
            this.generateCurve(this.gd.size3, this.gd.floor - this.gd.cursorY);
        }
    }

    public void level5b() {
        int selection = RandomNum.getRandomUInt(8);
        if (selection == 0) {
            this.generateCurve(this.gd.size3, this.gd.size4 >> 1);
            this.generateCurve(this.gd.size4, this.gd.floor - this.gd.cursorY);
        } else if (selection == 1) {
            this.generateCurve(this.gd.size2, this.gd.size3 >> 1);
            this.generateCurve(this.gd.size3, this.gd.floor - this.gd.cursorY);
        } else if (selection == 2) {
            this.generateCurve(this.gd.size3, this.gd.size3 >> 1);
            this.generateCurve(this.gd.size4, this.gd.floor - this.gd.cursorY);
        } else if (selection == 3) {
            this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
            this.generateCurve(this.gd.size2, this.gd.floor - this.gd.cursorY);
        } else if (selection == 4) {
            this.generateCurve(this.gd.size2, this.gd.size4 >> 1);
            this.generateCurve(this.gd.size4, this.gd.floor - this.gd.cursorY);
        } else if (selection == 5) {
            this.generateCurve(this.gd.size1, this.gd.size3 >> 1);
            this.generateCurve(this.gd.size3, this.gd.floor - this.gd.cursorY);
        } else if (selection == 6) {
            this.generateCurve(this.gd.size2, this.gd.size3 >> 1);
            this.generateCurve(this.gd.size4, this.gd.floor - this.gd.cursorY);
        } else if (selection == 7) {
            this.generateCurve(this.gd.size0, this.gd.size1 >> 1);
            this.generateCurve(this.gd.size2, this.gd.floor - this.gd.cursorY);
        }
    }

    public void level6a() {
        int selection = RandomNum.getRandomUInt(10);
        if (selection == 0) {
            this.generateCurve(this.gd.size3, this.gd.size2 >> 1);
            this.generateCurve(this.gd.size3, this.gd.size3 >> 1);
        } else if (selection == 1) {
            this.generateCurve(this.gd.size2, this.gd.size1 >> 1);
            this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
        } else if (selection == 2) {
            this.generateCurve(this.gd.size1, this.gd.size0 >> 1);
            this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
        } else if (selection == 3) {
            this.generateCurve(this.gd.size4, this.gd.size2 >> 1);
            this.generateCurve(this.gd.size4, this.gd.size3 >> 1);
        } else if (selection == 4) {
            this.generateCurve(this.gd.size3, this.gd.size1 >> 1);
            this.generateCurve(this.gd.size3, this.gd.size2 >> 1);
        } else if (selection == 5) {
            this.generateCurve(this.gd.size2, this.gd.size0 >> 1);
            this.generateCurve(this.gd.size2, this.gd.size1 >> 1);
        } else if (selection == 6) {
            this.generateCurve(this.gd.size3, this.gd.size3 >> 1);
            this.generateCurve(this.gd.size3, this.gd.size3 >> 1);
        } else if (selection == 7) {
            this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
            this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
        } else if (selection == 8) {
            this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
            this.generateCurve(this.gd.size2, this.gd.size3 >> 1);
        } else if (selection == 9) {
            this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
            this.generateCurve(this.gd.size1, this.gd.size2 >> 1);
        }
    }

    public void level6b() {
        int selection = RandomNum.getRandomUInt(6);
        if (selection == 0) {
            this.generateCurve(this.gd.size2, this.gd.size1 >> 1);
            this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
        } else if (selection == 1) {
            this.generateCurve(this.gd.size1, this.gd.size0 >> 1);
            this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
        } else if (selection == 2) {
            this.generateCurve(this.gd.size3, this.gd.size1 >> 1);
            this.generateCurve(this.gd.size3, this.gd.size2 >> 1);
        } else if (selection == 3) {
            this.generateCurve(this.gd.size2, this.gd.size0 >> 1);
            this.generateCurve(this.gd.size2, this.gd.size1 >> 1);
        } else if (selection == 4) {
            this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
            this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
        } else if (selection == 5) {
            this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
            this.generateCurve(this.gd.size1, this.gd.size2 >> 1);
        }
    }

    public void level6c() {
        int selection = RandomNum.getRandomUInt(2);
        if (selection == 0) {
            this.generateCurve(this.gd.size1, this.gd.size0 >> 1);
            this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
        } else if (selection == 1) {
            this.generateCurve(this.gd.size2, this.gd.size0 >> 1);
            this.generateCurve(this.gd.size2, this.gd.size1 >> 1);
        }
    }

    public void level7a() {
        int selection = RandomNum.getRandomUInt(10);
        if (selection == 0) {
            this.generateCurve(this.gd.size3, this.gd.size3 >> 1);
            this.generateCurve(this.gd.size3, this.gd.size2 >> 1);
        } else if (selection == 1) {
            this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
            this.generateCurve(this.gd.size2, this.gd.size1 >> 1);
        } else if (selection == 2) {
            this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
            this.generateCurve(this.gd.size1, this.gd.size0 >> 1);
        } else if (selection == 3) {
            this.generateCurve(this.gd.size4, this.gd.size3 >> 1);
            this.generateCurve(this.gd.size4, this.gd.size2 >> 1);
        } else if (selection == 4) {
            this.generateCurve(this.gd.size3, this.gd.size2 >> 1);
            this.generateCurve(this.gd.size3, this.gd.size1 >> 1);
        } else if (selection == 5) {
            this.generateCurve(this.gd.size2, this.gd.size1 >> 1);
            this.generateCurve(this.gd.size2, this.gd.size0 >> 1);
        } else if (selection == 6) {
            this.generateCurve(this.gd.size3, this.gd.size3 >> 1);
            this.generateCurve(this.gd.size3, this.gd.floor - this.gd.cursorY);
        } else if (selection == 7) {
            this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
            this.generateCurve(this.gd.size2, this.gd.floor - this.gd.cursorY);
        } else if (selection == 8) {
            this.generateCurve(this.gd.size2, this.gd.size3 >> 1);
            this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
        } else if (selection == 9) {
            this.generateCurve(this.gd.size1, this.gd.size2 >> 1);
            this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
        }
    }

    public void level7b() {
        int selection = RandomNum.getRandomUInt(6);
        if (selection == 0) {
            this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
            this.generateCurve(this.gd.size2, this.gd.size1 >> 1);
        } else if (selection == 1) {
            this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
            this.generateCurve(this.gd.size1, this.gd.size0 >> 1);
        } else if (selection == 2) {
            this.generateCurve(this.gd.size3, this.gd.size2 >> 1);
            this.generateCurve(this.gd.size3, this.gd.size1 >> 1);
        } else if (selection == 3) {
            this.generateCurve(this.gd.size2, this.gd.size1 >> 1);
            this.generateCurve(this.gd.size2, this.gd.size0 >> 1);
        } else if (selection == 4) {
            this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
            this.generateCurve(this.gd.size2, this.gd.floor - this.gd.cursorY);
        } else if (selection == 5) {
            this.generateCurve(this.gd.size1, this.gd.size2 >> 1);
            this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
        }
    }

    public void level7c() {
        int selection = RandomNum.getRandomUInt(2);
        if (selection == 0) {
            this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
            this.generateCurve(this.gd.size1, this.gd.size0 >> 1);
        } else if (selection == 1) {
            this.generateCurve(this.gd.size2, this.gd.size1 >> 1);
            this.generateCurve(this.gd.size2, this.gd.size0 >> 1);
        }
    }

    public void level8() {
        if (this.gd.postupnost == 0) {
            this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
            this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
        } else if (this.gd.postupnost == 1) {
            this.generateCurve(this.gd.size3, this.gd.size3 >> 1);
            this.generateCurve(this.gd.size2, this.gd.size3 >> 1);
        } else if (this.gd.postupnost == 2) {
            this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
            this.generateCurve(this.gd.size0, this.gd.size1 >> 1);
        } else if (this.gd.postupnost == 3) {
            this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
            this.generateCurve(this.gd.size1, this.gd.size2 >> 1);
        } else if (this.gd.postupnost == 4) {
            this.generateCurve(this.gd.size2, this.gd.size4 >> 1);
            this.generateCurve(this.gd.size4, this.gd.size4 >> 1);
        } else if (this.gd.postupnost == 5) {
            this.generateCurve(this.gd.size4, this.gd.size4 >> 1);
            this.generateCurve(this.gd.size4, this.gd.floor - this.gd.cursorY);
        } else if (this.gd.postupnost == 6) {
            this.generateCurve(this.gd.size4, this.gd.size4 >> 1);
            this.generateCurve(this.gd.size2, this.gd.size4 >> 1);
        } else if (this.gd.postupnost == 7) {
            this.generateCurve(this.gd.size3, this.gd.size3 >> 1);
            this.generateCurve(this.gd.size3, this.gd.size3 >> 1);
        } else if (this.gd.postupnost == 8) {
            this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
            this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
        } else if (this.gd.postupnost == 9) {
            this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
            this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
        } else if (this.gd.postupnost == 10) {
            this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
            this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
        } else if (this.gd.postupnost == 11) {
            this.generateCurve(this.gd.size3, this.gd.size3 >> 1);
            this.generateCurve(this.gd.size3, this.gd.size3 >> 1);
        } else if (this.gd.postupnost == 12) {
            this.generateCurve(this.gd.size2, this.gd.size4 >> 1);
            this.generateCurve(this.gd.size4, this.gd.size4 >> 1);
        } else if (this.gd.postupnost == 13) {
            this.generateCurve(this.gd.size4, this.gd.size4 >> 1);
            this.generateCurve(this.gd.size4, this.gd.floor - this.gd.cursorY);
        } else if (this.gd.postupnost == 14) {
            this.generateCurve(this.gd.size4, this.gd.size4 >> 1);
            this.generateCurve(this.gd.size2, this.gd.size4 >> 1);
        } else if (this.gd.postupnost == 15) {
            this.generateCurve(this.gd.size3, this.gd.size3 >> 1);
            this.generateCurve(this.gd.size2, this.gd.size3 >> 1);
        } else if (this.gd.postupnost == 16) {
            this.generateCurve(this.gd.size3, this.gd.size3 >> 1);
            this.generateCurve(this.gd.size2, this.gd.size3 >> 1);
        } else if (this.gd.postupnost == 17) {
            this.generateCurve(this.gd.size3, this.gd.size3 >> 1);
            this.generateCurve(this.gd.size2, this.gd.size3 >> 1);
        } else if (this.gd.postupnost == 18) {
            this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
            this.generateCurve(this.gd.size1, this.gd.size2 >> 1);
        } else if (this.gd.postupnost == 19) {
            this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
            this.generateCurve(this.gd.size1, this.gd.size2 >> 1);
        } else if (this.gd.postupnost == 20) {
            this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
            this.generateCurve(this.gd.size1, this.gd.size2 >> 1);
        } else if (this.gd.postupnost == 21) {
            this.generateCurve(this.gd.size4, this.gd.size4 >> 1);
            this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
        } else if (this.gd.postupnost == 22) {
            this.generateCurve(this.gd.size4, this.gd.size4 >> 1);
            this.generateCurve(this.gd.size2, this.gd.size3 >> 1);
        } else if (this.gd.postupnost == 23) {
            this.generateCurve(this.gd.size2, this.gd.size3 >> 1);
            this.generateCurve(this.gd.size4, this.gd.size4 >> 1);
        } else if (this.gd.postupnost == 24) {
            this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
            this.generateCurve(this.gd.size4, this.gd.size4 >> 1);
        } else if (this.gd.postupnost == 25) {
            this.generateCurve(this.gd.size3, this.gd.size3 >> 1);
            this.generateCurve(this.gd.size2, this.gd.size3 >> 1);
        } else if (this.gd.postupnost == 26) {
            this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
            this.generateCurve(this.gd.size0, this.gd.size1 >> 1);
        } else if (this.gd.postupnost == 27) {
            this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
            this.generateCurve(this.gd.size1, this.gd.size2 >> 1);
        } else if (this.gd.postupnost == 28) {
            this.generateCurve(this.gd.size2, this.gd.size4 >> 1);
            this.generateCurve(this.gd.size4, this.gd.size4 >> 1);
        } else if (this.gd.postupnost == 29) {
            this.generateCurve(this.gd.size4, this.gd.size4 >> 1);
            this.generateCurve(this.gd.size4, this.gd.floor - this.gd.cursorY);
        } else if (this.gd.postupnost == 30) {
            this.generateCurve(this.gd.size4, this.gd.size4 >> 1);
            this.generateCurve(this.gd.size2, this.gd.size4 >> 1);
        }
        ++this.gd.postupnost;
        if (this.gd.postupnost > 30) {
            this.gd.postupnost = 0;
        }
    }

    public void level9a() {
        block12: {
            int selection;
            block14: {
                block13: {
                    block11: {
                        selection = RandomNum.getRandomUInt(4);
                        if (selection != 0) break block11;
                        for (int i = 0; i < 2; ++i) {
                            int selection2 = RandomNum.getRandomUInt(2);
                            if (selection2 == 0) {
                                this.generateCurve(this.gd.size3, this.gd.size4 >> 1);
                                continue;
                            }
                            if (selection2 != 1) continue;
                            this.generateCurve(this.gd.size4, this.gd.size4 >> 1);
                        }
                        break block12;
                    }
                    if (selection != 1) break block13;
                    for (int i = 0; i < 2; ++i) {
                        int selection2 = RandomNum.getRandomUInt(3);
                        if (selection2 == 0) {
                            this.generateCurve(this.gd.size2, this.gd.size3 >> 1);
                            continue;
                        }
                        if (selection2 == 1) {
                            this.generateCurve(this.gd.size3, this.gd.size3 >> 1);
                            continue;
                        }
                        if (selection2 != 2) continue;
                        this.generateCurve(this.gd.size4, this.gd.size3 >> 1);
                    }
                    break block12;
                }
                if (selection != 2) break block14;
                for (int i = 0; i < 2; ++i) {
                    int selection2 = RandomNum.getRandomUInt(3);
                    if (selection2 == 0) {
                        this.generateCurve(this.gd.size1, this.gd.size2 >> 1);
                        continue;
                    }
                    if (selection2 == 1) {
                        this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
                        continue;
                    }
                    if (selection2 != 2) continue;
                    this.generateCurve(this.gd.size3, this.gd.size2 >> 1);
                }
                break block12;
            }
            if (selection != 3) break block12;
            for (int i = 0; i < 2; ++i) {
                int selection2 = RandomNum.getRandomUInt(3);
                if (selection2 == 0) {
                    this.generateCurve(this.gd.size0, this.gd.size1 >> 1);
                    continue;
                }
                if (selection2 == 1) {
                    this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
                    continue;
                }
                if (selection2 != 2) continue;
                this.generateCurve(this.gd.size2, this.gd.size1 >> 1);
            }
        }
    }

    public void level9b() {
        block9: {
            int selection;
            block10: {
                block8: {
                    selection = RandomNum.getRandomUInt(3);
                    if (selection != 0) break block8;
                    for (int i = 0; i < 2; ++i) {
                        int selection2 = RandomNum.getRandomUInt(3);
                        if (selection2 == 0) {
                            this.generateCurve(this.gd.size2, this.gd.size3 >> 1);
                            continue;
                        }
                        if (selection2 == 1) {
                            this.generateCurve(this.gd.size3, this.gd.size3 >> 1);
                            continue;
                        }
                        if (selection2 != 2) continue;
                        this.generateCurve(this.gd.size4, this.gd.size3 >> 1);
                    }
                    break block9;
                }
                if (selection != 1) break block10;
                for (int i = 0; i < 2; ++i) {
                    int selection2 = RandomNum.getRandomUInt(3);
                    if (selection2 == 0) {
                        this.generateCurve(this.gd.size1, this.gd.size2 >> 1);
                        continue;
                    }
                    if (selection2 == 1) {
                        this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
                        continue;
                    }
                    if (selection2 != 2) continue;
                    this.generateCurve(this.gd.size3, this.gd.size2 >> 1);
                }
                break block9;
            }
            if (selection != 2) break block9;
            for (int i = 0; i < 2; ++i) {
                int selection2 = RandomNum.getRandomUInt(2);
                if (selection2 == 0) {
                    this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
                    continue;
                }
                if (selection2 != 1) continue;
                this.generateCurve(this.gd.size2, this.gd.size1 >> 1);
            }
        }
    }

    public void level9c() {
        block6: {
            int selection;
            block5: {
                selection = RandomNum.getRandomUInt(2);
                if (selection != 0) break block5;
                for (int i = 0; i < 2; ++i) {
                    int selection2 = RandomNum.getRandomUInt(3);
                    if (selection2 == 0) {
                        this.generateCurve(this.gd.size1, this.gd.size2 >> 1);
                        continue;
                    }
                    if (selection2 == 1) {
                        this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
                        continue;
                    }
                    if (selection2 != 2) continue;
                    this.generateCurve(this.gd.size3, this.gd.size2 >> 1);
                }
                break block6;
            }
            if (selection != 1) break block6;
            for (int i = 0; i < 2; ++i) {
                int selection2 = RandomNum.getRandomUInt(2);
                if (selection2 == 0) {
                    this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
                    continue;
                }
                if (selection2 != 1) continue;
                this.generateCurve(this.gd.size2, this.gd.size1 >> 1);
            }
        }
    }

    public void level9d() {
        for (int i = 0; i < 2; ++i) {
            int selection2 = RandomNum.getRandomUInt(2);
            if (selection2 == 0) {
                this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
                continue;
            }
            if (selection2 != 1) continue;
            this.generateCurve(this.gd.size2, this.gd.size1 >> 1);
        }
    }

    public void level10a() {
        block14: {
            int selection;
            block16: {
                block15: {
                    block13: {
                        selection = RandomNum.getRandomUInt(4);
                        if (selection != 0) break block13;
                        for (int i = 0; i < 2; ++i) {
                            int selection2 = RandomNum.getRandomUInt(3);
                            if (selection2 == 0) {
                                this.generateCurve(this.gd.size2, this.gd.size4 >> 1);
                                continue;
                            }
                            if (selection2 == 1) {
                                this.generateCurve(this.gd.size3, this.gd.size4 >> 1);
                                continue;
                            }
                            if (selection2 != 2) continue;
                            this.generateCurve(this.gd.size4, this.gd.size4 >> 1);
                        }
                        break block14;
                    }
                    if (selection != 1) break block15;
                    for (int i = 0; i < 2; ++i) {
                        int selection2 = RandomNum.getRandomUInt(4);
                        if (selection2 == 0) {
                            this.generateCurve(this.gd.size1, this.gd.size3 >> 1);
                            continue;
                        }
                        if (selection2 == 1) {
                            this.generateCurve(this.gd.size2, this.gd.size3 >> 1);
                            continue;
                        }
                        if (selection2 == 2) {
                            this.generateCurve(this.gd.size3, this.gd.size3 >> 1);
                            continue;
                        }
                        if (selection2 != 3) continue;
                        this.generateCurve(this.gd.size4, this.gd.size3 >> 1);
                    }
                    break block14;
                }
                if (selection != 2) break block16;
                for (int i = 0; i < 2; ++i) {
                    int selection2 = RandomNum.getRandomUInt(3);
                    if (selection2 == 0) {
                        this.generateCurve(this.gd.size1, this.gd.size2 >> 1);
                        continue;
                    }
                    if (selection2 == 1) {
                        this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
                        continue;
                    }
                    if (selection2 != 2) continue;
                    this.generateCurve(this.gd.size3, this.gd.size2 >> 1);
                }
                break block14;
            }
            if (selection != 3) break block14;
            for (int i = 0; i < 2; ++i) {
                int selection2 = RandomNum.getRandomUInt(3);
                if (selection2 == 0) {
                    this.generateCurve(this.gd.size0, this.gd.size1 >> 1);
                    continue;
                }
                if (selection2 == 1) {
                    this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
                    continue;
                }
                if (selection2 != 2) continue;
                this.generateCurve(this.gd.size2, this.gd.size1 >> 1);
            }
        }
    }

    public void level10b() {
        block11: {
            int selection;
            block12: {
                block10: {
                    selection = RandomNum.getRandomUInt(3);
                    if (selection != 0) break block10;
                    for (int i = 0; i < 2; ++i) {
                        int selection2 = RandomNum.getRandomUInt(4);
                        if (selection2 == 0) {
                            this.generateCurve(this.gd.size1, this.gd.size3 >> 1);
                            continue;
                        }
                        if (selection2 == 1) {
                            this.generateCurve(this.gd.size2, this.gd.size3 >> 1);
                            continue;
                        }
                        if (selection2 == 2) {
                            this.generateCurve(this.gd.size3, this.gd.size3 >> 1);
                            continue;
                        }
                        if (selection2 != 3) continue;
                        this.generateCurve(this.gd.size4, this.gd.size3 >> 1);
                    }
                    break block11;
                }
                if (selection != 1) break block12;
                for (int i = 0; i < 2; ++i) {
                    int selection2 = RandomNum.getRandomUInt(3);
                    if (selection2 == 0) {
                        this.generateCurve(this.gd.size1, this.gd.size2 >> 1);
                        continue;
                    }
                    if (selection2 == 1) {
                        this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
                        continue;
                    }
                    if (selection2 != 2) continue;
                    this.generateCurve(this.gd.size3, this.gd.size2 >> 1);
                }
                break block11;
            }
            if (selection != 2) break block11;
            for (int i = 0; i < 2; ++i) {
                int selection2 = RandomNum.getRandomUInt(3);
                if (selection2 == 0) {
                    this.generateCurve(this.gd.size0, this.gd.size1 >> 1);
                    continue;
                }
                if (selection2 == 1) {
                    this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
                    continue;
                }
                if (selection2 != 2) continue;
                this.generateCurve(this.gd.size2, this.gd.size1 >> 1);
            }
        }
    }

    public void level10c() {
        block7: {
            int selection;
            block6: {
                selection = RandomNum.getRandomUInt(2);
                if (selection != 0) break block6;
                for (int i = 0; i < 2; ++i) {
                    int selection2 = RandomNum.getRandomUInt(3);
                    if (selection2 == 0) {
                        this.generateCurve(this.gd.size1, this.gd.size2 >> 1);
                        continue;
                    }
                    if (selection2 == 1) {
                        this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
                        continue;
                    }
                    if (selection2 != 2) continue;
                    this.generateCurve(this.gd.size3, this.gd.size2 >> 1);
                }
                break block7;
            }
            if (selection != 1) break block7;
            for (int i = 0; i < 2; ++i) {
                int selection2 = RandomNum.getRandomUInt(3);
                if (selection2 == 0) {
                    this.generateCurve(this.gd.size0, this.gd.size1 >> 1);
                    continue;
                }
                if (selection2 == 1) {
                    this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
                    continue;
                }
                if (selection2 != 2) continue;
                this.generateCurve(this.gd.size2, this.gd.size1 >> 1);
            }
        }
    }

    public void level10d() {
        for (int i = 0; i < 2; ++i) {
            int selection2 = RandomNum.getRandomUInt(3);
            if (selection2 == 0) {
                this.generateCurve(this.gd.size0, this.gd.size1 >> 1);
                continue;
            }
            if (selection2 == 1) {
                this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
                continue;
            }
            if (selection2 != 2) continue;
            this.generateCurve(this.gd.size2, this.gd.size1 >> 1);
        }
    }

    public void level11() {
        if (this.gd.postupnost == 0) {
            this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
            this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
        } else if (this.gd.postupnost == 1) {
            this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
            this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
        } else if (this.gd.postupnost == 2) {
            this.generateCurve(this.gd.size0, this.gd.size0 >> 1);
            this.generateCurve(this.gd.size0, this.gd.size0 >> 1);
        } else if (this.gd.postupnost == 3) {
            this.generateCurve(this.gd.size3, this.gd.size3 >> 1);
            this.generateCurve(this.gd.size3, this.gd.size3 >> 1);
        } else if (this.gd.postupnost == 4) {
            this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
            this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
        } else if (this.gd.postupnost == 5) {
            this.generateCurve(this.gd.size0, this.gd.size0 >> 1);
            this.generateCurve(this.gd.size0, this.gd.size0 >> 1);
        } else if (this.gd.postupnost == 6) {
            this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
            this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
        } else if (this.gd.postupnost == 7) {
            this.generateCurve(this.gd.size4, this.gd.size4 >> 1);
            this.generateCurve(this.gd.size1, this.gd.size4 >> 1);
        } else if (this.gd.postupnost == 8) {
            this.generateCurve(this.gd.size4, this.gd.size4 >> 1);
            this.generateCurve(this.gd.size4, this.gd.floor - this.gd.cursorY);
        } else if (this.gd.postupnost == 9) {
            this.generateCurve(this.gd.size1, this.gd.size4 >> 1);
            this.generateCurve(this.gd.size4, this.gd.size4 >> 1);
        } else if (this.gd.postupnost == 10) {
            this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
            this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
        } else if (this.gd.postupnost == 11) {
            this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
            this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
        } else if (this.gd.postupnost == 12) {
            this.generateCurve(this.gd.size3, this.gd.size3 >> 1);
            this.generateCurve(this.gd.size3, this.gd.size3 >> 1);
        } else if (this.gd.postupnost == 13) {
            this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
            this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
        } else if (this.gd.postupnost == 14) {
            this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
            this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
        } else if (this.gd.postupnost == 15) {
            this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
            this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
        } else if (this.gd.postupnost == 16) {
            this.generateCurve(this.gd.size3, this.gd.size3 >> 1);
            this.generateCurve(this.gd.size3, this.gd.size3 >> 1);
        } else if (this.gd.postupnost == 17) {
            this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
            this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
        } else if (this.gd.postupnost == 18) {
            this.generateCurve(this.gd.size4, this.gd.size4 >> 1);
            this.generateCurve(this.gd.size1, this.gd.size4 >> 1);
        } else if (this.gd.postupnost == 19) {
            this.generateCurve(this.gd.size4, this.gd.size4 >> 1);
            this.generateCurve(this.gd.size4, this.gd.floor - this.gd.cursorY);
        } else if (this.gd.postupnost == 20) {
            this.generateCurve(this.gd.size1, this.gd.size4 >> 1);
            this.generateCurve(this.gd.size4, this.gd.size4 >> 1);
        } else if (this.gd.postupnost == 21) {
            this.generateCurve(this.gd.size2, this.gd.size1 >> 1);
            this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
        } else if (this.gd.postupnost == 22) {
            this.generateCurve(this.gd.size3, this.gd.size4 >> 1);
            this.generateCurve(this.gd.size3, this.gd.size1 >> 1);
        } else if (this.gd.postupnost == 23) {
            this.generateCurve(this.gd.size4, this.gd.size2 >> 1);
            this.generateCurve(this.gd.size4, this.gd.size1 >> 1);
        } else if (this.gd.postupnost == 24) {
            this.generateCurve(this.gd.size3, this.gd.size1 >> 1);
            this.generateCurve(this.gd.size3, this.gd.size1 >> 1);
        } else if (this.gd.postupnost == 25) {
            this.generateCurve(this.gd.size3, this.gd.size2 >> 1);
            this.generateCurve(this.gd.size2, this.gd.size1 >> 1);
        } else if (this.gd.postupnost == 26) {
            this.generateCurve(this.gd.size3, this.gd.size1 >> 1);
            this.generateCurve(this.gd.size3, this.gd.size1 >> 1);
        } else if (this.gd.postupnost == 27) {
            this.generateCurve(this.gd.size3, this.gd.size1 >> 1);
            this.generateCurve(this.gd.size3, this.gd.size2 >> 1);
        } else if (this.gd.postupnost == 28) {
            this.generateCurve(this.gd.size3, this.gd.size1 >> 1);
            this.generateCurve(this.gd.size3, this.gd.size1 >> 1);
        } else if (this.gd.postupnost == 29) {
            this.generateCurve(this.gd.size2, this.gd.size1 >> 1);
            this.generateCurve(this.gd.size3, this.gd.size4 >> 1);
        } else if (this.gd.postupnost == 30) {
            this.generateCurve(this.gd.size3, this.gd.size1 >> 1);
            this.generateCurve(this.gd.size3, this.gd.size2 >> 1);
        }
        ++this.gd.postupnost;
        if (this.gd.postupnost > 30) {
            this.gd.postupnost = 0;
        }
    }

    public void level12a() {
        int selection = RandomNum.getRandomUInt(6);
        if (selection == 0) {
            for (int i = 0; i < 2; ++i) {
                int selection2 = RandomNum.getRandomUInt(3);
                if (selection2 == 0) {
                    this.generateCurve(this.gd.size2, this.gd.size4 >> 1);
                    continue;
                }
                if (selection2 == 1) {
                    this.generateCurve(this.gd.size3, this.gd.size4 >> 1);
                    continue;
                }
                if (selection2 != 2) continue;
                this.generateCurve(this.gd.size4, this.gd.size4 >> 1);
            }
        } else if (selection == 1) {
            for (int i = 0; i < 2; ++i) {
                int selection2 = RandomNum.getRandomUInt(4);
                if (selection2 == 0) {
                    this.generateCurve(this.gd.size1, this.gd.size3 >> 1);
                    continue;
                }
                if (selection2 == 1) {
                    this.generateCurve(this.gd.size2, this.gd.size3 >> 1);
                    continue;
                }
                if (selection2 == 2) {
                    this.generateCurve(this.gd.size3, this.gd.size3 >> 1);
                    continue;
                }
                if (selection2 != 3) continue;
                this.generateCurve(this.gd.size4, this.gd.size3 >> 1);
            }
        } else if (selection == 2) {
            for (int i = 0; i < 2; ++i) {
                int selection2 = RandomNum.getRandomUInt(3);
                if (selection2 == 0) {
                    this.generateCurve(this.gd.size1, this.gd.size2 >> 1);
                    continue;
                }
                if (selection2 == 1) {
                    this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
                    continue;
                }
                if (selection2 != 2) continue;
                this.generateCurve(this.gd.size3, this.gd.size2 >> 1);
            }
        } else if (selection == 3) {
            for (int i = 0; i < 2; ++i) {
                int selection2 = RandomNum.getRandomUInt(3);
                if (selection2 == 0) {
                    this.generateCurve(this.gd.size0, this.gd.size1 >> 1);
                    continue;
                }
                if (selection2 == 1) {
                    this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
                    continue;
                }
                if (selection2 != 2) continue;
                this.generateCurve(this.gd.size2, this.gd.size1 >> 1);
            }
        } else if (selection == 4) {
            if (this.gd.updateCounter % 16 == 0) {
                this.generateCurve(this.gd.cursorY - this.gd.ceiling << 1, this.gd.cursorY - this.gd.ceiling);
                this.isAddingCoins = true;
                this.generateCurve(this.gd.floor - this.gd.cursorY << 1, this.gd.floor - this.gd.cursorY);
                this.isAddingCoins = false;
            }
        } else if (selection == 5 && this.gd.updateCounter % 6 == 0) {
            this.generateCurve(this.gd.size2, this.gd.size4 >> 1);
            this.generateCurve(this.gd.size2, this.gd.size4 >> 1);
            this.generateCurve(this.gd.size2, this.gd.size4 >> 1);
            this.generateCurve(this.gd.size2, this.gd.size4 >> 1);
            this.generateCurve(this.gd.size2, this.gd.size4 >> 1);
            this.generateCurve(this.gd.size2, this.gd.size4 >> 1);
        }
    }

    public void level12b() {
        block11: {
            int selection;
            block12: {
                block10: {
                    selection = RandomNum.getRandomUInt(3);
                    if (selection != 0) break block10;
                    for (int i = 0; i < 2; ++i) {
                        int selection2 = RandomNum.getRandomUInt(4);
                        if (selection2 == 0) {
                            this.generateCurve(this.gd.size1, this.gd.size3 >> 1);
                            continue;
                        }
                        if (selection2 == 1) {
                            this.generateCurve(this.gd.size2, this.gd.size3 >> 1);
                            continue;
                        }
                        if (selection2 == 2) {
                            this.generateCurve(this.gd.size3, this.gd.size3 >> 1);
                            continue;
                        }
                        if (selection2 != 3) continue;
                        this.generateCurve(this.gd.size4, this.gd.size3 >> 1);
                    }
                    break block11;
                }
                if (selection != 1) break block12;
                for (int i = 0; i < 2; ++i) {
                    int selection2 = RandomNum.getRandomUInt(3);
                    if (selection2 == 0) {
                        this.generateCurve(this.gd.size1, this.gd.size2 >> 1);
                        continue;
                    }
                    if (selection2 == 1) {
                        this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
                        continue;
                    }
                    if (selection2 != 2) continue;
                    this.generateCurve(this.gd.size3, this.gd.size2 >> 1);
                }
                break block11;
            }
            if (selection != 2) break block11;
            for (int i = 0; i < 2; ++i) {
                int selection2 = RandomNum.getRandomUInt(3);
                if (selection2 == 0) {
                    this.generateCurve(this.gd.size0, this.gd.size1 >> 1);
                    continue;
                }
                if (selection2 == 1) {
                    this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
                    continue;
                }
                if (selection2 != 2) continue;
                this.generateCurve(this.gd.size2, this.gd.size1 >> 1);
            }
        }
    }

    public void level12c() {
        block7: {
            int selection;
            block6: {
                selection = RandomNum.getRandomUInt(2);
                if (selection != 0) break block6;
                for (int i = 0; i < 2; ++i) {
                    int selection2 = RandomNum.getRandomUInt(3);
                    if (selection2 == 0) {
                        this.generateCurve(this.gd.size1, this.gd.size2 >> 1);
                        continue;
                    }
                    if (selection2 == 1) {
                        this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
                        continue;
                    }
                    if (selection2 != 2) continue;
                    this.generateCurve(this.gd.size3, this.gd.size2 >> 1);
                }
                break block7;
            }
            if (selection != 1) break block7;
            for (int i = 0; i < 2; ++i) {
                int selection2 = RandomNum.getRandomUInt(3);
                if (selection2 == 0) {
                    this.generateCurve(this.gd.size0, this.gd.size1 >> 1);
                    continue;
                }
                if (selection2 == 1) {
                    this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
                    continue;
                }
                if (selection2 != 2) continue;
                this.generateCurve(this.gd.size2, this.gd.size1 >> 1);
            }
        }
    }

    public void level12d() {
        for (int i = 0; i < 2; ++i) {
            int selection2 = RandomNum.getRandomUInt(3);
            if (selection2 == 0) {
                this.generateCurve(this.gd.size0, this.gd.size1 >> 1);
                continue;
            }
            if (selection2 == 1) {
                this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
                continue;
            }
            if (selection2 != 2) continue;
            this.generateCurve(this.gd.size2, this.gd.size1 >> 1);
        }
    }

    public void level13a() {
        int selection = RandomNum.getRandomUInt(4);
        if (selection == 0) {
            int selection2 = RandomNum.getRandomUInt(3);
            if (selection2 == 0) {
                this.generateCurve(this.gd.size1, this.gd.size4 >> 1);
                this.generateCurve(this.gd.size1, this.gd.size3 >> 1);
            } else if (selection2 == 1) {
                this.generateCurve(this.gd.size2, this.gd.size4 >> 1);
                this.generateCurve(this.gd.size2, this.gd.size3 >> 1);
            } else if (selection2 == 2) {
                this.generateCurve(this.gd.size3, this.gd.size4 >> 1);
                this.generateCurve(this.gd.size3, this.gd.size3 >> 1);
            }
        } else if (selection == 1) {
            int selection2 = RandomNum.getRandomUInt(3);
            if (selection2 == 0) {
                this.generateCurve(this.gd.size1, this.gd.size3 >> 1);
                this.generateCurve(this.gd.size1, this.gd.size2 >> 1);
            } else if (selection2 == 1) {
                this.generateCurve(this.gd.size2, this.gd.size3 >> 1);
                this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
            } else if (selection2 == 2) {
                this.generateCurve(this.gd.size3, this.gd.size3 >> 1);
                this.generateCurve(this.gd.size3, this.gd.size2 >> 1);
            }
        } else if (selection == 2) {
            int selection2 = RandomNum.getRandomUInt(2);
            if (selection2 == 0) {
                this.generateCurve(this.gd.size1, this.gd.size2 >> 1);
                this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
            } else if (selection2 == 1) {
                this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
                this.generateCurve(this.gd.size2, this.gd.size1 >> 1);
            }
        } else if (selection == 3) {
            int selection2 = RandomNum.getRandomUInt(2);
            if (selection2 == 0) {
                this.generateCurve(this.gd.size0, this.gd.size1 >> 1);
                this.generateCurve(this.gd.size0, this.gd.size0 >> 1);
            } else if (selection2 == 1) {
                this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
                this.generateCurve(this.gd.size1, this.gd.size0 >> 1);
            }
        }
    }

    public void level13b() {
        int selection = RandomNum.getRandomUInt(3);
        if (selection == 0) {
            int selection2 = RandomNum.getRandomUInt(3);
            if (selection2 == 0) {
                this.generateCurve(this.gd.size1, this.gd.size3 >> 1);
                this.generateCurve(this.gd.size1, this.gd.size2 >> 1);
            } else if (selection2 == 1) {
                this.generateCurve(this.gd.size2, this.gd.size3 >> 1);
                this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
            } else if (selection2 == 2) {
                this.generateCurve(this.gd.size3, this.gd.size3 >> 1);
                this.generateCurve(this.gd.size3, this.gd.size2 >> 1);
            }
        } else if (selection == 1) {
            int selection2 = RandomNum.getRandomUInt(2);
            if (selection2 == 0) {
                this.generateCurve(this.gd.size1, this.gd.size2 >> 1);
                this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
            } else if (selection2 == 1) {
                this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
                this.generateCurve(this.gd.size2, this.gd.size1 >> 1);
            }
        } else if (selection == 2) {
            int selection2 = RandomNum.getRandomUInt(2);
            if (selection2 == 0) {
                this.generateCurve(this.gd.size0, this.gd.size1 >> 1);
                this.generateCurve(this.gd.size0, this.gd.size0 >> 1);
            } else if (selection2 == 1) {
                this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
                this.generateCurve(this.gd.size1, this.gd.size0 >> 1);
            }
        }
    }

    public void level13c() {
        int selection = RandomNum.getRandomUInt(2);
        if (selection == 0) {
            int selection2 = RandomNum.getRandomUInt(2);
            if (selection2 == 0) {
                this.generateCurve(this.gd.size1, this.gd.size2 >> 1);
                this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
            } else if (selection2 == 1) {
                this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
                this.generateCurve(this.gd.size2, this.gd.size1 >> 1);
            }
        } else if (selection == 1) {
            int selection2 = RandomNum.getRandomUInt(2);
            if (selection2 == 0) {
                this.generateCurve(this.gd.size0, this.gd.size1 >> 1);
                this.generateCurve(this.gd.size0, this.gd.size0 >> 1);
            } else if (selection2 == 1) {
                this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
                this.generateCurve(this.gd.size1, this.gd.size0 >> 1);
            }
        }
    }

    public void level13d() {
        int selection2 = RandomNum.getRandomUInt(2);
        if (selection2 == 0) {
            this.generateCurve(this.gd.size0, this.gd.size1 >> 1);
            this.generateCurve(this.gd.size0, this.gd.size0 >> 1);
        } else if (selection2 == 1) {
            this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
            this.generateCurve(this.gd.size1, this.gd.size0 >> 1);
        }
    }

    public void level14a() {
        int selection = RandomNum.getRandomUInt(7);
        if (selection == 0) {
            int selection2 = RandomNum.getRandomUInt(3);
            if (selection2 == 0) {
                this.generateCurve(this.gd.size1, this.gd.size4 >> 1);
                this.generateCurve(this.gd.size1, this.gd.size3 >> 1);
            } else if (selection2 == 1) {
                this.generateCurve(this.gd.size2, this.gd.size4 >> 1);
                this.generateCurve(this.gd.size2, this.gd.size3 >> 1);
            } else if (selection2 == 2) {
                this.generateCurve(this.gd.size3, this.gd.size4 >> 1);
                this.generateCurve(this.gd.size3, this.gd.size3 >> 1);
            }
        } else if (selection == 1) {
            int selection2 = RandomNum.getRandomUInt(3);
            if (selection2 == 0) {
                this.generateCurve(this.gd.size1, this.gd.size3 >> 1);
                this.generateCurve(this.gd.size1, this.gd.size2 >> 1);
            } else if (selection2 == 1) {
                this.generateCurve(this.gd.size2, this.gd.size3 >> 1);
                this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
            } else if (selection2 == 2) {
                this.generateCurve(this.gd.size3, this.gd.size3 >> 1);
                this.generateCurve(this.gd.size3, this.gd.size2 >> 1);
            }
        } else if (selection == 2) {
            int selection2 = RandomNum.getRandomUInt(2);
            if (selection2 == 0) {
                this.generateCurve(this.gd.size1, this.gd.size2 >> 1);
                this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
            } else if (selection2 == 1) {
                this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
                this.generateCurve(this.gd.size2, this.gd.size1 >> 1);
            }
        } else if (selection == 3) {
            int selection2 = RandomNum.getRandomUInt(2);
            if (selection2 == 0) {
                this.generateCurve(this.gd.size0, this.gd.size1 >> 1);
                this.generateCurve(this.gd.size0, this.gd.size0 >> 1);
            } else if (selection2 == 1) {
                this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
                this.generateCurve(this.gd.size1, this.gd.size0 >> 1);
            }
        } else if (selection == 4) {
            if (this.gd.updateCounter % 16 == 0) {
                this.generateCurve(this.gd.cursorY - this.gd.ceiling << 1, this.gd.cursorY - this.gd.ceiling);
                this.isAddingCoins = true;
                this.generateCurve(this.gd.floor - this.gd.cursorY << 1, this.gd.floor - this.gd.cursorY);
                this.isAddingCoins = false;
            }
        } else if (selection == 5) {
            if (this.gd.updateCounter % 6 == 0) {
                this.generateCurve(this.gd.size2, this.gd.size4 >> 1);
                this.generateCurve(this.gd.size2, this.gd.size4 >> 1);
                this.generateCurve(this.gd.size2, this.gd.size4 >> 1);
                this.generateCurve(this.gd.size2, this.gd.size4 >> 1);
                this.generateCurve(this.gd.size2, this.gd.size4 >> 1);
                this.generateCurve(this.gd.size2, this.gd.size4 >> 1);
            }
        } else if (selection == 6 && this.gd.updateCounter % 6 == 0) {
            this.generateCurve(this.gd.size2, this.gd.size4 >> 1);
            this.generateCurve(this.gd.size2, this.gd.size4 >> 1);
            this.generateCurve(this.gd.size1, this.gd.size0 >> 1);
            this.generateCurve(this.gd.size1, this.gd.size0 >> 1);
            this.generateCurve(this.gd.size2, this.gd.size4 >> 1);
            this.generateCurve(this.gd.size2, this.gd.size4 >> 1);
        }
    }

    public void level14b() {
        int selection = RandomNum.getRandomUInt(3);
        if (selection == 0) {
            int selection2 = RandomNum.getRandomUInt(3);
            if (selection2 == 0) {
                this.generateCurve(this.gd.size1, this.gd.size3 >> 1);
                this.generateCurve(this.gd.size1, this.gd.size2 >> 1);
            } else if (selection2 == 1) {
                this.generateCurve(this.gd.size2, this.gd.size3 >> 1);
                this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
            } else if (selection2 == 2) {
                this.generateCurve(this.gd.size3, this.gd.size3 >> 1);
                this.generateCurve(this.gd.size3, this.gd.size2 >> 1);
            }
        } else if (selection == 1) {
            int selection2 = RandomNum.getRandomUInt(2);
            if (selection2 == 0) {
                this.generateCurve(this.gd.size1, this.gd.size2 >> 1);
                this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
            } else if (selection2 == 1) {
                this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
                this.generateCurve(this.gd.size2, this.gd.size1 >> 1);
            }
        } else if (selection == 2) {
            int selection2 = RandomNum.getRandomUInt(2);
            if (selection2 == 0) {
                this.generateCurve(this.gd.size0, this.gd.size1 >> 1);
                this.generateCurve(this.gd.size0, this.gd.size0 >> 1);
            } else if (selection2 == 1) {
                this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
                this.generateCurve(this.gd.size1, this.gd.size0 >> 1);
            }
        }
    }

    public void level14c() {
        int selection = RandomNum.getRandomUInt(2);
        if (selection == 0) {
            int selection2 = RandomNum.getRandomUInt(2);
            if (selection2 == 0) {
                this.generateCurve(this.gd.size1, this.gd.size2 >> 1);
                this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
            } else if (selection2 == 1) {
                this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
                this.generateCurve(this.gd.size2, this.gd.size1 >> 1);
            }
        } else if (selection == 1) {
            int selection2 = RandomNum.getRandomUInt(2);
            if (selection2 == 0) {
                this.generateCurve(this.gd.size0, this.gd.size1 >> 1);
                this.generateCurve(this.gd.size0, this.gd.size0 >> 1);
            } else if (selection2 == 1) {
                this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
                this.generateCurve(this.gd.size1, this.gd.size0 >> 1);
            }
        }
    }

    public void level14d() {
        int selection2 = RandomNum.getRandomUInt(2);
        if (selection2 == 0) {
            this.generateCurve(this.gd.size0, this.gd.size1 >> 1);
            this.generateCurve(this.gd.size0, this.gd.size0 >> 1);
        } else if (selection2 == 1) {
            this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
            this.generateCurve(this.gd.size1, this.gd.size0 >> 1);
        }
    }

    public void level15() {
        if (this.gd.postupnost == 0) {
            this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
            this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
        } else if (this.gd.postupnost == 1) {
            this.generateCurve(this.gd.size3, this.gd.size3 >> 1);
            this.generateCurve(this.gd.size2, this.gd.size3 >> 1);
        } else if (this.gd.postupnost == 2) {
            this.generateCurve(this.gd.cursorY - this.gd.ceiling, this.gd.cursorY - this.gd.ceiling);
            this.generateCurve(this.gd.size3, this.gd.size2 >> 1);
        } else if (this.gd.postupnost == 3) {
            this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
            this.generateCurve(this.gd.floor - this.gd.cursorY >> 1, this.gd.floor - this.gd.cursorY);
        } else if (this.gd.postupnost == 4) {
            this.generateCurve(this.gd.size4, this.gd.size4 >> 1);
            this.generateCurve(this.gd.size2, this.gd.size4 >> 1);
        } else if (this.gd.postupnost == 5) {
            this.generateCurve(this.gd.cursorY - this.gd.ceiling, this.gd.cursorY - this.gd.ceiling);
            this.generateCurve(this.gd.size4, this.gd.size3 >> 1);
        } else if (this.gd.postupnost == 6) {
            this.generateCurve(this.gd.cursorY - this.gd.ceiling, this.gd.cursorY - this.gd.ceiling);
            this.generateCurve(this.gd.size4, this.gd.size3 >> 1);
        } else if (this.gd.postupnost == 7) {
            this.generateCurve(this.gd.cursorY - this.gd.ceiling, this.gd.cursorY - this.gd.ceiling);
            this.generateCurve(this.gd.floor - this.gd.cursorY << 1, this.gd.floor - this.gd.cursorY);
        } else if (this.gd.postupnost == 8) {
            this.generateCurve(this.gd.size3, this.gd.size3 >> 1);
            this.generateCurve(this.gd.size1, this.gd.size2 >> 1);
        } else if (this.gd.postupnost == 9) {
            this.generateCurve(this.gd.size2, this.gd.size4 >> 1);
            this.generateCurve(this.gd.size4, this.gd.size4 >> 1);
        } else if (this.gd.postupnost == 10) {
            this.generateCurve(this.gd.cursorY - this.gd.ceiling, this.gd.cursorY - this.gd.ceiling);
            this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
        } else if (this.gd.postupnost == 11) {
            this.generateCurve(this.gd.size2, this.gd.size1 >> 1);
            this.generateCurve(this.gd.size1, this.gd.size2 >> 1);
        } else if (this.gd.postupnost == 12) {
            this.generateCurve(this.gd.cursorY - this.gd.ceiling, this.gd.cursorY - this.gd.ceiling);
            this.generateCurve(this.gd.floor - this.gd.cursorY, this.gd.floor - this.gd.cursorY);
        } else if (this.gd.postupnost == 13) {
            this.generateCurve(this.gd.size4, this.gd.size4 >> 1);
            this.generateCurve(this.gd.size3, this.gd.size3 >> 1);
        } else if (this.gd.postupnost == 14) {
            this.generateCurve(this.gd.size1, this.gd.size2 >> 1);
            this.generateCurve(this.gd.floor - this.gd.cursorY, this.gd.floor - this.gd.cursorY);
        } else if (this.gd.postupnost == 15) {
            this.generateCurve(this.gd.size4, this.gd.size3 >> 1);
            this.generateCurve(this.gd.size1, this.gd.size3 >> 1);
        } else if (this.gd.postupnost == 16) {
            this.generateCurve(this.gd.cursorY - this.gd.ceiling, this.gd.cursorY - this.gd.ceiling);
            this.generateCurve(this.gd.size2, this.gd.size3 >> 1);
        } else if (this.gd.postupnost == 17) {
            this.generateCurve(this.gd.cursorY - this.gd.ceiling << 1, this.gd.cursorY - this.gd.ceiling);
            this.generateCurve(this.gd.floor - this.gd.cursorY >> 1, this.gd.floor - this.gd.cursorY);
        } else if (this.gd.postupnost == 18) {
            this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
            this.generateCurve(this.gd.size1, this.gd.size1 >> 1);
        } else if (this.gd.postupnost == 19) {
            this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
            this.generateCurve(this.gd.size2, this.gd.size2 >> 1);
        } else if (this.gd.postupnost == 20) {
            this.generateCurve(this.gd.size3, this.gd.size3 >> 1);
            this.generateCurve(this.gd.size3, this.gd.size3 >> 1);
        } else if (this.gd.postupnost == 21) {
            this.generateCurve(this.gd.cursorY - this.gd.ceiling >> 1, this.gd.cursorY - this.gd.ceiling);
            this.generateCurve(this.gd.size3, this.gd.size4 >> 1);
        } else if (this.gd.postupnost == 22) {
            this.generateCurve(this.gd.cursorY - this.gd.ceiling >> 1, this.gd.cursorY - this.gd.ceiling);
            this.generateCurve(this.gd.size2, this.gd.size3 >> 1);
        } else if (this.gd.postupnost == 23) {
            this.generateCurve(this.gd.cursorY - this.gd.ceiling >> 1, this.gd.cursorY - this.gd.ceiling);
            this.generateCurve(this.gd.size0, this.gd.size1 >> 1);
        } else if (this.gd.postupnost == 24) {
            this.generateCurve(this.gd.cursorY - this.gd.ceiling >> 1, this.gd.cursorY - this.gd.ceiling);
            this.generateCurve(this.gd.floor - this.gd.cursorY, this.gd.floor - this.gd.cursorY);
        } else if (this.gd.postupnost == 25) {
            this.generateCurve(this.gd.size2, this.gd.size4 >> 1);
            this.generateCurve(this.gd.size2, this.gd.size4 >> 1);
        } else if (this.gd.postupnost == 26) {
            this.generateCurve(this.gd.cursorY - this.gd.ceiling >> 1, this.gd.cursorY - this.gd.ceiling);
            this.generateCurve(this.gd.floor - this.gd.cursorY, this.gd.floor - this.gd.cursorY);
        } else if (this.gd.postupnost == 27) {
            this.generateCurve(this.gd.size1, this.gd.size2 >> 1);
            this.generateCurve(this.gd.size3, this.gd.size2 >> 1);
        } else if (this.gd.postupnost == 28) {
            this.generateCurve(this.gd.size2, this.gd.size4 >> 1);
            this.generateCurve(this.gd.size3, this.gd.size4 >> 1);
        } else if (this.gd.postupnost == 29) {
            this.generateCurve(this.gd.cursorY - this.gd.ceiling, this.gd.cursorY - this.gd.ceiling);
            this.generateCurve(this.gd.size2, this.gd.size1 >> 1);
        } else if (this.gd.postupnost == 30) {
            this.generateCurve(this.gd.size3, this.gd.size1 >> 1);
            this.generateCurve(this.gd.floor - this.gd.cursorY, this.gd.floor - this.gd.cursorY);
        }
        ++this.gd.postupnost;
        if (this.gd.postupnost > 30) {
            this.gd.postupnost = 0;
        }
    }

    public void paintHills(Graphics g) {
        block12: {
            block13: {
                block10: {
                    block11: {
                        if (MainCanvas.isRotated) break block10;
                        if (this.gd.zoom != 0) break block11;
                        for (int i = 0; i < MainCanvas.WIDTH; i += this.gd.hillsPartWidth) {
                            if (this.COORDS[i] == -9999) continue;
                            g.setColor(EnvironmentsDefines.HILLS_COLOR[this.gd.level]);
                            g.fillRect(i, this.COORDS[i], this.gd.hillsPartWidth, MainCanvas.HEIGHT - this.COORDS[i]);
                        }
                        if (this.gd.zoomCounter <= 0) break block12;
                        this.gd.zoomCounter = 0;
                        break block12;
                    }
                    this.gd.zoomCounter = 0;
                    for (int i = 0; i < MainCanvas.WIDTH; i += this.gd.hillsPartWidth) {
                        for (int j = 0; j < this.maxCoords; ++j) {
                            if (this.COORDS[j] != -9999) {
                                int y = this.getY(j);
                                g.setColor(EnvironmentsDefines.HILLS_COLOR[this.gd.level]);
                                g.drawRect(i, y, this.gd.hillsPartWidth, MainCanvas.HEIGHT - y);
                            }
                            if (i + 1 < MainCanvas.WIDTH) {
                                ++i;
                                continue;
                            }
                            j = this.maxCoords;
                        }
                    }
                    break block12;
                }
                if (this.gd.zoom != 0) break block13;
                for (int i = 0; i < MainCanvas.HEIGHT; i += this.gd.hillsPartWidth) {
                    if (this.COORDS[i] == -9999) continue;
                    g.setColor(EnvironmentsDefines.HILLS_COLOR[this.gd.level]);
                    g.fillRect(0, i, MainCanvas.WIDTH - this.COORDS[i], this.gd.hillsPartWidth);
                }
                if (this.gd.zoomCounter <= 0) break block12;
                this.gd.zoomCounter = 0;
                break block12;
            }
            this.gd.zoomCounter = 0;
            for (int i = 0; i < MainCanvas.HEIGHT; i += this.gd.hillsPartWidth) {
                for (int j = 0; j < this.maxCoords; ++j) {
                    if (this.COORDS[i] != -9999) {
                        int y = this.getY(j);
                        g.setColor(EnvironmentsDefines.HILLS_COLOR[this.gd.level]);
                        g.fillRect(0, i, MainCanvas.WIDTH - y, this.gd.hillsPartWidth);
                    }
                    if (i + 1 < MainCanvas.HEIGHT) {
                        ++i;
                        continue;
                    }
                    j = this.maxCoords;
                }
            }
        }
    }

    public void paintDust(Graphics g) {
        block4: {
            block3: {
                if (this.isDragonBall) break block3;
                if (this.gd.move <= 0 || !this.isPlaying || !MainCanvas.isRotated) break block4;
                for (int i = 0; i < this.dd.bodyParts; ++i) {
                    if (this.COORDS[this.dd.BODY_SHIFT[i]] + this.dd.dragonHeadShift - this.dd.BODY_HEIGHT[i] > 0) continue;
                    Particles.createParticle(MainCanvas.WIDTH - this.COORDS[this.dd.BODY_SHIFT[i]], this.dd.BODY_SHIFT[i], this.gd.move, -(this.gd.move << 3) - (this.gd.move << 1), 0, 0, RandomNum.getRandomUInt(3) + 3, 0x505070, RandomNum.getRandomUInt(7));
                }
                break block4;
            }
            if (this.gd.move > 0 && this.isPlaying && MainCanvas.isRotated) {
                for (int i = 0; i < this.dd.bodyParts; ++i) {
                    if (this.COORDS[this.dd.headShift] + this.dd.dragonHeadShift - this.dd.headHeight > 0) continue;
                    Particles.createParticle(MainCanvas.WIDTH - this.COORDS[this.dd.headShift], this.dd.headShift, this.gd.move, -(this.gd.move << 3) - (this.gd.move << 1), 0, 0, RandomNum.getRandomUInt(3) + 3, 0x505070, RandomNum.getRandomUInt(7));
                }
            }
        }
    }

    public void paintEffects(Graphics g) {
        block4: {
            block3: {
                if (this.isDragonBall) break block3;
                if (!MainCanvas.isRotated) break block4;
                for (int i = 0; i < 6; ++i) {
                    Particles.createParticle(MainCanvas.WIDTH - (this.dd.BODY_HEIGHT[0] + this.gd.radius + (this.gd.radius >> 1)), (this.dd.tailShift + this.dd.tailShift2 >> 1) + (this.gd.zoom >> 4), RandomNum.getRandomInt(this.gd.move), 0, 0, -(this.gd.move << 1) - RandomNum.getRandomUInt(this.gd.move << 1), 1, EnvironmentsDefines.PARTICLES_EFFECTS[this.gd.environment], RandomNum.getRandomUInt(10));
                }
                break block4;
            }
            if (MainCanvas.isRotated) {
                for (int i = 0; i < 6; ++i) {
                    Particles.createParticle(MainCanvas.WIDTH - (this.dd.headHeight + this.gd.radius), this.dd.headShift + (this.sprDragonBall.getHeight() >> 3) + (this.gd.zoom >> 4), RandomNum.getRandomInt(this.gd.move + (this.gd.move << 1)), 0, 0, -(this.gd.move << 1) - RandomNum.getRandomUInt(this.gd.move << 1), 1, EnvironmentsDefines.PARTICLES_EFFECTS[this.gd.environment], RandomNum.getRandomUInt(10));
                }
            }
        }
    }

    public void paintDragonBall(Graphics g) {
        this.sprDragonBall.setFrame(this.gd.frameDragonBall);
        this.sprDragonBall.setPosition(this.dd.dragonball[0], this.dd.dragonball[1]);
        this.sprDragonBall.paint(g);
    }

    public void paintDragon(Graphics g) {
        if (this.dd.dragonLevel == 0) {
            g.setColor(DragonDefines.DRAGON_COLORS[this.dd.bodyParts]);
        } else if (this.dd.dragonLevel == 1) {
            g.setColor(DragonDefines.DRAGON_COLORS0[this.dd.bodyParts]);
        } else if (this.dd.dragonLevel == 2) {
            g.setColor(DragonDefines.DRAGON_COLORS1[this.dd.bodyParts]);
        } else if (this.dd.dragonLevel == 3) {
            g.setColor(DragonDefines.DRAGON_COLORS2[this.dd.bodyParts]);
        } else if (this.dd.dragonLevel == 4) {
            g.setColor(DragonDefines.DRAGON_COLORS3[this.dd.bodyParts]);
        } else if (this.dd.dragonLevel == 5) {
            g.setColor(DragonDefines.DRAGON_COLORS4[this.dd.bodyParts]);
        } else if (this.dd.dragonLevel == 6) {
            g.setColor(DragonDefines.DRAGON_COLORS5[this.dd.bodyParts]);
        }
        g.fillTriangle(this.dd.tail1[0], this.dd.tail1[1], this.dd.tail1[2], this.dd.tail1[3], this.dd.tail1[4], this.dd.tail1[5]);
        g.fillTriangle(this.dd.tail2[0], this.dd.tail2[1], this.dd.tail2[2], this.dd.tail2[3], this.dd.tail2[4], this.dd.tail2[5]);
        if (this.dd.bodyParts >= 5) {
            if (this.dd.dragonLevel == 0) {
                g.setColor(DragonDefines.DRAGON_COLORS[4]);
            } else if (this.dd.dragonLevel == 1) {
                g.setColor(DragonDefines.DRAGON_COLORS0[4]);
            } else if (this.dd.dragonLevel == 2) {
                g.setColor(DragonDefines.DRAGON_COLORS1[4]);
            } else if (this.dd.dragonLevel == 3) {
                g.setColor(DragonDefines.DRAGON_COLORS2[4]);
            } else if (this.dd.dragonLevel == 4) {
                g.setColor(DragonDefines.DRAGON_COLORS3[4]);
            } else if (this.dd.dragonLevel == 5) {
                g.setColor(DragonDefines.DRAGON_COLORS4[4]);
            } else if (this.dd.dragonLevel == 6) {
                g.setColor(DragonDefines.DRAGON_COLORS5[4]);
            }
            g.fillTriangle(this.dd.body1[0], this.dd.body1[1], this.dd.body1[2], this.dd.body1[3], this.dd.body1[4], this.dd.body1[5]);
            if (this.dd.dragonLevel == 0) {
                g.setColor(DragonDefines.LINE_COLOR[4]);
            } else if (this.dd.dragonLevel == 1) {
                g.setColor(DragonDefines.LINE_COLOR0[4]);
            } else if (this.dd.dragonLevel == 2) {
                g.setColor(DragonDefines.LINE_COLOR1[4]);
            } else if (this.dd.dragonLevel == 3) {
                g.setColor(DragonDefines.LINE_COLOR2[4]);
            } else if (this.dd.dragonLevel == 4) {
                g.setColor(DragonDefines.LINE_COLOR3[4]);
            } else if (this.dd.dragonLevel == 5) {
                g.setColor(DragonDefines.LINE_COLOR4[4]);
            } else if (this.dd.dragonLevel == 6) {
                g.setColor(DragonDefines.LINE_COLOR5[4]);
            }
            g.fillTriangle(this.dd.line1[0], this.dd.line1[1], this.dd.line1[2], this.dd.line1[3], this.dd.line1[4], this.dd.line1[5]);
        }
        if (this.dd.bodyParts >= 4) {
            if (this.dd.dragonLevel == 0) {
                g.setColor(DragonDefines.DRAGON_COLORS[3]);
            } else if (this.dd.dragonLevel == 1) {
                g.setColor(DragonDefines.DRAGON_COLORS0[3]);
            } else if (this.dd.dragonLevel == 2) {
                g.setColor(DragonDefines.DRAGON_COLORS1[3]);
            } else if (this.dd.dragonLevel == 3) {
                g.setColor(DragonDefines.DRAGON_COLORS2[3]);
            } else if (this.dd.dragonLevel == 4) {
                g.setColor(DragonDefines.DRAGON_COLORS3[3]);
            } else if (this.dd.dragonLevel == 5) {
                g.setColor(DragonDefines.DRAGON_COLORS4[3]);
            } else if (this.dd.dragonLevel == 6) {
                g.setColor(DragonDefines.DRAGON_COLORS5[3]);
            }
            g.fillTriangle(this.dd.body2[0], this.dd.body2[1], this.dd.body2[2], this.dd.body2[3], this.dd.body2[4], this.dd.body2[5]);
            if (this.dd.dragonLevel == 0) {
                g.setColor(DragonDefines.LINE_COLOR[3]);
            } else if (this.dd.dragonLevel == 1) {
                g.setColor(DragonDefines.LINE_COLOR0[3]);
            } else if (this.dd.dragonLevel == 2) {
                g.setColor(DragonDefines.LINE_COLOR1[3]);
            } else if (this.dd.dragonLevel == 3) {
                g.setColor(DragonDefines.LINE_COLOR2[3]);
            } else if (this.dd.dragonLevel == 4) {
                g.setColor(DragonDefines.LINE_COLOR3[3]);
            } else if (this.dd.dragonLevel == 5) {
                g.setColor(DragonDefines.LINE_COLOR4[3]);
            } else if (this.dd.dragonLevel == 6) {
                g.setColor(DragonDefines.LINE_COLOR5[3]);
            }
            g.fillTriangle(this.dd.line2[0], this.dd.line2[1], this.dd.line2[2], this.dd.line2[3], this.dd.line2[4], this.dd.line2[5]);
        }
        if (this.dd.bodyParts >= 3) {
            if (this.dd.dragonLevel == 0) {
                g.setColor(DragonDefines.DRAGON_COLORS[2]);
            } else if (this.dd.dragonLevel == 1) {
                g.setColor(DragonDefines.DRAGON_COLORS0[2]);
            } else if (this.dd.dragonLevel == 2) {
                g.setColor(DragonDefines.DRAGON_COLORS1[2]);
            } else if (this.dd.dragonLevel == 3) {
                g.setColor(DragonDefines.DRAGON_COLORS2[2]);
            } else if (this.dd.dragonLevel == 4) {
                g.setColor(DragonDefines.DRAGON_COLORS3[2]);
            } else if (this.dd.dragonLevel == 5) {
                g.setColor(DragonDefines.DRAGON_COLORS4[2]);
            } else if (this.dd.dragonLevel == 6) {
                g.setColor(DragonDefines.DRAGON_COLORS5[2]);
            }
            g.fillTriangle(this.dd.body3[0], this.dd.body3[1], this.dd.body3[2], this.dd.body3[3], this.dd.body3[4], this.dd.body3[5]);
            if (this.dd.dragonLevel == 0) {
                g.setColor(DragonDefines.LINE_COLOR[2]);
            } else if (this.dd.dragonLevel == 1) {
                g.setColor(DragonDefines.LINE_COLOR0[2]);
            } else if (this.dd.dragonLevel == 2) {
                g.setColor(DragonDefines.LINE_COLOR1[2]);
            } else if (this.dd.dragonLevel == 3) {
                g.setColor(DragonDefines.LINE_COLOR2[2]);
            } else if (this.dd.dragonLevel == 4) {
                g.setColor(DragonDefines.LINE_COLOR3[2]);
            } else if (this.dd.dragonLevel == 5) {
                g.setColor(DragonDefines.LINE_COLOR4[2]);
            } else if (this.dd.dragonLevel == 6) {
                g.setColor(DragonDefines.LINE_COLOR5[2]);
            }
            g.fillTriangle(this.dd.line3[0], this.dd.line3[1], this.dd.line3[2], this.dd.line3[3], this.dd.line3[4], this.dd.line3[5]);
        }
        if (this.dd.bodyParts >= 2) {
            if (this.dd.dragonLevel == 0) {
                g.setColor(DragonDefines.DRAGON_COLORS[1]);
            } else if (this.dd.dragonLevel == 1) {
                g.setColor(DragonDefines.DRAGON_COLORS0[1]);
            } else if (this.dd.dragonLevel == 2) {
                g.setColor(DragonDefines.DRAGON_COLORS1[1]);
            } else if (this.dd.dragonLevel == 3) {
                g.setColor(DragonDefines.DRAGON_COLORS2[1]);
            } else if (this.dd.dragonLevel == 4) {
                g.setColor(DragonDefines.DRAGON_COLORS3[1]);
            } else if (this.dd.dragonLevel == 5) {
                g.setColor(DragonDefines.DRAGON_COLORS4[1]);
            } else if (this.dd.dragonLevel == 6) {
                g.setColor(DragonDefines.DRAGON_COLORS5[1]);
            }
            g.fillTriangle(this.dd.body4[0], this.dd.body4[1], this.dd.body4[2], this.dd.body4[3], this.dd.body4[4], this.dd.body4[5]);
            if (this.dd.dragonLevel == 0) {
                g.setColor(DragonDefines.LINE_COLOR[1]);
            } else if (this.dd.dragonLevel == 1) {
                g.setColor(DragonDefines.LINE_COLOR0[1]);
            } else if (this.dd.dragonLevel == 2) {
                g.setColor(DragonDefines.LINE_COLOR1[1]);
            } else if (this.dd.dragonLevel == 3) {
                g.setColor(DragonDefines.LINE_COLOR2[1]);
            } else if (this.dd.dragonLevel == 4) {
                g.setColor(DragonDefines.LINE_COLOR3[1]);
            } else if (this.dd.dragonLevel == 5) {
                g.setColor(DragonDefines.LINE_COLOR4[1]);
            } else if (this.dd.dragonLevel == 6) {
                g.setColor(DragonDefines.LINE_COLOR5[1]);
            }
            g.fillTriangle(this.dd.line4[0], this.dd.line4[1], this.dd.line4[2], this.dd.line4[3], this.dd.line4[4], this.dd.line4[5]);
        }
        if (this.dd.bodyParts >= 1) {
            if (this.dd.dragonLevel == 0) {
                g.setColor(DragonDefines.DRAGON_COLORS[0]);
            } else if (this.dd.dragonLevel == 1) {
                g.setColor(DragonDefines.DRAGON_COLORS0[0]);
            } else if (this.dd.dragonLevel == 2) {
                g.setColor(DragonDefines.DRAGON_COLORS1[0]);
            } else if (this.dd.dragonLevel == 3) {
                g.setColor(DragonDefines.DRAGON_COLORS2[0]);
            } else if (this.dd.dragonLevel == 4) {
                g.setColor(DragonDefines.DRAGON_COLORS3[0]);
            } else if (this.dd.dragonLevel == 5) {
                g.setColor(DragonDefines.DRAGON_COLORS4[0]);
            } else if (this.dd.dragonLevel == 6) {
                g.setColor(DragonDefines.DRAGON_COLORS5[0]);
            }
            g.fillTriangle(this.dd.body5[0], this.dd.body5[1], this.dd.body5[2], this.dd.body5[3], this.dd.body5[4], this.dd.body5[5]);
            if (this.dd.dragonLevel == 0) {
                g.setColor(DragonDefines.LINE_COLOR[0]);
            } else if (this.dd.dragonLevel == 1) {
                g.setColor(DragonDefines.LINE_COLOR0[0]);
            } else if (this.dd.dragonLevel == 2) {
                g.setColor(DragonDefines.LINE_COLOR1[0]);
            } else if (this.dd.dragonLevel == 3) {
                g.setColor(DragonDefines.LINE_COLOR2[0]);
            } else if (this.dd.dragonLevel == 4) {
                g.setColor(DragonDefines.LINE_COLOR3[0]);
            } else if (this.dd.dragonLevel == 5) {
                g.setColor(DragonDefines.LINE_COLOR4[0]);
            } else if (this.dd.dragonLevel == 6) {
                g.setColor(DragonDefines.LINE_COLOR5[0]);
            }
            g.fillTriangle(this.dd.line5[0], this.dd.line5[1], this.dd.line5[2], this.dd.line5[3], this.dd.line5[4], this.dd.line5[5]);
        }
        if (MainCanvas.isRotated) {
            g.drawImage(this.imgHead, this.dd.head[0], this.dd.head[1], 24);
        }
    }

    public void paintText(Graphics g) {
        if (MainCanvas.isRotated) {
            if (!this.isBackToLevel1) {
                int i;
                int x1 = MainCanvas.WIDTH - (MainCanvas.WIDTH >> 1);
                int x2 = MainCanvas.WIDTH - ((MainCanvas.WIDTH >> 1) + this.sprTabulka.getWidth());
                int count = 8;
                int y1 = (MainCanvas.HEIGHT >> 1) - this.sprTabulka.getHeight() * count;
                int y2 = (MainCanvas.HEIGHT >> 1) + this.sprTabulka.getHeight() * (count - 1);
                this.sprTabulka.setFrame(2);
                this.sprTabulka.setPosition(x1, y1);
                this.sprTabulka.paint(g);
                for (i = 0; i < count; ++i) {
                    this.sprTabulka.setFrame(5);
                    this.sprTabulka.setPosition(x1, (MainCanvas.HEIGHT >> 1) - i * this.sprTabulka.getHeight());
                    this.sprTabulka.paint(g);
                }
                for (i = 1; i < count - 1; ++i) {
                    this.sprTabulka.setFrame(5);
                    this.sprTabulka.setPosition(x1, (MainCanvas.HEIGHT >> 1) + i * this.sprTabulka.getHeight());
                    this.sprTabulka.paint(g);
                }
                this.sprTabulka.setFrame(8);
                this.sprTabulka.setPosition(x1, y2);
                this.sprTabulka.paint(g);
                this.sprTabulka.setFrame(0);
                this.sprTabulka.setPosition(x2, y1);
                this.sprTabulka.paint(g);
                for (i = 0; i < count; ++i) {
                    this.sprTabulka.setFrame(3);
                    this.sprTabulka.setPosition(x2, (MainCanvas.HEIGHT >> 1) - i * this.sprTabulka.getHeight());
                    this.sprTabulka.paint(g);
                }
                for (i = 1; i < count - 1; ++i) {
                    this.sprTabulka.setFrame(3);
                    this.sprTabulka.setPosition(x2, (MainCanvas.HEIGHT >> 1) + i * this.sprTabulka.getHeight());
                    this.sprTabulka.paint(g);
                }
                this.sprTabulka.setFrame(6);
                this.sprTabulka.setPosition(x2, y2);
                this.sprTabulka.paint(g);
            } else {
                int i;
                int x1 = MainCanvas.WIDTH - ((MainCanvas.WIDTH >> 1) - this.sprTabulka.getWidth());
                int x2 = MainCanvas.WIDTH - (MainCanvas.WIDTH >> 1);
                int x3 = MainCanvas.WIDTH - ((MainCanvas.WIDTH >> 1) + this.sprTabulka.getWidth());
                int x4 = MainCanvas.WIDTH - ((MainCanvas.WIDTH >> 1) + (this.sprTabulka.getWidth() << 1));
                int count = 8;
                int y1 = (MainCanvas.HEIGHT >> 1) - this.sprTabulka.getHeight() * count;
                int y2 = (MainCanvas.HEIGHT >> 1) + this.sprTabulka.getHeight() * (count - 1);
                this.sprTabulka.setFrame(2);
                this.sprTabulka.setPosition(x1, y1);
                this.sprTabulka.paint(g);
                for (i = 0; i < count; ++i) {
                    this.sprTabulka.setFrame(5);
                    this.sprTabulka.setPosition(x1, (MainCanvas.HEIGHT >> 1) - i * this.sprTabulka.getHeight());
                    this.sprTabulka.paint(g);
                }
                for (i = 1; i < count - 1; ++i) {
                    this.sprTabulka.setFrame(5);
                    this.sprTabulka.setPosition(x1, (MainCanvas.HEIGHT >> 1) + i * this.sprTabulka.getHeight());
                    this.sprTabulka.paint(g);
                }
                this.sprTabulka.setFrame(8);
                this.sprTabulka.setPosition(x1, y2);
                this.sprTabulka.paint(g);
                this.sprTabulka.setFrame(1);
                this.sprTabulka.setPosition(x2, y1);
                this.sprTabulka.paint(g);
                for (i = 0; i < count; ++i) {
                    this.sprTabulka.setFrame(4);
                    this.sprTabulka.setPosition(x2, (MainCanvas.HEIGHT >> 1) - i * this.sprTabulka.getHeight());
                    this.sprTabulka.paint(g);
                }
                for (i = 1; i < count - 1; ++i) {
                    this.sprTabulka.setFrame(4);
                    this.sprTabulka.setPosition(x2, (MainCanvas.HEIGHT >> 1) + i * this.sprTabulka.getHeight());
                    this.sprTabulka.paint(g);
                }
                this.sprTabulka.setFrame(7);
                this.sprTabulka.setPosition(x2, y2);
                this.sprTabulka.paint(g);
                this.sprTabulka.setFrame(1);
                this.sprTabulka.setPosition(x3, y1);
                this.sprTabulka.paint(g);
                for (i = 0; i < count; ++i) {
                    this.sprTabulka.setFrame(4);
                    this.sprTabulka.setPosition(x3, (MainCanvas.HEIGHT >> 1) - i * this.sprTabulka.getHeight());
                    this.sprTabulka.paint(g);
                }
                for (i = 1; i < count - 1; ++i) {
                    this.sprTabulka.setFrame(4);
                    this.sprTabulka.setPosition(x3, (MainCanvas.HEIGHT >> 1) + i * this.sprTabulka.getHeight());
                    this.sprTabulka.paint(g);
                }
                this.sprTabulka.setFrame(7);
                this.sprTabulka.setPosition(x3, y2);
                this.sprTabulka.paint(g);
                this.sprTabulka.setFrame(0);
                this.sprTabulka.setPosition(x4, y1);
                this.sprTabulka.paint(g);
                for (i = 0; i < count; ++i) {
                    this.sprTabulka.setFrame(3);
                    this.sprTabulka.setPosition(x4, (MainCanvas.HEIGHT >> 1) - i * this.sprTabulka.getHeight());
                    this.sprTabulka.paint(g);
                }
                for (i = 1; i < count - 1; ++i) {
                    this.sprTabulka.setFrame(3);
                    this.sprTabulka.setPosition(x4, (MainCanvas.HEIGHT >> 1) + i * this.sprTabulka.getHeight());
                    this.sprTabulka.paint(g);
                }
                this.sprTabulka.setFrame(6);
                this.sprTabulka.setPosition(x4, y2);
                this.sprTabulka.paint(g);
            }
            if (this.isBackToLevel1) {
                preparedText1.drawTextRotated(g, this.rectText1, 0, 3);
                preparedText2.drawTextRotated(g, this.rectText2, 0, 3);
                preparedText3.drawTextRotated(g, this.rectText3, 0, 3);
                preparedText4.drawTextRotated(g, this.rectText4, 0, 3);
            } else if (this.isGameOver) {
                preparedText.drawTextRotated(g, this.rectText, 0, 3);
            } else if (this.gd.levelCounter + 1 < 10) {
                preparedText.drawTextRotated(g, this.rectText, 0, 3);
            } else {
                preparedText.drawTextRotated(g, this.rectText, 0, 3);
            }
        }
    }

    public void paintPause(Graphics g) {
        if (MainCanvas.isRotated) {
            g.drawImage(this.imgPause, (this.imgPause.getWidth() >> 1) + 10, MainCanvas.HEIGHT - ((this.imgPause.getHeight() >> 1) + 10), 3);
        }
    }

    public void paintSea(Graphics g) {
        if (!this.isComplete && MainCanvas.isRotated) {
            if (this.gd.environment == 1) {
                g.setColor(EnvironmentsDefines.SEA_COLOR[this.gd.environment]);
                g.fillRect(0, 0, this.coords.space2SeaHeight - this.gd.shift, MainCanvas.HEIGHT);
            }
            if (this.gd.environment == 2) {
                g.setColor(EnvironmentsDefines.SEA_COLOR[this.gd.environment]);
                g.fillRect(0, 0, this.coords.space3SeaHeight - this.gd.shift, MainCanvas.HEIGHT);
            }
        }
    }

    public void paintMoon(Graphics g) {
        int posunRight = 5;
        if (!this.isComplete) {
            g.setColor(EnvironmentsDefines.MOON_COLOR[this.gd.environment]);
            if (MainCanvas.isRotated) {
                if (this.gd.environment == 0) {
                    g.fillArc(MainCanvas.WIDTH - (this.coords.space1Moon + this.coords.moonSize + this.gd.shift), MainCanvas.HEIGHT - (posunRight + this.coords.moonSize), this.coords.moonSize, this.coords.moonSize, 0, 360);
                } else if (this.gd.environment == 1) {
                    g.fillArc(MainCanvas.WIDTH - (this.coords.space2Moon + this.coords.moonSize + this.gd.shift), MainCanvas.HEIGHT - (posunRight + this.coords.moonSize), this.coords.moonSize, this.coords.moonSize, 0, 360);
                } else if (this.gd.environment == 2) {
                    g.fillArc(MainCanvas.WIDTH - (this.coords.space3Moon + this.coords.moonSize + this.gd.shift), MainCanvas.HEIGHT - (posunRight + this.coords.moonSize), this.coords.moonSize, this.coords.moonSize, 0, 360);
                }
            }
        }
    }

    public void paintMountains2(Graphics g) {
        if (MainCanvas.isRotated) {
            g.drawImage(this.imgMountains2, MainCanvas.WIDTH - this.ed.mountains2YaShift, this.ed.mountains2X1a, 20);
            g.drawImage(this.imgMountains2, MainCanvas.WIDTH - this.ed.mountains2YbShift, this.ed.mountains2X1b, 20);
            g.drawImage(this.imgMountains2, MainCanvas.WIDTH - this.ed.mountains2YaShift, this.ed.mountains2X2a, 20);
            g.drawImage(this.imgMountains2, MainCanvas.WIDTH - this.ed.mountains2YbShift, this.ed.mountains2X2b, 20);
        }
    }

    public void paintGate(Graphics g, int part) {
        if (part == 1 && MainCanvas.isRotated) {
            g.drawImage(this.imgGate1, MainCanvas.WIDTH - (this.gd.gateY + (this.gd.zoom << 2)), this.gd.gateX, 36);
        }
        if (part == 2 && MainCanvas.isRotated) {
            g.drawImage(this.imgGate2, MainCanvas.WIDTH - (this.gd.gateY + (this.gd.zoom << 2)), this.gd.gateX, 20);
        }
    }

    public int getY(int i) {
        int y = 0;
        if (MainCanvas.isRotated) {
            y = this.COORDS[i] + (MainCanvas.WIDTH - this.COORDS[i]) / (this.gd.maxZoom + 5 - this.gd.zoom) + this.gd.hillsShift;
        }
        return y;
    }

    public void paintItems(Graphics g) {
        if (!MainCanvas.isRotated) {
            for (int i = 0; i <= MainCanvas.WIDTH; ++i) {
                int y = this.gd.zoom == 0 ? this.COORDS[i] : this.getY(i);
                if (this.ITEMS[i] == 0) {
                    this.sprGold.setFrame(this.gd.frameGold);
                    this.sprGold.setPosition(i - (this.sprGold.getWidth() >> 1), y - (this.gd.radius << 1) + (this.gd.radius >> 2));
                    this.sprGold.paint(g);
                }
                if (this.ITEMS[i] == 6) {
                    g.drawImage(this.imgGoldOff, i - (this.gd.radius >> 2) - (this.sprGold.getWidth() >> 1), y - this.gd.radius, 6);
                }
                if (this.ITEMS[i] == 1) {
                    this.sprEnergy.setFrame(this.gd.frameEnergy);
                    this.sprEnergy.setPosition(i + (this.gd.radius >> 2) - (this.sprEnergy.getWidth() >> 1), y - (this.gd.radius << 1) - (this.gd.radius >> 2));
                    this.sprEnergy.paint(g);
                }
                if (this.ITEMS[i] == 7) {
                    g.drawImage(this.imgEnergyOff, i + (this.gd.radius >> 2) - (this.sprEnergy.getWidth() >> 1), y - this.gd.radius - (this.gd.radius >> 2), 6);
                }
                if (this.ITEMS[i] == 2) {
                    g.drawImage(this.imgSushi, i - (this.imgSushi.getWidth() >> 2), y, 36);
                }
                if (this.ITEMS[i] == 8) {
                    g.drawImage(this.imgOff, i - (this.imgSushi.getWidth() >> 2), y, 36);
                }
                if (this.ITEMS[i] == 3) {
                    this.sprClock.setFrame(this.gd.frameClock);
                    this.sprClock.setPosition(i - (this.sprClock.getWidth() >> 1) - (this.sprClock.getWidth() >> 2), this.ITEMS_HEIGHT[i] - (this.gd.radius << 1) - this.gd.radius - this.sprClock.getHeight() + this.gd.shift);
                    this.sprClock.paint(g);
                }
                if (this.ITEMS[i] != 9) continue;
                g.drawImage(this.imgOff, i - (this.sprClock.getWidth() >> 1), this.ITEMS_HEIGHT[i] - (this.gd.radius << 2) - (this.gd.radius << 1) + this.gd.shift, 6);
            }
        } else {
            for (int i = 0; i < MainCanvas.HEIGHT; ++i) {
                int y = this.gd.zoom == 0 ? this.COORDS[i] : this.getY(i);
                if (this.ITEMS[i] == 0) {
                    this.sprGold.setFrame(this.gd.frameGold);
                    this.sprGold.setPosition(MainCanvas.WIDTH - (y - (this.gd.radius >> 1)), i - (this.sprGold.getHeight() >> 1));
                    this.sprGold.paint(g);
                }
                if (this.ITEMS[i] == 6) {
                    g.drawImage(this.imgGoldOff, MainCanvas.WIDTH - (y - this.gd.radius), i + (this.gd.radius >> 2) + (this.sprGold.getHeight() >> 1), 33);
                }
                if (this.ITEMS[i] == 1) {
                    this.sprEnergy.setFrame(this.gd.frameEnergy);
                    this.sprEnergy.setPosition(MainCanvas.WIDTH - (y - (this.gd.radius >> 1)), i - (this.sprEnergy.getHeight() >> 1));
                    this.sprEnergy.paint(g);
                }
                if (this.ITEMS[i] == 7) {
                    g.drawImage(this.imgEnergyOff, MainCanvas.WIDTH - (y - this.gd.radius - (this.gd.radius >> 2)), i + (this.gd.radius >> 2) + (this.sprEnergy.getHeight() >> 1), 33);
                }
                if (this.ITEMS[i] == 2) {
                    g.drawImage(this.imgSushi, MainCanvas.WIDTH - (y + (this.gd.radius >> 1)), i + (this.gd.radius >> 1) + (this.imgSushi.getHeight() >> 1), 36);
                }
                if (this.ITEMS[i] == 8) {
                    g.drawImage(this.imgOff, MainCanvas.WIDTH - (y + (this.gd.radius >> 1)), i + (this.gd.radius >> 1) + (this.imgSushi.getHeight() >> 1), 36);
                }
                if (this.ITEMS[i] == 3) {
                    this.sprClock.setFrame(this.gd.frameClock);
                    this.sprClock.setPosition(MainCanvas.WIDTH - (this.ITEMS_HEIGHT[i] - (this.gd.radius << 1) - this.gd.radius + this.gd.shift), i - (this.sprClock.getWidth() >> 1) - (this.sprClock.getWidth() >> 2));
                    this.sprClock.paint(g);
                }
                if (this.ITEMS[i] != 9) continue;
                g.drawImage(this.imgOff, MainCanvas.WIDTH - (this.ITEMS_HEIGHT[i] - (this.gd.radius << 2) - (this.gd.radius << 1) + this.gd.shift), i - (this.sprClock.getWidth() >> 1), 17);
            }
        }
    }

    public void paintRemoved(Graphics g) {
        if (this.dd.dragonLevel == 0) {
            g.setColor(DragonDefines.DRAGON_COLORS[0]);
        } else if (this.dd.dragonLevel == 1) {
            g.setColor(DragonDefines.DRAGON_COLORS0[0]);
        } else if (this.dd.dragonLevel == 2) {
            g.setColor(DragonDefines.DRAGON_COLORS1[0]);
        } else if (this.dd.dragonLevel == 3) {
            g.setColor(DragonDefines.DRAGON_COLORS2[0]);
        } else if (this.dd.dragonLevel == 4) {
            g.setColor(DragonDefines.DRAGON_COLORS3[0]);
        } else if (this.dd.dragonLevel == 5) {
            g.setColor(DragonDefines.DRAGON_COLORS4[0]);
        } else if (this.dd.dragonLevel == 6) {
            g.setColor(DragonDefines.DRAGON_COLORS5[0]);
        }
        if (this.isRemoved1 && !this.isDragonBall && MainCanvas.isRotated) {
            g.fillTriangle(MainCanvas.WIDTH - this.gd.removedY1, this.gd.removedX1 - (this.gd.radius >> 1), MainCanvas.WIDTH - (this.gd.removedY1 + this.gd.radius), this.gd.removedX1 - (this.gd.radius >> 1), MainCanvas.WIDTH - (this.gd.removedY1 + (this.gd.radius >> 1)), this.gd.removedX1);
        }
        if (this.isRemoved2 && !this.isDragonBall && MainCanvas.isRotated) {
            g.fillTriangle(MainCanvas.WIDTH - this.gd.removedY2, this.gd.removedX2 - (this.gd.radius >> 1), MainCanvas.WIDTH - (this.gd.removedY2 + this.gd.radius), this.gd.removedX2 - (this.gd.radius >> 1), MainCanvas.WIDTH - (this.gd.removedY2 + (this.gd.radius >> 1)), this.gd.removedX2);
        }
        if (this.isRemoved3 && !this.isDragonBall && MainCanvas.isRotated) {
            g.fillTriangle(MainCanvas.WIDTH - this.gd.removedY3, this.gd.removedX3 - (this.gd.radius >> 1), MainCanvas.WIDTH - (this.gd.removedY3 + this.gd.radius), this.gd.removedX3 - (this.gd.radius >> 1), MainCanvas.WIDTH - (this.gd.removedY3 + (this.gd.radius >> 1)), this.gd.removedX3);
        }
    }

    public void paintAchievement(Graphics g) {
        if (MainCanvas.isRotated) {
            g.drawImage(this.imgAchievement, MainCanvas.WIDTH >> 1, MainCanvas.HEIGHT >> 1, 3);
        }
    }

    public void paintCountdown(Graphics g) {
        int posunY;
        int posunX;
        if (!this.isDragonBall) {
            posunX = this.imgHead.getWidth() << 1;
            posunY = this.imgHead.getHeight() >> 1;
        } else {
            posunX = this.sprDragonBall.getWidth() << 1;
            posunY = this.sprDragonBall.getHeight() >> 1;
        }
        if (MainCanvas.isRotated) {
            this.sprTabulka.setFrame(2);
            this.sprTabulka.setPosition(MainCanvas.WIDTH - (this.dd.headHeight - posunY), this.dd.headShift - this.sprTabulka.getHeight() + posunX);
            this.sprTabulka.paint(g);
            this.sprTabulka.setFrame(8);
            this.sprTabulka.setPosition(MainCanvas.WIDTH - (this.dd.headHeight - posunY), this.dd.headShift + posunX);
            this.sprTabulka.paint(g);
            this.sprTabulka.setFrame(0);
            this.sprTabulka.setPosition(MainCanvas.WIDTH - (this.dd.headHeight + this.sprTabulka.getWidth() - posunY), this.dd.headShift - this.sprTabulka.getHeight() + posunX);
            this.sprTabulka.paint(g);
            this.sprTabulka.setFrame(6);
            this.sprTabulka.setPosition(MainCanvas.WIDTH - (this.dd.headHeight + this.sprTabulka.getWidth() - posunY), this.dd.headShift + posunX);
            this.sprTabulka.paint(g);
            preparedTextCountdown.drawText(g, this.rectTextCountdown, 0, 24);
        }
    }

    public void paintStatusBar(Graphics g) {
        if (MainCanvas.isRotated) {
            g.drawImage(this.imgLista, MainCanvas.WIDTH, 0, 24);
        }
    }

    public void paintUkazovatelTime(Graphics g) {
        if (MainCanvas.isRotated) {
            int i;
            g.setClip(MainCanvas.WIDTH - (this.gd.sparklerY << 1), this.coords.getStatusBar1(this.imgLista.getHeight()), MainCanvas.WIDTH, this.gd.sparklerX);
            for (i = 0; i <= this.gd.sparklerMaxX / this.sprSnura.getHeight(); ++i) {
                if (this.gd.time > 0) {
                    if (this.isGameCompleted || this.isEnd || this.isBackToLevel1 || this.isLoadingNewLevel) {
                        this.sprSnura.setFrame(1);
                    } else if (this.gd.time <= 10 && this.gd.updateCounter % 20 < 10) {
                        this.sprSnura.setFrame(0);
                    } else {
                        this.sprSnura.setFrame(1);
                    }
                } else {
                    this.sprSnura.setFrame(1);
                }
                this.sprSnura.setPosition(MainCanvas.WIDTH - ((this.imgLista.getWidth() >> 1) + (this.sprSnura.getWidth() >> 1)), this.coords.getStatusBar1(this.imgLista.getHeight()) + i * this.sprSnura.getHeight());
                this.sprSnura.paint(g);
            }
            g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
            this.sprFire.setFrame(this.gd.frameFire);
            this.sprFire.setPosition(MainCanvas.WIDTH - (this.gd.sparklerY + this.sprSnura.getWidth()), this.coords.getStatusBar1(this.imgLista.getHeight()) + this.gd.sparklerX - (this.sprSnura.getHeight() >> 2));
            this.sprFire.paint(g);
            if (this.isComplete && !this.isBigSparkler) {
                for (i = 0; i < 3; ++i) {
                    Particles.createParticle(MainCanvas.WIDTH - this.gd.sparklerY, this.coords.getStatusBar1(this.imgLista.getHeight()) + this.gd.sparklerX, RandomNum.getRandomInt(30), RandomNum.getRandomInt(30), 0, 0, RandomNum.getRandomUInt(2) + 1, 0xFF7F00, RandomNum.getRandomUInt(5));
                }
            }
        }
    }

    public void paintUkazovatelSlides(Graphics g) {
        if (MainCanvas.isRotated) {
            preparedTextSlides1.drawText(g, this.rectTextSlides1, 0, 24);
            preparedTextSlides2.drawText(g, this.rectTextSlides2, 0, 24);
        }
    }

    public void paintUkazovatelCoins(Graphics g) {
        if (MainCanvas.isRotated) {
            this.sprCoinScore.setFrame(this.gd.frameGold);
            this.sprCoinScore.setPosition(MainCanvas.WIDTH - ((this.imgLista.getWidth() - this.sprCoinScore.getWidth() >> 1) + this.sprCoinScore.getWidth()), this.gd.radius >> 1);
            this.sprCoinScore.paint(g);
            if (this.gd.coins >= 100) {
                preparedTextCoins1.drawText(g, this.rectTextCoins1, 0, 24);
                preparedTextCoins2.drawText(g, this.rectTextCoins2, 0, 24);
                preparedTextCoins3.drawText(g, this.rectTextCoins3, 0, 24);
            } else if (this.gd.coins >= 10) {
                preparedTextCoins2.drawText(g, this.rectTextCoins2, 0, 24);
                preparedTextCoins3.drawText(g, this.rectTextCoins3, 0, 24);
            } else {
                preparedTextCoins3.drawText(g, this.rectTextCoins3, 0, 24);
            }
        }
    }

    public void paint(Graphics g) {
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        g.setColor(EnvironmentsDefines.BG_COLOR_GAME[this.gd.environment]);
        g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        if (this.isComplete) {
            if (this.gd.environment >= 1) {
                this.paintSea(g);
            }
            this.paintMoon(g);
        } else {
            this.paintMoon(g);
            if (this.gd.environment >= 1) {
                this.paintSea(g);
            }
        }
        if (!this.isNewLevelLoading) {
            if (this.gd.environment == 0) {
                if (this.isMountains2) {
                    this.paintMountains2(g);
                }
            } else if (this.gd.environment == 1 || this.gd.environment == 2) {
                // empty if block
            }
            if (this.isGate) {
                this.paintGate(g, 1);
            }
            if (this.isHills && this.gd.cursorX >= 0) {
                this.paintHills(g);
            }
            this.paintItems(g);
            if (!this.isGameOver && this.isComplete) {
                this.paintDust(g);
            }
        }
        this.paintStatusBar(g);
        this.paintUkazovatelCoins(g);
        this.paintUkazovatelTime(g);
        if ((this.isGoodSlides || this.isDragonBall) && this.gd.textSlides1 > 0) {
            this.paintUkazovatelSlides(g);
        }
        if (this.isEffect && !this.isGameOver) {
            this.paintEffects(g);
        }
        Particles.paint(g);
        if (!this.isDragonBall) {
            this.paintDragon(g);
        } else {
            this.paintDragonBall(g);
        }
        if (!this.isNewLevelLoading) {
            if (this.isRemovedPart) {
                this.paintRemoved(g);
            }
            if (this.isGate) {
                this.paintGate(g, 2);
            }
            if (this.isGameOver) {
                this.paintText(g);
            } else if (this.isAchievement && this.ad.achievementTimer % 2 == 1) {
                this.paintAchievement(g);
            }
        }
        if ((this.isNewLevelIndicator || this.isLevel1Indicator) && !this.isGameOver) {
            this.paintText(g);
        }
        if (!this.isGameOver) {
            this.paintPause(g);
        }
        if (this.isCountdown && this.gd.countdownTimer > 0 && !this.isGameOver && !this.isNewLevelIndicator && !this.isLevel1Indicator) {
            this.paintCountdown(g);
        }
    }

    public void pointerPressed(int x, int y) {
        if (this.isLevel1Indicator) {
            this.isLevel1Indicator = false;
            this.gd.level1Timer = 0;
            this.gd.glidingTimer = 0;
        }
        if (MainCanvas.isRotated) {
            if (x <= this.imgPause.getWidth() + 20 && y >= MainCanvas.HEIGHT - (this.imgPause.getHeight() + 20)) {
                if (!this.isTimeUp && !this.isGameOver) {
                    this.achievement(2, 0);
                    this.actionPause();
                }
            } else if (!(this.isLoadingFlag || this.isStartSparkling || this.isCountdown)) {
                this.actionFire();
            }
        }
    }

    public void pointerDragged(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
        this.isPressedAction = false;
    }

    public int min(int a, int b, int c) {
        if (a <= b && a <= c) {
            return a;
        }
        if (b <= a && b <= c) {
            return b;
        }
        return c;
    }

    public void achievement(int aNumber, int aLevel) {
        if (aNumber == 1) {
            if (aLevel == 0 && this.ad.achievement1 == 0 && this.dd.dragonLevel == 0) {
                ++this.ad.aGoodSlides;
                if (this.ad.aGoodSlides == 15) {
                    ++this.ad.achievement1;
                    this.ad.aGoodSlides = 0;
                    this.saveAchievements(1);
                }
            } else if (aLevel == 1 && this.ad.achievement1 == 1 && this.dd.dragonLevel == 1) {
                ++this.ad.aCoins;
                if (this.ad.aCoins == 200) {
                    ++this.ad.achievement1;
                    this.ad.aCoins = 0;
                    this.saveAchievements(1);
                }
            } else if (aLevel == 2 && this.ad.achievement1 == 2 && this.dd.dragonLevel == 2) {
                this.ad.aDistance += this.gd.move;
                if (this.ad.aDistance >= 50000) {
                    ++this.ad.achievement1;
                    this.ad.aDistance = 0;
                    this.saveAchievements(1);
                }
            } else if (aLevel == 3 && this.ad.achievement1 == 3 && this.dd.dragonLevel == 3) {
                ++this.ad.aCoins;
                if (this.ad.aCoins == 300) {
                    ++this.ad.achievement1;
                    this.ad.aCoins = 0;
                    this.saveAchievements(1);
                }
            } else if (aLevel == 4 && this.ad.achievement1 == 4 && this.dd.dragonLevel == 4) {
                this.ad.aDistance += this.gd.move;
                if (this.ad.aDistance >= 150000) {
                    ++this.ad.achievement1;
                    this.ad.aDistance = 0;
                    this.saveAchievements(1);
                }
            } else if (aLevel == 5 && this.ad.achievement1 == 5 && this.dd.dragonLevel == 5) {
                ++this.ad.aCoins;
                if (this.ad.aCoins == 500) {
                    ++this.ad.achievement1;
                    this.ad.aCoins = 0;
                    this.saveAchievements(1);
                }
            }
        } else if (aNumber == 2) {
            if (aLevel == 0 && this.ad.achievement2 == 0 && this.dd.dragonLevel == 0) {
                ++this.ad.achievement2;
                this.isPauseAchievement = true;
                this.saveAchievements(1);
            } else if (aLevel == 1 && this.ad.achievement2 == 1 && this.dd.dragonLevel == 1) {
                ++this.ad.aDragonBalls;
                if (this.ad.aDragonBalls == 5) {
                    ++this.ad.achievement2;
                    this.ad.aDragonBalls = 0;
                    this.saveAchievements(1);
                }
            } else if (aLevel == 2 && this.ad.achievement2 == 2 && this.dd.dragonLevel == 2) {
                if (this.gd.level >= 5) {
                    ++this.ad.achievement2;
                    this.saveAchievements(1);
                }
            } else if (aLevel == 3 && this.ad.achievement2 == 3 && this.dd.dragonLevel == 3) {
                if (this.gd.time >= this.ad.aInputTime >> 1) {
                    ++this.ad.achievement2;
                    this.ad.aInputTime = 0;
                    this.saveAchievements(1);
                }
            } else if (aLevel == 4 && this.ad.achievement2 == 4 && this.dd.dragonLevel == 4) {
                if (this.ad.aSegments == 0) {
                    ++this.ad.achievement2;
                    this.saveAchievements(1);
                }
            } else if (aLevel == 5 && this.ad.achievement2 == 5 && this.dd.dragonLevel == 5 && this.ad.aImpacts == 0) {
                ++this.ad.achievement2;
                this.saveAchievements(1);
            }
        } else if (aNumber == 3) {
            if (aLevel == 0 && this.ad.achievement3 == 0 && this.dd.dragonLevel == 0) {
                if (this.dd.bodyParts == 5) {
                    ++this.ad.achievement3;
                    this.saveAchievements(1);
                }
            } else if (aLevel == 1 && this.ad.achievement3 == 1 && this.dd.dragonLevel == 1) {
                ++this.ad.aEnergy;
                if (this.ad.aEnergy == 15) {
                    ++this.ad.achievement3;
                    this.ad.aEnergy = 0;
                    this.saveAchievements(1);
                }
            } else if (aLevel == 2 && this.ad.achievement3 == 2 && this.dd.dragonLevel == 2) {
                ++this.ad.aClocks;
                if (this.ad.aClocks == 15) {
                    ++this.ad.achievement3;
                    this.ad.aClocks = 0;
                    this.saveAchievements(1);
                }
            } else if (aLevel == 3 && this.ad.achievement3 == 3 && this.dd.dragonLevel == 3) {
                ++this.ad.aSushi;
                if (this.ad.aSushi == 15) {
                    ++this.ad.achievement3;
                    this.ad.aSushi = 0;
                    this.saveAchievements(1);
                }
            } else if (aLevel == 4 && this.ad.achievement3 == 4 && this.dd.dragonLevel == 4) {
                if (this.gd.level >= 10) {
                    ++this.ad.achievement3;
                    this.saveAchievements(1);
                }
            } else if (aLevel == 5 && this.ad.achievement3 == 5 && this.dd.dragonLevel == 5) {
                ++this.ad.achievement3;
                this.saveAchievements(1);
            }
        }
    }

    public void checkNewDragonLevel() {
        if (this.ad.achievement1 == 1 && this.ad.achievement2 == 1 && this.ad.achievement3 == 1 && this.dd.dragonLevel == 0) {
            ++this.dd.dragonLevel;
            this.initTimeNewDragonLevel(GameDefines.LEVEL_TIME[0] / 20);
        }
        if (this.ad.achievement1 == 2 && this.ad.achievement2 == 2 && this.ad.achievement3 == 2 && this.dd.dragonLevel == 1) {
            ++this.dd.dragonLevel;
            this.initTimeNewDragonLevel(GameDefines.LEVEL_TIME[0] / 20 + GameDefines.LEVEL_TIME[this.gd.level] / 20);
        }
        if (this.ad.achievement1 == 3 && this.ad.achievement2 == 3 && this.ad.achievement3 == 3 && this.dd.dragonLevel == 2) {
            ++this.dd.dragonLevel;
            this.addBodyPart();
            this.initTimeNewDragonLevel(GameDefines.LEVEL_TIME[0] / 20 + GameDefines.LEVEL_TIME[this.gd.level] / 20);
        }
        if (this.ad.achievement1 == 4 && this.ad.achievement2 == 4 && this.ad.achievement3 == 4 && this.dd.dragonLevel == 3) {
            ++this.dd.dragonLevel;
            this.initTimeNewDragonLevel(GameDefines.LEVEL_TIME[0] / 10 + GameDefines.LEVEL_TIME[this.gd.level] / 20);
        }
        if (this.ad.achievement1 == 5 && this.ad.achievement2 == 5 && this.ad.achievement3 == 5 && this.dd.dragonLevel == 4) {
            ++this.dd.dragonLevel;
            this.initTimeNewDragonLevel(GameDefines.LEVEL_TIME[0] / 10 + GameDefines.LEVEL_TIME[this.gd.level] / 10);
        }
        if (this.ad.achievement1 == 6 && this.ad.achievement2 == 6 && this.ad.achievement3 == 6 && this.dd.dragonLevel == 5) {
            ++this.dd.dragonLevel;
            this.addBodyPart();
            this.initTimeNewDragonLevel(GameDefines.LEVEL_TIME[0] / 6 + GameDefines.LEVEL_TIME[this.gd.level] / 10);
        }
    }

    public void loadAchievements() {
        RMSObjects.createRMSConnect(2);
        if (!RMSObjects.rmsConnects[2].load()) {
            RMSObjects.rmsConnects[2].create();
        }
        this.ad.achievement1 = RMSObjects.achievements.getAchievement1();
        this.ad.achievement2 = RMSObjects.achievements.getAchievement2();
        this.ad.achievement3 = RMSObjects.achievements.getAchievement3();
        this.ad.aSushi = RMSObjects.achievements.getASushi();
        this.ad.aGoodSlides = RMSObjects.achievements.getAGoodSlides();
        this.ad.aCoins = RMSObjects.achievements.getACoins();
        this.ad.aEnergy = RMSObjects.achievements.getAEnergy();
        this.ad.aClocks = RMSObjects.achievements.getAClocks();
        this.ad.aDragonBalls = RMSObjects.achievements.getADragonBalls();
        this.ad.aSegments = RMSObjects.achievements.getASegments();
        this.ad.aImpacts = RMSObjects.achievements.getAImpacts();
        this.ad.aInputTime = RMSObjects.achievements.getAInputTime();
        this.ad.aDistance = RMSObjects.achievements.getADistance();
        RMSObjects.freeRMSConnect(2);
        this.dd.dragonLevel = this.min(this.ad.achievement1, this.ad.achievement2, this.ad.achievement3);
    }

    public void saveAchievements(int i) {
        RMSObjects.achievements.achievement1 = this.ad.achievement1;
        RMSObjects.achievements.achievement2 = this.ad.achievement2;
        RMSObjects.achievements.achievement3 = this.ad.achievement3;
        RMSObjects.achievements.aSushi = this.ad.aSushi;
        RMSObjects.achievements.aGoodSlides = this.ad.aGoodSlides;
        RMSObjects.achievements.aCoins = this.ad.aCoins;
        RMSObjects.achievements.aEnergy = this.ad.aEnergy;
        RMSObjects.achievements.aClocks = this.ad.aClocks;
        RMSObjects.achievements.aDragonBalls = this.ad.aDragonBalls;
        RMSObjects.achievements.aSegments = this.ad.aSegments;
        RMSObjects.achievements.aImpacts = this.ad.aImpacts;
        RMSObjects.achievements.aInputTime = this.ad.aInputTime;
        RMSObjects.achievements.aDistance = this.ad.aDistance;
        RMSObjects.createRMSConnect(2);
        if (!RMSObjects.rmsConnects[2].isExist()) {
            RMSObjects.rmsConnects[2].create();
        }
        RMSObjects.rmsConnects[2].save();
        RMSObjects.freeRMSConnect(2);
        if (i == 1) {
            this.initAchievement();
            this.checkNewDragonLevel();
            if (this.isComplete) {
                this.setHeadColor();
                this.setDragonBallColor();
            }
        }
    }

    public void deleteAchievements() {
        RMSObjects.createRMSConnect(2);
        RMSObjects.rmsConnects[2].delete();
        RMSObjects.freeRMSConnect(2);
    }

    public void loadGame() {
        int i;
        this.gd.environment = RMSObjects.savedGame.getEnvironment();
        this.gd.level = RMSObjects.savedGame.getLevel();
        this.gd.zoom = RMSObjects.savedGame.getZoom();
        this.gd.zoomCounter = RMSObjects.savedGame.getZoomCounter();
        this.gd.goodSlides = RMSObjects.savedGame.getGoodSlides();
        this.gd.badImpacts = RMSObjects.savedGame.getBadImpacts();
        this.gd.score = RMSObjects.savedGame.getScore();
        this.gd.coins = RMSObjects.savedGame.getCoins();
        this.gd.maxZoom = RMSObjects.savedGame.getMaxZoom();
        this.gd.hillsShift = RMSObjects.savedGame.getHillsShift();
        this.gd.levelLength = RMSObjects.savedGame.getLevelLength();
        this.gd.time = RMSObjects.savedGame.getTime();
        this.gd.distance = RMSObjects.savedGame.getDistance();
        this.gd.acceleration = RMSObjects.savedGame.getAcceleration();
        this.gd.move = RMSObjects.savedGame.getMove();
        this.gd.movePom = RMSObjects.savedGame.getMovePom();
        this.gd.jumpSpeed = RMSObjects.savedGame.getJumpSpeed();
        this.gd.jumpHeight = RMSObjects.savedGame.getJumpHeight();
        this.gd.originalAcceleration = RMSObjects.savedGame.getOriginalAcceleration();
        this.dd.bodyParts = RMSObjects.savedGame.getBodyParts();
        this.dd.tailHeight = RMSObjects.savedGame.getTailHeight();
        this.dd.tailHeight2 = RMSObjects.savedGame.getTailHeight2();
        this.dd.headHeight = RMSObjects.savedGame.getHeadHeight();
        this.dd.tailShift = RMSObjects.savedGame.getTailShift();
        this.dd.tailShift2 = RMSObjects.savedGame.getTailShift2();
        this.dd.headShift = RMSObjects.savedGame.getHeadShift();
        this.dd.halfHeadWidth = RMSObjects.savedGame.getHalfHeadWidth();
        this.dd.dragonHeadShift = RMSObjects.savedGame.getDragonHeadShift();
        this.dd.dragonBodyShift = RMSObjects.savedGame.getDragonBodyShift();
        this.gd.dragonBallStarter = RMSObjects.savedGame.getDragonBallStarter();
        this.gd.dragonBallJumps = RMSObjects.savedGame.getDragonBallJumps();
        this.gd.dragonBallJumpsAllowed = RMSObjects.savedGame.getDragonBallJumpsAllowed();
        this.gd.newLevelTimer = RMSObjects.savedGame.getNewLevelTimer();
        this.gd.glidingTimer = RMSObjects.savedGame.getGlidingTimer();
        this.gd.postupnost = RMSObjects.savedGame.getPostupnost();
        this.ad.achievementTimer = RMSObjects.savedGame.getAchievementTimer();
        this.gd.timerWidth = RMSObjects.savedGame.getTimerWidth();
        this.gd.level1Timer = RMSObjects.savedGame.getLevel1Timer();
        this.gd.clocksCount = RMSObjects.savedGame.getClocksCount();
        this.gd.levelLengthPom = RMSObjects.savedGame.getLevelLengthPom();
        this.gd.generatedClocks = RMSObjects.savedGame.getGeneratedClocks();
        this.gd.levelCounter = RMSObjects.savedGame.getLevelCounter();
        this.gd.generatingLastHill = RMSObjects.savedGame.getGeneratingLastHill();
        this.gd.maxTime = RMSObjects.savedGame.getMaxTime();
        this.gd.size0 = RMSObjects.savedGame.getSize0();
        this.gd.size1 = RMSObjects.savedGame.getSize1();
        this.gd.size2 = RMSObjects.savedGame.getSize2();
        this.gd.size3 = RMSObjects.savedGame.getSize3();
        this.gd.size4 = RMSObjects.savedGame.getSize4();
        this.gd.size5 = RMSObjects.savedGame.getSize5();
        this.gd.energyAcceleratingTimer = RMSObjects.savedGame.getEnergyAcceleratingTimer();
        this.gd.hillsPartWidth = RMSObjects.savedGame.getHillsPartWidth();
        this.gd.radius = RMSObjects.savedGame.getRadius();
        this.gd.updateCounter = RMSObjects.savedGame.getUpdateCounter();
        this.gd.direction = RMSObjects.savedGame.getDirection();
        this.gd.cursorX = RMSObjects.savedGame.getCursorX();
        this.gd.cursorY = RMSObjects.savedGame.getCursorY();
        this.gd.lastX = RMSObjects.savedGame.getLastX();
        this.gd.gameOverTimer = RMSObjects.savedGame.getGameOverTimer();
        this.gd.ceilingDragon = RMSObjects.savedGame.getCeilingDragon();
        this.gd.sparklerX = RMSObjects.savedGame.getSparklerX();
        this.gd.sparklerY = RMSObjects.savedGame.getSparklerY();
        this.gd.sparklerStep = RMSObjects.savedGame.getSparklerStep();
        this.gd.sparklerMaxX = RMSObjects.savedGame.getSparklerMaxX();
        this.gd.timeAdd = RMSObjects.savedGame.getTimeAdd();
        this.gd.floor = RMSObjects.savedGame.getFloor();
        this.gd.ceiling = RMSObjects.savedGame.getCeiling();
        this.gd.type = RMSObjects.savedGame.getType();
        this.gd.gateX = RMSObjects.savedGame.getGateX();
        this.gd.gateY = RMSObjects.savedGame.getGateY();
        this.gd.fallingStep = RMSObjects.savedGame.getFallingStep();
        this.gd.dragonShift = RMSObjects.savedGame.getDragonShift();
        this.gd.goodSlidingStarter = RMSObjects.savedGame.getGoodSlidingStarter();
        this.gd.shift = RMSObjects.savedGame.getShift();
        this.isInfinite = RMSObjects.savedGame.getIsInfinite();
        this.isComplete = RMSObjects.savedGame.getIsComplete();
        this.isPlaying = RMSObjects.savedGame.getIsPlaying();
        this.isFlying = RMSObjects.savedGame.getIsFlying();
        this.isLanding = RMSObjects.savedGame.getIsLanding();
        this.isWaiting = RMSObjects.savedGame.getIsWaiting();
        this.isPause = RMSObjects.savedGame.getIsPause();
        this.isTimeAdd = RMSObjects.savedGame.getIsTimeAdd();
        this.isNewLevelIndicator = RMSObjects.savedGame.getIsNewLevelIndicator();
        this.isEffect = RMSObjects.savedGame.getIsEffect();
        this.isGameCompleted = RMSObjects.savedGame.getIsGameCompleted();
        this.isAccelerating = RMSObjects.savedGame.getIsAccelerating();
        this.isSlowingDown = RMSObjects.savedGame.getIsSlowingDown();
        this.isGameOver = RMSObjects.savedGame.getIsGameOver();
        this.isDragonBall = RMSObjects.savedGame.getIsDragonBall();
        this.isTutorial = RMSObjects.savedGame.getIsTutorial();
        this.isTutorialStopped = RMSObjects.savedGame.getIsTutorialStopped();
        this.isTutorialPushed = RMSObjects.savedGame.getIsTutorialPushed();
        this.isNewLevelLoading = RMSObjects.savedGame.getIsNewLevelLoading();
        this.isEnergyAccelerating = RMSObjects.savedGame.getIsEnergyAccelerating();
        this.isSparkling = RMSObjects.savedGame.getIsSparkling();
        this.isStartSparkling = RMSObjects.savedGame.getIsStartSparkling();
        this.isSparkler = RMSObjects.savedGame.getIsSparkler();
        this.isBigSparkler = RMSObjects.savedGame.getIsBigSparkler();
        this.isAchievement = RMSObjects.savedGame.getIsAchievement();
        this.isPauseAchievement = RMSObjects.savedGame.getIsPauseAchievement();
        this.isBackToLevel1 = RMSObjects.savedGame.getIsBackToLevel1();
        this.isRepeated = RMSObjects.savedGame.getIsRepeated();
        this.isLevel1Indicator = RMSObjects.savedGame.getIsLevel1Indicator();
        this.isGeneratingClocks = RMSObjects.savedGame.getIsGeneratingClocks();
        this.isAddingClocks = RMSObjects.savedGame.getIsAddingClocks();
        this.isAddedClocks = RMSObjects.savedGame.getIsAddedClocks();
        this.isGoodSlides = RMSObjects.savedGame.getIsGoodSlides();
        this.isFalling = RMSObjects.savedGame.getIsFalling();
        this.isBg = RMSObjects.savedGame.getIsBg();
        this.isMoon = RMSObjects.savedGame.getIsMoon();
        this.isCloudsA = RMSObjects.savedGame.getIsCloudsA();
        this.isMountains1 = RMSObjects.savedGame.getIsMountains1();
        this.isMountains2 = RMSObjects.savedGame.getIsMountains2();
        this.isCloudsB = RMSObjects.savedGame.getIsCloudsB();
        this.isObjects = RMSObjects.savedGame.getIsObjects();
        this.isCloudsC = RMSObjects.savedGame.getIsCloudsC();
        this.isCloudsD = RMSObjects.savedGame.getIsCloudsD();
        this.isHills = RMSObjects.savedGame.getIsHills();
        this.isCoins = RMSObjects.savedGame.getIsCoins();
        this.isEnergy = RMSObjects.savedGame.getIsEnergy();
        this.isSushi = RMSObjects.savedGame.getIsSushi();
        this.isClock = RMSObjects.savedGame.getIsClock();
        this.isGeneratingLastHill = RMSObjects.savedGame.getIsGeneratingLastHill();
        this.isLastHillStart = RMSObjects.savedGame.getIsLastHillStart();
        this.isLastHillTop = RMSObjects.savedGame.getIsLastHillTop();
        this.isLastHillEnd = RMSObjects.savedGame.getIsLastHillEnd();
        this.isIslandEnd = RMSObjects.savedGame.getIsIslandEnd();
        this.isLevelEnd = RMSObjects.savedGame.getIsLevelEnd();
        this.isGeneratedEnd = RMSObjects.savedGame.getIsGeneratedEnd();
        this.isEnd = RMSObjects.savedGame.getIsEnd();
        this.isTimeUp = RMSObjects.savedGame.getIsTimeUp();
        this.isPullingDownLeft = RMSObjects.savedGame.getIsPullingDownLeft();
        this.isPullingDownRight = RMSObjects.savedGame.getIsPullingDownRight();
        this.isAddingCoins = RMSObjects.savedGame.getIsAddingCoins();
        this.isGate = RMSObjects.savedGame.getIsGate();
        this.isControllable = RMSObjects.savedGame.getIsControllable();
        this.isSliding = RMSObjects.savedGame.getIsSliding();
        this.isLoadingNewLevel = RMSObjects.savedGame.getIsLoadingNewLevel();
        this.isLastCurve = RMSObjects.savedGame.getIsLastCurve();
        for (i = 0; i < this.maxCoords; ++i) {
            this.COORDS[i] = RMSObjects.savedGame.getCoords(i);
            this.ITEMS[i] = RMSObjects.savedGame.getItems(i);
            this.ITEMS_HEIGHT[i] = RMSObjects.savedGame.getItemsHeight(i);
        }
        for (i = 0; i < 5; ++i) {
            this.dd.BODY_HEIGHT[i] = RMSObjects.savedGame.getBodyHeight(i);
            this.dd.BODY_SHIFT[i] = RMSObjects.savedGame.getBodyShift(i);
            this.dd.BODY_SHIFT2[i] = RMSObjects.savedGame.getBodyShift2(i);
        }
    }

    public void saveGame() {
        int i;
        RMSObjects.savedGame.environment = this.gd.environment;
        RMSObjects.savedGame.level = this.gd.level;
        RMSObjects.savedGame.zoom = this.gd.zoom;
        RMSObjects.savedGame.zoomCounter = this.gd.zoomCounter;
        RMSObjects.savedGame.goodSlides = this.gd.goodSlides;
        RMSObjects.savedGame.badImpacts = this.gd.badImpacts;
        RMSObjects.savedGame.score = this.gd.score;
        RMSObjects.savedGame.coins = this.gd.coins;
        RMSObjects.savedGame.maxZoom = this.gd.maxZoom;
        RMSObjects.savedGame.hillsShift = this.gd.hillsShift;
        RMSObjects.savedGame.levelLength = this.gd.levelLength;
        RMSObjects.savedGame.time = this.gd.time;
        RMSObjects.savedGame.distance = this.gd.distance;
        RMSObjects.savedGame.acceleration = this.gd.acceleration;
        RMSObjects.savedGame.move = this.gd.move;
        RMSObjects.savedGame.movePom = this.gd.movePom;
        RMSObjects.savedGame.jumpSpeed = this.gd.jumpSpeed;
        RMSObjects.savedGame.jumpHeight = this.gd.jumpHeight;
        RMSObjects.savedGame.originalAcceleration = this.gd.originalAcceleration;
        RMSObjects.savedGame.bodyParts = this.dd.bodyParts;
        RMSObjects.savedGame.tailHeight = this.dd.tailHeight;
        RMSObjects.savedGame.tailHeight2 = this.dd.tailHeight2;
        RMSObjects.savedGame.headHeight = this.dd.headHeight;
        RMSObjects.savedGame.tailShift = this.dd.tailShift;
        RMSObjects.savedGame.tailShift2 = this.dd.tailShift2;
        RMSObjects.savedGame.headShift = this.dd.headShift;
        RMSObjects.savedGame.halfHeadWidth = this.dd.halfHeadWidth;
        RMSObjects.savedGame.dragonHeadShift = this.dd.dragonHeadShift;
        RMSObjects.savedGame.dragonBodyShift = this.dd.dragonBodyShift;
        RMSObjects.savedGame.dragonBallStarter = this.gd.dragonBallStarter;
        RMSObjects.savedGame.dragonBallJumps = this.gd.dragonBallJumps;
        RMSObjects.savedGame.dragonBallJumpsAllowed = this.gd.dragonBallJumpsAllowed;
        RMSObjects.savedGame.newLevelTimer = this.gd.newLevelTimer;
        RMSObjects.savedGame.glidingTimer = this.gd.glidingTimer;
        RMSObjects.savedGame.postupnost = this.gd.postupnost;
        RMSObjects.savedGame.achievementTimer = this.ad.achievementTimer;
        RMSObjects.savedGame.timerWidth = this.gd.timerWidth;
        RMSObjects.savedGame.level1Timer = this.gd.level1Timer;
        RMSObjects.savedGame.clocksCount = this.gd.clocksCount;
        RMSObjects.savedGame.levelLengthPom = this.gd.levelLengthPom;
        RMSObjects.savedGame.generatedClocks = this.gd.generatedClocks;
        RMSObjects.savedGame.levelCounter = this.gd.levelCounter;
        RMSObjects.savedGame.generatingLastHill = this.gd.generatingLastHill;
        RMSObjects.savedGame.maxTime = this.gd.maxTime;
        RMSObjects.savedGame.size0 = this.gd.size0;
        RMSObjects.savedGame.size1 = this.gd.size1;
        RMSObjects.savedGame.size2 = this.gd.size2;
        RMSObjects.savedGame.size3 = this.gd.size3;
        RMSObjects.savedGame.size4 = this.gd.size4;
        RMSObjects.savedGame.size5 = this.gd.size5;
        RMSObjects.savedGame.energyAcceleratingTimer = this.gd.energyAcceleratingTimer;
        RMSObjects.savedGame.hillsPartWidth = this.gd.hillsPartWidth;
        RMSObjects.savedGame.radius = this.gd.radius;
        RMSObjects.savedGame.updateCounter = this.gd.updateCounter;
        RMSObjects.savedGame.direction = this.gd.direction;
        RMSObjects.savedGame.cursorX = this.gd.cursorX;
        RMSObjects.savedGame.cursorY = this.gd.cursorY;
        RMSObjects.savedGame.lastX = this.gd.lastX;
        RMSObjects.savedGame.gameOverTimer = this.gd.gameOverTimer;
        RMSObjects.savedGame.ceilingDragon = this.gd.ceilingDragon;
        RMSObjects.savedGame.sparklerX = this.gd.sparklerX;
        RMSObjects.savedGame.sparklerY = this.gd.sparklerY;
        RMSObjects.savedGame.sparklerStep = this.gd.sparklerStep;
        RMSObjects.savedGame.sparklerMaxX = this.gd.sparklerMaxX;
        RMSObjects.savedGame.timeAdd = this.gd.timeAdd;
        RMSObjects.savedGame.floor = this.gd.floor;
        RMSObjects.savedGame.ceiling = this.gd.ceiling;
        RMSObjects.savedGame.type = this.gd.type;
        RMSObjects.savedGame.gateX = this.gd.gateX;
        RMSObjects.savedGame.gateY = this.gd.gateY;
        RMSObjects.savedGame.fallingStep = this.gd.fallingStep;
        RMSObjects.savedGame.dragonShift = this.gd.dragonShift;
        RMSObjects.savedGame.goodSlidingStarter = this.gd.goodSlidingStarter;
        RMSObjects.savedGame.shift = this.gd.shift;
        RMSObjects.savedGame.isInfinite = this.isInfinite;
        RMSObjects.savedGame.isComplete = this.isComplete;
        RMSObjects.savedGame.isPlaying = this.isPlaying;
        RMSObjects.savedGame.isFlying = this.isFlying;
        RMSObjects.savedGame.isLanding = this.isLanding;
        RMSObjects.savedGame.isWaiting = this.isWaiting;
        RMSObjects.savedGame.isPause = this.isPause;
        RMSObjects.savedGame.isTimeAdd = this.isTimeAdd;
        RMSObjects.savedGame.isNewLevelIndicator = this.isNewLevelIndicator;
        RMSObjects.savedGame.isEffect = this.isEffect;
        RMSObjects.savedGame.isGameCompleted = this.isGameCompleted;
        RMSObjects.savedGame.isAccelerating = this.isAccelerating;
        RMSObjects.savedGame.isSlowingDown = this.isSlowingDown;
        RMSObjects.savedGame.isGameOver = this.isGameOver;
        RMSObjects.savedGame.isDragonBall = this.isDragonBall;
        RMSObjects.savedGame.isTutorial = this.isTutorial;
        RMSObjects.savedGame.isTutorialStopped = this.isTutorialStopped;
        RMSObjects.savedGame.isTutorialPushed = this.isTutorialPushed;
        RMSObjects.savedGame.isNewLevelLoading = this.isNewLevelLoading;
        RMSObjects.savedGame.isEnergyAccelerating = this.isEnergyAccelerating;
        RMSObjects.savedGame.isSparkling = this.isSparkling;
        RMSObjects.savedGame.isStartSparkling = this.isStartSparkling;
        RMSObjects.savedGame.isSparkler = this.isSparkler;
        RMSObjects.savedGame.isBigSparkler = this.isBigSparkler;
        RMSObjects.savedGame.isAchievement = this.isAchievement;
        RMSObjects.savedGame.isPauseAchievement = this.isPauseAchievement;
        RMSObjects.savedGame.isBackToLevel1 = this.isBackToLevel1;
        RMSObjects.savedGame.isRepeated = this.isRepeated;
        RMSObjects.savedGame.isLevel1Indicator = this.isLevel1Indicator;
        RMSObjects.savedGame.isGeneratingClocks = this.isGeneratingClocks;
        RMSObjects.savedGame.isAddingClocks = this.isAddingClocks;
        RMSObjects.savedGame.isAddedClocks = this.isAddedClocks;
        RMSObjects.savedGame.isGoodSlides = this.isGoodSlides;
        RMSObjects.savedGame.isFalling = this.isFalling;
        RMSObjects.savedGame.isBg = this.isBg;
        RMSObjects.savedGame.isMoon = this.isMoon;
        RMSObjects.savedGame.isCloudsA = this.isCloudsA;
        RMSObjects.savedGame.isMountains1 = this.isMountains1;
        RMSObjects.savedGame.isMountains2 = this.isMountains2;
        RMSObjects.savedGame.isCloudsB = this.isCloudsB;
        RMSObjects.savedGame.isObjects = this.isObjects;
        RMSObjects.savedGame.isCloudsC = this.isCloudsC;
        RMSObjects.savedGame.isCloudsD = this.isCloudsD;
        RMSObjects.savedGame.isHills = this.isHills;
        RMSObjects.savedGame.isCoins = this.isCoins;
        RMSObjects.savedGame.isEnergy = this.isEnergy;
        RMSObjects.savedGame.isSushi = this.isSushi;
        RMSObjects.savedGame.isClock = this.isClock;
        RMSObjects.savedGame.isGeneratingLastHill = this.isGeneratingLastHill;
        RMSObjects.savedGame.isLastHillStart = this.isLastHillStart;
        RMSObjects.savedGame.isLastHillTop = this.isLastHillTop;
        RMSObjects.savedGame.isLastHillEnd = this.isLastHillEnd;
        RMSObjects.savedGame.isIslandEnd = this.isIslandEnd;
        RMSObjects.savedGame.isLevelEnd = this.isLevelEnd;
        RMSObjects.savedGame.isGeneratedEnd = this.isGeneratedEnd;
        RMSObjects.savedGame.isEnd = this.isEnd;
        RMSObjects.savedGame.isTimeUp = this.isTimeUp;
        RMSObjects.savedGame.isPullingDownLeft = this.isPullingDownLeft;
        RMSObjects.savedGame.isPullingDownRight = this.isPullingDownRight;
        RMSObjects.savedGame.isAddingCoins = this.isAddingCoins;
        RMSObjects.savedGame.isGate = this.isGate;
        RMSObjects.savedGame.isControllable = this.isControllable;
        RMSObjects.savedGame.isSliding = this.isSliding;
        RMSObjects.savedGame.isLoadingNewLevel = this.isLoadingNewLevel;
        RMSObjects.savedGame.isLastCurve = this.isLastCurve;
        for (i = 0; i < this.maxCoords; ++i) {
            RMSObjects.savedGame.COORDS[i] = this.COORDS[i];
            RMSObjects.savedGame.ITEMS[i] = this.ITEMS[i];
            RMSObjects.savedGame.ITEMS_HEIGHT[i] = this.ITEMS_HEIGHT[i];
        }
        for (i = 0; i < 5; ++i) {
            RMSObjects.savedGame.BODY_HEIGHT[i] = this.dd.BODY_HEIGHT[i];
            RMSObjects.savedGame.BODY_SHIFT[i] = this.dd.BODY_SHIFT[i];
            RMSObjects.savedGame.BODY_SHIFT2[i] = this.dd.BODY_SHIFT2[i];
        }
        RMSObjects.createRMSConnect(3);
        if (!RMSObjects.rmsConnects[3].isExist()) {
            RMSObjects.rmsConnects[3].create();
        }
        RMSObjects.rmsConnects[3].save();
        RMSObjects.freeRMSConnect(3);
    }

    public void deleteSavedGame() {
        RMSObjects.createRMSConnect(3);
        RMSObjects.rmsConnects[3].delete();
        RMSObjects.freeRMSConnect(3);
    }
}

