/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.X;
import sk.inlogic.coords.Coords;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.table.Table;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenAbout
implements IScreen {
    MainCanvas mainCanvas;
    Coords coords;
    Table table;
    boolean isComplete;
    private Rectangle rectText;
    private static PreparedText preparedText;
    public static final int SPR_ABOUT2 = 6;
    public static final int SPR_YES = 12;
    Rectangle rectItems;
    public int posX;
    public int posYUp;
    public int posYDown;
    public int posYLogo;
    public int space;
    public int tilesX;
    public int tilesY;
    Image imgBg;
    Image imgLogo;
    Image imgBtnDown;
    Image imgCircle;
    Sprite sprTable;
    Sprite sprIconUp;
    Sprite sprIconDown;
    boolean isPressed;
    boolean isOnBtn;
    boolean isLoadingFlag;

    public ScreenAbout(MainCanvas mainCanvas) {
        this.mainCanvas = mainCanvas;
    }

    public void beforeShow() {
        this.isLoadingFlag = true;
        this.checkLowMem();
        this.coords = new Coords();
        this.table = new Table();
        if (this.isComplete) {
            this.imgBg = Resources.resImgs[70];
        }
        this.imgLogo = Resources.resImgs[1];
        this.imgBtnDown = Resources.resImgs[73];
        this.imgCircle = Resources.resImgs[75];
        this.sprTable = Resources.resSprs[1];
        this.sprIconUp = Resources.resSprs[15];
        this.sprIconDown = Resources.resSprs[14];
        Resources.loadGFont(this.coords.gfontMain);
        this.calculatePositions();
        this.calculateTable();
        this.calculateContent();
        preparedText = new PreparedText(Resources.resGFonts[this.coords.gfontMain]);
        preparedText.prepareText(X.singleton.getAppProperty("MIDlet-Name").toUpperCase() + ", " + X.singleton.getAppProperty("MIDlet-Version"), this.rectText.width);
        this.isLoadingFlag = false;
    }

    public void checkLowMem() {
        this.isComplete = true;
    }

    public void afterHide() {
    }

    public void beforeInteruption() {
        if (MainCanvas.soundManager.IsSoundOn()) {
            MainCanvas.soundManager.Stop();
        }
    }

    public void afterInteruption() {
        if (MainCanvas.soundManager.IsSoundOn()) {
            while (!MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1)) {
                for (int counterPlaySounds = 0; counterPlaySounds < 10; ++counterPlaySounds) {
                }
            }
        }
    }

    private void calculatePositions() {
        this.posX = MainCanvas.WIDTH >> 1;
        this.posYDown = MainCanvas.HEIGHT - (this.coords.shiftBtnDown + this.coords.shiftMaster);
        this.tilesX = (MainCanvas.WIDTH - this.sprTable.getWidth()) / this.sprTable.getWidth();
        this.tilesY = !MainCanvas.isRotated ? this.posYDown / this.sprTable.getHeight() : (this.posYDown - this.sprTable.getHeight()) / this.sprTable.getHeight();
        this.posYUp = this.posYDown - this.tilesY * this.sprTable.getHeight() + (this.sprTable.getHeight() >> 2);
        this.rectItems = new Rectangle(this.posX - (this.imgBtnDown.getWidth() >> 1), this.posYDown - (this.imgBtnDown.getHeight() >> 1), this.imgBtnDown.getWidth(), this.imgBtnDown.getHeight());
    }

    public void calculateTable() {
        int x = MainCanvas.WIDTH - this.tilesX * this.sprTable.getWidth() >> 1;
        int y = this.posYDown - this.tilesY * this.sprTable.getHeight();
        this.table.set(x, y, this.tilesX, this.tilesY, this.sprTable);
    }

    public void calculateContent() {
        int contentYUp = this.posYUp + this.sprIconUp.getHeight() + (this.sprTable.getHeight() >> 2);
        int contentYDown = this.posYDown - (this.imgCircle.getHeight() >> 1) - (this.sprTable.getHeight() >> 2);
        int fontHeight = Resources.resGFonts[this.coords.gfontMain].getHeight();
        this.space = (contentYDown - contentYUp - this.imgLogo.getHeight() - (fontHeight << 1)) / 3;
        this.posYLogo = contentYUp + this.space;
        int textMarginLeft = (MainCanvas.WIDTH - this.tilesX * this.sprTable.getWidth() >> 1) + (this.sprTable.getWidth() >> 1);
        int textMarginTop = this.posYLogo + this.imgLogo.getHeight() + this.space;
        int textWidth = MainCanvas.WIDTH - (textMarginLeft << 1);
        int textHeight = fontHeight << 1;
        this.rectText = new Rectangle(textMarginLeft, textMarginTop, textWidth, textHeight);
    }

    public void update(long lastRunLenght) {
    }

    public void paint(Graphics g) {
        if (this.isComplete) {
            for (int i = 0; i <= MainCanvas.WIDTH / this.imgBg.getWidth(); ++i) {
                for (int j = 0; j <= MainCanvas.HEIGHT / this.imgBg.getHeight(); ++j) {
                    g.drawImage(this.imgBg, i * this.imgBg.getWidth(), j * this.imgBg.getHeight(), 20);
                }
            }
        } else {
            g.setColor(0);
            g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        }
        this.paintDialog(g);
    }

    private void paintDialog(Graphics g) {
        this.table.draw(g);
        g.drawImage(this.imgCircle, this.posX, this.posYDown + this.coords.shiftDownCircle, 3);
        g.drawImage(this.imgBtnDown, this.posX, this.posYDown, 3);
        this.paintDialogItems(g);
    }

    private void paintDialogItems(Graphics g) {
        this.sprIconUp.setFrame(6);
        this.sprIconUp.setPosition(this.posX - (this.sprIconUp.getWidth() >> 1), this.posYUp);
        this.sprIconUp.paint(g);
        this.sprIconDown.setFrame(12);
        this.sprIconDown.setPosition(this.posX - (this.sprIconDown.getWidth() >> 1), this.posYDown - (this.sprIconDown.getHeight() >> 1));
        this.sprIconDown.paint(g);
        g.drawImage(this.imgLogo, this.posX, this.posYLogo, 17);
        if (preparedText.getTextHeight() > Resources.resGFonts[this.coords.gfontMain].getHeight()) {
            preparedText.drawText(g, this.rectText, 0, 17);
        } else {
            preparedText.drawText(g, this.rectText, 0, 3);
        }
    }

    public void keyPressed(int keyCode) {
        if (!MainCanvas.touchActivated && !this.isLoadingFlag && !this.isPressed && Keys.isActionGeneratedByKey(5, keyCode)) {
            this.press();
        }
    }

    public void keyReleased(int keyCode) {
        if (!MainCanvas.touchActivated && Keys.isActionGeneratedByKey(5, keyCode)) {
            this.isOnBtn = true;
            this.release();
        }
    }

    public void pointerPressed(int x, int y) {
        if (this.rectItems.contains(x, y)) {
            this.isOnBtn = true;
            this.press();
        }
    }

    public void pointerDragged(int x, int y) {
        if (!this.rectItems.contains(x, y)) {
            this.isOnBtn = false;
            this.release();
        }
    }

    public void pointerReleased(int x, int y) {
        if (this.rectItems.contains(x, y) && this.isPressed && this.isOnBtn) {
            this.release();
        }
    }

    public void press() {
        this.isPressed = true;
    }

    public void release() {
        this.isPressed = false;
        if (this.isOnBtn) {
            this.confirm();
        }
    }

    public void confirm() {
        this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 5, false));
        this.mainCanvas.repaint();
    }
}

