/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.coords.Coords;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenGame;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Rectangle;

public class ScreenLoading
implements IScreen {
    MainCanvas mainCanvas;
    Coords coords;
    boolean isComplete;
    int updateCounter;
    private Rectangle rectText;
    private static PreparedText preparedText;
    public static final int DELAY_TIME = 3000;
    private long delay;
    public static final int FRAMES_ROTATE = 2;
    public static final int COUNTER_LOADING = 2;
    public static final int COUNTER_ROTATE = 12;
    public static final int COUNTER1 = 1000;
    public static final int COUNTER2 = 30;
    public int counter;
    public int loadingCounter;
    public int frameRotate;
    boolean isLoading;
    boolean isPressed;
    boolean isReleased;
    Image imgBg;
    Sprite sprRotate;
    public static final int[] IMAGES;
    public static final int[] IMAGES2;
    public static final int[] SPRITES;
    public static final int[] SPRITES2;

    public ScreenLoading(MainCanvas mainCanvas) {
        this.mainCanvas = mainCanvas;
    }

    public void beforeShow() {
        this.checkLowMem();
        if (this.isComplete) {
            Resources.loadImage(70);
        }
        Resources.loadSprite(21);
        this.coords = new Coords();
        Resources.loadGFont(this.coords.gfontMain);
        if (this.isComplete) {
            this.imgBg = Resources.resImgs[70];
        }
        this.sprRotate = Resources.resSprs[21];
        this.frameRotate = 0;
        this.updateCounter = 0;
        this.delay = 3000L;
        this.calculatePositions();
        this.prepareText();
    }

    public void loadAll() {
        int i;
        for (i = 0; i < IMAGES.length; ++i) {
            Resources.loadImage(IMAGES[i]);
        }
        if (this.isComplete) {
            for (i = 0; i < IMAGES2.length; ++i) {
                Resources.loadImage(IMAGES2[i]);
            }
        }
        for (i = 0; i < SPRITES.length; ++i) {
            Resources.loadSprite(SPRITES[i]);
        }
        if (this.isComplete) {
            for (i = 0; i < SPRITES2.length; ++i) {
                Resources.loadSprite(SPRITES2[i]);
            }
        }
    }

    public void loading() {
        this.prepareText();
        ++this.loadingCounter;
        this.mainCanvas.repaint();
        this.mainCanvas.serviceRepaints();
    }

    public void checkLowMem() {
        this.isComplete = true;
    }

    public void afterHide() {
        Resources.freeSprite(21);
    }

    public void beforeInteruption() {
        if (MainCanvas.soundManager.IsSoundOn()) {
            MainCanvas.soundManager.Stop();
        }
    }

    public void afterInteruption() {
        if (MainCanvas.soundManager.IsSoundOn()) {
            while (!MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1)) {
                for (int counterPlaySounds = 0; counterPlaySounds < 10; ++counterPlaySounds) {
                }
            }
        }
    }

    public void prepareText() {
        Resources.loadGFont(this.coords.gfontMain);
        preparedText = new PreparedText(Resources.resGFonts[this.coords.gfontMain]);
        preparedText.prepareText(this.prepareTextLoading(), this.rectText.width);
    }

    public String prepareTextLoading() {
        String text = "";
        switch (this.loadingCounter % 6) {
            case 0: {
                text = " \n \n ";
                break;
            }
            case 1: {
                text = ".\n \n ";
                break;
            }
            case 2: {
                text = ".\n.\n ";
                break;
            }
            case 3: {
                text = ".\n.\n.";
                break;
            }
            case 4: {
                text = " \n.\n.";
                break;
            }
            case 5: {
                text = " \n \n.";
                break;
            }
            default: {
                text = " \n \n ";
            }
        }
        return text;
    }

    private void calculatePositions() {
        this.isLoading = false;
        this.counter = 0;
        this.loadingCounter = 0;
        int fontHeight = Resources.resGFonts[this.coords.gfontMain].getHeight();
        int textMarginLeft = 6;
        int textMarginTop = MainCanvas.HEIGHT - ((fontHeight << 2) - (fontHeight >> 1));
        int textWidth = 20;
        int textHeight = MainCanvas.HEIGHT >> 2;
        this.rectText = new Rectangle(textMarginLeft, textMarginTop, textWidth, textHeight);
    }

    public void update(long lastRunLenght) {
        ++this.updateCounter;
        if (this.updateCounter % 2 == 0) {
            this.loading();
        }
        if (this.updateCounter % 12 == 0) {
            this.frameRotate = (this.frameRotate + 1) % 2;
        }
        if (!this.isLoading) {
            this.isLoading = true;
            this.loadAll();
        }
        if (this.delay > 0L) {
            this.delay -= lastRunLenght;
        } else if (this.checkLoads()) {
            this.confirm();
        } else {
            this.loadAll();
        }
    }

    public boolean checkLoads() {
        int i;
        for (i = 0; i < IMAGES.length; ++i) {
            if (Resources.resImgs[IMAGES[i]] != null) continue;
            return false;
        }
        if (this.isComplete) {
            for (i = 0; i < IMAGES2.length; ++i) {
                if (Resources.resImgs[IMAGES2[i]] != null) continue;
                return false;
            }
        }
        for (i = 0; i < SPRITES.length; ++i) {
            if (Resources.resSprs[SPRITES[i]] != null) continue;
            return false;
        }
        if (this.isComplete) {
            for (i = 0; i < SPRITES2.length; ++i) {
                if (Resources.resSprs[SPRITES2[i]] != null) continue;
                return false;
            }
        }
        return true;
    }

    public void paint(Graphics g) {
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        if (this.isComplete) {
            for (int i = 0; i <= MainCanvas.WIDTH / this.imgBg.getWidth(); ++i) {
                for (int j = 0; j <= MainCanvas.HEIGHT / this.imgBg.getHeight(); ++j) {
                    g.drawImage(this.imgBg, i * this.imgBg.getWidth(), j * this.imgBg.getHeight(), 20);
                }
            }
        } else {
            g.setColor(0);
            g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        }
        this.sprRotate.setFrame(this.frameRotate);
        this.sprRotate.setPosition((MainCanvas.WIDTH >> 1) - (this.sprRotate.getWidth() >> 1), (MainCanvas.HEIGHT >> 1) - (this.sprRotate.getHeight() >> 1));
        this.sprRotate.paint(g);
        preparedText.drawText(g, this.rectText, 0, 20);
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
    }

    public void pointerPressed(int x, int y) {
    }

    public void pointerDragged(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
    }

    public void confirm() {
        this.isReleased = false;
        this.mainCanvas.changeLastActiveScreen(new ScreenGame(this.mainCanvas, false));
        this.mainCanvas.repaint();
    }

    static {
        IMAGES = new int[]{17, 15, 16, 56, 11, 12, 13, 14, 18, 19, 20, 63, 21, 22, 23};
        IMAGES2 = new int[]{57, 58, 59, 60, 61, 62, 64, 65, 66, 67, 68, 69, 24, 36, 45, 25, 37, 46, 40, 49, 27, 28, 29, 30, 31, 32, 33, 34, 35, 26, 38, 39, 43, 44, 41, 42, 55, 47, 48, 53, 54, 50, 51, 52};
        SPRITES = new int[]{5, 4, 6, 7, 3, 1, 20};
        SPRITES2 = new int[]{8, 9, 10, 11, 12, 13, 19, 2};
    }
}

