/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.coords.Coords;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.screen.ScreenReset;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenOptions
implements IScreen {
    MainCanvas mainCanvas;
    Coords coords;
    boolean isComplete;
    public static final int COMP_ID_SOUNDS = 0;
    public static final int COMP_ID_RESET = 1;
    public static final int COMP_ID_BACK = 2;
    public static final int TOTAL_COMP_IDS = 3;
    public static final int SPR_SOUNDS_ON = 7;
    public static final int SPR_SOUNDS_OFF = 8;
    public static final int SPR_BACK = 10;
    public static final int SPR_RESET = 9;
    public static final int[] SPR_ITEMS_ON = new int[]{7, 9, 10};
    public static final int[] SPR_ITEMS_OFF = new int[]{8, 9, 10};
    Rectangle[] rectItems = new Rectangle[3];
    private int selectedItem;
    public int posX;
    public int posYTitle;
    public int posYMaster;
    public int posYUp;
    public int posYMain;
    public int posYDown;
    public int timerPressed;
    public int timerReleased;
    public int timerSelected;
    public int timerScrolled;
    boolean isSoundOn;
    boolean isPressed;
    boolean isOnMainBtn;
    Image imgBtnUp;
    Image imgBtnDown;
    Image imgMaster;
    Image imgCircle;
    Sprite sprIconUp;
    Sprite sprIconMain;
    Sprite sprIconDown;

    public ScreenOptions(MainCanvas mainCanvas, int selectedItem) {
        this.mainCanvas = mainCanvas;
        this.selectedItem = selectedItem;
    }

    public void beforeShow() {
        this.checkLowMem();
        this.coords = new Coords();
        this.isSoundOn = false;
        this.isSoundOn = MainCanvas.soundManager.IsSoundOn();
        this.imgBtnUp = Resources.resImgs[73];
        this.imgBtnDown = Resources.resImgs[73];
        this.imgMaster = Resources.resImgs[72];
        this.imgCircle = Resources.resImgs[75];
        this.sprIconUp = Resources.resSprs[14];
        this.sprIconMain = Resources.resSprs[14];
        this.sprIconDown = Resources.resSprs[14];
        this.calculatePositions();
    }

    public void checkLowMem() {
        this.isComplete = false;
    }

    public void afterHide() {
    }

    public void beforeInteruption() {
        if (MainCanvas.soundManager.IsSoundOn()) {
            MainCanvas.soundManager.Stop();
        }
    }

    public void afterInteruption() {
        if (MainCanvas.soundManager.IsSoundOn()) {
            while (!MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1)) {
                for (int counterPlaySounds = 0; counterPlaySounds < 10; ++counterPlaySounds) {
                }
            }
        }
    }

    private void calculatePositions() {
        this.timerPressed = 0;
        this.timerReleased = 0;
        this.timerSelected = 0;
        this.timerScrolled = 0;
        this.isPressed = false;
        this.posX = MainCanvas.WIDTH >> 1;
        this.posYDown = MainCanvas.HEIGHT - (this.coords.shiftBtnDown + this.coords.shiftMaster);
        this.posYMain = MainCanvas.HEIGHT - (this.coords.shiftBtnMain + this.coords.shiftMaster);
        this.posYUp = MainCanvas.HEIGHT - (this.coords.shiftBtnUp + this.coords.shiftMaster);
        this.posYMaster = MainCanvas.HEIGHT - (this.imgMaster.getHeight() + this.coords.shiftMaster);
        if (this.coords.isTitle) {
            this.posYTitle = MainCanvas.HEIGHT - (this.imgMaster.getHeight() + this.coords.shiftMaster + this.coords.shiftTitle);
        }
        this.rectItems[0] = new Rectangle(this.posX - (this.imgBtnUp.getWidth() >> 1), this.posYUp - (this.imgBtnUp.getHeight() >> 1), this.imgBtnUp.getWidth(), this.imgBtnUp.getHeight());
        if (!this.isComplete) {
            this.rectItems[1] = new Rectangle(this.posX - (this.imgBtnDown.getWidth() >> 1), this.posYMain - (this.imgBtnDown.getHeight() >> 1), this.imgBtnDown.getWidth(), this.imgBtnDown.getHeight());
        }
        this.rectItems[2] = new Rectangle(this.posX - (this.imgBtnDown.getWidth() >> 1), this.posYDown - (this.imgBtnDown.getHeight() >> 1), this.imgBtnDown.getWidth(), this.imgBtnDown.getHeight());
    }

    public void update(long lastRunLenght) {
    }

    public void paint(Graphics g) {
        if (!this.isComplete) {
            g.setColor(0);
            g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        }
        this.paintDialog(g);
    }

    public void paintDialog(Graphics g) {
        g.drawImage(this.imgMaster, this.posX, this.posYMaster, 17);
        g.drawImage(this.imgBtnUp, this.posX, this.posYUp, 3);
        g.drawImage(this.imgBtnDown, this.posX, this.posYDown, 3);
        this.paintDialogItems(g);
    }

    public void paintDialogItems(Graphics g) {
        if (this.selectedItem == 0) {
            if (this.isSoundOn) {
                this.sprIconUp.setFrame(SPR_ITEMS_ON[2]);
            } else {
                this.sprIconUp.setFrame(SPR_ITEMS_OFF[2]);
            }
        } else if (this.isSoundOn) {
            this.sprIconUp.setFrame(SPR_ITEMS_ON[this.selectedItem - 1]);
        } else {
            this.sprIconUp.setFrame(SPR_ITEMS_OFF[this.selectedItem - 1]);
        }
        this.sprIconUp.setPosition(this.posX - (this.sprIconUp.getWidth() >> 1), this.posYUp - (this.sprIconUp.getHeight() >> 1));
        this.sprIconUp.paint(g);
        if (this.isSoundOn) {
            this.sprIconMain.setFrame(SPR_ITEMS_ON[this.selectedItem]);
        } else {
            this.sprIconMain.setFrame(SPR_ITEMS_OFF[this.selectedItem]);
        }
        this.sprIconMain.setPosition(this.posX - (this.sprIconMain.getWidth() >> 1), this.posYMain - (this.sprIconMain.getHeight() >> 1));
        this.sprIconMain.paint(g);
        if (this.selectedItem == 2) {
            if (this.isSoundOn) {
                this.sprIconDown.setFrame(SPR_ITEMS_ON[0]);
            } else {
                this.sprIconDown.setFrame(SPR_ITEMS_OFF[0]);
            }
        } else if (this.isSoundOn) {
            this.sprIconDown.setFrame(SPR_ITEMS_ON[this.selectedItem + 1]);
        } else {
            this.sprIconDown.setFrame(SPR_ITEMS_OFF[this.selectedItem + 1]);
        }
        this.sprIconDown.setPosition(this.posX - (this.sprIconDown.getWidth() >> 1), this.posYDown - (this.sprIconDown.getHeight() >> 1));
        this.sprIconDown.paint(g);
    }

    public void keyPressed(int keyCode) {
        if (!MainCanvas.touchActivated && !this.isPressed) {
            if (Keys.isActionGeneratedByKey(1, keyCode)) {
                this.setUp();
            }
            if (Keys.isActionGeneratedByKey(2, keyCode)) {
                this.setDown();
            }
            if (Keys.isActionGeneratedByKey(5, keyCode)) {
                this.press();
            }
        }
    }

    public void keyReleased(int keyCode) {
        if (!MainCanvas.touchActivated && Keys.isActionGeneratedByKey(5, keyCode)) {
            this.isOnMainBtn = true;
            this.release();
        }
    }

    public void setUp() {
        --this.selectedItem;
        if (this.selectedItem < 0) {
            this.selectedItem = 2;
        }
        this.mainCanvas.repaint();
    }

    public void setDown() {
        this.selectedItem = (this.selectedItem + 1) % 3;
        this.mainCanvas.repaint();
    }

    public void pointerPressed(int x, int y) {
        if (this.rectItems[0].contains(x, y)) {
            this.setUp();
        } else if (this.rectItems[1].contains(x, y)) {
            this.isOnMainBtn = true;
            this.press();
        } else if (this.rectItems[2].contains(x, y)) {
            this.setDown();
        }
    }

    public void pointerDragged(int x, int y) {
        if (!this.rectItems[1].contains(x, y)) {
            this.isOnMainBtn = false;
            this.release();
        }
    }

    public void pointerReleased(int x, int y) {
        if (this.rectItems[1].contains(x, y) && this.isPressed && this.isOnMainBtn) {
            this.release();
        }
    }

    public void press() {
        this.isPressed = true;
        this.mainCanvas.repaint();
    }

    public void release() {
        this.isPressed = false;
        this.mainCanvas.repaint();
        this.mainCanvas.serviceRepaints();
        if (this.isOnMainBtn) {
            this.select();
        }
    }

    public void select() {
        this.isOnMainBtn = false;
        switch (this.selectedItem) {
            case 0: {
                if (!this.isSoundOn) {
                    this.isSoundOn = true;
                    MainCanvas.soundManager.SetSoundOn(true);
                    MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                    break;
                }
                this.isSoundOn = false;
                MainCanvas.soundManager.SetSoundOn(false);
                MainCanvas.soundManager.Stop();
                break;
            }
            case 1: {
                this.mainCanvas.changeLastActiveScreen(new ScreenReset(this.mainCanvas));
                break;
            }
            case 2: {
                this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 4, false));
            }
        }
        this.mainCanvas.repaint();
    }
}

