/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenSplash;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenLanguage
implements IScreen {
    private MainCanvas mainCanvas;
    private static int[] imgsForCompId = new int[]{3, 4, 5, 6, 7, 8};
    private static String[] langCodes = new String[]{"en", "de", "fr", "tr", "es", "pt"};
    private Rectangle[] rectItems = new Rectangle[imgsForCompId.length];
    private Rectangle rectSelector;
    private int selectedCompId;
    private static final int selectorPadding = 0;

    public ScreenLanguage(MainCanvas mainCanvas) {
        this.mainCanvas = mainCanvas;
    }

    public void beforeShow() {
        MainCanvas.soundManager.SetSoundOn(false);
        MainCanvas.soundManager.Stop();
        Resources.loadImages(new int[]{3, 4, 5, 6, 7, 8});
        this.calculatePositions();
        this.selectedCompId = 0;
        this.calculateSelectorPos();
    }

    public void afterHide() {
        Resources.freeImages(new int[]{3, 4, 5, 6, 7, 8});
    }

    public void beforeInteruption() {
        if (MainCanvas.soundManager.IsSoundOn()) {
            MainCanvas.soundManager.Stop();
        }
    }

    public void afterInteruption() {
        MainCanvas.soundManager.SetSoundOn(false);
        MainCanvas.soundManager.Stop();
    }

    private void calculatePositions() {
        int btnWidth = Resources.resImgs[3].getWidth();
        int btnHeight = Resources.resImgs[3].getHeight();
        int spaceX = (MainCanvas.WIDTH - btnWidth * 2) / 3;
        int spaceY = (MainCanvas.HEIGHT - btnHeight * 3) / 4;
        for (int i = 0; i < imgsForCompId.length; ++i) {
            this.rectItems[i] = new Rectangle(spaceX + i % 2 * (btnWidth + spaceX), spaceY + i / 2 * (btnHeight + spaceY), btnWidth, btnHeight);
        }
        Image imgFlag = Resources.resImgs[3];
        this.rectSelector = new Rectangle(0, 0, imgFlag.getWidth() + 0, imgFlag.getHeight() + 0);
    }

    private void calculateSelectorPos() {
        if (MainCanvas.touchActivated) {
            return;
        }
        this.rectSelector.x = this.rectItems[this.selectedCompId].x - 0;
        this.rectSelector.y = this.rectItems[this.selectedCompId].y - 0;
    }

    public void update(long lastRunLenght) {
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
        if (Keys.isActionGeneratedByKey(3, keyCode)) {
            if (this.selectedCompId % 2 == 1 && this.selectedCompId - 1 >= 0) {
                --this.selectedCompId;
                this.calculateSelectorPos();
            }
        } else if (Keys.isActionGeneratedByKey(4, keyCode)) {
            if (this.selectedCompId % 2 == 0 && this.selectedCompId + 1 < langCodes.length) {
                ++this.selectedCompId;
                this.calculateSelectorPos();
            }
        } else if (Keys.isActionGeneratedByKey(1, keyCode)) {
            if (this.selectedCompId / 2 > 0 && this.selectedCompId - 2 >= 0) {
                this.selectedCompId -= 2;
                this.calculateSelectorPos();
            }
        } else if (Keys.isActionGeneratedByKey(2, keyCode)) {
            if (this.selectedCompId / 2 < 3 && this.selectedCompId + 2 < langCodes.length) {
                this.selectedCompId += 2;
                this.calculateSelectorPos();
            }
        } else if (Keys.isActionGeneratedByKey(5, keyCode)) {
            Resources.initLangDirs(langCodes[this.selectedCompId]);
            this.mainCanvas.changeLastActiveScreen(new ScreenSplash(this.mainCanvas));
        }
        this.mainCanvas.repaint();
    }

    public void paint(Graphics g) {
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        g.setColor(0);
        g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        for (int i = 0; i < imgsForCompId.length; ++i) {
            g.drawImage(Resources.resImgs[imgsForCompId[i]], this.rectItems[i].x, this.rectItems[i].y, 20);
        }
        if (!MainCanvas.touchActivated) {
            g.setColor(16770816);
            g.drawRect(this.rectSelector.x, this.rectSelector.y, this.rectSelector.width, this.rectSelector.height);
            g.drawRect(this.rectSelector.x - 1, this.rectSelector.y - 1, this.rectSelector.width + 2, this.rectSelector.height + 2);
        }
    }

    public void pointerPressed(int x, int y) {
        for (int i = 0; i < this.rectItems.length; ++i) {
            if (!this.rectItems[i].contains(x, y)) continue;
            this.selectedCompId = i;
            switch (this.selectedCompId) {
                default: 
            }
            this.mainCanvas.keyPressed(53);
        }
    }

    public void pointerDragged(int x, int y) {
        if (!this.rectItems[this.selectedCompId].contains(x, y)) {
            switch (this.selectedCompId) {
                default: 
            }
            Keys.keyReleased(53);
        }
    }

    public void pointerReleased(int x, int y) {
        switch (this.selectedCompId) {
            default: 
        }
        if (Keys.isKeyPressed(53)) {
            this.mainCanvas.keyReleased(53);
        }
    }
}

