/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.oldschoolracing;

import simple.video.Graphics;
import sk.inlogic.oldschoolracing.ScreenGame;
import sk.inlogic.oldschoolracing.Vector;

public class MotionVectors {
    public Vector vecCentr;
    public Vector vecFric;
    public Vector vecMotor;
    public Vector vecResult;
    public int iPredefinnedDelay;
    public int iDelay;

    public MotionVectors(int angle) {
        this.iDelay = this.iPredefinnedDelay;
        this.vecCentr = new Vector(0, 0);
        this.vecMotor = new Vector(angle, 0);
        this.vecFric = new Vector(this.getOpositeVectorDir(angle), 0);
        this.vecResult = new Vector(0, 0);
    }

    public void reset(int angle, int imax) {
        this.vecCentr = new Vector(0, 0);
        this.vecMotor = new Vector(angle, 0);
        this.vecFric = new Vector(this.getOpositeVectorDir(angle), imax);
        this.vecResult = new Vector(this.getOpositeVectorDir(angle), imax);
        this.calculate(false, false);
    }

    public void calculate(boolean left, boolean right) {
        Vector tmp = new Vector(0, 0);
        tmp.iSize = this.vecMotor.iSize - this.vecFric.iSize <= 0 ? 0 : this.vecMotor.iSize - this.vecFric.iSize;
        tmp.iDirection = this.vecMotor.iDirection;
        this.vecResult.iSize = this.vecCentr.iSize > 0 ? (this.vecCentr.iSize + this.vecMotor.iSize) / 2 : this.vecMotor.iSize;
        if (this.vecCentr.iSize > 0) {
            if (tmp.iDirection > this.vecCentr.iDirection) {
                this.vecResult.iDirection = (tmp.iDirection - this.vecCentr.iDirection) / 2 + this.vecCentr.iDirection;
                if (right && tmp.iDirection > 180 && this.vecCentr.iDirection < 180) {
                    this.vecResult.iDirection = this.getOpositeVectorDir(this.vecResult.iDirection);
                }
                if (this.vecCentr.iDirection - tmp.iDirection >= 180) {
                    this.vecCentr.iSize = 0;
                }
            } else {
                this.vecResult.iDirection = (this.vecCentr.iDirection - tmp.iDirection) / 2 + tmp.iDirection;
                if (left && this.vecCentr.iDirection > 180 && tmp.iDirection < 180) {
                    this.vecResult.iDirection = this.getOpositeVectorDir(this.vecResult.iDirection);
                }
                if (this.vecCentr.iDirection - tmp.iDirection >= 180) {
                    this.vecCentr.iSize = 0;
                }
            }
        } else {
            this.vecResult.iDirection = tmp.iDirection;
        }
        if (ScreenGame.vPlayersNR == 0 && this.vecCentr.iSize > 0) {
            this.vecResult.iDirection = this.vecCentr.iDirection;
        }
        if (this.iDelay == 0) {
            if (this.vecCentr.iSize > 0) {
                --this.vecCentr.iSize;
                this.iDelay = this.iPredefinnedDelay;
            }
        } else {
            --this.iDelay;
        }
    }

    public int getOpositeVectorDir(int dir) {
        if (dir < 180) {
            return 180 + dir;
        }
        return dir - 180;
    }

    public void paintVects(Graphics g) {
        g.setColor(65280);
        this.vecCentr.paintVector(g);
        g.setColor(0xFFFFFF);
        this.vecFric.paintVector(g);
        g.setColor(0x999999);
        this.vecMotor.paintVector(g);
        g.setColor(0xFF0000);
        this.vecResult.paintVector(g);
    }
}

