/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.oldschoolracing;

import simple.input.Key;
import simple.input.Keys;
import simple.video.Graphics;
import sk.inlogic.oldschoolracing.CMenuItem;
import sk.inlogic.oldschoolracing.IMenuItemActivator;
import sk.inlogic.oldschoolracing.IMenuItemRenderer;
import sk.inlogic.oldschoolracing.IScreen;
import sk.inlogic.oldschoolracing.MenuSystem;
import sk.inlogic.oldschoolracing.MyApplication;
import sk.inlogic.oldschoolracing.Profile;
import sk.inlogic.oldschoolracing.Resources;
import sk.inlogic.oldschoolracing.ScreenMenu;
import sk.inlogic.oldschoolracing.Sounds;
import sk.inlogic.oldschoolracing.Texts;

public class ScreenSplash
implements IScreen,
IMenuItemActivator,
IMenuItemRenderer {
    final int MODE_VOID;
    final int MODE_LOADINGRES;
    final int MODE_LANGUAGES;
    final int MODE_SOUNDS;
    final int MODE_LOGO;
    final int MODE_TITLE;
    final int TIME_DELAY;
    int iMode;
    int iModeDelay;
    MyApplication pMyApplication;
    MenuSystem pMenuSystem;

    public ScreenSplash() {
        this.MODE_VOID = 0;
        this.MODE_LOADINGRES = 1;
        this.MODE_LANGUAGES = 2;
        this.MODE_SOUNDS = 3;
        this.MODE_LOGO = 4;
        this.MODE_TITLE = 5;
        this.TIME_DELAY = 3000;
        new Texts();
        this.pMyApplication = MyApplication.getInstance();
        this.iMode = 1;
    }

    private void prepareEnableSounds() {
        Resources.prepareMultiLineText(Texts.getString(6));
    }

    public void update(long lTick) {
        if (this.iMode > 3 && this.iModeDelay > 0) {
            this.iModeDelay = (int)((long)this.iModeDelay - lTick);
            if (this.iModeDelay <= 0) {
                this.nextMode();
            }
        }
        this.pMyApplication.repaintScreen();
        if (this.iMode == 1) {
            this.updateModeLoadingRes();
        }
    }

    private void updateModeLoadingRes() {
        this.pMyApplication.repaintScreen();
        Resources.loadInitialResources();
        this.pMenuSystem = MenuSystem.getInstance();
        this.pMenuSystem.setMenuItemActivator(this);
        this.pMenuSystem.setMenuItemRenderer(this);
        int iGap = Resources.iLangW / 5;
        int iWidth = Resources.iLangW;
        int iHeight = Resources.iLangH;
        int partsY = Resources.iScreenH / Resources.iBorderH - 2;
        int iPosY = (Resources.iScreenH - (3 * iHeight + 2 * iGap)) / 2;
        int iPosX = Resources.iScreenW / 2 + Resources.iBorderH / 2;
        this.pMenuSystem.addMenuItem(new CMenuItem(0, "ENGLISH", iPosX, iPosY, iWidth, iHeight));
        this.pMenuSystem.addMenuItem(new CMenuItem(1, "DEUTSCH", iPosX + Resources.iLangW + Resources.iBorderH, iPosY, iWidth, iHeight));
        this.pMenuSystem.addMenuItem(new CMenuItem(2, "FRAN\u00c7AIS", iPosX, iPosY + iHeight + iGap, iWidth, iHeight));
        this.pMenuSystem.addMenuItem(new CMenuItem(3, "ESPA\u00d1OL", iPosX + Resources.iLangW + Resources.iBorderH, iPosY + iHeight + iGap, iWidth, iHeight));
        this.pMenuSystem.addMenuItem(new CMenuItem(4, "T\u00dcRK\u0130YE", iPosX, iPosY + (iHeight + iGap) * 2, iWidth, iHeight));
        this.pMenuSystem.addMenuItem(new CMenuItem(5, "PORTUGU\u00caS", iPosX + Resources.iLangW + Resources.iBorderH, iPosY + (iHeight + iGap) * 2, iWidth, iHeight));
        this.pMenuSystem.getClass();
        this.pMenuSystem.iMenuType = 1;
        this.iMode = 2;
        Resources.loadLangResources();
        this.pMyApplication.repaintScreen();
    }

    public void paintScreen(Graphics g) {
        switch (this.iMode) {
            case 2: {
                this.paintModeLanguage(g);
                break;
            }
            case 3: {
                this.paintModeSounds(g);
                break;
            }
            case 4: {
                this.paintModeLogo(g);
                break;
            }
            case 5: {
                this.paintModeTitle(g);
            }
        }
    }

    private void paintModeLanguage(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, Resources.iScreenW, Resources.iScreenH);
        this.pMenuSystem.paintMenu(g);
    }

    public void renderMenuItem(Graphics g, CMenuItem pMenuItem, boolean bSelected) {
        Resources.sprLang.setFrame(pMenuItem.getID());
        Resources.sprLang.setPosition(pMenuItem.getLeft(), pMenuItem.getTop());
        Resources.sprLang.paint(g);
    }

    private void paintModeSounds(Graphics g) {
        int partsX = Resources.iScreenW / Resources.iBorderW - Resources.MINUS_MAIN_X_PARTS;
        int partsY = Resources.iScreenH / Resources.iBorderH - Resources.MINUS_MAIN_Y_PARTS;
        Resources.paintMenuBG(partsX, partsY, g, true);
        int iPosY = (Resources.iScreenH - Resources.iBorderH * (partsY - 1)) / 2;
        int iPosX = (Resources.iScreenW - Resources.iBorderW * partsX) / 2 + Resources.iBorderW;
        Resources.imgLogo.drawAtPoint(g, iPosX, iPosY);
        iPosY = (Resources.iScreenH - Resources.iBorderH * partsY) / 2 + partsY * Resources.iBorderH - Resources.BORDER_WIDTH;
        Resources.imgIlust.drawAtPoint(g, iPosX, iPosY - Resources.iIlustH);
        int half = Resources.iScreenW / 2;
        int x = half + (half - Resources.iBigBtnW) / 2 - Resources.iBorderW;
        int y = (Resources.iScreenH - Resources.iBigBtnH) / 2;
        Resources.imgBigBtn.drawAtPoint(g, x, y);
        int iTextW = Texts.getTextWidth(Texts.getString(6));
        iPosY = (Resources.iScreenH - Resources.iBorderH * partsY) / 2 + partsY * Resources.iBorderH - Texts.getFontHeight() - Texts.getFontHeight() / 2;
        if (Resources.iScreenH == 240 && Resources.iScreenW <= 320) {
            Texts.drawTextAtPos(g, (Resources.iScreenW - iTextW) / 2, iPosY, Texts.getString(6));
        } else {
            Texts.drawTextAtPos(g, half, iPosY, Texts.getString(6));
        }
        Resources.paintLeftButton(g, partsY);
        Resources.paintRightButton(g, partsY);
    }

    private void paintModeLogo(Graphics g) {
        g.setColor(0xFF0000);
        g.fillRect(0, 0, Resources.iScreenW, Resources.iScreenH);
        Resources.imgBackground = Resources.createImage("/minl.png");
        Resources.paintBackground(g);
    }

    private void paintModeTitle(Graphics g) {
        g.setColor(0xFF0000);
        g.fillRect(0, 0, Resources.iScreenW, Resources.iScreenH);
        Resources.imgBackground = Resources.createImage("/mspl.png");
        Resources.paintBackground(g);
    }

    public void keyPressed(Key pKey) {
    }

    private void keyPressedModeLanguages(Key pKey) {
        this.pMenuSystem.keyPressed(pKey);
        if (pKey.iValue == Keys.KEY_FNLEFT || pKey.iGameAction == 8) {
            this.nextMode();
        }
    }

    void keyPressedModeSounds(Key pKey) {
        if (pKey.iValue == Keys.KEY_FNLEFT) {
            Profile.bMusic = true;
            this.nextMode();
            return;
        }
        if (pKey.iValue == Keys.KEY_FNRIGHT || pKey.iGameAction == 8) {
            Profile.bMusic = false;
            this.nextMode();
        }
    }

    void keyPressedModeSplash(Key pKey) {
        if (pKey.iGameAction == 8) {
            this.nextMode();
        }
    }

    void nextMode() {
        System.out.println("next");
        this.iModeDelay = 3000;
        switch (this.iMode) {
            case 2: {
                Resources.loadSplashResources();
                Sounds.playMenuMusic();
                this.iMode = 4;
                this.iMode = 3;
                break;
            }
            case 3: {
                this.iMode = 4;
                break;
            }
            case 4: {
                this.iMode = 5;
                break;
            }
            case 5: {
                Resources.releaseSplashResources();
                MyApplication.pScrMenu = new ScreenMenu();
                MyApplication.pActiveScreen = MyApplication.pScrMenu;
                MyApplication.pScrSplash = null;
                System.gc();
                this.iMode = 0;
            }
        }
    }

    public void keyReleased(Key pKey) {
    }

    public void pointerPressed(int x, int y) {
        if (this.iMode == 3) {
            int partsX = Resources.iScreenW / Resources.iBorderW - Resources.MINUS_MAIN_X_PARTS;
            int partsY = Resources.iScreenH / Resources.iBorderH - Resources.MINUS_MAIN_Y_PARTS;
            if (Resources.pressedLeftButton(x, y, partsX, partsY)) {
                Profile.bMusic = true;
                this.nextMode();
                return;
            }
            if (Resources.pressedRightButton(x, y, partsX, partsY)) {
                Profile.bMusic = false;
                this.nextMode();
                return;
            }
        } else if (this.iMode == 4 || this.iMode == 5) {
            this.nextMode();
            return;
        }
        this.pMenuSystem.pointerPressed(x, y);
    }

    public void pointerReleased(int x, int y) {
    }

    public void onMenuItemActivated(int iIdx) {
        System.out.println("print");
        if (this.iMode == 2) {
            Texts.iLanguage = iIdx;
            this.nextMode();
        }
    }

    public void onPause() {
    }

    public void onResume() {
    }

    public void onStart() {
    }
}

