/*
 * Decompiled with CFR 0.152.
 */
package simple.scene;

import simple.scene.Scene;
import simple.video.Graphics;

public abstract class SceneObject {
    protected int iPositionX;
    protected int iPositionY;
    protected int iReferencePixelX;
    protected int iReferencePixelY;
    protected boolean bVisible;
    Scene pScene;

    public SceneObject() {
        this.defineReferencePixel(0, 0);
        this.setPosition(0, 0);
        this.setVisible(true);
        this.pScene = null;
    }

    protected void finalize() throws Throwable {
        if (this.pScene != null) {
            this.pScene.removeObject(this);
        }
    }

    public void defineReferencePixel(int iReferencePixelX, int iReferencePixelY) {
        this.iReferencePixelX = iReferencePixelX;
        this.iReferencePixelY = iReferencePixelY;
    }

    public int getReferencePixelX() {
        return this.iReferencePixelX;
    }

    public int getReferencePixelY() {
        return this.iReferencePixelY;
    }

    public void setPosition(int iPositionX, int iPositionY) {
        this.iPositionX = iPositionX;
        this.iPositionY = iPositionY;
    }

    public int getPositionX() {
        int iRetVal = this.iPositionX;
        if (this.pScene != null) {
            iRetVal += this.pScene.getPositionX();
        }
        return iRetVal;
    }

    public int getPositionY() {
        int iRetVal = this.iPositionY;
        if (this.pScene != null) {
            iRetVal += this.pScene.getPositionY();
        }
        return iRetVal;
    }

    public void move(int iDeltaX, int iDeltaY) {
        this.setPosition(this.iPositionX + iDeltaX, this.iPositionY + iDeltaY);
    }

    public int getWidth() {
        return 0;
    }

    public int getHeight() {
        return 0;
    }

    public boolean isVisible() {
        return this.bVisible;
    }

    public void setVisible(boolean bVisible) {
        this.bVisible = bVisible;
    }

    public abstract void paint(Graphics var1, int var2, int var3);

    public void paint(Graphics pGraphics) {
        this.paint(pGraphics, this.iPositionX, this.iPositionY);
    }

    public abstract void paintRotated(Graphics var1, int var2, int var3);

    public void paintRotated(Graphics pGraphics) {
        this.paintRotated(pGraphics, this.iPositionX, this.iPositionY);
    }
}

