/*
 * Decompiled with CFR 0.152.
 */
package simple.video;

import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.midlet.MIDlet;
import simple.core.Application;
import simple.core.Device;
import simple.debug.DebugOutput;
import simple.video.Graphics;
import simple.video.SimpleCanvas;

public class Screen {
    public static final int ORIENTATION_PORTRAIT = 0;
    public static final int ORIENTATION_LANDSCAPE = 1;
    private Graphics pGraphics;
    private int iOrientation;
    private SimpleCanvas pCanvas;

    public Screen(Device pDevice) {
        DebugOutput.traceIn(2, "SIMPLE", "Screen.Screen()");
        boolean bFullScreen = pDevice.getPropertyAsLong("FULLSCREEN") == 1L;
        this.pCanvas = new SimpleCanvas(this, bFullScreen);
        this.pGraphics = new Graphics(this);
        this.setOrientation(1);
        DebugOutput.traceOut(2, "SIMPLE", "Screen.Screen()");
    }

    protected void finalize() throws Throwable {
        this.pGraphics = null;
        System.gc();
    }

    public void setActive() {
        try {
            Application pApplication = Application.getSingleton();
            DebugOutput.trace(2, "SIMPLE", "simple.core.Application = " + ((Object)((Object)pApplication)).toString());
            Display pDisplay = Display.getDisplay((MIDlet)pApplication);
            pDisplay.setCurrent((Displayable)this.pCanvas);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void repaint() {
        this.pCanvas.repaint();
        this.pCanvas.serviceRepaints();
    }

    public void repaintNow() {
        this.pCanvas.repaint();
        this.pCanvas.serviceRepaints();
    }

    public void setOrientation(int iOrientation) {
        if (this.iOrientation == iOrientation) {
            return;
        }
        this.iOrientation = iOrientation;
        this.pGraphics.setClipRegion(0, 0, this.getWidth(), this.getHeight());
    }

    public int getOrientation() {
        return this.iOrientation;
    }

    public int getWidth() {
        if (this.getOrientation() == 1) {
            return this.pCanvas.getHeight();
        }
        return this.pCanvas.getWidth();
    }

    public int getHeight() {
        if (this.getOrientation() == 1) {
            return this.pCanvas.getWidth();
        }
        return this.pCanvas.getHeight();
    }

    public Graphics getGraphics() {
        return this.pGraphics;
    }

    public GameCanvas getMicroeditionCanvas() {
        return this.pCanvas;
    }

    public javax.microedition.lcdui.Graphics getMicroeditionGraphics() {
        return this.pCanvas.getGraphics();
    }
}

