/*
 * Decompiled with CFR 0.152.
 */
package simple.video;

import simple.debug.DebugOutput;
import simple.video.Graphics;
import simple.video.Image;

public class BitmapFont {
    private Image pFontImage;
    private short[] asSupportedChars;
    private short[] asSupportedCharsPosX;
    private byte[] abSupportedCharsWidth;
    private int iHeight;
    private int iHorizontalSpacing;
    private int iMaxNumChrWidth;
    private int iMaxTxtChrWidth;
    private static final char cChrFormat = '\\';

    private static short[] SortArray(short[] asArray, boolean bCreateIndexTable) {
        int i;
        short[] indexTable = null;
        if (bCreateIndexTable) {
            i = asArray.length;
            indexTable = new short[i];
            while (i-- != 0) {
                indexTable[i] = (short)i;
            }
        }
        for (i = 0; i < asArray.length - 1; ++i) {
            int j;
            int k = i;
            for (j = i + 1; j < asArray.length; ++j) {
                if (asArray[j] >= asArray[k]) continue;
                k = j;
            }
            j = asArray[k];
            asArray[k] = asArray[i];
            asArray[i] = (short)j;
            if (indexTable == null) continue;
            j = indexTable[k];
            indexTable[k] = indexTable[i];
            indexTable[i] = (short)j;
        }
        return indexTable;
    }

    private static int BinarySearchA(short[] asArray, short sKey) {
        int off = 0;
        int hi = asArray.length - 1;
        while (off <= hi) {
            int m = off + hi >>> 1;
            short v = asArray[m];
            if (v < sKey) {
                off = m + 1;
                continue;
            }
            if (v > sKey) {
                hi = m - 1;
                continue;
            }
            return m;
        }
        return ~off;
    }

    static void bitBlt(Image pSrc, Graphics pDes, int iSrcX, int iSrcY, int iSrcW, int iSrcH, int iDesX, int iDesY) {
        pSrc.drawRegionAtPoint(pDes, iDesX, iDesY, iSrcX, iSrcY, iSrcW, iSrcH, 0, 0, false, false);
    }

    public BitmapFont(Image pImg, short[] asSupChar, byte[] abSupCharWidth, int iHSpacing) {
        int i;
        DebugOutput.traceIn(2, "BitmapFont", "constructor");
        short[] asSupCharXPos = new short[asSupChar.length];
        asSupCharXPos[0] = 0;
        for (i = 1; i < abSupCharWidth.length; ++i) {
            asSupCharXPos[i] = (short)(asSupCharXPos[i - 1] + abSupCharWidth[i - 1]);
        }
        this.pFontImage = pImg;
        this.iHeight = pImg.getHeight();
        this.iHorizontalSpacing = iHSpacing;
        this.asSupportedChars = asSupChar;
        this.asSupportedCharsPosX = asSupCharXPos;
        this.abSupportedCharsWidth = abSupCharWidth;
        this.iMaxTxtChrWidth = 0;
        this.iMaxNumChrWidth = 0;
        System.out.println("bbb");
        short[] indexTable = BitmapFont.SortArray(asSupChar, true);
        i = indexTable.length;
        short[] chrXPos = new short[i];
        byte[] chrWidth = new byte[i];
        System.arraycopy(asSupCharXPos, 0, chrXPos, 0, i);
        System.arraycopy(abSupCharWidth, 0, chrWidth, 0, i);
        while (i-- != 0) {
            asSupCharXPos[i] = chrXPos[indexTable[i]];
            abSupCharWidth[i] = chrWidth[indexTable[i]];
        }
        i = asSupChar.length;
        while (i-- != 0) {
            int chrW = abSupCharWidth[i];
            short chr = asSupChar[i];
            if (chr < 48 || chr > 57) {
                if (chrW <= this.iMaxTxtChrWidth) continue;
                this.iMaxTxtChrWidth = chrW;
                continue;
            }
            if (chrW <= this.iMaxNumChrWidth) continue;
            this.iMaxNumChrWidth = chrW;
        }
        DebugOutput.traceOut(2, "BitmapFont", "constructor");
    }

    public BitmapFont(Image pImg, short[] asSupChar, short[] asSupCharXPos, byte[] abSupCharWidth, int iHSpacing) {
        this.pFontImage = pImg;
        this.iHeight = pImg.getHeight();
        this.iHorizontalSpacing = iHSpacing;
        this.asSupportedChars = asSupChar;
        this.asSupportedCharsPosX = asSupCharXPos;
        this.abSupportedCharsWidth = abSupCharWidth;
        this.iMaxTxtChrWidth = 0;
        this.iMaxNumChrWidth = 0;
        short[] indexTable = BitmapFont.SortArray(asSupChar, true);
        int i = indexTable.length;
        short[] chrXPos = new short[i];
        byte[] chrWidth = new byte[i];
        System.arraycopy(asSupCharXPos, 0, chrXPos, 0, i);
        System.arraycopy(abSupCharWidth, 0, chrWidth, 0, i);
        while (i-- != 0) {
            asSupCharXPos[i] = chrXPos[indexTable[i]];
            abSupCharWidth[i] = chrWidth[indexTable[i]];
        }
        i = asSupChar.length;
        while (i-- != 0) {
            int chrW = abSupCharWidth[i];
            short chr = asSupChar[i];
            if (chr < 48 || chr > 57) {
                if (chrW <= this.iMaxTxtChrWidth) continue;
                this.iMaxTxtChrWidth = chrW;
                continue;
            }
            if (chrW <= this.iMaxNumChrWidth) continue;
            this.iMaxNumChrWidth = chrW;
        }
    }

    public boolean supportsChar(char cChar) {
        return BitmapFont.BinarySearchA(this.asSupportedChars, (short)cChar) >= 0;
    }

    public Image getImage() {
        return this.pFontImage;
    }

    public int getHeight() {
        return this.iHeight;
    }

    public int getCharWidth(char cChar) {
        int i = BitmapFont.BinarySearchA(this.asSupportedChars, (short)cChar);
        if (i >= 0) {
            return this.abSupportedCharsWidth[i];
        }
        return 0;
    }

    public int getTextWidth(String sText) {
        return this.getTextWidth(sText, 0, sText.length());
    }

    public int getTextWidth(String sText, int iFrom, int iLen) {
        int iTextWidth = 0;
        while (iLen-- > 0) {
            short sChar;
            if ((sChar = (short)sText.charAt(iFrom++)) != 92) {
                int iCharId = BitmapFont.BinarySearchA(this.asSupportedChars, sChar);
                if (iCharId < 0) continue;
                iTextWidth += this.abSupportedCharsWidth[iCharId] + this.iHorizontalSpacing;
                continue;
            }
            ++iFrom;
            --iLen;
        }
        return iTextWidth - this.iHorizontalSpacing;
    }

    public int getCharsWidth(char[] acText, int iFrom, int iLen) {
        int iTextWidth = 0;
        while (iLen-- > 0) {
            short sChar;
            if ((sChar = (short)acText[iFrom++]) != 92) {
                int iCharId = BitmapFont.BinarySearchA(this.asSupportedChars, sChar);
                if (iCharId < 0) continue;
                iTextWidth += this.abSupportedCharsWidth[iCharId] + this.iHorizontalSpacing;
                continue;
            }
            ++iFrom;
            --iLen;
        }
        return iTextWidth - this.iHorizontalSpacing;
    }

    public void drawTextAtPos(Graphics pGraphics, int iX, int iY, String sText) {
        this.drawTextRegionAtPos(pGraphics, iX, iY, sText, 0, sText.length());
    }

    public void drawTextRegionAtPos(Graphics pGraphics, int iX, int iY, String sText, int iFrom, int iLen) {
        int iPosX = iX;
        while (iLen-- > 0) {
            short sChar;
            if ((sChar = (short)sText.charAt(iFrom++)) != 92) {
                int iCharId = BitmapFont.BinarySearchA(this.asSupportedChars, sChar);
                if (iCharId < 0) continue;
                byte iCharWidth = this.abSupportedCharsWidth[iCharId];
                if (sChar != 32) {
                    BitmapFont.bitBlt(this.pFontImage, pGraphics, this.asSupportedCharsPosX[iCharId], 0, iCharWidth, this.iHeight, iPosX, iY);
                }
                iPosX += iCharWidth + this.iHorizontalSpacing;
                continue;
            }
            ++iFrom;
            --iLen;
        }
    }
}

