/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.oldschoolracing;

import javax.microedition.lcdui.Font;
import simple.core.Application;
import simple.debug.DebugOutput;
import simple.events.Event;
import simple.input.Key;
import simple.input.Keys;
import simple.input.Pointer;
import simple.input.Pointers;
import simple.video.Graphics;
import simple.video.Screen;
import sk.inlogic.oldschoolracing.IScreen;
import sk.inlogic.oldschoolracing.Profile;
import sk.inlogic.oldschoolracing.Resources;
import sk.inlogic.oldschoolracing.ScreenGame;
import sk.inlogic.oldschoolracing.ScreenMenu;
import sk.inlogic.oldschoolracing.ScreenSplash;
import sk.inlogic.oldschoolracing.Sounds;
import sk.inlogic.oldschoolracing.Texts;

public class MyApplication
extends Application {
    static MyApplication pInstance;
    public static IScreen pActiveScreen;
    public static ScreenSplash pScrSplash;
    public static ScreenMenu pScrMenu;
    public static ScreenGame pScrGame;
    public static boolean bTouchScreen;
    public static boolean bLoading;
    public static Font pSystemFont;
    boolean bMusicOn;

    public MyApplication() {
        Profile.load();
        DebugOutput.setDebugLevel(0);
        pSystemFont = Font.getFont((int)0, (int)0, (int)8);
        pInstance = this;
    }

    public static MyApplication getInstance() {
        return pInstance;
    }

    public void update() {
        if (pActiveScreen == null) {
            pScrSplash = new ScreenSplash();
            pActiveScreen = pScrSplash;
        }
        if (pActiveScreen != null) {
            pActiveScreen.update(33L);
        }
    }

    public void onEventFired(Event event) {
        if (Pointers.isEventSender(event)) {
            Pointer pointer = (Pointer)event.getData();
            switch (pointer.iAction) {
                case 2: {
                    this.pointerPressed(pointer.iPositionX, pointer.iPositionY);
                    break;
                }
                case 3: {
                    this.pointerReleased(pointer.iPositionX, pointer.iPositionY);
                }
            }
        }
        if (Keys.isEventSender(event)) {
            Key pKey = (Key)event.getData();
            switch (pKey.iAction) {
                case 1: {
                    this.keyPressed(pKey);
                    break;
                }
                case 2: {
                    this.keyReleased(pKey);
                }
            }
        }
    }

    private void pointerPressed(int iX, int iY) {
        DebugOutput.traceIn(100, "MyApplication", "pointerPressed(" + iX + ", " + iY + ")");
        bTouchScreen = true;
        if (pActiveScreen != null) {
            pActiveScreen.pointerPressed(iX, iY);
        }
        DebugOutput.traceOut(100, "MyApplication", "pointerPressed()");
    }

    private void pointerReleased(int iX, int iY) {
        DebugOutput.traceIn(100, "MyApplication", "pointerReleased(" + iX + ", " + iY + ")");
        if (pActiveScreen != null) {
            pActiveScreen.pointerReleased(iX, iY);
        }
        DebugOutput.traceOut(100, "MyApplication", "pointerReleased()");
    }

    private void keyPressed(Key pKey) {
        if (pActiveScreen != null) {
            pActiveScreen.keyPressed(pKey);
        }
    }

    private void keyReleased(Key pKey) {
        if (pActiveScreen != null) {
            pActiveScreen.keyReleased(pKey);
        }
    }

    private void paintLoading(Graphics g) {
        int iScreenW = g.getWidth();
        int iScreenH = g.getHeight();
        int partsX = Resources.iScreenW / Resources.iBorderW - Resources.MINUS_MAIN_X_PARTS;
        int partsY = Resources.iScreenH / Resources.iBorderH - 2;
        Resources.paintBackground(g);
        Resources.paintMenuBG(partsX, partsY, g);
        int iPosY = (Resources.iScreenH - Resources.iBorderH * (partsY - 1)) / 2;
        Resources.imgLogo.drawAtPoint(g, (Resources.iScreenW - Resources.iLogoW) / 2, iPosY);
        boolean buttonFrame = false;
        partsX = (partsX - 2) * Resources.iBorderW / Resources.iDemFGW;
        int x = (Resources.iScreenW - partsX * Resources.iDemFGW) / 2;
        int y = iPosY + Resources.iLogoH + Resources.iDemBGH;
        String sText = Texts.getString(0);
        int iTextW = Texts.getTextWidth(sText);
        iPosY = (Resources.iScreenH - Resources.iBorderH * partsY) / 2 + partsY * Resources.iBorderH - Texts.getFontHeight() - Texts.getFontHeight() / 2;
        Texts.drawTextAtPos(g, (Resources.iScreenW - iTextW) / 2, iPosY, sText);
    }

    public void paintScreen(Screen pScreen) {
        Graphics g = pScreen.getGraphics();
        Resources.iScreenH = g.getHeight();
        if (bLoading) {
            this.paintLoading(g);
            return;
        }
        if (pActiveScreen != null) {
            pActiveScreen.paintScreen(g);
        }
    }

    public void onPause() {
        if (Profile.bMusic) {
            this.bMusicOn = true;
            Profile.bMusic = false;
            Sounds.stopMusic();
        }
        if (pActiveScreen != null) {
            pActiveScreen.onPause();
        }
    }

    public void onStart() {
        this.bMusicOn = false;
    }

    public void onResume() {
        if (this.bMusicOn) {
            Profile.bMusic = true;
        }
        if (pActiveScreen != null) {
            pActiveScreen.onResume();
        }
    }

    public void onStop() {
        if (Profile.bMusic) {
            Profile.bMusic = false;
            this.bMusicOn = true;
            Sounds.stopMusic();
        }
        if (pActiveScreen != null) {
            pActiveScreen.onPause();
        }
    }

    static {
        pActiveScreen = null;
        pScrSplash = null;
        pScrMenu = null;
        pScrGame = null;
        bTouchScreen = true;
        bLoading = false;
        pSystemFont = null;
    }
}

