/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.oldschoolracing;

import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Vector;
import simple.video.Graphics;
import sk.inlogic.oldschoolracing.Environment;
import sk.inlogic.oldschoolracing.Resources;
import sk.inlogic.oldschoolracing.ScreenGame;

public class Map {
    public static int width = 0;
    public static int height = 0;
    public static int[][] tilesMatrix;
    public static int[][] orientationMatrix;
    public static int[][] flippedMatrix;
    public static int[] startLinesX;
    public static int[] startLinesY;
    public static int iStartLineRot;
    public static int iStartLinePosX;
    public static int iStartLinePosY;
    public static int envir;
    public static Vector checks;

    public void loadMap(int env, int track) {
        try {
            InputStream is = this.getClass().getResourceAsStream("/map" + env + "-" + track + ".bin");
            DataInputStream input = new DataInputStream(is);
            width = input.readByte();
            height = input.readByte();
            envir = input.readByte();
            tilesMatrix = new int[width][height];
            orientationMatrix = new int[width][height];
            flippedMatrix = new int[width][height];
            for (int i = 0; i < width; ++i) {
                for (int j = 0; j < height; ++j) {
                    Map.tilesMatrix[i][j] = input.readByte();
                    Map.orientationMatrix[i][j] = input.readByte();
                    Map.flippedMatrix[i][j] = input.readByte();
                }
            }
            Resources.loadEnviromentResources(Environment.iEnv);
            int x = input.readByte() * 30;
            byte xzv = input.readByte();
            int y = input.readByte() * 30;
            byte yzv = input.readByte();
            iStartLineRot = input.readByte();
            iStartLinePosX = (x + xzv) * Resources.iRoadW / 30;
            iStartLinePosY = (y + yzv) * Resources.iRoadW / 30;
            this.setStartPositions((x + xzv) * Resources.iRoadW / 30, (y + yzv) * Resources.iRoadW / 30, iStartLineRot);
            int size = input.readShort();
            for (int i = 0; i < size; ++i) {
                x = input.readByte() * Resources.iRoadW;
                xzv = input.readByte();
                y = input.readByte() * Resources.iRoadW;
                yzv = input.readByte();
                byte rot = input.readByte();
                checks.addElement(new Checks(x + xzv * Resources.iRoadW / 30, y + yzv * Resources.iRoadW / 30, rot));
            }
            this.addLastCheck();
            this.printMatrixes();
        }
        catch (Exception e) {
            System.out.println("chybaaaaaaa" + e.toString());
        }
    }

    public void addLastCheck() {
        int y;
        int x;
        block7: {
            block8: {
                x = 0;
                y = 0;
                if (iStartLineRot == 1) {
                    x = iStartLinePosX - ScreenGame.iXPos + Resources.iStartLineW / 2;
                    y = iStartLinePosY - ScreenGame.iYPos;
                }
                if (iStartLineRot == 4) {
                    x = iStartLinePosX - ScreenGame.iXPos;
                    y = iStartLinePosY - ScreenGame.iYPos + Resources.iStartLineW / 2;
                }
                if (iStartLineRot == 2) {
                    x = iStartLinePosX - ScreenGame.iXPos + 5 * Resources.StartOffsets;
                    y = iStartLinePosY - ScreenGame.iYPos + Resources.iStartLineW / 2;
                }
                if (iStartLineRot == 3) {
                    x = iStartLinePosX - ScreenGame.iXPos;
                    y = iStartLinePosY - ScreenGame.iYPos + 5 * Resources.StartOffsets + Resources.iStartLineW / 2;
                }
                if (Environment.iTrack != 6) break block7;
                if (Environment.iEnv == 1) break block8;
                if (Environment.iEnv != 2) break block7;
            }
            return;
        }
        checks.addElement(new Checks(x, y, iStartLineRot));
    }

    public void setStartPositions(int x, int y, int rot) {
        System.out.println("start positions: " + x + ", " + y + ", rot = " + rot);
        if (rot == 1) {
            Map.startLinesX[0] = x;
            Map.startLinesY[0] = y + Resources.StartOffsets;
            Map.startLinesX[1] = x + Resources.StartOffsets;
            Map.startLinesY[1] = y + Resources.StartOffsets * 2;
            Map.startLinesX[2] = x;
            Map.startLinesY[2] = y + Resources.StartOffsets * 3;
            Map.startLinesX[3] = x + Resources.StartOffsets;
            Map.startLinesY[3] = y + Resources.StartOffsets * 4;
            Map.startLinesX[4] = x;
            Map.startLinesY[4] = y + Resources.StartOffsets * 5;
        } else if (rot == 2) {
            Map.startLinesX[0] = x + Resources.StartOffsets * 5;
            Map.startLinesY[0] = y + Resources.StartOffsets;
            Map.startLinesX[1] = x + Resources.StartOffsets * 4;
            Map.startLinesY[1] = y;
            Map.startLinesX[2] = x + Resources.StartOffsets * 3;
            Map.startLinesY[2] = y + Resources.StartOffsets;
            Map.startLinesX[3] = x + Resources.StartOffsets * 2;
            Map.startLinesY[3] = y;
            Map.startLinesX[4] = x + Resources.StartOffsets;
            Map.startLinesY[4] = y + Resources.StartOffsets;
        } else if (rot == 3) {
            Map.startLinesX[0] = x;
            Map.startLinesY[0] = y - Resources.StartOffsets;
            Map.startLinesX[1] = x + Resources.StartOffsets;
            Map.startLinesY[1] = y - Resources.StartOffsets * 2;
            Map.startLinesX[2] = x;
            Map.startLinesY[2] = y - Resources.StartOffsets * 3;
            Map.startLinesX[3] = x + Resources.StartOffsets;
            Map.startLinesY[3] = y - Resources.StartOffsets * 4;
            Map.startLinesX[4] = x;
            Map.startLinesY[4] = y - Resources.StartOffsets * 5;
        } else if (rot == 4) {
            Map.startLinesX[0] = x + Resources.StartOffsets;
            Map.startLinesY[0] = y + Resources.StartOffsets;
            Map.startLinesX[1] = x + Resources.StartOffsets * 2;
            Map.startLinesY[1] = y;
            Map.startLinesX[2] = x + Resources.StartOffsets * 3;
            Map.startLinesY[2] = y + Resources.StartOffsets;
            Map.startLinesX[3] = x + Resources.StartOffsets * 4;
            Map.startLinesY[3] = y;
            Map.startLinesX[4] = x + Resources.StartOffsets * 5;
            Map.startLinesY[4] = y + Resources.StartOffsets;
        }
    }

    public void printMatrixes() {
        int j;
        int i;
        System.out.println("\n.........................\n");
        System.out.println("\n.........................\n");
        System.out.println("\n.........................\n");
        for (i = 0; i < width; ++i) {
            for (j = 0; j < height; ++j) {
                System.out.print(tilesMatrix[i][j] + ", ");
            }
            System.out.println("");
        }
        System.out.println("\n.........................\n");
        for (i = 0; i < width; ++i) {
            for (j = 0; j < height; ++j) {
                System.out.print(orientationMatrix[i][j] + ", ");
            }
            System.out.println("");
        }
        System.out.println("\n.........................\n");
        for (i = 0; i < width; ++i) {
            for (j = 0; j < height; ++j) {
                System.out.print(flippedMatrix[i][j] + ", ");
            }
            System.out.println("");
        }
    }

    public void paintMap(Graphics g) {
        block17: {
            block18: {
                int widStart = ScreenGame.iYPos / Resources.iRoadW;
                int widEnd = 2 + ScreenGame.iYPos / Resources.iRoadW + Resources.iScreenH / Resources.iRoadW;
                if (widEnd > width) {
                    widEnd = width;
                }
                int heiStart = ScreenGame.iXPos / Resources.iRoadW;
                int heiEnd = 2 + ScreenGame.iXPos / Resources.iRoadW + Resources.iScreenW / Resources.iRoadW;
                if (heiEnd > height) {
                    heiEnd = height;
                }
                for (int i = widStart; i < widEnd; ++i) {
                    for (int j = heiStart; j < heiEnd; ++j) {
                        if (j < ScreenGame.iXPos / Resources.iRoadW || j - 1 > ScreenGame.iXPos / Resources.iRoadW + Resources.iScreenW / Resources.iRoadW || i < ScreenGame.iYPos / Resources.iRoadW || i - 1 > ScreenGame.iYPos / Resources.iRoadW + Resources.iScreenH / Resources.iRoadW) continue;
                        if (orientationMatrix[i][j] == 1 && flippedMatrix[i][j] == 1) {
                            Resources.sprRoad.setFrame(tilesMatrix[i][j] - 1);
                            Resources.sprRoad.setRotation(1);
                            Resources.sprRoad.setHorizontalFlip(false);
                            Resources.sprRoad.setVerticalFlip(false);
                            Resources.sprRoad.setPosition(j * Resources.iRoadW - ScreenGame.iXPos, i * Resources.iRoadW - ScreenGame.iYPos);
                            Resources.sprRoad.paint(g);
                            continue;
                        }
                        this.paintRotatedTile(g, i, j);
                    }
                }
                if (iStartLineRot == 1 || iStartLineRot == 4) {
                    Resources.imgStartLine.drawRotatedAtPoint(g, iStartLinePosX - ScreenGame.iXPos, iStartLinePosY - ScreenGame.iYPos, false, false, iStartLineRot);
                } else if (iStartLineRot == 2) {
                    Resources.imgStartLine.drawRotatedAtPoint(g, iStartLinePosX - ScreenGame.iXPos + 5 * Resources.StartOffsets, iStartLinePosY - ScreenGame.iYPos, false, false, iStartLineRot);
                } else if (iStartLineRot == 3) {
                    Resources.imgStartLine.drawRotatedAtPoint(g, iStartLinePosX - ScreenGame.iXPos, iStartLinePosY - ScreenGame.iYPos + 5 * Resources.StartOffsets, false, false, iStartLineRot);
                }
                if (Environment.iTrack != 6) break block17;
                if (Environment.iEnv == 1) break block18;
                if (Environment.iEnv != 2) break block17;
            }
            int iFinRot = ((Checks)Map.checks.elementAt((int)(Map.checks.size() - 1))).rot;
            int iFinX = ((Checks)Map.checks.elementAt((int)(Map.checks.size() - 1))).x;
            int iFinY = ((Checks)Map.checks.elementAt((int)(Map.checks.size() - 1))).y;
            if (iFinRot == 1) {
                iFinX -= Resources.iStartLineW / 2;
            }
            if (iFinRot == 2) {
                iFinY -= Resources.iStartLineW / 2;
            }
            if (iFinRot == 3) {
                iFinX -= Resources.iStartLineW / 2;
            }
            if (iFinRot == 1) {
                iFinY -= Resources.iStartLineW / 2;
            }
            Resources.imgStartLine.drawRotatedAtPoint(g, iFinX - ScreenGame.iXPos, iFinY - ScreenGame.iYPos, false, false, iFinRot);
        }
    }

    public void paintRotatedTile(Graphics g, int i, int j) {
        Resources.sprRoad.setFrame(tilesMatrix[i][j] - 1);
        Resources.sprRoad.setRotation(orientationMatrix[i][j]);
        Resources.sprRoad.setHorizontalFlip(false);
        Resources.sprRoad.setVerticalFlip(false);
        if (flippedMatrix[i][j] == 2 || flippedMatrix[i][j] == 4) {
            Resources.sprRoad.setHorizontalFlip(true);
        }
        if (flippedMatrix[i][j] == 3 || flippedMatrix[i][j] == 4) {
            Resources.sprRoad.setVerticalFlip(true);
        }
        if (tilesMatrix[i][j] - 1 == 0 || tilesMatrix[i][j] - 1 == 1 || tilesMatrix[i][j] - 1 == 3) {
            Resources.sprRoad.setHorizontalFlip(false);
            Resources.sprRoad.setVerticalFlip(false);
        }
        if (flippedMatrix[i][j] == 4) {
            Resources.sprRoad.setHorizontalFlip(false);
            Resources.sprRoad.setVerticalFlip(false);
            if (orientationMatrix[i][j] == 1) {
                Resources.sprRoad.setRotation(3);
            }
            if (orientationMatrix[i][j] == 2) {
                Resources.sprRoad.setRotation(4);
            }
            if (orientationMatrix[i][j] == 3) {
                Resources.sprRoad.setRotation(1);
            }
            if (orientationMatrix[i][j] == 4) {
                Resources.sprRoad.setRotation(2);
            }
        }
        Resources.sprRoad.defineReferencePixel(0, 0);
        Resources.sprRoad.setPosition(j * Resources.iRoadW - ScreenGame.iXPos, i * Resources.iRoadW - ScreenGame.iYPos);
        Resources.sprRoad.paintRotated(g);
    }

    public void paintAxis(Graphics g) {
        g.setColor(0xFF0000);
        int nrW = width;
        int x = 0;
        for (int i = 0; i < nrW + 1; ++i) {
            x = i * 30;
            g.drawLine(x - ScreenGame.iXPos, 0 - ScreenGame.iYPos, x - ScreenGame.iXPos, height * 30 - ScreenGame.iYPos);
        }
        int nrH = height;
        int y = 0;
        for (int i = 0; i < nrH + 1; ++i) {
            y = i * 30;
            g.drawLine(0 - ScreenGame.iXPos, y - ScreenGame.iYPos, width * 30 - ScreenGame.iXPos, y - ScreenGame.iYPos);
        }
    }

    static {
        startLinesX = new int[5];
        startLinesY = new int[5];
        checks = new Vector();
    }

    class Checks {
        public int x;
        public int y;
        public int rot;

        public Checks(int ix, int iy, int irot) {
            this.x = ix;
            this.y = iy;
            this.rot = irot;
        }
    }
}

