/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.oldschoolracing;

import simple.input.Key;
import simple.input.Keys;
import simple.video.Graphics;
import simple.video.Image;
import sk.inlogic.oldschoolracing.CMenuItem;
import sk.inlogic.oldschoolracing.IMenuItemActivator;
import sk.inlogic.oldschoolracing.IMenuItemRenderer;
import sk.inlogic.oldschoolracing.IScreen;
import sk.inlogic.oldschoolracing.MenuSystem;
import sk.inlogic.oldschoolracing.MyApplication;
import sk.inlogic.oldschoolracing.Profile;
import sk.inlogic.oldschoolracing.Resources;
import sk.inlogic.oldschoolracing.ScreenMenu;
import sk.inlogic.oldschoolracing.Sounds;
import sk.inlogic.oldschoolracing.Texts;

public class ScreenSplash
implements IScreen,
IMenuItemActivator,
IMenuItemRenderer {
    final int MODE_VOID;
    final int MODE_LOADINGRES;
    final int MODE_LANGUAGES;
    final int MODE_SOUNDS;
    final int MODE_LOGO;
    final int MODE_TITLE;
    final int TIME_DELAY;
    int iMode = 1;
    int iModeDelay;
    MyApplication pMyApplication = MyApplication.getInstance();
    MenuSystem pMenuSystem;

    public ScreenSplash() {
        this.MODE_VOID = 0;
        this.MODE_LOADINGRES = 1;
        this.MODE_LANGUAGES = 2;
        this.MODE_SOUNDS = 3;
        this.MODE_LOGO = 4;
        this.MODE_TITLE = 5;
        this.TIME_DELAY = 3000;
    }

    private void prepareEnableSounds() {
        Resources.prepareMultiLineText(Texts.getString(6));
    }

    public void update(long lTick) {
        if (this.iMode > 3 && this.iModeDelay > 0) {
            this.iModeDelay = (int)((long)this.iModeDelay - lTick);
            if (this.iModeDelay <= 0) {
                this.nextMode();
            }
        }
        this.pMyApplication.repaintScreen();
        if (this.iMode == 1) {
            this.updateModeLoadingRes();
        }
    }

    private void updateModeLoadingRes() {
        this.pMyApplication.repaintScreen();
        Resources.loadInitialResources();
        this.pMenuSystem = MenuSystem.getInstance();
        this.pMenuSystem.setMenuItemActivator(this);
        this.pMenuSystem.setMenuItemRenderer(this);
        int iGap = Resources.iLangW / 5;
        int iWidth = Resources.iLangW;
        int iHeight = Resources.iLangH;
        int iPosX = (Resources.iScreenW - iWidth) / 2;
        int iPosY = iHeight / 2 + (Resources.iScreenH - (iHeight + iGap)) / 2 - Resources.LANG_OFFSET;
        this.pMenuSystem.addMenuItem(new CMenuItem(0, "ENGLISH", iPosX - iWidth - iGap, iPosY, iWidth, iHeight));
        this.pMenuSystem.addMenuItem(new CMenuItem(1, "DEUTSCH", iPosX, iPosY, iWidth, iHeight));
        this.pMenuSystem.addMenuItem(new CMenuItem(2, "FRAN\u00c7AIS", iPosX + iWidth + iGap, iPosY, iWidth, iHeight));
        this.pMenuSystem.addMenuItem(new CMenuItem(3, "ESPA\u00d1OL", iPosX - iWidth - iGap, iPosY + iHeight + iGap, iWidth, iHeight));
        this.pMenuSystem.addMenuItem(new CMenuItem(4, "T\u00dcRK\u0130YE", iPosX, iPosY + iHeight + iGap, iWidth, iHeight));
        this.pMenuSystem.addMenuItem(new CMenuItem(5, "PORTUGU\u00caS", iPosX + iWidth + iGap, iPosY + iHeight + iGap, iWidth, iHeight));
        this.pMenuSystem.getClass();
        this.pMenuSystem.iMenuType = 1;
        this.iMode = 2;
        Resources.loadLangResources();
        this.pMyApplication.repaintScreen();
    }

    public void paintScreen(Graphics g) {
        switch (this.iMode) {
            case 2: {
                this.paintModeLanguage(g);
                break;
            }
            case 3: {
                this.paintModeSounds(g);
                break;
            }
            case 4: {
                this.paintModeLogo(g);
                break;
            }
            case 5: {
                this.paintModeTitle(g);
            }
        }
    }

    private void paintModeLanguage(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, Resources.iScreenW, Resources.iScreenH);
        this.pMenuSystem.paintMenu(g);
    }

    public void renderMenuItem(Graphics g, CMenuItem pMenuItem, boolean bSelected) {
        int iTextW = Texts.getTextWidth(pMenuItem.getCaption());
        int iDspX = (pMenuItem.getWidth() - iTextW) / 2;
        if (bSelected) {
            Resources.sprLangOn.setFrame(pMenuItem.getID());
            Resources.sprLangOn.setPosition(pMenuItem.getLeft(), pMenuItem.getTop());
            Resources.sprLangOn.paint(g);
        } else {
            Resources.sprLang.setFrame(pMenuItem.getID());
            Resources.sprLang.setPosition(pMenuItem.getLeft(), pMenuItem.getTop());
            Resources.sprLang.paint(g);
        }
        int partsY = Resources.iScreenH / Resources.iBorderH - Resources.MINUS_MAIN_Y_PARTS;
        int iPosY = (Resources.iScreenH - Resources.iBorderH * partsY) / 2 + partsY * Resources.iBorderH - Texts.getFontHeight() - Texts.getFontHeight() / 2;
        if (bSelected) {
            Texts.drawTextAtPos(g, (Resources.iScreenW - iTextW) / 2, iPosY - Resources.CAPTION_OFFSET, pMenuItem.getCaption());
        }
    }

    private void paintModeSounds(Graphics g) {
        int partsX = Resources.iScreenW / Resources.iBorderW - Resources.MINUS_MAIN_X_PARTS;
        int partsY = Resources.iScreenH / Resources.iBorderH - Resources.MINUS_MAIN_Y_PARTS;
        Resources.paintMenuBG(partsX, partsY, g);
        int iPosY = (Resources.iScreenH - Resources.iBorderH * (partsY - 1)) / 2;
        Resources.imgLogo.drawAtPoint(g, (Resources.iScreenW - Resources.iLogoW) / 2, iPosY);
        int y = (partsY * Resources.iBorderH - Resources.iLogoH - Resources.iMenuIcOutH) / 2 + iPosY / 2 + Resources.iLogoH;
        Resources.sprMenuIcs.setFrame(0);
        Resources.sprMenuIcs.setPosition((Resources.iScreenW - Resources.iMenuIcsW) / 2, y + Resources.MENU_RING_OFFSET);
        Resources.sprMenuIcs.paint(g);
        Resources.imgMenuIcOut.drawAtPoint(g, (Resources.iScreenW - Resources.iMenuIcOutW) / 2, y);
        Resources.paintLeftButton(g, partsY);
        Resources.paintRightButton(g, partsY);
    }

    private void paintModeLogo(Graphics g) {
        g.setColor(0xFF0000);
        g.fillRect(0, 0, Resources.iScreenW, Resources.iScreenH);
        Resources.imgBackground = new Image("/minl.png");
        Resources.paintBackground(g);
    }

    private void paintModeTitle(Graphics g) {
        g.setColor(0xFF0000);
        g.fillRect(0, 0, Resources.iScreenW, Resources.iScreenH);
        Resources.imgBackground = new Image("/mspl.png");
        Resources.paintBackground(g);
    }

    public void keyPressed(Key pKey) {
        switch (this.iMode) {
            case 2: {
                this.keyPressedModeLanguages(pKey);
                break;
            }
            case 3: {
                this.keyPressedModeSounds(pKey);
                break;
            }
            case 4: 
            case 5: {
                this.keyPressedModeSplash(pKey);
            }
        }
    }

    private void keyPressedModeLanguages(Key pKey) {
        this.pMenuSystem.keyPressed(pKey);
        if (pKey.iGameAction == 8 || pKey.iValue == 53) {
            this.nextMode();
        }
    }

    void keyPressedModeSounds(Key pKey) {
        if (pKey.iValue == Keys.KEY_FNLEFT) {
            Profile.bMusic = true;
            Sounds.playMenuMusic();
            this.nextMode();
            return;
        }
        if (pKey.iValue == Keys.KEY_FNRIGHT) {
            Profile.bMusic = false;
            this.nextMode();
        }
    }

    void keyPressedModeSplash(Key pKey) {
        if (pKey.iGameAction == 8 || pKey.iValue == 53 || pKey.iValue == 100) {
            this.nextMode();
        }
    }

    void nextMode() {
        this.iModeDelay = 3000;
        switch (this.iMode) {
            case 2: {
                Resources.loadSplashResources();
                this.iMode = 3;
                break;
            }
            case 3: {
                this.iMode = 4;
                break;
            }
            case 4: {
                this.iMode = 5;
                break;
            }
            case 5: {
                Resources.releaseSplashResources();
                MyApplication.pScrMenu = new ScreenMenu();
                MyApplication.pActiveScreen = MyApplication.pScrMenu;
                MyApplication.pScrSplash = null;
                System.gc();
                this.iMode = 0;
            }
        }
    }

    public void keyReleased(Key pKey) {
    }

    public void pointerPressed(int x, int y) {
        if (this.iMode == 3) {
            if (Resources.pressedLeftButton(x, y)) {
                Profile.bMusic = true;
                this.nextMode();
                return;
            }
            if (Resources.pressedRightButton(x, y)) {
                Profile.bMusic = false;
                this.nextMode();
                return;
            }
        }
        if (Resources.pressedLeftButton(x, y)) {
            this.pMenuSystem.activateSelectedMenuItem();
            return;
        }
        this.pMenuSystem.pointerPressed(x, y);
    }

    public void pointerReleased(int x, int y) {
    }

    public void onMenuItemActivated(int iIdx) {
        if (this.iMode == 2) {
            Texts.iLanguage = iIdx;
        }
    }

    public void onPause() {
    }

    public void onResume() {
    }

    public void onStart() {
    }
}

