/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.oldschoolracing;

import javax.microedition.lcdui.Font;
import simple.core.Application;
import simple.debug.DebugOutput;
import simple.events.Event;
import simple.input.Key;
import simple.input.Keys;
import simple.input.Pointer;
import simple.input.Pointers;
import simple.video.Graphics;
import simple.video.Screen;
import sk.inlogic.oldschoolracing.IScreen;
import sk.inlogic.oldschoolracing.Profile;
import sk.inlogic.oldschoolracing.Resources;
import sk.inlogic.oldschoolracing.ScreenGame;
import sk.inlogic.oldschoolracing.ScreenMenu;
import sk.inlogic.oldschoolracing.ScreenSplash;
import sk.inlogic.oldschoolracing.Sounds;
import sk.inlogic.oldschoolracing.Texts;

public class MyApplication
extends Application {
    static MyApplication pInstance;
    public static IScreen pActiveScreen;
    public static ScreenSplash pScrSplash;
    public static ScreenMenu pScrMenu;
    public static ScreenGame pScrGame;
    public static boolean bTouchScreen;
    public static boolean bLoading;
    public static Font pSystemFont;
    public static boolean bPause;
    public static boolean bMusicOn;

    public MyApplication() {
        Profile.load();
        DebugOutput.setDebugLevel(0);
        pSystemFont = Font.getFont((int)0, (int)0, (int)8);
        pInstance = this;
    }

    public static MyApplication getInstance() {
        return pInstance;
    }

    public void update() {
        if (pActiveScreen == null) {
            pScrSplash = new ScreenSplash();
            pActiveScreen = pScrSplash;
        }
        if (pActiveScreen != null) {
            pActiveScreen.update(33L);
        }
    }

    public void onEventFired(Event event) {
        if (Pointers.isEventSender(event)) {
            Pointer pointer = (Pointer)event.getData();
            switch (pointer.iAction) {
                case 2: {
                    this.pointerPressed(pointer.iPositionX, pointer.iPositionY);
                    break;
                }
                case 3: {
                    this.pointerReleased(pointer.iPositionX, pointer.iPositionY);
                }
            }
        }
        if (Keys.isEventSender(event)) {
            Key pKey = (Key)event.getData();
            switch (pKey.iAction) {
                case 1: {
                    this.keyPressed(pKey);
                    break;
                }
                case 2: {
                    this.keyReleased(pKey);
                }
            }
        }
    }

    private void pointerPressed(int iX, int iY) {
        DebugOutput.traceIn(100, "MyApplication", "pointerPressed(" + iX + ", " + iY + ")");
        bTouchScreen = true;
        if (pActiveScreen != null) {
            pActiveScreen.pointerPressed(iX, iY);
        }
        DebugOutput.traceOut(100, "MyApplication", "pointerPressed()");
    }

    private void pointerReleased(int iX, int iY) {
        DebugOutput.traceIn(100, "MyApplication", "pointerReleased(" + iX + ", " + iY + ")");
        if (pActiveScreen != null) {
            pActiveScreen.pointerReleased(iX, iY);
        }
        DebugOutput.traceOut(100, "MyApplication", "pointerReleased()");
    }

    private void keyPressed(Key pKey) {
        if (pActiveScreen != null) {
            pActiveScreen.keyPressed(pKey);
        }
    }

    private void keyReleased(Key pKey) {
        if (pActiveScreen != null) {
            pActiveScreen.keyReleased(pKey);
        }
    }

    private void paintLoading(Graphics g) {
        int iScreenW = g.getWidth();
        int iScreenH = g.getHeight();
        int partsX = Resources.iScreenW / Resources.iBorderW - Resources.MINUS_MAIN_X_PARTS;
        int partsY = Resources.iScreenH / Resources.iBorderH - Resources.MINUS_MAIN_Y_PARTS;
        Resources.paintBackground(g);
        Resources.paintMenuBG(partsX, partsY, g);
        int iPosY = (Resources.iScreenH - Resources.iBorderH * (partsY - 1)) / 2;
        Resources.imgLogo.drawAtPoint(g, (Resources.iScreenW - Resources.iLogoW) / 2, iPosY);
        boolean buttonFrame = false;
        partsX = (partsX - 2) * Resources.iBorderW / Resources.iDemFGW;
        int x = (Resources.iScreenW - partsX * Resources.iDemFGW) / 2;
        int y = iPosY + Resources.iLogoH + Resources.iDemBGH;
        int offset = Resources.iBonsH + Resources.iBonsH / 2;
        int iconOffset = (offset - Resources.iBonsH) / 2;
        y += Resources.iDemBGH * 2;
        String[] Text = new String[]{Texts.getString(38), Texts.getString(35), Texts.getString(37), Texts.getString(36)};
        for (int i = 0; i < 5; ++i) {
            Resources.imgLineM.drawAtPoint(g, (Resources.iScreenW - Resources.iLineMW) / 2 + Resources.iChooseSideW / 4, y + i * offset);
            if (i == 4) continue;
            Resources.sprBons.setFrame(i);
            Resources.sprBons.setPosition((Resources.iScreenW - Resources.iLineMW) / 2 + Resources.iChooseSideW, y + i * offset + iconOffset + 1);
            Resources.sprBons.paint(g);
            Texts.drawTextAtPos(g, (Resources.iScreenW - Resources.iLineMW) / 2 + Resources.iChooseSideW * 2 + Resources.iIconsW, y + i * offset + iconOffset + 1, Text[i]);
        }
        String sText = Texts.getString(0);
        int iTextW = Texts.getTextWidth(sText);
        iPosY = (Resources.iScreenH - Resources.iBorderH * partsY) / 2 + partsY * Resources.iBorderH - Texts.getFontHeight() - Texts.getFontHeight() / 2;
        Texts.drawTextAtPos(g, (Resources.iScreenW - iTextW) / 2, iPosY, sText);
    }

    public void paintScreen(Screen pScreen) {
        Graphics g = pScreen.getGraphics();
        Resources.iScreenH = g.getHeight();
        if (bLoading) {
            this.paintLoading(g);
            return;
        }
        if (pActiveScreen != null) {
            pActiveScreen.paintScreen(g);
        }
    }

    public void onPause() {
        bPause = true;
        if (Profile.bMusic) {
            bMusicOn = true;
            Sounds.stopMusic();
        }
        if (pActiveScreen != null) {
            pActiveScreen.onPause();
        }
    }

    public void onStart() {
        bMusicOn = false;
    }

    public void onResume() {
        bPause = false;
        if (bMusicOn) {
            Profile.bMusic = true;
        }
        if (pActiveScreen != null) {
            pActiveScreen.onResume();
        }
    }

    public void onStop() {
        if (Profile.bMusic) {
            Profile.bMusic = false;
            bMusicOn = true;
            Sounds.stopMusic();
        }
        if (pActiveScreen != null) {
            pActiveScreen.onPause();
        }
    }

    static {
        pActiveScreen = null;
        pScrSplash = null;
        pScrMenu = null;
        pScrGame = null;
        bTouchScreen = false;
        bLoading = false;
        pSystemFont = null;
        bPause = false;
    }
}

