/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.oldschoolracing;

import simple.core.Application;
import simple.debug.DebugOutput;
import simple.input.Key;
import simple.input.Keys;
import simple.video.Graphics;
import sk.inlogic.oldschoolracing.CMenuItem;
import sk.inlogic.oldschoolracing.Cars;
import sk.inlogic.oldschoolracing.IMenuItemActivator;
import sk.inlogic.oldschoolracing.IMenuItemRenderer;
import sk.inlogic.oldschoolracing.IScreen;
import sk.inlogic.oldschoolracing.MenuSystem;
import sk.inlogic.oldschoolracing.MyApplication;
import sk.inlogic.oldschoolracing.Profile;
import sk.inlogic.oldschoolracing.Resources;
import sk.inlogic.oldschoolracing.ScreenGame;
import sk.inlogic.oldschoolracing.Sounds;
import sk.inlogic.oldschoolracing.Texts;

public class ScreenMenu
implements IScreen,
IMenuItemActivator,
IMenuItemRenderer {
    public static int instrOffset;
    public static int instrMaxOffs;
    final int MODE_VOID;
    final int MODE_LOADINGRES;
    final int MODE_MENU;
    final int MODE_OPTIONS;
    final int MODE_INSTRUCTIONS;
    final int MODE_TOPSCORE;
    final int MODE_ABOUT;
    final int MODE_RESET_QUESTION;
    final int MODE_REALLY_QUIT;
    final int MODE_MOVING_RIGHT;
    final int MODE_MOVING_LEFT;
    final int MODE_CHOOSE_CAR;
    final int MODE_CHOOSE_TRACK;
    final int MODE_MOVING_UP;
    final int MODE_MOVING_DOWN;
    final int MODE_STARTING_GAME;
    final int MODE_BONUS_LOCKED;
    public int iSelectorPos;
    public static int iSelectedEnvir;
    final int ENV_1;
    final int ENV_2;
    final int ENV_3;
    int MI_GETTHEGAME;
    int MI_PLAY;
    int MI_MOREGAMES;
    int MI_INSTRUCTIONS;
    int MI_TOPSCORE;
    int MI_OPTIONS;
    int MI_ABOUT;
    int MI_QUIT;
    final int MI_MUSIC;
    final int MI_VIBRATIONS;
    final int MI_RESET;
    int iSelectedMenuItem = 0;
    int iSelectedCar;
    int iMode;
    public boolean bMovingOption;
    MenuSystem pMenuSystem = null;
    MyApplication pMyApplication = null;
    int iInstructionPage;
    int iTotalInstructionsPages = 3;
    int iNavigationArrowLeftPosX;
    int iNavigationArrowLeftPosY;
    int iNavigationArrowLeftSize;
    int iNavigationArrowRightPosX;
    int iNavigationArrowRightPosY;
    int iNavigationArrowRightSize;
    int iNewImageXPos;
    int iNewImageYPos;
    public boolean bBackFromGame;
    String strExternalURL;
    public static boolean bFirstTime;

    public ScreenMenu() {
        this.MODE_VOID = 0;
        this.MODE_LOADINGRES = 1;
        this.MODE_MENU = 2;
        this.MODE_OPTIONS = 3;
        this.MODE_INSTRUCTIONS = 4;
        this.MODE_TOPSCORE = 5;
        this.MODE_ABOUT = 6;
        this.MODE_RESET_QUESTION = 7;
        this.MODE_REALLY_QUIT = 8;
        this.MODE_MOVING_RIGHT = 10;
        this.MODE_MOVING_LEFT = 11;
        this.MODE_CHOOSE_CAR = 12;
        this.MODE_CHOOSE_TRACK = 13;
        this.MODE_MOVING_UP = 14;
        this.MODE_MOVING_DOWN = 15;
        this.MODE_STARTING_GAME = 16;
        this.MODE_BONUS_LOCKED = 17;
        this.ENV_1 = 0;
        this.ENV_2 = 1;
        this.ENV_3 = 2;
        this.MI_MUSIC = 0;
        this.MI_VIBRATIONS = 1;
        this.MI_RESET = 2;
        DebugOutput.traceIn(0, "ScreenMenu", "ScreenMenu()");
        this.pMyApplication = MyApplication.getInstance();
        this.calculateResolutionVars();
        this.bBackFromGame = false;
        this.iMode = 1;
        this.bMovingOption = false;
        DebugOutput.traceOut(0, "ScreenMenu", "ScreenMenu()");
        Resources.imgBackground = null;
    }

    public void loadGame() {
        if (Profile.canLoad()) {
            Profile.load();
        } else {
            this.newGame();
        }
    }

    public void newGame() {
        boolean[] bools = new boolean[]{true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
        String[] strings = new String[]{"0:00", "0:00", "0:00", "0:00", "0:00", "0:00", "0:00", "0:00", "0:00", "0:00", "0:00", "0:00", "0:00", "0:00", "0:00", "0:00", "0:00", "0:00"};
        int[] secs = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        int[] stars = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        Resources.profile = new Profile(bools, strings, secs, stars);
    }

    void calculateResolutionVars() {
        DebugOutput.traceIn(0, "ScreenMenu", "calculateResolutionVars()");
        DebugOutput.traceOut(0, "ScreenMenu", "calculateResolutionVars()");
    }

    public void update(long tick) {
        int partsY = Resources.iScreenH / Resources.iBorderH - Resources.MINUS_CHOOSE_Y_PARTS;
        int partsX = Resources.iScreenW / Resources.iBorderW - Resources.MINUS_MAIN_X_PARTS;
        int iPosX = (Resources.iScreenW - Resources.iBorderW * partsX) / 2 + Resources.iBorderW * 2 + Resources.iCarImgsW + Resources.iChooseSideW * 2;
        int iPosY = (Resources.iScreenH - Resources.iBorderH * partsY) / 2 + Resources.iChooseSide2H + Resources.iBorderH + Resources.iBorderH / 2;
        switch (this.iMode) {
            case 1: {
                this.updateModeLoadingRes();
                break;
            }
            case 10: {
                this.iNewImageXPos -= Resources.iMenuIcsW / 6;
                int n = this.pMenuSystem.iMenuType;
                this.pMenuSystem.getClass();
                if (n == 2 && this.iNewImageXPos <= (Resources.iScreenW - Resources.iMenuIcsW) / 2) {
                    this.iMode = 2;
                }
                int n2 = this.pMenuSystem.iMenuType;
                this.pMenuSystem.getClass();
                if (n2 == 4 && this.iNewImageXPos <= iPosX - Resources.CHOOSE_MENU_OFFSET * 2) {
                    this.iMode = 12;
                }
                int n3 = this.pMenuSystem.iMenuType;
                this.pMenuSystem.getClass();
                if (n3 == 5 && this.iNewImageXPos <= (Resources.iScreenW - Resources.iCarNamesW) / 2) {
                    this.iMode = 13;
                }
                int n4 = this.pMenuSystem.iMenuType;
                this.pMenuSystem.getClass();
                if (n4 == 6 && this.iNewImageXPos <= (Resources.iScreenW - Resources.iCarNamesW) / 2) {
                    this.iMode = 5;
                }
                this.pMyApplication.repaintScreen();
                break;
            }
            case 11: {
                this.iNewImageXPos += Resources.iMenuIcsW / 6;
                int n = this.pMenuSystem.iMenuType;
                this.pMenuSystem.getClass();
                if (n == 2 && this.iNewImageXPos >= (Resources.iScreenW - Resources.iMenuIcsW) / 2) {
                    this.iMode = 2;
                }
                int n5 = this.pMenuSystem.iMenuType;
                this.pMenuSystem.getClass();
                if (n5 == 4 && this.iNewImageXPos >= iPosX - Resources.CHOOSE_MENU_OFFSET * 2) {
                    this.iMode = 12;
                }
                this.pMyApplication.repaintScreen();
                break;
            }
            case 15: {
                partsY = Resources.iScreenH / Resources.iBorderH - Resources.MINUS_CHOOSE_Y_PARTS;
                partsX = Resources.iScreenW / Resources.iBorderW - Resources.MINUS_MAIN_X_PARTS;
                iPosY = (Resources.iScreenH - Resources.iBorderH * partsY) / 2 + Resources.iChooseSide2H + Resources.iBorderH + Resources.iBorderH / 2;
                this.iNewImageYPos -= Resources.iMenuIcsW / 6;
                int n = this.pMenuSystem.iMenuType;
                this.pMenuSystem.getClass();
                if (n == 5 && this.iNewImageYPos <= iPosY) {
                    this.iMode = 13;
                }
                int n6 = this.pMenuSystem.iMenuType;
                this.pMenuSystem.getClass();
                if (n6 == 6 && this.iNewImageYPos <= iPosY) {
                    this.iMode = 5;
                }
                this.pMyApplication.repaintScreen();
                break;
            }
            case 14: {
                partsY = Resources.iScreenH / Resources.iBorderH - Resources.MINUS_CHOOSE_Y_PARTS;
                partsX = Resources.iScreenW / Resources.iBorderW - Resources.MINUS_MAIN_X_PARTS;
                iPosY = (Resources.iScreenH - Resources.iBorderH * partsY) / 2 + Resources.iChooseSide2H + Resources.iBorderH + Resources.iBorderH / 2;
                this.iNewImageYPos += Resources.iMenuIcsW / 6;
                int n = this.pMenuSystem.iMenuType;
                this.pMenuSystem.getClass();
                if (n == 5 && this.iNewImageYPos >= iPosY) {
                    this.iMode = 13;
                }
                int n7 = this.pMenuSystem.iMenuType;
                this.pMenuSystem.getClass();
                if (n7 == 6 && this.iNewImageYPos >= iPosY) {
                    this.iMode = 5;
                }
                this.pMyApplication.repaintScreen();
            }
        }
    }

    public void updateModeLoadingRes() {
        DebugOutput.traceIn(0, "ScreenMenu", "updateModeLoadingRes()");
        boolean bl = MyApplication.bLoading = !bFirstTime;
        if (MyApplication.bLoading) {
            Application.getSingleton().repaintScreen();
        }
        bFirstTime = false;
        Resources.loadMenuResources();
        this.pMenuSystem = MenuSystem.getInstance();
        this.pMenuSystem.setMenuItemActivator(this);
        this.pMenuSystem.setMenuItemRenderer(this);
        this.pMenuSystem.getClass();
        this.pMenuSystem.iMenuType = 2;
        this.prepareMainMenuItems();
        this.iMode = 2;
        MyApplication.bLoading = false;
        this.pMyApplication.repaintScreen();
        if (!Sounds.musicPlaying()) {
            Sounds.playMenuMusic();
        }
        DebugOutput.traceOut(0, "ScreenMenu", "updateModeLoadingRes()");
    }

    private void prepareMainMenuItems() {
        this.pMenuSystem.reset();
        this.pMenuSystem.getClass();
        this.pMenuSystem.iMenuType = 2;
        int partsY = Resources.iScreenH / Resources.iBorderH - Resources.MINUS_CHOOSE_Y_PARTS;
        int partsX = Resources.iScreenW / Resources.iBorderW - Resources.MINUS_MAIN_X_PARTS;
        int iPosY = (Resources.iScreenH - Resources.iBorderH * (partsY - 1)) / 2;
        int y = (partsY * Resources.iBorderH - Resources.iLogoH - Resources.iMenuIcsH) / 2 + iPosY / 2 + Resources.iLogoH;
        int iMenuItems = 0;
        int iXPos = Resources.iScreenW / 2;
        int iYPos = (Resources.iScreenH - Resources.iBorderH) / 2;
        this.pMenuSystem.addMenuItem(new CMenuItem(0, Texts.getString(41), iXPos, iYPos, Resources.iBigBtnW, Resources.iBigBtnH));
        this.MI_PLAY = iMenuItems++;
        iXPos = Resources.iScreenW / 2 - Resources.iBorderW * 2;
        iYPos = (Resources.iScreenH - Resources.iBorderH) / 2 - Resources.iMenuIcsH + Resources.iMenuIcsH / 5;
        this.pMenuSystem.addMenuItem(new CMenuItem(1, Texts.getString(12), iXPos, iYPos, Resources.iMenuIcsW, Resources.iMenuIcsH));
        this.MI_TOPSCORE = iMenuItems++;
        iXPos = Resources.iScreenW / 2 - Resources.iBorderW - Resources.iBorderW / 2 + Resources.iMenuIcsW;
        iYPos = (Resources.iScreenH - Resources.iBorderH) / 2 - Resources.iMenuIcsH - Resources.iBorderH;
        this.pMenuSystem.addMenuItem(new CMenuItem(2, Texts.getString(11), iXPos, iYPos, Resources.iMenuIcsW, Resources.iMenuIcsH));
        this.MI_INSTRUCTIONS = iMenuItems++;
        iXPos = iXPos + Resources.iBorderW * 2 + Resources.iBorderW / 2 + Resources.iBorderW / 4;
        iYPos = (Resources.iScreenH - Resources.iBorderH) / 2 - Resources.iMenuIcsH;
        this.pMenuSystem.addMenuItem(new CMenuItem(3, Texts.getString(13), iXPos, iYPos, Resources.iMenuIcsW, Resources.iMenuIcsH));
        this.MI_OPTIONS = iMenuItems++;
        iYPos = (Resources.iScreenH - Resources.iBorderH) / 2 + Resources.iBorderW / 2;
        this.pMenuSystem.addMenuItem(new CMenuItem(4, Texts.getString(43), iXPos += Resources.iBorderW, iYPos, Resources.iMenuIcsW, Resources.iMenuIcsH));
        this.MI_ABOUT = iMenuItems++;
    }

    public void prepareCarChooseMenuItems() {
        this.pMenuSystem.reset();
        this.pMenuSystem.getClass();
        this.pMenuSystem.iMenuType = 4;
        this.pMenuSystem.addMenuItem(new CMenuItem(0, "", 0, 0, 0, 0));
        this.pMenuSystem.addMenuItem(new CMenuItem(1, "", 0, 0, 0, 0));
        this.pMenuSystem.addMenuItem(new CMenuItem(2, "", 0, 0, 0, 0));
        this.pMenuSystem.addMenuItem(new CMenuItem(3, "", 0, 0, 0, 0));
        this.pMenuSystem.addMenuItem(new CMenuItem(4, "", 0, 0, 0, 0));
        this.pMenuSystem.iSelectedMenuItem = 2;
    }

    public void prepareTrackChooseMenuItems() {
        this.pMenuSystem.reset();
        this.pMenuSystem.getClass();
        this.pMenuSystem.iMenuType = 5;
        if (this.iMode == 5) {
            this.pMenuSystem.getClass();
            this.pMenuSystem.iMenuType = 6;
        }
        iSelectedEnvir = 0;
        int partsY = Resources.iScreenH / Resources.iBorderH - Resources.MINUS_CHOOSE_Y_PARTS;
        int partsX = Resources.iScreenW / Resources.iBorderW - Resources.MINUS_MAIN_X_PARTS;
        int x = (Resources.iScreenW - Resources.iBorderW * partsX) / 2 + Resources.iBorderW + Resources.iBorderW / 2 + Resources.iChooseSide2W + Resources.iBorderW + Resources.iBorderW / 2 - Resources.CHOOSE_MENU_OFFSET * 2;
        int y = (Resources.iScreenH - Resources.iBorderH * partsY) / 2 + Resources.iBorderH + Resources.iBorderH / 2 - Resources.TRACK_NAMES_OFFSET * 2;
        this.pMenuSystem.addMenuItem(new CMenuItem(0, Texts.getString(39) + " 1", x, y, Resources.iSelectW, Resources.iSelectH));
        y = y + Resources.iSelectH + Resources.TRACK_NAMES_OFFSET;
        this.pMenuSystem.addMenuItem(new CMenuItem(1, Texts.getString(39) + " 2", x, y, Resources.iSelectW, Resources.iSelectH));
        y = y + Resources.iSelectH + Resources.TRACK_NAMES_OFFSET;
        this.pMenuSystem.addMenuItem(new CMenuItem(2, Texts.getString(39) + " 3", x, y, Resources.iSelectW, Resources.iSelectH));
        y = y + Resources.iSelectH + Resources.TRACK_NAMES_OFFSET;
        this.pMenuSystem.addMenuItem(new CMenuItem(3, Texts.getString(39) + " 4", x, y, Resources.iSelectW, Resources.iSelectH));
        y = y + Resources.iSelectH + Resources.TRACK_NAMES_OFFSET;
        this.pMenuSystem.addMenuItem(new CMenuItem(4, Texts.getString(39) + " 5", x, y, Resources.iSelectW, Resources.iSelectH));
        y = y + Resources.iSelectH + Resources.TRACK_NAMES_OFFSET;
        this.pMenuSystem.addMenuItem(new CMenuItem(5, Texts.getString(44), x, y, Resources.iSelectW, Resources.iSelectH));
    }

    private void prepareOptionsMenuItems() {
        this.pMenuSystem.reset();
        this.pMenuSystem.getClass();
        this.pMenuSystem.iMenuType = 7;
        int iGap = Resources.iSelectH / 4;
        int iWidth = Resources.iSelectW;
        int iHeight = Resources.iSelectH;
        int iPosX = (Resources.iScreenW - Resources.iSelectW) / 2;
        int iPosY = (Resources.iScreenH - 4 * (iHeight + iGap)) / 2;
        if (Profile.canLoad()) {
            iPosY = (Resources.iScreenH - 3 * (iHeight + iGap) - iGap * 4) / 2;
        }
        this.pMenuSystem.addMenuItem(new CMenuItem(0, Texts.getString(16), iPosX, iPosY, iWidth, iHeight));
        this.pMenuSystem.addMenuItem(new CMenuItem(1, Texts.getString(17), iPosX, iPosY += iHeight + iGap, iWidth, iHeight));
        iPosY += iHeight + 2 * iGap;
        if (Profile.canLoad()) {
            this.pMenuSystem.addMenuItem(new CMenuItem(2, Texts.getString(45), iPosX, iPosY, iWidth, iHeight));
        }
        iPosY += iHeight + iGap;
    }

    private void prepareInstructions() {
        Resources.prepareMultiLineText(this.getInstructionPage(this.iInstructionPage));
        instrOffset = 0;
        int partsY = Resources.iScreenH / Resources.iBorderH - Resources.MINUS_MAIN_Y_PARTS;
        int iPosY = (Resources.iScreenH - Resources.iBorderH * partsY) / 2;
        int linePos = iPosY + (partsY - 1) * Resources.iBorderH - Resources.BG_LINE_OFFSET;
        int iY = iPosY + Resources.iIconsW / 2 + Resources.iIconsW / 6 + Resources.iIconsW;
        int iH = linePos - Resources.iIconsW - Resources.iIconsW / 2 - Resources.iIconsW / 6 - iY;
        int iLineItemH = Texts.getFontHeight();
        int iSize = Resources.vecMultipleLines.size();
        int iHeight = iLineItemH * iSize;
        int visibleLines = iH / iLineItemH;
        System.out.println("isize = " + iSize + ", visiblines = " + visibleLines + ", ilineitemH = " + iLineItemH);
        instrMaxOffs = (iSize - visibleLines) * iLineItemH;
    }

    String getInstructionPage(int iPage) {
        if (iPage == 0) {
            return Texts.getString(24);
        }
        if (iPage == 1) {
            return Texts.getString(51);
        }
        return Texts.getString(54);
    }

    public void paintScreen(Graphics g) {
        switch (this.iMode) {
            case 16: {
                Resources.paintLoading(g, 1, false);
                break;
            }
            case 2: 
            case 12: 
            case 13: {
                this.paintModeMenu(g);
                break;
            }
            case 3: {
                this.paintModeOptions(g);
                break;
            }
            case 4: {
                this.paintModeInstructions(g);
                break;
            }
            case 5: {
                this.paintModeTopScore(g);
                break;
            }
            case 10: {
                int n = this.pMenuSystem.iMenuType;
                this.pMenuSystem.getClass();
                if (n == 2) {
                    this.paintMovingRightMain(g);
                }
                int n2 = this.pMenuSystem.iMenuType;
                this.pMenuSystem.getClass();
                if (n2 == 4) {
                    this.paintMovingRightChoose(g);
                }
                int n3 = this.pMenuSystem.iMenuType;
                this.pMenuSystem.getClass();
                if (n3 != 5) {
                    int n4 = this.pMenuSystem.iMenuType;
                    this.pMenuSystem.getClass();
                    if (n4 != 6) break;
                }
                this.paintMovingRightTrack(g);
                break;
            }
            case 11: {
                int n = this.pMenuSystem.iMenuType;
                this.pMenuSystem.getClass();
                if (n == 2) {
                    this.paintMovingLeftMain(g);
                }
                int n5 = this.pMenuSystem.iMenuType;
                this.pMenuSystem.getClass();
                if (n5 == 4) {
                    this.paintMovingLeftChoose(g);
                }
                int n6 = this.pMenuSystem.iMenuType;
                this.pMenuSystem.getClass();
                if (n6 != 5) {
                    int n7 = this.pMenuSystem.iMenuType;
                    this.pMenuSystem.getClass();
                    if (n7 != 6) break;
                }
                this.paintMovingLeftTrack(g);
                break;
            }
            case 14: {
                this.paintMovingUp(g);
                break;
            }
            case 15: {
                this.paintMovingDown(g);
                break;
            }
            case 6: {
                this.paintModeAbout(g);
                break;
            }
            case 7: {
                this.paintRestartQuestion(g);
                break;
            }
            case 17: {
                this.paintBonusLocked(g);
                break;
            }
            case 8: {
                this.paintReallyQuit(g);
            }
        }
    }

    void paintBonusLocked(Graphics g) {
        int partsX = Resources.iScreenW / Resources.iBorderW - 2;
        int partsY = Resources.iScreenH / Resources.iBorderH - 6;
        Resources.paintBackground(g);
        Resources.paintMenuBG(partsX, partsY, g);
        int iLineItemH = Texts.getFontHeight();
        int iSize = Resources.vecMultipleLines.size();
        int iHeight = iLineItemH * (iSize + 2);
        int iPosX = Resources.iScreenW / 10;
        int iPosY = (Resources.iScreenH - (partsY - 2) * Resources.iBorderH) / 2;
        iPosY += (iHeight - iSize * iLineItemH) / 2;
        for (int i = 0; i < iSize; ++i) {
            String strText = (String)Resources.vecMultipleLines.elementAt(i);
            int iItemW = Texts.getTextWidth(strText);
            iPosX = (Resources.iScreenW - iItemW) / 2;
            Texts.drawTextAtPos(g, iPosX, iPosY - Texts.getFontHeight() / 2, strText);
            iPosY += iLineItemH;
        }
        Resources.paintLeftButton(g, partsY);
    }

    void paintReallyQuit(Graphics g) {
        int partsX = Resources.iScreenW / Resources.iBorderW - Resources.MINUS_MAIN_X_PARTS;
        int partsY = Resources.iScreenH / Resources.iBorderH - 6;
        Resources.paintBackground(g);
        Resources.paintMenuBG(partsX, partsY, g);
        int iLineItemH = Texts.getFontHeight();
        int iSize = Resources.vecMultipleLines.size();
        int iHeight = iLineItemH * (iSize + 2);
        int iPosX = Resources.iScreenW / 10;
        int iPosY = (Resources.iScreenH - (partsY - 2) * Resources.iBorderH) / 2;
        iPosY += (iHeight - iSize * iLineItemH) / 2;
        for (int i = 0; i < iSize; ++i) {
            String strText = (String)Resources.vecMultipleLines.elementAt(i);
            int iItemW = Texts.getTextWidth(strText);
            iPosX = (Resources.iScreenW - iItemW) / 2;
            Texts.drawTextAtPos(g, iPosX, iPosY - Texts.getFontHeight() / 2, strText);
            iPosY += iLineItemH;
        }
        Resources.paintLeftButton(g, partsY);
        Resources.paintRightButton(g, partsY);
    }

    void paintRestartQuestion(Graphics g) {
        int partsX = Resources.iScreenW / Resources.iBorderW - Resources.MINUS_MAIN_X_PARTS;
        int partsY = Resources.iScreenH / Resources.iBorderH - 6;
        Resources.paintBackground(g);
        Resources.paintMenuBG(partsX, partsY, g);
        int iLineItemH = Texts.getFontHeight();
        int iSize = Resources.vecMultipleLines.size();
        int iHeight = iLineItemH * (iSize + 2);
        int iPosX = Resources.iScreenW / 10;
        int iPosY = (Resources.iScreenH - (partsY - 2) * Resources.iBorderH) / 2;
        iPosY += (iHeight - iSize * iLineItemH) / 2;
        for (int i = 0; i < iSize; ++i) {
            String strText = (String)Resources.vecMultipleLines.elementAt(i);
            int iItemW = Texts.getTextWidth(strText);
            iPosX = (Resources.iScreenW - iItemW) / 2;
            Texts.drawTextAtPos(g, iPosX, iPosY - Texts.getFontHeight() / 2, strText);
            iPosY += iLineItemH;
        }
        Resources.paintLeftButton(g, partsY);
        Resources.paintRightButton(g, partsY);
    }

    void paintMovingLeftTrack(Graphics g) {
        int oldIcon = iSelectedEnvir + 1;
        if (iSelectedEnvir == 2) {
            oldIcon = 0;
        }
        int partsY = Resources.iScreenH / Resources.iBorderH - 1;
        int y = (partsY * Resources.iBorderH - Resources.iLogoH - Resources.iMenuIcsH) / 2;
        if (this.pMenuSystem.iSelectedMenuItem == 2) {
            oldIcon = 0;
        }
        this.pMenuSystem.paintChooseTrackMenu(g);
        g.setClipRegion((Resources.iScreenW - Resources.iCarNamesW) / 2, y, Resources.iCarNamesW, Resources.iCarNamesH);
        Resources.sprEnvs.setFrame(iSelectedEnvir);
        Resources.sprEnvs.setPosition(this.iNewImageXPos, y);
        Resources.sprEnvs.paint(g);
        Resources.sprEnvs.setFrame(oldIcon);
        Resources.sprEnvs.setPosition(this.iNewImageXPos + Resources.iCarNamesW, y);
        Resources.sprEnvs.paint(g);
    }

    void paintMovingRightTrack(Graphics g) {
        int y;
        int newIcon;
        block5: {
            block4: {
                newIcon = iSelectedEnvir - 1;
                int partsY = Resources.iScreenH / Resources.iBorderH - 1;
                y = (partsY * Resources.iBorderH - Resources.iLogoH - Resources.iMenuIcsH) / 2;
                int n = this.pMenuSystem.iMenuType;
                this.pMenuSystem.getClass();
                if (n == 5) break block4;
                int n2 = this.pMenuSystem.iMenuType;
                this.pMenuSystem.getClass();
                if (n2 != 6) break block5;
            }
            if (iSelectedEnvir == 0) {
                newIcon = 2;
            }
        }
        this.pMenuSystem.paintChooseTrackMenu(g);
        g.setClipRegion((Resources.iScreenW - Resources.iCarNamesW) / 2, y, Resources.iCarNamesW, Resources.iCarNamesH);
        Resources.sprEnvs.setFrame(iSelectedEnvir);
        Resources.sprEnvs.setPosition(this.iNewImageXPos, y);
        Resources.sprEnvs.paint(g);
        Resources.sprEnvs.setFrame(newIcon);
        Resources.sprEnvs.setPosition(this.iNewImageXPos - Resources.iCarNamesW, y);
        Resources.sprEnvs.paint(g);
    }

    void paintMovingUp(Graphics g) {
        int oldIcon = iSelectedEnvir + 1;
        if (iSelectedEnvir == 2) {
            oldIcon = 0;
        }
        int partsX = Resources.iScreenW / Resources.iBorderW - Resources.MINUS_MAIN_X_PARTS;
        int partsY = Resources.iScreenH / Resources.iBorderH - Resources.MINUS_CHOOSE_Y_PARTS;
        int iPosX = (Resources.iScreenW - Resources.iBorderW * partsX) / 2 + Resources.iBorderW + Resources.iBorderW / 2 - Resources.CHOOSE_MENU_OFFSET;
        int iPosY = (Resources.iScreenH - Resources.iBorderH * partsY) / 2 + Resources.iChooseSide2H + Resources.iBorderH + Resources.iBorderH / 2;
        if (this.pMenuSystem.iSelectedMenuItem == 2) {
            oldIcon = 0;
        }
        this.pMenuSystem.paintChooseTrackMenu(g);
        g.setClipRegion(iPosX, iPosY, Resources.iEnvsW, Resources.iEnvsH);
        Resources.sprEnvs.setFrame(iSelectedEnvir);
        Resources.sprEnvs.setPosition(iPosX, this.iNewImageYPos);
        Resources.sprEnvs.paint(g);
        Resources.sprEnvs.setFrame(oldIcon);
        Resources.sprEnvs.setPosition(iPosX, this.iNewImageYPos + Resources.iEnvsH);
        Resources.sprEnvs.paint(g);
        Resources.paintRightButton(g, partsY);
    }

    void paintMovingDown(Graphics g) {
        int newIcon = iSelectedEnvir - 1;
        if (iSelectedEnvir == 0) {
            newIcon = 2;
        }
        int partsX = Resources.iScreenW / Resources.iBorderW - Resources.MINUS_MAIN_X_PARTS;
        int partsY = Resources.iScreenH / Resources.iBorderH - Resources.MINUS_CHOOSE_Y_PARTS;
        int iPosX = (Resources.iScreenW - Resources.iBorderW * partsX) / 2 + Resources.iBorderW + Resources.iBorderW / 2 - Resources.CHOOSE_MENU_OFFSET;
        int iPosY = (Resources.iScreenH - Resources.iBorderH * partsY) / 2 + Resources.iChooseSide2H + Resources.iBorderH + Resources.iBorderH / 2;
        this.pMenuSystem.paintChooseTrackMenu(g);
        g.setClipRegion(iPosX, iPosY, Resources.iEnvsW, Resources.iEnvsH);
        Resources.sprEnvs.setFrame(iSelectedEnvir);
        Resources.sprEnvs.setPosition(iPosX, this.iNewImageYPos);
        Resources.sprEnvs.paint(g);
        Resources.sprEnvs.setFrame(newIcon);
        Resources.sprEnvs.setPosition(iPosX, this.iNewImageYPos - Resources.iEnvsH);
        Resources.sprEnvs.paint(g);
        Resources.paintRightButton(g, partsY);
    }

    void paintMovingLeftChoose(Graphics g) {
        int oldIcon = this.pMenuSystem.iSelectedMenuItem + 1;
        this.pMenuSystem.paintChooseMenu(g);
        int partsY = Resources.iScreenH / Resources.iBorderH - Resources.MINUS_CHOOSE_Y_PARTS;
        int partsX = Resources.iScreenW / Resources.iBorderW - Resources.MINUS_MAIN_X_PARTS;
        int y = (Resources.iScreenH - Resources.iBorderH * partsY) / 2 + Resources.iBorderH + Resources.iBorderH / 2;
        if (this.pMenuSystem.iSelectedMenuItem == 4) {
            oldIcon = 0;
        }
        this.pMenuSystem.paintChooseMenu(g);
        int iPosX = (Resources.iScreenW - Resources.iBorderW * partsX) / 2 + Resources.iBorderW * 2 + Resources.iCarImgsW + Resources.iChooseSideW * 2 - Resources.CHOOSE_MENU_OFFSET * 2;
        g.setClipRegion(iPosX, y, Resources.iCarNamesW, Resources.iCarNamesH);
        Resources.sprCarNames.setFrame(this.pMenuSystem.iSelectedMenuItem);
        Resources.sprCarNames.setPosition(this.iNewImageXPos, y);
        Resources.sprCarNames.paint(g);
        Resources.sprCarNames.setFrame(oldIcon);
        Resources.sprCarNames.setPosition(this.iNewImageXPos + Resources.iCarNamesW, y);
        Resources.sprCarNames.paint(g);
        g.setClipRegion(0, 0, Resources.iScreenW, Resources.iScreenH);
    }

    void paintMovingRightChoose(Graphics g) {
        int newIcon = this.pMenuSystem.iSelectedMenuItem - 1;
        this.pMenuSystem.paintChooseMenu(g);
        int partsY = Resources.iScreenH / Resources.iBorderH - Resources.MINUS_CHOOSE_Y_PARTS;
        int partsX = Resources.iScreenW / Resources.iBorderW - Resources.MINUS_MAIN_X_PARTS;
        int y = (Resources.iScreenH - Resources.iBorderH * partsY) / 2 + Resources.iBorderH + Resources.iBorderH / 2;
        if (this.pMenuSystem.iSelectedMenuItem == 0) {
            newIcon = 4;
        }
        this.pMenuSystem.paintChooseMenu(g);
        int iPosX = (Resources.iScreenW - Resources.iBorderW * partsX) / 2 + Resources.iBorderW * 2 + Resources.iCarImgsW + Resources.iChooseSideW * 2 - Resources.CHOOSE_MENU_OFFSET * 2;
        g.setClipRegion(iPosX, y, Resources.iCarNamesW, Resources.iCarNamesH);
        Resources.sprCarNames.setFrame(this.pMenuSystem.iSelectedMenuItem);
        Resources.sprCarNames.setPosition(this.iNewImageXPos, y);
        Resources.sprCarNames.paint(g);
        Resources.sprCarNames.setFrame(newIcon);
        Resources.sprCarNames.setPosition(this.iNewImageXPos - Resources.iCarNamesW, y);
        Resources.sprCarNames.paint(g);
        g.setClipRegion(0, 0, Resources.iScreenW, Resources.iScreenH);
    }

    void paintMovingLeftMain(Graphics g) {
        int oldIcon = this.pMenuSystem.iSelectedMenuItem + 1;
        if (this.pMenuSystem.iSelectedMenuItem == 5) {
            oldIcon = 0;
        }
        int partsY = Resources.iScreenH / Resources.iBorderH - Resources.MINUS_CHOOSE_Y_PARTS;
        int partsX = Resources.iScreenW / Resources.iBorderW - Resources.MINUS_MAIN_X_PARTS;
        int iPosY = (Resources.iScreenH - Resources.iBorderH * (partsY - 1)) / 2;
        int y = (Resources.iScreenH - Resources.iBorderH * partsY) / 2 + Resources.iBorderH + Resources.iBorderH / 2;
        int iPosX = (Resources.iScreenW - Resources.iBorderW * partsX) / 2 + Resources.iBorderW * 2 + Resources.iCarImgsW + Resources.iChooseSideW * 2;
        g.setClipRegion(iPosX, y, Resources.iCarNamesW, Resources.iCarNamesH);
        g.fillRect((Resources.iScreenW - Resources.iMenuIcsW) / 2, y, Resources.iMenuIcsW, Resources.iMenuIcsH);
        Resources.sprMenuIcs.setFrame(this.pMenuSystem.iSelectedMenuItem + 1);
        Resources.sprMenuIcs.setPosition(this.iNewImageXPos, y);
        Resources.sprMenuIcs.paint(g);
        Resources.sprMenuIcs.setFrame(oldIcon + 1);
        Resources.sprMenuIcs.setPosition(this.iNewImageXPos + Resources.iMenuIcsW, y);
        Resources.sprMenuIcs.paint(g);
        Resources.paintLeftButton(g, partsY);
        Resources.paintRightButton(g, partsY);
        g.setClipRegion(0, 0, Resources.iScreenW, Resources.iScreenH);
    }

    void paintMovingRightMain(Graphics g) {
        int newIcon = this.pMenuSystem.iSelectedMenuItem - 1;
        if (this.pMenuSystem.iSelectedMenuItem == 0) {
            newIcon = 5;
        }
        int partsY = Resources.iScreenH / Resources.iBorderH - Resources.MINUS_CHOOSE_Y_PARTS;
        int partsX = Resources.iScreenW / Resources.iBorderW - Resources.MINUS_MAIN_X_PARTS;
        int iPosY = (Resources.iScreenH - Resources.iBorderH * (partsY - 1)) / 2;
        int y = (partsY * Resources.iBorderH - Resources.iLogoH - Resources.iMenuIcsH) / 2 + iPosY / 2 + Resources.iLogoH;
        g.setClipRegion((Resources.iScreenW - Resources.iMenuIcsW) / 2, y, Resources.iMenuIcsW, Resources.iMenuIcsH);
        g.fillRect((Resources.iScreenW - Resources.iMenuIcsW) / 2, y, Resources.iMenuIcsW, Resources.iMenuIcsH);
        Resources.sprMenuIcs.setFrame(this.pMenuSystem.iSelectedMenuItem + 1);
        Resources.sprMenuIcs.setPosition(this.iNewImageXPos, y + Resources.MENU_RING_OFFSET);
        Resources.sprMenuIcs.paint(g);
        Resources.sprMenuIcs.setFrame(newIcon + 1);
        Resources.sprMenuIcs.setPosition(this.iNewImageXPos - Resources.iMenuIcsW, y + Resources.MENU_RING_OFFSET);
        Resources.sprMenuIcs.paint(g);
        Resources.paintLeftButton(g, partsY);
        Resources.paintRightButton(g, partsY);
        g.setClipRegion(0, 0, Resources.iScreenW, Resources.iScreenH);
    }

    void paintBackground(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, Resources.iScreenW, Resources.iScreenH);
    }

    private void paintModeMenu(Graphics g) {
        this.paintBackground(g);
        this.pMenuSystem.paintMenu(g);
    }

    void paintModeOptions(Graphics g) {
        this.paintBackground(g);
        this.pMenuSystem.paintMenu(g);
    }

    void paintModeTopScore(Graphics g) {
        this.paintBackground(g);
        this.pMenuSystem.paintMenu(g);
    }

    void paintModeAbout(Graphics g) {
        int partsX = Resources.iScreenW / Resources.iBorderW - Resources.MINUS_MAIN_X_PARTS;
        int partsY = Resources.iScreenH / Resources.iBorderH - Resources.MINUS_ABOUT_PARTS_Y;
        this.paintBackground(g);
        Resources.paintMenuBG(partsX, partsY, g);
        Resources.imgBackground.drawAtPoint(g, (Resources.iScreenW - Resources.imgBackground.getWidth()) / 2, (Resources.iScreenH - Resources.imgBackground.getHeight()) / 2);
        Resources.paintRightButton(g, partsY);
        String name = MyApplication.getInstance().getAppProperty("MIDlet-Name").toUpperCase();
        String version = (Texts.getString(46) + MyApplication.getInstance().getAppProperty("MIDlet-Version")).toUpperCase();
        int iPosY = (Resources.iScreenH - Resources.imgBackground.getHeight()) / 2;
        Texts.drawTextAtPos(g, (Resources.iScreenW - Texts.getTextWidth(name)) / 2, iPosY - Resources.iBorderH, name);
        Texts.drawTextAtPos(g, (Resources.iScreenW - Texts.getTextWidth(version)) / 2, iPosY + Resources.imgBackground.getHeight() + Resources.iBorderH - Texts.getFontHeight(), version);
    }

    void paintModeInstructions(Graphics g) {
        int partsX = Resources.iScreenW / Resources.iBorderW - Resources.MINUS_MAIN_X_PARTS;
        int partsY = Resources.iScreenH / Resources.iBorderH - Resources.MINUS_MAIN_Y_PARTS;
        g.setColor(0);
        g.fillRect(0, 0, Resources.iScreenW, Resources.iScreenH);
        Resources.paintMenuBG(partsX, partsY, g);
        int iPosY = (Resources.iScreenH - Resources.iBorderH * partsY) / 2;
        int iPosX = (Resources.iScreenW - Resources.iBorderW * partsX) / 2;
        Resources.sprIcons.setFrame(4);
        Resources.sprIcons.setPosition(iPosX + Resources.iIconsW / 2 + Resources.iIconsW / 6, (Resources.iScreenH - Resources.iIconsH) / 2);
        Resources.sprIcons.paint(g);
        Resources.sprIcons.setFrame(4);
        Resources.sprIcons.setRotation(3);
        Resources.sprIcons.setPosition(Resources.iScreenW - iPosX - Resources.iIconsW - Resources.iIconsW / 2 - Resources.iIconsW / 6, (Resources.iScreenH - Resources.iIconsH) / 2);
        Resources.sprIcons.paintRotated(g);
        int linePos = iPosY + (partsY - 1) * Resources.iBorderH - Resources.BG_LINE_OFFSET;
        int iX = iPosX + Resources.iIconsW / 2 + Resources.iIconsW / 6 + Resources.iIconsW;
        int iY = iPosY + Resources.iIconsW / 2 + Resources.iIconsW / 6 + Resources.iIconsW;
        int iW = Resources.iScreenW - iPosX - Resources.iIconsW - Resources.iIconsW / 2 - Resources.iIconsW / 6 - iX;
        int iH = linePos - Resources.iIconsW - Resources.iIconsW / 2 - Resources.iIconsW / 6 - iY;
        int iLineItemH = Texts.getFontHeight();
        int iSize = Resources.vecMultipleLines.size();
        int iHeight = iLineItemH * iSize;
        if (iHeight > iH) {
            Resources.sprIcons.setFrame(4);
            Resources.sprIcons.setRotation(2);
            Resources.sprIcons.setPosition((Resources.iScreenW - Resources.iIconsW) / 2, iPosY + Resources.iIconsW / 2 + Resources.iIconsW / 6);
            Resources.sprIcons.paintRotated(g);
            Resources.sprIcons.setFrame(4);
            Resources.sprIcons.setRotation(4);
            Resources.sprIcons.setPosition((Resources.iScreenW - Resources.iIconsW) / 2, linePos - Resources.iIconsW - Resources.iIconsW / 2 - Resources.iIconsW / 6);
            Resources.sprIcons.paintRotated(g);
        }
        Resources.sprIcons.setRotation(1);
        g.setClipRegion(iX, iY, iW, iH);
        iPosX = iX + Resources.iIconsW / 2;
        iPosY = iY + Resources.iIconsW / 2;
        for (int i = 0; i < iSize; ++i) {
            String strText = (String)Resources.vecMultipleLines.elementAt(i);
            int iItemW = Texts.getTextWidth(strText);
            iPosX = (Resources.iScreenW - iItemW) / 2;
            Texts.drawTextAtPos(g, iPosX, iPosY - Texts.getFontHeight() / 2 - instrOffset, strText);
            iPosY += iLineItemH;
        }
        g.setClipRegion(0, 0, Resources.iScreenW, Resources.iScreenH);
        Resources.paintRightButton(g, partsY);
    }

    public void renderMenuItem(Graphics g, CMenuItem pMenuItem, boolean bSelected) {
        int partsX = Resources.iScreenW / Resources.iBorderW - Resources.MINUS_MAIN_X_PARTS;
        int partsY = Resources.iScreenH / Resources.iBorderH - Resources.MINUS_CHOOSE_Y_PARTS;
        int iPosY = (Resources.iScreenH - Resources.iBorderH * (partsY - 1)) / 2;
        int iPosX = (Resources.iScreenW - Resources.iBorderW * (partsX - 1)) / 2;
        int y = 0;
        int offset = 0;
        int iconOffset = 0;
        int iTextW = 0;
        switch (this.iMode) {
            case 2: {
                partsY = Resources.iScreenH / Resources.iBorderH - Resources.MINUS_CHOOSE_Y_PARTS;
                iPosY = (Resources.iScreenH - Resources.iBorderH * (partsY - 1)) / 2;
                y = (partsY * Resources.iBorderH - Resources.iLogoH - Resources.iMenuIcsH) / 2 + iPosY / 2 + Resources.iLogoH;
                if (pMenuItem.iID == 0) {
                    Resources.imgBigBtn.drawAtPoint(g, pMenuItem.iPosX, pMenuItem.iPosY);
                } else {
                    Resources.sprMenuIcs.setFrame(pMenuItem.iID - 1);
                    Resources.sprMenuIcs.setPosition(pMenuItem.iPosX, pMenuItem.iPosY);
                    Resources.sprMenuIcs.paint(g);
                }
                iTextW = Texts.getTextWidth(pMenuItem.getCaption());
                iPosY = (Resources.iScreenH - Resources.iBorderH * partsY) / 2 + partsY * Resources.iBorderH - Texts.getFontHeight() - Texts.getFontHeight() / 2;
                break;
            }
            case 12: {
                if (!bSelected) {
                    return;
                }
                partsX = Resources.iScreenW / Resources.iBorderW - Resources.MINUS_MAIN_X_PARTS;
                partsY = Resources.iScreenH / Resources.iBorderH - Resources.MINUS_CHOOSE_Y_PARTS;
                iPosX = (Resources.iScreenW - Resources.iBorderW * partsX) / 2;
                iPosY = (Resources.iScreenH - Resources.iBorderH * partsY) / 2;
                Resources.sprCarImgs.setFrame(pMenuItem.iID);
                Resources.sprCarImgs.setPosition(iPosX + Resources.iBorderW + Resources.iBorderW / 2 - Resources.CHOOSE_MENU_OFFSET, iPosY + Resources.iBorderH + Resources.iBorderH / 2);
                Resources.sprCarImgs.paint(g);
                iPosX = (Resources.iScreenW - Resources.iBorderW * partsX) / 2 + Resources.iBorderW * 2 + Resources.iCarImgsW + Resources.iChooseSideW * 2 - Resources.CHOOSE_MENU_OFFSET * 2;
                Resources.sprCarNames.setFrame(pMenuItem.iID);
                Resources.sprCarNames.setPosition(iPosX, iPosY + Resources.iBorderH + Resources.iBorderH / 2);
                Resources.sprCarNames.paint(g);
                y = iPosY + Resources.iBorderH + Resources.iBorderH / 2;
                y += Resources.iCarNamesH + Resources.iIconsH / 2;
                offset = Resources.iBonsH + Resources.iBonsH / 2;
                iconOffset = (offset - Resources.iIconsH) / 2;
                iPosX = (Resources.iScreenW - Resources.iBorderW * partsX) / 2 + Resources.iBorderW * 2 + Resources.iCarImgsW - Resources.CHOOSE_MENU_OFFSET * 2;
                int xDots = iPosX + Resources.iCarNamesW + Resources.iChooseSideW * 2 - 3 * (Resources.iIconsW + Resources.DOTS_OFFSET);
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 4; ++j) {
                        if (i == 0) {
                            if (Cars.cartypes[pMenuItem.iID].dotsContr > j) {
                                Resources.sprIcons.setFrame(12);
                            } else {
                                Resources.sprIcons.setFrame(13);
                            }
                        } else if (i == 1) {
                            if (Cars.cartypes[pMenuItem.iID].dotsAcc > j) {
                                Resources.sprIcons.setFrame(12);
                            } else {
                                Resources.sprIcons.setFrame(13);
                            }
                        } else if (i == 2) {
                            if (Cars.cartypes[pMenuItem.iID].dotsSpeed > j) {
                                Resources.sprIcons.setFrame(12);
                            } else {
                                Resources.sprIcons.setFrame(13);
                            }
                        }
                        Resources.sprIcons.setPosition(xDots + j * (Resources.iIconsW + Resources.DOTS_OFFSET), y + i * offset + iconOffset + 1);
                        Resources.sprIcons.paint(g);
                    }
                }
                break;
            }
            case 5: 
            case 13: {
                iPosY = (Resources.iScreenH - Resources.iBorderH * (partsY - 1)) / 2;
                partsX = Resources.iScreenW / Resources.iBorderW - Resources.MINUS_MAIN_X_PARTS;
                partsY = Resources.iScreenH / Resources.iBorderH - Resources.MINUS_CHOOSE_Y_PARTS;
                iPosX = (Resources.iScreenW - Resources.iBorderW * partsX) / 2 - Resources.CHOOSE_MENU_OFFSET;
                iPosY = (Resources.iScreenH - Resources.iBorderH * partsY) / 2;
                Resources.sprEnvs.setFrame(iSelectedEnvir);
                Resources.sprEnvs.setPosition(iPosX + Resources.iBorderW + Resources.iBorderW / 2, iPosY + Resources.iChooseSide2H + Resources.iBorderH + Resources.iBorderH / 2);
                Resources.sprEnvs.paint(g);
                iTextW = Texts.getTextWidth(pMenuItem.getCaption());
                int iDspX = (pMenuItem.getWidth() - iTextW) / 2;
                Resources.imgSelect.drawAtPoint(g, pMenuItem.getLeft(), pMenuItem.getTop());
                int iDspY = (pMenuItem.getHeight() - Texts.getFontHeight()) / 2;
                Texts.drawTextAtPos(g, pMenuItem.getLeft() + 5, pMenuItem.getTop() + iDspY, pMenuItem.getCaption());
                if (this.iMode == 13) {
                    iDspY = (pMenuItem.getHeight() - Resources.iIconsH) / 2;
                    for (int j = 0; j < 3; ++j) {
                        if (Profile.envs[ScreenMenu.iSelectedEnvir].tracks[pMenuItem.iID].iMedals > j) {
                            Resources.sprIcons.setFrame(14);
                        } else {
                            Resources.sprIcons.setFrame(15);
                        }
                        if (!Profile.envs[ScreenMenu.iSelectedEnvir].tracks[pMenuItem.iID].bUnlocked) {
                            Resources.sprIcons.setFrame(8);
                            j = 2;
                        }
                        Resources.sprIcons.setPosition(pMenuItem.getLeft() + Resources.iSelectW - Resources.iBorderW - 3 * (Resources.iIconsW + Resources.DOTS_OFFSET) + j * (Resources.iIconsW + Resources.DOTS_OFFSET), pMenuItem.getTop() + iDspY);
                        Resources.sprIcons.setPosition(pMenuItem.getLeft() + Resources.iSelectW - 3 - 3 * (Resources.iIconsW + 1) + j * (Resources.iIconsW + 1), pMenuItem.getTop() + iDspY);
                        Resources.sprIcons.paint(g);
                    }
                }
                if (this.iMode != 5) break;
                iDspY = (pMenuItem.getHeight() - Resources.iIconsH) / 2;
                if (!Profile.envs[ScreenMenu.iSelectedEnvir].tracks[pMenuItem.iID].bUnlocked) {
                    Resources.sprIcons.setFrame(8);
                    Resources.sprIcons.setPosition(pMenuItem.getLeft() + pMenuItem.iWidth - Resources.iIconsW * 2, pMenuItem.getTop() + iDspY);
                    Resources.sprIcons.paint(g);
                    break;
                }
                int timeX = pMenuItem.getLeft() + pMenuItem.iWidth - Resources.iIconsW - Texts.getTextWidth(Profile.envs[ScreenMenu.iSelectedEnvir].tracks[pMenuItem.iID].sBestTime);
                Texts.drawTextAtPos(g, timeX, pMenuItem.getTop() + iDspY, Profile.envs[ScreenMenu.iSelectedEnvir].tracks[pMenuItem.iID].sBestTime);
                break;
            }
            case 3: {
                Resources.imgSelect.drawAtPoint(g, pMenuItem.getLeft(), pMenuItem.getTop());
                iTextW = Texts.getTextWidth(pMenuItem.getCaption());
                if (pMenuItem.iID == 2) {
                    Texts.drawTextAtPos(g, (Resources.iScreenW - iTextW) / 2, pMenuItem.getTop() + (pMenuItem.getHeight() - Texts.getFontHeight()) / 2, pMenuItem.getCaption());
                    return;
                }
                Texts.drawTextAtPos(g, pMenuItem.getLeft() + Resources.iIconsW, pMenuItem.getTop() + (pMenuItem.getHeight() - Texts.getFontHeight()) / 2, pMenuItem.getCaption());
                int frame = 0;
                if (pMenuItem.iID == 0 && Profile.bMusic || pMenuItem.iID == 1 && Profile.bVibrations) {
                    frame = 2;
                }
                Resources.sprIcons.setFrame(frame);
                Resources.sprIcons.setPosition(pMenuItem.getLeft() + pMenuItem.getWidth() - 2 * Resources.iIconsW, pMenuItem.getTop() + (pMenuItem.getHeight() - Resources.iIconsH) / 2);
                Resources.sprIcons.paint(g);
            }
        }
    }

    public void keyPressed(Key pKey) {
    }

    public void onMenuItemActivated(int iMenuItem) {
        DebugOutput.traceIn(100, "ScreenMenu", "activateMenuItem(" + iMenuItem + ")");
        switch (this.iMode) {
            case 2: {
                this.onMenuItemActivatedMainMenu(iMenuItem);
                break;
            }
            case 3: {
                this.onMenuItemActivatedOptions(iMenuItem);
                break;
            }
            case 12: {
                this.onCarChooseActivated(iMenuItem);
                break;
            }
            case 13: {
                this.onTrackChooseActivated(iMenuItem);
            }
        }
        DebugOutput.traceOut(100, "ScreenMenu", "activateMenuItem()");
    }

    private void onTrackChooseActivated(int iMenuItem) {
        if (!Profile.envs[ScreenMenu.iSelectedEnvir].tracks[iMenuItem].bUnlocked && iMenuItem == 5) {
            this.iMode = 17;
            Resources.prepareMultiLineText(Texts.getString(26) + "15" + Texts.getString(27));
            return;
        }
        if (!Profile.envs[ScreenMenu.iSelectedEnvir].tracks[iMenuItem].bUnlocked) {
            return;
        }
        this.iMode = 16;
        this.pMyApplication.repaintScreen();
        int selectedTrack = iMenuItem;
        this.startGame(this.iSelectedCar, iSelectedEnvir, selectedTrack);
    }

    private void onCarChooseActivated(int iMenuItem) {
        this.iSelectedCar = iMenuItem;
        this.iMode = 13;
        this.prepareTrackChooseMenuItems();
        this.pMyApplication.repaintScreen();
    }

    private void onMenuItemActivatedOptions(int iMenuItem) {
        DebugOutput.traceIn(100, "ScreenMenu", "activateOptionsMenuItem(" + iMenuItem + ")");
        switch (iMenuItem) {
            case 0: {
                Profile.bMusic = !Profile.bMusic;
                this.prepareOptionsMenuItems();
                if (Profile.bMusic) {
                    Sounds.playMenuMusic();
                    break;
                }
                Sounds.stopMusic();
                break;
            }
            case 1: {
                Profile.bVibrations = !Profile.bVibrations;
                Profile.save();
                this.prepareOptionsMenuItems();
                this.pMenuSystem.setSelectedItem(1);
                break;
            }
            case 2: {
                this.iMode = 7;
                Resources.prepareMultiLineText(Texts.getString(34));
            }
        }
        this.pMyApplication.repaintScreen();
        DebugOutput.traceOut(100, "ScreenMenu", "activateOptionsMenuItem()");
    }

    private void onMenuItemActivatedMainMenu(int iMenuItem) {
        DebugOutput.traceIn(100, "ScreenMenu", "activateMainMenuItem(" + iMenuItem + ")");
        if (iMenuItem == this.MI_PLAY) {
            this.loadGame();
            Profile.save();
            this.iMode = 12;
            this.prepareCarChooseMenuItems();
            this.pMyApplication.repaintScreen();
            return;
        }
        if (iMenuItem == this.MI_OPTIONS) {
            this.prepareOptionsMenuItems();
            this.iMode = 3;
            return;
        }
        if (iMenuItem == this.MI_TOPSCORE) {
            this.iMode = 5;
            this.loadGame();
            this.prepareTrackChooseMenuItems();
            return;
        }
        if (iMenuItem == this.MI_INSTRUCTIONS) {
            this.iInstructionPage = 0;
            this.prepareInstructions();
            this.iMode = 4;
            this.pMyApplication.repaintScreen();
            return;
        }
        if (iMenuItem == this.MI_ABOUT) {
            Resources.imgBackground = Resources.createImage("/minl.png");
            this.iMode = 6;
        }
        if (iMenuItem == this.MI_QUIT) {
            this.iMode = 8;
            Resources.prepareMultiLineText(Texts.getString(40));
            this.pMyApplication.repaintScreen();
        }
        DebugOutput.traceOut(100, "ScreenMenu", "activateMainMenuItem()");
    }

    private void startGame(int Car2, int Env, int Track2) {
        MyApplication.pScrGame = new ScreenGame(Car2, Env + 1, Track2 + 1);
        MyApplication.pActiveScreen = MyApplication.pScrGame;
        MyApplication.pScrMenu = null;
        this.iMode = 0;
        Resources.releaseMenuResources();
    }

    public void keyReleased(Key pKey) {
    }

    public void pointerPressed(int x, int y) {
        int partsY = Resources.iScreenH / Resources.iBorderH - Resources.MINUS_CHOOSE_Y_PARTS;
        int partsX = Resources.iScreenW / Resources.iBorderW - Resources.MINUS_MAIN_X_PARTS;
        switch (this.iMode) {
            case 2: {
                this.pMenuSystem.pointerPressed(x, y);
                if (!Resources.pressedRightButton(x, y, partsX, partsY)) break;
                this.iMode = 8;
                Resources.prepareMultiLineText(Texts.getString(40));
                this.pMyApplication.repaintScreen();
                return;
            }
            case 8: {
                if (Resources.pressedRightButton(x, y, partsX, Resources.iScreenH / Resources.iBorderH - 6)) {
                    this.prepareMainMenuItems();
                    this.iMode = 2;
                    this.pMyApplication.repaintScreen();
                    return;
                }
                if (!Resources.pressedLeftButton(x, y, partsX, Resources.iScreenH / Resources.iBorderH - 6)) break;
                Sounds.stopMusic();
                Application.getSingleton().stop();
                return;
            }
            case 3: {
                if (Resources.pressedLeftButton(x, y, partsX, Resources.iScreenH / Resources.iBorderH - 4)) {
                    this.prepareMainMenuItems();
                    this.iMode = 2;
                    this.pMyApplication.repaintScreen();
                    if (!Profile.canLoad()) {
                        this.newGame();
                    }
                    Profile.save();
                    return;
                }
                this.pMenuSystem.pointerPressed(x, y);
                break;
            }
            case 4: {
                if (Resources.pressedInstrLeft(x, y)) {
                    --this.iInstructionPage;
                    if (this.iInstructionPage < 0) {
                        this.iInstructionPage += this.iTotalInstructionsPages;
                    }
                    this.prepareInstructions();
                    this.pMyApplication.repaintScreen();
                    return;
                }
                if (Resources.pressedInstrRight(x, y)) {
                    ++this.iInstructionPage;
                    if (this.iInstructionPage > this.iTotalInstructionsPages - 1) {
                        this.iInstructionPage -= this.iTotalInstructionsPages;
                    }
                    this.prepareInstructions();
                    this.pMyApplication.repaintScreen();
                    return;
                }
                if (Resources.pressedInstrDown(x, y)) {
                    int iLineItemH = Texts.getFontHeight();
                    if (instrOffset < instrMaxOffs) {
                        instrOffset += iLineItemH;
                    }
                    this.pMyApplication.repaintScreen();
                    return;
                }
                if (Resources.pressedInstrUp(x, y)) {
                    int iLineItemH = Texts.getFontHeight();
                    if (instrOffset > 0) {
                        instrOffset -= iLineItemH;
                    }
                    this.pMyApplication.repaintScreen();
                    return;
                }
            }
            case 5: 
            case 6: {
                int iPosY;
                if (Resources.pressedRightButton(x, y, partsX, partsY)) {
                    this.iMode = 2;
                    this.prepareMainMenuItems();
                    this.pMyApplication.repaintScreen();
                    return;
                }
                if (this.iMode != 5) {
                    return;
                }
                if (Resources.pressedUpChooseTrack(x, y)) {
                    this.iMode = 14;
                    if (--iSelectedEnvir < 0) {
                        iSelectedEnvir = 2;
                    }
                    partsY = Resources.iScreenH / Resources.iBorderH - Resources.MINUS_CHOOSE_Y_PARTS;
                    partsX = Resources.iScreenW / Resources.iBorderW - Resources.MINUS_MAIN_X_PARTS;
                    iPosY = (Resources.iScreenH - Resources.iBorderH * partsY) / 2 + Resources.iChooseSide2H + Resources.iBorderH + Resources.iBorderH / 2;
                    this.iNewImageYPos = iPosY - Resources.iEnvsH;
                }
                if (!Resources.pressedDownChooseTrack(x, y)) break;
                this.iMode = 15;
                if (++iSelectedEnvir > 2) {
                    iSelectedEnvir = 0;
                }
                partsY = Resources.iScreenH / Resources.iBorderH - Resources.MINUS_CHOOSE_Y_PARTS;
                partsX = Resources.iScreenW / Resources.iBorderW - Resources.MINUS_MAIN_X_PARTS;
                iPosY = (Resources.iScreenH - Resources.iBorderH * partsY) / 2 + Resources.iChooseSide2H + Resources.iBorderH + Resources.iBorderH / 2;
                this.iNewImageYPos = iPosY + Resources.iEnvsH;
                break;
            }
            case 12: {
                int iPosX;
                if (Resources.pressedRightButton(x, y, partsX, partsY)) {
                    this.prepareMainMenuItems();
                    this.iMode = 2;
                    this.pMyApplication.repaintScreen();
                    return;
                }
                if (Resources.pressedLeftchooseCar(x, y)) {
                    this.iMode = 11;
                    partsX = Resources.iScreenW / Resources.iBorderW - 2;
                    iPosX = (Resources.iScreenW - Resources.iBorderW * partsX) / 2 + Resources.iBorderW * 2 + Resources.iCarImgsW + Resources.iChooseSideW * 2 - Resources.CHOOSE_MENU_OFFSET * 2;
                    this.iNewImageXPos = iPosX - Resources.iCarNamesW;
                }
                if (Resources.pressedRightchooseCar(x, y)) {
                    this.iMode = 10;
                    partsX = Resources.iScreenW / Resources.iBorderW - 2;
                    iPosX = (Resources.iScreenW - Resources.iBorderW * partsX) / 2 + Resources.iBorderW * 2 + Resources.iCarImgsW + Resources.iChooseSideW * 2 - Resources.CHOOSE_MENU_OFFSET * 2;
                    this.iNewImageXPos = iPosX + Resources.iCarNamesW;
                }
                this.pMenuSystem.pointerPressed(x, y);
                break;
            }
            case 13: {
                int iPosY;
                if (Resources.pressedRightButton(x, y, partsX, partsY)) {
                    if (this.iMode == 13) {
                        this.prepareCarChooseMenuItems();
                        this.iMode = 12;
                    }
                    this.pMyApplication.repaintScreen();
                    return;
                }
                if (Resources.pressedUpChooseTrack(x, y)) {
                    this.iMode = 14;
                    if (--iSelectedEnvir < 0) {
                        iSelectedEnvir = 2;
                    }
                    partsY = Resources.iScreenH / Resources.iBorderH - Resources.MINUS_CHOOSE_Y_PARTS;
                    partsX = Resources.iScreenW / Resources.iBorderW - Resources.MINUS_MAIN_X_PARTS;
                    iPosY = (Resources.iScreenH - Resources.iBorderH * partsY) / 2 + Resources.iChooseSide2H + Resources.iBorderH + Resources.iBorderH / 2;
                    this.iNewImageYPos = iPosY - Resources.iEnvsH;
                }
                if (Resources.pressedDownChooseTrack(x, y)) {
                    this.iMode = 15;
                    if (++iSelectedEnvir > 2) {
                        iSelectedEnvir = 0;
                    }
                    partsY = Resources.iScreenH / Resources.iBorderH - Resources.MINUS_CHOOSE_Y_PARTS;
                    partsX = Resources.iScreenW / Resources.iBorderW - Resources.MINUS_MAIN_X_PARTS;
                    iPosY = (Resources.iScreenH - Resources.iBorderH * partsY) / 2 + Resources.iChooseSide2H + Resources.iBorderH + Resources.iBorderH / 2;
                    this.iNewImageYPos = iPosY + Resources.iEnvsH;
                }
                this.pMenuSystem.pointerPressed(x, y);
                break;
            }
            case 7: {
                if (Resources.pressedRightButton(x, y, partsX, Resources.iScreenH / Resources.iBorderH - 6)) {
                    this.prepareOptionsMenuItems();
                    this.iMode = 3;
                    this.pMyApplication.repaintScreen();
                    return;
                }
                if (!Resources.pressedLeftButton(x, y, partsX, Resources.iScreenH / Resources.iBorderH - 6)) break;
                Profile.delete();
                this.newGame();
                this.prepareMainMenuItems();
                this.iMode = 2;
                this.pMyApplication.repaintScreen();
                return;
            }
            case 17: {
                if (!Resources.pressedLeftButton(x, y, partsX, Resources.iScreenH / Resources.iBorderH - 6)) break;
                this.prepareTrackChooseMenuItems();
                this.iMode = 13;
                this.pMyApplication.repaintScreen();
            }
        }
        this.pMyApplication.repaintScreen();
    }

    public void pointerReleased(int x, int y) {
        Keys.getSingleton().releaseKey(52);
        Keys.getSingleton().releaseKey(54);
    }

    public void onPause() {
    }

    public void onResume() {
        if (Profile.bMusic) {
            Sounds.playMenuMusic();
        } else {
            Sounds.stopMusic();
        }
        this.pMyApplication.repaintScreen();
    }

    static {
        bFirstTime = true;
    }
}

