/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.oldschoolracing;

import simple.debug.DebugOutput;
import simple.output.File;
import simple.output.FileSystem;
import sk.inlogic.oldschoolracing.Resources;

public class Profile {
    public static Environment[] envs = new Environment[3];
    static final String FILENAME = "rs:osr_profile";
    public static boolean bMusic = false;
    public static boolean bSoundFX = false;
    public static boolean bVibrations = true;

    public Profile(boolean[] bools, String[] strings, int[] secs, int[] stars) {
        int i;
        Profile.envs[0] = new Environment();
        for (i = 0; i < 6; ++i) {
            envs[0].addTrack(i, bools[i], strings[i], secs[i], stars[i]);
        }
        Profile.envs[1] = new Environment();
        for (i = 0; i < 6; ++i) {
            envs[1].addTrack(i, bools[6 + i], strings[6 + i], secs[6 + i], stars[6 + i]);
        }
        Profile.envs[2] = new Environment();
        for (i = 0; i < 6; ++i) {
            envs[2].addTrack(i, bools[12 + i], strings[12 + i], secs[12 + i], stars[12 + i]);
        }
    }

    public static boolean canLoad() {
        FileSystem pFileSystem = FileSystem.getSingleton();
        return FileSystem.fileExistsAtPath(FILENAME);
    }

    public static void delete() {
        FileSystem pFileSystem = FileSystem.getSingleton();
        pFileSystem.deleteFileAtPath(FILENAME);
    }

    public static void save() {
        DebugOutput.traceIn(50, "Profile", "save()");
        FileSystem pFileSystem = FileSystem.getSingleton();
        pFileSystem.deleteFileAtPath(FILENAME);
        File pFile = pFileSystem.createFileAtPath(FILENAME);
        pFile.writeBool(bMusic);
        pFile.writeBool(bSoundFX);
        pFile.writeBool(bVibrations);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 6; ++j) {
                System.out.println(i + ", " + j);
                pFile.writeBool(Profile.envs[i].tracks[j].bUnlocked);
                pFile.writeString(Profile.envs[i].tracks[j].sBestTime);
                pFile.writeInt(Profile.envs[i].tracks[j].seconds);
                pFile.writeInt(Profile.envs[i].tracks[j].iMedals);
            }
        }
        pFile.close();
        DebugOutput.traceOut(50, "Profile", "save()");
    }

    public static void load() {
        DebugOutput.traceIn(50, "Profile", "load()");
        FileSystem pFileSystem = FileSystem.getSingleton();
        File pFile = pFileSystem.openFileAtPath(FILENAME);
        if (pFile == null) {
            return;
        }
        boolean a = pFile.readBool();
        bSoundFX = pFile.readBool();
        a = pFile.readBool();
        boolean[] bools = new boolean[18];
        String[] strings = new String[18];
        int[] seconds = new int[18];
        int[] stars = new int[18];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 6; ++j) {
                bools[i * 6 + j] = pFile.readBool();
                strings[i * 6 + j] = pFile.readString();
                seconds[i * 6 + j] = pFile.readInt();
                stars[i * 6 + j] = pFile.readInt();
            }
        }
        Resources.profile = new Profile(bools, strings, seconds, stars);
        pFile.close();
        DebugOutput.traceOut(50, "Profile", "load()");
    }

    public class Environment {
        public Track[] tracks = new Track[6];

        public void addTrack(int i, boolean unl, String time, int seconds, int stars) {
            this.tracks[i] = new Track(unl, time, seconds, stars);
        }

        public class Track {
            boolean bUnlocked;
            String sBestTime;
            int seconds;
            int iMedals;

            public Track(boolean unl, String time, int secs, int meds) {
                this.bUnlocked = unl;
                this.sBestTime = time;
                this.seconds = secs;
                this.iMedals = meds;
            }
        }
    }
}

