/*
 * Decompiled with CFR 0.152.
 */
package simple.scene;

import simple.debug.DebugOutput;
import simple.scene.SceneObject;
import simple.video.Graphics;
import simple.video.Image;

public class Sprite
extends SceneObject {
    protected Image pImage;
    protected int iFramesInColumn;
    protected int iFramesInRow;
    protected int iFrameHeight;
    protected int iFrameWidth;
    protected int iFrame;
    protected int iFramesCount;
    protected int iZoomRatioX;
    protected int iZoomRatioY;
    protected boolean bFlipHorizontally;
    protected boolean bFlipVertically;
    protected int iRotation;
    public static final int ROT_0 = 1;
    public static final int ROT_90 = 2;
    public static final int ROT_180 = 3;
    public static final int ROT_270 = 4;

    public Sprite(Image pImage, int iFramesInRow, int iFramesInColumn) {
        this.setImage(pImage, iFramesInRow, iFramesInColumn);
        this.setFrame(0);
        this.iZoomRatioX = 1000;
        this.iZoomRatioY = 1000;
        this.setHorizontalFlip(false);
        this.setVerticalFlip(false);
    }

    public void release() {
        DebugOutput.traceIn(100, "simple.scene.Sprite", "release()");
        this.pImage = null;
        DebugOutput.traceOut(100, "simple.scene.Sprite", "release()");
    }

    public void releaseWithImage() {
        DebugOutput.traceIn(100, "simple.scene.Sprite", "release()");
        this.pImage.release();
        this.pImage = null;
        DebugOutput.traceOut(100, "simple.scene.Sprite", "release()");
    }

    void setImage(Image pImage, int iFramesInRow, int iFramesInColumn) {
        this.pImage = pImage;
        this.iFrameWidth = pImage.getWidth() / iFramesInRow;
        this.iFrameHeight = pImage.getHeight() / iFramesInColumn;
        this.iFramesCount = iFramesInColumn * iFramesInRow;
        this.iFramesInColumn = iFramesInColumn;
        this.iFramesInRow = iFramesInRow;
    }

    public Image getImage() {
        return this.pImage;
    }

    public int getWidth() {
        if (this.iZoomRatioX == 1000) {
            return this.iFrameWidth;
        }
        return this.iFrameWidth * this.iZoomRatioX / 1000;
    }

    public int getHeight() {
        if (this.iZoomRatioY == 1000) {
            return this.iFrameHeight;
        }
        return this.iFrameHeight * this.iZoomRatioY / 1000;
    }

    public void setReferencePixelPosition(int iPositionX, int iPositionY) {
        this.iPositionX = iPositionX - this.iReferencePixelX;
        this.iPositionY = iPositionY - this.iReferencePixelY;
    }

    public int getFramesCount() {
        return this.iFramesCount;
    }

    public int getFramesInColumn() {
        return this.iFramesInColumn;
    }

    public int getFramesInRow() {
        return this.iFramesInRow;
    }

    public void setFrame(int iFrame) {
        this.iFrame = iFrame % this.iFramesCount;
        if (this.iFrame < 0) {
            this.iFrame += this.iFramesCount;
        }
        if (this.iFrame > this.iFramesCount - 1) {
            this.iFrame -= this.iFramesCount;
        }
    }

    public int getFrame() {
        return this.iFrame;
    }

    public void prevFrame() {
        this.setFrame(this.iFrame - 1);
    }

    public void nextFrame() {
        this.setFrame(this.iFrame + 1);
    }

    public void setZoomRatio(int iZoomRatio) {
        this.setZoomRatio(iZoomRatio, iZoomRatio);
    }

    public void setZoomRatio(int iZoomRatioX, int iZoomRatioY) {
        this.iZoomRatioX = iZoomRatioX;
        this.iZoomRatioY = iZoomRatioY;
    }

    public void paint(Graphics pGraphics, int iPositionX, int iPositionY) {
        if (!this.isVisible()) {
            return;
        }
        int iRegionLeft = this.iFrameWidth * (this.iFrame % this.iFramesInRow);
        int iRegionTop = this.iFrameHeight * (this.iFrame / this.iFramesInRow);
        if (this.iZoomRatioX != 1000 || this.iZoomRatioY != 1000) {
            this.pImage.drawScaledRegionAtPoint(pGraphics, iPositionX, iPositionY, iRegionLeft, iRegionTop, this.iFrameWidth, this.iFrameHeight, this.iReferencePixelX, this.iReferencePixelY, this.iZoomRatioX, this.iZoomRatioY, this.bFlipHorizontally, this.bFlipVertically);
        } else {
            this.pImage.drawRegionAtPoint(pGraphics, iPositionX, iPositionY, iRegionLeft, iRegionTop, this.iFrameWidth, this.iFrameHeight, this.iReferencePixelX, this.iReferencePixelY, this.bFlipHorizontally, this.bFlipVertically);
        }
    }

    public void setHorizontalFlip(boolean bFlipHorizontally) {
        this.bFlipHorizontally = bFlipHorizontally;
    }

    public void setVerticalFlip(boolean bFlipVertically) {
        this.bFlipVertically = bFlipVertically;
    }

    public void setRotation(int rot) {
        this.iRotation = rot;
    }

    public void paintRotated(Graphics pGraphics, int iPositionX, int iPositionY) {
        if (!this.isVisible()) {
            return;
        }
        int iRegionLeft = this.iFrameWidth * (this.iFrame % this.iFramesInRow);
        int iRegionTop = this.iFrameHeight * (this.iFrame / this.iFramesInRow);
        this.pImage.drawRotatedRegionAtPoint(pGraphics, iPositionX, iPositionY, iRegionLeft, iRegionTop, this.iFrameWidth, this.iFrameHeight, this.iReferencePixelX, this.iReferencePixelY, this.bFlipHorizontally, this.bFlipVertically, this.iRotation);
    }
}

