/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.oldschoolracing;

import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Vector;
import simple.video.Graphics;
import sk.inlogic.oldschoolracing.RecShape;
import sk.inlogic.oldschoolracing.Resources;
import sk.inlogic.oldschoolracing.ScreenGame;

public class Obstacles {
    public static int envir;
    public static Vector obs;
    public static Vector trees;
    public static Vector colisions;
    public static Vector defects;
    public static Vector specRoads;

    public Obstacles(int env) {
        envir = env;
    }

    public void loadObsts(int env, int track) {
        try {
            obs.removeAllElements();
            trees.removeAllElements();
            colisions.removeAllElements();
            defects.removeAllElements();
            specRoads.removeAllElements();
            InputStream is = this.getClass().getResourceAsStream("/obsts" + env + "-" + track + ".bin");
            DataInputStream input = new DataInputStream(is);
            int size = input.readShort();
            for (int i = 0; i < size; ++i) {
                byte id = input.readByte();
                int x = input.readByte() * 30;
                byte xzv = input.readByte();
                int y = input.readByte() * 30;
                byte yzv = input.readByte();
                byte rot = input.readByte();
                byte flip = input.readByte();
                if (id == 7) {
                    defects.addElement(new Obst(id, (x + xzv) * Resources.iRoadW / 30, (y + yzv) * Resources.iRoadW / 30, rot, flip));
                    continue;
                }
                if (id == 12) {
                    specRoads.addElement(new Obst(id, (x + xzv) * Resources.iRoadW / 30, (y + yzv) * Resources.iRoadW / 30, rot, flip));
                    continue;
                }
                if (id == 10) {
                    trees.addElement(new Obst(id, (x + xzv) * Resources.iRoadW / 30, (y + yzv) * Resources.iRoadW / 30, rot, flip));
                    this.addColisionPoints(id, (x + xzv) * Resources.iRoadW / 30, (y + yzv) * Resources.iRoadW / 30, rot, flip);
                    continue;
                }
                obs.addElement(new Obst(id, (x + xzv) * Resources.iRoadW / 30, (y + yzv) * Resources.iRoadW / 30, rot, flip));
                this.addColisionPoints(id, (x + xzv) * Resources.iRoadW / 30, (y + yzv) * Resources.iRoadW / 30, rot, flip);
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    public void addColisionPoints(int id, int x, int y, int irot, int iflip) {
        int iX = 0;
        int iY = 0;
        int iW = 0;
        int iH = 0;
        switch (id) {
            case 1: {
                if (envir == 1 || envir == 2) {
                    if (irot == 1) {
                        iX = x + Resources.iBarrierW / 15;
                        iY = y + Resources.iBarrierW / 10;
                        iW = Resources.iBarrierW - Resources.iBarrierW / 4;
                        iH = Resources.iBarrierH / 2;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        return;
                    }
                    if (irot == 2) {
                        iX = x + Resources.iBarrierW / 3;
                        iY = y + Resources.iBarrierW / 13;
                        iW = Resources.iBarrierW / 2;
                        iH = Resources.iBarrierH - Resources.iBarrierH / 3;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        return;
                    }
                    if (irot == 3) {
                        iX = x + Resources.iBarrierW / 6;
                        iY = y + Resources.iBarrierH / 3;
                        iW = Resources.iBarrierW - Resources.iBarrierW / 4;
                        iH = Resources.iBarrierH / 2;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        return;
                    }
                    if (irot == 4) {
                        iX = x + Resources.iBarrierW / 9;
                        iY = y + Resources.iBarrierW / 5;
                        iW = Resources.iBarrierW / 2;
                        iH = Resources.iBarrierH - Resources.iBarrierH / 3;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        return;
                    }
                }
                if (envir == 3) {
                    if (irot == 1) {
                        iX = x;
                        iY = y;
                        iW = Resources.iBarrierW - Resources.iBarrierW / 4;
                        iH = Resources.iBarrierH - Resources.iBarrierH / 4;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        return;
                    }
                    if (irot == 2) {
                        iX = x + Resources.iBarrierW / 4;
                        iY = y;
                        iW = Resources.iBarrierW - Resources.iBarrierW / 4;
                        iH = Resources.iBarrierH - Resources.iBarrierH / 4;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        return;
                    }
                    if (irot == 3) {
                        iX = x + Resources.iBarrierW / 5;
                        iY = y + Resources.iBarrierH / 5;
                        iW = Resources.iBarrierW - Resources.iBarrierW / 4;
                        iH = Resources.iBarrierH - Resources.iBarrierH / 4;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        return;
                    }
                    if (irot == 4) {
                        iX = x;
                        iY = y;
                        iW = Resources.iBarrierW - Resources.iBarrierW / 4;
                        iH = Resources.iBarrierH - Resources.iBarrierH / 4;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        return;
                    }
                }
                if (envir != 2) break;
                if (irot == 1) {
                    iX = x + Resources.iBarrierW / 15;
                    iY = y + Resources.iBarrierW / 10;
                    iW = Resources.iBarrierW - Resources.iBarrierW / 4;
                    iH = Resources.iBarrierH / 2;
                    colisions.addElement(new RecShape(iX, iY, iW, iH));
                    return;
                }
                if (irot == 2) {
                    iX = x + Resources.iBarrierW / 3;
                    iY = y + Resources.iBarrierW / 13;
                    iW = Resources.iBarrierW / 2;
                    iH = Resources.iBarrierH - Resources.iBarrierH / 3;
                    colisions.addElement(new RecShape(iX, iY, iW, iH));
                    return;
                }
                if (irot == 3) {
                    iX = x + Resources.iBarrierW / 6;
                    iY = y + Resources.iBarrierH / 3;
                    iW = Resources.iBarrierW - Resources.iBarrierW / 4;
                    iH = Resources.iBarrierH / 2;
                    colisions.addElement(new RecShape(iX, iY, iW, iH));
                    return;
                }
                if (irot != 4) break;
                iX = x + Resources.iBarrierW / 9;
                iY = y + Resources.iBarrierW / 5;
                iW = Resources.iBarrierW / 2;
                iH = Resources.iBarrierH - Resources.iBarrierH / 3;
                colisions.addElement(new RecShape(iX, iY, iW, iH));
                return;
            }
            case 2: {
                if (envir == 1 || envir == 2) {
                    if (irot == 1) {
                        iX = x + Resources.iBarrierW / 15;
                        iY = y + Resources.iBarrierW / 10;
                        iW = Resources.iBarrierW - Resources.iBarrierW / 4;
                        iH = Resources.iBarrierH / 2;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        return;
                    }
                    if (irot == 2) {
                        iX = x + Resources.iBarrierW / 3;
                        iY = y + Resources.iBarrierW / 13;
                        iW = Resources.iBarrierW / 2;
                        iH = Resources.iBarrierH - Resources.iBarrierH / 3;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        return;
                    }
                    if (irot == 3) {
                        iX = x + Resources.iBarrierW / 6;
                        iY = y + Resources.iBarrierH / 3;
                        iW = Resources.iBarrierW - Resources.iBarrierW / 4;
                        iH = Resources.iBarrierH / 2;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        return;
                    }
                    if (irot == 4) {
                        iX = x + Resources.iBarrierW / 9;
                        iY = y + Resources.iBarrierW / 5;
                        iW = Resources.iBarrierW / 2;
                        iH = Resources.iBarrierH - Resources.iBarrierH / 3;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        return;
                    }
                }
                if (envir != 3) break;
                if (irot == 1) {
                    iX = x;
                    iY = y;
                    iW = Resources.iBarrierW - Resources.iBarrierW / 4;
                    iH = Resources.iBarrierH - Resources.iBarrierH / 4;
                    colisions.addElement(new RecShape(iX, iY, iW, iH));
                    return;
                }
                if (irot == 2) {
                    iX = x + Resources.iBarrierW / 4;
                    iY = y;
                    iW = Resources.iBarrierW - Resources.iBarrierW / 4;
                    iH = Resources.iBarrierH - Resources.iBarrierH / 4;
                    colisions.addElement(new RecShape(iX, iY, iW, iH));
                    return;
                }
                if (irot == 3) {
                    iX = x + Resources.iBarrierW / 5;
                    iY = y + Resources.iBarrierH / 5;
                    iW = Resources.iBarrierW - Resources.iBarrierW / 4;
                    iH = Resources.iBarrierH - Resources.iBarrierH / 4;
                    colisions.addElement(new RecShape(iX, iY, iW, iH));
                    return;
                }
                if (irot != 4) break;
                iX = x;
                iY = y;
                iW = Resources.iBarrierW - Resources.iBarrierW / 4;
                iH = Resources.iBarrierH - Resources.iBarrierH / 4;
                colisions.addElement(new RecShape(iX, iY, iW, iH));
                return;
            }
            case 3: {
                if (envir == 1) {
                    if (irot == 1) {
                        iX = x + Resources.iHouse1W / 5;
                        iY = y + Resources.iHouse1W / 8;
                        iW = Resources.iHouse1W / 16 + Resources.iHouse1W / 2;
                        iH = Resources.iHouse1H - Resources.iHouse1H / 3 + Resources.iHouse1H / 20;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        return;
                    }
                    if (irot == 2) {
                        iX = x + Resources.iHouse1W / 6;
                        iY = y + Resources.iHouse1W / 5;
                        iW = Resources.iHouse1W - Resources.iHouse1W / 3;
                        iH = Resources.iHouse1W / 16 + Resources.iHouse1W / 2;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        return;
                    }
                    if (irot == 3) {
                        iX = x + Resources.iHouse1W / 5;
                        iY = y + Resources.iHouse1W / 7;
                        iW = Resources.iHouse1W / 16 + Resources.iHouse1W / 2;
                        iH = Resources.iHouse1H - Resources.iHouse1H / 3 + Resources.iHouse1H / 20;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        return;
                    }
                    if (irot == 4) {
                        iX = x + Resources.iHouse1W / 6;
                        iY = y + Resources.iHouse1W / 5;
                        iW = Resources.iHouse1W - Resources.iHouse1W / 3;
                        iH = Resources.iHouse1W / 16 + Resources.iHouse1W / 2;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        return;
                    }
                }
                if (envir == 2) {
                    if (irot == 1) {
                        iX = x;
                        iY = y;
                        iW = Resources.iHouse1W - Resources.iHouse1W / 13;
                        iH = Resources.iHouse1H - Resources.iHouse1H / 4 - Resources.iHouse1H / 20;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        iX = x + Resources.iHouse1W / 13;
                        iY = y + iH;
                        iW = Resources.iHouse1W / 4;
                        iH = Resources.iHouse1H / 10;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        return;
                    }
                    if (irot == 2) {
                        iX = x + Resources.iHouse1W / 13 + Resources.iHouse1H / 10;
                        iY = y + Resources.iHouse1W / 13;
                        iH = Resources.iHouse1W / 4;
                        iW = Resources.iHouse1H / 10;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        iX = x + iW + Resources.iHouse1W / 13 + Resources.iHouse1H / 10;
                        iY = y;
                        iH = Resources.iHouse1W - Resources.iHouse1W / 13;
                        iW = Resources.iHouse1H - Resources.iHouse1H / 4 - Resources.iHouse1H / 20;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        return;
                    }
                    if (irot == 3) {
                        iX = x + Resources.iHouse1W - Resources.iHouse1W / 13 - Resources.iHouse1W / 4;
                        iY = y + Resources.iHouse1W / 6;
                        iW = Resources.iHouse1W / 4;
                        iH = Resources.iHouse1H / 10;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        iX = x + Resources.iHouse1H / 20;
                        iY = y + iH + Resources.iHouse1W / 6;
                        iW = Resources.iHouse1W - Resources.iHouse1W / 13;
                        iH = Resources.iHouse1H - Resources.iHouse1H / 4 - Resources.iHouse1H / 20;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        return;
                    }
                    if (irot == 4) {
                        iX = x;
                        iY = y + Resources.iHouse1H / 20;
                        iH = Resources.iHouse1W - Resources.iHouse1W / 13;
                        iW = Resources.iHouse1H - Resources.iHouse1H / 4 - Resources.iHouse1H / 20;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        iX = x + iW;
                        iH = Resources.iHouse1W / 4;
                        iY = y + Resources.iHouse1W - Resources.iHouse1W / 13 - iH;
                        iW = Resources.iHouse1H / 10;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        return;
                    }
                }
                if (envir != 3) break;
                if (irot == 1) {
                    iX = x;
                    iY = y;
                    iW = Resources.iHouse1W - Resources.iHouse1W / 10;
                    iH = Resources.iHouse1H - Resources.iHouse1H / 10;
                    colisions.addElement(new RecShape(iX, iY, iW, iH));
                    return;
                }
                if (irot == 2) {
                    iX = x + Resources.iHouse1W / 10;
                    iY = y;
                    iH = Resources.iHouse1W - Resources.iHouse1W / 10;
                    iW = Resources.iHouse1H - Resources.iHouse1H / 10;
                    colisions.addElement(new RecShape(iX, iY, iW, iH));
                    return;
                }
                if (irot == 3) {
                    iX = x + Resources.iHouse1W / 10;
                    iY = y + Resources.iHouse1H / 10;
                    iW = Resources.iHouse1W - Resources.iHouse1W / 10;
                    iH = Resources.iHouse1H - Resources.iHouse1H / 10;
                    colisions.addElement(new RecShape(iX, iY, iW, iH));
                    return;
                }
                if (irot != 4) break;
                iX = x;
                iY = y + Resources.iHouse1H / 10;
                iH = Resources.iHouse1W - Resources.iHouse1W / 10;
                iW = Resources.iHouse1H - Resources.iHouse1H / 10;
                colisions.addElement(new RecShape(iX, iY, iW, iH));
                return;
            }
            case 4: {
                if (envir == 1) {
                    if (irot == 1) {
                        iX = x + Resources.iHouse2W / 6;
                        iY = y + Resources.iHouse2W / 6;
                        iW = Resources.iHouse2W / 6 + Resources.iHouse2W / 2;
                        iH = Resources.iHouse2H / 13 + Resources.iHouse2H / 2;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        return;
                    }
                    if (irot == 2) {
                        iX = x + Resources.iHouse2W / 6;
                        iY = y + Resources.iHouse2W / 6;
                        iW = Resources.iHouse2H / 13 + Resources.iHouse2H / 2;
                        iH = Resources.iHouse2W / 6 + Resources.iHouse2W / 2;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        return;
                    }
                    if (irot == 3) {
                        iX = x + Resources.iHouse2W / 6;
                        iY = y + Resources.iHouse2W / 6;
                        iW = Resources.iHouse2W / 6 + Resources.iHouse2W / 2;
                        iH = Resources.iHouse2H / 13 + Resources.iHouse2H / 2;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        return;
                    }
                    if (irot == 4) {
                        iX = x + Resources.iHouse2W / 6;
                        iY = y + Resources.iHouse2W / 6;
                        iW = Resources.iHouse2H / 13 + Resources.iHouse2H / 2;
                        iH = Resources.iHouse2W / 6 + Resources.iHouse2W / 2;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        return;
                    }
                }
                if (envir == 2) {
                    if (irot == 1) {
                        iX = x + Resources.iHouse2W / 3;
                        iY = y + Resources.iHouse2W / 10;
                        iW = Resources.iHouse2W / 3;
                        iH = Resources.iHouse2H / 5;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        iX = x;
                        iY = y + iH + Resources.iHouse2W / 10;
                        iW = Resources.iHouse2W - Resources.iHouse2W / 13;
                        iH = Resources.iHouse2H - Resources.iHouse2H / 4 - Resources.iHouse2H / 10;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        return;
                    }
                    if (irot == 2) {
                        iX = x + Resources.iHouse2W / 10;
                        iY = y;
                        iH = Resources.iHouse2W - Resources.iHouse2W / 13;
                        iW = Resources.iHouse2H - Resources.iHouse2H / 4 - Resources.iHouse2H / 10;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        iX = x + iW + Resources.iHouse2W / 3 - Resources.iHouse2H / 5;
                        iY = y + Resources.iHouse2W / 3;
                        iH = Resources.iHouse2W / 3;
                        iW = Resources.iHouse2H / 5;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        return;
                    }
                    if (irot == 3) {
                        iX = x + Resources.iHouse2W / 20;
                        iY = y + Resources.iHouse2W / 10;
                        iW = Resources.iHouse2W - Resources.iHouse2W / 13;
                        iH = Resources.iHouse2H - Resources.iHouse2H / 4 - Resources.iHouse2H / 10;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        iX = x + Resources.iHouse2W / 3;
                        iY = y + iH + Resources.iHouse2W / 10;
                        iW = Resources.iHouse2W / 3;
                        iH = Resources.iHouse2H / 5;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        return;
                    }
                    if (irot == 4) {
                        iX = x + Resources.iHouse2W / 3 - Resources.iHouse2H / 5;
                        iY = y + Resources.iHouse2W / 3;
                        iH = Resources.iHouse2W / 3;
                        iW = Resources.iHouse2H / 5;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        iX = x + iW + Resources.iHouse2W / 3 - Resources.iHouse2H / 5;
                        iY = y + Resources.iHouse2W / 20;
                        iH = Resources.iHouse2W - Resources.iHouse2W / 13;
                        iW = Resources.iHouse2H - Resources.iHouse2H / 4 - Resources.iHouse2H / 10;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        return;
                    }
                }
                if (envir != 3) break;
                if (irot == 1) {
                    iX = x;
                    iY = y;
                    iW = Resources.iHouse2W - Resources.iHouse2W / 13;
                    iH = Resources.iHouse2H - Resources.iHouse2H / 10;
                    colisions.addElement(new RecShape(iX, iY, iW, iH));
                    return;
                }
                if (irot == 2) {
                    iX = x + Resources.iHouse2W / 13;
                    iY = y;
                    iH = Resources.iHouse2W - Resources.iHouse2W / 10;
                    iW = Resources.iHouse2H - Resources.iHouse2H / 10;
                    colisions.addElement(new RecShape(iX, iY, iW, iH));
                    return;
                }
                if (irot == 3) {
                    iX = x + Resources.iHouse2W / 13;
                    iY = y + Resources.iHouse2H / 10;
                    iW = Resources.iHouse2W - Resources.iHouse2W / 10;
                    iH = Resources.iHouse2H - Resources.iHouse2H / 10;
                    colisions.addElement(new RecShape(iX, iY, iW, iH));
                    return;
                }
                if (irot != 4) break;
                iX = x;
                iY = y + Resources.iHouse2H / 13;
                iH = Resources.iHouse2W - Resources.iHouse2W / 10;
                iW = Resources.iHouse2H - Resources.iHouse2H / 10;
                colisions.addElement(new RecShape(iX, iY, iW, iH));
                return;
            }
            case 5: {
                if (envir == 1 || envir == 2) {
                    if (irot == 1) {
                        iX = x + Resources.iObs1W / 6;
                        iY = y + Resources.iObs1W / 6;
                        iW = Resources.iObs1W / 6 + Resources.iObs1W / 2;
                        iH = Resources.iObs1H - Resources.iObs1H / 7;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        return;
                    }
                    if (irot == 2) {
                        iX = x + Resources.iObs1W / 6;
                        iY = y + Resources.iObs1W / 6;
                        iW = Resources.iObs1H - Resources.iObs1H / 9;
                        iH = Resources.iObs1W / 6 + Resources.iObs1W / 2;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        return;
                    }
                    if (irot == 3) {
                        iX = x + Resources.iObs1W / 6;
                        iY = y + Resources.iObs1W / 6;
                        iW = Resources.iObs1W / 6 + Resources.iObs1W / 2;
                        iH = Resources.iObs1H - Resources.iObs1H / 7;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        return;
                    }
                    if (irot == 4) {
                        iX = x + Resources.iObs1W / 6;
                        iY = y + Resources.iObs1W / 6;
                        iW = Resources.iObs1H - Resources.iObs1H / 9;
                        iH = Resources.iObs1W / 6 + Resources.iObs1W / 2;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        return;
                    }
                }
                if (envir != 3) break;
                if (irot == 1) {
                    iX = x + Resources.iObs1W / 6;
                    iY = y + Resources.iObs1W / 2;
                    iW = Resources.iObs1W / 6 + Resources.iObs1W / 2;
                    iH = Resources.iObs1H / 2 - Resources.iObs1H / 4;
                    colisions.addElement(new RecShape(iX, iY, iW, iH));
                    iX = x + Resources.iObs1W / 15;
                    iY = y + Resources.iObs1W / 2 + iH;
                    iW = Resources.iObs1W / 3;
                    iH = Resources.iObs1H / 2 - Resources.iObs1H / 4;
                    colisions.addElement(new RecShape(iX, iY, iW, iH));
                    iX = x + Resources.iObs1W / 3;
                    iY = y + Resources.iObs1H / 9;
                    iW = Resources.iObs1W / 3;
                    iH = Resources.iObs1H / 2 - Resources.iObs1H / 4;
                    colisions.addElement(new RecShape(iX, iY, iW, iH));
                    iX = x + Resources.iObs1W - Resources.iObs1W / 3;
                    iY = y;
                    iW = Resources.iObs1W / 3;
                    iH = Resources.iObs1H / 2 - Resources.iObs1H / 4;
                    colisions.addElement(new RecShape(iX, iY, iW, iH));
                    return;
                }
                if (irot == 2) {
                    iX = x + Resources.iObs1W / 3;
                    iY = y + Resources.iObs1H / 10;
                    iH = Resources.iObs1W / 6 + Resources.iObs1W / 2;
                    iW = Resources.iObs1H / 2 - Resources.iObs1H / 4;
                    colisions.addElement(new RecShape(iX, iY, iW, iH));
                    iX = x + Resources.iObs1W / 15;
                    iY = y;
                    iW = Resources.iObs1W / 3;
                    iH = Resources.iObs1H / 2 - Resources.iObs1H / 4;
                    colisions.addElement(new RecShape(iX, iY, iW, iH));
                    iX = x + Resources.iObs1W / 2 + Resources.iObs1W / 6;
                    iY = y + Resources.iObs1H / 4;
                    iW = Resources.iObs1W / 3;
                    iH = Resources.iObs1H / 2 - Resources.iObs1H / 4;
                    colisions.addElement(new RecShape(iX, iY, iW, iH));
                    iX = x + Resources.iObs1W - Resources.iObs1W / 6;
                    iY = y + Resources.iObs1W / 2 + Resources.iObs1W / 6;
                    iW = Resources.iObs1W / 3;
                    iH = Resources.iObs1H / 2 - Resources.iObs1H / 4;
                    colisions.addElement(new RecShape(iX, iY, iW, iH));
                    return;
                }
                if (irot == 3) {
                    iX = x + Resources.iObs1W / 4;
                    iY = y + Resources.iObs1W / 3;
                    iW = Resources.iObs1W / 6 + Resources.iObs1W / 2;
                    iH = Resources.iObs1H / 2 - Resources.iObs1H / 4;
                    colisions.addElement(new RecShape(iX, iY, iW, iH));
                    iX = x + Resources.iObs1W / 15;
                    iY = y + Resources.iObs1W / 2 + iH;
                    iW = Resources.iObs1W / 3;
                    iH = Resources.iObs1H / 2 - Resources.iObs1H / 4;
                    colisions.addElement(new RecShape(iX, iY, iW, iH));
                    iX = x + Resources.iObs1W / 3;
                    iY = y + Resources.iObs1H / 2 + Resources.iObs1H / 13;
                    iW = Resources.iObs1W / 3;
                    iH = Resources.iObs1H / 2 - Resources.iObs1H / 4;
                    colisions.addElement(new RecShape(iX, iY, iW, iH));
                    iX = x + Resources.iObs1W - Resources.iObs1W / 2;
                    iY = y;
                    iW = Resources.iObs1W / 2;
                    iH = Resources.iObs1H / 2 - Resources.iObs1H / 4;
                    colisions.addElement(new RecShape(iX, iY, iW, iH));
                    return;
                }
                if (irot != 4) break;
                iX = x + Resources.iObs1W / 3;
                iY = y + Resources.iObs1H / 10;
                iH = Resources.iObs1W / 6 + Resources.iObs1W / 2;
                iW = Resources.iObs1H / 2 - Resources.iObs1H / 4;
                colisions.addElement(new RecShape(iX, iY, iW, iH));
                iX = x + Resources.iObs1W / 15;
                iY = y;
                iW = Resources.iObs1W / 3;
                iH = Resources.iObs1H / 2 - Resources.iObs1H / 4;
                colisions.addElement(new RecShape(iX, iY, iW, iH));
                iX = x + Resources.iObs1W / 2 + Resources.iObs1W / 6;
                iY = y + Resources.iObs1H / 4;
                iW = Resources.iObs1W / 3;
                iH = Resources.iObs1H / 2 - Resources.iObs1H / 4;
                colisions.addElement(new RecShape(iX, iY, iW, iH));
                iX = x + Resources.iObs1W - Resources.iObs1W / 6;
                iY = y + Resources.iObs1W / 2 + Resources.iObs1W / 6;
                iW = Resources.iObs1W / 3;
                iH = Resources.iObs1H / 2 - Resources.iObs1H / 4;
                colisions.addElement(new RecShape(iX, iY, iW, iH));
                return;
            }
            case 6: {
                if (irot == 1) {
                    iX = x + Resources.iObsW / 6;
                    iY = y + Resources.iObsW / 6;
                    iW = Resources.iObsW / 9 + Resources.iObsW / 2;
                    iH = Resources.iObsH - Resources.iObsH / 7;
                    colisions.addElement(new RecShape(iX, iY, iW, iH));
                    iX = x;
                    iY = y + Resources.iObsW / 2 - Resources.iObsW / 7;
                    iW = Resources.iObsW / 9 + Resources.iObsW / 2;
                    iH = Resources.iObsH / 4;
                    colisions.addElement(new RecShape(iX, iY, iW, iH));
                    iX = x + Resources.iObsW / 2 - Resources.iObsW / 5;
                    iY = y + Resources.iObsW - Resources.iObsW / 15;
                    iW = Resources.iObsW / 9 + Resources.iObsW / 2;
                    iH = Resources.iObsH / 4;
                    colisions.addElement(new RecShape(iX, iY, iW, iH));
                    return;
                }
                if (irot == 2) {
                    iX = x + Resources.iObsW / 15;
                    iY = y + Resources.iObsW / 5;
                    iW = Resources.iObsH - Resources.iObsH / 5;
                    iH = Resources.iObsW / 11 + Resources.iObsW / 2;
                    colisions.addElement(new RecShape(iX, iY, iW, iH));
                    iX = x + Resources.iObsW / 5;
                    iY = y + Resources.iObsW / 2 - Resources.iObsW / 7;
                    iW = Resources.iObsH / 4;
                    iH = Resources.iObsW / 9 + Resources.iObsW / 2;
                    colisions.addElement(new RecShape(iX, iY, iW, iH));
                    iX = x + Resources.iObsH / 2;
                    iY = y + Resources.iObsW / 15;
                    iW = Resources.iObsH / 4;
                    iH = Resources.iObsW / 9 + Resources.iObsW / 2;
                    colisions.addElement(new RecShape(iX, iY, iW, iH));
                    return;
                }
                if (irot == 3) {
                    iX = x + Resources.iObsW / 4;
                    iY = y + Resources.iObsW / 12;
                    iW = Resources.iObsW / 9 + Resources.iObsW / 2;
                    iH = Resources.iObsH - Resources.iObsH / 5;
                    colisions.addElement(new RecShape(iX, iY, iW, iH));
                    iX = x;
                    iY = y + Resources.iObsW / 2 - Resources.iObsW / 3;
                    iW = Resources.iObsW / 9 + Resources.iObsW / 2;
                    iH = Resources.iObsH / 4;
                    colisions.addElement(new RecShape(iX, iY, iW, iH));
                    iX = x + Resources.iObsW / 2 - Resources.iObsW / 5;
                    iY = y + Resources.iObsW - Resources.iObsW / 7;
                    iW = Resources.iObsW / 6 + Resources.iObsW / 2;
                    iH = Resources.iObsH / 4;
                    colisions.addElement(new RecShape(iX, iY, iW, iH));
                    return;
                }
                if (irot != 4) break;
                iX = x + Resources.iObsW / 6;
                iY = y + Resources.iObsW / 4;
                iW = Resources.iObsH - Resources.iObsH / 5;
                iH = Resources.iObsW / 11 + Resources.iObsW / 2;
                colisions.addElement(new RecShape(iX, iY, iW, iH));
                iX = x + Resources.iObsW / 3;
                iY = y + Resources.iObsW / 2 - Resources.iObsW / 7;
                iW = Resources.iObsH / 4;
                iH = Resources.iObsW / 9 + Resources.iObsW / 2;
                colisions.addElement(new RecShape(iX, iY, iW, iH));
                iX = x + Resources.iObsH / 2 + Resources.iObsH / 10;
                iY = y + Resources.iObsW / 15;
                iW = Resources.iObsH / 4;
                iH = Resources.iObsW / 9 + Resources.iObsW / 2;
                colisions.addElement(new RecShape(iX, iY, iW, iH));
                return;
            }
            case 7: {
                break;
            }
            case 8: {
                if (irot == 1) {
                    iX = x + Resources.iFence1W / 6;
                    iY = y + Resources.iFence1W / 6;
                    iW = Resources.iFence1W / 6 + Resources.iFence1W / 2;
                    iH = Resources.iFence1H - Resources.iFence1H / 7;
                    colisions.addElement(new RecShape(iX, iY, iW, iH));
                    return;
                }
                if (irot == 2) {
                    iX = x + Resources.iFence1W / 6;
                    iY = y + Resources.iFence1W / 6;
                    iW = Resources.iFence1H - Resources.iFence1H / 9;
                    iH = Resources.iFence1W / 6 + Resources.iFence1W / 2;
                    colisions.addElement(new RecShape(iX, iY, iW, iH));
                    return;
                }
                if (irot == 3) {
                    iX = x + Resources.iFence1W / 6;
                    iY = y + Resources.iFence1W / 6;
                    iW = Resources.iFence1W / 6 + Resources.iFence1W / 2;
                    iH = Resources.iFence1H - Resources.iFence1H / 7;
                    colisions.addElement(new RecShape(iX, iY, iW, iH));
                    return;
                }
                if (irot != 4) break;
                iX = x + Resources.iFence1W / 6;
                iY = y + Resources.iFence1W / 6;
                iW = Resources.iFence1H - Resources.iFence1H / 9;
                iH = Resources.iFence1W / 6 + Resources.iFence1W / 2;
                colisions.addElement(new RecShape(iX, iY, iW, iH));
                return;
            }
            case 9: {
                if (envir == 1 || envir == 2) {
                    if (irot == 1) {
                        iX = x + Resources.iFence2W / 6;
                        iY = y + Resources.iFence2W / 6;
                        iW = Resources.iFence2W / 6 + Resources.iFence2W / 2;
                        iH = Resources.iFence2H - Resources.iFence2H / 7;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        return;
                    }
                    if (irot == 2) {
                        iX = x + Resources.iFence2W / 6;
                        iY = y + Resources.iFence2W / 6;
                        iW = Resources.iFence2H - Resources.iFence2H / 9;
                        iH = Resources.iFence2W / 6 + Resources.iFence2W / 2;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        return;
                    }
                    if (irot == 3) {
                        iX = x + Resources.iFence2W / 6;
                        iY = y + Resources.iFence2W / 6;
                        iW = Resources.iFence2W / 6 + Resources.iFence2W / 2;
                        iH = Resources.iFence2H - Resources.iFence2H / 7;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        return;
                    }
                    if (irot == 4) {
                        iX = x + Resources.iFence2W / 6;
                        iY = y + Resources.iFence2W / 6;
                        iW = Resources.iFence2H - Resources.iFence2H / 9;
                        iH = Resources.iFence2W / 6 + Resources.iFence2W / 2;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        return;
                    }
                }
                if (envir != 3) break;
                if (irot == 1) {
                    iX = x;
                    iY = y + Resources.iFence2W / 6;
                    iW = Resources.iFence2W - Resources.iFence2W / 15;
                    iH = Resources.iFence2H / 2;
                    colisions.addElement(new RecShape(iX, iY, iW, iH));
                    return;
                }
                if (irot == 2) {
                    iX = x + Resources.iFence2W / 6;
                    iY = y;
                    iH = Resources.iFence2W - Resources.iFence2W / 15;
                    iW = Resources.iFence2H / 2;
                    colisions.addElement(new RecShape(iX, iY, iW, iH));
                    return;
                }
                if (irot == 3) {
                    iX = x;
                    iY = y + Resources.iFence2W / 6;
                    iW = Resources.iFence2W - Resources.iFence2W / 15;
                    iH = Resources.iFence2H / 2;
                    colisions.addElement(new RecShape(iX, iY, iW, iH));
                    return;
                }
                if (irot != 4) break;
                iX = x + Resources.iFence2W / 6;
                iY = y;
                iH = Resources.iFence2W - Resources.iFence2W / 15;
                iW = Resources.iFence2H / 2;
                colisions.addElement(new RecShape(iX, iY, iW, iH));
                return;
            }
            case 10: {
                iW = Resources.iTreeW / 4;
                iH = Resources.iTreeH / 4;
                iX = x + (Resources.iTreeW - iW) / 2;
                iY = y + (Resources.iTreeW - iW) / 2;
                colisions.addElement(new RecShape(iX, iY, iW, iH));
                break;
            }
            case 11: {
                if (envir == 1) {
                    if (irot == 1) {
                        iX = x + Resources.iSpecBuildW / 3;
                        iY = y + Resources.iSpecBuildW / 5;
                        iW = Resources.iSpecBuildW / 6 + Resources.iSpecBuildW / 2;
                        iH = Resources.iSpecBuildH - Resources.iSpecBuildH / 7;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        return;
                    }
                    if (irot == 2) {
                        iX = x + Resources.iFence2W / 6;
                        iY = y + Resources.iFence2W / 6;
                        iW = Resources.iFence2H - Resources.iFence2H / 9;
                        iH = Resources.iFence2W / 6 + Resources.iFence2W / 2;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        return;
                    }
                    if (irot == 3) {
                        iX = x + Resources.iFence2W / 6;
                        iY = y + Resources.iFence2W / 6;
                        iW = Resources.iFence2W / 6 + Resources.iFence2W / 2;
                        iH = Resources.iFence2H - Resources.iFence2H / 7;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        return;
                    }
                    if (irot == 4) {
                        iX = x + Resources.iFence2W / 6;
                        iY = y + Resources.iFence2W / 6;
                        iW = Resources.iFence2H - Resources.iFence2H / 9;
                        iH = Resources.iFence2W / 6 + Resources.iFence2W / 2;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        return;
                    }
                }
                if (envir == 3) {
                    if (irot == 1) {
                        iX = x;
                        iY = y + Resources.iSpecBuildW / 13;
                        iW = Resources.iSpecBuildW - Resources.iSpecBuildW / 15;
                        iH = Resources.iSpecBuildH - Resources.iSpecBuildH / 5;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        return;
                    }
                    if (irot == 2) {
                        iX = x + Resources.iSpecBuildW / 13;
                        iY = y;
                        iW = Resources.iSpecBuildH - Resources.iSpecBuildH / 5;
                        iH = Resources.iSpecBuildW - Resources.iSpecBuildW / 20;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        return;
                    }
                    if (irot == 3) {
                        iX = x + Resources.iSpecBuildW / 20;
                        iY = y + Resources.iSpecBuildW / 13;
                        iW = Resources.iSpecBuildW - Resources.iSpecBuildW / 15;
                        iH = Resources.iSpecBuildH - Resources.iSpecBuildH / 5;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        return;
                    }
                    if (irot == 4) {
                        iX = x + Resources.iSpecBuildW / 13;
                        iY = y + Resources.iSpecBuildH / 13;
                        iH = Resources.iSpecBuildW - Resources.iSpecBuildW / 10;
                        iW = Resources.iSpecBuildH - Resources.iSpecBuildH / 5;
                        colisions.addElement(new RecShape(iX, iY, iW, iH));
                        return;
                    }
                }
                if (envir != 2) break;
                if (irot == 1) {
                    iX = x + Resources.iSpecBuildH / 5;
                    iY = y + Resources.iSpecBuildH / 9;
                    iW = Resources.iSpecBuildH / 7;
                    iH = Resources.iSpecBuildH - Resources.iSpecBuildH / 3;
                    colisions.addElement(new RecShape(iX, iY, iW, iH));
                    iX = x + Resources.iSpecBuildH / 5 + Resources.iSpecBuildH / 6;
                    iY = y;
                    iW = Resources.iSpecBuildH - Resources.iSpecBuildH / 10;
                    iH = Resources.iSpecBuildH - Resources.iSpecBuildH / 10;
                    colisions.addElement(new RecShape(iX, iY, iW, iH));
                    return;
                }
                if (irot == 2) {
                    iX = x + Resources.iSpecBuildH / 5;
                    iY = y + Resources.iSpecBuildH / 5;
                    iH = Resources.iSpecBuildH / 7;
                    iW = Resources.iSpecBuildH - Resources.iSpecBuildH / 3;
                    colisions.addElement(new RecShape(iX, iY, iW, iH));
                    iX = x + Resources.iSpecBuildH / 10;
                    iY = y + Resources.iSpecBuildH / 3 + Resources.iSpecBuildH / 20;
                    iH = Resources.iSpecBuildH - Resources.iSpecBuildH / 10;
                    iW = Resources.iSpecBuildH - Resources.iSpecBuildH / 10;
                    colisions.addElement(new RecShape(iX, iY, iW, iH));
                    return;
                }
                if (irot == 3) {
                    iX = x + Resources.iSpecBuildH / 10;
                    iY = y + Resources.iSpecBuildH / 10;
                    iW = Resources.iSpecBuildH - Resources.iSpecBuildH / 9;
                    iH = Resources.iSpecBuildH - Resources.iSpecBuildH / 10;
                    colisions.addElement(new RecShape(iX, iY, iW, iH));
                    iX = x + iW + Resources.iSpecBuildH / 10;
                    iY = y + Resources.iSpecBuildH / 5;
                    iW = Resources.iSpecBuildH / 7;
                    iH = Resources.iSpecBuildH - Resources.iSpecBuildH / 3;
                    colisions.addElement(new RecShape(iX, iY, iW, iH));
                    return;
                }
                if (irot != 4) break;
                iX = x;
                iY = y + Resources.iSpecBuildH / 10;
                iH = Resources.iSpecBuildH - Resources.iSpecBuildH / 10;
                iW = Resources.iSpecBuildH - Resources.iSpecBuildH / 10;
                colisions.addElement(new RecShape(iX, iY, iW, iH));
                iX = x + Resources.iSpecBuildH / 8;
                iY = y + iH + Resources.iSpecBuildH / 10;
                iH = Resources.iSpecBuildH / 7;
                iW = Resources.iSpecBuildH - Resources.iSpecBuildH / 3;
                colisions.addElement(new RecShape(iX, iY, iW, iH));
                return;
            }
        }
    }

    public void paintTrees(Graphics g) {
        for (int i = 0; i < trees.size(); ++i) {
            ((Obst)trees.elementAt(i)).paintObstacle(g);
        }
    }

    public void paintObstacles(Graphics g) {
        int i;
        for (i = 0; i < specRoads.size(); ++i) {
            ((Obst)specRoads.elementAt(i)).paintObstacle(g);
        }
        for (i = 0; i < defects.size(); ++i) {
            ((Obst)defects.elementAt(i)).paintObstacle(g);
        }
        for (i = 0; i < obs.size(); ++i) {
            ((Obst)obs.elementAt(i)).paintObstacle(g);
        }
    }

    public static boolean checkSpecialRoad(int x, int y) {
        for (int i = 0; i < specRoads.size(); ++i) {
            if (!(((Obst)Obstacles.specRoads.elementAt((int)i)).rot == 1 || ((Obst)Obstacles.specRoads.elementAt((int)i)).rot == 3 ? x >= ((Obst)Obstacles.specRoads.elementAt((int)i)).x && x <= ((Obst)Obstacles.specRoads.elementAt((int)i)).x + Resources.iSpecRoadW && y >= ((Obst)Obstacles.specRoads.elementAt((int)i)).y && y <= ((Obst)Obstacles.specRoads.elementAt((int)i)).y + Resources.iSpecRoadH : x >= ((Obst)Obstacles.specRoads.elementAt((int)i)).x && x <= ((Obst)Obstacles.specRoads.elementAt((int)i)).x + Resources.iSpecRoadH && y >= ((Obst)Obstacles.specRoads.elementAt((int)i)).y && y <= ((Obst)Obstacles.specRoads.elementAt((int)i)).y + Resources.iSpecRoadW)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCollision(int[] xCorns, int[] yCorns, int i) {
        if (((RecShape)Obstacles.colisions.elementAt((int)i)).xStart + ((RecShape)Obstacles.colisions.elementAt((int)i)).width * 5 < xCorns[0] || ((RecShape)Obstacles.colisions.elementAt((int)i)).xStart - ((RecShape)Obstacles.colisions.elementAt((int)i)).width * 5 > xCorns[0]) {
            return false;
        }
        if (((RecShape)Obstacles.colisions.elementAt((int)i)).yStart + ((RecShape)Obstacles.colisions.elementAt((int)i)).height * 5 < yCorns[0] || ((RecShape)Obstacles.colisions.elementAt((int)i)).yStart - ((RecShape)Obstacles.colisions.elementAt((int)i)).height * 5 > yCorns[0]) {
            return false;
        }
        for (int j = 0; j < xCorns.length; ++j) {
            if (xCorns[j] < ((RecShape)Obstacles.colisions.elementAt((int)i)).xStart || xCorns[j] > ((RecShape)Obstacles.colisions.elementAt((int)i)).xStart + ((RecShape)Obstacles.colisions.elementAt((int)i)).width || yCorns[j] < ((RecShape)Obstacles.colisions.elementAt((int)i)).yStart || yCorns[j] > ((RecShape)Obstacles.colisions.elementAt((int)i)).yStart + ((RecShape)Obstacles.colisions.elementAt((int)i)).height) continue;
            return true;
        }
        return false;
    }

    public static boolean isRoadDef(int[] xCorns, int[] yCorns, int i) {
        for (int j = 0; j < xCorns.length; ++j) {
            if (!(((Obst)Obstacles.defects.elementAt((int)i)).rot == 1 || ((Obst)Obstacles.defects.elementAt((int)i)).rot == 3 ? xCorns[j] >= ((Obst)Obstacles.defects.elementAt((int)i)).x && xCorns[j] <= ((Obst)Obstacles.defects.elementAt((int)i)).x + Resources.iRoadDefectW && yCorns[j] >= ((Obst)Obstacles.defects.elementAt((int)i)).y && yCorns[j] <= ((Obst)Obstacles.defects.elementAt((int)i)).y + Resources.iRoadDefectH : xCorns[j] >= ((Obst)Obstacles.defects.elementAt((int)i)).x && xCorns[j] <= ((Obst)Obstacles.defects.elementAt((int)i)).x + Resources.iRoadDefectH && yCorns[j] >= ((Obst)Obstacles.defects.elementAt((int)i)).y && yCorns[j] <= ((Obst)Obstacles.defects.elementAt((int)i)).y + Resources.iRoadDefectW)) continue;
            return true;
        }
        return false;
    }

    public static int[] getDimensions(int id, int i) {
        int[] result = new int[2];
        if (id < 3) {
            result[0] = Resources.iBarrierW;
            result[1] = Resources.iBarrierH;
        } else {
            switch (id) {
                case 3: {
                    result[0] = Resources.iHouse1W;
                    result[1] = Resources.iHouse1H;
                    break;
                }
                case 4: {
                    result[0] = Resources.iHouse2W;
                    result[1] = Resources.iHouse2H;
                    break;
                }
                case 5: {
                    result[0] = Resources.iObs1W;
                    result[1] = Resources.iObs1H;
                    break;
                }
                case 6: {
                    result[0] = Resources.iObsW;
                    result[1] = Resources.iObsH;
                    break;
                }
                case 7: {
                    result[0] = Resources.iRoadDefectW;
                    result[1] = Resources.iRoadDefectH;
                    break;
                }
                case 8: {
                    result[0] = Resources.iFence1W;
                    result[1] = Resources.iFence1H;
                    break;
                }
                case 9: {
                    result[0] = Resources.iFence2W;
                    result[1] = Resources.iFence2H;
                    break;
                }
                case 10: {
                    result[0] = Resources.iTreeW;
                    result[1] = Resources.iTreeH;
                    break;
                }
                case 11: {
                    result[0] = Resources.iSpecBuildW;
                    result[1] = Resources.iSpecBuildH;
                    break;
                }
                case 12: {
                    result[0] = Resources.iSpecRoadW;
                    result[1] = Resources.iSpecRoadH;
                }
            }
        }
        if (((Obst)Obstacles.obs.elementAt((int)i)).rot == 1 || ((Obst)Obstacles.obs.elementAt((int)i)).rot == 3) {
            int tmp = result[0];
            result[0] = result[1];
            result[1] = tmp;
        }
        return result;
    }

    static {
        obs = new Vector();
        trees = new Vector();
        colisions = new Vector();
        defects = new Vector();
        specRoads = new Vector();
    }

    public class Obst {
        public int id;
        public int x;
        public int y;
        public int rot;
        public int flip;

        public Obst(int iid, int ix, int iy, int irot, int iflip) {
            this.id = iid;
            this.x = ix;
            this.y = iy;
            this.rot = irot;
            this.flip = iflip;
        }

        public void paintObstacle(Graphics g) {
            if (this.x + Resources.iScreenW2 < ScreenGame.iXPos || this.x - Resources.iScreenW2 > ScreenGame.iXPos + Resources.iScreenW) {
                return;
            }
            if (this.y + Resources.iScreenH2 < ScreenGame.iYPos || this.y - Resources.iScreenH2 > ScreenGame.iYPos + Resources.iScreenH) {
                return;
            }
            if (this.id < 3) {
                Resources.sprBarrier.setFrame(this.id - 1);
                Resources.sprBarrier.setRotation(this.rot);
                Resources.sprBarrier.setHorizontalFlip(false);
                Resources.sprBarrier.setVerticalFlip(false);
                if (this.flip == 2 || this.flip == 4) {
                    Resources.sprBarrier.setHorizontalFlip(true);
                }
                if (this.flip == 3 || this.flip == 4) {
                    Resources.sprBarrier.setVerticalFlip(true);
                }
                Resources.sprBarrier.setPosition(this.x - ScreenGame.iXPos, this.y - ScreenGame.iYPos);
                Resources.sprBarrier.paintRotated(g);
            } else {
                boolean hor = false;
                boolean ver = false;
                switch (this.id) {
                    case 3: {
                        Resources.imgHouse1.drawRotatedAtPoint(g, this.x - ScreenGame.iXPos, this.y - ScreenGame.iYPos, hor, ver, this.rot);
                        break;
                    }
                    case 4: {
                        Resources.imgHouse2.drawRotatedAtPoint(g, this.x - ScreenGame.iXPos, this.y - ScreenGame.iYPos, hor, ver, this.rot);
                        break;
                    }
                    case 5: {
                        Resources.imgObs1.drawRotatedAtPoint(g, this.x - ScreenGame.iXPos, this.y - ScreenGame.iYPos, hor, ver, this.rot);
                        break;
                    }
                    case 6: {
                        Resources.imgObs2.drawRotatedAtPoint(g, this.x - ScreenGame.iXPos, this.y - ScreenGame.iYPos, hor, ver, this.rot);
                        break;
                    }
                    case 7: {
                        Resources.imgRoadDefect.drawRotatedAtPoint(g, this.x - ScreenGame.iXPos, this.y - ScreenGame.iYPos, hor, ver, this.rot);
                        break;
                    }
                    case 8: {
                        Resources.imgFence1.drawRotatedAtPoint(g, this.x - ScreenGame.iXPos, this.y - ScreenGame.iYPos, hor, ver, this.rot);
                        break;
                    }
                    case 9: {
                        Resources.imgFence2.drawRotatedAtPoint(g, this.x - ScreenGame.iXPos, this.y - ScreenGame.iYPos, hor, ver, this.rot);
                        break;
                    }
                    case 10: {
                        Resources.imgTree.drawRotatedAtPoint(g, this.x - ScreenGame.iXPos, this.y - ScreenGame.iYPos, hor, ver, this.rot);
                        break;
                    }
                    case 11: {
                        Resources.imgSpecBuild.drawRotatedAtPoint(g, this.x - ScreenGame.iXPos, this.y - ScreenGame.iYPos, hor, ver, this.rot);
                        break;
                    }
                    case 12: {
                        Resources.imgSpecRoad.drawRotatedAtPoint(g, this.x - ScreenGame.iXPos, this.y - ScreenGame.iYPos, hor, ver, this.rot);
                    }
                }
            }
            int[] dim = new int[2];
            dim = this.getDimensions(this.id);
        }

        public int[] getDimensions(int id) {
            int[] result = new int[2];
            if (id < 3) {
                result[0] = Resources.iBarrierW;
                result[1] = Resources.iBarrierH;
            } else {
                switch (id) {
                    case 3: {
                        result[0] = Resources.iHouse1W;
                        result[1] = Resources.iHouse1H;
                        break;
                    }
                    case 4: {
                        result[0] = Resources.iHouse2W;
                        result[1] = Resources.iHouse2H;
                        break;
                    }
                    case 5: {
                        result[0] = Resources.iObs1W;
                        result[1] = Resources.iObs1H;
                        break;
                    }
                    case 6: {
                        result[0] = Resources.iObsW;
                        result[1] = Resources.iObsH;
                        break;
                    }
                    case 7: {
                        result[0] = Resources.iRoadDefectW;
                        result[1] = Resources.iRoadDefectH;
                        break;
                    }
                    case 8: {
                        result[0] = Resources.iFence1W;
                        result[1] = Resources.iFence1H;
                        break;
                    }
                    case 9: {
                        result[0] = Resources.iTreeW;
                        result[1] = Resources.iTreeH;
                        break;
                    }
                    case 10: {
                        result[0] = Resources.iFence2W;
                        result[1] = Resources.iFence2H;
                    }
                }
            }
            if (this.rot == 1 || this.rot == 3) {
                int tmp = result[0];
                result[0] = result[1];
                result[1] = tmp;
            }
            return result;
        }
    }
}

