/*
 * Decompiled with CFR 0.152.
 */
package simple.video;

import java.io.IOException;
import java.util.Hashtable;
import simple.core.Application;
import simple.debug.DebugOutput;
import simple.video.Graphics;
import simple.video.ImageScaler;

public class Image {
    private static Hashtable mapImageCache = new Hashtable();
    private static StringBuffer pTmpStringBuffer = new StringBuffer();
    private javax.microedition.lcdui.Image pImage;
    private Graphics pGraphics;
    private String strResourceName;
    private boolean bImageLoaded;
    private boolean bSubImage;
    private int iLeft;
    private int iTop;
    private int iWidth;
    private int iHeight;
    private int[] pRgbData = null;
    private boolean bUpdatePixels = false;
    private Hashtable mapScaledImages = null;

    public javax.microedition.lcdui.Image getMicroeditionImage() {
        return this.pImage;
    }

    public static Image createCachedImage(String strResourceNameToCache) {
        Image pRetVal = Image.getCachedImage(strResourceNameToCache);
        if (pRetVal == null) {
            pRetVal = new Image(strResourceNameToCache);
            mapImageCache.put(strResourceNameToCache, pRetVal);
        }
        return pRetVal;
    }

    public static Image createCachedImage(String strResourceNameToCache, Image pImage, int iLeft, int iTop, int iWidth, int iHeight) {
        Image pRetVal = Image.getCachedImage(strResourceNameToCache);
        if (pRetVal == null) {
            pRetVal = new Image(pImage, iLeft, iTop, iWidth, iHeight);
            mapImageCache.put(strResourceNameToCache, pRetVal);
        }
        return pRetVal;
    }

    public static Image getCachedImage(String strResourceNameFromCache) {
        return (Image)mapImageCache.get(strResourceNameFromCache);
    }

    public Image(String strResourceName) {
        try {
            this.pImage = javax.microedition.lcdui.Image.createImage((String)strResourceName);
            this.pGraphics = null;
            this.strResourceName = strResourceName;
            this.bSubImage = false;
            this.iLeft = 0;
            this.iTop = 0;
            this.iWidth = this.pImage.getWidth();
            this.iHeight = this.pImage.getHeight();
            this.bImageLoaded = true;
        }
        catch (IOException e) {
            this.bImageLoaded = false;
            System.out.println("simple.video.Image(\"" + strResourceName + "\") exception : " + e.getMessage());
        }
    }

    public Image(int iWidth, int iHeight) {
        this.pImage = javax.microedition.lcdui.Image.createImage((int)iWidth, (int)iHeight);
        this.pGraphics = null;
        this.bSubImage = false;
        this.iLeft = 0;
        this.iTop = 0;
        this.iWidth = iWidth;
        this.iHeight = iHeight;
    }

    public Image(Image pSrcImage, int iLeft, int iTop, int iWidth, int iHeight) {
        this.pImage = pSrcImage.pImage;
        this.pGraphics = null;
        this.strResourceName = pSrcImage.strResourceName;
        this.bSubImage = true;
        this.iLeft = iLeft;
        this.iTop = iTop;
        this.iWidth = iWidth;
        this.iHeight = iHeight;
    }

    public void release() {
        DebugOutput.traceIn(100, "simple.video.Image", "release()");
        if (this.mapScaledImages != null) {
            this.mapScaledImages.clear();
        }
        this.mapScaledImages = null;
        this.pImage = null;
        this.pRgbData = null;
        DebugOutput.traceOut(100, "simple.video.Image", "release()");
    }

    public Graphics getGraphics() {
        if (this.pGraphics == null) {
            this.pGraphics = new Graphics(this);
        }
        return this.pGraphics;
    }

    public boolean isLoaded() {
        return this.bImageLoaded;
    }

    public String getResourceName() {
        return this.strResourceName;
    }

    public int getWidth() {
        return this.iWidth;
    }

    public int getHeight() {
        return this.iHeight;
    }

    private void getPixelsData() {
        if (this.pRgbData == null) {
            this.pRgbData = new int[this.pImage.getWidth() * (this.pImage.getHeight() + 1)];
            this.pImage.getRGB(this.pRgbData, 0, this.pImage.getWidth(), 0, 0, this.pImage.getWidth(), this.pImage.getHeight());
        }
    }

    public int getPixelColor(int iLeft, int iTop) {
        this.getPixelsData();
        return this.pRgbData[iTop * this.pImage.getWidth() + iLeft];
    }

    public void setPixelColor(int iLeft, int iTop, int iColor) {
        this.getPixelsData();
        this.pRgbData[iTop * this.pImage.getWidth() + iLeft] = iColor;
        this.bUpdatePixels = true;
    }

    private void updatePixelsData() {
        if (!this.bUpdatePixels) {
            return;
        }
        int iWidth = this.pImage.getWidth();
        int iHeight = this.pImage.getHeight();
        this.pImage = javax.microedition.lcdui.Image.createRGBImage((int[])this.pRgbData, (int)iWidth, (int)iHeight, (boolean)true);
        this.bUpdatePixels = false;
    }

    public void releasePixelsData() {
        this.updatePixelsData();
        this.pRgbData = null;
        System.gc();
    }

    public void drawAtPoint(Graphics pGraphics, int iLeft, int iTop, int iReferencePixelX, int iReferencePixelY, boolean bFlipHorizontally, boolean bFlipVertically) {
        this.drawRegionAtPoint(pGraphics, iLeft, iTop, this.iLeft, this.iTop, this.iWidth, this.iHeight, iReferencePixelX, iReferencePixelY, bFlipHorizontally, bFlipVertically);
    }

    public void drawAtPoint(Graphics pGraphics, int iLeft, int iTop) {
        this.drawRegionAtPoint(pGraphics, iLeft, iTop, this.iLeft, this.iTop, this.iWidth, this.iHeight);
    }

    public void drawRotatedAtPoint(Graphics pGraphics, int iLeft, int iTop, boolean bFlipHorizontally, boolean bFlipVertically, int iRotation) {
        this.drawRotatedRegionAtPoint(pGraphics, iLeft, iTop, this.iLeft, this.iTop, this.iWidth, this.iHeight, bFlipHorizontally, bFlipVertically, iRotation);
    }

    public void drawRegionAtPoint(Graphics pGraphics, int iLeft, int iTop, int iRegionLeft, int iRegionTop, int iRegionWidth, int iRegionHeight, int iReferencePixelX, int iReferencePixelY, boolean bFlipHorizontally, boolean bFlipVertically) {
        this.updatePixelsData();
        int iRefX = iReferencePixelX;
        int iRefY = iReferencePixelY;
        int iTransform = 0;
        if (bFlipHorizontally && bFlipVertically) {
            iTransform = 3;
        } else if (bFlipHorizontally) {
            iTransform = 2;
        } else if (bFlipVertically) {
            iTransform = 1;
        }
        if (pGraphics.pScreen != null && Application.getSingleton().getDevice().getScreen().getOrientation() == 1) {
            int iTmp = iTop;
            iTop = iLeft;
            iLeft = pGraphics.getHeight() - iTmp - iRegionHeight;
            iTransform = 5;
            if (bFlipHorizontally && bFlipVertically) {
                iTransform = 6;
            } else if (bFlipHorizontally) {
                iTransform = 7;
            } else if (bFlipVertically) {
                iTransform = 4;
            }
            iRefX = -iReferencePixelY;
            iRefY = iReferencePixelX;
        }
        pGraphics.getMicroeditionGraphics().drawRegion(this.pImage, iRegionLeft, iRegionTop, iRegionWidth, iRegionHeight, iTransform, iLeft - iRefX, iTop - iRefY, 0);
    }

    public void drawRegionAtPoint(Graphics pGraphics, int iLeft, int iTop, int iRegionLeft, int iRegionTop, int iRegionWidth, int iRegionHeight) {
        this.updatePixelsData();
        int iTransform = 0;
        if (pGraphics.pScreen != null && Application.getSingleton().getDevice().getScreen().getOrientation() == 1) {
            int iTmp = iTop;
            iTop = iLeft;
            iLeft = pGraphics.getHeight() - iTmp - iRegionHeight;
            iTransform = 5;
        }
        pGraphics.getMicroeditionGraphics().drawRegion(this.pImage, iRegionLeft, iRegionTop, iRegionWidth, iRegionHeight, iTransform, iLeft, iTop, 0);
    }

    public void drawRotatedRegionAtPoint(Graphics pGraphics, int iLeft, int iTop, int iRegionLeft, int iRegionTop, int iRegionWidth, int iRegionHeight, boolean bFlipHorizontally, boolean bFlipVertically, int iRotation) {
        this.updatePixelsData();
        int iTransform = 0;
        if (iRotation == 1) {
            iTransform = 0;
            if (bFlipHorizontally && bFlipVertically) {
                iTransform = 3;
            } else if (bFlipHorizontally) {
                iTransform = 2;
            } else if (bFlipVertically) {
                iTransform = 1;
            }
        } else if (iRotation == 2) {
            iTransform = 5;
            if (bFlipHorizontally && bFlipVertically) {
                iTransform = 6;
            } else if (bFlipHorizontally) {
                iTransform = 4;
            } else if (bFlipVertically) {
                iTransform = 7;
            }
        } else if (iRotation == 3) {
            iTransform = 3;
            if (bFlipHorizontally && bFlipVertically) {
                iTransform = 0;
            } else if (bFlipHorizontally) {
                iTransform = 1;
            } else if (bFlipVertically) {
                iTransform = 2;
            }
        } else if (iRotation == 4) {
            iTransform = 6;
            if (bFlipHorizontally && bFlipVertically) {
                iTransform = 5;
            } else if (bFlipHorizontally) {
                iTransform = 7;
            } else if (bFlipVertically) {
                iTransform = 4;
            }
        }
        if (Application.getSingleton().getDevice().getScreen().getOrientation() == 1) {
            int iTmp = iTop;
            iTop = iLeft;
            iLeft = pGraphics.getHeight() - iTmp - iRegionHeight;
            iTransform = 5;
            if (iRotation == 1) {
                iTransform = 5;
                if (bFlipHorizontally && bFlipVertically) {
                    iTransform = 6;
                } else if (bFlipHorizontally) {
                    iTransform = 7;
                } else if (bFlipVertically) {
                    iTransform = 4;
                }
            } else if (iRotation == 2) {
                iLeft += iRegionHeight;
                iLeft -= iRegionWidth;
                iTransform = 3;
                if (bFlipHorizontally && bFlipVertically) {
                    iTransform = 0;
                } else if (bFlipHorizontally) {
                    iTransform = 2;
                } else if (bFlipVertically) {
                    iTransform = 1;
                }
            } else if (iRotation == 3) {
                iTransform = 6;
                if (bFlipHorizontally && bFlipVertically) {
                    iTransform = 5;
                } else if (bFlipHorizontally) {
                    iTransform = 4;
                } else if (bFlipVertically) {
                    iTransform = 7;
                }
            } else if (iRotation == 4) {
                iLeft += iRegionHeight;
                iLeft -= iRegionWidth;
                iTransform = 0;
                if (bFlipHorizontally && bFlipVertically) {
                    iTransform = 3;
                } else if (bFlipHorizontally) {
                    iTransform = 1;
                } else if (bFlipVertically) {
                    iTransform = 2;
                }
            }
        }
        pGraphics.getMicroeditionGraphics().drawRegion(this.pImage, iRegionLeft, iRegionTop, iRegionWidth, iRegionHeight, iTransform, iLeft, iTop, 0);
    }

    public void drawRotatedRegionAtPoint(Graphics pGraphics, int iLeft, int iTop, int iRegionLeft, int iRegionTop, int iRegionWidth, int iRegionHeight, int iReferencePixelX, int iReferencePixelY, boolean bFlipHorizontally, boolean bFlipVertically, int iRotation) {
        this.updatePixelsData();
        int iTransform = 0;
        if (iRotation == 1) {
            iTransform = 0;
            if (bFlipHorizontally && bFlipVertically) {
                iTransform = 3;
            } else if (bFlipHorizontally) {
                iTransform = 2;
            } else if (bFlipVertically) {
                iTransform = 1;
            }
        } else if (iRotation == 2) {
            iTransform = 5;
            if (bFlipHorizontally && bFlipVertically) {
                iTransform = 6;
            } else if (bFlipHorizontally) {
                iTransform = 4;
            } else if (bFlipVertically) {
                iTransform = 7;
            }
        } else if (iRotation == 3) {
            iTransform = 3;
            if (bFlipHorizontally && bFlipVertically) {
                iTransform = 0;
            } else if (bFlipHorizontally) {
                iTransform = 1;
            } else if (bFlipVertically) {
                iTransform = 2;
            }
        } else if (iRotation == 4) {
            iTransform = 6;
            if (bFlipHorizontally && bFlipVertically) {
                iTransform = 5;
            } else if (bFlipHorizontally) {
                iTransform = 7;
            } else if (bFlipVertically) {
                iTransform = 4;
            }
        }
        if (Application.getSingleton().getDevice().getScreen().getOrientation() == 1) {
            int iTmp = iTop;
            iTop = iLeft;
            iLeft = pGraphics.getHeight() - iTmp - iRegionHeight;
            iTransform = 5;
            if (iRotation == 1) {
                iTransform = 5;
                if (bFlipHorizontally && bFlipVertically) {
                    iTransform = 6;
                } else if (bFlipHorizontally) {
                    iTransform = 7;
                } else if (bFlipVertically) {
                    iTransform = 4;
                }
            } else if (iRotation == 2) {
                iTransform = 3;
                if (bFlipHorizontally && bFlipVertically) {
                    iTransform = 0;
                } else if (bFlipHorizontally) {
                    iTransform = 2;
                } else if (bFlipVertically) {
                    iTransform = 1;
                }
            } else if (iRotation == 3) {
                iTransform = 6;
                if (bFlipHorizontally && bFlipVertically) {
                    iTransform = 5;
                } else if (bFlipHorizontally) {
                    iTransform = 4;
                } else if (bFlipVertically) {
                    iTransform = 7;
                }
            } else if (iRotation == 4) {
                iTransform = 0;
                if (bFlipHorizontally && bFlipVertically) {
                    iTransform = 3;
                } else if (bFlipHorizontally) {
                    iTransform = 1;
                } else if (bFlipVertically) {
                    iTransform = 2;
                }
            }
        }
        pGraphics.getMicroeditionGraphics().drawRegion(this.pImage, iRegionLeft, iRegionTop, iRegionWidth, iRegionHeight, iTransform, iLeft, iTop, 0);
    }

    public void drawScaledAtPoint(Graphics pGraphics, int iLeft, int iTop, int iDstW, int iDstH) {
        this.drawScaledAtPoint(pGraphics, iLeft, iTop, 0, 0, iDstW, iDstH, false, false);
    }

    public void drawScaledAtPoint(Graphics pGraphics, int iLeft, int iTop, int iReferencePixelX, int iReferencePixelY, int iScaleFactorX, int iScaleFactorY, boolean bFlipHorizontally, boolean bFlipVertically) {
        javax.microedition.lcdui.Image pTmpImage = this.getScaledImage(iScaleFactorX, iScaleFactorY);
        pGraphics.getMicroeditionGraphics().drawImage(pTmpImage, iLeft, iTop, 0);
    }

    public void drawScaledRegionAtPoint(Graphics pGraphics, int iLeft, int iTop, int iRegionLeft, int iRegionTop, int iRegionWidth, int iRegionHeight, int iScaleFactorX, int iScaleFactorY) {
        this.drawScaledRegionAtPoint(pGraphics, iLeft, iTop, iRegionLeft, iRegionTop, iRegionWidth, iRegionHeight, 0, 0, iScaleFactorX, iScaleFactorY, false, false);
    }

    public void drawScaledRegionAtPoint(Graphics pGraphics, int iLeft, int iTop, int iRegionLeft, int iRegionTop, int iRegionWidth, int iRegionHeight, int iReferencePixelX, int iReferencePixelY, int iScaleFactorX, int iScaleFactorY, boolean bFlipHorizontally, boolean bFlipVertically) {
        int iFramesX = this.iWidth / iRegionWidth;
        int iFramesY = this.iHeight / iRegionHeight;
        int iScaledRegionWidth = iRegionWidth * iScaleFactorX / 1000;
        int iScaledRegionHeight = iRegionHeight * iScaleFactorY / 1000;
        int iScaledWidth = iScaledRegionWidth * iFramesX;
        int iScaledHeight = iScaledRegionHeight * iFramesY;
        int iNewScaleFactorX = iScaledWidth * 1000 / this.iWidth;
        int iNewScaleFactorY = iScaledHeight * 1000 / this.iHeight;
        iScaledRegionWidth = iRegionWidth * iNewScaleFactorX / 1000;
        iScaledRegionHeight = iRegionHeight * iNewScaleFactorY / 1000;
        iScaledWidth = iScaledRegionWidth * iFramesX;
        iScaledHeight = iScaledRegionHeight * iFramesY;
        iLeft -= iReferencePixelX * iScaleFactorX / 1000;
        iTop -= iReferencePixelY * iScaleFactorY / 1000;
        javax.microedition.lcdui.Image pTmpImage = this.getScaledImage(iNewScaleFactorX, iNewScaleFactorY);
        int iTransform = 0;
        if (pGraphics.pScreen != null && Application.getSingleton().getDevice().getScreen().getOrientation() == 1) {
            int iTmp = iTop;
            iTop = iLeft;
            iLeft = pGraphics.getHeight() - iTmp - iScaledRegionHeight;
            iTransform = 5;
        }
        pGraphics.getMicroeditionGraphics().drawRegion(pTmpImage, iRegionLeft * iNewScaleFactorX / 1000, iRegionTop * iNewScaleFactorY / 1000, iScaledRegionWidth, iScaledRegionHeight, iTransform, iLeft, iTop, 0);
    }

    private javax.microedition.lcdui.Image getScaledImage(int iScaleFactorX, int iScaleFactorY) {
        if (iScaleFactorX == 1000 && iScaleFactorY == 1000) {
            return this.pImage;
        }
        if (this.mapScaledImages == null) {
            this.mapScaledImages = new Hashtable();
        }
        pTmpStringBuffer.setLength(0);
        pTmpStringBuffer.append(iScaleFactorX);
        pTmpStringBuffer.append("x");
        pTmpStringBuffer.append(iScaleFactorY);
        javax.microedition.lcdui.Image pRetVal = (javax.microedition.lcdui.Image)this.mapScaledImages.get(pTmpStringBuffer.toString());
        if (pRetVal == null) {
            pRetVal = ImageScaler.resizeImage(this.pImage, iScaleFactorX, iScaleFactorY, 0);
            this.mapScaledImages.put(pTmpStringBuffer.toString(), pRetVal);
        }
        return pRetVal;
    }
}

