/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.oldschoolracing;

import simple.core.Application;
import simple.input.Key;
import simple.input.Keys;
import simple.video.Graphics;
import simple.video.Image;
import sk.inlogic.oldschoolracing.Bonuses;
import sk.inlogic.oldschoolracing.CarPhysics;
import sk.inlogic.oldschoolracing.Environment;
import sk.inlogic.oldschoolracing.Generator;
import sk.inlogic.oldschoolracing.IScreen;
import sk.inlogic.oldschoolracing.Map;
import sk.inlogic.oldschoolracing.MyApplication;
import sk.inlogic.oldschoolracing.Obstacles;
import sk.inlogic.oldschoolracing.Profile;
import sk.inlogic.oldschoolracing.Resources;
import sk.inlogic.oldschoolracing.ScreenMenu;
import sk.inlogic.oldschoolracing.Sounds;
import sk.inlogic.oldschoolracing.Texts;
import sk.inlogic.oldschoolracing.Trails;
import sk.inlogic.oldschoolracing.VirtualPlayer;

public class ScreenGame
implements IScreen {
    public static int instrOffset;
    public static int instrMaxOffs;
    final int MODE_VOID;
    final int MODE_LOADINGRES;
    final int MODE_GAME;
    final int MODE_END_RACE;
    final int MODE_GAME_OVER;
    final int MODE_SEM_DOWN;
    final int MODE_SEMAFOR_COUNTDOWN;
    final int MODE_OPENING_MENU;
    final int MODE_CLOSING_MENU;
    final int MODE_INGAME_MENU;
    final int MODE_INSTRUCTIONS;
    final int MODE_UNLOCK_BONUS;
    static boolean somebodyNearCheck;
    public static int[] winners;
    public static int iWinCount;
    int iInstructionPage;
    int iTotalInstructionsPages = 3;
    public final int iFinalLapDur;
    public int iFinalBGWidth;
    public int iFinalBGXPos;
    public long iFinalStartTime;
    public static boolean bPaintFinal;
    public final int iBlickDurationMax;
    public long iBlickStart;
    public boolean bRedDam;
    public static int percLoaded;
    public Image imgHighLight;
    public int xPosTable;
    public int iYSemPos;
    public int startNr;
    public int iMenuParts;
    public int iSelectedInGameMenuItem;
    int iMode;
    long lTimer;
    long startTime;
    long finishTime;
    long lPauseTimeStart;
    long lTotalPauseTime = 0L;
    public static boolean bStarted;
    public static Environment env;
    public static int iXPos;
    public static int iYPos;
    public static boolean bCheckLap;
    MyApplication pMyApplication;
    public static CarPhysics playerCar;
    public static VirtualPlayer[] vPlay;
    public static int vPlayersNR;
    public static Bonuses bons;
    public static boolean bPressStart;
    public static boolean bPressedLeft;
    public static boolean bPressedRight;
    public static boolean bPressedBrake;
    public boolean go = true;
    long lastTime = 0L;

    public ScreenGame(int iCar, int iEnv, int iTrack) {
        int i;
        this.MODE_VOID = 0;
        this.MODE_LOADINGRES = 1;
        this.MODE_GAME = 2;
        this.MODE_END_RACE = 3;
        this.MODE_GAME_OVER = 4;
        this.MODE_SEM_DOWN = 5;
        this.MODE_SEMAFOR_COUNTDOWN = 6;
        this.MODE_OPENING_MENU = 7;
        this.MODE_CLOSING_MENU = 8;
        this.MODE_INGAME_MENU = 9;
        this.MODE_INSTRUCTIONS = 10;
        this.MODE_UNLOCK_BONUS = 11;
        this.iFinalLapDur = 3;
        this.iBlickDurationMax = 1;
        if (iTrack != 6) {
            vPlayersNR = 4;
        } else {
            if (iEnv == 3) {
                vPlayersNR = 1;
            }
            if (iEnv == 2) {
                vPlayersNR = 0;
            }
            if (iEnv == 1) {
                vPlayersNR = 4;
            }
        }
        bPressedLeft = false;
        bPressedRight = false;
        bPressedBrake = false;
        bPaintFinal = false;
        this.iSelectedInGameMenuItem = 0;
        percLoaded = 1;
        bPressStart = false;
        this.pMyApplication = MyApplication.getInstance();
        this.iMode = 1;
        this.pMyApplication.repaintScreen();
        Resources.loadCommonGameResources();
        bCheckLap = true;
        env = new Environment(iEnv, iTrack);
        iXPos = 0;
        iYPos = 0;
        bStarted = false;
        this.startTime = 0L;
        playerCar = vPlayersNR == 4 ? new CarPhysics(true, iCar + 1, 5) : (vPlayersNR == 1 ? new CarPhysics(true, iCar + 1, 2) : new CarPhysics(true, iCar + 1, 1));
        this.setHighLightImg(iCar + 1);
        if (vPlayersNR != 0) {
            VirtualPlayer.loadTrails(iEnv, iTrack);
        }
        vPlay = new VirtualPlayer[vPlayersNR];
        percLoaded = 70;
        this.pMyApplication.repaintScreen();
        for (i = 0; i < vPlayersNR; ++i) {
            int carType = Generator.getRandomUInt(6);
            while (!this.checkType(carType, i) || iCar + 1 == carType || carType <= 0) {
                carType = Generator.getRandomUInt(6);
            }
            System.out.println("generated: " + carType);
            ScreenGame.vPlay[i] = new VirtualPlayer(carType, 1 + i);
        }
        percLoaded = 100;
        this.pMyApplication.repaintScreen();
        bons = new Bonuses();
        bPressStart = true;
        this.setFinalBGWidth();
        if (iEnv == 1 && iTrack == 6) {
            ScreenGame.playerCar.iHitTimeDur = 20;
            for (i = 0; i < 4; ++i) {
                ScreenGame.vPlay[i].playerCar.iHitTimeDur = 20;
            }
        }
    }

    public void setFinalBGWidth() {
        int iTextW = Texts.getTextWidth(Texts.getString(55));
        this.iFinalBGWidth = iTextW / Resources.iFinalLapW / 2 + Resources.iFinalLapW * 2;
        this.iFinalBGXPos = -this.iFinalBGWidth;
        this.iFinalStartTime = 0L;
    }

    public void setHighLightImg(int car) {
        switch (car) {
            case 1: {
                this.imgHighLight = new Image("/1mh.png");
                break;
            }
            case 2: {
                this.imgHighLight = new Image("/2zh.png");
                break;
            }
            case 3: {
                this.imgHighLight = new Image("/3zh.png");
                break;
            }
            case 4: {
                this.imgHighLight = new Image("/4ch.png");
                break;
            }
            case 5: {
                this.imgHighLight = new Image("/5hh.png");
            }
        }
    }

    public boolean checkType(int type, int count) {
        for (int i = 0; i < count; ++i) {
            if (ScreenGame.playerCar.iCar == type) {
                return false;
            }
            if (ScreenGame.vPlay[i].playerCar.iCar != type) continue;
            return false;
        }
        return true;
    }

    public static void waiter() {
        int start = (int)System.currentTimeMillis() / 1000;
        int end = (int)System.currentTimeMillis() / 1000;
        while (end - start < 1) {
            end = (int)System.currentTimeMillis() / 1000;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void update(long tick) {
        if (System.currentTimeMillis() - this.lastTime > 1500L && this.lastTime != 0L && this.iMode == 2) {
            MyApplication.getInstance().onPause();
        }
        this.lastTime = System.currentTimeMillis();
        switch (this.iMode) {
            case 7: {
                ScreenGame.bPressedLeft = false;
                ScreenGame.bPressedRight = false;
                ScreenGame.bPressedBrake = false;
                partsYOp = Resources.iScreenH / Resources.iBorderH - 4;
                if (this.iMenuParts == partsYOp) {
                    this.iMode = 9;
                    break;
                }
                ++this.iMenuParts;
                break;
            }
            case 8: {
                if (this.iMenuParts == 2) {
                    if (this.iSelectedInGameMenuItem == 0) {
                        this.iMode = 2;
                        this.lTotalPauseTime += System.currentTimeMillis() - this.lPauseTimeStart;
                    }
                    if (this.iSelectedInGameMenuItem == 1) {
                        this.iMode = 5;
                    }
                    if (this.iSelectedInGameMenuItem == 2) {
                        this.setCarSelecting();
                    }
                    if (this.iSelectedInGameMenuItem == 3) {
                        this.setMainMenu();
                    }
                    if (Profile.bMusic) {
                        Sounds.playGameStageMusic(0L);
                        break;
                    }
                    Sounds.stopMusic();
                    break;
                }
                --this.iMenuParts;
                break;
            }
            case 6: {
                ScreenGame.waiter();
                --this.startNr;
                if (this.startNr == 0) {
                    this.iMode = 2;
                    this.startRace();
                }
                ScreenGame.playerCar.move(false, ScreenGame.bPressedBrake, ScreenGame.bPressedLeft, ScreenGame.bPressedRight);
                for (i = 0; i < ScreenGame.vPlayersNR; ++i) {
                    ScreenGame.vPlay[i].operateCar();
                }
                break;
            }
            case 5: {
                this.iYSemPos += Resources.iBorderH / 4;
                if (this.iYSemPos >= Resources.iSBarBGH) {
                    this.iYSemPos = Resources.iSBarBGH;
                    this.iMode = 6;
                    this.startNr = 3;
                }
                ScreenGame.playerCar.move(false, ScreenGame.bPressedBrake, ScreenGame.bPressedLeft, ScreenGame.bPressedRight);
                for (i = 0; i < ScreenGame.vPlayersNR; ++i) {
                    ScreenGame.vPlay[i].operateCar();
                }
                break;
            }
            case 2: {
                this.updateModeGame();
                ScreenGame.playerCar.move(ScreenGame.bStarted, ScreenGame.bPressedBrake, ScreenGame.bPressedLeft, ScreenGame.bPressedRight);
                if (ScreenGame.bCheckLap && !ScreenGame.playerCar.bFinish) {
                    ScreenGame.somebodyNearCheck = true;
                    if (ScreenGame.playerCar.checkLap()) {
                        ScreenGame.bCheckLap = false;
                        ScreenGame.somebodyNearCheck = false;
                        if (ScreenGame.playerCar.iLap == 1) {
                            this.startTime = System.currentTimeMillis();
                            this.lTotalPauseTime = 0L;
                        }
                        if (ScreenGame.playerCar.iLap == 4) {
                            this.finishTime = System.currentTimeMillis();
                            ScreenGame.playerCar.iLap = 3;
                            ScreenGame.playerCar.bFinish = true;
                            ScreenGame.playerCar.iFinishPos = ScreenGame.playerCar.iPosition;
                        }
                        if (Environment.iTrack == 6 && ScreenGame.playerCar.iLap == 2) {
                            this.finishTime = System.currentTimeMillis();
                            ScreenGame.playerCar.iLap = 1;
                            ScreenGame.playerCar.bFinish = true;
                            ScreenGame.playerCar.iFinishPos = ScreenGame.playerCar.iPosition;
                        }
                        ScreenGame.bCheckLap = false;
                    }
                } else {
                    ScreenGame.bCheckLap = ScreenGame.playerCar.canHumanCheck();
                }
                if (ScreenGame.playerCar.iCarState >= 20) ** GOTO lbl98
                x = ScreenGame.iXPos - Resources.iBonsW * 2;
                y = ScreenGame.iYPos - Resources.iBonsW * 2;
                width = Resources.iScreenW + Resources.iBonsW * 4;
                height = Resources.iBonsW * 4 + Resources.iScreenH;
                if (x <= 0) {
                    x = 1;
                }
                if (y <= 0) {
                    y = 1;
                }
                if (Bonuses.Bonuses[0].iXPos <= x) ** GOTO lbl94
                if (Bonuses.Bonuses[0].iXPos < x + width) ** GOTO lbl98
lbl94:
                // 2 sources

                if (Bonuses.Bonuses[0].iYPos <= y) ** GOTO lbl97
                if (Bonuses.Bonuses[0].iYPos < y + height) ** GOTO lbl98
lbl97:
                // 2 sources

                ScreenGame.bons.generatePosition(x, y, width, height);
lbl98:
                // 5 sources

                for (i = 0; i < ScreenGame.vPlayersNR; ++i) {
                    ScreenGame.vPlay[i].operateCar();
                }
                if (ScreenGame.vPlayersNR != 0) {
                    this.sortCars();
                }
                if (ScreenGame.vPlayersNR == 0) {
                    this.checkEndBonus2();
                } else if (ScreenGame.vPlayersNR == 1) {
                    this.checkEndBonus3();
                } else {
                    this.checkEnd();
                }
                if (ScreenGame.playerCar.iCarState <= 50) {
                    if (this.iBlickStart == 0L) {
                        this.iBlickStart = System.currentTimeMillis();
                    }
                    if ((iBlNow = System.currentTimeMillis()) / 1000L - this.iBlickStart / 1000L < 1L) break;
                    this.iBlickStart = System.currentTimeMillis();
                    this.bRedDam = this.bRedDam == false;
                    break;
                }
                this.iBlickStart = 0L;
                this.bRedDam = false;
                break;
            }
            case 3: {
                this.updateModeGame();
                ScreenGame.bPressedBrake = false;
                ScreenGame.bPressedLeft = false;
                ScreenGame.bPressedRight = false;
                ScreenGame.playerCar.move(ScreenGame.bStarted, false, false, false);
                for (i = 0; i < ScreenGame.vPlayersNR; ++i) {
                    ScreenGame.vPlay[i].operateCar();
                }
                partsX = Resources.iScreenW / Resources.iBorderW - Resources.MINUS_MAIN_X_PARTS;
                if (this.xPosTable < (Resources.iScreenW - Resources.iBorderW * partsX) / 2) {
                    this.xPosTable += Resources.iBorderW / 2 + Resources.iBorderW / 4;
                    break;
                }
                this.xPosTable = (Resources.iScreenW - Resources.iBorderW * partsX) / 2;
                this.iMode = 4;
                this.setWinnerPositions();
            }
        }
        this.pMyApplication.repaintScreen();
    }

    public void setWinnerPositions() {
        int i;
        if (vPlayersNR != 4) {
            return;
        }
        for (i = 0; i < vPlayersNR; ++i) {
            ScreenGame.vPlay[i].playerCar.iFinishPos = 5;
        }
        ScreenGame.playerCar.iFinishPos = 5;
        for (i = 2; i >= 0; --i) {
            if (winners[i] == vPlayersNR + 1) {
                ScreenGame.playerCar.iFinishPos = i + 1;
                continue;
            }
            ScreenGame.vPlay[ScreenGame.winners[i] - 1].playerCar.iFinishPos = i + 1;
        }
    }

    public void saveTracks() {
        long time = this.finishTime - this.startTime - this.lTotalPauseTime;
        int seconds = (int)(time / 1000L) % 60;
        int minutes = (int)(time / 60000L % 60L);
        if (vPlayersNR == 1) {
            int meds = 0;
            if (ScreenGame.playerCar.iFinishPos == 1) {
                meds = 3;
            }
            if (meds > Profile.envs[Environment.iEnv - 1].tracks[Environment.iTrack - 1].iMedals) {
                Profile.envs[Environment.iEnv - 1].tracks[Environment.iTrack - 1].iMedals = meds;
            }
            if (minutes * 60 + seconds < Profile.envs[Environment.iEnv - 1].tracks[Environment.iTrack - 1].seconds) {
                Profile.envs[Environment.iEnv - 1].tracks[Environment.iTrack - 1].sBestTime = seconds < 10 ? minutes + ":0" + seconds : minutes + ":" + seconds;
                Profile.envs[Environment.iEnv - 1].tracks[Environment.iTrack - 1].seconds = minutes * 60 + seconds;
            } else if (Profile.envs[Environment.iEnv - 1].tracks[Environment.iTrack - 1].seconds == 0) {
                Profile.envs[Environment.iEnv - 1].tracks[Environment.iTrack - 1].sBestTime = seconds < 10 ? minutes + ":0" + seconds : minutes + ":" + seconds;
                Profile.envs[Environment.iEnv - 1].tracks[Environment.iTrack - 1].seconds = minutes * 60 + seconds;
            }
        } else if (ScreenGame.playerCar.iFinishPos < 4) {
            if (Environment.iTrack < 5) {
                Profile.envs[Environment.iEnv - 1].tracks[Environment.iTrack].bUnlocked = true;
            } else if (Environment.iEnv != 3) {
                Profile.envs[Environment.iEnv].tracks[0].bUnlocked = true;
            }
            if (4 - ScreenGame.playerCar.iFinishPos > Profile.envs[Environment.iEnv - 1].tracks[Environment.iTrack - 1].iMedals) {
                Profile.envs[Environment.iEnv - 1].tracks[Environment.iTrack - 1].iMedals = 4 - ScreenGame.playerCar.iFinishPos;
            }
            if (minutes * 60 + seconds < Profile.envs[Environment.iEnv - 1].tracks[Environment.iTrack - 1].seconds) {
                Profile.envs[Environment.iEnv - 1].tracks[Environment.iTrack - 1].sBestTime = seconds < 10 ? minutes + ":0" + seconds : minutes + ":" + seconds;
                Profile.envs[Environment.iEnv - 1].tracks[Environment.iTrack - 1].seconds = minutes * 60 + seconds;
            } else if (Profile.envs[Environment.iEnv - 1].tracks[Environment.iTrack - 1].seconds == 0) {
                Profile.envs[Environment.iEnv - 1].tracks[Environment.iTrack - 1].sBestTime = seconds < 10 ? minutes + ":0" + seconds : minutes + ":" + seconds;
                Profile.envs[Environment.iEnv - 1].tracks[Environment.iTrack - 1].seconds = minutes * 60 + seconds;
            }
        }
        Profile.save();
    }

    public void setCarSelecting() {
        Resources.releaseCommonGameResources();
        Resources.loadInitialResources();
        int selectedCar = ScreenGame.playerCar.iCar - 1;
        ScreenGame.playerCar.sprCar = null;
        playerCar = null;
        for (int i = 0; i < vPlayersNR; ++i) {
            ScreenGame.vPlay[i].playerCar.sprCar = null;
        }
        vPlay = null;
        Trails.trails.removeAllElements();
        Map.checks.removeAllElements();
        Map.tilesMatrix = null;
        Obstacles.obs.removeAllElements();
        Obstacles.trees.removeAllElements();
        Obstacles.colisions.removeAllElements();
        Obstacles.defects.removeAllElements();
        Obstacles.specRoads.removeAllElements();
        int selectedEnv = Map.envir;
        env = null;
        this.imgHighLight = null;
        System.gc();
        MyApplication.pScrMenu = new ScreenMenu();
        if (Profile.bMusic) {
            Sounds.playMenuMusic();
        } else {
            Sounds.stopMusic();
        }
        MyApplication.pActiveScreen = MyApplication.pScrMenu;
        MyApplication.pScrGame = null;
        System.gc();
        MyApplication.pScrMenu.updateModeLoadingRes();
        MyApplication.pScrMenu.prepareCarChooseMenuItems();
        MyApplication.pScrMenu.iSelectedCar = selectedCar;
        MyApplication.pScrMenu.getClass();
        MyApplication.pScrMenu.iMode = 12;
        this.pMyApplication.repaintScreen();
    }

    public void setMainMenu() {
        Resources.releaseCommonGameResources();
        Resources.loadInitialResources();
        int selectedCar = ScreenGame.playerCar.iCar - 1;
        ScreenGame.playerCar.sprCar = null;
        playerCar = null;
        for (int i = 0; i < vPlayersNR; ++i) {
            ScreenGame.vPlay[i].playerCar.sprCar = null;
        }
        vPlay = null;
        Trails.trails.removeAllElements();
        Map.checks.removeAllElements();
        Map.tilesMatrix = null;
        Obstacles.obs.removeAllElements();
        int selectedEnv = Map.envir;
        env = null;
        this.imgHighLight = null;
        System.gc();
        Resources.releaseSplashResources();
        MyApplication.pScrMenu = new ScreenMenu();
        if (Profile.bMusic) {
            Sounds.playMenuMusic();
        } else {
            Sounds.stopMusic();
        }
        MyApplication.pActiveScreen = MyApplication.pScrMenu;
        MyApplication.pScrGame = null;
        System.gc();
        this.iMode = 0;
        this.pMyApplication.repaintScreen();
    }

    public void startRace() {
        bStarted = true;
        VirtualPlayer.setUp(true);
        winners = new int[3];
        iWinCount = 0;
        somebodyNearCheck = false;
    }

    public void checkEndBonus2() {
        if (ScreenGame.playerCar.bFinish) {
            this.iMode = 3;
            ScreenGame.playerCar.bHuman = false;
            int partsX = Resources.iScreenW / Resources.iBorderW - Resources.MINUS_MAIN_X_PARTS;
            this.xPosTable = -Resources.iBorderW * partsX;
        }
    }

    public void checkEndBonus3() {
        int i;
        if (ScreenGame.playerCar.bFinish) {
            boolean playerInTable = false;
            for (int i2 = 0; i2 < vPlayersNR; ++i2) {
                if (ScreenGame.vPlay[i2].playerCar.bFinish) continue;
                ScreenGame.vPlay[i2].playerCar.bFinish = true;
                ScreenGame.vPlay[i2].playerCar.iFinishPos = ScreenGame.vPlay[i2].playerCar.iPosition;
            }
            if (iWinCount < 3) {
                if (!playerInTable) {
                    ScreenGame.winners[ScreenGame.iWinCount] = ScreenGame.playerCar.ID;
                    ++iWinCount;
                    playerInTable = true;
                }
                int pos = 2;
                while (iWinCount == 1) {
                    for (int j = 0; j < vPlayersNR; ++j) {
                        if (ScreenGame.vPlay[j].playerCar.iPosition != pos) continue;
                        ScreenGame.winners[ScreenGame.iWinCount] = ScreenGame.vPlay[j].playerCar.ID;
                        ++iWinCount;
                        j = vPlayersNR;
                    }
                    if (iWinCount != 1 || ++pos != 5) continue;
                    ScreenGame.winners[ScreenGame.iWinCount] = ScreenGame.vPlay[0].playerCar.ID;
                    ++iWinCount;
                }
            }
            this.iMode = 3;
            ScreenGame.playerCar.bHuman = false;
            int partsX = Resources.iScreenW / Resources.iBorderW - Resources.MINUS_MAIN_X_PARTS;
            this.xPosTable = -Resources.iBorderW * partsX;
            return;
        }
        boolean bTmp = true;
        for (i = 0; i < vPlayersNR; ++i) {
            if (ScreenGame.vPlay[i].playerCar.bFinish) continue;
            bTmp = false;
        }
        if (bTmp) {
            ScreenGame.playerCar.bFinish = true;
            for (i = 0; i < vPlayersNR; ++i) {
                if (ScreenGame.vPlay[i].playerCar.bFinish) continue;
                ScreenGame.vPlay[i].playerCar.bFinish = true;
                ScreenGame.vPlay[i].playerCar.iFinishPos = ScreenGame.vPlay[i].playerCar.iPosition;
            }
            ScreenGame.playerCar.iFinishPos = ScreenGame.playerCar.iPosition;
            this.iMode = 3;
            int partsX = Resources.iScreenW / Resources.iBorderW - Resources.MINUS_MAIN_X_PARTS;
            this.xPosTable = -Resources.iBorderW * partsX;
        }
    }

    public void checkEnd() {
        int i;
        if (ScreenGame.playerCar.bFinish) {
            boolean playerInTable = false;
            for (int i2 = 0; i2 < vPlayersNR; ++i2) {
                if (ScreenGame.vPlay[i2].playerCar.bFinish) continue;
                ScreenGame.vPlay[i2].playerCar.bFinish = true;
                ScreenGame.vPlay[i2].playerCar.iFinishPos = ScreenGame.vPlay[i2].playerCar.iPosition;
            }
            if (iWinCount < 3) {
                int j;
                if (!playerInTable) {
                    ScreenGame.winners[ScreenGame.iWinCount] = ScreenGame.playerCar.ID;
                    ++iWinCount;
                    playerInTable = true;
                }
                int pos = 2;
                while (iWinCount == 1) {
                    for (j = 0; j < vPlayersNR; ++j) {
                        if (ScreenGame.vPlay[j].playerCar.iPosition != pos) continue;
                        ScreenGame.winners[ScreenGame.iWinCount] = ScreenGame.vPlay[j].playerCar.ID;
                        ++iWinCount;
                        j = vPlayersNR;
                    }
                    if (iWinCount != 1 || ++pos != 5) continue;
                    ScreenGame.winners[ScreenGame.iWinCount] = ScreenGame.vPlay[0].playerCar.ID;
                    ++iWinCount;
                }
                pos = 3;
                while (iWinCount == 2) {
                    for (j = 0; j < vPlayersNR; ++j) {
                        if (ScreenGame.vPlay[j].playerCar.iPosition != pos) continue;
                        ScreenGame.winners[ScreenGame.iWinCount] = ScreenGame.vPlay[j].playerCar.ID;
                        ++iWinCount;
                        j = vPlayersNR;
                    }
                    if (iWinCount != 2 || ++pos != 5) continue;
                    ScreenGame.winners[ScreenGame.iWinCount] = ScreenGame.vPlay[1].playerCar.ID;
                    ++iWinCount;
                }
            }
            this.iMode = 3;
            ScreenGame.playerCar.bHuman = false;
            int partsX = Resources.iScreenW / Resources.iBorderW - Resources.MINUS_MAIN_X_PARTS;
            this.xPosTable = -Resources.iBorderW * partsX;
            return;
        }
        boolean bTmp = true;
        for (i = 0; i < vPlayersNR; ++i) {
            if (ScreenGame.vPlay[i].playerCar.bFinish) continue;
            bTmp = false;
        }
        if (bTmp) {
            ScreenGame.playerCar.bFinish = true;
            for (i = 0; i < vPlayersNR; ++i) {
                if (ScreenGame.vPlay[i].playerCar.bFinish) continue;
                ScreenGame.vPlay[i].playerCar.bFinish = true;
                ScreenGame.vPlay[i].playerCar.iFinishPos = ScreenGame.vPlay[i].playerCar.iPosition;
            }
            ScreenGame.playerCar.iFinishPos = ScreenGame.playerCar.iPosition;
            this.iMode = 3;
            int partsX = Resources.iScreenW / Resources.iBorderW - Resources.MINUS_MAIN_X_PARTS;
            this.xPosTable = -Resources.iBorderW * partsX;
        }
    }

    public void sortCars() {
        int i;
        int[] ids;
        CarPhysics[] arr;
        if (vPlayersNR == 1) {
            arr = new CarPhysics[]{playerCar, ScreenGame.vPlay[0].playerCar};
            ids = new int[]{1, 0};
        } else {
            arr = new CarPhysics[]{playerCar, ScreenGame.vPlay[3].playerCar, ScreenGame.vPlay[2].playerCar, ScreenGame.vPlay[1].playerCar, ScreenGame.vPlay[0].playerCar};
            ids = new int[]{4, 3, 2, 1, 0};
        }
        for (i = 1; i < vPlayersNR + 1; ++i) {
            for (int j = 0; j < vPlayersNR; ++j) {
                int iTmp;
                CarPhysics cTmp;
                if ((arr[j].iLap + 1) * 1000 + (arr[j].iCheckPointNR + 1) < (arr[j + 1].iLap + 1) * 1000 + (arr[j + 1].iCheckPointNR + 1)) {
                    cTmp = arr[j];
                    arr[j] = arr[j + 1];
                    arr[j + 1] = cTmp;
                    iTmp = ids[j];
                    ids[j] = ids[j + 1];
                    ids[j + 1] = iTmp;
                }
                if ((arr[j].iLap + 1) * 1000 + (arr[j].iCheckPointNR + 1) != (arr[j + 1].iLap + 1) * 1000 + (arr[j + 1].iCheckPointNR + 1) || !this.mustSwitch(arr, j)) continue;
                cTmp = arr[j];
                arr[j] = arr[j + 1];
                arr[j + 1] = cTmp;
                iTmp = ids[j];
                ids[j] = ids[j + 1];
                ids[j + 1] = iTmp;
            }
        }
        for (i = 0; i < vPlayersNR + 1; ++i) {
            if (ids[i] == vPlayersNR) {
                ScreenGame.playerCar.iPosition = i + 1;
                continue;
            }
            ScreenGame.vPlay[ids[i]].playerCar.iPosition = i + 1;
        }
    }

    public boolean mustSwitch(CarPhysics[] arr, int j) {
        return arr[j].iCheckPointLength > arr[j + 1].iCheckPointLength;
    }

    void updateModeGame() {
        long lTick = Application.getSingleton().getRealTicksPerUpdate();
        if (lTick > 99L) {
            lTick = 99L;
        }
        this.lTimer += lTick;
    }

    public void keyPressed(Key pKey) {
        switch (this.iMode) {
            case 1: {
                break;
            }
            case 4: {
                break;
            }
            case 2: {
                break;
            }
            case 9: {
                break;
            }
        }
    }

    private void keyPressedInstr(Key pKey) {
        if (pKey.iGameAction == 2) {
            --this.iInstructionPage;
            if (this.iInstructionPage < 0) {
                this.iInstructionPage += this.iTotalInstructionsPages;
            }
            this.prepareInstructions();
            this.pMyApplication.repaintScreen();
            return;
        }
        if (pKey.iGameAction == 5) {
            ++this.iInstructionPage;
            if (this.iInstructionPage > this.iTotalInstructionsPages - 1) {
                this.iInstructionPage -= this.iTotalInstructionsPages;
            }
            this.prepareInstructions();
            this.pMyApplication.repaintScreen();
            return;
        }
        if (pKey.iValue == Keys.KEY_FNRIGHT) {
            this.iMode = 9;
            this.pMyApplication.repaintScreen();
        }
    }

    private void keyPressedInGameMenu(Key pKey) {
        if (pKey.iGameAction == 6) {
            ++this.iSelectedInGameMenuItem;
            if (this.iSelectedInGameMenuItem == 5) {
                this.iSelectedInGameMenuItem = 0;
            }
        }
        if (pKey.iGameAction == 1) {
            --this.iSelectedInGameMenuItem;
            if (this.iSelectedInGameMenuItem == -1) {
                this.iSelectedInGameMenuItem = 4;
            }
        }
        if (pKey.iGameAction == 8) {
            switch (this.iSelectedInGameMenuItem) {
                case 0: {
                    this.iMode = 8;
                    break;
                }
                case 1: {
                    playerCar.restartCar(true);
                    for (int i = 0; i < vPlayersNR; ++i) {
                        ScreenGame.vPlay[i].playerCar.restartCar(false);
                        ScreenGame.vPlay[i].iStep = 0;
                        ScreenGame.vPlay[i].bCheckLap = true;
                        vPlay[i].resetFirstPoint();
                    }
                    bStarted = false;
                    bPaintFinal = false;
                    VirtualPlayer.setUp(false);
                    this.iMode = 8;
                    this.iYSemPos = -2 * Resources.iBorderH;
                    this.startNr = 3;
                    this.setFinalBGWidth();
                    break;
                }
                case 2: 
                case 3: {
                    this.iMode = 8;
                    break;
                }
                case 4: {
                    this.iInstructionPage = 0;
                    this.prepareInstructions();
                    this.iMode = 10;
                    this.pMyApplication.repaintScreen();
                }
            }
        }
    }

    private void prepareInstructions() {
        Resources.prepareMultiLineText(this.getInstructionPage(this.iInstructionPage));
        instrOffset = 0;
        int partsY = Resources.iScreenH / Resources.iBorderH - Resources.MINUS_MAIN_Y_PARTS;
        int iPosY = (Resources.iScreenH - Resources.iBorderH * partsY) / 2;
        int linePos = iPosY + (partsY - 1) * Resources.iBorderH - Resources.BG_LINE_OFFSET;
        int iY = iPosY + Resources.iIconsW / 2 + Resources.iIconsW / 6 + Resources.iIconsW;
        int iH = linePos - Resources.iIconsW - Resources.iIconsW / 2 - Resources.iIconsW / 6 - iY;
        int iLineItemH = Texts.getFontHeight();
        int iSize = Resources.vecMultipleLines.size();
        int iHeight = iLineItemH * iSize;
        int visibleLines = iH / iLineItemH;
        System.out.println("isize = " + iSize + ", visiblines = " + visibleLines + ", ilineitemH = " + iLineItemH);
        instrMaxOffs = (iSize - visibleLines) * iLineItemH;
    }

    String getInstructionPage(int iPage) {
        if (iPage == 0) {
            return Texts.getString(24);
        }
        if (iPage == 1) {
            return Texts.getString(51);
        }
        return Texts.getString(54);
    }

    private void keyPressedGame(Key pKey) {
        if (pKey.iValue == Keys.KEY_FNLEFT) {
            ScreenGame.playerCar.bReset = true;
        }
        if (pKey.iValue == Keys.KEY_FNRIGHT) {
            this.iMenuParts = 1;
            this.iMode = 7;
            Sounds.stopMusic();
            this.iSelectedInGameMenuItem = 0;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void keyPressedGameOver(Key pKey) {
        block5: {
            if (pKey.iValue != Keys.KEY_FNLEFT && pKey.iGameAction != 8) break block5;
            this.saveTracks();
            stars = 0;
            for (i = 0; i < 5; ++i) {
                stars += Profile.envs[Environment.iEnv - 1].tracks[i].iMedals;
            }
            if (stars != 15) ** GOTO lbl-1000
            if (!Profile.envs[Environment.iEnv - 1].tracks[5].bUnlocked) {
                this.iMode = 11;
                Resources.prepareMultiLineText(Texts.getString(44) + " " + Texts.getString(30) + Texts.getString(31));
                Profile.envs[Environment.iEnv - 1].tracks[5].bUnlocked = true;
            } else lbl-1000:
            // 2 sources

            {
                this.goBackToMenuAfterRace();
            }
        }
        if (pKey.iValue == Keys.KEY_FNRIGHT) {
            ScreenGame.playerCar.restartCar(true);
            for (i = 0; i < ScreenGame.vPlayersNR; ++i) {
                ScreenGame.vPlay[i].playerCar.restartCar(false);
                ScreenGame.vPlay[i].iStep = 0;
                ScreenGame.vPlay[i].bCheckLap = true;
                ScreenGame.vPlay[i].resetFirstPoint();
            }
            ScreenGame.bStarted = false;
            VirtualPlayer.setUp(false);
            this.iMode = 5;
            this.iYSemPos = -2 * Resources.iBorderH;
            this.startNr = 3;
            this.setFinalBGWidth();
        }
    }

    private void keyPressedLoading(Key pKey) {
        if (pKey.iValue == Keys.KEY_FNLEFT || pKey.iGameAction == 8) {
            this.iMode = 5;
            this.iYSemPos = -2 * Resources.iBorderH;
            this.startNr = 3;
            if (Profile.bMusic) {
                Sounds.playGameStageMusic(0L);
            } else {
                Sounds.stopMusic();
            }
        }
    }

    public void keyReleased(Key pKey) {
    }

    public void paintScreen(Graphics g) {
        switch (this.iMode) {
            case 5: 
            case 6: {
                this.paintModeGame(g);
                if (this.startNr > 1) {
                    this.paintHighLightCar(g);
                }
                this.paintSemafor(g);
                this.paintIcs(g);
                break;
            }
            case 1: {
                Resources.paintLoading(g, percLoaded, bPressStart);
                break;
            }
            case 2: {
                this.paintModeGame(g);
                if (vPlayersNR != 0) {
                    if (ScreenGame.vPlay[0].playerCar.iLap == 0) {
                        this.paintSemafor(g);
                    }
                } else if (ScreenGame.playerCar.iLap == 0) {
                    this.paintSemafor(g);
                }
                this.paintIcs(g);
                break;
            }
            case 3: 
            case 4: {
                this.paintModeGame(g);
                this.paintTableMove(g);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                this.paintModeGame(g);
                this.paintRaster(g);
                this.paintInGameMenu(g);
                break;
            }
            case 10: {
                this.paintModeInstructions(g);
                break;
            }
            case 11: {
                this.paintUnlockBonus(g);
            }
        }
    }

    void paintUnlockBonus(Graphics g) {
        int partsX = Resources.iScreenW / Resources.iBorderW - 2;
        int partsY = Resources.iScreenH / Resources.iBorderH - 6;
        Resources.paintBackground(g);
        Resources.paintMenuBG(partsX, partsY, g);
        int iLineItemH = Texts.getFontHeight();
        int iSize = Resources.vecMultipleLines.size();
        int iHeight = iLineItemH * (iSize + 2);
        int iPosX = Resources.iScreenW / 10;
        int iPosY = (Resources.iScreenH - (partsY - 2) * Resources.iBorderH) / 2;
        iPosY += (iHeight - iSize * iLineItemH) / 2;
        for (int i = 0; i < iSize; ++i) {
            String strText = (String)Resources.vecMultipleLines.elementAt(i);
            int iItemW = Texts.getTextWidth(strText);
            iPosX = (Resources.iScreenW - iItemW) / 2;
            Texts.drawTextAtPos(g, iPosX, iPosY - Texts.getFontHeight() / 2, strText);
            iPosY += iLineItemH;
        }
        Resources.paintLeftButton(g, partsY);
    }

    void paintModeInstructions(Graphics g) {
        int partsX = Resources.iScreenW / Resources.iBorderW - Resources.MINUS_MAIN_X_PARTS;
        int partsY = Resources.iScreenH / Resources.iBorderH - Resources.MINUS_MAIN_Y_PARTS;
        g.setColor(0);
        g.fillRect(0, 0, Resources.iScreenW, Resources.iScreenH);
        Resources.paintMenuBG(partsX, partsY, g);
        int iPosY = (Resources.iScreenH - Resources.iBorderH * partsY) / 2;
        int iPosX = (Resources.iScreenW - Resources.iBorderW * partsX) / 2;
        Resources.sprIcons.setFrame(4);
        Resources.sprIcons.setPosition(iPosX + Resources.iIconsW / 2 + Resources.iIconsW / 6, (Resources.iScreenH - Resources.iIconsH) / 2);
        Resources.sprIcons.paint(g);
        Resources.sprIcons.setFrame(4);
        Resources.sprIcons.setRotation(3);
        Resources.sprIcons.setPosition(Resources.iScreenW - iPosX - Resources.iIconsW - Resources.iIconsW / 2 - Resources.iIconsW / 6, (Resources.iScreenH - Resources.iIconsH) / 2);
        Resources.sprIcons.paintRotated(g);
        int linePos = iPosY + (partsY - 1) * Resources.iBorderH - Resources.BG_LINE_OFFSET;
        int iX = iPosX + Resources.iIconsW / 2 + Resources.iIconsW / 6 + Resources.iIconsW;
        int iY = iPosY + Resources.iIconsW / 2 + Resources.iIconsW / 6 + Resources.iIconsW;
        int iW = Resources.iScreenW - iPosX - Resources.iIconsW - Resources.iIconsW / 2 - Resources.iIconsW / 6 - iX;
        int iH = linePos - Resources.iIconsW - Resources.iIconsW / 2 - Resources.iIconsW / 6 - iY;
        int iLineItemH = Texts.getFontHeight();
        int iSize = Resources.vecMultipleLines.size();
        int iHeight = iLineItemH * iSize;
        if (iHeight > iH) {
            Resources.sprIcons.setFrame(4);
            Resources.sprIcons.setRotation(2);
            Resources.sprIcons.setPosition((Resources.iScreenW - Resources.iIconsW) / 2, iPosY + Resources.iIconsW / 2 + Resources.iIconsW / 6);
            Resources.sprIcons.paintRotated(g);
            Resources.sprIcons.setFrame(4);
            Resources.sprIcons.setRotation(4);
            Resources.sprIcons.setPosition((Resources.iScreenW - Resources.iIconsW) / 2, linePos - Resources.iIconsW - Resources.iIconsW / 2 - Resources.iIconsW / 6);
            Resources.sprIcons.paintRotated(g);
        }
        Resources.sprIcons.setRotation(1);
        g.setClipRegion(iX, iY, iW, iH);
        iPosX = iX + Resources.iIconsW / 2;
        iPosY = iY + Resources.iIconsW / 2;
        for (int i = 0; i < iSize; ++i) {
            String strText = (String)Resources.vecMultipleLines.elementAt(i);
            int iItemW = Texts.getTextWidth(strText);
            iPosX = (Resources.iScreenW - iItemW) / 2;
            Texts.drawTextAtPos(g, iPosX, iPosY - Texts.getFontHeight() / 2 - instrOffset, strText);
            iPosY += iLineItemH;
        }
        g.setClipRegion(0, 0, Resources.iScreenW, Resources.iScreenH);
        Resources.paintRightButton(g, partsY);
    }

    void paintHighLightCar(Graphics g) {
        int rot = 0;
        if (Map.iStartLineRot == 1) {
            rot = 1;
        }
        if (Map.iStartLineRot == 2) {
            rot = 2;
        }
        if (Map.iStartLineRot == 3) {
            rot = 3;
        }
        if (Map.iStartLineRot == 4) {
            rot = 4;
        }
        this.imgHighLight.drawRotatedAtPoint(g, -iXPos + ScreenGame.playerCar.iXposMap, -iYPos + ScreenGame.playerCar.iYposMap, false, false, rot);
    }

    void paintIcs(Graphics g) {
        Resources.sprGameIcs.setFrame(1);
        Resources.sprGameIcs.setPosition(0 + Resources.iGameIcsW / 2, (Resources.iSBarBGH - Resources.iGameIcsH) / 2);
        Resources.sprGameIcs.paint(g);
        Resources.sprGameIcs.setFrame(0);
        Resources.sprGameIcs.setPosition(Resources.iScreenW - Resources.iGameIcsW - Resources.iGameIcsW / 2, (Resources.iSBarBGH - Resources.iGameIcsH) / 2);
        Resources.sprGameIcs.paint(g);
    }

    void paintInGameMenu(Graphics g) {
        int partsX = Resources.iScreenW / Resources.iBorderW - Resources.MINUS_MAIN_X_PARTS;
        Resources.paintInGameMenuBG(partsX, this.iMenuParts, g);
        if (this.iMode != 9) {
            return;
        }
        int iPosY = (Resources.iScreenH - Resources.iBorderH * (this.iMenuParts - 1)) / 2;
        int offset = Resources.iSelectH / 5;
        int height = 5 * (Resources.iSelectH + offset);
        int y = (Resources.iScreenH - height) / 2;
        String[] Text = new String[]{Texts.getString(23), Texts.getString(48), Texts.getString(49), Texts.getString(50), Texts.getString(11)};
        for (int i = 0; i < 5; ++i) {
            Resources.imgSelect.drawAtPoint(g, (Resources.iScreenW - Resources.iSelectW) / 2, y + i * (offset + Resources.iSelectH));
            int iTextW = Texts.getTextWidth(Text[i]);
            if (Texts.iLanguage != 0) {
                iTextW = Texts.getTextWidth(Text[i].toUpperCase());
            }
            if (Texts.iLanguage == 0) {
                Texts.drawTextAtPos(g, (Resources.iScreenW - iTextW) / 2, y + i * (offset + Resources.iSelectH) + (Resources.iSelectH - Texts.getFontHeight()) / 2, Text[i]);
                continue;
            }
            Texts.drawTextAtPos(g, (Resources.iScreenW - iTextW) / 2, y + i * (offset + Resources.iSelectH) + (Resources.iSelectH - Texts.getFontHeight()) / 2, Text[i].toUpperCase());
        }
    }

    void paintSemafor(Graphics g) {
        int x = (Resources.iScreenW - Resources.iBorderW * 3) / 2;
        int buttonFrame = 0;
        for (int j = 0; j < 3; ++j) {
            if (j > 0) {
                buttonFrame = 1;
            }
            if (j >= 2) {
                buttonFrame = 2;
            }
            Resources.sprSBar.setFrame(buttonFrame);
            Resources.sprSBar.setPosition(x + j * Resources.iSBarW, this.iYSemPos);
            Resources.sprSBar.paint(g);
        }
        int offsetY = (Resources.iSBarH - Resources.iIconsH) / 2;
        int offsetX = (Resources.iSBarW * 3 - (Resources.iIconsW + Resources.DOTS_OFFSET) * 3) / 2;
        int xLight = 0;
        for (int j = 0; j < 3; ++j) {
            xLight = x + offsetX + j * (Resources.iSemLightsW + Resources.DOTS_OFFSET);
            if (j == 0) {
                xLight -= Resources.DOTS_OFFSET;
            }
            if (j == 2) {
                xLight += Resources.DOTS_OFFSET;
            }
            Resources.sprIcons.setFrame(12);
            Resources.sprIcons.setPosition(xLight, this.iYSemPos + offsetY);
            Resources.sprIcons.paint(g);
            if (!(this.startNr == 2 && j == 0 || this.startNr == 1 && j < 2) && this.startNr != 0) continue;
            Resources.sprSemLights.setFrame(0);
            if (this.startNr == 0 && j == 2) {
                Resources.sprSemLights.setFrame(1);
            }
            Resources.sprSemLights.setPosition(xLight, this.iYSemPos + offsetY);
            Resources.sprSemLights.paint(g);
        }
    }

    void paintTableMove(Graphics g) {
        int j;
        int i;
        String[] Text;
        int y;
        int x;
        int iconOffset;
        int offset;
        int iPosY;
        int iPosX;
        int partsY;
        int partsX;
        block21: {
            block20: {
                block19: {
                    this.paintRaster(g);
                    partsX = Resources.iScreenW / Resources.iBorderW - Resources.MINUS_MAIN_X_PARTS;
                    partsY = Resources.iScreenH / Resources.iBorderH - Resources.MINUS_CHOOSE_Y_PARTS;
                    iPosX = (Resources.iScreenW - Resources.iBorderW * partsX) / 2;
                    iPosY = (Resources.iScreenH - Resources.iBorderH * partsY) / 2;
                    Resources.paintEndGame(partsX, partsY, this.xPosTable, iPosY, g);
                    Resources.imgEndGameBG.drawAtPoint(g, this.xPosTable + Resources.iBorderW + Resources.iBorderW / 2 - Resources.CHOOSE_MENU_OFFSET / 2, iPosY + Resources.iBorderH + Resources.iBorderH / 2);
                    Resources.sprEndGameFG.setPosition(this.xPosTable + Resources.iBorderW + Resources.iBorderW / 2 - Resources.CHOOSE_MENU_OFFSET / 2, iPosY + Resources.iBorderH + Resources.iBorderH / 2);
                    Resources.sprEndGameFG.setFrame(ScreenGame.playerCar.iFinishPos - 1);
                    if (ScreenGame.playerCar.iFinishPos - 1 > 3) {
                        Resources.sprEndGameFG.setFrame(3);
                    }
                    Resources.sprEndGameFG.paint(g);
                    offset = Resources.iBonsH + Resources.iIconsH / 2;
                    iconOffset = (offset - Resources.iBonsH) / 2;
                    x = this.xPosTable + Resources.iBorderW + Resources.iBorderW / 2 + Resources.iEndGameBGW + Resources.iBorderW + Resources.iBorderW / 2 - Resources.CHOOSE_MENU_OFFSET - Resources.CHOOSE_MENU_OFFSET / 2;
                    y = iPosY + Resources.iBorderH + Resources.iBorderH / 2;
                    if (Environment.iEnv == 2) break block19;
                    if (Environment.iTrack != 6) break block20;
                }
                if (Environment.iEnv == 3) break block21;
                if (Environment.iTrack == 6) break block21;
            }
            Text = this.getWinners();
            for (i = 0; i < 4; ++i) {
                iPosX = (Resources.iScreenW - Resources.iLineMW) / 2 - (Resources.iScreenW - Resources.iBorderW * partsX) / 2;
                Resources.imgLineM.drawAtPoint(g, x, y + i * offset);
                if (i == 3) continue;
                for (j = 0; j < 3; ++j) {
                    if (i == 0 || i == 1 && j < 2 || i == 2 && j == 0) {
                        Resources.sprIcons.setFrame(14);
                    } else {
                        Resources.sprIcons.setFrame(15);
                    }
                    Resources.sprIcons.setPosition(x + Resources.iLineMW - 3 * (Resources.iIconsW + Resources.DOTS_OFFSET) + j * (Resources.iIconsW + Resources.DOTS_OFFSET), y + i * offset + iconOffset + 1);
                    Resources.sprIcons.paint(g);
                }
                iPosX = (Resources.iScreenW - Resources.iLineMW) / 2 - (Resources.iScreenW - Resources.iBorderW * partsX) / 2;
                Texts.drawTextAtPos(g, x, y + i * offset + iconOffset + 1, i + 1 + ". " + Text[i]);
            }
        }
        if (Environment.iEnv == 3) {
            if (Environment.iTrack == 6) {
                Text = this.getWinnersBonus();
                if (winners[1] != ScreenGame.playerCar.iCar) {
                    Resources.sprEndGameFG.setFrame(4);
                }
                Resources.sprEndGameFG.paint(g);
                for (i = 0; i < 3; ++i) {
                    iPosX = (Resources.iScreenW - Resources.iLineMW) / 2 - (Resources.iScreenW - Resources.iBorderW * partsX) / 2;
                    Resources.imgLineM.drawAtPoint(g, x, y + i * offset);
                    if (i == 2) continue;
                    for (j = 0; j < 3; ++j) {
                        if (i == 0) {
                            Resources.sprIcons.setFrame(14);
                        } else {
                            Resources.sprIcons.setFrame(15);
                        }
                        Resources.sprIcons.setPosition(x + Resources.iLineMW - 3 * (Resources.iIconsW + Resources.DOTS_OFFSET) + j * (Resources.iIconsW + Resources.DOTS_OFFSET), y + i * offset + iconOffset + 1);
                        Resources.sprIcons.paint(g);
                    }
                    iPosX = (Resources.iScreenW - Resources.iLineMW) / 2 - (Resources.iScreenW - Resources.iBorderW * partsX) / 2;
                    Texts.drawTextAtPos(g, x, y + i * offset + iconOffset + 1, i + 1 + ". " + Text[i]);
                }
            }
        }
        iPosX = (Resources.iScreenW - Resources.iLineLW) / 2 - (Resources.iScreenW - Resources.iBorderW * partsX) / 2;
        Resources.imgLineL.drawAtPoint(g, this.xPosTable + iPosX, iPosY + (partsY - 1) * Resources.iBorderH - Resources.BG_LINE_OFFSET);
        iPosX = (Resources.iScreenW - Resources.iSelectW) / 2 - (Resources.iScreenW - Resources.iBorderW * partsX) / 2;
        if (this.iMode == 4) {
            Resources.paintLeftButton(g, partsY);
            Resources.paintRightButtonText(g, partsY, "Restart");
        }
        String sText = Texts.getString(32);
        if (ScreenGame.playerCar.iFinishPos < 4) {
            if (Environment.iTrack >= 5) {
                return;
            }
            sText = Texts.getString(30) + (Environment.iTrack + 1) + Texts.getString(31);
            if (Profile.envs[Environment.iEnv - 1].tracks[Environment.iTrack].bUnlocked) {
                return;
            }
        }
        Resources.imgSelect.drawAtPoint(g, x, iPosY + Resources.iBorderH + Resources.iBorderH / 2 + Resources.iEndGameBGH - Resources.iSelectH);
        int iTextW = Texts.getTextWidth(sText);
        iPosX = x + (Resources.iSelectW - iTextW) / 2;
        Texts.drawTextAtPos(g, iPosX, iPosY + Resources.iBorderH + Resources.iBorderH / 2 + Resources.iEndGameBGH - Resources.iSelectH + (Resources.iSelectH - Texts.getFontHeight()) / 2, sText);
    }

    public String[] getWinnersBonus() {
        String[] res = new String[2];
        for (int i = 0; i < 2; ++i) {
            res[i] = winners[i] == vPlayersNR + 1 ? this.getCarName(ScreenGame.playerCar.iCar) : this.getCarName(ScreenGame.vPlay[0].playerCar.iCar);
        }
        if (winners[0] == vPlayersNR) {
            res[1] = this.getCarName(ScreenGame.playerCar.iCar);
        }
        return res;
    }

    public String[] getWinners() {
        String[] res = new String[3];
        for (int i = 0; i < 3; ++i) {
            res[i] = winners[i] == vPlayersNR + 1 ? this.getCarName(ScreenGame.playerCar.iCar) : this.getCarName(ScreenGame.vPlay[ScreenGame.winners[i] - 1].playerCar.iCar);
        }
        return res;
    }

    public String getCarName(int id) {
        if (id == 1) {
            return "Falcon";
        }
        if (id == 2) {
            return "Arrow";
        }
        if (id == 3) {
            return "Wasp";
        }
        if (id == 4) {
            return "Legend";
        }
        if (id == 5) {
            return "Triumph";
        }
        return "";
    }

    public void paintRaster(Graphics g) {
        int x = 0;
        for (int y = 0; y <= Resources.iScreenH; y += Resources.iRasterH) {
            while (x <= Resources.iScreenW) {
                Resources.imgRaster.drawAtPoint(g, x, y);
                x += Resources.iRasterW;
            }
            x = 0;
        }
    }

    void paintModeGame(Graphics g) {
        int i;
        env.paintEnvironment(g);
        Environment.obsts.paintObstacles(g);
        if (ScreenGame.playerCar.bInSlip) {
            playerCar.paintSlip(g);
        }
        for (i = 0; i < vPlayersNR; ++i) {
            if (!ScreenGame.vPlay[i].playerCar.bInSlip) continue;
            ScreenGame.vPlay[i].playerCar.paintSlip(g);
        }
        playerCar.paintCar(g);
        for (i = 0; i < vPlayersNR; ++i) {
            ScreenGame.vPlay[i].playerCar.paintCar(g);
        }
        Environment.obsts.paintTrees(g);
        bons.paintBonuses(g);
        if (ScreenGame.playerCar.iBonusStart != 0L) {
            playerCar.paintTakenBonus(g);
        }
        if (bPaintFinal) {
            this.paintFinal(g);
        }
        if (vPlayersNR == 0 && ScreenGame.playerCar.iLap > 0) {
            this.paintTimeAttack(g);
        }
        this.paintStatusBar(g);
        this.paintControlArrs(g);
    }

    public void paintTimeAttack(Graphics g) {
        this.iFinalBGXPos = Resources.iScreenW / 2;
        for (int i = 0; i < this.iFinalBGWidth; ++i) {
            Resources.imgFinalLapBG.drawAtPoint(g, this.iFinalBGXPos + i * Resources.iFinalLapW, Resources.iSBarBGH);
            Resources.imgFinalLapBG.drawAtPoint(g, Resources.iScreenW - this.iFinalBGXPos - i * Resources.iFinalLapW, Resources.iSBarBGH);
        }
        long time = System.currentTimeMillis() - this.startTime;
        int seconds = (int)(time / 1000L) % 60;
        int minutes = (int)(time / 60000L % 60L);
        int iTextW = Texts.getTextWidth(minutes + " : " + seconds);
        int y = (Resources.iFinalLapH - Texts.getFontHeight()) / 2 + Resources.iSBarBGH;
        Texts.drawTextAtPos(g, (Resources.iScreenW - iTextW) / 2, y, minutes + " : " + seconds);
    }

    void paintControlArrs(Graphics g) {
        Resources.imgPlayArrow.drawAtPoint(g, Resources.iScreenW - Resources.iPlayArrowW - Resources.iPlayArrowW, Resources.iScreenH - Resources.iPlayArrowH - Resources.iPlayArrowH);
        Resources.imgPlayArrow.drawRotatedAtPoint(g, Resources.iPlayArrowW, Resources.iScreenH - Resources.iPlayArrowH - Resources.iPlayArrowH, false, false, 3);
        Resources.imgBrake.drawAtPoint(g, Resources.iScreenW - Resources.iPlayArrowW - Resources.iPlayArrowW, Resources.iScreenH - Resources.iPlayArrowH - Resources.iPlayArrowH * 2 - Resources.iBrakeH - Resources.iBrakeH / 2);
    }

    public void paintFinal(Graphics g) {
        for (int i = 0; i < this.iFinalBGWidth; ++i) {
            Resources.imgFinalLapBG.drawAtPoint(g, this.iFinalBGXPos + i * Resources.iFinalLapW, Resources.iSBarBGH);
            if (i == this.iFinalBGWidth - 1) continue;
            Resources.imgFinalLapBG.drawAtPoint(g, Resources.iScreenW - this.iFinalBGXPos - i * Resources.iFinalLapW, Resources.iSBarBGH);
        }
        if (this.iFinalBGXPos == Resources.iScreenW / 2 - this.iFinalBGWidth) {
            if (this.iFinalStartTime == 0L) {
                this.iFinalStartTime = System.currentTimeMillis();
            }
            long iTimeNow = System.currentTimeMillis();
            if (this.iFinalStartTime != 0L && iTimeNow / 1000L - this.iFinalStartTime / 1000L >= 3L) {
                bPaintFinal = false;
                this.iFinalStartTime = 0L;
            }
            int iTextW = Texts.getTextWidth(Texts.getString(55));
            int y = (Resources.iFinalLapH - Texts.getFontHeight()) / 2 + Resources.iSBarBGH;
            Texts.drawTextAtPos(g, (Resources.iScreenW - iTextW) / 2, y, Texts.getString(55));
        } else {
            this.iFinalBGXPos += Resources.iFinalLapW;
            if (this.iFinalBGXPos >= Resources.iScreenW / 2 - this.iFinalBGWidth) {
                this.iFinalBGXPos = Resources.iScreenW / 2 - this.iFinalBGWidth;
            }
        }
    }

    public void paintStatusBar(Graphics g) {
        int j;
        int parts = Resources.iScreenW / Resources.iSBarBGW;
        for (int i = 0; i <= parts; ++i) {
            Resources.imgSBarBG.drawAtPoint(g, Resources.iSBarW * i, 0);
        }
        int buttonFrame = 0;
        int partnr = parts / 2;
        if (Resources.iScreenH == 240) {
            partnr = parts / 2 + parts / 5;
        }
        if (Resources.iScreenW == 640) {
            partnr = parts / 2 + parts / 5;
        }
        int x = (Resources.iScreenW - partnr * Resources.iSBarW) / 2;
        int y = (Resources.iSBarBGH - Resources.iSBarH) / 2;
        for (j = 0; j < partnr; ++j) {
            if (j > 0) {
                buttonFrame = 1;
            }
            if (j >= partnr - 1) {
                buttonFrame = 2;
            }
            Resources.sprSBar.setFrame(buttonFrame);
            Resources.sprSBar.setPosition(x + j * Resources.iSBarW, y);
            Resources.sprSBar.paint(g);
        }
        y = (Resources.iSBarBGH - Resources.iSBIconsH) / 2;
        Resources.sprSBIcons.setFrame(0);
        Resources.sprSBIcons.setPosition(x += Resources.iSBarW + Resources.iSBarW / 4, y);
        Resources.sprSBIcons.paint(g);
        x += Resources.iSBIconsW + Resources.iSBIconsW / 5;
        y = (Resources.iSBarBGH - Texts.getFontHeight()) / 2;
        if (Environment.iTrack != 6) {
            Texts.drawTextAtPos(g, x, y, ScreenGame.playerCar.iLap + "/3");
        } else {
            Texts.drawTextAtPos(g, x, y, ScreenGame.playerCar.iLap + "/1");
        }
        y = (Resources.iSBarBGH - Resources.iSBIconsH) / 2;
        Resources.sprSBIcons.setFrame(1);
        Resources.sprSBIcons.setPosition(x += Resources.iSBarW + Resources.iSBarW / 3, y);
        Resources.sprSBIcons.paint(g);
        y = (Resources.iSBarBGH - Texts.getFontHeight()) / 2;
        Texts.drawTextAtPos(g, x += Resources.iSBIconsW + Resources.iSBIconsW / 3, y, ScreenGame.playerCar.iPosition + "/" + (vPlayersNR + 1));
        y = (Resources.iSBarBGH - Resources.iSBIconsH) / 2;
        Resources.sprSBIcons.setFrame(2);
        Resources.sprSBIcons.setPosition(x += Resources.iSBarW + Resources.iSBarW, y);
        Resources.sprSBIcons.paint(g);
        x += Resources.iSBIconsW + Resources.iSBIconsW / 3;
        y = (Resources.iSBarBGH - Resources.iDemBGH) / 2;
        buttonFrame = 0;
        for (j = 0; j < 15; ++j) {
            if (j > 0) {
                buttonFrame = 1;
            }
            if (j >= 14) {
                buttonFrame = 2;
            }
            Resources.sprDemBG.setFrame(buttonFrame);
            Resources.sprDemBG.setPosition(x + j * Resources.iDemBGW, y);
            Resources.sprDemBG.paint(g);
        }
        buttonFrame = 0;
        for (j = 0; j < ScreenGame.playerCar.iCarState / 10; ++j) {
            if (j > 0) {
                buttonFrame = 1;
            }
            if (j >= 14) {
                buttonFrame = 2;
            }
            if (!this.bRedDam) {
                Resources.sprDemFG.setFrame(buttonFrame);
                Resources.sprDemFG.setPosition(x + j * Resources.iDemFGW, y);
                Resources.sprDemFG.paint(g);
                continue;
            }
            Resources.sprDemFG2.setFrame(buttonFrame);
            Resources.sprDemFG2.setPosition(x + j * Resources.iDemFGW, y);
            Resources.sprDemFG2.paint(g);
        }
    }

    public void pointerPressed(int x, int y) {
        this.go = true;
        switch (this.iMode) {
            case 1: {
                if (!bPressStart) break;
                this.iMode = 5;
                this.iYSemPos = -2 * Resources.iBorderH;
                this.startNr = 3;
                break;
            }
            case 4: {
                this.pointerPressedGameOver(x, y);
                break;
            }
            case 2: {
                this.pointerPressedGame(x, y);
                break;
            }
            case 9: {
                this.pointerPressedInGameMenu(x, y);
                break;
            }
            case 10: {
                int partsY = Resources.iScreenH / Resources.iBorderH - Resources.MINUS_MAIN_Y_PARTS;
                int partsX = Resources.iScreenW / Resources.iBorderW - Resources.MINUS_MAIN_X_PARTS;
                if (Resources.pressedRightButton(x, y, partsX, partsY)) {
                    this.iMode = 9;
                    this.pMyApplication.repaintScreen();
                    return;
                }
                if (Resources.pressedInstrLeft(x, y)) {
                    --this.iInstructionPage;
                    if (this.iInstructionPage < 0) {
                        this.iInstructionPage += this.iTotalInstructionsPages;
                    }
                    this.prepareInstructions();
                    this.pMyApplication.repaintScreen();
                    return;
                }
                if (Resources.pressedInstrRight(x, y)) {
                    ++this.iInstructionPage;
                    if (this.iInstructionPage > this.iTotalInstructionsPages - 1) {
                        this.iInstructionPage -= this.iTotalInstructionsPages;
                    }
                    this.prepareInstructions();
                    this.pMyApplication.repaintScreen();
                    return;
                }
                if (Resources.pressedInstrDown(x, y)) {
                    int iLineItemH = Texts.getFontHeight();
                    if (instrOffset < instrMaxOffs) {
                        instrOffset += iLineItemH;
                    }
                    this.pMyApplication.repaintScreen();
                    return;
                }
                if (!Resources.pressedInstrUp(x, y)) break;
                int iLineItemH = Texts.getFontHeight();
                if (instrOffset > 0) {
                    instrOffset -= iLineItemH;
                }
                this.pMyApplication.repaintScreen();
                return;
            }
            case 11: {
                int partsY = Resources.iScreenH / Resources.iBorderH - Resources.MINUS_MAIN_Y_PARTS;
                int partsX = Resources.iScreenW / Resources.iBorderW - Resources.MINUS_MAIN_X_PARTS;
                if (!Resources.pressedLeftButton(x, y, partsX, Resources.iScreenH / Resources.iBorderH - 6)) break;
                this.goBackToMenuAfterRace();
                return;
            }
        }
    }

    public void pointerPressedInGameMenu(int iX, int iY) {
        this.iSelectedInGameMenuItem = Resources.whichSubMenuButton(iX, iY);
        switch (this.iSelectedInGameMenuItem) {
            case 0: {
                this.iMode = 8;
                break;
            }
            case 1: {
                playerCar.restartCar(true);
                for (int i = 0; i < vPlayersNR; ++i) {
                    ScreenGame.vPlay[i].playerCar.restartCar(false);
                    ScreenGame.vPlay[i].iStep = 0;
                    ScreenGame.vPlay[i].bCheckLap = true;
                    vPlay[i].resetFirstPoint();
                }
                bStarted = false;
                bPaintFinal = false;
                VirtualPlayer.setUp(false);
                this.iMode = 8;
                this.iYSemPos = -2 * Resources.iBorderH;
                this.startNr = 3;
                this.setFinalBGWidth();
                break;
            }
            case 2: {
                this.iMode = 8;
                break;
            }
            case 3: {
                this.iMode = 8;
                break;
            }
            case 4: {
                this.iInstructionPage = 0;
                this.prepareInstructions();
                this.iMode = 10;
                this.pMyApplication.repaintScreen();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void pointerPressedGameOver(int iX, int iY) {
        block5: {
            partsX = Resources.iScreenW / Resources.iBorderW - Resources.MINUS_MAIN_X_PARTS;
            partsY = Resources.iScreenH / Resources.iBorderH - Resources.MINUS_MAIN_Y_PARTS;
            if (!Resources.pressedLeftButton(iX, iY, partsX, partsY)) break block5;
            this.saveTracks();
            stars = 0;
            for (i = 0; i < 5; ++i) {
                stars += Profile.envs[Environment.iEnv - 1].tracks[i].iMedals;
            }
            if (stars != 15) ** GOTO lbl-1000
            if (!Profile.envs[Environment.iEnv - 1].tracks[5].bUnlocked) {
                this.iMode = 11;
                Resources.prepareMultiLineText(Texts.getString(44) + " " + Texts.getString(30) + Texts.getString(31));
                Profile.envs[Environment.iEnv - 1].tracks[5].bUnlocked = true;
            } else lbl-1000:
            // 2 sources

            {
                this.goBackToMenuAfterRace();
            }
        }
        if (Resources.pressedRightButtonRes(iX, iY, partsX, partsY)) {
            ScreenGame.playerCar.restartCar(true);
            for (i = 0; i < ScreenGame.vPlayersNR; ++i) {
                ScreenGame.vPlay[i].playerCar.restartCar(false);
                ScreenGame.vPlay[i].iStep = 0;
                ScreenGame.vPlay[i].bCheckLap = true;
                ScreenGame.vPlay[i].resetFirstPoint();
            }
            ScreenGame.bStarted = false;
            VirtualPlayer.setUp(false);
            this.iMode = 5;
            this.iYSemPos = -2 * Resources.iBorderH;
            this.startNr = 3;
            this.setFinalBGWidth();
        }
    }

    public void goBackToMenuAfterRace() {
        this.saveTracks();
        Resources.releaseCommonGameResources();
        Resources.loadInitialResources();
        int selectedEnv = Environment.iEnv;
        int selectedTrack = Environment.iTrack;
        int pos = ScreenGame.playerCar.iFinishPos;
        int selectedCar = ScreenGame.playerCar.iCar - 1;
        ScreenGame.playerCar.sprCar = null;
        playerCar = null;
        for (int i = 0; i < vPlayersNR; ++i) {
            ScreenGame.vPlay[i].playerCar.sprCar = null;
        }
        vPlay = null;
        Trails.trails.removeAllElements();
        Map.checks.removeAllElements();
        Map.tilesMatrix = null;
        Obstacles.obs.removeAllElements();
        env = null;
        this.imgHighLight = null;
        System.gc();
        MyApplication.pScrMenu = new ScreenMenu();
        Sounds.playMenuMusic();
        MyApplication.pActiveScreen = MyApplication.pScrMenu;
        MyApplication.pScrGame = null;
        System.gc();
        MyApplication.pScrMenu.updateModeLoadingRes();
        MyApplication.pScrMenu.iSelectedCar = selectedCar;
        ScreenMenu.iSelectedEnvir = selectedEnv - 1;
        MyApplication.pScrMenu.pMenuSystem.iSelectedMenuItem = selectedTrack - 1;
        MyApplication.pScrMenu.getClass();
        MyApplication.pScrMenu.iMode = 13;
        MyApplication.pScrMenu.prepareTrackChooseMenuItems();
        if (selectedTrack < 5 && pos < 4) {
            MyApplication.pScrMenu.pMenuSystem.iSelectedMenuItem = selectedTrack;
            ScreenMenu.iSelectedEnvir = selectedEnv - 1;
        } else if (selectedTrack == 5 && pos < 4) {
            ScreenMenu.iSelectedEnvir = selectedEnv;
            if (selectedEnv == 3) {
                ScreenMenu.iSelectedEnvir = selectedEnv - 1;
            }
            MyApplication.pScrMenu.pMenuSystem.iSelectedMenuItem = 0;
        }
        if (selectedTrack == 6) {
            ScreenMenu.iSelectedEnvir = selectedEnv - 1;
            MyApplication.pScrMenu.pMenuSystem.iSelectedMenuItem = 0;
        }
        this.pMyApplication.repaintScreen();
    }

    public void pointerPressedGame(int iX, int iY) {
        if (Resources.pressedPlayLeft(iX, iY)) {
            bPressedLeft = Resources.pressedPlayLeft(iX, iY);
            bPressedRight = false;
        }
        if (Resources.pressedPlayRight(iX, iY)) {
            bPressedRight = Resources.pressedPlayRight(iX, iY);
            bPressedLeft = false;
        }
        if (!bPressedBrake) {
            bPressedBrake = Resources.pressedPlayBrake(iX, iY);
        }
        if (Resources.pressedPause(iX, iY)) {
            this.iMenuParts = 1;
            this.iMode = 7;
            this.iSelectedInGameMenuItem = 0;
            this.lPauseTimeStart = System.currentTimeMillis();
        }
        if (Resources.pressedReset(iX, iY)) {
            ScreenGame.playerCar.bReset = true;
        }
    }

    public void pointerReleasedGame(int iX, int iY) {
        if (bPressedLeft) {
            if (Resources.pressedPlayLeft(iX, iY)) {
                bPressedLeft = false;
            } else if (!Resources.pressedPlayBrake(iX, iY) || !Resources.pressedPlayRight(iX, iY)) {
                bPressedRight = false;
            }
        }
        if (bPressedRight) {
            if (Resources.pressedPlayRight(iX, iY)) {
                bPressedRight = false;
            } else if (!Resources.pressedPlayLeft(iX, iY) || !Resources.pressedPlayBrake(iX, iY)) {
                bPressedRight = false;
            }
        }
        if (bPressedBrake) {
            if (Resources.pressedPlayBrake(iX, iY)) {
                bPressedBrake = false;
            } else if (!Resources.pressedPlayLeft(iX, iY) || !Resources.pressedPlayRight(iX, iY)) {
                bPressedBrake = false;
            }
        }
    }

    public void pointerReleased(int x, int y) {
        switch (this.iMode) {
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                this.pointerReleasedGame(x, y);
                break;
            }
            case 9: {
                break;
            }
        }
    }

    public void onPause() {
        if (this.iMode == 2) {
            this.lPauseTimeStart = System.currentTimeMillis();
        }
        int partsYOp = Resources.iScreenH / Resources.iBorderH - 4;
        this.iMode = 9;
        this.iMenuParts = partsYOp;
        bPressedBrake = false;
        bPressedLeft = false;
        bPressedRight = false;
    }

    public void onResume() {
        int partsYOp = Resources.iScreenH / Resources.iBorderH - 4;
        this.iMode = 9;
        this.iSelectedInGameMenuItem = 0;
        this.pMyApplication.repaintScreen();
    }

    static {
        iWinCount = 0;
    }
}

