/*
 * Decompiled with CFR 0.152.
 */
package simple.video;

import java.util.Stack;
import simple.video.GeomUtils;
import simple.video.Image;
import simple.video.Screen;

public class Graphics {
    public Screen pScreen;
    public Image pImage;
    private javax.microedition.lcdui.Graphics pGraphics;
    private int iSavedClipRegionX;
    private int iSavedClipRegionY;
    private int iSavedClipRegionWidth;
    private int iSavedClipRegionHeight;
    private static Stack pStack;

    public Graphics(Screen pScreen) {
        this.pScreen = pScreen;
        this.pImage = null;
        this.setClipRegion(0, 0, this.getWidth(), this.getHeight());
        this.setColor(0xFFFFFF);
    }

    public Graphics(Image pImage) {
        this.pScreen = null;
        this.pImage = pImage;
        this.pGraphics = pImage.getMicroeditionImage().getGraphics();
        this.setClipRegion(0, 0, this.getWidth(), this.getHeight());
        this.setColor(0xFFFFFF);
    }

    public javax.microedition.lcdui.Graphics getMicroeditionGraphics() {
        if (this.pImage != null) {
            return this.pGraphics;
        }
        return this.pScreen.getMicroeditionGraphics();
    }

    protected void finalize() throws Throwable {
    }

    public int getWidth() {
        if (this.pImage != null) {
            return this.pImage.getWidth();
        }
        return this.pScreen.getWidth();
    }

    public int getHeight() {
        if (this.pImage != null) {
            return this.pImage.getHeight();
        }
        return this.pScreen.getHeight();
    }

    public void setClipRegion(int iX, int iY, int iWidth, int iHeight) {
        if (this.pScreen != null && this.pScreen.getOrientation() == 1) {
            int iTmp = iY;
            iY = iX;
            iX = this.getHeight() - iTmp - iHeight;
            iTmp = iWidth;
            iWidth = iHeight;
            iHeight = iTmp;
        }
        if (iWidth < 0) {
            iWidth = 0;
        }
        if (iHeight < 0) {
            iHeight = 0;
        }
        this.getMicroeditionGraphics().setClip(iX, iY, iWidth, iHeight);
    }

    public void clipRegion(int iX, int iY, int iWidth, int iHeight) {
        if (this.pScreen != null && this.pScreen.getOrientation() == 1) {
            int iTmp = iY;
            iY = iX;
            iX = this.getHeight() - iTmp - iHeight;
            iTmp = iWidth;
            iWidth = iHeight;
            iHeight = iTmp;
        }
        this.getMicroeditionGraphics().clipRect(iX, iY, iWidth, iHeight);
    }

    public int getClipRegionX() {
        return this.getMicroeditionGraphics().getClipX();
    }

    public int getClipRegionY() {
        return this.getMicroeditionGraphics().getClipY();
    }

    public int getClipRegionWidth() {
        return this.getMicroeditionGraphics().getClipWidth();
    }

    public int getClipRegionHeight() {
        return this.getMicroeditionGraphics().getClipHeight();
    }

    public void saveClipRegion() {
        this.iSavedClipRegionX = this.getClipRegionX();
        this.iSavedClipRegionY = this.getClipRegionY();
        this.iSavedClipRegionWidth = this.getClipRegionWidth();
        this.iSavedClipRegionHeight = this.getClipRegionHeight();
    }

    public void restoreClipRegion() {
        this.getMicroeditionGraphics().setClip(this.iSavedClipRegionX, this.iSavedClipRegionY, this.iSavedClipRegionWidth, this.iSavedClipRegionHeight);
    }

    public void setColor(int iColorRGB) {
        this.getMicroeditionGraphics().setColor(iColorRGB);
    }

    public int getColor() {
        return this.getMicroeditionGraphics().getColor();
    }

    public int getColorRed() {
        return this.getMicroeditionGraphics().getRedComponent();
    }

    public int getColorGreen() {
        return this.getMicroeditionGraphics().getGreenComponent();
    }

    public int getColorBlue() {
        return this.getMicroeditionGraphics().getBlueComponent();
    }

    public void setColor(int iColorRed, int iColorGreen, int iColorBlue) {
        this.getMicroeditionGraphics().setColor(iColorRed, iColorGreen, iColorBlue);
    }

    public void drawArc(int iX, int iY, int iWidth, int iHeight, int iStartAngle, int iArcAngle) {
        if (this.pScreen != null && this.pScreen.getOrientation() == 1) {
            int iTmp = iY;
            iY = iX;
            iX = this.getHeight() - iTmp - iHeight;
            iTmp = iWidth;
            iWidth = iHeight;
            iHeight = iTmp;
        }
        this.getMicroeditionGraphics().drawArc(iX, iY, iWidth, iHeight, iStartAngle, iArcAngle);
    }

    public void drawLine(int iX1, int iY1, int iX2, int iY2) {
        if (this.pScreen != null && this.pScreen.getOrientation() == 1) {
            int iScreenH = this.getHeight();
            int iTmp = iY1;
            iY1 = iX1;
            iX1 = iScreenH - iTmp;
            iTmp = iY2;
            iY2 = iX2;
            iX2 = iScreenH - iTmp;
        }
        this.getMicroeditionGraphics().drawLine(iX1, iY1, iX2, iY2);
    }

    public void fillTriangle(int iX1, int iY1, int iX2, int iY2, int iX3, int iY3) {
        if (this.pScreen != null && this.pScreen.getOrientation() == 1) {
            int iScreenH = this.getHeight();
            int iTmp = iY1;
            iY1 = iX1;
            iX1 = iScreenH - iTmp;
            iTmp = iY2;
            iY2 = iX2;
            iX2 = iScreenH - iTmp;
            iTmp = iY3;
            iY3 = iX3;
            iX3 = iScreenH - iTmp;
        }
        this.getMicroeditionGraphics().fillTriangle(iX1, iY1, iX2, iY2, iX3, iY3);
    }

    public void fillRect(int iX, int iY, int iWidth, int iHeight) {
        if (this.pScreen != null && this.pScreen.getOrientation() == 1) {
            int iTmp = iY;
            iY = iX;
            iX = this.getHeight() - iTmp - iHeight;
            iTmp = iWidth;
            iWidth = iHeight;
            iHeight = iTmp;
        }
        this.getMicroeditionGraphics().fillRect(iX, iY, iWidth, iHeight);
    }

    public void drawRect(int iX, int iY, int iWidth, int iHeight) {
        if (this.pScreen != null && this.pScreen.getOrientation() == 1) {
            int iTmp = iY;
            iY = iX;
            iX = this.getHeight() - iTmp - iHeight;
            iTmp = iWidth;
            iWidth = iHeight;
            iHeight = iTmp;
        }
        this.getMicroeditionGraphics().drawRect(iX, iY, iWidth, iHeight);
    }

    public void drawPoly(int[] xPoints, int[] yPoints) {
        int i;
        int[] aiX = xPoints;
        int[] aiY = yPoints;
        if (this.pScreen != null && this.pScreen.getOrientation() == 1) {
            aiY = new int[xPoints.length];
            System.arraycopy(xPoints, 0, aiY, 0, xPoints.length);
            aiX = new int[yPoints.length];
            System.arraycopy(yPoints, 0, aiX, 0, yPoints.length);
            int iH = this.getHeight();
            for (i = aiX.length - 1; i >= 0; --i) {
                aiX[i] = iH - aiX[i];
            }
        }
        int iLen = xPoints.length - 1;
        for (i = 0; i < iLen; ++i) {
            this.getMicroeditionGraphics().drawLine(aiX[i], aiY[i], aiX[i + 1], aiY[i + 1]);
        }
        this.getMicroeditionGraphics().drawLine(aiX[iLen], aiY[iLen], aiX[0], aiY[0]);
    }

    public void fillArc(int iX, int iY, int iWidth, int iHeight, int iStartAngle, int iArcAngle) {
        if (this.pScreen != null && this.pScreen.getOrientation() == 1) {
            int iTmp = iY;
            iY = iX;
            iX = this.getHeight() - iTmp - iHeight;
            iTmp = iWidth;
            iWidth = iHeight;
            iHeight = iTmp;
        }
        this.getMicroeditionGraphics().fillArc(iX, iY, iWidth, iHeight, iStartAngle, iArcAngle);
    }

    public void fillPoly(int[] xPoints, int[] yPoints) {
        int[] aiX = xPoints;
        int[] aiY = yPoints;
        if (this.pScreen != null && this.pScreen.getOrientation() == 1) {
            aiY = new int[xPoints.length];
            System.arraycopy(xPoints, 0, aiY, 0, xPoints.length);
            aiX = new int[yPoints.length];
            System.arraycopy(yPoints, 0, aiX, 0, yPoints.length);
            int iH = this.getHeight();
            for (int i = aiX.length - 1; i >= 0; --i) {
                aiX[i] = iH - aiX[i];
            }
        }
        pStack = new Stack();
        this.fillPolygon(aiX, aiY, pStack);
        while (!pStack.isEmpty()) {
            this.fillPolygon((int[])pStack.pop(), (int[])pStack.pop(), pStack);
        }
        pStack = null;
    }

    private void fillPolygon(int[] xPoints, int[] yPoints, Stack stack) {
        while (xPoints.length > 2) {
            int a = GeomUtils.indexOfLeast(xPoints);
            int b = (a + 1) % xPoints.length;
            int c = a > 0 ? a - 1 : xPoints.length - 1;
            int leastInternalIndex = -1;
            boolean leastInternalSet = false;
            if (xPoints.length > 3) {
                for (int i = 0; i < xPoints.length; ++i) {
                    if (i == a || i == b || i == c || !GeomUtils.withinBounds(xPoints[i], yPoints[i], xPoints[a], yPoints[a], xPoints[b], yPoints[b], xPoints[c], yPoints[c]) || leastInternalSet && xPoints[i] >= xPoints[leastInternalIndex]) continue;
                    leastInternalIndex = i;
                    leastInternalSet = true;
                }
            }
            if (!leastInternalSet) {
                this.getMicroeditionGraphics().fillTriangle(xPoints[a], yPoints[a], xPoints[b], yPoints[b], xPoints[c], yPoints[c]);
                int[][] trimmed = GeomUtils.trimEar(xPoints, yPoints, a);
                xPoints = trimmed[0];
                yPoints = trimmed[1];
                continue;
            }
            int[][][] split = GeomUtils.split(xPoints, yPoints, a, leastInternalIndex);
            int[][] poly1 = split[0];
            int[][] poly2 = split[1];
            stack.push(poly2[1]);
            stack.push(poly2[0]);
            stack.push(poly1[1]);
            stack.push(poly1[0]);
            break;
        }
    }
}

