/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Game;
import game.GameBoard;
import game.RandomGenerator;
import javax.microedition.lcdui.Graphics;
import tinbrain.GCanvas;
import tinbrain.RM;

public class Floor {
    private static int sFontWidth = RM.getValue(81, 0, 0);
    private static int sFontHeight = RM.getValue(81, 0, 1);
    private static int sFontImageId = 24;
    private byte mFloorType;
    private int mFloorSpriteId;
    private int mFloorXPos;
    private int mFloorXPosFixed;
    private int mFloorWidth;
    private byte mFloorWidthId;
    private int mFloorIndex;
    private int mFloorSpriteWidth;
    private int mFloorSpriteHeight;
    private boolean mFloorLong;
    private boolean mFloorBrick;
    private boolean mFloorPowerUp;
    private boolean mFloorTable;
    private int mFloorPowerUpIdx;
    private long mTouchTime;
    private boolean mTouched;
    private boolean mDestroyed;
    private int mFloorTouchedPosY;
    private int mShakeOffsetX;
    private int mShakeOffsetY;
    private int mMovingPlatformsSign;

    public Floor(int n, int n2, int n3, boolean bl) {
        this.reinitFloor(n, n2, n3, bl);
    }

    public void reinitFloor(int n, int n2, int n3, boolean bl) {
        int n4;
        this.mFloorIndex = n3;
        this.mFloorWidthId = (byte)n;
        this.mFloorSpriteId = RM.getValue(71, Game.sGameStyle, 0);
        this.mFloorSpriteWidth = GCanvas.getSpriteWidth(this.mFloorSpriteId);
        this.mFloorSpriteHeight = GCanvas.getSpriteHeight(this.mFloorSpriteId);
        this.mFloorLong = bl;
        this.mFloorType = (byte)n2;
        this.mFloorWidth = this.calculateFloorWidth(n);
        this.mFloorXPos = bl ? GameBoard.getWallWidth() : this.randomXPos(n);
        this.mFloorXPosFixed = this.mFloorXPos << 10;
        this.mShakeOffsetX = 0;
        this.mShakeOffsetY = 0;
        this.mDestroyed = false;
        this.mTouched = false;
        this.mFloorBrick = false;
        this.mMovingPlatformsSign = 0;
        this.mFloorPowerUp = false;
        this.mFloorPowerUpIdx = 0;
        this.mFloorTable = false;
        this.mMovingPlatformsSign = !bl && this.mFloorIndex % 3 == 0 ? (n4 = RandomGenerator.nextInt() % 2 == 1 ? 1 : -1) : 0;
        if (this.mFloorIndex % 10 == 0) {
            this.mFloorTable = true;
        }
        if (Game.sPowerUpBrickActive) {
            this.setFloorBrickOn();
        }
        if (!bl && this.mFloorIndex - Game.sPowerUpFloorIndexLast > Game.sPowerUpSeed) {
            Game.setNewPowerUpRandomSeed();
            this.mFloorPowerUpIdx = Game.generateNewPowerUpIdx();
            Game.sPowerUpFloorIndexLast = n3;
            this.mFloorPowerUp = true;
        } else {
            this.mFloorPowerUp = false;
        }
    }

    public void calcDestPlatformsShake(boolean bl) {
        int n = bl ? Game.sPlatformnsShakeOffsetX << 1 : Game.sPlatformnsShakeOffsetX;
        int n2 = bl ? Game.sPlatformnsShakeOffsetY << 1 : Game.sPlatformnsShakeOffsetY;
        this.mShakeOffsetX = GCanvas.getRandom(-n, n);
        this.mShakeOffsetY = GCanvas.getRandom(-n2, n2);
    }

    public void reCalcXPosition(Floor floor, int n) {
        int n2;
        int n3;
        int n4;
        int n5 = Game.calcPercentage(this.mFloorWidth, 100 - n);
        int n6 = Math.abs(this.mFloorWidth - floor.getFloorWidth());
        if (this.mFloorWidth <= floor.getFloorWidth()) {
            n4 = floor.getXPos() - n5;
            n3 = floor.getXPos() + n6 + n5;
        } else {
            n4 = floor.getXPos() - n6 - n5;
            n3 = floor.getXPos() + n5;
        }
        if (n4 < GameBoard.getWallWidth()) {
            n4 = GameBoard.getWallWidth();
        }
        if (n3 + this.mFloorWidth > Game.sGameWidth - GameBoard.getWallWidth()) {
            n3 = Game.sGameWidth - GameBoard.getWallWidth() - this.mFloorWidth;
        }
        if ((n2 = Math.abs(n3 - n4)) != 0) {
            this.mFloorXPos = n4 + RandomGenerator.nextInt() % n2;
            this.mFloorXPosFixed = this.mFloorXPos << 10;
        } else {
            this.mFloorXPos = n4;
            this.mFloorXPosFixed = this.mFloorXPos << 10;
        }
    }

    public int getFloorIndex() {
        return this.mFloorIndex;
    }

    public int getFloorType() {
        return this.mFloorType;
    }

    public boolean getFloorLong() {
        return this.mFloorLong;
    }

    public boolean getFloorBrick() {
        return this.mFloorBrick;
    }

    public boolean getFloorTable() {
        return this.mFloorTable;
    }

    public int getShakeOffsetX() {
        return this.mShakeOffsetX;
    }

    public int getShakeOffsetY() {
        return this.mShakeOffsetY;
    }

    public int calculateFloorWidth(int n) {
        int n2 = this.mFloorSpriteWidth / 3;
        return (2 + RM.getValue(78, n)) * n2;
    }

    private int randomXPos(int n) {
        if (n == 3) {
            return Game.sGameWidth - this.mFloorWidth >> 1;
        }
        return RandomGenerator.nextInt() % (Game.sGameWidth - (GameBoard.getWallWidth() << 1) - this.mFloorWidth) + GameBoard.getWallWidth();
    }

    public int checkXPosBoundingFixed(int n) {
        if (n + (this.mFloorWidth << 10) > (Game.sGameWidth << 10) - (GameBoard.getWallWidth() << 10)) {
            n = (Game.sGameWidth << 10) - (GameBoard.getWallWidth() << 10) - (this.mFloorWidth << 10);
        }
        if (n < GameBoard.getWallWidth() << 10) {
            n = GameBoard.getWallWidth() << 10;
        }
        return n;
    }

    public boolean isLeftSideStick() {
        return this.mFloorXPos <= GameBoard.getWallWidth();
    }

    public boolean isRightSideStick() {
        return this.mFloorXPos + this.mFloorWidth >= Game.sGameWidth - GameBoard.getWallWidth();
    }

    public void changeMovingSign() {
        this.mMovingPlatformsSign *= -1;
    }

    public int getMovingPlatformSign() {
        return this.mMovingPlatformsSign;
    }

    public boolean getFloorPowerUp() {
        return this.mFloorPowerUp;
    }

    public int getFloorPowerUpIdx() {
        return this.mFloorPowerUpIdx;
    }

    public void setFloorPowerUp(boolean bl) {
        this.mFloorPowerUp = bl;
    }

    public void setFloorBrickOn() {
        if (!this.mFloorBrick) {
            this.mFloorBrick = true;
            this.mFloorSpriteId = 9;
        }
    }

    public void setFloorTouchedPosY(int n) {
        this.mFloorTouchedPosY = n;
    }

    public int getFloorTouchedPosY() {
        return this.mFloorTouchedPosY;
    }

    public int getXPos() {
        return this.mFloorXPos;
    }

    public int getXPosFixed() {
        return this.mFloorXPosFixed;
    }

    public int getFloorWidth() {
        return this.mFloorWidth;
    }

    public void setTouched(boolean bl) {
        this.mTouched = bl;
    }

    public boolean getTouched() {
        return this.mTouched;
    }

    public void setDestroyed(boolean bl) {
        this.mDestroyed = bl;
    }

    public boolean getDestroyed() {
        return this.mDestroyed;
    }

    public void setTouchTime(long l) {
        this.mTouchTime = l;
    }

    public long getTouchTime() {
        return this.mTouchTime;
    }

    public void setXPosFixed(int n) {
        this.mFloorXPosFixed = n;
        this.mFloorXPos = this.mFloorXPosFixed >> 10;
    }

    public void drawSign(Graphics graphics, int n, int n2) {
        int n3 = Game.sGameStyle == 0 ? 6 : 7;
        int n4 = GCanvas.getSpriteWidth(n3);
        int n5 = this.mFloorXPos + (this.mFloorWidth - n4 >> 1);
        if (this.mFloorLong) {
            n5 = Game.sGameWidth - n4 >> 1;
        }
        int n6 = n2 + (this.mFloorSpriteHeight >> 1);
        int n7 = 0;
        if (this.mFloorType != 4 || Game.sGameStyle == 1) {
            // empty if block
        }
        GCanvas.drawSprite(graphics, n3, n5, n6 - 4 + n7 + 0, this.mFloorType);
        String string = "" + n;
        int n8 = n5 + (n4 - string.length() * sFontWidth >> 1);
        int n9 = n6 + (GCanvas.getSpriteHeight(n3) - sFontHeight >> 1);
        if (Game.sGameStyle == 0) {
            if (this.mFloorType >= 2) {
                ++n9;
            }
        } else if (this.mFloorType == 2) {
            ++n9;
        }
        this.drawOwnFontNumbers(graphics, string, n8, n9 - 4 + n7 + 0);
    }

    private void drawElement(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        GCanvas.pushClip(graphics);
        graphics.clipRect(n4, n5, n3 + n6, this.mFloorSpriteHeight);
        this.mFloorType = this.mFloorBrick ? (byte)0 : this.mFloorType;
        GCanvas.drawSprite(graphics, this.mFloorSpriteId, n4 - n2, n5, this.mFloorType);
        GCanvas.popClip(graphics);
    }

    public void draw(Graphics graphics, int n) {
        int n2;
        if (this.getDestroyed()) {
            return;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = RM.getValue(78, this.mFloorWidthId);
        int n6 = this.mFloorSpriteWidth / 3;
        graphics.translate(this.mShakeOffsetX, this.mShakeOffsetY);
        this.drawElement(graphics, this.mFloorType, n4, n6, this.mFloorXPos, n, 0);
        if (!this.mFloorBrick && !this.mFloorLong && (Game.sPowerUpNailsActive || Game.sPowerUpNailsOutroActive)) {
            this.drawLeftNail(graphics, n);
        }
        n3 += n6;
        n4 += n6;
        int n7 = 0;
        if (this.mFloorLong) {
            n2 = Game.sGameWidth - (GameBoard.getWallWidth() << 1);
            if (n5 * n6 > n2) {
                n5 = n2 / n6 - 2;
            }
            n7 = n2 % n6;
        }
        for (n2 = 0; n2 < n5; ++n2) {
            this.drawElement(graphics, this.mFloorType, n4, n6, this.mFloorXPos + n3, n, 0);
            n3 += n6;
        }
        if (n7 > 0) {
            this.drawElement(graphics, this.mFloorType, n4, n6, this.mFloorXPos + n3, n, 0);
        }
        this.drawElement(graphics, this.mFloorType, n4 += n6, n6, this.mFloorXPos + n3 + n7, n, n4);
        if (!this.mFloorBrick && !this.mFloorLong && (Game.sPowerUpNailsActive || Game.sPowerUpNailsOutroActive)) {
            this.drawRightNail(graphics, n);
        }
        if (this.mFloorIndex != 0 && this.mFloorIndex % 10 == 0) {
            this.drawSign(graphics, this.mFloorIndex, n);
        }
        if (this.mFloorPowerUp) {
            this.drawPowerUp(graphics, n);
        }
        graphics.translate(-this.mShakeOffsetX, -this.mShakeOffsetY);
    }

    private void drawLeftNail(Graphics graphics, int n) {
        long l;
        int n2 = 0;
        if (!Game.sPowerUpNailsOutroActive) {
            l = System.currentTimeMillis() - Game.sPowerUpNailsIntroTimer;
            if (l < 300L) {
                int n3 = (int)l * 100 / 300;
                n2 = Game.calcPercentageFrom(n3, this.getXPos());
            } else {
                n2 = this.getXPos();
            }
        } else {
            l = System.currentTimeMillis() - Game.sPowerUpNailsOutroTimer;
            if (l < 300L) {
                int n4 = (int)l * 100 / 300;
                n2 = this.getXPos() - Game.calcPercentageFrom(n4, this.getXPos());
            } else {
                n2 = this.getXPos();
            }
        }
        int n5 = n2 - (RM.getWidth(60) >> 1);
        int n6 = n - (RM.getHeight(60) >> 1);
        GCanvas.drawImage(graphics, 60, n5, n6, false, 0);
    }

    private void drawRightNail(Graphics graphics, int n) {
        long l;
        int n2 = 0;
        if (!Game.sPowerUpNailsOutroActive) {
            l = System.currentTimeMillis() - Game.sPowerUpNailsIntroTimer;
            if (l < 300L) {
                int n3 = (int)l * 100 / 300;
                n2 = Game.sGameWidth - Game.calcPercentageFrom(n3, Game.sGameWidth - this.getXPos() - this.getFloorWidth());
            } else {
                n2 = this.getXPos() + this.getFloorWidth();
            }
        } else {
            l = System.currentTimeMillis() - Game.sPowerUpNailsOutroTimer;
            if (l < 300L) {
                int n4 = (int)l * 100 / 300;
                n2 = this.getFloorWidth() + this.getXPos() + Game.calcPercentageFrom(n4, Game.sGameWidth);
            } else {
                n2 = this.getXPos() + this.getFloorWidth();
            }
        }
        int n5 = n2 - (RM.getWidth(61) >> 1);
        int n6 = n - (RM.getHeight(60) >> 1);
        GCanvas.drawImage(graphics, 61, n5, n6, false, 0);
    }

    private void drawPowerUp(Graphics graphics, int n) {
        int n2 = GCanvas.getSpriteWidth(23);
        int n3 = GCanvas.getSpriteHeight(23);
        int n4 = this.mFloorXPos + (this.mFloorWidth - n2 >> 1);
        int n5 = n - n3;
        GCanvas.drawSprite(graphics, 23, n4, n5, this.mFloorPowerUpIdx);
    }

    private void drawOwnFont(Graphics graphics, int n, int n2, int n3) {
        GCanvas.pushClip(graphics);
        graphics.clipRect(n2, n3, sFontWidth, sFontHeight + 2);
        graphics.drawImage(RM.getImage(sFontImageId), n2 - n * sFontWidth, n3, 20);
        GCanvas.popClip(graphics);
    }

    public void drawOwnFontNumbers(Graphics graphics, String string, int n, int n2) {
        int n3 = string.length();
        for (int i = 0; i < n3; ++i) {
            int n4 = string.charAt(i) - 48;
            this.drawOwnFont(graphics, n4, n + sFontWidth * i, n2 - 1);
        }
    }
}

