/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Avatar;
import game.Game;
import javax.microedition.lcdui.Graphics;
import tinbrain.GCanvas;
import tinbrain.RM;

public class Bubbles {
    private static int initTurn;
    private static long lastInitTurnTime;
    private static int initTurnInterval;
    private static int[][] coordsX;
    private static int[][] coordsY;
    private static int[][] speedY;
    private static int[][] life;
    private static boolean endPhase;
    private static final int[] SPEEDY_MIN;
    private static final int[] SPEEDY_MAX;

    public static boolean isEndPhase() {
        return endPhase;
    }

    public static void init() {
        coordsX = new int[3][6];
        coordsY = new int[3][6];
        speedY = new int[3][6];
        life = new int[3][6];
    }

    private static void initPart(int n) {
        int n2 = 1 * n;
        int n3 = 1 * (n + 1);
        for (int i = 0; i < 3; ++i) {
            for (int j = n2; j < n3; ++j) {
                Bubbles.coordsX[i][j] = GCanvas.getRandom(0, Game.sGameWidth) << 10;
                Bubbles.coordsY[i][j] = Game.sGameHeight << 10;
                Bubbles.speedY[i][j] = GCanvas.getRandom(SPEEDY_MIN[i], SPEEDY_MAX[i]);
                Bubbles.life[i][j] = GCanvas.getRandom(0, 2048);
            }
        }
    }

    public static void initEffect() {
        endPhase = false;
        initTurn = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 6; ++j) {
                Bubbles.coordsY[i][j] = 0;
                Bubbles.coordsX[i][j] = 0;
                Bubbles.speedY[i][j] = 0;
                Bubbles.life[i][j] = -1;
            }
        }
        Bubbles.initPart(initTurn++);
        lastInitTurnTime = System.currentTimeMillis();
    }

    public static void continueEffect() {
        lastInitTurnTime = System.currentTimeMillis();
        endPhase = false;
    }

    public static void update() {
        boolean bl = false;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 6; ++j) {
                if (life[i][j] < 0) continue;
                int[] nArray = coordsY[i];
                int n = j;
                nArray[n] = nArray[n] - speedY[i][j];
                if (coordsY[i][j] < Game.sGameHeight << 10) {
                    bl = true;
                }
                if (!endPhase) {
                    if (coordsY[i][j] >= 0) continue;
                    Bubbles.coordsY[i][j] = Game.sGameHeight << 10;
                    Bubbles.coordsX[i][j] = GCanvas.getRandom(0, Game.sGameWidth) << 10;
                    int[] nArray2 = life[i];
                    int n2 = j;
                    nArray2[n2] = nArray2[n2] + 1;
                    continue;
                }
                int[] nArray3 = life[i];
                int n3 = j;
                nArray3[n3] = nArray3[n3] + 1;
                int[] nArray4 = coordsY[i];
                int n4 = j;
                nArray4[n4] = nArray4[n4] + (speedY[i][j] << 2);
            }
        }
        long l = System.currentTimeMillis();
        if (l - (long)initTurnInterval > lastInitTurnTime && initTurn < 4) {
            Bubbles.initPart(initTurn++);
            lastInitTurnTime = l;
        }
        if (l - 5000L > lastInitTurnTime) {
            endPhase = true;
            Avatar.switchGravityNormal();
        }
        if (!bl && endPhase) {
            Game.sPowerUpBubbleActive = false;
        }
    }

    public static void draw(Graphics graphics) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 6; ++j) {
                if (life[i][j] < 0) continue;
                int n = coordsY[i][j] >> 10;
                int n2 = RM.getLength(83);
                int n3 = RM.getInts(83)[(GCanvas.getGlobalFrameCount() + life[i][j]) % n2];
                int n4 = n3 + coordsX[i][j] >> 10;
                GCanvas.drawSprite(graphics, 24, n4, n, i);
            }
        }
    }

    static {
        initTurnInterval = 1000;
        SPEEDY_MIN = new int[]{2048, 2048, 2048};
        SPEEDY_MAX = new int[]{6144, 4096, 3072};
    }
}

