/*
 * Decompiled with CFR 0.152.
 */
package tinbrain;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;
import tinbrain.GCanvas;
import tinbrain.Menu;
import tinbrain.Midlet;
import tinbrain.midp20.MIDP20Proxy;
import tinbrain.util.GL;

public final class RM {
    private static int[] resWidths;
    private static int[] resHeights;
    private static byte[] resTypes;
    private static Object[] resources;
    private static int maxResources;
    private static int numResources;
    private static int currentLoading;
    public static String language;
    public static int languageIndex;
    private static String[] strings;
    private static String[] varStrings;
    private static String[] dynamicStrings;
    private static int nextDynamicString;
    private static String[] fittedStrings;
    private static int lastRMSError;
    private static String[] storeNames;
    private static byte[][] stores;
    private static int rmsLoaded;
    private static int rmsDirty;
    private static final int[] tmpRect;
    private static int minMemory;
    public static final int[] menuRes;
    public static final int[] classicGame;
    public static final int[] modernGame;
    public static boolean debugStringWidth;

    public static int getNumResources() {
        return numResources;
    }

    public static int getCurrentLoading() {
        return currentLoading;
    }

    public static final String t(int n) {
        if (strings == null) {
            return null;
        }
        if (n == -1) {
            return null;
        }
        if (n < 0) {
            n &= 0xFF;
        }
        return strings[n];
    }

    public static final String dt(int n) {
        if (n == -1) {
            return null;
        }
        return dynamicStrings[n];
    }

    public static final void fitString(String string, int n, int n2, Font font) {
        int n3;
        if (fittedStrings == null) {
            fittedStrings = new String[24];
        }
        if ((n3 = RM.getStringWidth(string, font)) <= n2) {
            RM.fittedStrings[n] = string;
        } else {
            int n4;
            int n5 = n2 - RM.getCharWidth('.', font) * 3;
            int n6 = string.length();
            for (n4 = 0; n4 < n6 && RM.getSubstringWidth(string, 0, n4, font) < n5; ++n4) {
            }
            RM.fittedStrings[n] = string.substring(0, n4 - 1) + "...";
        }
    }

    public static final String getFittedString(int n) {
        return fittedStrings[n];
    }

    public static final int formatString(StringBuffer stringBuffer, String[] stringArray) {
        int n = 0;
        int n2 = stringArray.length;
        for (int i = 0; i < stringBuffer.length() - 1 && n < n2; ++i) {
            if (stringBuffer.charAt(i) != '%' || !Character.isDigit(stringBuffer.charAt(i + 1))) continue;
            int n3 = stringBuffer.charAt(i + 1) - 48 - 1;
            stringBuffer.deleteCharAt(i);
            stringBuffer.deleteCharAt(i);
            if (stringArray[n3] != null) {
                stringBuffer.insert(i, stringArray[n3]);
            }
            ++n;
        }
        return n;
    }

    public static final void prepareVarText(int n, String string) {
        RM.prepareVarText(n, new String[]{string});
    }

    public static final void prepareVarText(int n, String string, String string2) {
        RM.prepareVarText(n, new String[]{string, string2});
    }

    public static final void prepareVarText(int n, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(varStrings[n]);
        int n2 = RM.formatString(stringBuffer, stringArray);
        RM.setString(n, stringBuffer.toString());
    }

    public static final int getTextWidth(int n, Font font) {
        String string = RM.t(n);
        return RM.getStringWidth(string, font);
    }

    public static final int getTextWidth(String string, Font font) {
        return font.stringWidth(string);
    }

    public static final int getStringWidth(String string, Font font) {
        return font.stringWidth(string);
    }

    public static final int getCharWidth(char c, Font font) {
        return font.charWidth(c);
    }

    public static final int getSubstringWidth(String string, int n, int n2, Font font) {
        return font.substringWidth(string, n, n2);
    }

    public static final int getFontHeight(Font font) {
        return font.getHeight();
    }

    public static final void setString(int n, String string) {
        RM.strings[n] = string;
    }

    public static final void flushDynamicStrings(int n) {
        nextDynamicString = 0;
        dynamicStrings = n > 0 ? new String[n] : null;
    }

    public static final int createDynamicString(String string) {
        if (string == null || string.length() == 0) {
            return -1;
        }
        RM.dynamicStrings[RM.nextDynamicString] = string;
        return nextDynamicString++;
    }

    public static void setLocale(int n) {
        RM.setLocale(GL.HANDSON_LANGUAGE_CODES[n]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLocale(String string) {
        if (language != null && language.equals(string)) {
            return;
        }
        strings = null;
        varStrings = null;
        DataInputStream dataInputStream = RM.getNamedResource("/res/text.lng");
        try {
            int n;
            dataInputStream.readShort();
            dataInputStream.readByte();
            int n2 = dataInputStream.readUnsignedByte();
            short s = dataInputStream.readShort();
            boolean bl = false;
            int n3 = 0;
            for (n = 0; n < n2; ++n) {
                dataInputStream.readByte();
                dataInputStream.readByte();
                if (string.equals(GL.HANDSON_LANGUAGE_CODES[n]) || n2 == 1) {
                    bl = true;
                    languageIndex = n;
                    n3 = dataInputStream.readShort() & 0xFFFF;
                    continue;
                }
                dataInputStream.read();
                dataInputStream.read();
            }
            if (bl) {
                if (strings == null) {
                    strings = new String[s];
                }
                language = string;
                dataInputStream.skipBytes(n3);
                for (n = 0; n < s; ++n) {
                    RM.strings[n] = dataInputStream.readUTF();
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            RM.closeStream(dataInputStream);
        }
        if (varStrings == null) {
            varStrings = new String[30];
        }
        System.arraycopy(strings, 0, varStrings, 0, 30);
    }

    public static final Image getImage(int n) {
        if ((resTypes[n] & 0x40) != 0) {
            RM.createImage(n);
        }
        return (Image)RM.get(n);
    }

    private static final Image createImage(byte[] byArray, int n) {
        Image image = null;
        image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
        return image;
    }

    private static final void createImage(int n) {
        byte[] byArray = (byte[])RM.get(n);
        Image image = null;
        image = RM.createImage(byArray, n);
        RM.resources[n] = image;
        RM.resWidths[n] = image.getWidth();
        RM.resHeights[n] = image.getHeight();
    }

    public static final int getType(int n) {
        return resTypes[n] & 0x3F;
    }

    public static final byte[] getBytes(int n) {
        return (byte[])RM.get(n);
    }

    public static final byte[] getUBytes(int n) {
        return (byte[])RM.get(n);
    }

    public static final short[] getShorts(int n) {
        return (short[])RM.get(n);
    }

    public static final int[] getInts(int n) {
        return (int[])RM.get(n);
    }

    public static final boolean isLoaded(int n) {
        return n >= 0 && resources != null && resources[n] != null;
    }

    private static final Object get(int n) {
        Object object = resources[n];
        if (object == null && (resTypes[n] & 0x80) != 0) {
            String string = "/res/r" + n + ".bin";
            RM.load(string, n);
            object = resources[n];
        }
        return object;
    }

    public static final void forget(int n) {
        RM.resources[n] = null;
        System.gc();
    }

    public static final void forget(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == -1) continue;
            RM.resources[nArray[i]] = null;
        }
        System.gc();
    }

    public static final int getWidth(int n) {
        if ((resTypes[n] & 0x40) != 0) {
            RM.createImage(n);
        }
        return resWidths[n];
    }

    public static final int getHeight(int n) {
        if ((resTypes[n] & 0x40) != 0) {
            RM.createImage(n);
        }
        return resHeights[n];
    }

    public static final int getLength(int n) {
        return resWidths[n] * resHeights[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final void load() {
        DataInputStream dataInputStream = RM.getNamedResource("/res/res.bin");
        try {
            GL.dbgPrint("Here");
            numResources = dataInputStream.readShort();
            maxResources = numResources + 24;
            resTypes = new byte[maxResources];
            resWidths = new int[maxResources];
            resHeights = new int[maxResources];
            resources = new Object[maxResources];
            Menu.onLoadingStart(numResources);
            currentLoading = 0;
            for (int i = 0; i < numResources; ++i) {
                byte by = dataInputStream.readByte();
                RM.load(dataInputStream, currentLoading, by);
                Menu.onLoadingStep(++currentLoading);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
        }
        catch (Exception exception) {
        }
        finally {
            RM.closeStream(dataInputStream);
        }
        System.gc();
        Menu.onLoadingDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void load(String string, int n) {
        DataInputStream dataInputStream = RM.getNamedResource(string);
        try {
            byte by = dataInputStream.readByte();
            RM.load(dataInputStream, n, by);
        }
        catch (Exception exception) {
        }
        finally {
            RM.closeStream(dataInputStream);
        }
    }

    public static final void load(int n) {
        RM.get(n);
    }

    private static final void load(DataInputStream dataInputStream, int n, byte by) throws IOException {
        int n2 = 0;
        int n3 = 0;
        Image image = null;
        if ((by & 0x80) == 0) {
            Object[] objectArray;
            int n4;
            byte[] byArray;
            if (by == 1) {
                n2 = dataInputStream.readUnsignedShort();
                byArray = new byte[n2];
                RM.getBytes(dataInputStream, byArray);
                image = RM.createImage(byArray, n);
                byArray = null;
                n2 = image.getWidth();
                n3 = image.getHeight();
                RM.resources[n] = image;
            }
            if (by == 13) {
                n2 = dataInputStream.readUnsignedShort();
                n3 = dataInputStream.readUnsignedShort();
                n4 = n2 * n3;
                objectArray = new int[n4];
                RM.getInts(dataInputStream, objectArray);
                image = MIDP20Proxy.createImage(objectArray, n2, n3, true);
                RM.resources[n] = image;
                by = 1;
            }
            if (by == 2 || by == 9) {
                n2 = dataInputStream.readUnsignedShort();
                n3 = dataInputStream.readUnsignedShort();
                byArray = new byte[n2 * n3];
                RM.getBytes(dataInputStream, byArray);
                RM.resources[n] = byArray;
            }
            if (by == 3) {
                n2 = dataInputStream.readUnsignedShort();
                n3 = dataInputStream.readUnsignedShort();
                n4 = n2 * n3;
                objectArray = new short[n4];
                RM.getShorts(dataInputStream, (short[])objectArray);
                RM.resources[n] = objectArray;
            }
            if (by == 4) {
                n2 = dataInputStream.readUnsignedShort();
                n3 = dataInputStream.readUnsignedShort();
                n4 = n2 * n3;
                objectArray = new int[n4];
                RM.getInts(dataInputStream, objectArray);
                RM.resources[n] = objectArray;
            }
            if (by == 7) {
                int n5 = dataInputStream.readUnsignedByte();
                byte[][] byArray2 = new byte[n5][4];
                for (int i = 0; i < n5; ++i) {
                    RM.getBytes(dataInputStream, byArray2[i]);
                }
                GCanvas.softkeys = byArray2;
                n5 = dataInputStream.readUnsignedByte();
                byte[] byArray3 = new byte[n5];
                RM.getBytes(dataInputStream, byArray3);
                Menu.iconBases = byArray3;
                n5 = dataInputStream.readUnsignedByte();
                byte[][] byArray4 = new byte[n5][2];
                for (int i = 0; i < n5; ++i) {
                    RM.getBytes(dataInputStream, byArray4[i]);
                }
                Menu.icons = byArray4;
                n5 = dataInputStream.readByte();
                byte[][] byArray5 = new byte[n5][5];
                for (int i = 0; i < n5; ++i) {
                    RM.getBytes(dataInputStream, byArray5[i]);
                }
                Menu.menus = byArray5;
                byte[][][] byArrayArray = new byte[n5][][];
                for (int i = 0; i < n5; ++i) {
                    int n6 = dataInputStream.readByte();
                    byArrayArray[i] = new byte[n6][6];
                    for (int j = 0; j < n6; ++j) {
                        RM.getBytes(dataInputStream, byArrayArray[i][j]);
                    }
                }
                Menu.menuItems = byArrayArray;
            }
        }
        if (resTypes[n] == 0) {
            RM.resTypes[n] = by;
        }
        RM.resWidths[n] = n2;
        RM.resHeights[n] = n3;
    }

    public static final int getShortFromBytes(byte[] byArray, int n) {
        byte by = byArray[n];
        int n2 = byArray[n + 1] & 0xFF;
        return by << 8 | n2;
    }

    public static final int getBytes(DataInputStream dataInputStream, byte[] byArray) throws IOException {
        return RM.getBytes(dataInputStream, byArray, 0, byArray.length);
    }

    public static final int getBytes(DataInputStream dataInputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while ((n3 = dataInputStream.read(byArray, n, n2 - n)) != -1 && (n += n3) < n2) {
        }
        return n;
    }

    public static final void getInts(DataInputStream dataInputStream, int[] nArray) throws IOException {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            nArray[i] = dataInputStream.readInt();
        }
    }

    public static final void getShorts(DataInputStream dataInputStream, short[] sArray) throws IOException {
        int n = sArray.length;
        for (int i = 0; i < n; ++i) {
            sArray[i] = dataInputStream.readShort();
        }
    }

    public static final DataInputStream getNamedResource(String string) {
        InputStream inputStream = ((Object)((Object)Midlet.instance)).getClass().getResourceAsStream(string);
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        return dataInputStream;
    }

    public static final int getValue(int n, int n2, int n3) {
        switch (RM.getType(n)) {
            case 2: {
                return RM.getBytes(n)[n2 * RM.getWidth(n) + n3];
            }
            case 9: {
                return RM.getUBytes(n)[n2 * RM.getWidth(n) + n3] & 0xFF;
            }
            case 3: {
                return RM.getShorts(n)[n2 * RM.getWidth(n) + n3];
            }
            case 4: {
                return RM.getInts(n)[n2 * RM.getWidth(n) + n3];
            }
        }
        return 0;
    }

    public static final int getValue(int n, int n2) {
        switch (RM.getType(n)) {
            case 2: {
                return RM.getBytes(n)[n2];
            }
            case 9: {
                return RM.getUBytes(n)[n2] & 0xFF;
            }
            case 3: {
                return RM.getShorts(n)[n2];
            }
            case 4: {
                return RM.getInts(n)[n2];
            }
        }
        return 0;
    }

    public static final int getLinkedValue(int n, int n2, int n3, int n4) {
        int n5 = RM.getHeight(n);
        for (int i = 0; i < n5; ++i) {
            if (n3 != RM.getValue(n, i, n2)) continue;
            return RM.getValue(n, i, n4);
        }
        return -1;
    }

    public static final DataInputStream getDataInput(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        return new DataInputStream(byteArrayInputStream);
    }

    public static final void closeStream(InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final void closeStream(OutputStream outputStream) {
        try {
            outputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final void initRMS(String[] stringArray) {
        storeNames = stringArray;
        int n = storeNames.length;
        stores = new byte[n][];
    }

    public static final void setStoreDirty(int n) {
        rmsDirty |= 1 << n;
    }

    public static final int getRMSError() {
        int n = lastRMSError;
        lastRMSError = 0;
        return n;
    }

    public static final byte[] getRMS(int n, boolean bl) {
        int n2 = 1 << n;
        if ((rmsLoaded & n2) == 0) {
            RM.stores[n] = RM.getRMSBytes(storeNames[n]);
            if (lastRMSError == 0) {
                rmsLoaded |= n2;
            }
        }
        if (bl) {
            RM.setStoreDirty(n);
        }
        return stores[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int[] getRMSInts(int n) {
        int[] nArray = null;
        byte[] byArray = RM.getRMS(n, false);
        if (lastRMSError == 0) {
            DataInputStream dataInputStream = RM.getDataInput(byArray);
            int n2 = byArray.length >> 2;
            nArray = new int[n2];
            try {
                RM.getInts(dataInputStream, nArray);
            }
            catch (Exception exception) {
            }
            finally {
                RM.closeStream(dataInputStream);
            }
            RM.stores[n] = null;
        }
        return nArray;
    }

    public static final void setRMS(int n, byte[] byArray) {
        int n2 = 1 << n;
        boolean bl = false;
        if (stores[n] == null && byArray != null) {
            bl = true;
        }
        if (stores[n] != null && byArray == null) {
            bl = true;
        }
        if (stores[n] != null && byArray != null && stores[n].length != byArray.length) {
            bl = true;
        }
        if (!bl && stores[n] != null && byArray != null && stores[n].length == byArray.length) {
            int n3 = byArray.length;
            for (int i = 0; i < n3; ++i) {
                if (stores[n][i] == byArray[i]) continue;
                bl = true;
                break;
            }
        }
        RM.stores[n] = byArray;
        if (bl) {
            rmsDirty |= n2;
        }
        rmsLoaded |= n2;
    }

    public static final void setRMS(int n, int[] nArray) {
        RM.setRMS(n, RM.intsToBytes(nArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] intsToBytes(int[] nArray) {
        int n = nArray.length;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n << 2);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            for (int i = 0; i < n; ++i) {
                dataOutputStream.writeInt(nArray[i]);
            }
        }
        catch (Exception exception) {
        }
        finally {
            RM.closeStream(dataOutputStream);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static final void saveStore(int n) {
        if (RM.isDirty(n)) {
            RM.writeRMSBytes(storeNames[n], stores[n]);
            if (lastRMSError == 0) {
                rmsDirty &= ~(1 << n);
            }
        }
    }

    public static final boolean isDirty(int n) {
        int n2 = 1 << n;
        return (rmsDirty & rmsLoaded & n2) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void writeRMSBytes(String string, byte[] byArray) {
        lastRMSError = 0;
        RecordStore recordStore = null;
        if (byArray != null) {
            try {
                recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
                if (recordStore.getNumRecords() == 0) {
                    recordStore.addRecord(byArray, 0, byArray.length);
                } else {
                    RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, false);
                    int n = recordEnumeration.nextRecordId();
                    recordEnumeration.destroy();
                    recordStore.setRecord(n, byArray, 0, byArray.length);
                }
            }
            catch (RecordStoreFullException recordStoreFullException) {
                lastRMSError = 2;
            }
            catch (Exception exception) {
                lastRMSError = 3;
            }
            finally {
                if (recordStore != null) {
                    try {
                        recordStore.closeRecordStore();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final byte[] getRMSBytes(String string) {
        lastRMSError = 0;
        byte[] byArray = null;
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)string, (boolean)false);
            if (recordStore.getNumRecords() == 0) {
                lastRMSError = 1;
            } else {
                byArray = recordStore.getRecord(1);
            }
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            lastRMSError = 1;
        }
        catch (RecordStoreFullException recordStoreFullException) {
            lastRMSError = 2;
        }
        catch (Exception exception) {
            lastRMSError = 3;
        }
        finally {
            if (recordStore != null) {
                try {
                    recordStore.closeRecordStore();
                }
                catch (Exception exception) {}
            }
        }
        return byArray;
    }

    private static final void deleteStore(String string) {
        if (string != null) {
            try {
                RecordStore.deleteRecordStore((String)string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final void flushRMS() {
        int n = storeNames.length;
        for (int i = 0; i < n; ++i) {
            RM.saveStore(i);
        }
    }

    public static final void deleteRecordStore(int n) {
        RM.deleteStore(storeNames[n]);
        RM.stores[n] = null;
        int n2 = 1 << n;
        rmsDirty &= ~n2;
        rmsLoaded &= ~n2;
    }

    public static final void deleteAllRecordStores() {
        int n = storeNames.length;
        for (int i = 0; i < n; ++i) {
            RM.deleteRecordStore(i);
        }
    }

    public static final void setRect(int[] nArray, int n, int n2, int n3, int n4) {
        nArray[0] = n;
        nArray[2] = n + n3;
        nArray[1] = n2;
        nArray[3] = n2 + n4;
    }

    public static final void setRect(int[] nArray, int[] nArray2) {
        System.arraycopy(nArray2, 0, nArray, 0, 4);
    }

    public static final void intersectRect(int[] nArray, int n, int n2, int n3, int n4) {
        RM.setRect(tmpRect, n, n2, n3, n4);
        RM.intersectRect(nArray, tmpRect);
    }

    public static final void intersectRect(int[] nArray, int[] nArray2) {
        if (nArray[0] < nArray2[0]) {
            nArray[0] = nArray2[0];
        }
        if (nArray[1] < nArray2[1]) {
            nArray[1] = nArray2[1];
        }
        if (nArray[2] > nArray2[2]) {
            nArray[2] = nArray2[2];
        }
        if (nArray[3] > nArray2[3]) {
            nArray[3] = nArray2[3];
        }
    }

    public static final boolean isRectEmpty(int[] nArray) {
        return nArray[2] <= nArray[0] || nArray[3] <= nArray[1];
    }

    static {
        tmpRect = new int[4];
        minMemory = Integer.MAX_VALUE;
        menuRes = new int[]{23, 28, 66, 65, 21, 26, 25, 27, -1, -1};
        classicGame = new int[]{33, 34, 37, 38, 39, 40, 41, 42, 45, 46, 47, -1, -1};
        modernGame = new int[]{48, 33, 49, 50, 51, 52, 53, 54, 55, 57, 58, 59, -1, -1};
        debugStringWidth = false;
    }
}

