/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Combo;
import game.Game;
import javax.microedition.lcdui.Graphics;
import tinbrain.GCanvas;
import tinbrain.RM;

public class ComboIndicator {
    private static int sPosX;
    private static int sPosY;
    private static int sStripePosX;
    private static int sStripePosY;
    private static int sStripeWidth;
    private static int sStripeHeight;
    private static int imageId;
    private static int sCurrentStripeHeight;

    public static final void init() {
        imageId = Game.sGameStyle == 0 ? 42 : 55;
        sPosX = RM.getValue(77, Game.sGameStyle, 0);
        sPosY = RM.getValue(77, Game.sGameStyle, 1);
        sStripePosX = RM.getValue(77, Game.sGameStyle, 2);
        sStripePosY = RM.getValue(77, Game.sGameStyle, 3);
        sStripeWidth = RM.getValue(77, Game.sGameStyle, 4);
        sCurrentStripeHeight = sStripeHeight = RM.getValue(77, Game.sGameStyle, 5);
    }

    public static final void resetStripe() {
        sCurrentStripeHeight = sStripeHeight;
    }

    public static final void update() {
        int n = (int)((long)Game.frameCount - Combo.getStartTime());
        if (n >= 28) {
            ComboIndicator.resetStripe();
        } else {
            sCurrentStripeHeight = n * sStripeHeight / 28;
        }
    }

    public static final void draw(Graphics graphics) {
        GCanvas.drawImage(imageId, sPosX, sPosY, 0);
        ComboIndicator.drawStripe(graphics);
    }

    private static final void drawStripe(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(sPosX + sStripePosX, sPosY + sStripePosY, sStripeWidth, sCurrentStripeHeight);
    }
}

