/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.GameBoard;
import javax.microedition.lcdui.Graphics;
import tinbrain.GCanvas;
import tinbrain.RM;

public class BubblesAvatar {
    private static long lastAddTime;
    private static int nextAddInterval;
    private static int[] coordsX;
    private static int[] coordsY;
    private static int[] speedY;
    private static int[] life;
    private static boolean[] slotUsed;

    public static void init() {
        coordsX = new int[50];
        coordsY = new int[50];
        speedY = new int[50];
        life = new int[50];
        slotUsed = new boolean[50];
        lastAddTime = System.currentTimeMillis();
        nextAddInterval = GCanvas.getRandom(50, 300);
    }

    private static int searchFreeSlot() {
        int n = -1;
        for (int i = 0; i < 50; ++i) {
            if (slotUsed[i]) continue;
            n = i;
            break;
        }
        return n;
    }

    public static void add(int n, int n2) {
        int n3 = BubblesAvatar.searchFreeSlot();
        if (n3 == -1 || System.currentTimeMillis() - (long)nextAddInterval <= lastAddTime) {
            return;
        }
        BubblesAvatar.life[n3] = 100;
        BubblesAvatar.coordsX[n3] = n << 10;
        BubblesAvatar.coordsY[n3] = n2 << 10;
        BubblesAvatar.speedY[n3] = GCanvas.getRandom(4096, 8192);
        BubblesAvatar.slotUsed[n3] = true;
        lastAddTime = System.currentTimeMillis();
        nextAddInterval = GCanvas.getRandom(50, 300);
    }

    public static void update() {
        for (int i = 0; i < 50; ++i) {
            if (!slotUsed[i]) continue;
            int n = i;
            coordsY[n] = coordsY[n] + (-speedY[i] + (GameBoard.lastFloorSpeed << 10));
            int n2 = i;
            life[n2] = life[n2] - 1;
            if (life[i] > 0) continue;
            BubblesAvatar.slotUsed[i] = false;
        }
    }

    public static void updateEndPhase() {
        for (int i = 0; i < 50; ++i) {
            if (!slotUsed[i]) continue;
            int n = i;
            coordsY[n] = coordsY[n] + (speedY[i] << 2);
        }
    }

    public static void draw(Graphics graphics) {
        for (int i = 0; i < 50; ++i) {
            if (!slotUsed[i]) continue;
            int n = coordsY[i] >> 10;
            int n2 = RM.getLength(83);
            int n3 = RM.getInts(83)[(GCanvas.getGlobalFrameCount() + life[i]) % n2];
            int n4 = n3 + coordsX[i] >> 10;
            GCanvas.drawSprite(graphics, 24, n4, n, 2);
        }
    }
}

