/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Avatar;
import game.Bubbles;
import game.BubblesAvatar;
import game.Clock;
import game.ColorTool;
import game.Combo;
import game.ComboIndicator;
import game.CustomFonts;
import game.GameBoard;
import game.Keys;
import game.Particles;
import game.RandomGenerator;
import game.StarsEffect;
import java.util.Random;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import tinbrain.GCanvas;
import tinbrain.Menu;
import tinbrain.RM;
import tinbrain.util.GL;

public class Game {
    public static int DIFFICULTY_EASY = 0;
    public static int DIFFICULTY_HARD = 1;
    public static int sGameDifficulty = DIFFICULTY_EASY;
    public static int sSavedScore;
    public static int sSavedFloors;
    public static int sSavedCombos;
    public static Random random;
    public static long sAllFrameTime;
    public static int sCurrentSeed;
    public static int sGameStyle;
    public static boolean sPermitJump;
    public static boolean sModeReplay;
    public static boolean sDisplayJumpUp;
    public static long sStartTime;
    public static boolean sStartTimeIsSet;
    public static int frameCount;
    private static boolean waitForPlayer;
    public static int sCurrentFloor;
    public static boolean sFastScroll;
    public static boolean sGameOver;
    public static boolean sMoveLeftStarted;
    public static boolean sMoveRightStarted;
    public static boolean sMoveUpStarted;
    public static int sMaxCombos;
    public static int sMaxFloors;
    public static boolean sPauseReplay;
    public static long sPauseStartTime;
    public static int sCheatScrollSpeed;
    private static int sCheatComboMsgIndex;
    static long sStartTimeTemp;
    static boolean sReplayOver;
    private static int lastFrame;
    public static int sPlatformnsShakeOffsetX;
    public static int sPlatformnsShakeOffsetY;
    public static int sMovingPlatofrmsSpeed;
    public static int sPowerUpSeed;
    public static int sPowerUpFloorIndexLast;
    public static long sPowerUpNailsTimer;
    public static long sPowerUpNailsIntroTimer;
    public static long sPowerUpNailsOutroTimer;
    public static boolean sPowerUpNailsActive;
    public static boolean sPowerUpNailsOutroActive;
    public static long sPowerUpBubbleTimer;
    public static boolean sPowerUpBubbleActive;
    public static long sPowerUpBrickTimer;
    public static boolean sPowerUpBrickActive;
    public static ColorTool mColorTool;
    public static int ALT_TPAD_LEFT_JUMP;
    public static int ALT_TPAD_RIGHT_JUMP;
    public static int ALT_TPAD_LEFT;
    public static int ALT_TPAD_RIGHT;
    public static int[] ALT_C_TPAD_OFF_RES;
    public static int[] ALT_C_TPAD_ON_RES;
    public static int[] ALT_M_TPAD_OFF_RES;
    public static int[] ALT_M_TPAD_ON_RES;
    public static int sGameHeight;
    public static int sGameWidth;
    private static boolean sHelpMenuTextIsPrepared;
    private static int sOutroTimer;
    private static int sSwitchToOutroTimer;
    private static boolean sEndDemo;

    public static int calcPercentageFrom(int n, int n2) {
        return n * n2 / 100;
    }

    public static void setNewPowerUpRandomSeed() {
        sPowerUpSeed = GCanvas.getRandom(6, 25);
    }

    public static int generateNewPowerUpIdx() {
        int n = sGameStyle == 0 ? 1 : 2;
        return GCanvas.getRandom(0, n + 1);
    }

    private Game() {
    }

    public static final boolean isInGame() {
        return !waitForPlayer;
    }

    public static final void onDraw(Graphics graphics) {
        graphics.setClip(0, 0, sGameWidth, sGameHeight);
        GameBoard.draw(graphics);
        Clock.drawMessage(graphics);
        Avatar.draw();
        ComboIndicator.draw(graphics);
        Particles.draw(graphics);
        if (sPowerUpBubbleActive) {
            Bubbles.draw(graphics);
            BubblesAvatar.draw(graphics);
        }
        Combo.drawMessage(graphics);
        StarsEffect.draw();
        Clock.draw(graphics);
        GameBoard.drawScore(graphics);
        Combo.drawComboLength(graphics);
        if (GCanvas.cheatEnabled(4)) {
            Game.drawCheatComboMessages(graphics);
        }
        Game.renderTouchScreenButtons();
        Game.drawSoftButtons(graphics);
        Game.renderTouchScreenButtonsAlternate();
        Game.drawFingerprint(graphics);
    }

    private static final void renderTouchScreenButtonsAlternate() {
    }

    private static void renderTouchScreenButtons() {
    }

    private static final void drawFingerprint(Graphics graphics) {
        if (GCanvas.cheatEnabled(2)) {
            graphics.setFont(GCanvas.FONT_SMALL);
            graphics.setColor(0);
            int n = GCanvas.getStringWidth("Xendex-Internal") + 2;
            graphics.fillRect(0, 0, n, GCanvas.getFontHeight());
            graphics.setColor(-1);
            graphics.drawString("Xendex-Internal", 1, 0, 0);
        }
    }

    private static void drawCheatComboMessages(Graphics graphics) {
        waitForPlayer = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string = Combo.getMessage1(Combo.comboLengths[sCheatComboMsgIndex]);
        String string2 = Combo.getMessage2(Combo.comboLengths[sCheatComboMsgIndex]);
        n = sGameWidth - CustomFonts.getStringWidth(string) >> 1;
        n3 = sGameWidth - CustomFonts.getStringWidth(string2) >> 1;
        n2 = sGameHeight - CustomFonts.getFontHeight() >> 1;
        CustomFonts.drawString(graphics, string, n, n2 - CustomFonts.getFontHeight());
        CustomFonts.drawString(graphics, string2, n3, n2);
    }

    public static void correctingTimes(long l) {
        int n = (int)(l - sPauseStartTime);
        sStartTimeTemp += (long)n;
        if (sPowerUpNailsActive) {
            sPowerUpNailsTimer += (long)n;
            sPowerUpNailsIntroTimer += (long)n;
        }
        if (sPowerUpNailsOutroActive) {
            sPowerUpNailsOutroTimer += (long)n;
        }
        if (sPowerUpBubbleActive) {
            sPowerUpBubbleTimer += (long)n;
        }
        if (sPowerUpBrickActive) {
            sPowerUpBrickTimer += (long)n;
        }
        GameBoard.updateDestPlatformsTimers(n);
        if (Combo.sStartTimeMsg != 0L) {
            Combo.sStartTimeMsg += (long)n;
        }
    }

    public static Font getFont(int n) {
        switch (n) {
            case 0: {
                return GCanvas.FONT_SMALL;
            }
            case 1: {
                return GCanvas.FONT_MEDIUM;
            }
        }
        return GCanvas.FONT_LARGE;
    }

    public static boolean anySteeringKeyPressed() {
        return GCanvas.isKeyPressed(Keys.sKeys[4]) || GCanvas.isKeyPressed(Keys.sKeys[0]) || GCanvas.isKeyPressed(Keys.sKeys[1]) || GCanvas.isKeyPressed(Keys.sKeys[3]) || GCanvas.isKeyPressed(Keys.sKeys[2]);
    }

    private static final void keyHandling() {
        if (GCanvas.isKeyPressed(Keys.sKeys[4]) && !sMoveUpStarted && sPermitJump) {
            sDisplayJumpUp = false;
            sMoveUpStarted = true;
        }
        if (GCanvas.isKeyPressed(Keys.sKeys[2]) && !GCanvas.isKeyPressed(Keys.sKeys[3])) {
            if (!sMoveLeftStarted && sPermitJump) {
                sMoveLeftStarted = true;
            }
            if (!sMoveUpStarted && sPermitJump) {
                sDisplayJumpUp = true;
                sMoveUpStarted = true;
            }
        } else if (!GCanvas.isKeyPressed(Keys.sKeys[0])) {
            sMoveLeftStarted = Game.keyReleased(1, sMoveLeftStarted);
        }
        if (GCanvas.isKeyPressed(Keys.sKeys[0]) && !GCanvas.isKeyPressed(Keys.sKeys[1])) {
            if (!sMoveLeftStarted) {
                sMoveLeftStarted = true;
            }
        } else if (!GCanvas.isKeyPressed(Keys.sKeys[2])) {
            sMoveLeftStarted = Game.keyReleased(1, sMoveLeftStarted);
        }
        if (GCanvas.isKeyPressed(Keys.sKeys[3]) && !GCanvas.isKeyPressed(Keys.sKeys[2])) {
            if (!sMoveRightStarted && sPermitJump) {
                sMoveRightStarted = true;
            }
            if (!sMoveUpStarted && sPermitJump) {
                sDisplayJumpUp = true;
                sMoveUpStarted = true;
            }
        } else if (!GCanvas.isKeyPressed(Keys.sKeys[1])) {
            sMoveRightStarted = Game.keyReleased(2, sMoveRightStarted);
        }
        if (GCanvas.isKeyPressed(Keys.sKeys[1]) && !GCanvas.isKeyPressed(Keys.sKeys[0])) {
            if (!sMoveRightStarted) {
                sMoveRightStarted = true;
            }
        } else if (!GCanvas.isKeyPressed(Keys.sKeys[3])) {
            sMoveRightStarted = Game.keyReleased(2, sMoveRightStarted);
        }
        if (GCanvas.isLastKeyReleased(Keys.sKeys[0]) || GCanvas.isLastKeyReleased(Keys.sKeys[2])) {
            sMoveLeftStarted = Game.keyReleased(1, sMoveLeftStarted);
        }
        if (GCanvas.isLastKeyReleased(Keys.sKeys[4]) || GCanvas.isLastKeyReleased(Keys.sKeys[2]) || GCanvas.isLastKeyReleased(Keys.sKeys[3])) {
            sPermitJump = true;
        }
        if (GCanvas.isLastKeyReleased(Keys.sKeys[1]) || GCanvas.isLastKeyReleased(Keys.sKeys[3])) {
            sMoveRightStarted = Game.keyReleased(2, sMoveRightStarted);
        }
        if (GCanvas.cheatEnabled(3)) {
            if (GCanvas.isKeyPressed(32768)) {
                --sCheatScrollSpeed;
            }
            if (GCanvas.isKeyPressed(65536)) {
                ++sCheatScrollSpeed;
            }
        }
        if (GCanvas.cheatEnabled(4) && GCanvas.isKeyPressed(65536)) {
            sCheatComboMsgIndex = sCheatComboMsgIndex > 0 ? --sCheatComboMsgIndex : Combo.comboLengths.length - 1;
            GCanvas.resetKeys();
        }
        GCanvas.resetLastKeyReleased();
    }

    public static final void onInput() {
        if (waitForPlayer) {
            Avatar.updateAnim();
            if (Game.anySteeringKeyPressed()) {
                waitForPlayer = false;
            }
        }
        if (!sModeReplay) {
            Game.keyHandling();
        }
        if (!sPauseReplay) {
            Game.doGameLogic();
            ++frameCount;
        }
    }

    public static final boolean keyReleased(int n, boolean bl) {
        if (bl) {
            bl = false;
        }
        return bl;
    }

    public static void moveAvatar() {
        if (sMoveUpStarted) {
            if (Keys.sAutoJump == 0) {
                if (sPermitJump) {
                    Avatar.prepareToJump();
                }
            } else {
                Avatar.prepareToJump();
            }
            sMoveUpStarted = false;
        }
        Avatar.jump();
        if (sMoveLeftStarted) {
            Avatar.move(1);
        }
        if (sMoveRightStarted) {
            Avatar.move(2);
        }
        if (!sMoveLeftStarted && !sMoveRightStarted) {
            Avatar.brake();
        }
        Avatar.fall();
        if (sPowerUpBubbleActive && !Bubbles.isEndPhase()) {
            BubblesAvatar.add(Avatar.getPosX(), Avatar.getPosY());
        }
    }

    private static final void doGameLogic() {
        if (sEndDemo) {
            Menu.changeMenu(26, false);
        }
        Game.moveAvatar();
        if (Avatar.getPosY() < sGameHeight / 4 && !sStartTimeIsSet) {
            sStartTime = frameCount;
            sStartTimeTemp = System.currentTimeMillis();
            sAllFrameTime = 0L;
            sStartTimeIsSet = true;
        }
        if (sStartTimeIsSet) {
            if (GCanvas.frameTime < 0L) {
                if (GCanvas.frameTime > 55L) {
                    sAllFrameTime += GCanvas.frameTime;
                } else if (System.currentTimeMillis() - sStartTimeTemp - sAllFrameTime < 0L) {
                    sAllFrameTime = System.currentTimeMillis() - sStartTimeTemp;
                } else {
                    sStartTimeTemp = System.currentTimeMillis() - sAllFrameTime;
                    sAllFrameTime += 55L;
                }
            } else {
                sAllFrameTime = System.currentTimeMillis() - sStartTimeTemp;
            }
        }
        sFastScroll = Avatar.getPosY() < sGameHeight / 4;
        sCurrentFloor = GameBoard.getCurrentFloor(Avatar.getPosY());
        Avatar.updateAnim();
        if (sStartTimeIsSet) {
            GameBoard.update(sStartTime, sFastScroll);
            Avatar.update(sStartTime, sFastScroll);
        }
        Avatar.updateMovingPlatformsLogic();
        GameBoard.updateMovingPlatforms();
        Avatar.updateDestPlatformsLogic();
        GameBoard.updateDestPlatforms();
        if (Avatar.getPosY() < sGameHeight - Avatar.sAvatarHeight) {
            GameBoard.updatePowerUpCollision();
        }
        if (sPowerUpNailsActive && System.currentTimeMillis() - 7500L > sPowerUpNailsTimer) {
            sPowerUpNailsActive = false;
            sPowerUpNailsOutroTimer = System.currentTimeMillis();
            sPowerUpNailsOutroActive = true;
        }
        if (sPowerUpNailsOutroActive && System.currentTimeMillis() - 300L > sPowerUpNailsOutroTimer) {
            sPowerUpNailsOutroActive = false;
            sPowerUpNailsOutroTimer = 0L;
        }
        if (sPowerUpBrickActive && System.currentTimeMillis() - 7500L > sPowerUpBrickTimer) {
            sPowerUpBrickActive = false;
        }
        GameBoard.calculateScore(sCurrentFloor);
        Combo.update();
        StarsEffect.update();
        Particles.update();
        if (sPowerUpBubbleActive) {
            Bubbles.update();
            BubblesAvatar.update();
            if (Bubbles.isEndPhase()) {
                BubblesAvatar.updateEndPhase();
            }
        }
        Clock.update();
        if (GCanvas.cheatEnabled(5)) {
            GameBoard.sMaxFloor[0] = 10;
            GameBoard.sMaxFloor[1] = 10;
        }
        if (!GCanvas.cheatEnabled(3) && Avatar.getPosY() > sGameHeight - Avatar.sAvatarHeight) {
            sGameOver = true;
            Avatar.setState(7);
            if (!sModeReplay) {
                sStartTimeIsSet = false;
                if (sMaxFloors / 100 > GameBoard.sMaxFloor[sGameStyle]) {
                    GameBoard.sMaxFloor[Game.sGameStyle] = sMaxFloors / 100;
                    if (GameBoard.sMaxFloor[sGameStyle] > 10) {
                        GameBoard.sMaxFloor[Game.sGameStyle] = 10;
                    }
                }
                if (sGameStyle == 0) {
                    Menu.newHighscoreCandidate(0, GameBoard.getScore(), null, 1, sMaxFloors, null, 2, sMaxCombos, null);
                } else {
                    Menu.newHighscoreCandidate(3, GameBoard.getScore(), null, 4, sMaxFloors, null, 5, sMaxCombos, null);
                }
            } else if (sReplayOver) {
                sStartTimeIsSet = false;
                if (Avatar.getPosY() > sGameHeight) {
                    sGameStyle = Menu.sTempGameStyle;
                    Avatar.character = Menu.sTempCharacter;
                    GameBoard.sStartingFloorStyle = Menu.sTempStartingFloorStyle;
                    Keys.sAutoJump = Menu.sTempRejumpOption;
                    if (Menu.sWatchingLoadedReplay) {
                        Menu.changeMenu(10, false);
                    } else {
                        Menu.changeMenu(18, true);
                    }
                }
            }
        }
    }

    public static final void init() {
        sGameHeight = GCanvas.getHeight() - 0;
        sGameWidth = GCanvas.getWidth();
        mColorTool = new ColorTool();
        sMovingPlatofrmsSpeed = sGameWidth * 1024 / 240 >> 10 << 10;
        sMovingPlatofrmsSpeed = sMovingPlatofrmsSpeed == 0 ? 1024 : sMovingPlatofrmsSpeed;
        System.out.println("sMovingPlatofrmsSpeed = " + sMovingPlatofrmsSpeed);
        Game.setNewPowerUpRandomSeed();
        sPlatformnsShakeOffsetX = sGameWidth * 1 / 240;
        sPlatformnsShakeOffsetY = sGameHeight * 1 / 320;
        sPlatformnsShakeOffsetX = sPlatformnsShakeOffsetX == 0 ? 1 : sPlatformnsShakeOffsetX;
        sPlatformnsShakeOffsetY = sPlatformnsShakeOffsetY == 0 ? 1 : sPlatformnsShakeOffsetY;
        Particles.init();
        Bubbles.init();
        BubblesAvatar.init();
        GCanvas.touchScreenSetUpKeyboardBounds();
    }

    public static final int getTimeSeed() {
        long l = System.currentTimeMillis();
        return (int)(l & Integer.MAX_VALUE);
    }

    public static void setStyle(int n) {
        sGameStyle = n;
        GameBoard.sStartingFloorStyle = sGameStyle == 0 ? 0 : 0;
    }

    public static final void initGame(boolean bl) {
        if (bl) {
            Menu.startLoading(139);
        }
        if (random == null) {
            random = new Random();
        }
        CustomFonts.initFonts();
        StarsEffect.init();
        Particles.clear();
        Clock.init();
        if (!sModeReplay) {
            sCurrentSeed = Game.getTimeSeed();
        }
        RandomGenerator.setSeed(sCurrentSeed);
        ComboIndicator.init();
        GameBoard.init();
        Avatar.init();
        sPowerUpBubbleActive = false;
        sPowerUpNailsActive = false;
        Game.restart();
        sCurrentFloor = GameBoard.getCurrentFloor(Avatar.getPosY());
        if (bl) {
            Menu.stopLoading();
        }
    }

    public static final void restart() {
        if (sModeReplay) {
            GCanvas.setSoftButton(14, 9, true);
        } else {
            GCanvas.setSoftButton(-1, 9, true);
        }
        sReplayOver = false;
        lastFrame = 0;
        sAllFrameTime = 0L;
        sCheatComboMsgIndex = Combo.comboLengths.length - 1;
        sCheatScrollSpeed = 0;
        sPermitJump = true;
        sPauseReplay = false;
        sMaxFloors = 0;
        sMaxCombos = 0;
        sGameOver = false;
        waitForPlayer = !sModeReplay;
        sMoveLeftStarted = false;
        sMoveRightStarted = false;
        sMoveUpStarted = false;
        sFastScroll = false;
        sStartTimeIsSet = false;
        sPowerUpBrickActive = false;
        frameCount = 0;
        Game.setNewPowerUpRandomSeed();
        sPowerUpFloorIndexLast = 0;
        sPowerUpNailsTimer = 0L;
        sPowerUpNailsIntroTimer = 0L;
        sPowerUpNailsActive = false;
        sPowerUpNailsOutroTimer = 0L;
        sPowerUpNailsOutroActive = false;
        GCanvas.sTSCurrentTouchedButton = -1;
        GCanvas.sTSButtonPressed = false;
        Clock.restart();
        GameBoard.restart();
        Combo.restart();
        Avatar.restart();
        StarsEffect.removeAllStars();
        StarsEffect.update();
    }

    public static final void notify(boolean bl) {
        if (bl) {
            sMoveLeftStarted = Game.keyReleased(1, sMoveLeftStarted);
            sMoveRightStarted = Game.keyReleased(2, sMoveRightStarted);
            sPermitJump = true;
            if (sModeReplay) {
                GCanvas.setSoftButton(14, 9, true);
            } else {
                GCanvas.setSoftButton(-1, 9, true);
            }
        }
    }

    private static void drawSoftButtons(Graphics graphics) {
        int n;
        byte by;
        graphics.setColor(-1);
        graphics.setFont(GCanvas.softButtonFont);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (GCanvas.leftSoftButton != -1) {
            by = GCanvas.softkeys[GCanvas.leftSoftButton][2];
            if (by < 0) {
                n = RM.getShortFromBytes(GCanvas.softkeys[GCanvas.leftSoftButton], 0);
                graphics.drawString(RM.t(n), 3, sGameHeight - 1 + 0 + 0, 36);
            } else {
                n2 = 3;
                n3 = sGameHeight - 1;
                n4 = 36;
                GCanvas.drawImage(by, n2, n3, true, n4);
            }
        }
        if (GCanvas.rightSoftButton != -1) {
            by = GCanvas.softkeys[GCanvas.rightSoftButton][2];
            if (by < 0) {
                n = RM.getShortFromBytes(GCanvas.softkeys[GCanvas.rightSoftButton], 0);
                graphics.drawString(RM.t(n), sGameWidth - 3, sGameHeight - 1 + 0 + 0, 40);
            } else {
                n2 = sGameWidth - 3;
                n3 = sGameHeight - 1;
                n4 = 40;
                GCanvas.drawImage(by, n2, n3, true, n4);
            }
        }
    }

    public static final void setOptionDefaults() {
    }

    public static final void performMenuAction(int n, int n2) {
        switch (n) {
            case 10: {
                Game.forgetGameRes();
                Menu.changeMenu(7, false);
                break;
            }
            case 9: {
                Game.forgetGameRes();
                if (GL.handsonDemoIsActive()) {
                    Menu.changeMenu(26, false);
                    break;
                }
                Menu.performMenuAction(37);
                break;
            }
            case 8: {
                Game.forgetGameRes();
                if (GL.handsonDemoIsActive()) {
                    Menu.changeMenu(26, false);
                    break;
                }
                Menu.performMenuAction(37);
            }
        }
    }

    public static final boolean evaluateCondition(int n) {
        switch (n) {
            case 8: {
                return GL.handsonDemoIsActive();
            }
            case 10: {
                return !GL.handsonDemoIsActive();
            }
            case 6: {
                return false;
            }
            case 7: {
                return false;
            }
            case 17: {
                return Game.isInGame();
            }
            case 11: {
                return GL.handsonLanguageIsAvailable(0);
            }
            case 12: {
                return GL.handsonLanguageIsAvailable(1);
            }
            case 13: {
                return GL.handsonLanguageIsAvailable(2);
            }
            case 14: {
                return GL.handsonLanguageIsAvailable(3);
            }
            case 15: {
                return GL.handsonLanguageIsAvailable(4);
            }
            case 16: {
                return GL.handsonLanguageIsAvailable(5);
            }
        }
        return true;
    }

    private static final void prepareAboutScreen() {
        RM.prepareVarText(2, new String[]{Menu.getMidletInfo(0), Menu.getMidletInfo(1), Menu.getMidletInfo(0), Menu.getMidletInfo(0)});
    }

    private static final void prepareHelpMenuText(boolean bl) {
        if (sHelpMenuTextIsPrepared && !bl) {
            return;
        }
        sHelpMenuTextIsPrepared = true;
        String[] stringArray = new String[3];
        if (GL.handsonDemoIsActive()) {
            if (GL.handsonMoreGamesIsMenu()) {
                RM.prepareVarText(16, RM.t(24));
                stringArray[0] = RM.t(127);
                stringArray[1] = RM.t(129);
                stringArray[2] = RM.t(16);
                RM.prepareVarText(18, stringArray);
            } else {
                stringArray[0] = RM.t(127);
                stringArray[1] = RM.t(129);
                stringArray[2] = "";
                RM.prepareVarText(18, stringArray);
            }
        } else if (GL.handsonMoreGamesIsMenu()) {
            RM.prepareVarText(17, RM.t(24));
            stringArray[0] = RM.t(127);
            stringArray[1] = RM.t(129);
            stringArray[2] = RM.t(17);
            RM.prepareVarText(18, stringArray);
        } else {
            stringArray[0] = RM.t(127);
            stringArray[1] = RM.t(129);
            stringArray[2] = "";
            RM.prepareVarText(18, stringArray);
        }
    }

    private static final void prepareMenuExpiredScreen() {
        int n = 151;
        if (GL.handsonMoreGamesGetUrl() == null) {
            n = 152;
        } else {
            Menu.setSoftkeys(26, 24, 25);
        }
        RM.prepareVarText(26, Menu.getMidletInfo(0), RM.t(n));
    }

    public static final void onPrepareMenuChange(int n, int n2) {
        Menu.setMenuCaptionImage(-1, true);
        boolean bl = n != 7;
        Menu.showUpDownArrows(bl);
        switch (n) {
            case 7: {
                Menu.stopMusic();
                sOutroTimer = 5000;
                if (GL.handsonDemoIsActive()) {
                    Menu.setMenuOption(7, 3, (byte)-1);
                    Menu.setMenuOption(7, 4, (byte)-1);
                    sOutroTimer = 2000;
                } else if (GL.handsonMoreGamesIsExit()) {
                    Menu.setMenuOption(7, 3, (byte)31);
                }
                Menu.setMenuCaptionImage(-1);
                break;
            }
            case 6: {
                Game.prepareAboutScreen();
                break;
            }
            case 15: {
                break;
            }
            case 26: {
                sSwitchToOutroTimer = 5000;
                Game.prepareMenuExpiredScreen();
                break;
            }
            case 27: {
                Game.prepareMenuExpiredScreen();
                break;
            }
        }
    }

    private static final void forgetGameRes() {
        RM.forget(RM.modernGame);
        RM.forget(RM.classicGame);
    }

    public static final void onLanguageChanged() {
        GL.handsonDemoInit("P3TG0TJ0H");
        GL.handsonMoreGamesReadLabel();
        if (GL.sHandsonMoreGamesLabel == null || GL.sHandsonMoreGamesLabel.length() == 0) {
            GL.sHandsonMoreGamesLabel = GL.handsonDemoIsActive() ? new String(RM.t(154)) : new String(RM.t(143));
        }
        RM.prepareVarText(24, GL.sHandsonMoreGamesLabel);
        Game.prepareHelpMenuText(true);
    }

    public static final void menuDrawItem(Graphics graphics, Font font, int n, String string, int n2, int n3, int n4) {
        Menu.drawMenuItem(graphics, font, n, string, n2, n3, n4);
    }

    private static final void menuDrawOutroScreen(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(-1);
        graphics.fillRect(0, 0, GCanvas.getWidth(), GCanvas.getHeight());
        GCanvas.drawImage(2, sGameWidth - RM.getWidth(2) >> 1, (sGameHeight - RM.getHeight(2) >> 1) + 0, 0);
    }

    public static final boolean menuProcessActions() {
        switch (Menu.getCurrentMenu()) {
            case 26: {
                sSwitchToOutroTimer -= 55;
                break;
            }
            case 7: {
                if ((sOutroTimer -= 55) >= 0) break;
                Menu.performMenuAction(37);
                return true;
            }
        }
        return false;
    }

    public static final void drawCustomMenuBackground(Graphics graphics, int n, int n2, int n3, int n4) {
        switch (n) {
            case 7: {
                Game.menuDrawOutroScreen(graphics, n, n2, n3, n4);
                break;
            }
            default: {
                Game.menuDrawStandardBackground(n, n2, n3, n4);
            }
        }
    }

    public static final void drawBackgroundImage() {
        GCanvas.drawImage(26, GCanvas.width >> 1, GCanvas.height >> 1, 3);
    }

    private static void menuDrawStandardBackground(int n, int n2, int n3, int n4) {
        Game.drawBackgroundImage();
        switch (n) {
            case 0: {
                Game.drawHead();
                GCanvas.drawImage(27, sGameWidth - RM.getWidth(27) >> 1, 2, 20);
                break;
            }
            case -1: 
            case 33: {
                Game.drawHead();
                break;
            }
            default: {
                if (n == 16 || n == 17) break;
                Game.drawHead();
            }
        }
    }

    private static final void drawHead(int n) {
        int n2 = Menu.getCurrentMenu() == 0 ? 29 : 28;
        int n3 = RM.getLength(83);
        int n4 = RM.getInts(83)[GCanvas.getGlobalFrameCount() % n3];
        int n5 = (Menu.MENU_SEPERATOR_BOTTOM << 10) + n4;
        int n6 = GCanvas.getWidth() - RM.getWidth(28);
        if (n2 == 29) {
            GCanvas.drawImage(n2, n6, n + (n5 >> 10), true, 36);
        } else {
            GCanvas.drawImage(n2, n6, n + (n5 >> 10), true, 36);
        }
    }

    private static final void drawHead() {
        Game.drawHead(0);
    }

    public static int calcPercentage(int n, int n2) {
        int n3 = GCanvas.div(n2 << 10, 102400);
        return GCanvas.mul(n << 10, n3) >> 10;
    }

    public static final int menuDrawSelectionBar(Graphics graphics, int n, int n2, int n3) {
        if (Menu.getCurrentMenu() == 7) {
            return n;
        }
        if (n3 == 24) {
            if (n == -22528) {
                return -1;
            }
            return -3407872;
        }
        return n;
    }

    public static String readMoreGamesUrl() {
        return GL.handsonMoreGamesReadUrl();
    }

    private static boolean demoIsDemoExpired() {
        return GameBoard.getCurrentFloor(Avatar.getPosY()) + 1 > 50;
    }

    private static void demoPrintIngameDemoMode(Graphics graphics) {
        if (Menu.getCurrentMenu() == 7) {
            return;
        }
        if (GCanvas.getGlobalFrameCount() % 20 > 10) {
            graphics.setFont(GCanvas.FONT_SMALL);
            int n = 1;
            int n2 = 1;
            int n3 = 20;
            if (Menu.mode == 2) {
                n += 0;
                n2 += 0;
            }
            graphics.setColor(-16777216);
            graphics.drawString(RM.t(149), n - 1, n2 - 1, n3);
            graphics.drawString(RM.t(149), n + 1, n2 - 1, n3);
            graphics.drawString(RM.t(149), n - 1, n2 + 1, n3);
            graphics.drawString(RM.t(149), n + 1, n2 + 1, n3);
            graphics.setColor(-256);
            graphics.drawString(RM.t(149), n, n2, n3);
        }
    }

    private static void demoPrintMenuDemoMode(Graphics graphics) {
        Game.demoPrintIngameDemoMode(graphics);
    }

    public static void demoHandleDemoMode(Graphics graphics) {
        if (!GL.handsonDemoIsActive()) {
            return;
        }
        if (Menu.getMode() == 2) {
            if (Game.demoIsDemoExpired()) {
                sEndDemo = true;
            } else {
                Game.demoPrintIngameDemoMode(graphics);
            }
        } else {
            Game.demoPrintMenuDemoMode(graphics);
        }
    }

    public static final void drawSoftkeyLabels(Graphics graphics, int n, int n2, String string, int n3) {
        if (Menu.getCurrentMenu() == 7) {
            graphics.setColor(-16777216);
            graphics.drawString(string, n, n2, n3);
        } else {
            graphics.setColor(-1);
            graphics.drawString(string, n, n2, n3);
        }
    }

    static {
        sCurrentSeed = 0;
        sGameStyle = 0;
        sPermitJump = true;
        lastFrame = 0;
        sMovingPlatofrmsSpeed = 1024;
        ALT_TPAD_LEFT_JUMP = 0;
        ALT_TPAD_RIGHT_JUMP = 1;
        ALT_TPAD_LEFT = 2;
        ALT_TPAD_RIGHT = 3;
        ALT_C_TPAD_OFF_RES = new int[]{-1, -1, -1, -1};
        ALT_C_TPAD_ON_RES = new int[]{-1, -1, -1, -1};
        ALT_M_TPAD_OFF_RES = new int[]{-1, -1, -1, -1};
        ALT_M_TPAD_ON_RES = new int[]{-1, -1, -1, -1};
        sHelpMenuTextIsPrepared = false;
        sOutroTimer = 0;
        sSwitchToOutroTimer = 0;
        sEndDemo = false;
    }
}

