/*
 * Decompiled with CFR 0.152.
 */
package game;

public class ColorTool {
    private int rgb_r;
    private int rgb_g;
    private int rgb_b;
    private int hsb_h;
    private int hsb_s;
    private int hsb_b;
    private int[] tab_hsb_h = new int[3];
    private int[] tab_hsb_s = new int[3];
    private int[] tab_hsb_b = new int[3];
    public final int SET_ACT;
    public final int SET_START;
    public final int SET_END;

    public ColorTool() {
        this.SET_ACT = 0;
        this.SET_START = 1;
        this.SET_END = 2;
    }

    private int clamp(int n, int n2, int n3) {
        return n < n2 ? n2 : (n > n3 ? n3 : n);
    }

    public void HSBToRGBInternal(int n, int n2, int n3) {
        n2 = n2 * 255 / 100;
        n3 = n3 * 255 / 100;
        int n4 = 15300;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = n;
        int n9 = n2;
        int n10 = n3;
        if (n9 == 0) {
            n5 = n10;
            n6 = n10;
            n7 = n10;
        } else {
            int n11 = n8 == 360 ? 0 : n8;
            int n12 = n11 % 60;
            int n13 = n10 * n9;
            int n14 = n10 - n13 / 255;
            int n15 = n10 - n13 * n12 / n4;
            int n16 = n10 - n13 * (60 - n12) / n4;
            switch (n11 /= 60) {
                case 0: {
                    n5 = n10;
                    n6 = n16;
                    n7 = n14;
                    break;
                }
                case 1: {
                    n5 = n15;
                    n6 = n10;
                    n7 = n14;
                    break;
                }
                case 2: {
                    n5 = n14;
                    n6 = n10;
                    n7 = n16;
                    break;
                }
                case 3: {
                    n5 = n14;
                    n6 = n15;
                    n7 = n10;
                    break;
                }
                case 4: {
                    n5 = n16;
                    n6 = n14;
                    n7 = n10;
                    break;
                }
                case 5: {
                    n5 = n10;
                    n6 = n14;
                    n7 = n15;
                    break;
                }
                default: {
                    n5 = 0;
                    n6 = 0;
                    n7 = 0;
                }
            }
        }
        this.rgb_r = n5;
        this.rgb_g = n6;
        this.rgb_b = n7;
    }

    public void RGBToHSBInternal(int n, int n2, int n3) {
        int n4 = Math.min(Math.min(n, n2), n3);
        this.hsb_b = Math.max(Math.max(n, n2), n3);
        if (n4 == this.hsb_b) {
            this.hsb_h = 0;
        } else {
            if (n == this.hsb_b) {
                this.hsb_h = 0 + (n2 - n3) * 60 / (this.hsb_b - n4);
            }
            if (n2 == this.hsb_b) {
                this.hsb_h = 120 + (n3 - n) * 60 / (this.hsb_b - n4);
            }
            if (n3 == this.hsb_b) {
                this.hsb_h = 240 + (n - n2) * 60 / (this.hsb_b - n4);
            }
        }
        if (this.hsb_h < 0) {
            this.hsb_h += 360;
        }
        this.hsb_s = this.hsb_b == 0 ? 0 : (this.hsb_b - n4) * 100 / this.hsb_b;
        this.hsb_b = 100 * this.hsb_b / 255;
    }

    public int HSBToRGBHEX(int n, int n2, int n3) {
        this.HSBToRGBInternal(n, n2, n3);
        return this.RGBToRGBHEX(this.rgb_r, this.rgb_g, this.rgb_b);
    }

    public int RGBToHSBHEX(int n, int n2, int n3) {
        this.RGBToHSBInternal(n, n2, n3);
        return this.HSBToHSBHEX(this.hsb_h, this.hsb_s, this.hsb_b);
    }

    public int RGBHEXToHSBHEX(int n) {
        this.rgb_r = this.getRFromRGBHEX(n);
        this.rgb_g = this.getGFromRGBHEX(n);
        this.rgb_b = this.getBFromRGBHEX(n);
        return this.RGBToHSBHEX(this.rgb_r, this.rgb_g, this.rgb_b);
    }

    public int RGBToRGBHEX(int n, int n2, int n3) {
        n = this.clamp(n, 0, 255);
        n2 = this.clamp(n2, 0, 255);
        n3 = this.clamp(n3, 0, 255);
        return 0xFF000000 | n << 16 | (n2 << 8 | n3);
    }

    public int getBFromRGBHEX(int n) {
        return n & 0xFF;
    }

    public int getGFromRGBHEX(int n) {
        return (n & 0xFF00) >> 8;
    }

    public int getRFromRGBHEX(int n) {
        return (n & 0xFF0000) >> 16;
    }

    public int HSBToHSBHEX(int n, int n2, int n3) {
        n = this.clamp(n, 0, 360);
        n2 = this.clamp(n2, 0, 100);
        n3 = this.clamp(n3, 0, 100);
        return 0 | n << 16 | (n2 << 8 | n3);
    }

    public int getBFromHSBHEX(int n) {
        return n & 0xFF;
    }

    public int getSFromHSBHEX(int n) {
        return (n & 0xFF00) >> 8;
    }

    public int getHFromHSBHEX(int n) {
        return (n & 0xFFFF0000) >> 16;
    }
}

