/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Game;
import game.GameBoard;
import javax.microedition.lcdui.Graphics;
import tinbrain.GCanvas;
import tinbrain.Menu;
import tinbrain.RM;

public class Particles {
    private static int MAX_PLATFORMS = 16;
    private static int maxParticles;
    private static int[][] coordsX;
    private static int[][] coordsY;
    private static int[][] cols;
    private static byte[][] life;
    private static byte[][] size;
    private static short[][] speedY;
    private static short[][] speedYY;
    private static short[][] speedX;
    private static byte[][] cycles;
    private static boolean[] slotUsed;
    private static boolean[] altPhys;
    private static int maxWidth;
    private static int maxParticlesInLine;
    private static int borderCycle;
    private static final int[] floorColsClock;
    private static final int[] floorColsPower;
    private static final int[] powerUpsCols;
    private static final int[] starsColsClock;
    private static final int[] starsColsPower;

    public static void init() {
        maxWidth = Game.sGameWidth;
        maxParticlesInLine = RM.getWidth(47);
        maxParticles = maxParticlesInLine >> 0;
        coordsX = new int[MAX_PLATFORMS][maxParticles];
        coordsY = new int[MAX_PLATFORMS][maxParticles];
        cols = new int[MAX_PLATFORMS][maxParticles];
        life = new byte[MAX_PLATFORMS][maxParticles];
        speedX = new short[MAX_PLATFORMS][maxParticles];
        speedY = new short[MAX_PLATFORMS][maxParticles];
        speedYY = new short[MAX_PLATFORMS][maxParticles];
        size = new byte[MAX_PLATFORMS][maxParticles];
        cycles = new byte[MAX_PLATFORMS][maxParticles];
        slotUsed = new boolean[MAX_PLATFORMS];
        altPhys = new boolean[MAX_PLATFORMS];
        borderCycle = 12;
    }

    public static void clear() {
        for (int i = 0; i < MAX_PLATFORMS; ++i) {
            for (int j = 0; j < maxParticles; ++j) {
                Particles.coordsX[i][j] = 0;
                Particles.coordsY[i][j] = 0;
                Particles.cols[i][j] = 0;
                Particles.life[i][j] = 0;
                Particles.speedX[i][j] = 0;
                Particles.speedY[i][j] = 0;
                Particles.speedYY[i][j] = 0;
                Particles.size[i][j] = 0;
                Particles.cycles[i][j] = 0;
            }
            Particles.slotUsed[i] = false;
            Particles.altPhys[i] = false;
        }
    }

    private static int searchFreeSlot() {
        int n = -1;
        for (int i = 0; i < MAX_PLATFORMS; ++i) {
            if (slotUsed[i]) continue;
            n = i;
            break;
        }
        return n;
    }

    public static void initEffectByFloorStyle(int n, int n2, int n3, int n4) {
        int n5 = Game.sGameStyle == 0 ? floorColsClock[n4] : floorColsPower[n4];
        Particles.internalInitEffect(n, n2, n3, n5, false, false);
    }

    public static void initEffectByPowerUpIdx(int n, int n2, int n3, int n4) {
        Particles.internalInitEffect(n, n2, n3, powerUpsCols[n4], true, false);
    }

    public static void initEffectByStars(int n, int n2, int n3) {
        int n4 = n + (n3 >> 1);
        int n5 = n3 * 90 / 100;
        int n6 = n4 - n5;
        Particles.internalInitEffect(n6, n2, n5, -1, true, true);
    }

    public static void initEffectByBrick(int n, int n2, int n3, int n4) {
        int n5 = n + (n3 >> 1);
        int n6 = n3 * 3 / 10;
        int n7 = n5 - n6;
        Particles.internalInitEffect(n7, n2, n6, -2192267, true, false);
    }

    private static void internalInitEffect(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5 = Particles.searchFreeSlot();
        if (n5 != -1) {
            int n6 = 0;
            int n7 = n3 >> n6;
            for (int i = 0; i < n7; ++i) {
                int n8;
                int n9;
                int n10;
                int n11;
                int n12;
                if (bl2) {
                    Particles.coordsX[n5][i] = n + (i << n6) << 10;
                    Particles.coordsY[n5][i] = n2 << 10;
                    Particles.life[n5][i] = 30;
                    Particles.speedY[n5][i] = (short)(GCanvas.getRandom(2048, 12288) >> 1);
                    Particles.speedYY[n5][i] = (short)(GCanvas.getRandom(2048, 12288) >> 1);
                    Particles.size[n5][i] = (byte)GCanvas.getRandom(1, 4);
                } else {
                    Particles.coordsX[n5][i] = n + (i << n6) << 10;
                    Particles.coordsY[n5][i] = n2 << 10;
                    Particles.life[n5][i] = 50;
                    Particles.speedY[n5][i] = (short)GCanvas.getRandom(2048, 12288);
                    Particles.speedYY[n5][i] = (short)GCanvas.getRandom(2048, 12288);
                    Particles.size[n5][i] = (byte)GCanvas.getRandom(1, 4);
                }
                int n13 = -(n3 >> 1) + (i << n6);
                if (!bl) {
                    n12 = GCanvas.div(GCanvas.mul(n13 << 10, 20480), maxWidth) >> 10;
                    Particles.speedX[n5][i] = (short)n12;
                } else {
                    n12 = GCanvas.div(GCanvas.mul(n13 << 10, 102400), maxWidth) >> 10;
                    Particles.speedX[n5][i] = (short)n12;
                }
                if (n4 == -1) {
                    n12 = GCanvas.getRandom(0, 4);
                    n11 = Game.sGameStyle == 0 ? starsColsClock[n12] : starsColsPower[n12];
                    n10 = Game.mColorTool.RGBHEXToHSBHEX(n11);
                    n9 = Game.mColorTool.getHFromHSBHEX(n10);
                    n8 = Game.mColorTool.getSFromHSBHEX(n10);
                    int n14 = Game.mColorTool.getBFromHSBHEX(n10);
                    Particles.cols[n5][i] = n11 = Game.mColorTool.HSBToRGBHEX(n9 += GCanvas.getRandom(-30, 30), n8 += GCanvas.getRandom(-30, 0), n14 += GCanvas.getRandom(Game.sGameStyle == 0 ? -60 : -30, 0));
                } else if (n4 == -2) {
                    n12 = -6361857;
                    n11 = Game.mColorTool.RGBHEXToHSBHEX(n12);
                    n10 = Game.mColorTool.getHFromHSBHEX(n11);
                    n9 = Game.mColorTool.getSFromHSBHEX(n11);
                    n8 = Game.mColorTool.getBFromHSBHEX(n11);
                    Particles.cols[n5][i] = n12 = Game.mColorTool.HSBToRGBHEX(n10 += GCanvas.getRandom(-20, 20), n9 += GCanvas.getRandom(-20, 20), n8 += GCanvas.getRandom(-20, 20));
                } else {
                    n12 = n4;
                    n11 = Game.mColorTool.RGBHEXToHSBHEX(n12);
                    n10 = Game.mColorTool.getHFromHSBHEX(n11);
                    n9 = Game.mColorTool.getSFromHSBHEX(n11);
                    n8 = Game.mColorTool.getBFromHSBHEX(n11);
                    Particles.cols[n5][i] = n12 = Game.mColorTool.HSBToRGBHEX(n10 += GCanvas.getRandom(-20, 20), n9 += GCanvas.getRandom(-20, 20), n8 += GCanvas.getRandom(-20, 20));
                }
                Particles.cycles[n5][i] = 0;
            }
            Particles.slotUsed[n5] = true;
            Particles.altPhys[n5] = bl;
        }
    }

    public static void update() {
        for (int i = 0; i < MAX_PLATFORMS; ++i) {
            if (!slotUsed[i]) continue;
            boolean bl = true;
            boolean bl2 = altPhys[i];
            for (int j = 0; j < maxParticles; ++j) {
                if (life[i][j] <= 0) continue;
                bl = false;
                if (!bl2) {
                    int[] nArray = coordsY[i];
                    int n = j;
                    nArray[n] = nArray[n] + (speedY[i][j] + (GameBoard.lastFloorSpeed << 10));
                    int[] nArray2 = coordsY[i];
                    int n2 = j;
                    nArray2[n2] = nArray2[n2] - speedYY[i][j];
                    int[] nArray3 = coordsX[i];
                    int n3 = j;
                    nArray3[n3] = nArray3[n3] + speedX[i][j];
                    byte[] byArray = life[i];
                    int n4 = j;
                    byArray[n4] = (byte)(byArray[n4] - 1);
                    if (speedYY[i][j] > 0) {
                        short[] sArray = speedYY[i];
                        int n5 = j;
                        sArray[n5] = (short)(sArray[n5] - 1024);
                        if (speedYY[i][j] < 0) {
                            Particles.speedYY[i][j] = 0;
                        }
                    }
                    short[] sArray = speedY[i];
                    int n6 = j;
                    sArray[n6] = (short)(sArray[n6] + (speedY[i][j] >> 6));
                    byte[] byArray2 = cycles[i];
                    int n7 = j;
                    byArray2[n7] = (byte)(byArray2[n7] + 1);
                    if (cycles[i][j] > borderCycle) {
                        Particles.cycles[i][j] = 0;
                        if (size[i][j] > 1) {
                            byte[] byArray3 = size[i];
                            int n8 = j;
                            byArray3[n8] = (byte)(byArray3[n8] - 1);
                        }
                    }
                } else {
                    int[] nArray = coordsY[i];
                    int n = j;
                    nArray[n] = nArray[n] + (speedY[i][j] + (GameBoard.lastFloorSpeed << 10));
                    int[] nArray4 = coordsY[i];
                    int n9 = j;
                    nArray4[n9] = nArray4[n9] - speedYY[i][j];
                    int[] nArray5 = coordsX[i];
                    int n10 = j;
                    nArray5[n10] = nArray5[n10] + speedX[i][j];
                    byte[] byArray = life[i];
                    int n11 = j;
                    byArray[n11] = (byte)(byArray[n11] - 1);
                    byte[] byArray4 = cycles[i];
                    int n12 = j;
                    byArray4[n12] = (byte)(byArray4[n12] + 1);
                    if (cycles[i][j] > borderCycle) {
                        Particles.cycles[i][j] = 0;
                        if (size[i][j] > 1) {
                            byte[] byArray5 = size[i];
                            int n13 = j;
                            byArray5[n13] = (byte)(byArray5[n13] - 1);
                        }
                    }
                }
                if (Menu.mode != 2) continue;
                int n = GameBoard.getWallWidth() << 10;
                int n14 = Game.sGameWidth - GameBoard.getWallWidth() << 10;
                if (coordsX[i][j] > n && coordsX[i][j] < n14) continue;
                Particles.speedX[i][j] = -speedX[i][j];
            }
            if (!bl) continue;
            Particles.slotUsed[i] = false;
        }
    }

    public static void draw(Graphics graphics) {
        for (int i = 0; i < MAX_PLATFORMS; ++i) {
            if (!slotUsed[i]) continue;
            for (int j = 0; j < maxParticles; ++j) {
                if (life[i][j] <= 0) continue;
                int n = coordsX[i][j] >> 10;
                int n2 = coordsY[i][j] >> 10;
                int n3 = cols[i][j];
                byte by = size[i][j];
                graphics.setColor(n3);
                graphics.fillRect(n, n2, (int)by, (int)by);
            }
        }
    }

    static {
        floorColsClock = new int[]{-8149436, -2677485, -3102350, -6718114, -9615080, -12496778, -8690098, -4878779, -2848490, -4013375, -13141248};
        floorColsPower = new int[]{-6040328, -879884, -12036984, -798021, -1790464, -2730752, -7551535, -8026236, -3954265, -6565141, -267377};
        powerUpsCols = new int[]{-9571336, -1347256, -1706763};
        starsColsClock = new int[]{-16743937, -256, -65536, -16716281};
        starsColsPower = new int[]{-16711681, -256, -65536, -65282};
    }
}

