/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class CActor {
    public static int s_originalActorCount;
    public static int s_actorCount;
    public static CActor[] s_actors;
    public static short[][] s_actorsBaseInfo;
    public static CActor[] s_activeActors;
    public static int s_activeActorsCount;
    public static CActor[] s_actorDrawListBg;
    public static int s_actorInBgListNum;
    public static CActor[] s_actorDrawListNormal;
    public static int s_actorInNormalListNum;
    public static CActor[] s_EnemyActor;
    public static int s_EnemyActorCount;
    public static byte[] s_classesFlags;
    public static byte[] s_classesAnimID;
    public static byte[] s_classesDefaultZ;
    public static short[][] s_classesDefaultActiveBoxes;
    public static int s_actorClassCount;
    static int m_heroActorID;
    static CHero m_hero;
    static CActor m_frisianLeader;
    public static int ACTORS_BASE_INFO_CAPACITY;
    int m_actorID;
    int m_classID;
    int m_flags;
    int m_state;
    int m_actionID;
    int m_prevActionID;
    int m_mapX;
    int m_realX;
    int m_mapY;
    int m_realY;
    int m_z;
    short[] m_activeZoneBox = new short[4];
    short[] m_oriActiveBox;
    short[] m_Parameters;
    int m_actorStatus;
    int m_vX;
    int m_vY;
    int m_aX;
    int m_aY;
    int m_hp;
    int m_attackPoint;
    int m_Palette;
    int m_currStep;
    public short[] m_collisionBox = new short[4];
    public short[] m_attackBox;
    public static byte[] s_phyEnvInfo;
    ASprite m_sprite;
    int m_nextVillagerID;
    int m_weaponID;
    int m_waitTime;
    short[] m_savedData = new short[10];
    int m_timelineIndex = -1;
    int m_currentKeyFrameIndex = 0;
    static int s_curTrailerTextID;
    int m_attackedCount;
    int m_currAFrame;
    int m_currTime;
    static short[] s_colBoxTmp;
    static boolean s_bBlockFront;
    static boolean s_bBlockBack;
    static boolean s_bBlockBottom;
    static boolean s_bWillFall;
    static int s_frontTile;
    static int s_backTile;
    static int s_topTile;
    static int s_bottomTile;
    boolean m_canRun;
    static boolean s_canBackRun;
    boolean m_canStand;
    boolean m_isOnslope;
    boolean m_canJump;
    static boolean m_canHang;
    static boolean m_canHangJump;
    static boolean m_canStickH;
    static boolean m_canStickHJump;
    static boolean m_canEdgeClimb;
    static boolean m_canEdgeWalk;
    static boolean m_canEdgeTurn;
    static boolean m_canEdgeJump;
    static boolean m_canEdgeHang;
    static boolean m_canEdgeSpan;
    static boolean canEdgeRotateBack;
    static boolean m_canClimb;
    static boolean m_canBackClimb;
    static boolean m_canBackClimbUp;
    static boolean m_canSlide;
    static boolean m_canBackClimbLeft;
    static boolean m_canBackClimbRight;
    static boolean m_canLeaveClimbHorizonal;
    static boolean m_canBackClimbDownward;
    static boolean m_isSink;
    static boolean m_isSlowMotion;
    static boolean m_isTileLethal;
    static boolean m_canStandUp;
    static int m_tileInjurePoint;
    static int s_hangPositionY;
    static int s_stickVPointY;
    static int s_stickHPointX;
    static int s_stickHPointY;
    static int m_edgeTurnX;
    static int m_edgeHangX;
    int m_slopeID;
    static final int ABUT_LEFT = 1;
    static final int ABUT_RIGHT = 2;
    int m_puppetPosX;
    int m_puppetPosY;
    int m_manupulatedActorId;
    int m_decorationLinkActorID;
    CActor m_GeneratedActor;
    int m_generatedActorCount;
    int m_generatorPosX;
    int m_generatorPosY;
    byte m_iBackTileLayerPhysical = 0;
    int m_weaponType;
    int m_trailerFrameCount;
    static CActor s_actorToTriggerTrailer;
    int m_currBallStep;
    static CActor s_steelBall;
    public static final int k_woodPlatformStateStill = 0;
    public static final int k_woodPlatformStateMove = 1;
    public static final int k_chainBallTypeElevator = 0;
    public static final int k_chainBallTypeSwing = 1;
    public static final int k_chainBallElevatorStateWait = 0;
    public static final int k_chainBallElevatorStateMove = 1;
    public static final int k_chainBallSwingStateWait = 2;
    public static final int k_chainBallSwingStateMove = 3;
    public static final int k_MovingUp = 0;
    public static final int k_MovingDown = 1;
    public static final int k_Wait = 2;

    static void loadActors() throws Exception {
        s_originalActorCount = CGame.ReadShort();
        s_actorCount = s_originalActorCount + 15;
        CGame.ReadShort();
        s_actorsBaseInfo = new short[s_actorCount][];
        s_actors = new CActor[s_actorCount];
        s_activeActors = new CActor[50];
        s_EnemyActor = new CActor[10];
        s_actorDrawListBg = new CActor[10];
        s_actorDrawListNormal = new CActor[40];
        int n = 0;
        while (n < s_originalActorCount) {
            CActor cActor;
            short s = CGame.ReadShort();
            switch (s) {
                case 0: {
                    m_hero = new CHero();
                    cActor = m_hero;
                    cActor.m_attackBox = new short[4];
                    break;
                }
                case 2: 
                case 3: 
                case 19: 
                case 29: 
                case 34: 
                case 35: 
                case 44: 
                case 51: 
                case 56: {
                    cActor = new CEnemy();
                    cActor.m_attackBox = new short[4];
                    break;
                }
                case 7: 
                case 23: 
                case 43: 
                case 45: 
                case 46: 
                case 49: 
                case 55: 
                case 59: {
                    cActor = new CActor();
                    cActor.m_attackBox = new short[4];
                    break;
                }
                default: {
                    cActor = new CActor();
                }
            }
            CActor.s_actors[n] = cActor;
            cActor.m_actorID = n++;
            cActor.m_classID = s;
            cActor.load();
            cActor.m_z = s_classesDefaultZ[cActor.m_classID];
        }
        m_heroActorID = CGame.ReadShort();
    }

    static void destroyActors() {
        int n;
        s_classesDefaultActiveBoxes = null;
        for (n = 0; n < s_actorCount; ++n) {
            if (s_actors == null) continue;
            CActor.s_actors[n] = null;
        }
        s_actors = null;
        if (s_activeActors != null) {
            for (n = 0; n < s_activeActors.length; ++n) {
                CActor.s_activeActors[n] = null;
            }
        }
        if (s_EnemyActor != null) {
            for (n = 0; n < s_EnemyActor.length; ++n) {
                CActor.s_EnemyActor[n] = null;
            }
        }
        s_activeActors = null;
        s_EnemyActor = null;
        if (s_actorDrawListBg != null) {
            for (n = 0; n < s_actorDrawListBg.length; ++n) {
                CActor.s_actorDrawListBg[n] = null;
            }
        }
        if (s_actorDrawListNormal != null) {
            for (n = 0; n < s_actorDrawListNormal.length; ++n) {
                CActor.s_actorDrawListNormal[n] = null;
            }
        }
        s_actorDrawListBg = null;
        s_actorDrawListNormal = null;
        CActor.m_hero.m_vehicleActor = null;
        m_hero = null;
        m_frisianLeader = null;
        s_actorCount = 0;
        s_originalActorCount = 0;
        CActor.clearActorsLists();
        CHero.s_actionActor = null;
        CHero.s_platformActor = null;
        CHero.s_blockActor = null;
        CHero.s_leftCombatActor = null;
        CHero.s_rightCombatActor = null;
        s_steelBall = null;
        CGame.gc();
    }

    public static void checkActiveActor(int n, int n2) {
        boolean bl;
        CActor.clearActorsLists();
        boolean bl2 = false;
        boolean bl3 = bl = CGame.s_curTrailerCamera != null;
        if (bl) {
            for (int i = s_actorCount - 1; i >= 0; --i) {
                CActor cActor = s_actors[i];
                boolean bl4 = bl2 = cActor.m_timelineIndex != -1;
                if (bl2) {
                    CActor.addActorsToLists(cActor);
                    continue;
                }
                if (cActor.m_actorStatus != 4 && (cActor.testFlag(68) || cActor.checkInCamera())) {
                    if (i >= s_originalActorCount && CGame.s_curTrailerCamera.m_actionID != 7 || !cActor.setActive()) continue;
                    CActor.addActorsToLists(cActor);
                    continue;
                }
                cActor.setDeactive(false);
            }
        } else {
            for (int i = s_actorCount - 1; i >= 0; --i) {
                CActor cActor = s_actors[i];
                if (cActor.m_actorStatus != 4 && (cActor.testFlag(68) || cActor.checkInCamera())) {
                    if (!cActor.setActive()) continue;
                    CActor.addActorsToLists(cActor);
                    continue;
                }
                cActor.setDeactive(false);
            }
        }
    }

    public static void readActorClassInfo() throws Exception {
        s_actorClassCount = CGame.ReadByte();
        s_classesAnimID = new byte[s_actorClassCount];
        s_classesDefaultZ = new byte[s_actorClassCount];
        s_classesFlags = new byte[s_actorClassCount];
        CGame.ReadBytes(s_classesAnimID);
        CGame.ReadBytes(s_classesDefaultZ);
        CGame.ReadBytes(s_classesFlags);
    }

    public static boolean getActorClassFlag(int n, int n2) {
        return (s_classesFlags[n] & (n2 & 0xFFFFFFFF)) != 0;
    }

    public static void updateActors(boolean bl, boolean bl2) {
        for (int i = 0; i < s_activeActorsCount; ++i) {
            CActor cActor = s_activeActors[i];
            if (cActor == m_hero) continue;
            cActor.updateAIOrTrailer(bl, bl2);
        }
        m_hero.updateAIOrTrailer(bl, bl2);
    }

    public void updateAIOrTrailer(boolean bl, boolean bl2) {
        if (bl) {
            if (this.m_timelineIndex != -1) {
                this.updateTrailer();
            } else if (bl2) {
                this.update();
            } else {
                this.UpdateSpriteAnim(true);
            }
        } else {
            this.update();
        }
    }

    public static void splitActorList() {
        s_actorInBgListNum = 0;
        s_actorInNormalListNum = 0;
        for (int i = 0; i < s_activeActorsCount; ++i) {
            CActor cActor = s_activeActors[i];
            if (!cActor.testFlag(8) || cActor.m_sprite == null) continue;
            if (cActor.m_z >= 100) {
                if (s_actorInBgListNum >= 10) continue;
                CActor.s_actorDrawListBg[CActor.s_actorInBgListNum++] = cActor;
                continue;
            }
            if (s_actorInNormalListNum >= 40) continue;
            CActor.s_actorDrawListNormal[CActor.s_actorInNormalListNum++] = cActor;
        }
    }

    public static void drawBgActors(Graphics graphics, int n, int n2) {
        if (s_actorInBgListNum <= 0) {
            return;
        }
        for (int i = 0; i < s_actorInBgListNum; ++i) {
            if (CActor.s_actorDrawListBg[i].m_classID == 42 && CActor.s_actorDrawListBg[i].m_actionID == 3) {
                s_actorDrawListBg[i].draw(graphics, 0, CGame.m_cameraTopFar);
                continue;
            }
            int n3 = CGame.m_cameraLeftFar - CGame.m_cameraLeftFarOld;
            int n4 = CGame.m_cameraLeft - CGame.m_cameraLeftOld;
            CActor.s_actorDrawListBg[i].m_mapX += n4 - n3;
            CActor.s_actorDrawListBg[i].m_mapY += CGame.m_cameraTop - CGame.m_cameraTopOld;
            s_actorDrawListBg[i].draw(graphics, n, n2);
        }
    }

    public static void drawNormalActors(Graphics graphics, int n, int n2) {
        if (s_actorInNormalListNum <= 0) {
            return;
        }
        CActor.sortActors(s_actorDrawListNormal, 0, s_actorInNormalListNum - 1);
        for (int i = 0; i < s_actorInNormalListNum; ++i) {
            s_actorDrawListNormal[i].draw(graphics, n, n2);
        }
    }

    private static void sortActors(CActor[] cActorArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        int n5 = cActorArray[n + n2 >> 1].m_z;
        while (true) {
            if (cActorArray[n3].m_z > n5 && n3 < n2) {
                ++n3;
                continue;
            }
            while (cActorArray[n4].m_z < n5 && n4 > n) {
                --n4;
            }
            if (n3 <= n4) {
                if (cActorArray[n3].m_z != cActorArray[n4].m_z) {
                    CActor cActor = cActorArray[n3];
                    cActorArray[n3] = cActorArray[n4];
                    cActorArray[n4] = cActor;
                }
                ++n3;
                --n4;
            }
            if (n3 > n4) break;
        }
        if (n < n4) {
            CActor.sortActors(cActorArray, n, n4);
        }
        if (n2 > n3) {
            CActor.sortActors(cActorArray, n3, n2);
        }
    }

    public static void initActors() {
        CActor cActor;
        int n;
        for (n = 0; n < s_originalActorCount; ++n) {
            cActor = s_actors[n];
            cActor.loadBuffer();
        }
        s_actorsBaseInfo = null;
        CGame.gc();
        for (n = s_originalActorCount; n < s_actorCount; ++n) {
            CActor.s_actors[n] = new CActor();
            CActor.s_actors[n].m_actorID = n;
            s_actors[n].loadWeapon(18);
            s_actors[n].init(false);
            CActor.s_actors[n].m_attackBox = new short[4];
        }
        for (n = 0; n < s_originalActorCount; ++n) {
            cActor = s_actors[n];
            cActor.init(false);
        }
    }

    public static int getEnemyCount(int n) {
        int n2 = 0;
        for (int i = 0; i < s_EnemyActorCount; ++i) {
            if (CActor.s_EnemyActor[i].m_classID != n) continue;
            ++n2;
        }
        return n2;
    }

    public static void addActorsToLists(CActor cActor) {
        CDebug._assert(cActor != null);
        CActor cActor2 = cActor;
        CActor.s_activeActors[CActor.s_activeActorsCount++] = cActor2;
        boolean bl = cActor2.isEnemy();
        if (bl) {
            CActor.s_EnemyActor[CActor.s_EnemyActorCount++] = cActor2;
        }
    }

    static void clearActorsLists() {
        s_activeActorsCount = 0;
        s_EnemyActorCount = 0;
    }

    static void clearEnemies() {
        CActor cActor = null;
        for (int i = 0; i < s_EnemyActorCount; ++i) {
            cActor = s_EnemyActor[i];
            cActor.m_actorStatus = 4;
        }
        s_EnemyActorCount = 0;
    }

    public static void initActorsInListInTrailerMode(short[] sArray, byte n) {
        for (int i = 0; i < n; ++i) {
            short s = sArray[i];
            CDebug._assert(s < s_actorCount && s >= 0);
            CActor cActor = s_actors[s];
            cActor.initTrailer(i);
        }
        s_curTrailerTextID = -1;
    }

    public static void restoreActorsInListInTrailerMode(short[] sArray, byte n) {
        for (int i = 0; i < n; ++i) {
            short s = sArray[i];
            CDebug._assert(s < s_actorCount && s >= 0);
            CActor cActor = s_actors[s];
            cActor.restoreActorInTrailer();
        }
    }

    public static boolean isInList(short[] sArray, int n, int n2) {
        boolean bl = false;
        CDebug._assert(sArray != null);
        CDebug._assert(n > 0);
        CDebug._assert(n2 >= 0 && n2 < s_actorCount);
        for (int i = 0; i < n; ++i) {
            if (sArray[i] != n2) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static void invalidateAllWeaponInList() {
        for (int i = s_originalActorCount; i < s_actorCount; ++i) {
            s_actors[i].invalidateActor();
        }
    }

    boolean isFaceTo(CActor cActor) {
        return this.m_mapX - cActor.m_mapX < 0 ^ this.testFlag(1);
    }

    void setFaceTo(CActor cActor) {
        this.setFlag(1, this.m_mapX > cActor.m_mapX);
    }

    CActor findNearestActor(int n, int n2) {
        if (s_activeActorsCount <= 0) {
            return null;
        }
        CActor cActor = null;
        CActor cActor2 = null;
        for (int i = 0; i < s_activeActorsCount; ++i) {
            int n3;
            cActor = s_activeActors[i];
            if (cActor.m_classID != n || cActor == this || (n3 = CGame.getDistance(this.m_realX - cActor.m_realX, this.m_realY - cActor.m_realY)) > n2) continue;
            n2 = n3;
            cActor2 = cActor;
        }
        return cActor2;
    }

    void load() throws Exception {
        int n;
        int n2 = CGame.ReadByte();
        byte by = CGame.ReadByte();
        CActor.s_actorsBaseInfo[this.m_actorID] = new short[n2];
        for (n = 0; n < n2; ++n) {
            CActor.s_actorsBaseInfo[this.m_actorID][n] = CGame.ReadShort();
        }
        this.m_Parameters = new short[by];
        for (n = 0; n < by; ++n) {
            this.m_Parameters[n] = CGame.ReadShort();
        }
        if (this.m_classID == 34) {
            this.m_Parameters[3] = s_actorsBaseInfo[this.m_actorID][2];
            this.m_Parameters[4] = s_actorsBaseInfo[this.m_actorID][3];
        }
        if (this.m_classID == 59) {
            this.m_Parameters[3] = s_actorsBaseInfo[this.m_actorID][2];
            this.m_Parameters[4] = s_actorsBaseInfo[this.m_actorID][3];
            this.m_Parameters[5] = s_actorsBaseInfo[this.m_actorID][1];
        }
        if (this.m_classID == 46) {
            this.m_Parameters[2] = s_actorsBaseInfo[this.m_actorID][2];
            this.m_Parameters[3] = s_actorsBaseInfo[this.m_actorID][3];
            this.m_Parameters[4] = s_actorsBaseInfo[this.m_actorID][1];
        }
    }

    void loadWeapon(int n) {
        this.m_flags = 0;
        this.setFlag(8, true);
        this.m_classID = n;
        this.m_sprite = CGame.m_sprites[s_classesAnimID[this.m_classID]];
        this.m_Palette = 0;
        this.m_z = s_classesDefaultZ[this.m_classID];
        this.m_waitTime = 0;
        this.m_hp = 1;
        if (this.m_oriActiveBox == null) {
            this.m_oriActiveBox = s_classesDefaultActiveBoxes[this.m_classID];
        }
        this.getActiveBox();
    }

    public boolean checkInCamera() {
        this.getActiveBox();
        if (this.testFlag(2)) {
            return false;
        }
        return CActor.isCollide(CGame.m_cameraBox, this.m_activeZoneBox);
    }

    public boolean setActive() {
        boolean bl = true;
        if (this.m_actorStatus == 4) {
            return false;
        }
        if (this.m_actorStatus == 2) {
            return true;
        }
        if (this.m_actorStatus == 1 || this.m_actorStatus == 3) {
            switch (this.m_classID) {
                case 1: 
                case 3: 
                case 8: 
                case 10: 
                case 12: 
                case 15: 
                case 22: 
                case 52: 
                case 57: {
                    this.setFlag(64, true);
                    break;
                }
                case 17: {
                    this.activeVillager();
                    this.setFlag(64, true);
                    break;
                }
                case 4: 
                case 6: {
                    bl = this.activeDecoration();
                    break;
                }
                case 9: {
                    bl = this.activeCameraControl();
                    break;
                }
                case 11: {
                    bl = this.activeSlope();
                    break;
                }
                case 13: {
                    bl = this.activeAutoMoveTrigger();
                    break;
                }
                case 14: {
                    bl = this.activeEventTrigger();
                    break;
                }
                case 18: {
                    bl = this.activeWeapon();
                    break;
                }
                case 29: {
                    CHero.s_blockActor = this;
                    this.setFlag(64, true);
                    if (this.m_Parameters[6] != 0) break;
                    CGame.initBossHpBar(this, this.m_Parameters[4]);
                    break;
                }
                case 34: {
                    CGame.PlaySound(3);
                    this.setFlag(64, true);
                    if (this.m_actionID != 7) break;
                    CGame.initBossHpBar(this, this.m_Parameters[2]);
                    break;
                }
                case 23: {
                    this.activeSteelBall();
                    break;
                }
                case 50: {
                    this.activeEventZone();
                    break;
                }
                case 51: {
                    if (this.m_Parameters[0] == 2) {
                        CGame.initBossHpBar(this, this.m_Parameters[4]);
                    }
                    this.setFlag(64, true);
                    break;
                }
                case 44: {
                    if (this.m_Parameters[1] != 3) break;
                    CGame.initBossHpBar(this, this.m_Parameters[0]);
                    break;
                }
                case 56: {
                    CGame.PlaySound(3);
                    if (this.m_Parameters[0] == 3) {
                        CGame.initBossHpBar(this, this.m_Parameters[2]);
                    }
                    this.setFlag(64, true);
                    break;
                }
                case 2: {
                    if (this.m_actionID != 7 && this.m_actionID != 14) break;
                    m_hero.ClearThrownActor(this);
                    this.m_actorStatus = 4;
                    this.setFlag(4096, true);
                    this.setFlag(64, false);
                    m_hero.addScore(this);
                    bl = false;
                }
            }
            if (bl) {
                this.m_actorStatus = 2;
            }
            return bl;
        }
        return false;
    }

    public void setDeactive(boolean bl) {
        switch (this.m_classID) {
            case 4: 
            case 6: {
                this.deactiveDecoration(bl);
                break;
            }
            case 7: 
            case 16: {
                this.deactiveObject(bl);
                break;
            }
            case 8: {
                this.deactiveVehicle(bl);
                break;
            }
            case 9: {
                this.deactiveCameraControl(bl);
                break;
            }
            case 10: {
                this.deactiveGenerator(bl);
                break;
            }
            case 11: {
                this.deactiveSlope(bl);
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                this.deactiveAutoMoveTrigger(bl);
                break;
            }
            case 14: {
                this.deactiveEventTrigger(bl);
                break;
            }
            case 15: {
                this.deactiveDelayTrigger(bl);
                break;
            }
            case 22: {
                this.deactiveBall(bl);
                break;
            }
            case 24: {
                this.deactiveIronDoor(bl);
                break;
            }
            case 17: {
                this.deactiveVillager(bl);
                break;
            }
            case 18: {
                this.deactiveWeapon(bl);
                break;
            }
            case 23: {
                if (CHero.s_platformActor == this) {
                    CHero.s_platformActor = null;
                }
                if (CHero.s_blockActor == this) {
                    CHero.s_blockActor = null;
                }
                if (s_steelBall != this) break;
                s_steelBall = null;
                break;
            }
            case 29: {
                if (CHero.s_blockActor != this) break;
                CHero.s_blockActor = null;
                break;
            }
            case 35: {
                if (!m_hero.testFlag(1024)) break;
                m_hero.setActionWithCollision(116, -1, 3);
                CActor.m_hero.m_aY = 1792;
                CActor.m_hero.m_waitTime = 5;
                m_hero.removeIndicator();
                m_hero.setFlag(1024, false);
                break;
            }
            case 44: {
                short s = this.m_Parameters[1];
                if (this.m_actorStatus != 4 && this.m_vY > 0 && !this.m_canStand && s == 2 && this.m_collisionBox[1] > CGame.m_cameraBox[3]) {
                    this.m_actorStatus = 4;
                    this.setFlag(4096, true);
                    this.setFlag(64, false);
                    m_hero.addScore(this);
                }
                if (CHero.s_actorToBeBeviolentlyKilled != this) break;
                CHero.s_actorToBeBeviolentlyKilled = null;
                break;
            }
            case 40: {
                this.deactiveSeaPlatform();
                break;
            }
            case 21: {
                if (this.m_actorStatus == 4 || this.m_actorID < s_originalActorCount) break;
                this.m_actorStatus = 4;
            }
        }
    }

    boolean removeIfOutofMap() {
        if (this.m_collisionBox[1] + (this.m_vY >> 8) >= CGame.m_mapHeightByPixel[2]) {
            this.m_actorStatus = 4;
            this.setFlag(4096, true);
            this.setFlag(64, false);
            return true;
        }
        return false;
    }

    void update() {
        switch (this.m_classID) {
            case 1: {
                this.updateTrailerCameraAI();
                break;
            }
            case 5: 
            case 27: 
            case 36: 
            case 39: 
            case 41: 
            case 42: 
            case 53: 
            case 54: {
                this.UpdateSpriteAnim(true);
                break;
            }
            case 4: 
            case 6: {
                this.updateDecorationAI();
                break;
            }
            case 7: 
            case 16: {
                this.updateObjectAI();
                break;
            }
            case 8: {
                this.updateVehicleAI();
                break;
            }
            case 9: {
                this.updateCameraControlAI();
                break;
            }
            case 61: {
                this.updateMagicGate();
                break;
            }
            case 10: {
                this.updateGeneratorAI();
                break;
            }
            case 12: {
                this.updateLinkerAI();
                break;
            }
            case 13: {
                this.updateAutoMoveTriggerAI();
                break;
            }
            case 14: {
                this.updateEventTriggerAI();
                break;
            }
            case 15: {
                this.updateDelayTriggerAI();
                break;
            }
            case 22: {
                this.updateBallAI();
                break;
            }
            case 24: {
                this.updateIronDoorAI();
                break;
            }
            case 17: {
                this.updateVillagerAI();
                break;
            }
            case 18: {
                this.updateWeaponAI();
                break;
            }
            case 20: {
                this.updateCrystalAI();
                break;
            }
            case 28: {
                this.updateCeilingAI();
                break;
            }
            case 25: {
                this.updateHOAI();
                break;
            }
            case 26: {
                this.updateWallAI();
                break;
            }
            case 33: {
                this.updateSlipeRopeAI();
                break;
            }
            case 31: {
                this.updateSoliderAI();
                break;
            }
            case 30: {
                this.updateGrendelWeapon();
                break;
            }
            case 40: {
                this.updateSeaPlatform();
                break;
            }
            case 21: {
                this.updateBloodAI();
                break;
            }
            case 37: {
                this.updateBirdAI();
                break;
            }
            case 38: {
                this.updateBatSmallAI();
                break;
            }
            case 43: {
                this.updateStabAI();
                break;
            }
            case 23: {
                this.updateSteelBall();
                break;
            }
            case 45: {
                this.updateFrisianWeaponAI();
                break;
            }
            case 46: {
                this.updateWoodPlatformAI();
                break;
            }
            case 47: {
                this.updateWaterFall();
                break;
            }
            case 48: {
                this.updateBonePile();
                break;
            }
            case 49: {
                this.updatePoison();
                break;
            }
            case 50: {
                this.updateEventZone();
                break;
            }
            case 52: {
                this.updateLightBall();
                break;
            }
            case 55: {
                this.updateBomb();
                break;
            }
            case 57: {
                this.updateDragonFireBall();
                break;
            }
            case 59: {
                this.updateChainBallAI();
                break;
            }
            case 58: {
                this.updateSwitchAI();
                break;
            }
            case 60: {
                this.updateMangonel();
                break;
            }
        }
    }

    void draw(Graphics graphics, int n, int n2) {
        if (!this.testFlag(8)) {
            return;
        }
        if (CGame.s_IsFlashWhiteBackScreen && (this.m_classID == 41 || this.m_classID == 27 || this.m_classID == 4)) {
            return;
        }
        int n3 = this.m_mapX - n;
        int n4 = 0 + this.m_mapY - n2;
        if (this.m_classID == 59) {
            short s = this.m_Parameters[0];
            if (s != -1) {
                CActor cActor = s_actors[s];
                this.drawChain(graphics, cActor.m_mapX, cActor.m_mapY, this.m_mapX, this.m_mapY - 34, 16, 17, 8);
            } else {
                int n5 = this.m_weaponType - this.m_Parameters[2] - 68 - 20;
                graphics.setClip(0, n5 - CGame.m_cameraTop, 240, 320 - n5 + CGame.m_cameraTop);
                this.drawChain(graphics, this.m_mapX, this.m_mapY - 34, this.m_mapX, n5 - 26, 16, 16, 26);
            }
        }
        this.PaintSprite(graphics, n3, n4);
        if (this.testFlag(512) && (CGame.s_curTrailerCamera == null || CGame.s_curTrailerCamera.m_actionID == 7)) {
            this.displayAccessory(graphics, n, n2 - 0);
        }
    }

    void init(boolean bl) {
        this.m_z = s_classesDefaultZ[this.m_classID];
        if (s_classesAnimID[this.m_classID] != -1) {
            this.m_sprite = CGame.m_sprites[s_classesAnimID[this.m_classID]];
            this.setAction(this.m_actionID);
        }
        if (!bl) {
            this.m_actorStatus = 1;
            this.m_vX = 0;
            this.m_vY = 0;
            this.m_aX = 0;
            this.m_aY = 0;
            this.m_hp = 0;
            this.m_Palette = 0;
            if (this.m_classID == 42) {
                this.m_Palette = (1 << CGame.m_currLevel & 0x404) != 0 ? 1 : 0;
            }
        }
        this.m_waitTime = -1;
        this.m_weaponID = -1;
        this.m_attackPoint = 1;
        this.setFlag(1024, false);
        this.setFlag(4096, false);
        this.setFlag(512, false);
        this.m_nextVillagerID = -1;
        this.m_state = 0;
        this.clearAttackedInfo();
        switch (this.m_classID) {
            case 21: {
                if (!CGame.s_bloodEffect && this.m_actionID <= 2) {
                    this.m_actionID += 3;
                }
                this.setFlag(16384, true);
                break;
            }
            case 1: {
                this.setFlag(16384, true);
                break;
            }
            case 3: {
                this.setFlag(16384, true);
                break;
            }
            case 4: 
            case 6: {
                this.initDecoration(bl);
                this.setFlag(16384, true);
                break;
            }
            case 7: 
            case 16: {
                this.initObject();
                this.setFlag(16384, true);
                break;
            }
            case 8: {
                this.initVehicle();
                break;
            }
            case 9: {
                this.initCameraControl();
                this.setFlag(16384, true);
                break;
            }
            case 10: {
                this.initGenerator();
                this.setFlag(16384, true);
                break;
            }
            case 11: {
                this.setFlag(16384, true);
                break;
            }
            case 12: {
                this.initLinker();
                this.setFlag(16384, true);
                break;
            }
            case 13: {
                this.initAutoMoveTrigger();
                this.setFlag(16384, true);
                break;
            }
            case 15: {
                this.initDelayTrigger();
                this.setFlag(16384, true);
                break;
            }
            case 22: {
                this.initBall();
                break;
            }
            case 24: {
                this.initIronDoor();
                break;
            }
            case 17: {
                this.initVillager();
                break;
            }
            case 18: {
                this.initWeapon();
                break;
            }
            case 20: {
                this.initCrystal();
                break;
            }
            case 28: {
                this.m_currStep = 0;
                this.m_attackPoint = 70;
                break;
            }
            case 25: {
                this.m_currStep = 0;
                break;
            }
            case 26: {
                this.initWall();
                this.setFlag(16384, true);
                break;
            }
            case 39: {
                if (this.m_actionID == 0) {
                    this.m_z = CActor.m_hero.m_z - 1;
                }
                this.setFlag(16384, true);
                break;
            }
            case 40: {
                this.initSeaPlatform();
                this.setFlag(16384, true);
                break;
            }
            case 43: {
                this.initStab();
                this.setFlag(16384, true);
                break;
            }
            case 23: {
                this.initSteelBall();
                break;
            }
            case 46: {
                this.initWoodPlatform(bl);
                this.setFlag(16384, true);
                break;
            }
            case 59: {
                this.initChainBall(bl);
                this.setFlag(16384, true);
                break;
            }
            case 58: {
                this.initSwitch();
                this.setFlag(16384, true);
            }
        }
    }

    void renascence(int n, int n2) {
        this.clearAttackedInfo();
        this.setFlag(1024, false);
    }

    void TriggerActor() {
        switch (this.m_classID) {
            case 1: {
                this.triggerTrailerCamera();
                break;
            }
            case 3: {
                this.renascence(this.m_mapX, this.m_mapY);
                break;
            }
            case 2: {
                this.renascence(this.m_mapX, this.m_mapY);
                break;
            }
            case 4: 
            case 6: {
                this.triggerActorDecoration();
                break;
            }
            case 7: 
            case 16: {
                this.triggerActorObject();
                break;
            }
            case 8: {
                this.triggerVehicle();
                break;
            }
            case 10: {
                this.init(false);
                break;
            }
            case 13: {
                this.triggerAutoMoveTrigger();
                break;
            }
            case 14: {
                this.triggerEventTrigger();
                break;
            }
            case 15: {
                this.triggerDelayTrigger();
                break;
            }
            case 22: {
                this.triggerBall();
                break;
            }
            case 24: {
                this.triggerIronDoor();
                break;
            }
            case 17: {
                this.triggerVillager();
                break;
            }
            case 18: {
                this.triggerActorWeapon();
                break;
            }
            case 19: {
                this.renascence(this.m_mapX, this.m_mapY);
                break;
            }
            case 20: {
                this.triggerCrystal();
                break;
            }
            case 49: {
                this.triggerPoison();
                break;
            }
            case 59: {
                this.triggerChainBall();
                break;
            }
            case 32: {
                if (this.m_actionID == 5) {
                    this.setFlag(2, false);
                    break;
                }
                this.setFlag(4096, true);
            }
        }
        this.setActive();
    }

    void ThrowWeapon() {
    }

    void setThrow(boolean bl) {
    }

    public int clone(int n, int n2, int n3, int n4, int n5) {
        int n6 = -1;
        for (int i = s_originalActorCount; i < s_actorCount; ++i) {
            if (CActor.s_actors[i].m_actorStatus != 4) continue;
            CActor.s_actors[i].m_actorStatus = 1;
            n6 = CActor.s_actors[i].m_actorID;
            break;
        }
        if (n6 != -1) {
            CActor cActor = s_actors[n6];
            cActor.setMapPosition(n2, n3);
            cActor.loadWeapon(n);
            cActor.setFlag(n4, true);
            cActor.setAction(n5);
            cActor.setActive();
        }
        CDebug._assert(n6 != -1);
        return n6;
    }

    public CActor clone(int n, int n2, int n3, int n4) {
        int n5 = this.clone(n, n2, n3, 0, n4);
        if (n5 == -1) {
            return null;
        }
        return s_actors[n5];
    }

    boolean canBeAttackedBy(CActor cActor) {
        boolean bl = cActor.testFlag(65536) && CActor.isCollide(this.m_collisionBox, cActor.m_attackBox);
        return bl;
    }

    boolean canBeViolentlyKillWithType(int n) {
        return false;
    }

    int getAttackHurtToActor(CActor cActor) {
        return 0;
    }

    void displayAccessory(Graphics graphics, int n, int n2) {
        switch (this.m_classID) {
            case 15: {
                this.drawDelayTriggerAccessory(graphics, n, n2);
                break;
            }
            case 22: {
                this.drawBallAccessory(graphics, n, n2);
                break;
            }
            case 24: {
                this.drawIronDoorAccessory(graphics, n, n2);
                break;
            }
            case 17: {
                this.displayVillagerAccessory(graphics, n, n2);
                break;
            }
            case 25: {
                this.drawStepBar(graphics, n, n2, -15, -75);
                break;
            }
            case 28: {
                this.drawStepBar(graphics, n, n2, -20, -100);
            }
        }
    }

    boolean isEnemy() {
        boolean bl = CActor.getActorClassFlag(this.m_classID, 1);
        return bl;
    }

    void saveBuffer() {
    }

    void loadBuffer() {
        int n = 0;
        this.m_flags = s_actorsBaseInfo[this.m_actorID][n++];
        this.m_actionID = s_actorsBaseInfo[this.m_actorID][n++];
        this.m_mapX = s_actorsBaseInfo[this.m_actorID][n++];
        this.m_mapY = s_actorsBaseInfo[this.m_actorID][n++];
        this.setMapPosition(this.m_mapX, this.m_mapY);
        if (this.testFlag(32)) {
            this.m_oriActiveBox = s_classesDefaultActiveBoxes[this.m_classID];
        } else {
            this.m_oriActiveBox = new short[4];
            this.m_oriActiveBox[0] = s_actorsBaseInfo[this.m_actorID][n++];
            this.m_oriActiveBox[1] = s_actorsBaseInfo[this.m_actorID][n++];
            this.m_oriActiveBox[2] = s_actorsBaseInfo[this.m_actorID][n++];
            this.m_oriActiveBox[3] = s_actorsBaseInfo[this.m_actorID][n++];
        }
    }

    void saveCheckPoint() {
        int n = 0;
        this.m_savedData[n++] = (short)this.m_actionID;
        this.m_savedData[n++] = (short)this.m_prevActionID;
        this.m_savedData[n++] = (short)this.m_Palette;
        this.m_savedData[n++] = (short)(this.m_flags >> 16 & 0xFFFF);
        this.m_savedData[n++] = (short)(this.m_flags & 0xFFFF);
        this.m_savedData[n++] = (short)this.m_mapX;
        this.m_savedData[n++] = (short)this.m_mapY;
        this.m_savedData[n++] = (short)this.m_hp;
        this.m_savedData[n++] = (short)this.m_actorStatus;
    }

    void loadSavePoint() {
        int n = 0;
        this.m_actionID = this.m_savedData[n++];
        this.m_prevActionID = this.m_savedData[n++];
        this.m_Palette = this.m_savedData[n++];
        this.m_flags = this.m_savedData[n++] << 16 & 0xFFFF0000 | this.m_savedData[n++] & 0xFFFF;
        this.m_mapX = this.m_savedData[n++];
        this.m_mapY = this.m_savedData[n++];
        this.setMapPosition(this.m_mapX, this.m_mapY);
        this.m_hp = this.m_savedData[n++];
        this.m_actorStatus = this.m_savedData[n++];
        if (this.m_actorStatus == 2) {
            this.m_actorStatus = 1;
        }
        if (this == m_hero && CGame.s_savePointInfo[0] != -1) {
            CActor cActor = s_actors[CGame.s_savePointInfo[0]];
            this.m_actionID = 0;
            this.setMapPosition(cActor.m_mapX, cActor.m_mapY);
        }
        this.init(true);
    }

    private static final boolean IS_KEYFRAME_HIDE(int n) {
        return (n & 2) != 0;
    }

    private static final boolean IS_KEYFRAME_FLIPX(int n) {
        return (n & 1) != 0;
    }

    private static final boolean IS_KEYFRAME_DEACTIVE(int n) {
        return (n & 4) != 0;
    }

    private static final boolean IS_KEYFRAME_KICKOFF(int n) {
        return (n & 8) != 0;
    }

    public static final int getTimelinePosX(byte[] byArray, int n) {
        CDebug._assert(byArray != null);
        byte by = byArray[n + 3];
        byte by2 = byArray[n + 3 + 1];
        int n2 = by << 8 | by2 & 0xFF;
        return n2 << 8;
    }

    public static final int getTimelinePosY(byte[] byArray, int n) {
        CDebug._assert(byArray != null);
        byte by = byArray[n + 5];
        byte by2 = byArray[n + 5 + 1];
        int n2 = by << 8 | by2 & 0xFF;
        return n2 << 8;
    }

    void updateTrailer() {
        this.UpdateSpriteAnim(true);
        if (this.m_timelineIndex != -1) {
            int n;
            int n2;
            short n3;
            int n4 = CGame.m_currentTrailerIndex;
            byte[] byArray = CGame.m_trailers[n4][this.m_timelineIndex];
            byte by = CGame.m_nTrailersTimeLinesKeyFrameCount[n4][this.m_timelineIndex];
            CDebug._assert(by > 0);
            int n5 = this.m_currentKeyFrameIndex * 8;
            int n6 = byArray[n5 + 7];
            int n7 = byArray[n5 + 0] & 0xFF;
            int n8 = byArray[(by - 1) * 8 + 0] & 0xFF;
            if (CGame.m_currentTrailerFrame == 0 && (byArray[0] & 0xFF) != 0) {
                n3 = byArray[0] & 0xFF;
                n2 = CActor.getTimelinePosX(byArray, 0);
                n = CActor.getTimelinePosY(byArray, 0);
                if (n3 > 0) {
                    this.m_vX = (n2 - this.m_realX) / (n3 - 0);
                    this.m_vY = (n - this.m_realY) / (n3 - 0);
                }
            }
            if (this.m_classID == 23 && CHero.s_platformActor == this) {
                CHero.s_platformActor = null;
            }
            if (CGame.m_currentTrailerFrame == n7) {
                n3 = 0;
                if (this.m_classID != 1) {
                    if (CActor.IS_KEYFRAME_HIDE(n6)) {
                        this.setFlag(8, false);
                    } else {
                        this.setFlag(8, true);
                    }
                    if (CActor.IS_KEYFRAME_DEACTIVE(n6)) {
                        this.m_timelineIndex = -1;
                        this.m_actorStatus = 4;
                        this.setFlag(64, false);
                        this.setDeactive(false);
                        return;
                    }
                    this.setFlag(2, false);
                    if (CActor.IS_KEYFRAME_KICKOFF(n6)) {
                        this.m_timelineIndex = -1;
                        return;
                    }
                    n3 = CActor.IS_KEYFRAME_FLIPX(n6) ? 1 : 0;
                }
                n2 = byArray[n5 + 1] & 0xFF;
                if (!CGame.s_bloodEffect && this.m_classID == 21 && n2 <= 2) {
                    n2 += 3;
                }
                this.setAction(n2, n2);
                this.m_realX = CActor.getTimelinePosX(byArray, n5);
                this.m_realY = CActor.getTimelinePosY(byArray, n5);
                n = n7 < n8 ? n5 + 8 : n5;
                int n9 = byArray[n + 0] & 0xFF;
                int n10 = CActor.getTimelinePosX(byArray, n);
                int n11 = CActor.getTimelinePosY(byArray, n);
                if (this.m_classID == 1) {
                    s_curTrailerTextID = byArray[n5 + 2];
                    this.initTrailerCameraKeyFrame();
                    CHero.m_cameraShakingTimer = CActor.IS_KEYFRAME_HIDE(n6) ? (n9 > n7 ? n9 - n7 : 0) : 0;
                    this.m_hp = n6;
                }
                if (n9 > n7) {
                    this.m_vX = (n10 - this.m_realX) / (n9 - n7);
                    this.m_vY = (n11 - this.m_realY) / (n9 - n7);
                } else {
                    this.m_vX = 0;
                    this.m_vY = 0;
                }
                this.setFlag(1, n3 != 0);
                this.setRealPosition(this.m_realX, this.m_realY);
                if (this.m_currentKeyFrameIndex < by - 1) {
                    ++this.m_currentKeyFrameIndex;
                }
            }
            if (CGame.m_currentTrailerFrame < n8) {
                if (this.m_classID == 1) {
                    this.setRealPosition(this.m_realX + this.m_vX, this.m_realY + this.m_vY);
                    this.updateTrailerCameraInTrailer();
                } else {
                    this.setRealPosition(this.m_realX + this.m_vX, this.m_realY + this.m_vY);
                }
            }
        }
    }

    void initTrailer(int n) {
        this.m_timelineIndex = n;
        this.m_currentKeyFrameIndex = 0;
        this.m_actorStatus = 1;
    }

    void restoreActorInTrailer() {
        this.m_timelineIndex = -1;
        this.m_currentKeyFrameIndex = -1;
        if (this.m_classID == 1) {
            this.setFlag(4096, true);
        }
    }

    boolean testFlag(int n) {
        return (this.m_flags & n) != 0;
    }

    void setFlag(int n, boolean bl) {
        this.m_flags = bl ? (this.m_flags |= n) : (this.m_flags &= ~n);
    }

    int getAttackPoint() {
        return this.m_attackPoint;
    }

    void setAction(int n) {
        this.m_prevActionID = this.m_actionID;
        this.m_actionID = n;
        this.setFlag(16, false);
        if (!this.testFlag(128)) {
            this.m_aY = 0;
            this.m_aX = 0;
            this.m_vY = 0;
            this.m_vX = 0;
        } else {
            this.setFlag(128, false);
        }
        this.m_currAFrame = 0;
        this.m_currTime = 0;
    }

    void setAction(int n, int n2) {
        this.m_prevActionID = this.m_actionID;
        this.m_actionID = n;
        this.setFlag(16, false);
        if (!this.testFlag(128)) {
            this.m_aY = 0;
            this.m_aX = 0;
            this.m_vY = 0;
            this.m_vX = 0;
        } else {
            this.setFlag(128, false);
        }
        this.m_currAFrame = 0;
        this.m_currTime = 0;
    }

    void setActionWithCollision(int n, int n2, int n3) {
        boolean bl = this.m_sprite.GetAFrameBox(s_colBoxTmp, this.m_actionID, this.testFlag(16) && this.m_currAFrame == 0 ? this.m_sprite.GetAFrames(this.m_actionID) - 1 : this.m_currAFrame, this.testFlag(1), 0);
        if (bl) {
            if (n2 != -1) {
                this.m_mapX += s_colBoxTmp[n2];
            }
            if (n3 != -1) {
                this.m_mapY += s_colBoxTmp[n3];
            }
            this.setAction(n);
            bl = this.m_sprite.GetAFrameBox(s_colBoxTmp, this.m_actionID, this.testFlag(16) && this.m_currAFrame == 0 ? this.m_sprite.GetAFrames(this.m_actionID) - 1 : this.m_currAFrame, this.testFlag(1), 0);
            if (n2 != -1) {
                this.m_mapX -= s_colBoxTmp[n2];
            }
            if (n3 != -1) {
                this.m_mapY -= s_colBoxTmp[n3];
            }
            this.setMapPosition(this.m_mapX, this.m_mapY);
        } else {
            this.setAction(n);
        }
    }

    public boolean IsAlive() {
        return this.m_hp > 0;
    }

    void drawStatusBar(Graphics graphics, int n, int n2, int n3, int n4) {
        CDebug._assert(graphics != null);
        CDebug._assert(n3 >= 0 && n3 <= 100);
        int n5 = n3 * 25 / 100;
        graphics.setColor(255);
        graphics.fillRect(n, n2, 29, 8);
        graphics.setColor(0);
        graphics.fillRect(n + 2, n2 + 2, 25, 4);
        graphics.setColor(n4);
        graphics.fillRect(n + 2, n2 + 2, n5, 4);
    }

    void drawHPBar(Graphics graphics, int n, int n2, int n3, int n4) {
        CDebug._assert(graphics != null);
        CDebug._assert(n3 >= 0 && n3 <= 100);
        int n5 = n3 * 18 / 100;
        graphics.setColor(173);
        graphics.fillRect(n, n2, 20, 3);
        graphics.setColor(0xACACAC);
        graphics.fillRect(n + 1, n2 + 1, 18, 1);
        graphics.setColor(n4);
        graphics.fillRect(n + 1, n2 + 1, n5, 1);
    }

    void setAttacked(int n, boolean bl) {
        this.setFlag(2048, bl);
        this.m_attackedCount += n;
    }

    int getAttackedHurt() {
        return this.m_attackedCount;
    }

    void clearAttackedInfo() {
        this.m_attackedCount = 0;
    }

    int computeVDisToFloor() {
        this.getCollisionBox();
        short s = this.m_collisionBox[3];
        int n = this.m_mapX / 24;
        int n2 = s / 24;
        int n3 = CGame.m_mapHeightByPixel[2] / 24;
        for (int i = n2; i < n3; ++i) {
            if (CGame.GetTilePhyEnv(n, i) != 0) continue;
            return i * 24 - s;
        }
        return -1;
    }

    void shiftToFloor() {
        int n;
        this.getCollisionBox();
        int n2 = n = this.m_collisionBox[3];
        n2 /= 24;
        n2 *= 24;
        n2 += 24;
        int n3 = --n2 - n;
        this.setRealPosition(this.m_realX, this.m_realY + (n3 << 8));
    }

    void drawStepBar(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = 100;
        int n6 = this.m_currStep * 100 / n5;
        int n7 = this.m_mapX - n;
        int n8 = this.m_mapY - n2;
        this.drawStatusBar(graphics, n7 += n3, n8 += n4, n6, 0xFF0000);
    }

    int getCurrAFrame() {
        return this.m_currAFrame;
    }

    public void PaintSprite(Graphics graphics, int n, int n2) {
        int n3;
        if (this.m_sprite == null) {
            return;
        }
        graphics.setClip(0, 0, 240, 320);
        this.m_sprite.SetCurrentPalette(this.m_Palette);
        int n4 = n3 = this.testFlag(1) ? 1 : 0;
        if (this.m_currTime >= 0) {
            this.m_sprite.PaintAFrame(graphics, this.m_actionID, this.m_currAFrame, n, n2, n3, 0, 0);
        } else if (this.m_actionID >= 0) {
            this.m_sprite.PaintModule(graphics, this.m_actionID, n, n2, n3);
        } else if (this.m_currAFrame >= 0) {
            this.m_sprite.PaintFrame(graphics, this.m_currAFrame, n, n2, n3, 0, 0);
        }
    }

    void UpdateSpriteAnim(boolean bl) {
        if (this.m_sprite == null) {
            return;
        }
        if (this.m_currTime < 0) {
            return;
        }
        int n = this.m_sprite.GetAFrameTime(this.m_actionID, this.m_currAFrame);
        if (n == 0) {
            bl = false;
        }
        ++this.m_currTime;
        if (n > this.m_currTime) {
            return;
        }
        this.m_currTime = 0;
        ++this.m_currAFrame;
        if (this.m_currAFrame >= this.m_sprite.GetAFrames(this.m_actionID)) {
            this.setFlag(16, true);
            this.m_currAFrame = bl ? 0 : --this.m_currAFrame;
        }
    }

    void setSpriteAnimFrame(int n, boolean bl) {
        if (this.m_sprite == null) {
            return;
        }
        this.m_currAFrame = n;
        int n2 = this.m_sprite.GetAFrames(this.m_actionID);
        if (this.m_currAFrame >= n2) {
            this.m_currAFrame = bl ? 0 : n2 - 1;
        }
    }

    void getCollisionBox() {
        boolean bl;
        if (this.m_sprite == null) {
            return;
        }
        int n = this.m_currAFrame;
        if (this.testFlag(16) && this.m_currAFrame == 0) {
            n = this.m_sprite.GetAFrames(this.m_actionID) - 1;
        }
        if (!(bl = this.m_sprite.GetAFrameBox(this.m_collisionBox, this.m_actionID, n, this.testFlag(1), 0))) {
            for (int i = 0; i < 4; ++i) {
                this.m_collisionBox[i] = 0;
            }
        }
        this.setFlag(32768, bl);
        this.m_collisionBox[0] = (short)(this.m_collisionBox[0] + this.m_mapX);
        this.m_collisionBox[2] = (short)(this.m_collisionBox[2] + this.m_mapX);
        this.m_collisionBox[3] = (short)(this.m_collisionBox[3] + this.m_mapY);
        this.m_collisionBox[1] = (short)(this.m_collisionBox[1] + this.m_mapY);
    }

    void getAttackBox() {
        if (this.m_sprite == null || this.m_attackBox == null) {
            return;
        }
        int n = this.m_currAFrame;
        if (this.testFlag(16) && this.m_currAFrame == 0) {
            n = this.m_sprite.GetAFrames(this.m_actionID) - 1;
        }
        boolean bl = this.m_sprite.GetAFrameBox(this.m_attackBox, this.m_actionID, n, this.testFlag(1), 1);
        this.setFlag(65536, bl);
        this.m_attackBox[0] = (short)(this.m_attackBox[0] + this.m_mapX);
        this.m_attackBox[2] = (short)(this.m_attackBox[2] + this.m_mapX);
        this.m_attackBox[3] = (short)(this.m_attackBox[3] + this.m_mapY);
        this.m_attackBox[1] = (short)(this.m_attackBox[1] + this.m_mapY);
    }

    void getActiveBox() {
        this.m_activeZoneBox[1] = (short)(this.m_mapY + this.m_oriActiveBox[1]);
        this.m_activeZoneBox[3] = (short)(this.m_mapY + this.m_oriActiveBox[3]);
        if (!this.testFlag(1)) {
            this.m_activeZoneBox[0] = (short)(this.m_mapX + this.m_oriActiveBox[0]);
            this.m_activeZoneBox[2] = (short)(this.m_mapX + this.m_oriActiveBox[2]);
        } else {
            this.m_activeZoneBox[0] = (short)(this.m_mapX - this.m_oriActiveBox[2]);
            this.m_activeZoneBox[2] = (short)(this.m_mapX - this.m_oriActiveBox[0]);
        }
    }

    short[] getColBox(short[] sArray) {
        int n;
        if (sArray == null) {
            sArray = s_colBoxTmp;
        }
        for (n = 0; n < 4; ++n) {
            sArray[n] = 0;
        }
        if (this.m_sprite == null) {
            return sArray;
        }
        n = this.m_currAFrame;
        if (this.testFlag(16) && this.m_currAFrame == 0) {
            n = this.m_sprite.GetAFrames(this.m_actionID) - 1;
        }
        this.m_sprite.GetAFrameBox(sArray, this.m_actionID, n, this.testFlag(1), 0);
        sArray[0] = (short)(sArray[0] + this.m_mapX);
        sArray[2] = (short)(sArray[2] + this.m_mapX);
        sArray[3] = (short)(sArray[3] + this.m_mapY);
        sArray[1] = (short)(sArray[1] + this.m_mapY);
        return sArray;
    }

    void checkPhysicalEnvironment(short[] sArray) {
        int n;
        int n2;
        int n3;
        int n4;
        s_bBlockFront = false;
        s_bBlockBack = false;
        s_bBlockBottom = false;
        s_bWillFall = true;
        short s = sArray[0];
        short s2 = sArray[2];
        short s3 = sArray[1];
        short s4 = sArray[3];
        if (this.m_vX > 0) {
            n4 = s2 + 1;
            n3 = s - 1;
        } else {
            n4 = s - 1;
            n3 = s2 + 1;
        }
        s_frontTile = n4 < 0 ? -1 : n4 / 24;
        s_backTile = n3 < 0 ? -1 : n3 / 24;
        s_topTile = s3 / 24;
        s_bottomTile = s4 / 24;
        for (n2 = s_topTile; n2 <= s_bottomTile; ++n2) {
            if (CGame.IsTileCanGoThrough(CGame.GetTilePhyEnv(s_frontTile, n2))) continue;
            s_bBlockFront = true;
            break;
        }
        for (n2 = s_topTile; n2 <= s_bottomTile; ++n2) {
            if (CGame.IsTileCanGoThrough(CGame.GetTilePhyEnv(s_backTile, n2))) continue;
            s_bBlockBack = true;
            break;
        }
        n2 = s < 0 ? 0 : s / 24;
        int n5 = s2 < 0 ? 0 : s2 / 24;
        int n6 = (n2 + n5) / 2;
        if (s_bottomTile >= CGame.m_mapHeightByTile[2] - 1 || !CGame.IsTileCanGoThrough(CGame.GetTilePhyEnv(n6, s_bottomTile)) || CGame.GetTilePhyEnv(n6, s_bottomTile) == 8) {
            s_bBlockBottom = true;
        }
        if (!CGame.IsTileCanGoThrough(CGame.GetTilePhyEnv(n6, n = (s4 + 2) / 24)) || CGame.GetTilePhyEnv(n6, n) == 8) {
            s_bWillFall = false;
        }
        this.m_isOnslope = CGame.isInSlopeArea(this, this.m_mapX, this.m_mapY);
        this.getPhyEnv();
        this.m_canStand = this.canStand();
    }

    void adjustBoxToTileVertical(short[] sArray, int n, int n2) {
        short s = sArray[1];
        short s2 = sArray[3];
        int n3 = s2 - s;
        int n4 = n2 < 0 ? (n + 1) * 24 + 1 : (n == -1 ? CGame.m_bufHeight - n3 - 2 : n * 24 - n3 - 2);
        int n5 = n4 - s;
        this.setMapPosition(this.m_mapX, this.m_mapY + n5);
    }

    void adjustBoxToTileHorizonal(short[] sArray, int n, int n2) {
        short s = sArray[0];
        short s2 = sArray[2];
        int n3 = s2 - s;
        int n4 = n2 < 0 ? (n + 1) * 24 + 1 : (n == -1 ? CGame.m_bufWidth - n3 - 1 : n * 24 - n3 - 1);
        int n5 = n4 - s;
        this.setMapPosition(this.m_mapX + n5, this.m_mapY);
    }

    void updatePos(boolean bl) {
        this.m_vX += this.m_aX;
        this.m_vY += this.m_aY;
        if (this.m_isOnslope) {
            this.m_vY = 3840;
        }
        int n = Math.abs(this.m_vX);
        int n2 = Math.abs(this.m_vY);
        if (n > 5888) {
            int n3 = this.m_vX = this.m_vX > 0 ? 5888 : -5888;
        }
        if (n2 > 5888) {
            this.m_vY = this.m_vY > 0 ? 5888 : this.m_vY;
        }
        this.setRealPosition(this.m_realX + this.m_vX, this.m_realY + this.m_vY);
        if (this.m_isOnslope) {
            this.m_mapY = CGame.getPosYOnSlope(this.m_slopeID, this.m_mapX, this.m_mapY, this.m_vY);
            this.setMapPosition(this.m_mapX, this.m_mapY);
        }
        if (bl) {
            this.getColBox(s_colBoxTmp);
            this.checkPhysicalEnvironment(s_colBoxTmp);
            if (s_bBlockFront) {
                this.adjustBoxToTileHorizonal(s_colBoxTmp, s_frontTile, this.m_vX > 0 ? 1 : -1);
                this.m_vX = 0;
                this.m_aX = 0;
            }
            if (this.m_vY != 0 && s_bBlockBottom) {
                this.adjustBoxToTileVertical(s_colBoxTmp, s_bottomTile, 1);
                this.m_vY = 0;
                this.m_aY = 0;
            }
        }
    }

    void getPhyEnv() {
        int n;
        int n2;
        this.m_mapX = this.m_realX >> 8;
        this.m_mapY = this.m_realY >> 8;
        short s = this.m_collisionBox[0];
        short s2 = this.m_collisionBox[2];
        short s3 = this.m_collisionBox[3];
        short s4 = this.m_collisionBox[1];
        int n3 = s4 + s3 >> 1;
        int n4 = this.m_mapX;
        if (this.isFrontAtRight() && !this.testFlag(1) || !this.isFrontAtRight() && this.testFlag(1)) {
            n2 = s2 + 1;
            n = s - 1;
        } else {
            n2 = s - 1;
            n = s2 + 1;
        }
        CActor.s_phyEnvInfo[1] = CGame.GetPhyInfo(n2, s4);
        CActor.s_phyEnvInfo[3] = CGame.GetPhyInfo(n2, s3);
        CActor.s_phyEnvInfo[2] = CGame.GetPhyInfo(n2, n3);
        CActor.s_phyEnvInfo[4] = CGame.GetPhyInfo(n, s4);
        CActor.s_phyEnvInfo[6] = CGame.GetPhyInfo(n, s3);
        CActor.s_phyEnvInfo[5] = CGame.GetPhyInfo(n, n3);
        CActor.s_phyEnvInfo[0] = CGame.GetPhyInfo(n4, s3 + 1);
        CActor.s_phyEnvInfo[7] = CGame.GetPhyInfo(n4, s4 - 1);
        CActor.s_phyEnvInfo[8] = CGame.GetPhyInfo(n4, n3);
    }

    public static boolean canBackRun() {
        byte by = s_phyEnvInfo[4];
        byte by2 = s_phyEnvInfo[5];
        byte by3 = s_phyEnvInfo[6];
        boolean bl = CGame.IsTileCanGoThrough(by) && CGame.IsTileCanGoThrough(by2) && CGame.IsTileCanGoThrough(by3);
        return bl;
    }

    boolean canStand() {
        boolean bl;
        byte by = s_phyEnvInfo[0];
        boolean bl2 = bl = this.m_classID == 18 ? CGame.IsTileSolid(by) : CGame.IsTileCanStand(by);
        if (this.m_isOnslope) {
            bl = CGame.canStandOnSlope(this);
        }
        return bl;
    }

    void canHangClimb() {
        m_canHang = false;
        m_canHangJump = false;
        m_canClimb = false;
        short s = this.m_collisionBox[1];
        short s2 = this.m_collisionBox[0];
        short s3 = this.m_collisionBox[2];
        int n = !this.testFlag(1) ? s3 + 1 : s2 - 1;
        byte by = s_phyEnvInfo[1];
        int n2 = this.testFlag(1) ? s2 + 1 : s3 - 1;
        int n3 = s + 72;
        byte by2 = CGame.GetPhyInfo(n2, n3);
        if (by == 9 && by2 == -1) {
            m_canHang = true;
            s_hangPositionY = this.m_mapY - s % 24 + 12;
            byte by3 = CGame.GetPhyInfo(n, s - 24);
            if (by3 != -1) {
                m_canHangJump = true;
                s_stickVPointY = s - s % 24 + 12;
            }
        }
        if (by == 9 && by2 == 0) {
            m_canClimb = true;
            s_hangPositionY = this.m_mapY - s % 24 + 12;
        }
        if (m_canHang) {
            return;
        }
        if (this.m_actionID == 13 && CGame.GetPhyInfo(n, s + 12) != 9 && by != 9) {
            this.setAction(8, 8);
            this.m_aY = 1792;
        }
        for (int i = 1; i < 3; ++i) {
            int n4 = this.testFlag(1) ? s2 - i * 24 : s3 + i * 24;
            byte by4 = CGame.GetPhyInfo(n4, s);
            byte by5 = CGame.GetPhyInfo(n4, s - 24);
            if (by4 != 9 || by2 != -1) continue;
            m_canHang = true;
            s_hangPositionY = this.m_mapY - s % 24 + 12;
            if (by5 == -1) break;
            m_canHangJump = true;
            s_stickVPointY = s - s % 24 + 12;
            break;
        }
    }

    void canStickH() {
        int n = this.m_collisionBox[1];
        int n2 = this.m_mapX;
        int n3 = n2 + (this.testFlag(1) ? -96 : 96);
        byte by = CGame.GetPhyInfo(n3, n - 1);
        boolean bl = m_canStickH = s_phyEnvInfo[7] == 10;
        if (m_canStickH) {
            s_stickHPointX = n2 - n2 % 24 + 12;
            s_stickHPointY = this.m_mapY - (n - 1) % 24 + 24 - 1;
            m_canStickHJump = false;
            if (by == 10) {
                m_canStickHJump = true;
            }
            return;
        }
        boolean bl2 = m_canStickH = CGame.GetPhyInfo(n2, (n -= 24) - 1) == 10;
        if (m_canStickH) {
            s_stickHPointX = n2 - n2 % 24 + 12;
            s_stickHPointY = this.m_mapY - (n - 1) % 24 - 1;
            m_canStickHJump = false;
            by = CGame.GetPhyInfo(n3, n);
            if (by == 10) {
                m_canStickHJump = true;
            }
        }
    }

    void canEdgeClimbWalk() {
        short s = this.m_collisionBox[1];
        short s2 = this.m_collisionBox[3];
        int n = this.m_mapX;
        m_canEdgeTurn = false;
        m_canEdgeJump = false;
        m_canEdgeClimb = CGame.GetPhyInfo(n, s) == 11;
        boolean bl = m_canEdgeWalk = CGame.GetPhyInfo(n, s2) == 11;
        if (!m_canEdgeClimb && !m_canEdgeWalk) {
            return;
        }
        int n2 = n + (this.testFlag(1) ? -24 : 24);
        byte by = CGame.GetPhyInfo(n2, s);
        byte by2 = CGame.GetPhyInfo(n2, s2);
        if (m_canEdgeClimb && by != -1 || m_canEdgeWalk && by2 != -1) {
            return;
        }
        n2 = n + (this.testFlag(1) ? -72 : 72);
        by = CGame.GetPhyInfo(n2, s);
        by2 = CGame.GetPhyInfo(n2, s2);
        if (m_canEdgeClimb && by == 11 || m_canEdgeWalk && by2 == 11) {
            int n3;
            m_canEdgeTurn = true;
            int n4 = n3 = m_canEdgeClimb ? 48 : 46;
            m_edgeTurnX = this.testFlag(1) ? n2 - n2 % 24 + 48 + n3 : n2 - n2 % 24 - 24 - n3;
        } else if (m_canEdgeClimb && by != 11 || m_canEdgeWalk && by2 != 11) {
            m_canEdgeJump = true;
        }
    }

    void canEdgeHangSpan() {
        int n;
        int n2;
        int n3;
        m_canEdgeHang = false;
        m_canEdgeSpan = false;
        short s = this.m_collisionBox[1];
        int n4 = this.m_collisionBox[0];
        int n5 = this.m_collisionBox[2];
        short s2 = this.m_collisionBox[3];
        int n6 = (n4 + n5) / 2;
        byte by = CGame.GetPhyInfo(n4, s);
        byte by2 = CGame.GetPhyInfo(n5, s);
        byte by3 = CGame.GetPhyInfo(n6, s);
        byte by4 = CGame.GetPhyInfo(n4, s2);
        byte by5 = CGame.GetPhyInfo(n5, s2);
        byte by6 = CGame.GetPhyInfo(n6, s2);
        if (by3 == -1) {
            n3 = n4;
            n2 = n5;
            if (by == -1) {
                by = CGame.GetPhyInfo(n3 -= 24, s);
            }
            if (by2 == -1) {
                by2 = CGame.GetPhyInfo(n2 += 24, s);
            }
            if ((n = n2 / 24 - n3 / 24) == 3 && by == 11 && by2 == 11) {
                m_canEdgeHang = true;
                int n7 = m_edgeHangX = CGame.GetPhyInfo(n6 - 24, s) == -1 ? n6 - n6 % 24 : n6 - n6 % 24 + 24;
            }
        }
        if (by6 == -1) {
            n3 = n4;
            n2 = n5;
            if (by4 == -1) {
                by4 = CGame.GetPhyInfo(n3 -= 24, s2);
            }
            if (by5 == -1) {
                by5 = CGame.GetPhyInfo(n2 += 24, s2);
            }
            if ((n = n2 / 24 - n3 / 24) == 3 && by4 == 11 && by5 == 11) {
                m_canEdgeSpan = true;
                m_edgeHangX = CGame.GetPhyInfo(n6 - 24, s2) == -1 ? n6 - n6 % 24 : n6 - n6 % 24 + 24;
            }
        }
    }

    void canEdgeRotateBack() {
        canEdgeRotateBack = false;
        short s = this.m_collisionBox[1];
        short s2 = this.m_collisionBox[3];
        int n = this.m_mapX + (this.testFlag(1) ? -49 : 49);
        if (CGame.GetPhyInfo(n, s) == 11 || CGame.GetPhyInfo(n, s2) == 11) {
            canEdgeRotateBack = true;
        }
    }

    void canBackClimb() {
        m_canBackClimb = s_phyEnvInfo[7] == 5;
        m_canBackClimbUp = s_phyEnvInfo[7] == 8;
        m_canBackClimbLeft = s_phyEnvInfo[2] == 5;
        m_canBackClimbRight = s_phyEnvInfo[2] == 5;
        m_canLeaveClimbHorizonal = s_phyEnvInfo[5] != 5 && s_phyEnvInfo[7] != 5;
        m_canBackClimbDownward = s_phyEnvInfo[8] == 5;
    }

    boolean CanSlide() {
        return s_phyEnvInfo[1] == 7;
    }

    void handleSpecialEnviroment() {
        byte by = s_phyEnvInfo[0];
        byte by2 = s_phyEnvInfo[7];
        m_isSink = CGame.isTileCanSink(by);
        m_isSlowMotion = CGame.isTileCanSloMotion(by);
        m_tileInjurePoint = CGame.tileHurtPoint(by);
        m_tileInjurePoint += CGame.tileHurtPoint(by2);
        m_isTileLethal = CGame.IsTileLethal(by) || CGame.IsTileLethal(by2);
    }

    void detectEnviroment() {
        byte by;
        byte by2;
        byte by3;
        this.getCollisionBox();
        this.getAttackBox();
        if (this.testFlag(16384)) {
            return;
        }
        if (this.testFlag(8192)) {
            this.setFlag(8192, false);
            return;
        }
        this.m_isOnslope = CGame.isInSlopeArea(this, this.m_mapX, this.m_mapY);
        this.getPhyEnv();
        boolean bl = this.testFlag(1);
        if (this.isFrontAtRight()) {
            if (bl && this.m_vX <= 0 || !bl && this.m_vX >= 0) {
                by3 = s_phyEnvInfo[1];
                by2 = s_phyEnvInfo[2];
                by = s_phyEnvInfo[3];
            } else {
                by3 = s_phyEnvInfo[4];
                by2 = s_phyEnvInfo[5];
                by = s_phyEnvInfo[6];
            }
        } else if (!bl && this.m_vX <= 0 || bl && this.m_vX >= 0) {
            by3 = s_phyEnvInfo[1];
            by2 = s_phyEnvInfo[2];
            by = s_phyEnvInfo[3];
        } else {
            by3 = s_phyEnvInfo[4];
            by2 = s_phyEnvInfo[5];
            by = s_phyEnvInfo[6];
        }
        this.m_canRun = this.m_classID == 20 ? CGame.IsTileCanGoThrough(by3) : CGame.IsTileCanGoThrough(by3) && CGame.IsTileCanGoThrough(by2) && CGame.IsTileCanGoThrough(by);
        byte by4 = s_phyEnvInfo[0];
        boolean bl2 = this.m_canStand = this.m_classID == 18 ? CGame.IsTileSolid(by4) : CGame.IsTileCanStand(by4);
        if (this.m_isOnslope && !this.m_canStand) {
            this.m_canStand = CGame.canStandOnSlope(this);
        }
        this.m_canJump = CGame.IsTileCanGoThrough(s_phyEnvInfo[7]);
        if (this == m_hero) {
            m_hero.canRun();
            s_canBackRun = CActor.canBackRun();
            this.canHangClimb();
            this.canBackClimb();
            m_canSlide = s_phyEnvInfo[1] == 7;
            byte by5 = CGame.GetPhyInfo(this.m_mapX, this.m_collisionBox[1] - 24);
            m_canStandUp = CGame.IsTileCanGoThrough(by5);
            this.handleSpecialEnviroment();
        }
    }

    void updatePosition() {
        int n;
        int n2;
        this.m_vX += this.m_aX;
        this.m_vY += this.m_aY;
        int n3 = Math.abs(this.m_vX);
        int n4 = Math.abs(this.m_vY);
        if (n3 > 5888) {
            int n5 = this.m_vX = this.m_vX > 0 ? 5888 : -5888;
        }
        if (n4 > 5888) {
            this.m_vY = this == m_hero && (this.m_actionID == 99 || this.m_actionID == 98 || this.m_actionID == 126) || this.m_classID == 44 || this.m_classID == 18 ? (this.m_vY > 0 ? 5888 : this.m_vY) : (this.m_vY > 0 ? 5888 : -5888);
        }
        this.setRealPosition(this.m_realX + this.m_vX, this.m_realY + this.m_vY);
        this.detectEnviroment();
        if (this.m_vX > 0) {
            if (!(this.m_canRun && (this == m_hero || CActor.canBackRun()) || m_frisianLeader == this && this.m_canStand)) {
                n2 = this.m_collisionBox[2] + 1;
                if (n2 > CGame.m_mapWidthByPixel[2]) {
                    this.m_mapX = CGame.m_mapWidthByPixel[2] - (this.m_collisionBox[2] - this.m_mapX);
                } else {
                    n = n2 % 24 - 1;
                    this.m_mapX -= n;
                }
            }
        } else if (!(this.m_vX >= 0 || this.m_canRun && (this == m_hero || CActor.canBackRun()) || m_frisianLeader == this && this.m_canStand)) {
            n2 = this.m_collisionBox[0] - 1;
            if (n2 < 0) {
                this.m_mapX = this.m_collisionBox[0] - this.m_mapX;
            } else {
                n = 23 - n2 % 24;
                this.m_mapX += n;
            }
        }
        if (this.m_vY > 0) {
            if (this.m_canStand && !m_isSink && !this.m_isOnslope) {
                n2 = this.m_collisionBox[3] + 1;
                if (n2 > CGame.m_mapHeightByPixel[2]) {
                    this.m_mapY = CGame.m_mapHeightByPixel[2] - (this.m_collisionBox[3] - this.m_mapY);
                } else {
                    n = n2 % 24;
                    this.m_mapY -= n;
                }
            }
        } else if (this.m_vY < 0) {
            if (!this.m_canJump) {
                n2 = this.m_collisionBox[1];
                if (n2 < 0) {
                    this.m_mapY = this.m_collisionBox[1] - this.m_mapY;
                } else {
                    n = 24 - n2 % 24;
                    this.m_mapY += n;
                }
            } else if (this.m_canStand) {
                n2 = this.m_collisionBox[3] + 1;
                if (n2 > CGame.m_mapHeightByPixel[2]) {
                    this.m_mapY = CGame.m_mapHeightByPixel[2] - (this.m_collisionBox[3] - this.m_mapY);
                } else {
                    n = n2 % 24;
                    this.m_mapY -= n;
                }
            }
        }
        n2 = 0;
        if (this.m_vY == 0 && this.m_vX == 0) {
            n = this.checkYOffsetToTile(this.m_mapX, this.m_mapX, this.m_collisionBox[3], 2);
            if (n <= 20) {
                this.m_mapY -= n;
            } else {
                n2 = 1;
            }
        }
        if (this.m_vY != 0 || n2 != 0) {
            this.getCollisionBox();
            if (this.m_collisionBox[1] != this.m_mapY || this.m_collisionBox[3] != this.m_mapY || this.m_collisionBox[0] != this.m_mapX || this.m_collisionBox[2] != this.m_mapX) {
                n = this.checkXOffsetToTile(this.m_collisionBox[1], this.m_collisionBox[3], this.m_collisionBox[0], 1);
                int n6 = this.checkXOffsetToTile(this.m_collisionBox[1], this.m_collisionBox[3], this.m_collisionBox[2], 0);
                int n7 = 0;
                if (n == 0) {
                    n7 = n6;
                } else if (n6 == 0) {
                    n7 = n;
                } else {
                    int n8 = n7 = Math.abs(n) < Math.abs(n6) ? n : n6;
                }
                if (Math.abs(n7) <= 48) {
                    this.m_mapX += n7;
                }
            }
        }
        if (this.m_isOnslope) {
            this.m_mapY = CGame.getPosYOnSlope(this.m_slopeID, this.m_mapX, this.m_mapY, this.m_vY);
        }
        this.setMapPosition(this.m_mapX, this.m_mapY);
    }

    static final boolean isCollide(short[] sArray, short[] sArray2) {
        if (sArray[2] < sArray2[0]) {
            return false;
        }
        if (sArray[0] > sArray2[2]) {
            return false;
        }
        if (sArray[3] < sArray2[1]) {
            return false;
        }
        return sArray[1] <= sArray2[3];
    }

    static boolean isContaining(short[] sArray, int n, int n2) {
        return sArray[0] <= n && sArray[2] >= n && sArray[1] <= n2 && sArray[3] >= n2;
    }

    static int isBoxAbutOnHorizontal(short[] sArray, short[] sArray2) {
        if (sArray[3] < sArray2[1]) {
            return -1;
        }
        if (sArray[1] > sArray2[3]) {
            return -1;
        }
        if (sArray[2] == sArray2[0] - 1) {
            return 1;
        }
        if (sArray2[2] == sArray[0] - 1) {
            return 2;
        }
        return -1;
    }

    void adjustXPosToTile(boolean bl, int n, int n2) {
        this.getCollisionBox();
        int n3 = 0;
        switch (n2) {
            case 0: {
                n3 = !bl ? this.m_collisionBox[0] : this.m_collisionBox[2];
                break;
            }
            case 1: {
                n3 = this.m_realX >> 8;
                break;
            }
            default: {
                CDebug._assert(false);
            }
        }
        int n4 = this.checkXOffsetBesideToTile(this.m_collisionBox[1], this.m_collisionBox[3], n3, bl, n, n2);
        this.m_realX += n4 << 8;
        this.setRealPosition(this.m_realX, this.m_realY);
        this.detectEnviroment();
    }

    void RightToTheTile() {
        short s = this.m_collisionBox[2];
        if (s > CGame.m_mapWidthByPixel[2]) {
            this.m_mapX = CGame.m_mapWidthByPixel[2] - (this.m_collisionBox[2] - this.m_mapX);
        } else {
            int n = s % 24;
            this.m_mapX -= n;
        }
        this.setMapPosition(this.m_mapX, this.m_mapY);
    }

    void LeftToTheTile() {
        short s = this.m_collisionBox[0];
        if (s < 0) {
            this.m_mapX = this.m_collisionBox[0] - this.m_mapX;
        } else {
            int n = 24 - s % 24;
            this.m_mapX += n;
        }
        this.setMapPosition(this.m_mapX, this.m_mapY);
    }

    void setMapPosition(int n, int n2) {
        this.m_mapX = n;
        this.m_mapY = n2;
        this.m_realX = this.m_mapX << 8;
        this.m_realY = this.m_mapY << 8;
    }

    void setRealPosition(int n, int n2) {
        this.m_realX = n;
        this.m_realY = n2;
        this.m_mapX = this.m_realX >> 8;
        this.m_mapY = this.m_realY >> 8;
    }

    int checkXOffsetBesideToTile(int n, int n2, int n3, boolean bl, int n4, int n5) {
        CDebug._assert(n <= n2);
        int n6 = n;
        int n7 = n3;
        boolean bl2 = false;
        int n8 = 0;
        int n9 = 0;
        boolean bl3 = false;
        while (!bl2) {
            while (n6 <= n2) {
                byte by = CGame.GetPhyInfo(n7, n6);
                switch (n4) {
                    case 65: {
                        bl3 = by == 9;
                        break;
                    }
                    case 66: {
                        bl3 = by == 5;
                        break;
                    }
                    default: {
                        CDebug._assert(false);
                    }
                }
                if (bl3) break;
                n6 += 24;
            }
            if (bl3 || n9 >= 10) {
                bl2 = true;
            } else {
                switch (n5) {
                    case 0: {
                        if (bl) {
                            n8 = 24 - n7 % 24;
                            break;
                        }
                        n8 = -(n7 % 24 + 1);
                        break;
                    }
                    case 1: {
                        if (bl) {
                            n8 = 12 - n7 % 24 + 24;
                            break;
                        }
                        n8 = 12 - n7 % 24 - 24;
                        break;
                    }
                    default: {
                        CDebug._assert(false);
                    }
                }
                n7 += n8;
                n6 = n;
            }
            ++n9;
        }
        if (bl3) {
            return n7 - n3;
        }
        return 0;
    }

    int checkXOffsetToTile(int n, int n2, int n3, int n4) {
        CDebug._assert(n4 == 0 || n4 == 1, null);
        CDebug._assert(n <= n2, null);
        int n5 = 0;
        boolean bl = n4 == 1;
        int n6 = n;
        int n7 = n3;
        boolean bl2 = false;
        int n8 = n5;
        int n9 = 0;
        while (!bl2) {
            while (n6 <= n2) {
                byte by = CGame.GetPhyInfo(n7, n6);
                if (!CGame.IsTileCanGoThrough(by)) {
                    if (!bl) {
                        n8 = n7 % 24 + 1;
                        break;
                    }
                    n8 = 24 - n7 % 24;
                    break;
                }
                n6 += 24;
            }
            if (n8 == 0 || n9 >= 5) {
                bl2 = true;
            } else {
                n7 += !bl ? -n8 : n8;
            }
            n5 += n8;
            n8 = 0;
            ++n9;
        }
        return n7 - n3;
    }

    void adjustYPosToTile() {
        if (!this.m_canJump) {
            return;
        }
        int n = (this.m_collisionBox[1] - 1) % 24;
        this.setMapPosition(this.m_mapX, this.m_mapY - n);
    }

    int checkYOffsetToTile(int n, int n2, int n3, int n4) {
        CDebug._assert(n4 == 3 || n4 == 2);
        CDebug._assert(n <= n2);
        int n5 = 0;
        boolean bl = n4 == 2;
        int n6 = n3;
        int n7 = n;
        boolean bl2 = false;
        int n8 = n5;
        boolean bl3 = false;
        int n9 = 0;
        while (!bl2) {
            while (n7 <= n2) {
                byte by = CGame.GetPhyInfo(n7, n6);
                bl3 = bl ? !CGame.IsTileCanStand(by) : CGame.IsTileCanGoThrough(by);
                if (!bl3) {
                    if (bl) {
                        n8 = n6 % 24 + 1;
                        break;
                    }
                    n8 = 24 - n6 % 24;
                    break;
                }
                n7 += 24;
            }
            if (n8 == 0 || n9 >= 5) {
                bl2 = true;
            } else {
                n6 += bl ? -n8 : n8;
            }
            n5 += n8;
            n8 = 0;
            ++n9;
        }
        return n5;
    }

    boolean isFrontAtRight() {
        return this.m_classID == 0 || this.m_classID == 8;
    }

    void updateAutoMoveTriggerAI() {
        boolean bl;
        this.checkValid();
        if (this.m_manupulatedActorId == -1) {
            this.setFlag(4096, true);
            this.m_actorStatus = 4;
            this.setFlag(64, false);
            return;
        }
        CActor cActor = s_actors[this.m_manupulatedActorId];
        int n = this.m_realX - this.m_puppetPosX;
        int n2 = this.m_realY - this.m_puppetPosY;
        cActor.setFlag(1024, true);
        cActor.m_actorStatus = 2;
        cActor.setFlag(1, this.testFlag(1));
        boolean bl2 = bl = n == 0 && n2 == 0;
        if (this.testFlag(1024) && CActor.isCollide(cActor.m_activeZoneBox, CActor.m_hero.m_collisionBox)) {
            bl = true;
        }
        if (!bl) {
            int n3;
            int n4 = n > 0 ? this.m_vX : -this.m_vX;
            int n5 = n3 = n2 > 0 ? this.m_vY : -this.m_vY;
            if (Math.abs(n) < Math.abs(n4)) {
                n4 = n;
            }
            if (Math.abs(n2) < Math.abs(n3)) {
                n3 = n2;
            }
            this.m_puppetPosX += n4;
            this.m_puppetPosY += n3;
            cActor.setRealPosition(this.m_puppetPosX, this.m_puppetPosY);
            cActor.update();
        } else {
            this.setFlag(4096, true);
            this.m_actorStatus = 4;
            this.setFlag(64, false);
            cActor.setFlag(1024, false);
        }
    }

    void initAutoMoveTrigger() {
        this.m_manupulatedActorId = this.m_Parameters[0];
        if (this.m_manupulatedActorId == -1) {
            return;
        }
        CActor cActor = s_actors[this.m_manupulatedActorId];
        short s = this.m_Parameters[4];
        if (s <= 0) {
            s = 1;
        }
        this.m_vX = (this.m_Parameters[2] << 8) / s;
        this.m_vY = (this.m_Parameters[3] << 8) / s;
        this.m_vX = Math.abs(this.m_vX);
        this.m_vY = Math.abs(this.m_vY);
        this.m_realX = cActor.m_mapX + this.m_Parameters[2] << 8;
        this.m_realY = cActor.m_mapY + this.m_Parameters[3] << 8;
        this.setFlag(1, this.m_Parameters[5] == 1);
        this.setFlag(1024, this.m_Parameters[6] == 1);
        this.m_puppetPosX = cActor.m_mapX << 8;
        this.m_puppetPosY = cActor.m_mapY << 8;
    }

    boolean activeAutoMoveTrigger() {
        if (this.m_actorStatus == 1) {
            this.checkValid();
            this.setFlag(64, true);
            if (this.m_manupulatedActorId == -1) {
                return true;
            }
            CActor cActor = s_actors[this.m_manupulatedActorId];
            short s = this.m_Parameters[1];
            cActor.setAction(s, s);
        }
        return true;
    }

    void deactiveAutoMoveTrigger(boolean bl) {
    }

    void triggerAutoMoveTrigger() {
        this.checkValid();
        this.setFlag(64, true);
        this.setFlag(2, false);
        if (this.m_manupulatedActorId == -1) {
            return;
        }
        CActor cActor = s_actors[this.m_manupulatedActorId];
        short s = this.m_Parameters[1];
        cActor.setAction(s, s);
        this.m_puppetPosX = cActor.m_mapX << 8;
        this.m_puppetPosY = cActor.m_mapY << 8;
        this.setFlag(4096, false);
        this.m_actorStatus = 2;
        cActor.setFlag(1024, true);
        this.initAutoMoveTrigger();
    }

    private void checkValid() {
        if (this.m_manupulatedActorId == -1) {
            return;
        }
        CActor cActor = s_actors[this.m_manupulatedActorId];
        if (this.m_actionID == 1 && cActor.m_actorStatus == 4) {
            this.m_manupulatedActorId = -1;
        }
    }

    void updateCameraControlAI() {
        boolean bl;
        if (this.testFlag(256)) {
            if (!m_hero.isTriggeredByHero(this.m_activeZoneBox, true)) {
                this.m_actorStatus = 3;
                this.setFlag(64, false);
                CGame.setCameraLimit(-1, -1, this.m_actionID);
            } else if (CActor.m_hero.m_actionID != 141 && CActor.m_hero.m_actionID != 142 && CActor.m_hero.m_actionID != 143 && CActor.m_hero.m_actionID != 144) {
                CGame.setCameraLimit(this.m_realX >> 8, this.m_realY >> 8, this.m_actionID);
                this.setFlag(4096, false);
            }
            return;
        }
        short s = this.m_Parameters[0];
        short s2 = this.m_Parameters[1];
        short s3 = this.m_Parameters[2];
        boolean bl2 = s == -1 ? true : s_actors[s].testFlag(4096);
        boolean bl3 = s2 == -1 ? true : s_actors[s2].testFlag(4096);
        boolean bl4 = bl = s3 == -1 ? true : s_actors[s3].testFlag(4096);
        if (bl2 && bl3 && bl) {
            this.setFlag(4096, true);
            this.m_actorStatus = 4;
            this.setFlag(64, false);
            CGame.setCameraLimit(-1, -1, this.m_actionID);
            if (this.m_state != -1) {
                if (this.m_Parameters[3] == 1) {
                    s_actors[this.m_state].setAction(1);
                }
                this.m_state = -1;
            }
        } else if (this.m_state == -1) {
            CGame.setCameraLimit(this.m_mapX, this.m_mapY, this.m_actionID);
            if (this.m_Parameters[3] == 1) {
                this.m_state = this.clone(61, this.m_mapX, this.m_mapY, this.m_actionID == 1 ? 1 : 0, 2);
                if (this.m_state >= 0) {
                    s_actors[this.m_state].setFlag(16384, true);
                }
            } else {
                this.m_state = 1;
            }
        }
    }

    void initCameraControl() {
        short s = this.m_Parameters[0];
        short s2 = this.m_Parameters[1];
        short s3 = this.m_Parameters[2];
        boolean bl = s == -1 && s2 == -1 && s3 == -1;
        this.setFlag(256, bl);
    }

    boolean activeCameraControl() {
        this.m_state = -1;
        return m_hero.isTriggeredByHero(this.m_activeZoneBox, true);
    }

    void deactiveCameraControl(boolean bl) {
        if (this.m_actorStatus == 2) {
            if (this.testFlag(256)) {
                this.setFlag(4096, true);
            }
            CGame.setCameraLimit(-1, -1, this.m_actionID);
            this.m_actorStatus = 3;
            if (this.m_state != -1) {
                if (this.m_Parameters[3] == 1) {
                    s_actors[this.m_state].setAction(1);
                }
                this.m_state = -1;
            }
        }
    }

    void updateMagicGate() {
        this.UpdateSpriteAnim(true);
        if (this.m_actionID == 2) {
            if (this.testFlag(16)) {
                this.setAction(0);
            }
        } else if (this.m_actionID == 1 && this.testFlag(16)) {
            this.invalidateActor();
        }
    }

    void updateDecorationAI() {
        if (this.m_actorStatus == 2) {
            this.UpdateSpriteAnim(this.m_Parameters[2] == 1);
            if (this.m_classID == 4 && this.m_decorationLinkActorID != -1) {
                this.m_mapX = CActor.s_actors[this.m_decorationLinkActorID].m_mapX;
                this.m_mapY = CActor.s_actors[this.m_decorationLinkActorID].m_mapY + -86;
            }
            if (this.m_classID == 4 && this.m_Parameters[4] == 1) {
                this.getActiveBox();
                if (!m_hero.isTriggeredByHero(this.m_activeZoneBox, true)) {
                    this.m_actorStatus = 3;
                }
            }
        }
    }

    void initDecoration(boolean bl) {
        if (!bl) {
            short s = this.m_Parameters[0];
            this.setAction(s, s);
        }
    }

    boolean activeDecoration() {
        if (this.m_classID == 4) {
            if (this.m_Parameters[4] == 1) {
                this.getActiveBox();
                if (!m_hero.isTriggeredByHero(this.m_activeZoneBox, true)) {
                    return false;
                }
            }
            this.m_decorationLinkActorID = this.m_Parameters[3];
            if (CGame.s_textID == -1) {
                CGame.s_textID = this.m_Parameters[5];
            }
        }
        return true;
    }

    void deactiveDecoration(boolean bl) {
        this.m_actorStatus = 3;
        this.m_decorationLinkActorID = -1;
    }

    void triggerActorDecoration() {
        short s = this.m_Parameters[0];
        if (this.m_actionID == this.m_Parameters[0]) {
            s = this.m_Parameters[1];
            if (this.m_classID == 4 && this.m_Parameters[1] == 14) {
                CGame.s_textID = -1;
            }
        }
        this.setAction(s, s);
    }

    void updateEventTriggerAI() {
        switch (this.m_actionID) {
            case 4: {
                if (CActor.m_hero.m_timelineIndex != -1 || !m_hero.isTriggeredByHero(this.m_activeZoneBox, false)) break;
                this.triggerEventTrigger();
                break;
            }
            case 5: 
            case 6: {
                if (!m_hero.isTriggeredByHero(this.m_activeZoneBox, false)) break;
                this.triggerEventTrigger();
                break;
            }
            case 1: {
                if (!m_hero.isTriggeredByHero(this.m_activeZoneBox, true)) break;
                this.triggerEventTrigger();
                break;
            }
            case 2: {
                if (CGame.m_frameCounter % 2 > 0) {
                    CHero.m_cameraShakingOffsetY = 9;
                    break;
                }
                CHero.m_cameraShakingOffsetY = -9;
                break;
            }
            case 3: {
                if (CGame.m_frameCounter % 2 > 0) {
                    CHero.m_cameraShakingOffsetX = 9;
                    break;
                }
                CHero.m_cameraShakingOffsetX = -9;
                break;
            }
            default: {
                CDebug._assert(false);
            }
        }
    }

    boolean activeEventTrigger() {
        boolean bl = true;
        switch (this.m_actionID) {
            case 4: {
                this.setFlag(64, true);
                break;
            }
            case 5: 
            case 6: {
                this.setFlag(64, true);
                break;
            }
            case 1: {
                this.setFlag(64, true);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                CDebug._assert(false);
                bl = false;
            }
        }
        return bl;
    }

    void deactiveEventTrigger(boolean bl) {
        switch (this.m_actionID) {
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                m_hero.clearShakingOffset();
                break;
            }
            case 3: {
                m_hero.clearShakingOffset();
                break;
            }
            default: {
                CDebug._assert(false);
            }
        }
    }

    void triggerEventTrigger() {
        if (CGame.m_nLevelState == 5 || m_hero != null && CActor.m_hero.m_hp <= 0 || m_hero != null && m_hero.isHeroWillDie()) {
            return;
        }
        switch (this.m_actionID) {
            case 4: {
                CGame.levelWin();
                CGame.m_nLevelState = 7;
                CGame.s_levelFailWinTime = 0;
                CGame.ResetLevelDestroy();
                this.setFlag(4096, true);
                this.m_actorStatus = 4;
                this.setFlag(64, false);
                break;
            }
            case 5: {
                CGame.m_nLevelState = 5;
                CGame.ResetLevelDestroy();
                this.setFlag(4096, true);
                this.m_actorStatus = 4;
                this.setFlag(64, false);
                break;
            }
            case 6: {
                this.letVillagerLeave();
                this.setFlag(4096, true);
                this.m_actorStatus = 4;
                this.setFlag(64, false);
                break;
            }
            case 1: {
                CGame.s_currentCheckPointDelayFrame = 10;
                this.setFlag(4096, true);
                this.m_actorStatus = 4;
                this.setFlag(64, false);
                CGame.updateSavePoint(this.m_actorID);
                break;
            }
            case 2: {
                this.setFlag(2, false);
                break;
            }
            case 3: {
                break;
            }
            default: {
                CDebug._assert(false);
            }
        }
    }

    void letVillagerLeave() {
        int n = CActor.m_hero.m_nextVillagerID;
        while (n != -1) {
            CActor.s_actors[n].m_hp = 0;
            m_hero.removeActorFromList(CActor.s_actors[n].m_actorID);
            CActor.s_actors[n].m_actorStatus = 4;
            s_actors[n].setFlag(64, false);
            n = CActor.s_actors[n].m_nextVillagerID;
        }
    }

    void updateGeneratorAI() {
        if (this.m_generatedActorCount > 0) {
            if (this.m_GeneratedActor.m_actorStatus == 4 || this.m_GeneratedActor.m_actorStatus == 3 || this.m_GeneratedActor.m_actorStatus == 1) {
                this.m_GeneratedActor.renascence(this.m_generatorPosX, this.m_generatorPosY);
                this.m_GeneratedActor.update();
                --this.m_generatedActorCount;
            }
        } else if (this.m_GeneratedActor.m_actorStatus == 4) {
            this.setFlag(4096, true);
            this.setFlag(64, false);
            this.m_actorStatus = 4;
        }
    }

    void initGenerator() {
        this.m_GeneratedActor = null;
        this.m_generatedActorCount = this.m_Parameters[0];
        short s = this.m_Parameters[1];
        this.m_GeneratedActor = s_actors[s];
        this.m_generatorPosX = this.m_GeneratedActor.m_mapX;
        this.m_generatorPosY = this.m_GeneratedActor.m_mapY;
    }

    void deactiveGenerator(boolean bl) {
    }

    void updateLinkerAI() {
        short s = this.m_Parameters[0];
        short s2 = this.m_Parameters[1];
        boolean bl = s == -1 ? true : s_actors[s].testFlag(4096);
        boolean bl2 = s2 == -1 ? true : s_actors[s2].testFlag(4096);
        boolean bl3 = true;
        if (this.m_actionID == 1 && !CGame.IsKeyPressed(this.testFlag(1) ? 262672 : 193)) {
            bl3 = false;
        }
        if (bl && bl2 && bl3) {
            this.getActiveBox();
            if (CActor.isCollide(CActor.m_hero.m_collisionBox, this.m_activeZoneBox)) {
                int[] nArray = new int[]{this.m_Parameters[2], this.m_Parameters[3], this.m_Parameters[4]};
                for (int i = 0; i < 3; ++i) {
                    if (nArray[i] == -1) continue;
                    CActor cActor = s_actors[nArray[i]];
                    cActor.TriggerActor();
                }
                this.setFlag(4096, true);
                this.m_actorStatus = 4;
                this.setFlag(64, false);
            }
        }
    }

    void initLinker() {
    }

    void deactiveLinker(boolean bl) {
    }

    void updateObjectAI() {
        short s;
        short n;
        if (this.m_actorStatus != 2) {
            return;
        }
        if (this.testFlag(1024)) {
            return;
        }
        boolean bl = this.m_Parameters[0] == 1;
        boolean bl2 = this.m_Parameters[5] == 1;
        boolean bl3 = false;
        boolean bl4 = CActor.getActorClassFlag(this.m_classID, 2);
        boolean bl5 = CActor.getActorClassFlag(this.m_classID, 4);
        boolean bl6 = false;
        if (this.m_classID == 7) {
            boolean bl7 = bl6 = this.m_Parameters[6] == 1;
        }
        if (bl && this.IsAlive()) {
            this.getCollisionBox();
            n = 0;
            if (this.m_actionID == 17 || this.m_actionID == 18 || this.m_actionID == 4 || this.m_actionID == 5) {
                m_hero.getActiveBox();
                if (CActor.isCollide(CActor.m_hero.m_activeZoneBox, this.m_collisionBox)) {
                    n = 10;
                }
            } else {
                n = m_hero.getAttackHurtToActor(this);
                if (n == 0) {
                    n = this.getAttackedHurt();
                }
                if (n == 0 && this.m_actionID == 25 && CActor.m_hero.m_vY > 0 && CActor.m_hero.m_actionID == 8 && !this.testFlag(8) && CActor.isCollide(CActor.m_hero.m_collisionBox, this.m_collisionBox)) {
                    n = 10;
                }
            }
            if (bl4 && n > 0) {
                bl3 = true;
                this.m_hp -= n;
            }
            if (bl5) {
                for (s = 0; s < s_EnemyActorCount; ++s) {
                    CActor cActor = s_EnemyActor[s];
                    if (!this.canBeAttackedBy(cActor)) continue;
                    bl3 = true;
                    this.m_hp -= cActor.getAttackPoint();
                }
            }
            if (bl3 && this.m_actionID != this.m_Parameters[2]) {
                short s2;
                if (this.IsAlive()) {
                    s2 = this.m_Parameters[1];
                } else {
                    s2 = this.m_Parameters[2];
                    if (s2 == 8 || s2 == 26) {
                        this.m_z = CActor.m_hero.m_z - 1;
                    }
                    this.setFlag(4096, true);
                    s = this.m_Parameters[4];
                    if (s != -1) {
                        CActor cActor = s_actors[s];
                        if (cActor.m_classID == 20 && cActor.m_actionID == 6) {
                            int n2 = Math.abs(this.m_mapX - cActor.m_mapX);
                            n2 %= 10;
                            for (int i = 0; i < n2; ++i) {
                                this.jumpOutCrystal(i, 0, 0);
                            }
                        } else {
                            cActor.m_mapX = this.m_mapX;
                            cActor.m_mapY = this.m_mapY;
                            cActor.TriggerActor();
                        }
                    }
                }
                if (s2 != this.m_actionID) {
                    this.setAction(s2, s2);
                }
            }
        }
        if (this.m_Parameters[2] == 19 && !CActor.isCollide(this.m_collisionBox, CActor.m_hero.m_collisionBox)) {
            this.m_hp = this.m_Parameters[3];
            if (this.m_actionID == 19) {
                this.setAction(20, 20);
            } else {
                this.setAction(17, 17);
            }
        }
        if (this.m_actionID == 13) {
            this.getAttackBox();
            if (this.testFlag(65536)) {
                if (bl4 && m_hero.canBeAttackedBy(this)) {
                    n = this.m_realX - CActor.m_hero.m_realX < 0 ? 1 : 0;
                    m_hero.setAttacked(this.getAttackPoint(), n != 0);
                }
                if (bl5) {
                    for (int i = 0; i < s_EnemyActorCount; ++i) {
                        CActor cActor = s_EnemyActor[i];
                        if (!CActor.isCollide(this.m_attackBox, cActor.m_collisionBox)) continue;
                        s = this.m_mapX - cActor.m_mapX < 0 ? (short)1 : 0;
                        cActor.setAttacked(this.getAttackPoint(), s != 0);
                    }
                }
            }
        }
        switch (this.m_actionID) {
            case 16: {
                this.getActiveBox();
                if (CActor.isCollide(CActor.m_hero.m_attackBox, this.m_activeZoneBox)) {
                    this.setFlag(8, true);
                    this.UpdateSpriteAnim(bl6);
                    break;
                }
                if (this.testFlag(16)) {
                    this.setFlag(8, false);
                    break;
                }
                this.UpdateSpriteAnim(false);
                break;
            }
            case 20: {
                if (this.testFlag(16)) {
                    this.setAction(17, 17);
                    break;
                }
                this.UpdateSpriteAnim(false);
                break;
            }
            case 19: {
                this.UpdateSpriteAnim(false);
                break;
            }
            default: {
                this.UpdateSpriteAnim(bl6);
            }
        }
        if (bl2 && this.m_prevActionID != this.m_actionID) {
            this.fillPhysicalLayer(true);
            this.getCollisionBox();
            if (this.m_actionID != this.m_Parameters[2] || 16 == this.m_classID) {
                this.fillPhysicalLayer(false);
            }
        }
        this.m_prevActionID = this.m_actionID;
    }

    void initObject() {
        boolean bl;
        this.m_hp = this.m_Parameters[3];
        boolean bl2 = bl = this.m_Parameters[5] == 1;
        if (bl && this.m_actionID != this.m_Parameters[2]) {
            this.fillPhysicalLayer(true);
            this.getCollisionBox();
            this.fillPhysicalLayer(false);
        }
    }

    void triggerActorObject() {
        this.m_hp = 0;
        short s = this.m_Parameters[2];
        this.setFlag(4096, true);
        this.setAction(s, s);
    }

    void deactiveObject(boolean bl) {
        this.m_actorStatus = 3;
    }

    void fillPhysicalLayer(boolean bl, boolean bl2) {
        int n;
        int n2 = this.m_collisionBox[0] / 24;
        int n3 = this.m_collisionBox[2] / 24 + 1;
        int n4 = this.m_collisionBox[1] / 24 + 1;
        int n5 = this.m_collisionBox[3] / 24;
        byte by = bl ? this.m_iBackTileLayerPhysical : (byte)0;
        int n6 = n4;
        int n7 = n6 * CGame.m_mapWidthByTile[2];
        byte[] byArray = CGame.m_mapBuf[2];
        if (n4 < n5 && n2 < n3) {
            n = (n4 + n5) / 2;
            if (!bl) {
                this.m_iBackTileLayerPhysical = byArray[n * CGame.m_mapWidthByTile[2] + (n2 + n3) / 2];
            }
        }
        while (n6 < n5) {
            for (n = n2; n < n3; ++n) {
                byArray[n7 + n] = bl2 && !bl && n6 == n4 && (n == n2 || n == n3 - 1) ? 9 : by;
            }
            n7 += CGame.m_mapWidthByTile[2];
            ++n6;
        }
    }

    void fillPhysicalLayer(boolean bl) {
        this.fillPhysicalLayer(bl, false);
    }

    boolean activeSlope() {
        CActor cActor = s_actors[this.m_Parameters[0]];
        if (cActor.m_actorStatus != 2) {
            boolean bl;
            int n = cActor.m_realX;
            boolean bl2 = bl = this.m_Parameters[1] == 1 || cActor.m_Parameters[1] == 1;
            if (this.m_realX > n) {
                GloftBEOW.m_game.registerSlope(cActor, this, bl);
            } else {
                GloftBEOW.m_game.registerSlope(this, cActor, bl);
            }
        }
        return true;
    }

    void deactiveSlope(boolean bl) {
        CGame cGame = GloftBEOW.m_game;
        CActor cActor = s_actors[this.m_Parameters[0]];
        if (cActor.m_actorStatus == 3 || cActor.m_actorStatus == 1) {
            cGame.unregisterSlope(this);
        }
        this.m_actorStatus = 3;
    }

    void updateVehicleAI() {
        short s = this.m_Parameters[3];
        short s2 = this.m_Parameters[4];
        short s3 = this.m_Parameters[1];
        short s4 = this.m_Parameters[2];
        this.UpdateSpriteAnim(true);
        if (this.testFlag(1024)) {
            return;
        }
        if (this.m_actionID == s) {
            if (m_hero.isTriggeredByHero(this.m_activeZoneBox, false)) {
                boolean bl;
                boolean bl2 = bl = this.m_Parameters[0] == 1;
                if (m_hero.registerVehicle(this, bl)) {
                    this.setAction(s2, s2);
                    m_hero.setMapPosition(this.m_mapX, this.m_mapY + -18);
                }
                this.m_vX = 768;
            }
        } else if (this.m_actionID == s2) {
            this.updateVehiclePosition();
            if (m_hero.testFlag(1024)) {
                m_hero.setMapPosition(this.m_mapX, this.m_mapY + -18);
                m_hero.updateOnVehicleAI();
            }
            if (!this.m_canRun) {
                this.setAction(s4, s4);
                m_hero.unregisterVehicle(this, false);
            }
        } else if (this.m_actionID != s3 && this.m_actionID == s4) {
            this.getCollisionBox();
            if (this.testFlag(32768) && (CActor.m_hero.m_actionID == 2 || CActor.m_hero.m_actionID == 41) && CActor.isCollide(this.m_collisionBox, CActor.m_hero.m_collisionBox)) {
                m_hero.setAttacked(CActor.m_hero.m_hp, false);
                CActor.m_hero.m_hp = 0;
            }
            if (this.testFlag(16)) {
                this.setFlag(4096, true);
                this.m_actorStatus = 4;
                this.setFlag(64, false);
            }
        }
    }

    void initVehicle() {
        short s = this.m_Parameters[3];
        this.setAction(s, s);
        this.m_attackPoint = 800;
    }

    void deactiveVehicle(boolean bl) {
    }

    void triggerVehicle() {
        m_hero.unregisterVehicle(this, true);
    }

    void updateVehiclePosition() {
        short s = this.m_Parameters[4];
        if (this.m_actionID != s) {
            return;
        }
        this.detectEnviroment();
        if (this.m_canStand) {
            this.m_aX = 50;
            if (!this.m_isOnslope) {
                this.m_vY = 0;
                this.m_aY = 0;
            }
        } else {
            this.m_aY = 3968;
        }
        this.updatePosition();
    }

    void updateDelayTriggerAI() {
        short s = this.m_Parameters[0];
        short s2 = this.m_Parameters[2];
        short s3 = this.m_Parameters[5];
        short s4 = this.m_Parameters[4];
        short s5 = this.m_Parameters[6];
        this.getCollisionBox();
        if (!this.testFlag(4096) && this.m_actionID == s4) {
            if (m_hero.isTriggeredByHero(this.m_collisionBox, true) && CGame.IsKeyPressed(262656) && m_hero.handleDevice(this, s4)) {
                this.setAction(s3, s3);
            }
            this.updateProgress(s2, this.m_Parameters[1]);
        } else if (this.m_actionID == s3) {
            if (CGame.IsKeyPressed(262656)) {
                this.setAction(s5, s3);
            }
            this.updateProgress(s2, this.m_Parameters[1]);
        } else if (this.m_actionID == s5) {
            if (!m_hero.isRunningDevice()) {
                this.setAction(s3, s3);
            }
            if (this.updateProgress(s, this.m_Parameters[1])) {
                this.triggerDelayTrigger();
                this.setAction(s4, s4);
                m_hero.leaveDevice(s5);
            }
        }
        if (!m_hero.isOnDevice() && this.m_actionID != s4) {
            this.setAction(s4, s4);
        }
        this.UpdateSpriteAnim(true);
    }

    void initDelayTrigger() {
        this.m_currStep = 0;
        this.m_actionID = this.m_Parameters[4];
        this.setFlag(512, true);
    }

    void deactiveDelayTrigger(boolean bl) {
    }

    void triggerDelayTrigger() {
        short s = this.m_Parameters[7];
        short s2 = this.m_Parameters[8];
        short s3 = this.m_Parameters[9];
        if (s != -1) {
            s_actors[s].TriggerActor();
        }
        if (s2 != -1) {
            s_actors[s2].TriggerActor();
        }
        if (s3 != -1) {
            s_actors[s3].TriggerActor();
        }
        this.setFlag(4096, true);
        this.setFlag(64, false);
    }

    boolean updateProgress(int n, int n2) {
        boolean bl = false;
        this.m_currStep += n;
        if (this.m_currStep <= 0) {
            this.m_currStep = 0;
        }
        if (this.m_currStep >= n2) {
            this.m_currStep = n2;
            bl = true;
        }
        return bl;
    }

    void drawDelayTriggerAccessory(Graphics graphics, int n, int n2) {
        CDebug._assert(graphics != null);
        short s = this.m_Parameters[4];
        if (this.m_actionID == s) {
            return;
        }
        short s2 = this.m_Parameters[1];
        int n3 = this.m_currStep * 100 / s2;
        int n4 = this.m_mapX - n;
        int n5 = this.m_mapY - n2;
        this.drawStatusBar(graphics, n4 -= 14, n5 -= 50, n3, 0xFF0000);
    }

    void updateVillagerAI() {
        boolean bl;
        this.UpdateSpriteAnim(true);
        short s = this.m_Parameters[0];
        short s2 = this.m_Parameters[1];
        short s3 = this.m_Parameters[2];
        short s4 = this.m_Parameters[3];
        short s5 = this.m_Parameters[4];
        short s6 = this.m_Parameters[5];
        short s7 = this.m_Parameters[6];
        boolean bl2 = s_EnemyActorCount != 0;
        boolean bl3 = bl = this.m_Parameters[7] == 1;
        if (bl2 && this.m_actionID != s5 && this.m_actionID != s7 && this.m_actionID != s6) {
            if (this.m_actionID != s4) {
                this.setAction(s4, s4);
            }
            int n = 0;
            for (int i = 0; i < s_EnemyActorCount; ++i) {
                CActor cActor = s_EnemyActor[i];
                if (!this.canBeAttackedBy(cActor)) continue;
                n += cActor.getAttackPoint();
                break;
            }
            if ((n += this.getAttackedHurt()) > 0) {
                this.m_hp -= n;
                if (this.IsAlive()) {
                    this.setAction(s5, s5);
                } else {
                    this.setAction(s6, s6);
                }
            }
        }
        this.clearAttackedInfo();
        if (this.m_actionID == s) {
            if (CActor.isCollide(CActor.m_hero.m_collisionBox, this.m_collisionBox)) {
                this.setAction(s2, s2);
                m_hero.addActorToList(this.m_actorID);
            }
        } else if (this.m_actionID == s2) {
            if (this.CanVillagerRun()) {
                this.setAction(s3, s3);
            }
        } else if (this.m_actionID == s3) {
            this.setFlag(1, !bl);
            if (!this.CanVillagerRun()) {
                this.setAction(s2, s2);
            }
        } else if (this.m_actionID == s4) {
            if (!bl2) {
                this.setAction(s2, s2);
            }
        } else if (this.m_actionID == s5) {
            if (this.testFlag(16)) {
                this.setAction(s4, s4);
            }
        } else if (this.m_actionID == s6) {
            if (this.testFlag(16)) {
                this.setAction(s7, s7);
            }
        } else if (this.m_actionID == s7 && this.testFlag(16)) {
            m_hero.removeActorFromList(this.m_actorID);
            this.setFlag(4096, true);
            this.m_actorStatus = 4;
            this.setFlag(64, false);
        }
        this.updateVillagerPosition();
    }

    void initVillager() {
        this.m_hp = this.m_Parameters[8];
        this.m_actionID = this.m_Parameters[0];
        this.setFlag(512, true);
    }

    void activeVillager() {
        int n = this.m_mapY % 100;
        n = n * this.m_z / (this.m_z + 5) - this.m_z;
        this.m_z -= n;
    }

    void deactiveVillager(boolean bl) {
    }

    void triggerVillager() {
    }

    void updateVillagerPosition() {
        short s = this.m_Parameters[2];
        this.detectEnviroment();
        this.m_vX = this.m_actionID == s ? (this.m_canRun ? (this.testFlag(1) ? -1792 : 1792) : 0) : 0;
        this.m_vY = 0;
        this.m_aY = 0;
        this.m_aX = 0;
        this.updatePosition();
    }

    boolean CanVillagerRun() {
        int n = this.getIDinList(CActor.m_hero.m_actorID);
        boolean bl = this.m_Parameters[7] == 1;
        int n2 = -32 * n;
        int n3 = CActor.m_hero.m_mapX + (n2 += 15);
        if (bl) {
            return n3 - this.m_mapX > 0;
        }
        n3 = CActor.m_hero.m_mapX + (n2 = -n2);
        return n3 - this.m_mapX < 0;
    }

    void displayVillagerAccessory(Graphics graphics, int n, int n2) {
        if (this.testFlag(1024)) {
            return;
        }
        if (this.m_Parameters[8] == 0) {
            return;
        }
        int n3 = this.m_hp * 100 / this.m_Parameters[8];
        int n4 = this.m_mapX - n + -14;
        int n5 = this.m_mapY - n2 + -60;
        int n6 = 29229056;
        if (n3 > 0) {
            this.drawHPBar(graphics, n4, n5, n3, n6);
        }
    }

    void addActorToList(int n) {
        if (n == -1 || n == this.m_nextVillagerID) {
            return;
        }
        if (this.m_nextVillagerID == -1) {
            this.m_nextVillagerID = n;
        } else {
            s_actors[this.m_nextVillagerID].addActorToList(n);
        }
    }

    boolean removeActorFromList(int n) {
        if (n == -1) {
            return true;
        }
        if (this.m_nextVillagerID == n) {
            int n2;
            this.m_nextVillagerID = n2 = CActor.s_actors[this.m_nextVillagerID].m_nextVillagerID;
            return true;
        }
        if (this.m_nextVillagerID == -1) {
            return false;
        }
        return s_actors[this.m_nextVillagerID].removeActorFromList(n);
    }

    int getLastActorIndexInList(int n) {
        int n2 = n;
        while (n2 != -1) {
            if (CActor.s_actors[n2].m_nextVillagerID == -1) {
                return n2;
            }
            n2 = CActor.s_actors[n2].m_nextVillagerID;
        }
        return -1;
    }

    int getIDinList(int n) {
        int n2 = 0;
        while (n != -1) {
            if (n == this.m_actorID) {
                return n2;
            }
            n = CActor.s_actors[n].m_nextVillagerID;
            ++n2;
        }
        return n2;
    }

    void updateWeaponAI() {
        this.UpdateSpriteAnim(true);
        this.detectEnviroment();
        if (this.removeIfOutofMap()) {
            return;
        }
        boolean bl = false;
        boolean bl2 = !this.m_canJump || this.m_canStand && this.m_vY > 0;
        switch (this.m_weaponType) {
            case 0: {
                int n;
                this.getCollisionBox();
                CActor cActor = null;
                for (n = s_activeActorsCount - 1; n >= 0; --n) {
                    cActor = s_activeActors[n];
                    if (cActor.m_classID == 48 && cActor.m_actionID == 0) {
                        cActor.getCollisionBox();
                        if (!CActor.isCollide(cActor.m_collisionBox, this.m_collisionBox)) continue;
                        cActor.setAction(1);
                        continue;
                    }
                    if (cActor.m_classID != 7 || cActor.m_actionID != 7 && cActor.m_actionID != 25 && cActor.m_actionID != 21 && cActor.m_actionID != 23) continue;
                    cActor.getCollisionBox();
                    if (!CActor.isCollide(cActor.m_collisionBox, this.m_collisionBox)) continue;
                    cActor.setAttacked(m_hero.getAttackPoint(), true);
                }
                for (n = 0; n < s_EnemyActorCount; ++n) {
                    cActor = s_EnemyActor[n];
                    if (cActor.m_classID == 56 && (cActor.m_Parameters[0] == 1 || cActor.m_Parameters[0] == 3 && cActor.m_state == 3) || cActor.m_classID == 44 && !((CEnemy)cActor).canFrisianGetHurt()) continue;
                    cActor.getCollisionBox();
                    if (!CActor.isCollide(this.m_collisionBox, cActor.m_collisionBox)) continue;
                    cActor.setAttacked(this.getAttackPoint(), this.m_mapX < cActor.m_mapX);
                }
                break;
            }
            case 1: {
                bl = true;
                if (this.m_actionID != 2 || !this.testFlag(16)) break;
                bl2 = true;
                break;
            }
        }
        this.updateWeaponPosition();
        if (bl) {
            if (m_hero.getAttackHurtToActor(this) > 0) {
                this.setAction(2, 2);
            } else {
                if (m_hero.canBeAttackedBy(this)) {
                    m_hero.setAttacked(this.getAttackPoint(), !this.testFlag(1));
                }
                this.checkVillager();
            }
        }
        if (bl2) {
            this.invalidateActor();
        }
    }

    void initWeapon() {
        this.m_actorStatus = 4;
    }

    boolean activeWeapon() {
        return false;
    }

    void triggerActorWeapon() {
    }

    void deactiveWeapon(boolean bl) {
    }

    void updateWeaponPosition() {
        switch (this.m_actionID) {
            case 0: {
                if (!this.m_canRun) {
                    this.setFlag(1, !this.testFlag(1));
                }
                this.m_aY = 1200;
                break;
            }
            case 1: {
                this.m_aX = 0;
                this.m_aY = 320;
                break;
            }
        }
        this.updatePosition();
    }

    void prepareWeapon(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        CDebug._assert(n < 4);
        this.m_weaponType = n;
        this.m_vX = 0;
        this.m_aX = 0;
        this.m_aY = 0;
        this.m_vY = 0;
        switch (this.m_weaponType) {
            case 0: {
                this.setAction(0);
                this.m_vX = n6;
                this.m_vY = n7;
                this.setFlag(1, n4 < 0);
                break;
            }
            case 1: {
                this.setAction(1, 2);
                this.m_vY = -3500;
                this.m_vX = Math.abs(320 * n4 / (this.m_vY * 2));
                if (n4 < 0) {
                    this.m_vX *= -1;
                }
                this.setFlag(1, n4 < 0);
                break;
            }
            case 2: {
                this.setAction(0);
                this.m_vY = -3500;
                this.m_vX = Math.abs(320 * n4 / (this.m_vY * 2));
                this.m_aY = 320;
                if (n4 < 0) {
                    this.m_vX *= -1;
                }
                this.setFlag(1, n4 < 0);
                break;
            }
            default: {
                CDebug._assert(false);
            }
        }
        this.setFlag(64, true);
        this.m_actorStatus = 2;
        this.m_attackPoint = n5;
        this.setMapPosition(n2, n3);
    }

    void invalidateActor() {
        this.setFlag(64, false);
        this.m_actorStatus = 4;
    }

    void checkVillager() {
        int n = CActor.m_hero.m_nextVillagerID;
        while (n != -1) {
            if (s_actors[n].canBeAttackedBy(this)) {
                s_actors[n].setAttacked(this.getAttackPoint(), !this.testFlag(1));
            }
            n = CActor.s_actors[n].m_nextVillagerID;
        }
    }

    void updateTrailerCameraAI() {
        if (m_hero.isTriggeredByHero(this.m_activeZoneBox, false)) {
            this.triggerTrailerCamera();
        } else if (s_actorToTriggerTrailer != null && s_actorToTriggerTrailer.testFlag(16)) {
            s_actorToTriggerTrailer.getCollisionBox();
            if (CActor.isCollide(this.m_activeZoneBox, CActor.s_actorToTriggerTrailer.m_collisionBox)) {
                this.triggerTrailerCamera();
                s_actorToTriggerTrailer = null;
            }
        }
    }

    void triggerTrailerCamera() {
        if (CGame.m_nLevelState == 5 || m_hero != null && CActor.m_hero.m_hp <= 0 || m_hero != null && m_hero.isHeroWillDie()) {
            return;
        }
        CGame.StopCurrentTrailer();
        CGame.m_currentTrailerIndex = CGame.GetTrailerIDByCameraID(this.m_actorID);
        CGame.m_currentTrailerCameraActorID = this.m_actorID;
        CGame.m_currentTrailerFrame = 0;
        CGame.InitCurrentTrailer();
        CGame.s_curTrailerCamera = this;
        this.setFlag(64, false);
        this.m_actorStatus = 4;
        this.setFlag(512, true);
        if (CGame.s_curTrailerCamera.m_actionID != 7) {
            CGame.CleanKey();
            CGame.setCameraLimit(-1, -1, 0);
            CGame.setCameraLimit(-1, -1, 1);
            CGame.setCameraLimit(-1, -1, 2);
            CGame.setCameraLimit(-1, -1, 3);
        }
    }

    void updateTrailerCameraInTrailer() {
        CGame cGame = GloftBEOW.m_game;
        int n = 0;
        int n2 = 0;
        if (this.m_actionID == 4) {
            n = CGame.m_frameCounter % 2 > 0 ? 6 : -6;
        } else if (this.m_actionID == 5) {
            n2 = CGame.m_frameCounter % 2 > 0 ? 6 : -6;
        }
        switch (this.m_actionID) {
            case 0: 
            case 6: {
                this.m_trailerFrameCount = 0;
                break;
            }
            case 1: {
                if (this.m_trailerFrameCount <= 2) break;
                --this.m_trailerFrameCount;
                break;
            }
            case 2: {
                ++this.m_trailerFrameCount;
                if (this.m_trailerFrameCount <= 2) break;
                this.m_trailerFrameCount = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                this.m_trailerFrameCount = 2;
                break;
            }
            case 7: {
                this.m_trailerFrameCount = 0;
                break;
            }
            default: {
                CDebug._assert(false);
            }
        }
        if (this.m_actionID != 7) {
            cGame.setCameraCenter(this.m_mapX + n, this.m_mapY + n2);
        }
    }

    void initTrailerCameraKeyFrame() {
        CGame cGame = GloftBEOW.m_game;
        switch (this.m_actionID) {
            case 0: {
                this.m_trailerFrameCount = 0;
                this.setRealPosition(this.m_realX, this.m_realY);
                break;
            }
            case 1: {
                this.m_trailerFrameCount = 8;
                this.setRealPosition(this.m_realX, this.m_realY);
                break;
            }
            case 2: {
                this.m_trailerFrameCount = 0;
                this.setRealPosition(this.m_realX, this.m_realY);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                this.m_trailerFrameCount = 2;
                this.setRealPosition(this.m_realX, this.m_realY);
                break;
            }
            case 6: {
                this.setRealPosition(cGame.m_cameraCenterX << 8, cGame.m_cameraCenterY << 8);
                break;
            }
            case 7: {
                this.m_trailerFrameCount = 0;
                break;
            }
            default: {
                CDebug._assert(false);
            }
        }
    }

    void drawTrailerCameraAccessory(Graphics graphics, int n, int n2) {
        boolean bl;
        boolean bl2 = bl = s_curTrailerTextID >= 0 && this.m_actionID == 7;
        if (this.m_trailerFrameCount != 0 || bl) {
            graphics.setClip(0, 0, 240, 320);
            int n3 = bl ? 66 : this.m_trailerFrameCount * (s_curTrailerTextID >= 0 ? 33 : 20);
            int n4 = this.m_trailerFrameCount * 20;
            int n5 = 320 - n4;
            graphics.setColor(0);
            graphics.fillRect(0, 0, 240, n3);
            if (!bl) {
                graphics.fillRect(0, n5, 240, n4);
            }
            graphics.setColor(0x252525);
            graphics.drawLine(0, n3, 240, n3);
            if (!bl) {
                graphics.drawLine(0, n5 - 1, 240, n5 - 1);
            }
            graphics.setColor(0x555555);
            graphics.drawLine(0, n3 + 1, 240, n3 + 1);
            if (!bl) {
                graphics.drawLine(0, n5 - 2, 240, n5 - 2);
            }
            if (this.m_Parameters[1] == 1) {
                CGame.s_SpriteFontBig.SetCurrentPalette(0);
                CGame.drawSoftKeyCommand(CGame.m_commonTexts[33], null);
            }
            if (s_curTrailerTextID >= 0) {
                int n6 = (this.m_hp & 1) << 2 | (this.m_hp & 4) >> 1 | (this.m_hp & 8) >> 3;
                CGame.s_AnimationInterface.PaintAFrame(graphics, 10 + n6, 0, 0, n3 - 60 >> 1, 0, 0, 0);
                CGame.s_SpriteFontBig.DrawPage(graphics, CGame.m_levelTexts[s_curTrailerTextID], 142, n3 >> 1, 195, 3);
            }
        }
    }

    void updateCrystalAI() {
        if (this.m_actionID == 6 || this.m_actionID == 11) {
            this.updatePosition();
            if (this.m_canStand) {
                this.m_vY = -this.m_vY;
                this.setFlag(256, true);
            } else if (!this.m_canRun) {
                this.m_vX = -this.m_vX;
            }
            if (this.m_waitTime++ > 50) {
                this.m_waitTime = 0;
                this.setFlag(128, true);
                if (this.m_actionID == 6) {
                    this.setAction(7);
                } else {
                    this.setAction(12);
                }
                this.setFlag(256, false);
            } else if (Math.abs(this.m_vY) <= 768 && this.m_canStand) {
                if (this.m_actionID == 6) {
                    this.setAction(7);
                } else {
                    this.setAction(12);
                }
                this.setFlag(256, false);
            }
            if (this.testFlag(256) || this.m_isOnslope || m_hero.isHeroBackClimbing()) {
                this.setFlag(256, false);
                this.eatCrystal();
            }
        } else if (this.m_actionID == 0 || this.m_actionID == 10) {
            int n = CActor.m_hero.m_mapX - this.m_mapX;
            int n2 = CActor.m_hero.m_mapY + -30 - this.m_mapY;
            int n3 = CGame.getDistance(n, n2);
            int n4 = n3 = n3 <= 0 ? 1 : n3;
            if (n3 <= 100) {
                this.m_vX = 4608 * n / n3;
                this.m_vY = 4608 * n2 / n3;
                this.setRealPosition(this.m_realX + this.m_vX, this.m_realY + this.m_vY);
                this.eatCrystal();
            }
        } else if (this.m_actionID == 1) {
            if (this.testFlag(16)) {
                this.m_actorStatus = 4;
                this.setFlag(4096, true);
                this.setFlag(64, false);
                m_hero.addScore(this);
            }
        } else if (this.m_actionID == 7 || this.m_actionID == 12) {
            this.updatePosition();
            if (!this.m_canRun) {
                this.m_vX = -this.m_vX;
            }
            if (this.m_canStand) {
                this.m_vY = 0;
                this.m_vX = 0;
            }
            this.eatCrystal();
            if (this.testFlag(16)) {
                this.m_actorStatus = 4;
                this.setFlag(4096, true);
                this.setFlag(64, false);
            }
        } else if (this.m_actionID == 2 || this.m_actionID == 3) {
            this.getCollisionBox();
            if (!this.testFlag(4096) && m_hero.isTriggeredByHero(this.m_collisionBox, true) && CActor.m_hero.m_hp > 0) {
                this.m_actorStatus = 4;
                this.setFlag(4096, true);
                this.cloneEatEffect(this.m_actionID, this.m_mapX, this.m_mapY);
            }
        } else if (this.m_actionID == 4 || this.m_actionID == 5) {
            this.getCollisionBox();
            if (!this.testFlag(4096) && m_hero.isTriggeredByHero(this.m_collisionBox, true)) {
                this.m_actorStatus = 4;
                this.setFlag(4096, true);
                this.cloneEatEffect(this.m_actionID, this.m_mapX, this.m_mapY);
            }
        } else if (this.m_actionID == 8) {
            this.getCollisionBox();
            if (m_hero.isTriggeredByHero(this.m_collisionBox, true)) {
                m_hero.increaseMaxHPAndRage();
                this.setAction(9);
            }
        } else if (this.m_actionID == 9 && this.testFlag(16)) {
            this.m_actorStatus = 4;
            this.setFlag(4096, true);
            this.setFlag(64, false);
        }
        this.UpdateSpriteAnim(true);
    }

    void jumpOutCrystal(int n, int n2, int n3) {
        CActor cActor = this.clone(20, this.m_mapX + n2, this.m_mapY + n3, 6);
        if (cActor == null) {
            return;
        }
        cActor.m_vX = (n % 2 == 0 ? -1 : 1) * CGame.Random(512, 1792);
        cActor.m_vY = -CGame.Random(5120, 8960);
        cActor.m_aY = 1536;
        int n4 = cActor.m_hp = CGame.Random(0, 2) != 0 ? 10 : 50;
        if (cActor.m_hp < 50) {
            cActor.m_actionID = 11;
        }
        cActor.setFlag(64, true);
    }

    boolean eatCrystal() {
        this.getCollisionBox();
        if (!this.testFlag(4096) && m_hero.isTriggeredByHero(this.m_collisionBox, true)) {
            CGame.PlaySound(1);
            this.setAction(1, 1);
            return true;
        }
        return false;
    }

    void initCrystal() {
        if (this.m_actionID != 6 && this.m_actionID != 11) {
            this.setFlag(16384, true);
        }
        this.m_hp = this.m_Parameters == null ? 10 : this.m_Parameters[0];
        if (this.m_hp < 50 && this.m_actionID == 0) {
            this.m_actionID = 10;
        }
    }

    void triggerCrystal() {
        this.setFlag(2, false);
        this.m_actorStatus = 2;
        this.setFlag(4096, false);
        switch (this.m_actionID) {
            case 0: 
            case 1: 
            case 7: {
                this.setAction(0, 0);
            }
        }
    }

    void cloneEatEffect(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        if (n == 2) {
            n4 = 14;
        } else if (n == 3) {
            n4 = 13;
        } else if (n == 4) {
            n4 = 14;
            n5 = 1;
        } else if (n == 5) {
            n4 = 13;
            n5 = 1;
        }
        CActor cActor = this.clone(21, n2, n3, n4);
        if (cActor != null) {
            cActor.m_Palette = n5;
        }
    }

    void updateBallAI() {
        short s = this.m_Parameters[0];
        short s2 = this.m_Parameters[2];
        short s3 = this.m_Parameters[5];
        short s4 = this.m_Parameters[6];
        if (this.m_actionID == 2) {
            this.updateBallPosition();
            m_hero.setMapPosition(this.m_mapX + 43, this.m_mapY + 30);
            if (m_hero.touchBall(this, true)) {
                this.setAction(s3, s3);
                this.setFlag(512, true);
            }
            this.m_vX = 768;
        } else if (this.m_actionID == s3) {
            this.updateBallPosition();
            m_hero.updatePosition();
            if (CActor.m_hero.m_isOnslope) {
                m_hero.setMapPosition(this.m_mapX + 43, this.m_mapY + 30);
            } else {
                m_hero.setMapPosition(this.m_mapX + 43, CActor.m_hero.m_mapY);
            }
            if (CGame.IsKeyPressed(260)) {
                this.updateBallProgress(s);
            } else if (this.updateBallProgress(s2)) {
                this.setFlag(128, true);
                this.setAction(3, 3);
                this.setFlag(512, false);
                m_hero.leaveBall(this, 135);
                CActor.m_hero.m_hp = 0;
            } else if (!CActor.m_hero.m_canStand) {
                this.setFlag(128, true);
                this.setAction(3, 3);
                this.setFlag(512, false);
                m_hero.leaveBall(this, 8);
            }
        } else if (this.m_actionID == s4) {
            this.updateBallPosition();
            if (m_isTileLethal) {
                this.setFlag(4096, true);
                this.m_actorStatus = 4;
                this.setFlag(64, false);
            }
        }
        this.UpdateSpriteAnim(true);
    }

    void initBall() {
        this.m_currBallStep = this.m_Parameters[1];
        this.setFlag(512, false);
    }

    void deactiveBall(boolean bl) {
    }

    void triggerBall() {
        this.setFlag(128, true);
        this.setAction(3, 3);
        this.setFlag(512, false);
        m_hero.leaveBall(this, 7);
    }

    void updateBallPosition() {
        this.detectEnviroment();
        this.m_aY = 3968;
        if (this.m_canStand) {
            this.m_aX = 40;
            if (!this.m_isOnslope) {
                this.m_vY = 0;
                this.m_aY = 0;
            }
        }
        this.updatePosition();
    }

    boolean updateBallProgress(int n) {
        boolean bl = false;
        int n2 = this.m_Parameters[1];
        this.m_currBallStep += n;
        if (this.m_currBallStep <= 0) {
            this.m_currBallStep = 0;
            bl = true;
        }
        if (this.m_currBallStep >= n2) {
            this.m_currBallStep = n2;
        }
        return bl;
    }

    void drawBallAccessory(Graphics graphics, int n, int n2) {
        CDebug._assert(graphics != null);
        short s = this.m_Parameters[1];
        int n3 = this.m_currBallStep * 100 / s;
        int n4 = this.m_mapX - n;
        int n5 = this.m_mapY - n2;
        this.drawStatusBar(graphics, n4 -= 14, n5 -= 60, n3, 0xFF0000);
    }

    void updateIronDoorAI() {
        short s = this.m_Parameters[0];
        short s2 = this.m_Parameters[2];
        short s3 = this.m_Parameters[4];
        short s4 = this.m_Parameters[5];
        short s5 = this.m_Parameters[6];
        short s6 = this.m_Parameters[7];
        short s7 = this.m_Parameters[8];
        if (this.m_actionID != s4) {
            this.UpdateSpriteAnim(true);
        }
        if (this.m_actionID == s3) {
            this.getActiveBox();
            if ((CActor.m_hero.m_actionID == 0 || CActor.m_hero.m_actionID == 5) && CGame.IsKeyPressed(262656) && m_hero.isFaceTo(this) && m_hero.isTriggeredByHero(this.m_activeZoneBox, true)) {
                this.getCollisionBox();
                this.fillPhysicalLayer(true);
                CHero.s_actionActor = this;
                m_hero.setAction(51);
            }
        } else if (this.m_actionID == s4) {
            if (CGame.IsKeyPressed(262656)) {
                if (this.updateProgress(s, this.m_Parameters[1])) {
                    this.setAction(s5);
                    this.m_currStep = 0;
                    this.m_waitTime = 0;
                    CHero.s_noUpdateAnim = false;
                    CHero.s_actionActor = null;
                    m_hero.setAction(52);
                    this.setFlag(4096, true);
                }
            } else if (this.m_currStep == 0 && CGame.IsKeyPressed(260)) {
                CHero.s_noUpdateAnim = false;
                CHero.s_actionActor = null;
                m_hero.setAction(0);
                this.setAction(s3);
                this.getCollisionBox();
                this.fillPhysicalLayer(false);
                this.m_currStep = 0;
            } else {
                this.updateProgress(s2, this.m_Parameters[1]);
            }
            this.m_currAFrame = this.m_currStep * this.m_sprite.GetAFrames(this.m_actionID) / this.m_Parameters[1];
            this.setSpriteAnimFrame(this.m_currAFrame, false);
        } else if (this.m_actionID == s5) {
            if (this.testFlag(16)) {
                this.setAction(s6);
            }
        } else if (this.m_actionID == s6) {
            if (this.m_waitTime++ > 25) {
                this.setAction(s7);
            }
        } else if (this.m_actionID == s7) {
            if (m_hero.isTriggeredByHero(this.m_activeZoneBox, true)) {
                boolean bl = this.m_realX - CActor.m_hero.m_realX < 0;
                m_hero.setAttacked(10, bl);
                m_hero.setMapPosition(CActor.m_hero.m_mapX + (bl ? 24 : -24), CActor.m_hero.m_mapY);
            }
            if (this.testFlag(16)) {
                this.setAction(s3);
                this.getCollisionBox();
                this.fillPhysicalLayer(false);
            }
        }
    }

    void initIronDoor() {
        this.m_currStep = 0;
        this.m_actionID = this.m_Parameters[4];
        this.setFlag(512, true);
        this.fillPhysicalLayer(true);
        this.getCollisionBox();
        this.fillPhysicalLayer(false);
    }

    void deactiveIronDoor(boolean bl) {
    }

    void triggerIronDoor() {
        this.setFlag(4096, true);
        this.setFlag(64, false);
    }

    void drawIronDoorAccessory(Graphics graphics, int n, int n2) {
        CDebug._assert(graphics != null);
        if (this.m_actionID != this.m_Parameters[5]) {
            return;
        }
        short s = this.m_Parameters[1];
        int n3 = this.m_currStep * 100 / s;
        int n4 = this.m_mapX - n;
        int n5 = this.m_mapY - n2;
        this.drawStatusBar(graphics, n4 -= 14, n5 -= 50, n3, 0xFF0000);
    }

    void updateCeilingAI() {
        if (this.m_actionID == 8) {
            if (CActor.m_hero.m_actionID == 0) {
                this.getActiveBox();
                m_hero.getCollisionBox();
                if (m_hero.isTriggeredByHero(this.m_activeZoneBox, true)) {
                    CHero.s_actionActor = this;
                    CActor.m_hero.m_waitTime = 0;
                    m_hero.setAction(72);
                    this.setFlag(512, true);
                    this.setAction(9);
                }
            }
            this.UpdateSpriteAnim(true);
        } else if (this.m_actionID == 10) {
            if (this.testFlag(16)) {
                this.setAction(11);
                this.setCeilingSpeed(true);
            }
            this.UpdateSpriteAnim(false);
        } else if (this.m_actionID == 11) {
            boolean bl;
            this.updatePosition();
            boolean bl2 = bl = !this.m_canRun || this.m_canStand;
            if (bl) {
                CHero.m_cameraShakingTimer = 5;
                this.setAction(12);
            }
            this.UpdateSpriteAnim(true);
        } else if (this.m_actionID == 12) {
            if (this.testFlag(16)) {
                this.m_actorStatus = 4;
                CActor.m_hero.m_actorToBeThrow = null;
                s_actorToTriggerTrailer = null;
            }
            this.UpdateSpriteAnim(false);
        } else if (this.m_actionID == 13) {
            this.UpdateSpriteAnim(false);
        } else {
            this.UpdateSpriteAnim(true);
        }
    }

    void setCeilingSpeed(boolean bl) {
        if (bl) {
            this.m_vY = -4864;
            this.m_aY = 1792;
            this.m_vX = m_hero.testFlag(1) ? -7680 : 7680;
        }
    }

    void updateHOAI() {
        this.UpdateSpriteAnim(true);
        if (this.m_actionID == 0) {
            if ((CActor.m_hero.m_actionID == 0 || CActor.m_hero.m_actionID == 5) && CGame.IsKeyPressed(262656) && m_hero.canFindHO(this)) {
                CHero.s_actionActor = this;
                m_hero.setAction(56);
                this.setFlag(512, true);
                this.setAction(1);
            }
        } else if (this.m_actionID == 3) {
            this.m_realX = CActor.m_hero.m_realX;
            this.m_realY = CActor.m_hero.m_realY;
            this.updatePosition();
        } else if (this.m_actionID == 5) {
            if (this.testFlag(16)) {
                this.setAction(3);
            }
        } else if (this.m_actionID == 6) {
            if (this.m_sprite.GetAnimFrame(this.m_actionID, this.m_currAFrame) == 38) {
                CHero.m_cameraShakingTimer = 6;
            }
            if (this.testFlag(16)) {
                this.setAction(3);
            }
        } else if (this.m_actionID == 7 && this.testFlag(16)) {
            this.m_actorStatus = 4;
        }
    }

    void initWall() {
        this.fillPhysicalLayer(true);
        this.getCollisionBox();
        this.fillPhysicalLayer(false);
    }

    void updateWallAI() {
        if (this.m_actionID == 0) {
            this.UpdateSpriteAnim(true);
            int n = 0;
            if (s_steelBall != null) {
                n = s_steelBall.getSteelBallAttackToEnemy(this);
            }
            if (n == 0) {
                n = m_hero.getAttackHurtToActor(this);
            }
            if (n >= 70) {
                this.getCollisionBox();
                this.fillPhysicalLayer(true);
                CGame.PlaySound(4);
                this.setAction(1);
                CHero.m_cameraShakingTimer = 5;
                if (this.m_Parameters[0] == 1 && CHero.s_actionActor != null && CHero.s_actionActor.m_classID == 25) {
                    m_hero.setAction(0);
                    CHero.s_actionActor.setAction(7);
                    CHero.s_actionActor = null;
                }
            } else if (n > 0 && CActor.m_hero.m_vY == 0) {
                m_hero.attackWhenGuard(this);
            }
        } else if (this.m_actionID == 1) {
            this.UpdateSpriteAnim(false);
            if (this.testFlag(16)) {
                this.m_actorStatus = 4;
                this.setFlag(4096, true);
            }
        }
    }

    void updateSlipeRopeAI() {
        this.UpdateSpriteAnim(true);
        if (this.m_actionID == 0) {
            if (CActor.m_hero.m_vY != 0 || CActor.m_hero.m_aY != 0) {
                this.getCollisionBox();
                if (CActor.m_hero.m_actionID != 36 && m_hero.isTriggeredByHero(this.m_collisionBox, true)) {
                    this.setAction(1);
                    m_hero.setFaceTo(this);
                    m_hero.setAction(97);
                    m_hero.setMapPosition(this.m_mapX, this.m_mapY);
                }
            }
        } else if (this.m_actionID == 1) {
            CHero.s_cameraOffX += m_hero.testFlag(1) ? -8 : 8;
            if (this.testFlag(16)) {
                CHero.s_cameraOffX = 0;
                this.setAction(2);
                if (CActor.m_hero.m_actionID != 36 && CActor.m_hero.m_prevActionID != 36) {
                    m_hero.setAction(98);
                    short s = this.m_Parameters[0];
                    if (this.testFlag(1)) {
                        s = -s;
                    }
                    short s2 = this.m_Parameters[1];
                    CActor.m_hero.m_vX = s << 8;
                    CActor.m_hero.m_vY = s2 << 8;
                    CActor.m_hero.m_aY = 1792;
                    int n = m_hero.testFlag(1) ? -45 : 45;
                    m_hero.setMapPosition(CActor.m_hero.m_mapX + n, CActor.m_hero.m_mapY + 28);
                }
            }
        } else if (this.m_actionID == 2 && this.testFlag(16)) {
            this.setAction(0);
        }
    }

    void updateSoliderAI() {
        this.UpdateSpriteAnim(true);
        boolean bl = false;
        this.getActiveBox();
        if (m_hero.isTriggeredByHero(this.m_activeZoneBox, true)) {
            bl = true;
        }
        if (this.m_actionID == 7) {
            if (bl && this.testFlag(16)) {
                this.setAction(1);
            }
        } else if (this.m_actionID == 1 && !bl && this.testFlag(16)) {
            this.setAction(7);
        }
    }

    void updateGrendelWeapon() {
        this.UpdateSpriteAnim(true);
        this.setRealPosition(this.m_realX + this.m_vX, this.m_realY + this.m_vY);
        this.getCollisionBox();
        if (m_hero.isTriggeredByHero(this.m_collisionBox, true)) {
            m_hero.setAttacked(this.m_Parameters[0], this.isFaceTo(m_hero));
            this.setFlag(2, false);
            this.m_actorStatus = 4;
            this.setFlag(64, false);
        }
    }

    void initSeaPlatform() {
        if (this.m_actionID == 6 || this.m_actionID == 7 || this.m_actionID == 3 || this.m_actionID == 4) {
            return;
        }
        this.fillPhysicalLayer(true);
        this.getCollisionBox();
        this.fillPhysicalLayer(false, true);
        this.m_hp = this.m_Parameters[0];
    }

    void deactiveSeaPlatform() {
        if (this.m_actionID == 6 || this.m_actionID == 7 || this.m_actionID == 3 || this.m_actionID == 4) {
            return;
        }
        int n = CGame.m_cameraLeftLimit;
        if (this.m_activeZoneBox[2] <= n && n - this.m_activeZoneBox[2] <= 48 && this.m_activeZoneBox[1] - CGame.m_cameraTop <= 192) {
            this.fillPhysicalLayer(true);
        }
    }

    void updateSeaPlatform() {
        this.UpdateSpriteAnim(true);
        if (this.m_actionID == 6) {
            if (CHero.s_blowDir != 0) {
                this.setAction(7);
            }
            return;
        }
        if (this.m_actionID == 7) {
            if (this.testFlag(16) && CHero.s_blowDir == 0) {
                this.setAction(6);
            }
            return;
        }
        if (this.m_actionID == 3) {
            if (CHero.s_blowDir != 0) {
                this.setAction(4);
            }
            return;
        }
        if (this.m_actionID == 4) {
            if (this.testFlag(16) && CHero.s_blowDir == 0) {
                this.setAction(3);
            }
            return;
        }
        int n = this.getAttackedHurt();
        this.clearAttackedInfo();
        if (n > 0 && this.m_actionID != 1 && this.m_actionID != 2) {
            this.m_hp -= n;
            if (this.m_hp > 0) {
                this.setAction(1);
            } else {
                this.setAction(2);
            }
        }
        switch (this.m_actionID) {
            case 1: {
                if (!this.testFlag(16)) break;
                this.setAction(0);
                break;
            }
            case 2: {
                this.fillPhysicalLayer(true);
                this.getCollisionBox();
                this.fillPhysicalLayer(false, true);
                if (!this.testFlag(16)) break;
                this.fillPhysicalLayer(true);
                this.m_actorStatus = 4;
            }
        }
    }

    void updateBloodAI() {
        this.UpdateSpriteAnim(true);
        if (this.m_actionID == 13 || this.m_actionID == 14) {
            int n = CGame.m_cameraLeft - this.m_mapX;
            int n2 = CGame.m_cameraTop - this.m_mapY;
            int n3 = CGame.getDistance(n, n2);
            this.m_vX = 7680 * n / n3 + CActor.m_hero.m_vX;
            this.m_vY = 7680 * n2 / n3 + CActor.m_hero.m_vY;
            this.setRealPosition(this.m_realX + this.m_vX, this.m_realY + this.m_vY);
            if (n3 <= 100) {
                this.m_actorStatus = 4;
                this.setFlag(64, false);
                if (this.m_Palette == 0) {
                    m_hero.addHP(this.m_actionID == 14 ? 0 : 1);
                } else if (this.m_Palette == 1) {
                    m_hero.addRage(this.m_actionID == 14 ? 0 : 1);
                }
            }
            return;
        }
        if (this.m_actionID == 10) {
            this.setMapPosition(CActor.m_hero.m_mapX, CActor.m_hero.m_mapY);
        } else if (this.m_actionID == 11) {
            this.setMapPosition(CActor.m_frisianLeader.m_mapX, CActor.m_frisianLeader.m_mapY);
            return;
        }
        if (this.testFlag(16)) {
            this.m_actorStatus = 4;
            this.setFlag(64, false);
        }
    }

    void updateBirdAI() {
        this.UpdateSpriteAnim(true);
        if (this.m_actionID == 2) {
            this.setRealPosition(this.m_realX + this.m_vX, this.m_realY + this.m_vY);
            if (++this.m_waitTime > 20) {
                this.m_actorStatus = 4;
            }
        } else {
            this.getActiveBox();
            if (m_hero.isTriggeredByHero(this.m_activeZoneBox, true)) {
                this.setAction(2);
                this.m_vY = -3328;
                int n = CGame.Random(512, 3072);
                this.m_vX = this.testFlag(1) ? -n : n;
                this.m_waitTime = 0;
            }
        }
    }

    void updateBatSmallAI() {
        this.UpdateSpriteAnim(true);
        if (this.m_actionID == 1) {
            this.setRealPosition(this.m_realX + this.m_vX, this.m_realY + this.m_vY);
            if (++this.m_waitTime > 80) {
                this.m_waitTime = 0;
                this.m_actorStatus = 4;
            }
        } else {
            this.getActiveBox();
            if (m_hero.isTriggeredByHero(this.m_activeZoneBox, true)) {
                this.setAction(1);
                this.m_vX = this.testFlag(1) ? -768 : 768;
                this.m_vY = -CGame.Random(1280, 2560);
                this.m_waitTime = 0;
            }
        }
    }

    void initStab() {
        this.m_waitTime = this.m_Parameters[2];
    }

    void updateStabAI() {
        this.UpdateSpriteAnim(true);
        --this.m_waitTime;
        this.getAttackBox();
        if (m_hero.canBeAttackedBy(this)) {
            m_hero.setAttacked(this.getAttackPoint(), this.m_mapX < CActor.m_hero.m_mapX);
        }
        switch (this.m_actionID) {
            case 5: {
                if (this.m_waitTime >= 0) break;
                this.setAction(6);
                break;
            }
            case 0: {
                if (this.m_waitTime >= 0) break;
                this.setAction(1);
                break;
            }
            case 6: {
                if (!this.testFlag(16)) break;
                this.setAction(7);
                break;
            }
            case 1: {
                if (!this.testFlag(16)) break;
                this.setAction(2);
                break;
            }
            case 7: {
                if (!this.testFlag(16)) break;
                this.setAction(8);
                this.m_waitTime = this.m_Parameters[1];
                break;
            }
            case 2: {
                if (!this.testFlag(16)) break;
                this.setAction(3);
                this.m_waitTime = this.m_Parameters[1];
                break;
            }
            case 8: {
                if (this.m_waitTime >= 0) break;
                this.setAction(9);
                break;
            }
            case 3: {
                if (this.m_waitTime >= 0) break;
                this.setAction(4);
                this.m_waitTime = this.m_Parameters[0];
                break;
            }
            case 9: {
                if (!this.testFlag(16)) break;
                this.setAction(5);
                this.m_waitTime = this.m_Parameters[0];
                break;
            }
            case 4: {
                if (!this.testFlag(16)) break;
                this.setAction(0);
                this.m_waitTime = this.m_Parameters[0];
            }
        }
    }

    void initSteelBall() {
        this.shiftToFloor();
    }

    void activeSteelBall() {
        CHero.s_blockActor = this;
        s_steelBall = this;
        this.setFlag(64, true);
    }

    void updateSteelBall() {
        int n;
        if (this.m_actionID != 10) {
            this.checkSteelBallKilled();
            if (CHero.s_actionActor == this && ((n = CActor.isBoxAbutOnHorizontal(CActor.m_hero.m_collisionBox, this.m_collisionBox)) == -1 || n == 1 && m_hero.testFlag(1) || n == 2 && !m_hero.testFlag(1))) {
                m_hero.setAction(0);
                CHero.s_actionActor = null;
            }
            this.UpdateSpriteAnim(true);
        } else {
            if (CHero.s_platformActor == this) {
                CHero.s_platformActor = null;
            }
            this.UpdateSpriteAnim(false);
        }
        n = this.m_Parameters[0];
        switch (this.m_actionID) {
            case 0: {
                if (!CActor.m_hero.m_pressForward) break;
                if (!this.testFlag(256) && CHero.s_actionActor == this && CActor.m_hero.m_actionID == 109) {
                    if (n < 0) break;
                    if (m_hero.testFlag(1)) {
                        if (this.m_mapX != CActor.s_actors[n].m_mapX) break;
                        this.setAction(7);
                        this.m_vX = -3072;
                        m_hero.setAction(119);
                        CHero.s_actionActor = null;
                        this.setFlag(256, true);
                        break;
                    }
                    if (this.m_mapX != CActor.s_actors[n].m_mapX) break;
                    this.setAction(7);
                    this.m_vX = 3072;
                    m_hero.setAction(119);
                    CHero.s_actionActor = null;
                    this.setFlag(256, true);
                    break;
                }
                if (CActor.m_hero.m_actionID != 0 && CActor.m_hero.m_actionID != 4 || Math.abs(CActor.m_hero.m_mapY - this.m_mapY) > 12) break;
                this.getCollisionBox();
                m_hero.getCollisionBox();
                int n2 = CActor.isBoxAbutOnHorizontal(CActor.m_hero.m_collisionBox, this.m_collisionBox);
                if ((n2 != 1 || m_hero.testFlag(1)) && (n2 != 2 || !m_hero.testFlag(1))) break;
                m_hero.setAction(109);
                CHero.s_actionActor = this;
                break;
            }
            case 7: {
                this.updatePos(true);
                if (this.steelBallFall()) break;
                if (CHero.s_actionActor == this && n >= 0 && !this.testFlag(256)) {
                    if (m_hero.testFlag(1)) {
                        if (this.m_mapX < CActor.s_actors[n].m_mapX) {
                            this.setMapPosition(CActor.s_actors[n].m_mapX, this.m_mapY);
                            this.setAction(0);
                            m_hero.setAction(109);
                        }
                    } else if (this.m_mapX > CActor.s_actors[n].m_mapX) {
                        this.setMapPosition(CActor.s_actors[n].m_mapX, this.m_mapY);
                        this.setAction(0);
                        m_hero.setAction(109);
                    }
                }
                if (s_bBlockFront) {
                    this.setAction(0);
                    if (CHero.s_actionActor != this) break;
                    m_hero.setAction(109);
                    break;
                }
                if (CHero.s_actionActor == this || Math.abs(this.m_vX) > Math.abs(this.m_aX)) break;
                this.setAction(0);
                break;
            }
            case 8: {
                this.updatePos(true);
                if (this.steelBallFall()) break;
                if (CHero.s_actionActor == this && n >= 0 && !this.testFlag(256)) {
                    if (m_hero.testFlag(1)) {
                        if (this.m_mapX < CActor.s_actors[n].m_mapX) {
                            this.setMapPosition(CActor.s_actors[n].m_mapX, this.m_mapY);
                            this.setAction(0);
                            m_hero.setAction(109);
                        }
                    } else if (this.m_mapX > CActor.s_actors[n].m_mapX) {
                        this.setMapPosition(CActor.s_actors[n].m_mapX, this.m_mapY);
                        this.setAction(0);
                        m_hero.setAction(109);
                    }
                }
                if (s_bBlockFront) {
                    CHero.m_cameraShakingTimer = 5;
                    this.setAction(0);
                    this.setFlag(2048, false);
                    if (CHero.s_actionActor != this) break;
                    this.setFlag(2048, true);
                    m_hero.setAction(0);
                    CHero.s_actionActor = null;
                    break;
                }
                if (CHero.s_actionActor == this || Math.abs(this.m_vX) > Math.abs(this.m_aX)) break;
                this.setAction(0);
                break;
            }
            case 9: {
                if (CHero.s_platformActor == this) {
                    CHero.s_platformActor = null;
                }
                this.updatePos(true);
                if (!s_bBlockBottom) break;
                this.setAction(0);
                CHero.m_cameraShakingTimer = 5;
                CGame.PlaySound(4);
                break;
            }
            case 10: {
                if (!this.testFlag(16)) break;
                this.m_actorStatus = 4;
                this.setFlag(4096, true);
                this.setFlag(64, false);
                short s = this.m_Parameters[1];
                if (s < 0) break;
                CActor.s_actors[s].m_actorStatus = 1;
                s_actors[s].TriggerActor();
                break;
            }
            case 19: {
                short s;
                if (!this.testFlag(16)) break;
                this.m_actorStatus = 4;
                this.setFlag(4096, true);
                this.setFlag(64, false);
                if (CHero.s_blockActor == this) {
                    CHero.s_blockActor = null;
                }
                if ((s = this.m_Parameters[1]) < 0) break;
                CActor.s_actors[s].m_actorStatus = 1;
                s_actors[s].TriggerActor();
            }
        }
    }

    boolean isSteelBallOnSlopePoint() {
        short s = this.m_Parameters[0];
        return s >= 0 && this.m_mapX == CActor.s_actors[s].m_mapX;
    }

    boolean steelBallFall() {
        if (s_bWillFall && this.m_Parameters[0] < 0) {
            int n = this.m_vX;
            this.setAction(9);
            this.m_aY = 1792;
            this.m_vX = n;
            if (CHero.s_actionActor == this) {
                m_hero.setAction(119);
                CHero.s_actionActor = null;
            }
            return true;
        }
        return false;
    }

    boolean checkSteelBallKilled() {
        this.getCollisionBox();
        for (int i = 0; i < s_activeActorsCount; ++i) {
            CActor cActor = s_activeActors[i];
            if (cActor.m_classID != 32 || cActor.m_actionID != 5 || this.testFlag(2)) continue;
            cActor.getActiveBox();
            if (!CActor.isCollide(this.m_collisionBox, cActor.m_activeZoneBox)) continue;
            CGame.PlaySound(4);
            if (CHero.s_actionActor == this) {
                m_hero.setAction(0);
                CHero.s_actionActor = null;
            }
            this.setAction(10);
            CHero.s_blockActor = null;
            return true;
        }
        return false;
    }

    int getSteelBallAttackToEnemy(CActor cActor) {
        this.getAttackBox();
        cActor.getCollisionBox();
        if (CActor.isCollide(cActor.m_collisionBox, this.m_attackBox)) {
            if (cActor.m_classID == 26) {
                if (this.testFlag(2048)) {
                    this.setFlag(2048, false);
                    return 70;
                }
                if (Math.abs(this.m_vX) < 3072) {
                    return 0;
                }
                return 70;
            }
            CHero.m_cameraShakingTimer = 5;
            CHero.m_cameraYShakingExtent = 3;
            return 70;
        }
        return 0;
    }

    void updateFrisianWeaponAI() {
        this.UpdateSpriteAnim(true);
        this.detectEnviroment();
        this.updatePosition();
        switch (this.m_actionID) {
            case 35: {
                boolean bl = false;
                if (m_hero.canBeAttackedBy(this)) {
                    m_hero.setAttacked(this.getAttackPoint(), this.m_mapX < CActor.m_hero.m_mapX);
                    bl = true;
                }
                short[] sArray = new short[4];
                System.arraycopy(CGame.m_cameraBox, 0, sArray, 0, 4);
                sArray[0] = (short)(sArray[0] - 240 < 0 ? 0 : sArray[0] - 240);
                sArray[2] = (short)(sArray[2] + 240 > CGame.m_mapWidthByPixel[2] ? CGame.m_mapWidthByPixel[2] : sArray[2] + 240);
                if (!this.m_canRun || !CActor.isCollide(sArray, this.m_collisionBox) || CActor.isCollide(CActor.m_hero.m_attackBox, this.m_collisionBox)) {
                    bl = true;
                }
                if (s_steelBall != null) {
                    s_steelBall.getCollisionBox();
                    this.getCollisionBox();
                    if (CActor.isCollide(CActor.s_steelBall.m_collisionBox, this.m_collisionBox)) {
                        bl = true;
                    }
                }
                if (!bl) break;
                this.invalidateActor();
                break;
            }
            case 16: {
                if (m_hero.canBeAttackedBy(this)) {
                    m_hero.setAttacked(this.getAttackPoint(), this.m_mapX < CActor.m_hero.m_mapX);
                    this.setFlag(128, true);
                    this.setAction(17);
                }
                short[] sArray = new short[4];
                System.arraycopy(CGame.m_cameraBox, 0, sArray, 0, 4);
                sArray[0] = (short)(sArray[0] - 240 < 0 ? 0 : sArray[0] - 240);
                sArray[2] = (short)(sArray[2] + 240 > CGame.m_mapWidthByPixel[2] ? CGame.m_mapWidthByPixel[2] : sArray[2] + 240);
                if (CActor.isCollide(sArray, this.m_collisionBox)) {
                    if (!this.m_canRun || CActor.isCollide(CActor.m_hero.m_attackBox, this.m_collisionBox)) {
                        this.setAction(17);
                    }
                } else {
                    this.m_actorStatus = 4;
                    this.setFlag(64, false);
                    break;
                }
                if (s_steelBall == null) break;
                s_steelBall.getCollisionBox();
                this.getCollisionBox();
                if (!CActor.isCollide(CActor.s_steelBall.m_collisionBox, this.m_collisionBox)) break;
                this.setAction(17);
                break;
            }
            case 17: {
                if (!this.testFlag(16)) break;
                this.m_actorStatus = 4;
                this.setFlag(64, false);
            }
        }
    }

    void initWoodPlatform(boolean bl) {
        if (bl) {
            this.setMapPosition(this.m_Parameters[2], this.m_Parameters[3]);
            this.m_actionID = this.m_Parameters[4];
        }
        this.m_state = 0;
        this.m_weaponID = 0;
        this.m_waitTime = 15;
        if (this.m_actionID == 0) {
            --this.m_z;
        }
    }

    void updateWoodPlatformAI() {
        this.UpdateSpriteAnim(true);
        if (this.m_actionID != 0) {
            return;
        }
        --this.m_waitTime;
        switch (this.m_state) {
            case 0: {
                if (this.m_waitTime >= 0) break;
                this.m_state = 1;
                this.m_vY = (this.m_weaponID & 1) == 0 ? this.m_Parameters[0] << 8 : -this.m_Parameters[0] << 8;
                this.m_waitTime = Math.abs(this.m_Parameters[1] / this.m_Parameters[0]);
                ++this.m_weaponID;
                break;
            }
            case 1: {
                if (this.m_waitTime >= 0) break;
                this.m_state = 0;
                this.m_vY = 0;
                this.m_waitTime = 15;
                CHero.m_cameraShakingTimer = 5;
                CHero.m_cameraYShakingExtent = 4;
                this.clone(21, this.m_mapX, this.m_mapY + 100, 6);
            }
        }
        this.updateWoodPlatformPosition();
    }

    void updateWoodPlatformPosition() {
        this.setRealPosition(this.m_realX + this.m_vX, this.m_realY + this.m_vY);
        this.getCollisionBox();
        this.getAttackBox();
        if (CHero.s_platformActor == this) {
            int n = this.m_collisionBox[1] - CActor.m_hero.m_collisionBox[3] + CActor.m_hero.m_mapY << 8;
            m_hero.setRealPosition(CActor.m_hero.m_realX + this.m_vX, n);
        }
    }

    void updateWaterFall() {
        this.UpdateSpriteAnim(true);
        if (this.m_actionID == 5 && this.testFlag(16)) {
            this.m_actorStatus = 4;
        }
    }

    void updateBonePile() {
        if (this.m_actionID == 0) {
            this.UpdateSpriteAnim(true);
            this.getCollisionBox();
            if (m_hero.getAttackHurtToActor(this) > 0) {
                this.setAction(1);
            }
        } else if (this.m_actionID == 1) {
            this.UpdateSpriteAnim(false);
            if (this.m_currAFrame == 1) {
                short s = this.m_Parameters[0];
                short s2 = this.m_Parameters[1];
                short s3 = s;
                if (CGame.Random(0, 1) == 0) {
                    s3 = s2;
                }
                if (s3 != -1) {
                    CActor cActor = s_actors[s3];
                    if (cActor.m_classID == 20 && cActor.m_actionID == 6) {
                        int n = Math.abs(this.m_mapX - cActor.m_mapX);
                        n %= 10;
                        for (int i = 0; i < n; ++i) {
                            this.jumpOutCrystal(i, 0, 0);
                        }
                    } else {
                        cActor.m_mapX = this.m_mapX;
                        cActor.m_mapY = this.m_mapY;
                        cActor.TriggerActor();
                    }
                }
            } else if (this.testFlag(16)) {
                this.m_actorStatus = 4;
            }
        }
    }

    void updatePoison() {
        this.UpdateSpriteAnim(false);
        this.getAttackBox();
        if (m_hero.canBeAttackedBy(this)) {
            m_hero.setAttacked(5, false);
        }
        if (this.testFlag(16)) {
            this.m_actorStatus = 4;
        }
    }

    void triggerPoison() {
        this.setFlag(2, false);
        this.m_actorStatus = 2;
        this.setFlag(4096, false);
    }

    void activeEventZone() {
        this.m_waitTime = 0;
    }

    void updateEventZone() {
        this.getActiveBox();
        if (CActor.isContaining(this.m_activeZoneBox, CActor.m_hero.m_mapX, CActor.m_hero.m_mapY)) {
            int n;
            int n2 = n = this.m_Parameters[0] == 0 ? this.m_Parameters[1] : this.m_Parameters[2];
            if (this.m_waitTime == 0 && (this.m_Parameters[0] == 0 || CActor.m_hero.m_vX != 0 || CActor.m_hero.m_vY != 0)) {
                if (this.m_actionID == 8) {
                    CActor cActor = this.clone(47, CActor.m_hero.m_mapX, CActor.m_hero.m_mapY, 5);
                    cActor.m_z = CActor.m_hero.m_z - 1;
                } else if (this.m_actionID == 9) {
                    CActor cActor = null;
                    cActor = CActor.m_hero.m_actionID >= 23 && CActor.m_hero.m_actionID <= 25 ? this.clone(21, CActor.m_hero.m_mapX, CActor.m_hero.m_mapY, 9) : this.clone(21, CActor.m_hero.m_mapX, CActor.m_hero.m_mapY, 8);
                    if (cActor != null) {
                        cActor.setFlag(1, m_hero.testFlag(1));
                    }
                }
                this.m_waitTime = n;
            }
        }
        if (this.m_waitTime > 0) {
            --this.m_waitTime;
        }
    }

    void updateLightBall() {
        this.UpdateSpriteAnim(true);
        if (this.m_waitTime++ > 100) {
            this.m_waitTime = 0;
            this.m_actorStatus = 4;
            this.setFlag(64, false);
            return;
        }
        this.updatePosition();
        this.getCollisionBox();
        if (this.removeIfOutofMap()) {
            return;
        }
        if (this.m_actionID == 8) {
            m_hero.getAttackBox();
            if (CActor.isCollide(this.m_collisionBox, CActor.m_hero.m_attackBox) && !this.testFlag(2048)) {
                this.m_vX = -this.m_vX;
                this.m_vY = -this.m_vY;
                this.setFlag(2048, true);
                return;
            }
            if (this.m_canStand) {
                CHero.m_cameraShakingTimer = 5;
                CHero.m_cameraYShakingExtent = 8;
                this.setAction(9);
            }
        } else if (this.m_actionID == 9 && this.testFlag(16)) {
            this.m_actorStatus = 4;
            this.setFlag(64, false);
        }
        if (m_hero.isTriggeredByHero(this.m_collisionBox, true) && CHero.s_tickInvincible <= 0) {
            m_hero.setAttacked(3, this.isFaceTo(m_hero));
            this.clone(21, CActor.m_hero.m_mapX, CActor.m_hero.m_mapY, 10);
        }
        if (this.m_state >= 0) {
            CActor cActor = s_actors[this.m_state];
            cActor.getCollisionBox();
            if (cActor.m_actionID != 5 && this.testFlag(2048) && CActor.isCollide(this.m_collisionBox, cActor.m_collisionBox)) {
                cActor.setAction(5);
            }
        }
    }

    void updateBomb() {
        this.UpdateSpriteAnim(true);
        if (this.m_waitTime++ > 100) {
            this.m_waitTime = 0;
            this.m_actorStatus = 4;
            this.setFlag(64, false);
            return;
        }
        this.updatePosition();
        this.getCollisionBox();
        if (this.m_actionID == 0) {
            if (this.m_canStand || !this.m_canRun || CGame.canStandOnSlope(this)) {
                this.setAction(1);
            }
        } else if (this.m_actionID == 1) {
            this.getAttackBox();
            if (m_hero.canBeAttackedBy(this)) {
                m_hero.setAttacked(10, !this.testFlag(1));
            }
            if (this.testFlag(16)) {
                this.m_actorStatus = 4;
                this.setFlag(64, false);
            }
        }
    }

    void updateDragonFireBall() {
        this.UpdateSpriteAnim(true);
        if (this.m_waitTime++ > 50) {
            this.m_waitTime = 0;
            this.m_actorStatus = 4;
            this.setFlag(64, false);
            return;
        }
        this.updatePosition();
        this.getCollisionBox();
        if (this.removeIfOutofMap()) {
            return;
        }
        if (this.m_actionID == 3) {
            if (this.m_canStand) {
                CHero.m_cameraShakingTimer = 5;
                CHero.m_cameraYShakingExtent = 8;
                this.setAction(4);
                this.m_z = CActor.m_hero.m_z - 1;
            }
        } else if (this.m_actionID == 2) {
            if (this.testFlag(16)) {
                this.setFlag(128, true);
                this.setAction(3);
            }
        } else if (this.m_actionID == 4 && this.testFlag(16)) {
            this.m_actorStatus = 4;
            this.setFlag(64, false);
        }
        this.getAttackBox();
        if (m_hero.isTriggeredByHero(this.m_attackBox, true) && CHero.s_tickInvincible <= 0 && CActor.m_hero.m_hp > 0) {
            m_hero.setAttacked(5, this.isFaceTo(m_hero));
        }
    }

    void initSwitch() {
        this.m_actionID = 0;
    }

    void updateSwitchAI() {
        this.UpdateSpriteAnim(true);
        CActor cActor = s_actors[this.m_Parameters[0]];
        --this.m_waitTime;
        this.getCollisionBox();
        if (m_hero.testFlag(65536) && CActor.isCollide(CActor.m_hero.m_attackBox, this.m_collisionBox)) {
            boolean bl = m_hero.testFlag(1);
            this.clone(21, this.m_mapX, this.m_mapY, bl ? 1 : 0, 12);
            CHero.m_cameraShakingTimer = 5;
            CHero.m_cameraYShakingExtent = 4;
            cActor.m_state = 1;
            cActor.m_vY = -768;
            cActor.m_waitTime = 3;
            cActor.m_weaponID = 0;
            if (this.m_actionID == 0) {
                this.setAction(2);
            }
            this.m_waitTime = 3;
        }
        if (this.m_actionID == 2 && this.m_waitTime < 0) {
            this.setAction(0);
        }
    }

    void initChainBall(boolean bl) {
        if (bl) {
            this.setMapPosition(this.m_Parameters[3], this.m_Parameters[4]);
            this.m_actionID = this.m_Parameters[5];
            if (this.m_actionID == 14) {
                this.m_state = 0;
                this.m_weaponID = 0;
                this.m_weaponType = this.m_mapY;
            } else if (this.m_actionID == 15) {
                this.m_state = 2;
            }
        }
    }

    void updateChainBallAI() {
        this.UpdateSpriteAnim(true);
        --this.m_waitTime;
        this.getCollisionBox();
        switch (this.m_state) {
            case 0: {
                break;
            }
            case 1: {
                short s = this.m_Parameters[2];
                if (this.m_weaponID == 0) {
                    if (this.m_mapY <= this.m_weaponType - s) {
                        this.m_vY = 0;
                        this.setMapPosition(this.m_mapX, this.m_weaponType - s);
                        this.m_weaponID = 2;
                        this.m_waitTime = 25;
                    }
                    if (this.m_waitTime >= 0) break;
                    this.m_vY = 0;
                    this.m_weaponID = 2;
                    this.m_waitTime = 25;
                    break;
                }
                if (this.m_weaponID == 2) {
                    if (this.m_waitTime >= 0) break;
                    this.m_weaponID = 1;
                    this.m_vY = 256;
                    break;
                }
                if (this.m_weaponID != 1 || this.m_mapY < this.m_weaponType) break;
                this.m_vY = 0;
                this.setMapPosition(this.m_mapX, this.m_weaponType);
                this.m_weaponID = 0;
                this.m_state = 0;
                break;
            }
            case 2: {
                if (this.m_Parameters[1] != 0 && !this.testFlag(4096)) break;
                this.m_state = 3;
                CActor cActor = s_actors[this.m_Parameters[0]];
                int n = this.m_mapX - cActor.m_mapX;
                int n2 = this.m_mapY - cActor.m_mapY;
                this.m_weaponID = CGame.ArcTan(n, n2) << 8;
                this.m_attackPoint = Math.abs((this.m_weaponID >> 8) - 64);
                this.m_weaponType = 0;
                this.m_hp = CGame.getDistance(n, n2);
                break;
            }
            case 3: {
                int n;
                CActor cActor = s_actors[this.m_Parameters[0]];
                this.m_weaponType += this.m_mapX > cActor.m_mapX ? 85 : -85;
                if (Math.abs(this.m_weaponType) <= 85) {
                    n = this.m_mapX - cActor.m_mapX;
                    int n3 = this.m_mapY - cActor.m_mapY;
                    this.m_attackPoint = Math.abs(CGame.ArcTan(n, n3) - 64);
                }
                if (this == CHero.s_platformActor || CActor.m_hero.m_actionID == 16 || CActor.m_hero.m_actionID == 19 || CActor.m_hero.m_actionID == 18 || CActor.m_hero.m_actionID == 17 || !m_hero.testFlag(65536) || !CActor.isCollide(CActor.m_hero.m_attackBox, this.m_collisionBox)) break;
                n = m_hero.testFlag(1) ? 1 : 0;
                this.clone(21, this.m_mapX, this.m_mapY - 34, n != 0 ? 1 : 0, 12);
                CHero.m_cameraShakingTimer = 5;
                CHero.m_cameraYShakingExtent = 4;
                if (m_hero.testFlag(1) ^ this.m_weaponType > 0) {
                    this.m_weaponType += this.m_weaponType > 0 ? -85 : 85;
                    break;
                }
                if (this.m_attackPoint > 28) break;
                this.m_weaponType += this.m_weaponType > 0 ? 85 : -85;
            }
        }
        this.updateChainBallPosition();
    }

    void updateChainBallPosition() {
        int n = this.m_mapX;
        int n2 = this.m_mapY;
        if (this.m_state == 1) {
            this.setRealPosition(this.m_realX + this.m_vX, this.m_realY + this.m_vY);
        } else if (this.m_state == 3) {
            CActor cActor = s_actors[this.m_Parameters[0]];
            this.m_weaponID += this.m_weaponType;
            this.setMapPosition(cActor.m_mapX + CGame.LenCos(this.m_hp, this.m_weaponID >> 8), cActor.m_mapY + CGame.LenSin(this.m_hp, this.m_weaponID >> 8));
        }
        this.getCollisionBox();
        this.getAttackBox();
        if (CHero.s_platformActor == this && CActor.isContaining(this.m_attackBox, CActor.m_hero.m_mapX + this.m_mapX - n, CActor.m_hero.m_collisionBox[3] + this.m_mapY - n2)) {
            int n3 = 0;
            if (this.m_state == 3) {
                n3 += this.m_mapX - n << 8;
            }
            int n4 = this.m_collisionBox[1] - CActor.m_hero.m_collisionBox[3] + CActor.m_hero.m_mapY << 8;
            m_hero.setRealPosition(CActor.m_hero.m_realX + n3, n4);
        }
    }

    void triggerChainBall() {
        this.setFlag(4096, true);
    }

    void drawChain(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = (n3 -= CGame.m_cameraLeft) - (n -= CGame.m_cameraLeft);
        int n9 = (n4 -= CGame.m_cameraTop) - (n2 -= CGame.m_cameraTop);
        int n10 = CGame.ArcTan(n8, n9);
        if (n8 == 0 && n9 == 0) {
            return;
        }
        int n11 = CGame.LenCos(n7 << 8, n10);
        int n12 = CGame.LenSin(n7 << 8, n10);
        int n13 = Math.abs(n8) > Math.abs(n9) ? (n8 << 8) / n11 : (n9 << 8) / n12;
        int n14 = n << 8;
        int n15 = n2 << 8;
        ASprite aSprite = CGame.m_sprites[n5];
        for (int i = n13; i >= 0; --i) {
            aSprite.PaintAFrame(graphics, n6, 0, n14 >> 8, n15 >> 8, 0, 0, 0);
            n14 += n11;
            n15 += n12;
        }
    }

    void updateMangonel() {
        this.UpdateSpriteAnim(true);
        switch (this.m_actionID) {
            case 0: {
                if (s_steelBall == null) break;
                this.getCollisionBox();
                s_steelBall.getCollisionBox();
                if (!CActor.isCollide(this.m_collisionBox, CActor.s_steelBall.m_collisionBox)) break;
                this.setAction(1);
                s_steelBall.setAction(18);
                if (CHero.s_actionActor != s_steelBall) break;
                CHero.s_actionActor = null;
                m_hero.setAction(0);
                break;
            }
            case 1: {
                if (!CActor.m_hero.m_pressAttack || !CActor.m_hero.m_canStand || Math.abs(CActor.m_hero.m_mapX - this.m_mapX) > 20) break;
                this.setAction(2);
                s_steelBall.setAction(19);
                m_hero.setAction(146);
                break;
            }
            case 2: {
                if (!this.testFlag(16)) break;
                this.setAction(0);
            }
        }
    }

    static {
        ACTORS_BASE_INFO_CAPACITY = 8;
        s_phyEnvInfo = new byte[9];
        s_colBoxTmp = new short[4];
    }
}

