/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class CEnemy
extends CActor {
    boolean m_canAttack;
    boolean m_canDetect;
    boolean m_canChasing;
    boolean m_canGo;
    boolean m_canBackOff;
    boolean m_isThrownFront;
    boolean m_isThownToLeft;
    boolean m_canBackUp;
    int m_offset;
    int m_chasingRange;
    int m_attackRange;
    int m_backOffRange;
    int m_waitCount;
    int m_attackIdleCount;
    int m_destPosX;
    int m_destPosY;
    boolean m_isLeftToHero;
    int m_distanceToHero;
    static int s_werewolfAttackTimer;
    int m_throwCount;
    static int s_grendel_aim_point;
    static final int GRENDEL_ATTACK_MODE_NORMAL = 1;
    static final int GRENDEL_ATTACK_MODE_THROW = 2;
    static final int DRAGON_BOSS_STATE_HEAD_FLY_SHOOT = 0;
    static final int DRAGON_BOSS_STATE_HEAD_BIG_SHOOT = 1;
    static final int DRAGON_BOSS_STATE_HEAD_RIDE_ATTACKED = 2;
    static final int DRAGON_BOSS_STATE_FLY_SHOOT = 3;
    static final int DRAGON_BOSS_STATE_DIE = 4;
    static final int DRAGON_BOSS_STATE_DIED = 5;

    void init(boolean bl) {
        super.init(bl);
        this.setFlag(512, true);
        switch (this.m_classID) {
            case 2: {
                this.initWerewolf();
                break;
            }
            case 3: {
                this.initEagle();
                break;
            }
            case 19: {
                this.initSkeleton();
                break;
            }
            case 29: {
                this.initGrendel();
                break;
            }
            case 35: {
                this.setFlag(512, false);
                this.initSerpentBody(bl);
                break;
            }
            case 34: {
                this.initSerpent();
                break;
            }
            case 44: {
                this.initFrisianAI(bl);
                break;
            }
            case 51: {
                this.initMother();
                break;
            }
            case 56: {
                this.initGoldDragon();
            }
        }
    }

    void renascence(int n, int n2) {
        super.renascence(n, n2);
        switch (this.m_classID) {
            case 2: {
                this.m_hp = this.m_Parameters[0];
                this.m_actionID = 0;
                break;
            }
            case 3: {
                this.m_hp = this.m_Parameters[0];
                this.m_waitTime = CGame.Random(15, 20);
                this.m_actionID = 2;
                break;
            }
            case 19: {
                this.m_hp = this.m_Parameters[0];
                this.m_actionID = 0;
                break;
            }
            case 44: {
                this.m_hp = this.m_Parameters[0];
                int n3 = CGame.Random(0, 99);
                this.m_Parameters[1] = n3 < 33 ? 0 : (n3 < 66 ? 2 : 1);
                this.setFrisianWait(this.m_Parameters[1]);
            }
        }
        this.setFlag(4096, false);
        this.m_actorStatus = 2;
        this.setAction(this.m_actionID, this.m_actionID);
        this.setFlag(2, false);
        this.setMapPosition(n, n2);
    }

    void update() {
        this.UpdateSpriteAnim(true);
        if (this.testFlag(1024)) {
            return;
        }
        this.detectEnviroment();
        switch (this.m_classID) {
            case 2: {
                if (this.isWerewolfBackClimb()) {
                    this.updateWerewolfBackClimb();
                    break;
                }
                this.updateWerewolfAI();
                break;
            }
            case 3: {
                this.updateEagleAI();
                break;
            }
            case 19: {
                this.updateSkeletonAI();
                break;
            }
            case 29: {
                this.updateGrendelAI();
                break;
            }
            case 35: {
                this.updateSerpentBodyAI();
                break;
            }
            case 34: {
                this.updateSerpentAI();
                break;
            }
            case 44: {
                this.updateFrisianAI();
                break;
            }
            case 51: {
                this.updateMother();
                break;
            }
            case 56: {
                this.updateGoldDragon();
            }
        }
        this.updatePosition();
    }

    void updatePosition() {
        boolean bl = false;
        switch (this.m_classID) {
            case 2: {
                if (this.m_actionID == 20 || this.m_actionID == 21 || this.m_actionID == 23 || this.m_actionID == 22 || this.m_actionID == 27 || this.m_actionID == 24 || this.isWerewolfBackClimb()) {
                    super.updatePosition();
                    break;
                }
                this.updateWerewolfPosition();
                bl = true;
                break;
            }
            case 3: {
                this.updateEaglePosition();
                break;
            }
            case 19: {
                if (this.m_actionID == 11 || this.m_actionID == 12 || this.m_actionID == 13 || this.m_actionID == 14 || this.m_actionID == 18 || this.m_actionID == 15) {
                    super.updatePosition();
                    break;
                }
                this.updateSkeletonPosition();
                bl = true;
                break;
            }
            case 35: {
                this.updateSerpentBodyPosition();
                break;
            }
            case 44: {
                this.updateFrisianPosition();
                bl = true;
            }
        }
        if (bl) {
            if (!CGame.IsTileCanGoThrough(CActor.s_phyEnvInfo[6]) && (this.testFlag(1) && this.m_vX < 0 || !this.testFlag(1) && this.m_vX > 0)) {
                this.m_vX = 0;
            }
            super.updatePosition();
        }
    }

    void limitPosition() {
        int n = this.m_mapX;
        int n2 = CGame.m_cameraRightLimit + 240;
        int n3 = CGame.m_cameraLeftLimit;
        if (this.m_collisionBox[2] >= n2) {
            n = n2 - (this.m_collisionBox[2] - this.m_mapX);
            this.m_vX = 0;
        }
        if (this.m_collisionBox[0] <= n3) {
            n = this.m_mapX - this.m_collisionBox[0] + n3;
            this.m_vX = 0;
        }
        this.setMapPosition(n, this.m_mapY);
    }

    void setThrow(boolean bl) {
        switch (this.m_classID) {
            case 2: {
                this.setThrowWereWolf(bl);
            }
        }
    }

    boolean canBeViolentlyKillWithType(int n) {
        boolean bl = false;
        switch (n) {
            case 0: {
                bl = true;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                bl = this.m_classID == 2 || this.m_classID == 44 || this.m_classID == 19;
                break;
            }
            case 5: {
                bl = this.m_classID == 44;
                break;
            }
            default: {
                CDebug._assert(false);
            }
        }
        return bl;
    }

    boolean isEnemy() {
        switch (this.m_classID) {
            case 19: {
                if (this.m_actionID == 8 || this.m_actionID == 7) {
                    return false;
                }
                return super.isEnemy();
            }
        }
        return super.isEnemy();
    }

    void setHurt(int n) {
        this.m_hp -= n;
        if (n > 0) {
            if (CActor.m_hero.m_actionID != 30) {
                CActor.m_hero.m_RagePoint += CActor.m_hero.m_RageSpeedAttack;
                if (CActor.m_hero.m_RagePoint > CActor.m_hero.m_maxRage) {
                    CActor.m_hero.m_RagePoint = CActor.m_hero.m_maxRage;
                }
            }
            if (CActor.m_hero.m_comboHitsAttackStart) {
                CActor.m_hero.m_comboHitsAttackStart = false;
                CActor.m_hero.m_comboHitsAttackHit = true;
                CActor.m_hero.m_comboHitsTimer = 0;
                CActor.m_hero.m_isComboHits = true;
            }
            if (CActor.m_hero.m_isComboHits) {
                ++CActor.m_hero.m_comboHitsCount;
            }
        }
        if (CActor.m_hero.isAttackUsingSword()) {
            CActor cActor;
            int n2;
            boolean bl = this.testFlag(1);
            if (this.m_classID == 35) {
                int n3 = CActor.m_hero.testFlag(1) ? CActor.m_hero.m_collisionBox[0] - 30 : CActor.m_hero.m_collisionBox[2] + 30;
                bl = CActor.m_hero.testFlag(1);
                n2 = n3;
            } else {
                int n4 = bl ? -14 : 14;
                n2 = this.m_mapX + n4;
            }
            int n5 = this.m_mapY + -25;
            int n6 = CGame.Random(0, 2);
            int n7 = 0;
            int n8 = 0;
            if (this.m_classID == 34) {
                n7 = -30;
                n8 = -20;
            }
            if ((cActor = this.clone(21, n2 + n7, n5 + n8, n6)) != null) {
                if (!CGame.s_bloodEffect) {
                    cActor.m_actionID += 3;
                }
                int n9 = cActor.m_Palette = this.m_classID == 19 ? 1 : 0;
                if (bl) {
                    cActor.setFlag(1, true);
                }
            }
        }
        if (!CActor.m_hero.isSmashing() && (this.m_classID == 2 || this.m_classID == 34 || this.m_classID == 35 || this.m_classID == 29 || this.m_classID == 56 || this.m_classID == 19 || this.m_classID == 44) && (this.m_hp > 0 || this.m_classID == 2 && this.m_actionID == 21 || this.m_classID == 19 && this.m_actionID == 12 || this.m_classID == 44 && this.m_actionID == 7)) {
            CGame.PlaySound(0);
        }
    }

    void displayAccessory(Graphics graphics, int n, int n2) {
        int n3 = 1;
        int n4 = this.m_mapX - n;
        int n5 = this.m_collisionBox[1] - n2;
        int n6 = 0;
        switch (this.m_classID) {
            case 2: {
                n5 = this.m_mapY - n2 + -65;
                n3 = this.m_hp * 100 / this.m_Parameters[0];
                n4 -= 14;
                n5 -= 7;
                n6 = 65316;
                if (this.m_actionID != 7 && this.m_actionID != 20 && this.m_actionID != 21 && this.m_actionID != 26 && this.m_actionID != 27 && this.m_actionID != 23 && this.m_actionID != 22 && this.m_actionID != 14) break;
                return;
            }
            case 3: {
                n5 = this.m_mapY - n2 + -30;
                n3 = this.m_hp * 100 / this.m_Parameters[0];
                n4 -= 14;
                n5 -= 7;
                n6 = 65316;
                break;
            }
            case 19: {
                if (this.m_Parameters[0] == 0) {
                    return;
                }
                n5 = this.m_mapY - n2 + -65;
                n3 = this.m_hp * 100 / this.m_Parameters[0];
                n4 -= 14;
                n5 -= 7;
                n6 = 65316;
                if (this.m_actionID != 8 && this.m_actionID != 6 && this.m_actionID != 7 && this.m_actionID != 11 && this.m_actionID != 12 && this.m_actionID != 17 && this.m_actionID != 18 && this.m_actionID != 13 && this.m_actionID != 14) break;
                return;
            }
            case 29: {
                return;
            }
            case 34: {
                this.drawSerpentResistBar(graphics, n, n2);
                return;
            }
            case 51: {
                return;
            }
            case 56: {
                return;
            }
            case 44: {
                if (this.m_actionID == 6 || this.m_actionID == 7 || this.m_actionID == 9 || this.m_actionID == 8 && this.m_currAFrame < 4 || this.m_actionID == 13 || this.m_actionID == 14 || this.m_actionID == 15) {
                    n4 += this.testFlag(1) ? -40 : 40;
                }
                n5 = this.m_mapY - n2 + -66;
                n3 = this.m_hp * 100 / this.m_Parameters[0];
                n4 -= 14;
                n5 -= 7;
                n6 = 65316;
                if (this.m_Parameters[1] != 3 && this.m_actionID != 18) break;
                return;
            }
            default: {
                CDebug._assert(false);
            }
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 == 0) {
            return;
        }
        this.drawHPBar(graphics, n4, n5, n3, n6);
    }

    void checkAvailableAction() {
        int n;
        short s;
        int n2;
        int n3;
        boolean bl;
        boolean bl2 = bl = this.m_collisionBox[1] <= CActor.m_hero.m_collisionBox[3] && this.m_collisionBox[3] >= CActor.m_hero.m_collisionBox[1];
        if (this.m_classID == 19) {
            n3 = Math.abs(CActor.m_hero.m_mapY - this.m_mapY);
            if (n3 <= 144) {
                this.m_canAttack = this.m_distanceToHero <= this.m_attackRange;
                this.m_canDetect = CActor.m_hero.isTriggeredByHero(this.m_activeZoneBox, false);
                if (!this.m_canDetect && CActor.m_hero.m_nextVillagerID != -1) {
                    this.m_canDetect = CActor.m_hero.isTriggeredByHero(this.m_activeZoneBox, true);
                }
            } else {
                this.m_canAttack = false;
                this.m_canDetect = false;
            }
        } else {
            this.m_canAttack = this.m_distanceToHero <= this.m_attackRange && bl;
            this.m_canDetect = CActor.m_hero.isTriggeredByHero(this.m_activeZoneBox, false) && bl;
        }
        this.m_canChasing = this.m_distanceToHero >= this.m_chasingRange;
        boolean bl3 = this.m_canBackOff = this.m_distanceToHero <= this.m_backOffRange;
        if (this.m_canBackOff && this.m_classID == 19) {
            n3 = CGame.m_cameraRightLimit + 240;
            n2 = CGame.m_cameraLeftLimit;
            if (this.m_collisionBox[2] >= n3 || this.m_collisionBox[0] <= n2) {
                this.m_canBackOff = false;
            }
        }
        n3 = this.m_collisionBox[3] + 1;
        if (this.testFlag(1)) {
            n2 = this.m_collisionBox[2];
            s = this.m_collisionBox[0];
            n = 24;
        } else {
            n2 = this.m_collisionBox[0];
            s = this.m_collisionBox[2];
            n = -24;
        }
        byte by = CGame.GetPhyInfo(n2, n3);
        byte by2 = CGame.GetPhyInfo(n2 += n, n3);
        byte by3 = CGame.GetPhyInfo(n2 += n, n3);
        byte by4 = CGame.GetPhyInfo(s, n3);
        this.m_canGo = this.m_isOnslope || CGame.isInSlopeArea(this, n2 - n * 2, n3) || CGame.IsTileCanStand(by) && (CGame.IsTileCanStand(by2) || CGame.isInSlopeArea(this, n2 - n, n3)) && (CGame.IsTileCanStand(by3) || CGame.isInSlopeArea(this, n2, n3));
        this.m_canBackUp = CGame.IsTileCanStand(by4) && CGame.IsTileCanGoThrough(CActor.s_phyEnvInfo[6]);
    }

    void calcHorizontalPositionToHero() {
        int n = this.m_realX - CActor.m_hero.getHeroOrProtegePositionX(this.m_offset);
        short s = 0;
        short s2 = 0;
        this.m_isLeftToHero = false;
        short[] sArray = CActor.m_hero.getHeroOrProtegeBox(this.m_offset);
        if (n > 0) {
            s = this.m_collisionBox[0];
            s2 = sArray[2];
            this.m_distanceToHero = s - s2;
        } else if (n < 0) {
            s = this.m_collisionBox[2];
            s2 = sArray[0];
            this.m_isLeftToHero = true;
            this.m_distanceToHero = s2 - s;
        } else {
            this.m_distanceToHero = 0;
        }
    }

    void calcVerticalPositionToHero() {
        this.m_isLeftToHero = this.m_realX - CActor.m_hero.getHeroOrProtegePositionX(this.m_offset) > 0;
        short[] sArray = CActor.m_hero.getHeroOrProtegeBox(this.m_offset);
        this.m_distanceToHero = this.m_collisionBox[3] - sArray[1];
    }

    private int getNextWerewolfAttackIdleCount() {
        int n = CGame.m_frameCounter;
        int n2 = CGame.Random(3, 12);
        int n3 = n2 + n;
        if (CActor.getEnemyCount(2) == 1) {
            return n2;
        }
        if (n3 - s_werewolfAttackTimer < 12) {
            n3 = s_werewolfAttackTimer + n2 + CGame.Random(10, 30);
            n2 = n3 - s_werewolfAttackTimer;
        }
        s_werewolfAttackTimer = n3;
        return n2;
    }

    void setViolentlyBeKilled(int n) {
        this.getCollisionBox();
        int n2 = 0;
        switch (this.m_classID) {
            case 2: {
                if (n == 6) {
                    n2 = 20;
                    break;
                }
                if (n == 3) {
                    n2 = 26;
                    this.setHurt(CActor.m_hero.m_attackPoint);
                    break;
                }
                if (n == 4) {
                    n2 = 27;
                    break;
                }
                if (n == 2) {
                    n2 = 22;
                    break;
                }
                if (n != 1) break;
                n2 = 23;
                break;
            }
            case 19: {
                if (n == 6) {
                    n2 = 11;
                    break;
                }
                if (n == 3) {
                    n2 = 17;
                    this.setHurt(CActor.m_hero.m_attackPoint);
                    break;
                }
                if (n == 4) {
                    n2 = 18;
                    break;
                }
                if (n == 2) {
                    n2 = 14;
                    break;
                }
                if (n != 1) break;
                n2 = 13;
                break;
            }
            case 44: {
                if (n == 6) {
                    n2 = 6;
                    break;
                }
                if (n == 3) {
                    n2 = 13;
                    this.setHurt(CActor.m_hero.m_attackPoint);
                    break;
                }
                if (n == 4) {
                    n2 = 15;
                    break;
                }
                if (n == 5) {
                    n2 = 14;
                    break;
                }
                if (n == 2) {
                    n2 = 8;
                    break;
                }
                if (n != 1) break;
                n2 = 9;
                break;
            }
            default: {
                CDebug._assert(false);
            }
        }
        if (n == 6) {
            CHero.s_actorToBeBeviolentlyKilled = this;
            CHero.s_actorToBeBeviolentlyKilled.setMapPosition(CActor.m_hero.m_mapX, CActor.m_hero.m_mapY);
        } else if (this.m_classID != 44 && CHero.s_actorToBeBeviolentlyKilled == this && (n == 5 || n == 2 || n == 1 || n == 4)) {
            CHero.s_actorToBeBeviolentlyKilled = null;
        }
        this.setAction(n2, n2);
    }

    int getAttackedHurt() {
        int n = 0;
        if (this.m_classID == 56 && this.m_Parameters[0] == 3 && this.m_state == 3) {
            return super.getAttackedHurt();
        }
        if (CActor.s_steelBall != null && CActor.s_steelBall.m_vX != 0) {
            n = CActor.s_steelBall.getSteelBallAttackToEnemy(this);
        }
        return (n += CActor.m_hero.getAttackHurtToActor(this)) + super.getAttackedHurt();
    }

    int getWeaponClassIDByType(int n) {
        if (n == 2) {
            return 55;
        }
        return 18;
    }

    void ThrowWeapon(int n, int n2, int n3, int n4) {
        int n5 = CActor.m_hero.getHeroOrProtegePositionX(this.m_offset) - this.m_realX;
        CActor cActor = this.clone(n2, 0, 0, 0);
        if (cActor != null) {
            cActor.prepareWeapon(n, this.m_mapX + n3, this.m_mapY + n4, n5, this.getAttackPoint(), 0, 0);
        }
    }

    boolean canSeeHero() {
        int n = this.m_mapX;
        int n2 = this.m_mapY;
        int n3 = CActor.m_hero.m_mapX;
        int n4 = CActor.m_hero.m_mapY;
        if (Math.abs(n4 - (n2 -= 46)) >= 215) {
            return false;
        }
        return CGame.getDistance(n - n3, 0) <= 228;
    }

    boolean canPullCamera() {
        return CGame.getDistance(this.m_mapX - CActor.m_hero.m_mapX, 0) <= 228;
    }

    void SetAsHeroCombatActor() {
        int n;
        int n2;
        CActor cActor = this.m_realX < CActor.m_hero.m_realX ? CHero.s_leftCombatActor : CHero.s_rightCombatActor;
        if (cActor != null && (n2 = CGame.getDistance(CActor.m_hero.m_realX - cActor.m_realX, CActor.m_hero.m_realY - cActor.m_realY)) <= (n = CGame.getDistance(CActor.m_hero.m_realX - this.m_realX, CActor.m_hero.m_realY - this.m_realY))) {
            return;
        }
        if (this.m_realX < CActor.m_hero.m_realX) {
            CHero.s_leftCombatActor = this;
        } else {
            CHero.s_rightCombatActor = this;
        }
    }

    void initEagle() {
        this.m_hp = this.m_Parameters[0];
        this.m_waitTime = CGame.Random(15, 20);
        this.m_offset = this.m_Parameters[1];
        this.m_destPosX = this.m_mapX;
        this.m_destPosY = this.m_mapY;
        this.m_attackPoint = 2;
    }

    void updateEagleAI() {
        this.getCollisionBox();
        this.calcVerticalPositionToHero();
        int n = this.getAttackedHurt();
        this.clearAttackedInfo();
        if (n > 0 && this.m_actionID != 5 && this.m_actionID != 6) {
            this.setHurt(n);
            if (this.IsAlive()) {
                this.setAction(5, 5);
            } else {
                this.setAction(6, 6);
            }
        }
        this.setFlag(1, !this.m_isLeftToHero);
        if (this.m_actionID == 2) {
            if (--this.m_waitTime < 0) {
                this.setAction(3, 3);
            } else {
                this.calcPatrolPosition(false);
            }
            if (this.isNeedRecalcPosition()) {
                this.calcPatrolPosition(true);
            }
        } else if (this.m_actionID == 0) {
            if (--this.m_waitTime < 0) {
                this.calcPatrolPosition(true);
                this.setAction(1, 1);
            }
        } else if (this.m_actionID == 1) {
            if (this.isReachTarget()) {
                if (this.m_prevActionID == 4) {
                    this.m_waitTime = CGame.Random(15, 25);
                    this.setAction(0, 0);
                } else if (this.m_prevActionID == 5) {
                    this.m_waitTime = CGame.Random(15, 20);
                    this.setAction(2, 2);
                } else if (this.m_prevActionID == 0) {
                    this.m_waitTime = CGame.Random(15, 20);
                    this.setAction(2, 2);
                }
            }
        } else if (this.m_actionID == 3) {
            if (this.testFlag(16)) {
                this.calcAttackPosition();
                this.setAction(4, 4);
            }
        } else if (this.m_actionID == 4) {
            if (CActor.m_hero.canBeAttackedBy(this)) {
                CActor.m_hero.setAttacked(this.getAttackPoint(), this.m_isLeftToHero);
            }
            if (this.isReachTarget()) {
                this.calcWaitPosition();
                this.setAction(1, 1);
            }
        } else if (this.m_actionID == 7) {
            if (CActor.m_hero.canBeAttackedBy(this)) {
                CActor.m_hero.setAttacked(this.getAttackPoint(), this.m_isLeftToHero);
            }
        } else if (this.m_actionID == 5) {
            if (this.testFlag(16)) {
                this.calcPatrolPosition(true);
                this.setAction(1, 1);
            }
        } else if (this.m_actionID == 6 && this.testFlag(16)) {
            this.setFlag(64, false);
            this.m_actorStatus = 4;
            this.setFlag(4096, true);
            CActor.m_hero.addScore(this);
        }
    }

    void updateEaglePosition() {
        int n;
        int n2;
        int n3 = this.m_destPosX - this.m_mapX;
        int n4 = this.m_destPosY - this.m_mapY;
        if (this.m_actionID == 4) {
            n2 = 14;
            n = 18;
        } else {
            n2 = 7;
            n = 7;
        }
        this.m_mapX = n3 > 0 ? (this.m_mapX += n3 > n2 ? n2 : n3) : (this.m_mapX -= -n3 > n2 ? n2 : -n3);
        this.m_mapY = n4 > 0 ? (this.m_mapY += n4 > n ? n : n4) : (this.m_mapY -= -n4 > n ? n : -n4);
        this.setMapPosition(this.m_mapX, this.m_mapY);
    }

    void calcPatrolPosition(boolean bl) {
        short[] sArray = CActor.m_hero.m_collisionBox;
        int n = (sArray[2] + sArray[0]) / 2;
        short s = sArray[1];
        boolean bl2 = CActor.m_hero.testFlag(1);
        if (bl) {
            this.m_destPosX = bl2 ? n - 60 : n + 60;
            this.m_destPosY = s + -60;
        }
    }

    void calcAttackPosition() {
        short[] sArray = CActor.m_hero.m_collisionBox;
        int n = (sArray[2] + sArray[0]) / 2;
        int n2 = sArray[1];
        this.m_destPosX = n;
        this.m_destPosY = n2;
    }

    void calcWaitPosition() {
        short[] sArray = CActor.m_hero.m_collisionBox;
        int n = (sArray[2] + sArray[0]) / 2;
        short s = sArray[1];
        this.m_destPosX = n + 40;
        this.m_destPosY = s + -30;
    }

    boolean isNeedRecalcPosition() {
        boolean bl = CActor.m_hero.testFlag(1);
        return bl && this.m_isLeftToHero || !bl && CActor.m_hero.testFlag(1);
    }

    boolean isReachTarget() {
        return this.m_destPosX == this.m_mapX && this.m_destPosY == this.m_mapY;
    }

    void updateWerewolfPosition() {
        this.checkAvailableAction();
        if (this.m_actionID == 2) {
            this.m_vY = this.m_isOnslope ? 1536 : 0;
            this.m_vX += this.testFlag(1) ? 1792 : -1792;
        } else if (this.m_actionID == 6) {
            if (--this.m_throwCount > 0) {
                this.m_vY = -2048;
            } else {
                this.m_aY = 1792;
            }
            this.m_vX = this.m_isThrownFront ? (this.m_isThownToLeft ? -3072 : 3072) : (this.m_isThownToLeft ? 3072 : -3072);
            this.m_aX = 0;
        } else if (this.m_actionID == 4) {
            int n = this.m_vX = this.testFlag(2048) ? 256 : -256;
            if (CHero.s_isTooCloseToEnemyWhenAttacking) {
                int n2;
                int n3 = n2 = this.testFlag(2048) ? CActor.m_hero.m_collisionBox[2] - this.m_collisionBox[0] : this.m_collisionBox[2] - CActor.m_hero.m_collisionBox[0];
                if ((n2 <<= 8) > 256) {
                    int n4 = this.m_vX = this.testFlag(2048) ? n2 : -n2;
                }
            }
            if (!this.m_canBackUp) {
                this.m_vX = 0;
            }
        } else {
            if (this.m_actionID == 40) {
                this.limitPosition();
                return;
            }
            this.m_vX = 0;
            this.m_vY = 0;
            this.m_aX = 0;
            this.m_aY = 0;
        }
        if (!this.m_canStand) {
            this.m_aY = 1792;
        } else {
            this.m_vY = 0;
        }
        this.limitPosition();
    }

    void updateWerewolfAI() {
        this.calcHorizontalPositionToHero();
        if (this.m_Parameters[3] == 1 && this.IsAlive() && this.canSeeHero()) {
            this.SetAsHeroCombatActor();
        }
        if (this.m_Parameters[3] == 1 && CGame.m_cameraBox[3] + 48 < this.m_collisionBox[1] || this.m_collisionBox[1] + (this.m_vY >> 8) >= CGame.m_mapHeightByPixel[2]) {
            this.m_actorStatus = 4;
            this.setFlag(4096, true);
            this.setFlag(64, false);
            return;
        }
        int n = this.getAttackedHurt();
        this.clearAttackedInfo();
        this.checkAvailableAction();
        boolean bl = false;
        if (n >= this.m_Parameters[0]) {
            bl = true;
        }
        if (n > 0 && this.m_actionID != 4 && this.m_actionID != 7 && this.m_actionID != 20 && this.m_actionID != 21 && this.m_actionID != 26 && this.m_actionID != 27 && this.m_actionID != 23 && this.m_actionID != 22 && this.m_actionID != 14 && this.m_actionID != 18 && this.m_actionID != 17 && this.m_actionID != 19) {
            this.setHurt(n);
            if (this.m_actionID == 15 || this.m_actionID == 16) {
                if (this.IsAlive()) {
                    if (CActor.m_hero.m_actionID == 105) {
                        this.setAction(18);
                    } else {
                        this.setAction(17);
                    }
                } else {
                    CGame.PlaySound(6);
                    this.setAction(19);
                }
            } else if (this.IsAlive()) {
                this.setAction(4, 4);
            } else {
                if (bl) {
                    CGame.PlaySound(6);
                    this.setAction(14);
                    this.m_vX = this.m_mapX < CActor.m_hero.m_mapX ? -3840 : 3840;
                    this.m_vY = 1280;
                    return;
                }
                int n2 = CActor.m_hero.canViolentlyKill(this);
                if (n2 != 0) {
                    this.setViolentlyBeKilled(n2);
                } else {
                    CGame.PlaySound(6);
                    this.setAction(7, 7);
                }
            }
        }
        if (this.m_actionID != 0 && this.m_actionID != 9) {
            this.m_waitCount = 0;
        }
        if (this.m_actionID == 0 || this.m_actionID == 9) {
            if (this.m_canDetect) {
                if (this.m_canAttack) {
                    this.setFlag(1, this.m_isLeftToHero);
                    this.setAction(3, 3);
                } else if (this.m_Parameters[3] == 1) {
                    this.setAction(39);
                } else if (this.m_canChasing) {
                    if (this.m_canGo) {
                        this.setFlag(1, this.m_isLeftToHero);
                        this.setAction(2, 2);
                    }
                } else {
                    ++this.m_waitCount;
                    if (this.m_waitCount > 3 && this.m_canGo) {
                        this.setFlag(1, this.m_isLeftToHero);
                        this.setAction(2, 2);
                    }
                }
            }
        } else if (this.m_actionID == 2) {
            if (this.m_canDetect) {
                if (this.m_canAttack) {
                    this.setFlag(1, this.m_isLeftToHero);
                    this.setAction(3, 3);
                }
            } else {
                this.setAction(0, 0);
            }
            if (!this.m_canGo) {
                this.setAction(0, 0);
            }
        } else if (this.m_actionID == 39) {
            if (this.testFlag(16)) {
                this.setAction(40);
                this.m_vX = this.testFlag(1) ? 4608 : -4608;
                this.m_aY = 768;
                this.m_vY = -5120;
            }
        } else if (this.m_actionID == 40) {
            if (CActor.m_hero.canBeAttackedBy(this)) {
                CActor.m_hero.setAttacked(this.getAttackPoint(), this.m_isLeftToHero);
            }
            if (this.m_canStand || this.m_isOnslope && this.m_vY > 0) {
                this.setFlag(1, this.m_isLeftToHero);
                this.setAction(0);
            }
        } else if (this.m_actionID == 3) {
            if (this.testFlag(16)) {
                this.setAction(1, 1);
                this.m_attackIdleCount = this.getNextWerewolfAttackIdleCount();
            } else {
                this.setFlag(1, this.m_isLeftToHero);
                if (CActor.m_hero.canBeAttackedBy(this)) {
                    CActor.m_hero.setAttacked(this.getAttackPoint(), this.m_isLeftToHero);
                }
            }
        } else if (this.m_actionID == 11) {
            if (CActor.isCollide(CActor.m_hero.m_collisionBox, this.m_collisionBox)) {
                CActor.m_hero.setAttacked(this.getAttackPoint(), this.m_isLeftToHero);
            }
        } else if (this.m_actionID == 1) {
            if (--this.m_attackIdleCount < 0) {
                if (!this.m_canAttack) {
                    if (this.m_canDetect && this.m_canChasing && this.m_canGo) {
                        if (this.m_Parameters[3] == 1) {
                            this.setAction(39);
                        } else {
                            this.setFlag(1, this.m_isLeftToHero);
                            this.setAction(2, 2);
                        }
                    } else {
                        this.setAction(0, 0);
                    }
                } else {
                    this.setFlag(1, this.m_isLeftToHero);
                    this.setAction(3, 3);
                }
            }
        } else if (this.m_actionID == 4) {
            if (this.testFlag(16)) {
                this.setFlag(1, this.m_isLeftToHero);
                this.setAction(0, 0);
            }
        } else if (this.m_actionID == 5) {
            if (this.testFlag(16)) {
                this.setFlag(1, !this.m_isLeftToHero);
                this.setAction(6, 6);
                this.m_throwCount = 8;
            }
        } else if (this.m_actionID == 6) {
            if (this.m_canStand && this.m_throwCount <= 0) {
                this.setHurt(CActor.m_hero.getAttackPoint());
                if (this.IsAlive()) {
                    this.setAction(10, 10);
                } else {
                    CGame.PlaySound(6);
                    this.setAction(7, 7);
                }
            }
        } else if (this.m_actionID == 10) {
            CActor.m_hero.ClearThrownActor(this);
            if (this.testFlag(16)) {
                this.setAction(0, 0);
            }
        } else if (this.m_actionID == 7 || this.m_actionID == 14) {
            CActor.m_hero.ClearThrownActor(this);
            if (this.testFlag(16)) {
                this.m_actorStatus = 4;
                this.setFlag(4096, true);
                this.setFlag(64, false);
                CActor.m_hero.addScore(this);
            }
        } else if (this.m_actionID == 20) {
            if (this.testFlag(16)) {
                this.setAction(21);
                CActor.m_hero.ClearThrownActor(this);
            }
        } else if (this.m_actionID == 26) {
            if (this.testFlag(16)) {
                this.setAction(21);
            }
        } else if (this.m_actionID == 23) {
            if (this.testFlag(16)) {
                this.setAction(24);
                this.m_vX = this.testFlag(1) ? -4608 : 4608;
                this.m_waitTime = 0;
                this.setFlag(4096, true);
            }
        } else if (this.m_actionID == 24) {
            this.attackOtherEnemyWhenThrowFly();
            if (this.m_waitTime++ > 8) {
                this.m_waitTime = 0;
                this.setAction(25);
            }
        } else if (this.m_actionID == 22 || this.m_actionID == 27 || this.m_actionID == 25) {
            CActor.m_hero.ClearThrownActor(this);
            if (this.testFlag(16)) {
                this.m_actorStatus = 4;
                this.setFlag(4096, true);
                this.setFlag(64, false);
                CActor.m_hero.addScore(this);
            }
        } else if (this.m_actionID == 15) {
            if (this.testFlag(16)) {
                this.setAction(16);
            }
        } else if (this.m_actionID != 18) {
            if (this.m_actionID == 17) {
                if (this.testFlag(16)) {
                    this.setAction(16);
                }
            } else if (this.m_actionID != 16 && this.m_actionID == 19 && this.testFlag(16)) {
                this.m_actorStatus = 4;
                this.setFlag(4096, true);
                this.setFlag(64, false);
                CActor.m_hero.addScore(this);
                if (CActor.m_hero.m_actionID == 103 || CActor.m_hero.m_actionID == 104 || CActor.m_hero.m_actionID == 105) {
                    CActor.m_hero.setAction(0);
                }
            }
        }
    }

    void setThrowWereWolf(boolean bl) {
        if (bl) {
            this.setAction(6, 6);
            this.m_throwCount = 5;
            this.setFlag(1, CActor.m_hero.testFlag(1));
        } else {
            this.setAction(5, 5);
        }
        this.getCollisionBox();
        if (CActor.m_hero.testFlag(1)) {
            short s = CActor.m_hero.m_collisionBox[0];
            short s2 = this.m_collisionBox[2];
            int n = s - s2;
            int n2 = n - 8;
            this.setMapPosition(this.m_mapX + n2, this.m_mapY);
            this.setFlag(1, true);
        } else {
            short s = CActor.m_hero.m_collisionBox[2];
            short s3 = this.m_collisionBox[0];
            int n = s3 - s;
            int n3 = 8 - n;
            this.setMapPosition(this.m_mapX + n3, this.m_mapY);
            this.setFlag(1, false);
        }
        this.m_isThrownFront = bl;
        this.m_isThownToLeft = this.m_isLeftToHero;
    }

    void initWerewolf() {
        this.m_hp = this.m_Parameters[0];
        this.m_offset = this.m_Parameters[1];
        this.m_waitTime = 0;
        this.m_chasingRange = 72;
        this.m_attackRange = 16;
        this.m_backOffRange = 0;
        this.m_attackPoint = this.m_hp < 50 || this.m_Parameters[3] != 1 ? 4 : 5;
    }

    private boolean isWerewolfBackClimb() {
        return this.m_actionID >= 28 && this.m_actionID <= 38;
    }

    void updateWerewolfBackClimb() {
        int n = 0;
        int n2 = this.getAttackedHurt();
        this.clearAttackedInfo();
        if (n2 > 0 && this.m_actionID != 31 && this.m_actionID != 32 && this.m_actionID != 33 && this.m_actionID != 34 && this.m_actionID != 38 && this.m_actionID != 35 && this.m_actionID != 36 && this.m_actionID != 37) {
            this.setHurt(n2);
            if (this.IsAlive()) {
                this.setAction(31);
            } else {
                this.setAction(32);
                this.m_aY = 1792;
            }
        }
        if (!CActor.m_hero.isHeroBackClimbing() && this.m_actionID != 28 && this.m_actionID != 31 && this.m_actionID != 32 && this.m_actionID != 33 && this.m_actionID != 34 && this.m_actionID != 38) {
            this.setAction(28);
        }
        if (this.IsAlive() && this.m_actionID != 35 && this.m_actionID != 36 && this.m_actionID != 37) {
            this.setFaceTo(CActor.m_hero);
        }
        switch (this.m_actionID) {
            case 28: {
                if (!CActor.m_hero.isHeroBackClimbing()) {
                    return;
                }
                int n3 = this.m_realX - CActor.m_hero.m_realX;
                int n4 = this.m_realY - CActor.m_hero.m_realY;
                n = CGame.getDistance(n3, n4);
                this.getActiveBox();
                if (n <= 5120 || CActor.isCollide(CActor.m_hero.m_collisionBox, this.m_activeZoneBox)) {
                    if (this.m_waitTime++ <= 30) break;
                    this.m_waitTime = 0;
                    this.setAction(30);
                    break;
                }
                if (n >= 30720 || n <= 5120) break;
                this.setAction(29);
                if (n3 != 0) {
                    int n5 = this.m_vX = n3 > 0 ? -768 : 768;
                }
                if (n4 == 0) break;
                this.m_vY = n4 > 0 ? -768 : 768;
                break;
            }
            case 29: {
                if (!this.testFlag(16)) break;
                this.setAction(28);
                break;
            }
            case 30: {
                if (CActor.m_hero.canBeAttackedBy(this)) {
                    CActor.m_hero.setAttacked(this.getAttackPoint(), this.m_isLeftToHero);
                }
                if (!this.testFlag(16)) break;
                this.setAction(28);
                break;
            }
            case 31: {
                if (!this.testFlag(16)) break;
                this.setAction(28);
                break;
            }
            case 35: {
                break;
            }
            case 36: {
                break;
            }
            case 37: {
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 38: {
                if (!this.testFlag(16) && !this.m_canStand) break;
                this.m_actorStatus = 4;
                this.setFlag(4096, true);
                this.setFlag(64, false);
                CActor.m_hero.addScore(this);
            }
        }
    }

    void attackOtherEnemyWhenThrowFly() {
        this.getCollisionBox();
        for (int i = 0; i < CActor.s_EnemyActorCount; ++i) {
            CActor cActor = CActor.s_EnemyActor[i];
            if (cActor.m_classID != 2 && cActor.m_classID != 44 && cActor.m_classID != 19 || cActor == this || !CActor.isCollide(this.m_collisionBox, cActor.m_collisionBox)) continue;
            boolean bl = this.m_realX - cActor.m_realX < 0;
            cActor.setAttacked(10, bl);
        }
    }

    void updateSkeletonAI() {
        this.calcHorizontalPositionToHero();
        if (this.m_actionID != 11 && this.m_actionID != 12 && this.m_actionID != 17 && this.m_actionID != 18 && this.m_actionID != 13 && this.m_actionID != 14) {
            this.handleSkeletonHurt();
        }
        this.checkAvailableAction();
        --this.m_attackIdleCount;
        --this.m_waitCount;
        if (CHero.s_actorToBeBeviolentlyKilled != this && this.m_actionID != 13 && this.m_actionID != 14) {
            this.setFlag(1, this.m_isLeftToHero);
        }
        if (this.IsAlive() && this.canSeeHero() && this.m_actionID != 7) {
            this.SetAsHeroCombatActor();
        }
        if (this.m_actionID == 10) {
            if (CActor.isCollide(CActor.m_hero.m_collisionBox, this.m_collisionBox)) {
                CActor.m_hero.setAttacked(this.getAttackPoint(), this.m_isLeftToHero);
            }
        } else if (this.m_actionID == 8) {
            if (this.m_canAttack) {
                this.setAction(9);
            }
        } else if (this.m_actionID == 9) {
            if (this.testFlag(16)) {
                this.setAction(0);
            }
        } else if (this.m_actionID == 0) {
            if (this.m_canDetect) {
                if (this.m_canAttack && this.m_attackIdleCount < 0) {
                    this.m_attackIdleCount = 30;
                    this.setAction(3);
                }
                if (this.m_canChasing && this.m_canGo) {
                    this.setAction(1);
                }
                if (this.m_canBackOff && this.m_canBackUp) {
                    this.setAction(2);
                }
            }
        } else if (this.m_actionID == 1) {
            if (!this.m_canChasing || !this.m_canGo) {
                this.setAction(0);
            }
        } else if (this.m_actionID == 2) {
            if (!this.m_canBackOff || !this.m_canBackUp) {
                this.setAction(0);
            }
        } else if (this.m_actionID == 5) {
            if (this.testFlag(16)) {
                this.setAction(0);
            }
        } else if (this.m_actionID == 6) {
            if (this.testFlag(16)) {
                this.m_actorStatus = 4;
                this.setFlag(4096, true);
                this.setFlag(64, false);
                CActor.m_hero.addScore(this);
            }
        } else if (this.m_actionID == 3) {
            if (this.testFlag(16)) {
                int n = this.testFlag(1) ? -12 : 12;
                short s = this.m_Parameters[4];
                this.ThrowWeapon(s, this.getWeaponClassIDByType(s), n, -42);
                this.setAction(4);
            }
        } else if (this.m_actionID == 4) {
            if (this.testFlag(16)) {
                this.setAction(0);
            }
        } else if (this.m_actionID == 11) {
            if (this.testFlag(16)) {
                this.setAction(12);
                CActor.m_hero.ClearThrownActor(this);
            }
        } else if (this.m_actionID == 17) {
            if (this.testFlag(16)) {
                this.setAction(12);
            }
        } else if (this.m_actionID == 13) {
            if (this.testFlag(16)) {
                this.setAction(15);
                this.m_vX = this.testFlag(1) ? -4608 : 4608;
                this.m_waitTime = 0;
                this.setFlag(4096, true);
            }
        } else if (this.m_actionID == 15) {
            this.attackOtherEnemyWhenThrowFly();
            if (this.m_waitTime++ > 8) {
                this.m_waitTime = 0;
                this.setAction(16);
            }
        } else if (this.m_actionID == 14 || this.m_actionID == 18 || this.m_actionID == 16) {
            CActor.m_hero.ClearThrownActor(this);
            if (this.testFlag(16)) {
                this.m_actorStatus = 4;
                this.setFlag(4096, true);
                this.setFlag(64, false);
                CActor.m_hero.addScore(this);
            }
        }
    }

    void initSkeleton() {
        this.m_hp = this.m_Parameters[0];
        this.m_offset = this.m_Parameters[1];
        this.m_chasingRange = 81;
        this.m_attackRange = 80;
        this.m_backOffRange = 36;
        this.m_attackPoint = 4;
        if (this.m_Parameters[4] == 2) {
            this.m_Palette = 1;
        }
    }

    void updateSkeletonPosition() {
        this.checkAvailableAction();
        if (this.m_actionID == 1) {
            int n = this.m_vX = this.testFlag(1) ? 896 : -896;
            this.m_vY = this.m_isOnslope ? 1536 : 0;
        } else if (this.m_actionID == 5) {
            if (this.m_canBackOff && this.m_canBackUp) {
                int n = this.m_vX = this.testFlag(2048) ? 256 : -256;
            }
            this.m_vY = this.m_isOnslope ? 1536 : 0;
        } else if (this.m_actionID == 2) {
            int n = this.m_vX = this.testFlag(2048) ? 768 : -768;
            this.m_vY = this.m_isOnslope ? 1536 : 0;
        } else {
            this.m_vX = 0;
            this.m_vY = 0;
            this.m_aX = 0;
            this.m_aY = 0;
        }
        this.m_aY = !this.m_canStand ? 1024 : 0;
        this.limitPosition();
    }

    void handleSkeletonHurt() {
        boolean bl;
        int n = this.getAttackedHurt();
        this.clearAttackedInfo();
        if (n <= 0) {
            return;
        }
        boolean bl2 = bl = this.m_actionID == 5 || this.m_actionID == 6 || this.m_actionID == 7 || this.m_actionID == 8;
        if (!bl) {
            this.setHurt(n);
            if (this.IsAlive()) {
                this.setAction(5);
            } else {
                int n2 = CActor.m_hero.canViolentlyKill(this);
                if (n2 != 0) {
                    this.setViolentlyBeKilled(n2);
                } else {
                    CGame.PlaySound(6);
                    this.setAction(6);
                }
            }
        }
    }

    void initGrendel() {
        this.m_hp = this.m_Parameters[4];
        this.m_attackPoint = 3;
        this.m_waitTime = 0;
        this.m_waitCount = 0;
        s_grendel_aim_point = -1;
        this.shiftToFloor();
    }

    private int getGrendelAttackMode(CActor cActor) {
        int n = Math.abs(this.m_mapY - cActor.m_mapY);
        short s = this.m_Parameters[0];
        if (s != -1 && n > 40 && cActor.m_actionID != 8) {
            return 2;
        }
        return 1;
    }

    private int getGrendelAimPoint() {
        int n;
        int n2 = 0;
        for (n = 0; n < 3; ++n) {
            if (this.m_Parameters[1 + n] == -1) continue;
            ++n2;
        }
        if (n2 == 0) {
            return -1;
        }
        n = CGame.Random(0, n2 - 1);
        return this.m_Parameters[1 + n];
    }

    private void setGrendelJumpSpeed(int n) {
        if (n == -1) {
            this.m_aY = 1792;
            this.m_vY = -1536;
        } else {
            CActor cActor = CActor.s_actors[n];
            int n2 = cActor.m_mapX - this.m_mapX << 8;
            int n3 = cActor.m_mapY - this.m_mapY << 8;
            this.m_vX = n2 > 0 ? 3840 : -3840;
            int n4 = (n2 + 256) / this.m_vX;
            n4 = n4 <= 0 ? 1 : n4;
            this.m_vY = (Math.abs(n3) + 256) / n4;
            this.m_vY = n3 > 0 ? this.m_vY : -this.m_vY;
            this.setFaceTo(cActor);
        }
    }

    void updateGrendelAI() {
        if (this.m_Parameters[6] == 1) {
            return;
        }
        this.calcHorizontalPositionToHero();
        if (this.IsAlive() && this.canSeeHero()) {
            this.SetAsHeroCombatActor();
        }
        int n = this.getAttackedHurt();
        if (CGame.s_difficult >= 2) {
            n -= n >> 1;
        }
        this.clearAttackedInfo();
        if (n > 0 && this.m_hp > 0 && this.m_actionID != 9 && this.m_actionID != 4 && this.m_actionID != 5 && this.m_actionID != 14 && this.m_actionID != 13 && this.m_actionID != 21 && this.m_actionID != 22 && this.m_actionID != 12 && this.m_actionID != 20 && this.m_actionID != 6 && this.m_actionID != 7 && this.m_actionID != 8) {
            this.setHurt(n);
            if (this.IsAlive()) {
                if (CHero.s_actionActor != this) {
                    this.setAction(9);
                }
                this.m_waitCount += n;
            } else {
                CGame.clearBossHpBar();
                this.m_waitCount = 0;
                if (this.m_Parameters[7] == 1) {
                    this.setAction(12);
                } else {
                    this.setAction(14);
                }
                CActor.m_hero.addScore(this);
                if (CHero.s_actionActor == this) {
                    CActor.m_hero.setAction(6);
                    CHero.s_actionActor = null;
                }
            }
        }
        CHero cHero = CActor.m_hero;
        int n2 = 0;
        int n3 = 0;
        switch (this.m_actionID) {
            case 0: {
                if (this.getGrendelAttackMode(cHero) == 1) {
                    n2 = this.m_mapX - cHero.m_mapX;
                    if (Math.abs(n2) > 70) {
                        if (!this.m_canRun || s_grendel_aim_point != -1) break;
                        this.setAction(1);
                        this.setFaceTo(cHero);
                        this.m_vX = this.testFlag(1) ? -2048 : 2048;
                        break;
                    }
                    if (this.m_waitTime++ <= 17) break;
                    this.m_waitTime = 0;
                    this.setAction(20);
                    this.setFaceTo(cHero);
                    break;
                }
                if (this.m_waitTime++ <= 20) break;
                this.m_waitTime = 0;
                this.setAction(10);
                this.setFaceTo(cHero);
                break;
            }
            case 1: {
                if (!this.IsAlive()) {
                    super.updatePosition();
                    if (++this.m_waitTime <= 10) break;
                    this.m_waitTime = 0;
                    this.m_actorStatus = 4;
                    this.setFlag(4096, true);
                    this.setFlag(64, false);
                    break;
                }
                n2 = this.m_mapX - cHero.m_mapX;
                super.updatePosition();
                if (Math.abs(n2) > 70) break;
                this.setAction(0);
                break;
            }
            case 20: {
                if (!this.testFlag(16)) break;
                this.setAction(4);
                break;
            }
            case 4: 
            case 5: {
                if (CActor.m_hero.canBeAttackedBy(this)) {
                    int n4 = this.getAttackPoint();
                    if (this.m_actionID == 5) {
                        n4 <<= 1;
                    }
                    CActor.m_hero.setAttacked(n4, this.m_isLeftToHero);
                }
                if (!this.testFlag(16)) break;
                this.setAction(0);
                break;
            }
            case 10: {
                if (!this.testFlag(16)) break;
                this.setAction(0);
                short s = this.m_Parameters[0];
                CActor.s_actors[s].setFlag(2, false);
                CActor.s_actors[s].setFlag(64, true);
                CActor.s_actors[s].m_actorStatus = 1;
                int n5 = this.testFlag(1) ? -50 : 50;
                CActor.s_actors[s].setMapPosition(this.m_mapX + n5, this.m_mapY + -80);
                n2 = CActor.m_hero.m_realX - CActor.s_actors[s].m_realX;
                n3 = CActor.m_hero.m_realY - CActor.s_actors[s].m_realY;
                CActor.s_actors[s].m_vX = n2 / 10;
                CActor.s_actors[s].m_vY = n3 / 10;
                break;
            }
            case 9: {
                if (!this.testFlag(16)) break;
                short s = this.m_Parameters[4];
                short s2 = this.m_Parameters[5];
                if (this.m_hp < s && (s - this.m_hp) % s2 == 0) {
                    this.m_waitTime = 0;
                    this.setAction(21);
                    break;
                }
                if (this.m_waitCount > CGame.Random(50, 80)) {
                    this.m_waitCount = 0;
                    this.setAction(12);
                    break;
                }
                this.setAction(0);
                break;
            }
            case 12: {
                if (!this.testFlag(16)) break;
                if (this.m_Parameters[7] == 1 && this.m_hp <= 0) {
                    this.setAction(1);
                    this.m_vX = -5120;
                    this.setFlag(1, true);
                    CHero.s_blockActor = null;
                    this.m_waitTime = 0;
                    break;
                }
                if (s_grendel_aim_point != -1) {
                    this.setAction(6);
                    s_grendel_aim_point = -1;
                    break;
                }
                s_grendel_aim_point = this.getGrendelAimPoint();
                if (s_grendel_aim_point != -1) {
                    if (CGame.Random(0, 9) < 7) {
                        this.setAction(6);
                        break;
                    }
                    s_grendel_aim_point = -1;
                }
                this.setAction(5);
                break;
            }
            case 6: {
                if (!this.testFlag(16)) break;
                this.setAction(7);
                this.setGrendelJumpSpeed(s_grendel_aim_point);
                break;
            }
            case 7: {
                this.setFlag(8192, true);
                if (s_grendel_aim_point != -1) {
                    this.setRealPosition(this.m_realX + this.m_vX, this.m_realY + this.m_vY);
                    this.getCollisionBox();
                    CActor cActor = CActor.s_actors[s_grendel_aim_point];
                    int n6 = Math.abs(this.m_realX - cActor.m_realX);
                    int n7 = Math.abs(this.m_realY - cActor.m_realY);
                    if (n6 <= Math.abs(this.m_vX)) {
                        this.m_vX = 0;
                    }
                    if (n7 <= Math.abs(this.m_vY)) {
                        this.m_vY = 0;
                    }
                    if (this.m_vX != 0 || this.m_vY != 0) break;
                    this.setAction(8);
                    this.setRealPosition(cActor.m_realX, cActor.m_realY);
                    break;
                }
                this.m_vY += this.m_aY;
                this.setRealPosition(this.m_realX, this.m_realY + this.m_vY);
                int n8 = this.computeVDisToFloor() << 8;
                if (n8 >= Math.abs(this.m_vY)) break;
                this.setRealPosition(this.m_realX, this.m_realY + n8 - 256);
                this.setAction(8);
                break;
            }
            case 8: {
                if (!this.testFlag(16)) break;
                this.setAction(0);
                break;
            }
            case 21: {
                if (!this.testFlag(16)) break;
                this.setAction(22);
                break;
            }
            case 22: {
                if (CActor.m_hero.canBeAttackedBy(this)) {
                    int n9 = this.getAttackPoint();
                    CActor.m_hero.setAttacked(n9, this.m_isLeftToHero);
                }
                if (!this.testFlag(16)) break;
                this.setAction(13);
                break;
            }
            case 13: {
                if (this.m_waitTime++ > 35) {
                    this.m_waitTime = 0;
                    this.setAction(0);
                    break;
                }
                if (!CGame.IsKeyPressed(262656)) break;
                this.getActiveBox();
                if (CActor.m_hero.m_hp <= 0 || !CActor.m_hero.isTriggeredByHero(this.m_activeZoneBox, true)) break;
                this.m_waitTime = 0;
                CActor.m_hero.setAction(75);
                CActor.m_hero.setMapPosition(this.m_mapX, this.m_mapY);
                CActor.m_hero.setFlag(1, this.testFlag(1));
                this.setAction(15);
                CHero.s_actionActor = this;
                break;
            }
            case 15: {
                if (!this.testFlag(16)) break;
                this.setAction(16);
                break;
            }
            case 16: {
                if (this.m_waitTime++ > 50) {
                    this.m_waitTime = 0;
                    this.setAction(17);
                    break;
                }
                if (CHero.s_actionActor != null) break;
                this.setAction(0);
                break;
            }
            case 18: {
                ++this.m_waitTime;
                if (!this.testFlag(16)) break;
                this.setAction(this.m_prevActionID);
                break;
            }
            case 17: {
                if (this.m_waitTime++ > 30) {
                    this.m_waitTime = 0;
                    this.setAction(19);
                    CActor.m_hero.setAction(78);
                    break;
                }
                if (CHero.s_actionActor != null) break;
                this.setAction(0);
                break;
            }
            case 19: {
                CActor.m_hero.setMapPosition(this.m_mapX, this.m_mapY);
                if (!this.testFlag(16)) break;
                this.setAction(0);
                CActor.m_hero.setAttacked(10, this.testFlag(1));
                break;
            }
            case 14: {
                if (!this.testFlag(16)) break;
                this.setFlag(64, false);
                this.setFlag(4096, true);
            }
        }
    }

    void initSerpentBody(boolean bl) {
        this.m_waitTime = this.m_Parameters[0];
        this.m_vX = 0;
        this.m_attackIdleCount = 50;
        this.m_hp = 10000;
    }

    void updateSerpentBodyAI() {
        --this.m_waitTime;
        --this.m_attackIdleCount;
        if (CHero.s_platformActor == null && CActor.m_hero.m_actionID != 116 && CActor.isCollide(this.m_collisionBox, CActor.m_hero.m_collisionBox)) {
            CHero.s_platformActor = CHero.s_actionActor = this;
            this.m_vX = this.testFlag(1) ? 768 : -768;
            CActor.m_hero.setActionWithCollision(113, 2, 3);
            CActor.m_hero.setRealPosition(this.m_realX, CActor.m_hero.m_realY);
            CActor.m_hero.setFlag(1, !this.testFlag(1));
            CActor.m_hero.setFlag(1024, true);
            CActor.m_hero.m_weaponType = CActor.m_hero.m_waitTime = CGame.Random(30, 50);
            CActor.m_hero.createIndicator(9);
            this.m_waitTime = this.m_Parameters[0];
            this.m_waitCount = this.m_mapY;
            if (this.m_weaponID == -1) {
                this.m_weaponID = this.clone(36, this.m_mapX, this.m_mapY + 40, 0, 4);
            }
        }
        if (this.m_actionID == 19 && CHero.s_actionActor == this) {
            if (this.m_waitTime < 0) {
                this.m_vY = 768;
            }
            if (this.m_attackIdleCount < 0 && CActor.s_actors[this.m_weaponID].m_actionID == 5) {
                CActor.s_actors[this.m_weaponID].setAction(4);
            }
            int n = this.getAttackedHurt();
            this.clearAttackedInfo();
            if (n > 0) {
                this.setHurt(n);
                this.setFlag(128, true);
                this.setAction(20);
                this.m_vX += this.testFlag(1) ? 256 : -256;
                this.m_vY = -2560;
                this.m_waitTime = this.m_Parameters[0];
                CActor.s_actors[this.m_weaponID].setAction(5);
            }
        } else if (this.m_actionID == 20 && this.testFlag(16)) {
            this.setFlag(128, true);
            this.setAction(19);
        }
        if (CActor.m_hero.testFlag(1024)) {
            CActor.m_hero.updateOnSerpentAI();
        }
    }

    void updateSerpentBodyPosition() {
        if (this.m_mapY <= this.m_waitCount && this.m_vY < 0) {
            this.setRealPosition(this.m_realX, this.m_waitCount << 8);
            this.m_vY = 0;
        }
        this.setRealPosition(this.m_realX + this.m_vX, this.m_realY + this.m_vY);
        if (CHero.s_actionActor == this && (CActor.m_hero.m_actionID == 0 || CActor.m_hero.m_actionID == 4 || CActor.m_hero.m_actionID == 23 || CActor.m_hero.m_actionID == 1 || CActor.m_hero.m_actionID == 2 || CActor.m_hero.m_actionID == 3 || CActor.m_hero.m_actionID == 11 || CActor.m_hero.m_actionID == 12 || CActor.m_hero.m_actionID == 113 || CActor.m_hero.m_actionID == 114 || CActor.m_hero.m_actionID == 115 || CActor.m_hero.m_actionID == 116)) {
            this.getCollisionBox();
            int n = this.m_collisionBox[1] - CActor.m_hero.m_collisionBox[3] + CActor.m_hero.m_mapY << 8;
            if (CActor.m_hero.m_actionID == 116) {
                CActor.m_hero.m_vY += CActor.m_hero.m_aY;
                CActor.m_hero.setRealPosition(CActor.m_hero.m_realX + this.m_vX, CActor.m_hero.m_realY + CActor.m_hero.m_vY);
            } else {
                CActor.m_hero.setRealPosition(CActor.m_hero.m_realX + this.m_vX, n);
            }
            if (CHero.s_decorationID != -1) {
                int n2 = 7680;
                if (CActor.m_hero.testFlag(1)) {
                    n2 = -n2;
                }
                CActor.s_actors[CHero.s_decorationID].setRealPosition(CActor.m_hero.m_realX + n2, CActor.m_hero.m_collisionBox[1] - 40 << 8);
            }
            CActor.s_actors[this.m_weaponID].setRealPosition(this.m_realX, CActor.s_actors[this.m_weaponID].m_realY);
        }
    }

    void initSerpent() {
        this.m_waitTime = 0;
        this.m_hp = this.m_Parameters[2];
        this.setFlag(512, false);
    }

    void serpentBeAttacked() {
        int n = this.getAttackedHurt();
        if (CGame.s_difficult >= 2) {
            n -= n >> 1;
        }
        this.clearAttackedInfo();
        if (n > 0 && (this.m_actionID == 7 || this.m_actionID == 10 || this.m_actionID == 24)) {
            this.setHurt(n);
            if (this.m_hp > 0) {
                if (CHero.s_actionActor != this) {
                    if (this.m_actionID == 7) {
                        this.setAction(15);
                    } else if (this.m_actionID == 10) {
                        this.setAction(11);
                    }
                }
            } else {
                this.m_waitTime = 0;
                this.setAction(16);
                this.setFlag(4096, true);
                this.setFlag(64, false);
                CGame.clearBossHpBar();
            }
        }
    }

    void updateSerpentAI() {
        int n;
        short s = this.m_Parameters[0];
        short s2 = this.m_Parameters[1];
        this.serpentBeAttacked();
        if (this.m_hp > 0 && this.m_actionID >= 7) {
            int n2 = n = CActor.isCollide(this.m_collisionBox, CActor.m_hero.m_collisionBox) || this.canSeeHero() ? 1 : 0;
            if (n != 0) {
                this.SetAsHeroCombatActor();
            }
        }
        switch (this.m_actionID) {
            case 1: {
                if (!this.testFlag(16)) break;
                this.setAction(0);
                break;
            }
            case 3: {
                if (!this.testFlag(16)) break;
                this.m_actorStatus = 4;
                break;
            }
            case 0: {
                if (s >= 0 && CActor.s_actors[s].m_hp > 0) {
                    CActor.s_actors[s].getActiveBox();
                    if (!CActor.m_hero.isTriggeredByHero(CActor.s_actors[s].m_activeZoneBox, true) || this.m_waitTime++ <= 1) break;
                    this.m_waitTime = 0;
                    this.setAction(2);
                    CActor.s_actors[s].setAttacked(1, false);
                    break;
                }
                this.setAction(3);
                break;
            }
            case 2: {
                if (!this.testFlag(16)) break;
                CHero.m_cameraShakingTimer = 5;
                this.setAction(0);
                break;
            }
            case 4: {
                if (s < 0) break;
                if (CActor.s_actors[s].m_classID == 40) {
                    if (!CActor.m_hero.isTriggeredByHero(CActor.s_actors[s].m_activeZoneBox, true)) break;
                    this.setAction(1);
                    break;
                }
                if (!this.testFlag(256)) {
                    CActor.s_actors[s].getActiveBox();
                    if (CActor.m_hero.isTriggeredByHero(CActor.s_actors[s].m_activeZoneBox, true)) {
                        this.setFlag(256, true);
                        CHero.m_cameraShakingTimer = 15;
                        this.m_weaponID = this.clone(36, this.m_mapX, this.m_mapY, 0, 2);
                    }
                }
                if (!this.testFlag(256) || this.m_waitTime++ <= 25) break;
                this.setFlag(256, false);
                this.m_waitTime = 0;
                this.setAction(5);
                this.m_vX = this.m_realX > CActor.s_actors[s].m_realX ? -4096 : 4096;
                this.m_vY = -5120;
                this.m_aY = 1792;
                if (this.m_weaponID >= 0) {
                    CActor.s_actors[this.m_weaponID].m_actorStatus = 4;
                    this.m_weaponID = -1;
                }
                this.m_weaponID = this.clone(36, this.m_mapX, this.m_mapY, 0, 3);
                break;
            }
            case 5: {
                this.setRealPosition(this.m_realX + this.m_vX, this.m_realY + this.m_vY);
                this.m_vY += this.m_aY;
                if (CActor.m_hero.canBeAttackedBy(this)) {
                    n = 10;
                    CActor.m_hero.setAttacked(n, false);
                }
                if (!this.testFlag(16)) break;
                if (s == -1) {
                    this.m_actorStatus = 4;
                } else {
                    this.setFlag(1, !this.testFlag(1));
                    this.setAction(4);
                    n = (this.m_Parameters[3] << 8) - CActor.s_actors[s].m_realX;
                    int n3 = this.m_realX > CActor.s_actors[s].m_realX ? CActor.s_actors[s].m_realX - n : CActor.s_actors[s].m_realX + n;
                    this.setRealPosition(n3, this.m_Parameters[4] << 8);
                }
                if (this.m_weaponID < 0) break;
                CActor.s_actors[this.m_weaponID].m_actorStatus = 4;
                this.m_weaponID = -1;
                break;
            }
            case 7: {
                ++this.m_waitTime;
                if (this.m_waitTime <= 40) break;
                this.getActiveBox();
                if (CActor.m_hero.isTriggeredByHero(this.m_activeZoneBox, true)) {
                    this.m_waitTime = 0;
                    this.setAction(8);
                    break;
                }
                --this.m_waitTime;
                break;
            }
            case 15: {
                ++this.m_waitTime;
                if (!this.testFlag(16)) break;
                this.setAction(7);
                n = CGame.Random(-3, 1);
                for (int i = 0; i < n; ++i) {
                    this.jumpOutCrystal(i << 1, -110, 0);
                }
                break;
            }
            case 8: {
                if (!this.testFlag(16)) break;
                if (s2 == 0) {
                    this.setAction(9);
                    break;
                }
                if (CGame.Random(0, 100) > 40) {
                    this.setAction(17);
                    break;
                }
                this.setAction(9);
                break;
            }
            case 9: {
                if (this.testFlag(16)) {
                    this.getAttackBox();
                    if (CActor.m_hero.m_hp > 0 && CHero.s_tickInvincible == 0 && CActor.m_hero.isTriggeredByHero(this.m_attackBox, true)) {
                        if (CActor.m_hero.isFaceTo(this) && CActor.m_hero.m_canStand) {
                            this.setAction(12);
                            this.m_currStep = 0;
                            this.setFlag(512, true);
                            CActor.m_hero.setAction(111);
                            CActor.m_hero.m_waitTime = 0;
                            CHero.s_actionActor = this;
                            break;
                        }
                        n = this.m_realX - CActor.m_hero.m_realX < 0 ? 1 : 0;
                        CActor.m_hero.setAttacked(10, n != 0);
                        break;
                    }
                    this.setAction(10);
                    CHero.m_cameraShakingTimer = 8;
                    break;
                }
                this.getAttackBox();
                if (CActor.m_hero.m_vY == 0 || !CActor.m_hero.isTriggeredByHero(this.m_attackBox, true)) break;
                n = this.m_realX - CActor.m_hero.m_realX < 0 ? 1 : 0;
                CActor.m_hero.setAttacked(10, n != 0);
                break;
            }
            case 10: {
                ++this.m_waitTime;
                if (this.m_waitTime <= 50) break;
                this.m_waitTime = 0;
                this.setAction(7);
                break;
            }
            case 11: {
                ++this.m_waitTime;
                if (!this.testFlag(16)) break;
                this.setAction(10);
                n = CGame.Random(-3, 1);
                for (int i = 0; i < n; ++i) {
                    this.jumpOutCrystal(i << 1, -110, 0);
                }
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                if (!this.testFlag(16)) break;
                this.setAction(7);
                break;
            }
            case 14: {
                if (!this.testFlag(16)) break;
                this.setAction(7);
                break;
            }
            case 17: {
                if (!this.testFlag(16)) break;
                CHero.s_blowDir = this.testFlag(1) ? 1 : -1;
                CHero.s_blowedTimer = 0;
                this.setAction(18);
                break;
            }
            case 18: {
                if (++this.m_waitTime <= 30) break;
                this.m_waitTime = 0;
                this.setAction(22);
                CActor.m_hero.stopBlow();
                CHero.s_decorationID = this.clone(5, this.m_mapX + -124, this.m_mapY + -29, 0, 9);
                break;
            }
            case 22: {
                ++this.m_waitTime;
                if (this.m_waitTime > 60) {
                    this.m_waitTime = 0;
                    this.setAction(7);
                    if (CHero.s_decorationID == -1) break;
                    CActor.s_actors[CHero.s_decorationID].invalidateActor();
                    CHero.s_decorationID = -1;
                    break;
                }
                if (!CActor.m_hero.m_pressAttack || !CActor.m_hero.m_canStand) break;
                this.getActiveBox();
                if (!CActor.m_hero.isTriggeredByHero(this.m_activeZoneBox, true)) break;
                this.m_waitTime = 0;
                this.setFlag(512, true);
                this.setAction(23);
                CActor.m_hero.setAction(120);
                CHero.s_actionActor = this;
                if (CHero.s_decorationID == -1) break;
                CActor.s_actors[CHero.s_decorationID].invalidateActor();
                CHero.s_decorationID = -1;
                break;
            }
            case 24: {
                if (!this.testFlag(16)) break;
                this.clone(21, this.m_mapX + -70, this.m_mapY + 60, 7);
                this.setAction(7);
                CHero.m_cameraShakingTimer = 6;
                n = CGame.Random(1, 4);
                for (int i = 0; i < n; ++i) {
                    this.jumpOutCrystal(i << 1, -110, 0);
                }
                break;
            }
        }
    }

    void drawSerpentResistBar(Graphics graphics, int n, int n2) {
        int n3 = 100;
        int n4 = this.m_currStep * 100 / n3;
        int n5 = CActor.m_hero.m_mapX - n;
        int n6 = CActor.m_hero.m_mapY - n2;
        this.drawStatusBar(graphics, n5 += 0, n6 -= 60, n4, 0xFF0000);
    }

    void initFrisianAI(boolean bl) {
        this.m_hp = this.m_Parameters[0];
        this.m_waitCount = 0;
        this.m_attackPoint = 5;
        this.m_destPosX = 0;
        this.m_destPosY = 0;
        this.m_Palette = this.m_hp < 70 ? 0 : 1;
        short s = this.m_Parameters[1];
        this.setFrisianWait(s);
        this.setFlag(4096, false);
        if (s == 3 && bl) {
            CActor.m_frisianLeader = this;
            this.m_weaponID = this.clone(21, CActor.m_hero.m_mapX, CActor.m_hero.m_mapY, 0, 11);
        }
    }

    void updateFrisianAI() {
        int n;
        int n2;
        int n3;
        --this.m_waitTime;
        short s = this.m_Parameters[1];
        boolean bl = this.canSeeHero();
        this.calcHorizontalPositionToHero();
        if (s != 0 && this.IsAlive() && bl) {
            this.SetAsHeroCombatActor();
        }
        this.setFrisianDirection();
        this.checkAvailableAction();
        int n4 = this.getAttackedHurt();
        if (s == 3 && CGame.s_difficult >= 2) {
            n4 -= n4 >> 1;
        }
        this.clearAttackedInfo();
        boolean bl2 = false;
        if (n4 >= this.m_Parameters[0]) {
            bl2 = true;
        }
        if (n4 > 0) {
            if ((this.m_actionID == 24 || this.m_actionID == 21 || this.m_actionID == 23 || this.m_actionID == 22 || this.m_actionID == 33 || this.m_actionID == 27 || this.m_actionID == 28 && this.m_currAFrame < 8) && !CActor.m_hero.isUsingHO() && !CActor.m_hero.isSmashing() && CActor.m_hero.m_actionID != 30) {
                CActor.m_hero.attackWhenGuard(this);
            }
            if (this.canFrisianGetHurt()) {
                this.setHurt(n4);
                if (this.m_actionID == 13) {
                    return;
                }
                if (bl2) {
                    CGame.PlaySound(6);
                    this.setAction(18);
                    this.m_vX = this.m_mapX < CActor.m_hero.m_mapX ? -3840 : 3840;
                    this.m_vY = 1280;
                    return;
                }
                if (this.IsAlive()) {
                    if (CActor.m_hero.isSmashing()) {
                        this.setAction(31);
                    } else if (this.m_hp > this.m_Parameters[0] / 2) {
                        this.setAction(4);
                    } else {
                        n3 = CActor.m_hero.canViolentlyKill(this);
                        if (n3 != 0) {
                            this.setViolentlyBeKilled(n3);
                        } else {
                            this.setAction(4);
                        }
                    }
                } else {
                    CGame.PlaySound(6);
                    this.setAction(5);
                }
            }
        }
        if ((!CActor.m_hero.isCatching() || this.m_actionID != 10) && CActor.m_hero.canBeAttackedBy(this)) {
            CActor.m_hero.setAttacked(this.getAttackPoint(), this.testFlag(1));
        }
        if (this.m_actionID == 10 && this.testFlag(65536)) {
            for (n2 = 0; n2 < CActor.s_EnemyActorCount; ++n2) {
                CActor cActor = CActor.s_EnemyActor[n2];
                if (cActor == this || !CActor.isCollide(this.m_attackBox, cActor.m_collisionBox)) continue;
                n = this.m_realX - cActor.m_realX < 0 ? 1 : 0;
                cActor.setAttacked(cActor.m_hp, n != 0);
            }
        }
        switch (this.m_actionID) {
            case 0: 
            case 20: 
            case 26: {
                if (this.m_waitTime >= 0 || !bl) break;
                this.setFrisianAware();
                break;
            }
            case 1: {
                if (!this.testFlag(16)) break;
                this.setAction(this.m_waitCount == 0 ? 2 : 3);
                this.m_waitTime = 4;
                break;
            }
            case 2: 
            case 3: {
                if (this.m_waitTime == 0) {
                    n3 = this.m_mapY;
                    CActor cActor = this.clone(45, this.m_mapX, n3 += this.m_waitCount == 0 ? -58 : -27, 16);
                    if (cActor != null) {
                        if (this.m_isLeftToHero) {
                            cActor.setFlag(1, true);
                        }
                        cActor.m_vX = this.m_isLeftToHero ? 1280 : -1280;
                        cActor.setFlag(64, true);
                    }
                    int n5 = this.m_waitCount = this.m_waitCount == 0 ? 1 : 0;
                }
                if (!this.testFlag(16)) break;
                this.m_waitTime = 30;
                this.setFrisianWait(s);
                break;
            }
            case 4: {
                if (!this.testFlag(16)) break;
                this.setFrisianWait(s);
                break;
            }
            case 5: 
            case 15: 
            case 18: {
                if (this.m_currAFrame == 0 && s == 3) {
                    CGame.clearBossHpBar();
                }
                if (!this.testFlag(16)) break;
                this.m_actorStatus = 4;
                this.setFlag(4096, true);
                this.setFlag(64, false);
                if (CHero.s_actorToBeBeviolentlyKilled == this) {
                    CHero.s_actorToBeBeviolentlyKilled = null;
                }
                CActor.m_hero.addScore(this);
                if (s != 3) break;
                CActor.s_actors[this.m_weaponID].invalidateActor();
                break;
            }
            case 8: 
            case 9: {
                if (!this.testFlag(16)) break;
                n3 = this.testFlag(1) ^ (this.m_actionID == 8 ? 1 : 0);
                this.setActionWithCollision(10, 0, 3);
                this.m_vX = n3 != 0 ? -3840 : 3840;
                this.m_vY = -4608;
                this.m_aY = 1536;
                if (CHero.s_actorToBeBeviolentlyKilled != this) break;
                CHero.s_actorToBeBeviolentlyKilled = null;
                break;
            }
            case 10: {
                if (!this.m_canRun || this.m_collisionBox[0] < CGame.m_cameraLeftLimit || this.m_collisionBox[2] > CGame.m_cameraRightLimit + 240) {
                    this.m_vX = 0;
                }
                if (!this.m_canStand) break;
                this.setActionWithCollision(11, -1, 3);
                CHero.m_cameraShakingTimer = 5;
                CHero.m_cameraYShakingExtent = 4;
                break;
            }
            case 11: {
                if (!this.testFlag(16)) break;
                this.m_hp -= 10;
                if (this.IsAlive()) {
                    this.setAction(12);
                    break;
                }
                this.setAction(5);
                break;
            }
            case 12: 
            case 32: {
                if (!this.testFlag(16)) break;
                this.setFrisianWait(s);
                break;
            }
            case 6: {
                if (!this.testFlag(16)) break;
                this.setAction(7);
                break;
            }
            case 13: {
                if (!this.testFlag(16)) break;
                this.setAction(7);
                break;
            }
            case 14: {
                if (!this.testFlag(16) || !this.m_canStand) break;
                this.setFrisianWait(s);
                if (CHero.s_actorToBeBeviolentlyKilled != this) break;
                CHero.s_actorToBeBeviolentlyKilled = null;
                break;
            }
            case 21: {
                if (!this.testFlag(16)) break;
                if (this.m_distanceToHero > 10 && this.m_canGo) {
                    this.setAction(22);
                    this.m_vX = this.m_isLeftToHero ? 1536 : -1536;
                    this.m_aX = this.m_isLeftToHero ? 768 : -768;
                    break;
                }
                this.setAction(24);
                CHero.m_cameraShakingTimer = 5;
                CHero.m_cameraYShakingExtent = 4;
                break;
            }
            case 22: {
                if (!this.m_canGo) {
                    this.setFrisianWait(s);
                }
                if (this.m_distanceToHero >= 30) break;
                this.setFlag(128, true);
                this.setAction(23);
                break;
            }
            case 23: {
                if (this.m_distanceToHero < 10) {
                    this.m_vX = 0;
                    this.m_aX = 0;
                }
                if (!this.testFlag(16)) break;
                this.setAction(24);
                CHero.m_cameraShakingTimer = 5;
                CHero.m_cameraYShakingExtent = 4;
                break;
            }
            case 24: {
                if (!this.testFlag(16)) break;
                this.setAction(25);
                break;
            }
            case 25: {
                if (!this.testFlag(16)) break;
                this.setFrisianWait(s);
                this.m_waitTime = 10;
                break;
            }
            case 27: {
                if (!this.testFlag(16)) break;
                this.setAction(28);
                this.m_aY = 1536;
                this.m_vY = -8960;
                if (this.m_destPosX > 0) {
                    n3 = Math.abs(this.m_destPosX - this.m_mapX);
                    if (n3 > 24) {
                        this.m_vX = Math.abs((n3 << 8) * this.m_aY / (this.m_vY * 2));
                        this.m_vX = this.m_mapX < this.m_destPosX ? this.m_vX : -this.m_vX;
                        break;
                    }
                    this.m_destPosX = 0;
                    this.m_destPosY = 0;
                    n2 = CActor.m_hero.m_mapY - this.m_mapY;
                    if (n2 < -120) {
                        this.m_vX = 2048;
                        this.m_vX = this.m_isLeftToHero ? this.m_vX : -this.m_vX;
                        this.m_vY = -13312;
                        break;
                    }
                    if (n2 <= 120 || (n = this.getTheOtherUpperWayPointX()) <= 0) break;
                    this.m_vX = 2048;
                    this.m_vX = n > this.m_mapX ? this.m_vX : -this.m_vX;
                    this.m_vY = -8704;
                    break;
                }
                if (this.m_distanceToHero <= 20 || !this.m_canGo) break;
                this.m_vX = Math.abs((this.m_distanceToHero - 10 << 8) * this.m_aY / (this.m_vY * 2));
                this.m_vX = this.m_isLeftToHero ? this.m_vX : -this.m_vX;
                break;
            }
            case 28: {
                if (!this.m_canStand) break;
                this.setFlag(128, true);
                this.setAction(29);
                break;
            }
            case 29: {
                if (!this.testFlag(16)) break;
                this.setAction(30);
                CHero.m_cameraShakingTimer = 5;
                CHero.m_cameraYShakingExtent = 4;
                break;
            }
            case 30: {
                if (!this.testFlag(16)) break;
                this.setFrisianWait(s);
                this.m_waitTime = 10;
                break;
            }
            case 31: {
                if (!this.testFlag(16)) break;
                if (this.IsAlive()) {
                    this.setAction(32);
                    break;
                }
                this.setAction(5);
                break;
            }
            case 33: {
                if (!this.testFlag(16)) break;
                this.setFrisianWait(s);
                this.m_waitTime = 10;
                break;
            }
            case 36: {
                CActor cActor;
                if (this.m_waitTime == 0 && (cActor = this.clone(45, this.m_mapX + (this.testFlag(1) ? 20 : -20), this.m_mapY, 35)) != null) {
                    if (this.m_isLeftToHero) {
                        cActor.setFlag(1, true);
                    }
                    cActor.m_vX = this.m_isLeftToHero ? 2048 : -2048;
                    cActor.setFlag(64, true);
                }
                if (!this.testFlag(16)) break;
                this.setFrisianWait(s);
                this.m_waitTime = 10;
            }
        }
    }

    void updateFrisianPosition() {
        if (!this.m_canStand) {
            if (CHero.s_actorToBeBeviolentlyKilled != this || !CActor.m_hero.isCatching()) {
                this.m_aY = 1536;
            }
        } else if (this.m_vY > 0) {
            this.m_aY = 0;
            this.m_vY = 0;
            this.m_vX = 0;
        }
        this.limitFrisianPosition();
    }

    void limitFrisianPosition() {
        int n = this.m_mapX;
        int n2 = CGame.m_cameraRightLimit + 240;
        int n3 = CGame.m_cameraLeftLimit;
        if (this.m_collisionBox[2] > n2) {
            n = n2 - (this.m_collisionBox[2] - this.m_mapX);
        }
        if (this.m_collisionBox[0] < n3) {
            n = this.m_mapX - this.m_collisionBox[0] + n3;
        }
        this.setMapPosition(n, this.m_mapY);
    }

    void calculateDestPosition() {
        CActor[] cActorArray = new CActor[]{CActor.s_actors[this.m_Parameters[2]], CActor.s_actors[this.m_Parameters[3]], CActor.s_actors[this.m_Parameters[4]]};
        for (int i = 0; i < 3; ++i) {
            int n = Math.abs(cActorArray[i].m_mapY - this.m_mapY);
            if (n >= 24) continue;
            if (this.m_destPosX > 0 && this.m_destPosY > 0) {
                if (Math.abs(cActorArray[i].m_mapX - this.m_mapX) >= Math.abs(this.m_destPosX - this.m_mapX)) continue;
                this.m_destPosX = cActorArray[i].m_mapX;
                this.m_destPosY = cActorArray[i].m_mapY;
                continue;
            }
            this.m_destPosX = cActorArray[i].m_mapX;
            this.m_destPosY = cActorArray[i].m_mapY;
        }
    }

    int getTheOtherUpperWayPointX() {
        CActor[] cActorArray = new CActor[]{CActor.s_actors[this.m_Parameters[2]], CActor.s_actors[this.m_Parameters[3]], CActor.s_actors[this.m_Parameters[4]]};
        for (int i = 0; i < 3; ++i) {
            int n = Math.abs(cActorArray[i].m_mapY - this.m_mapY);
            if (n >= 24 || Math.abs(cActorArray[i].m_mapX - this.m_mapX) <= 24) continue;
            return cActorArray[i].m_mapX;
        }
        return -1;
    }

    void setFrisianWait(int n) {
        if (n == 0) {
            this.setAction(0);
        } else if (n == 1) {
            this.setAction(20);
        } else if (n == 2) {
            this.setAction(26);
        } else {
            if (Math.abs(CActor.m_hero.m_mapY - this.m_mapY) > 120) {
                this.calculateDestPosition();
            } else {
                this.m_destPosX = 0;
            }
            this.setAction(26);
        }
    }

    void setFrisianAware() {
        short s = this.m_Parameters[1];
        if (s == 3) {
            if (this.m_destPosX > 0) {
                this.setAction(27);
            } else {
                int n = CGame.Random(0, 99);
                if (this.m_distanceToHero < 80) {
                    if (n > 49) {
                        this.setAction(33);
                    } else {
                        this.setAction(27);
                    }
                } else if (n > 49) {
                    this.setAction(27);
                } else {
                    this.setAction(36);
                    this.m_waitTime = 8;
                }
            }
        } else if (this.m_actionID == 0) {
            this.setAction(1);
        } else if (this.m_actionID == 20) {
            this.setAction(21);
        } else if (this.m_actionID == 26) {
            this.setAction(27);
        }
    }

    boolean canFrisianGetHurt() {
        if (this.m_actionID == 5 || this.m_actionID == 4 || this.m_actionID == 18) {
            return false;
        }
        if (CActor.m_hero.isUsingHO() || CActor.m_hero.isSmashing() || CActor.m_hero.m_actionID == 30) {
            return true;
        }
        return this.m_actionID != 6 && this.m_actionID != 7 && this.m_actionID != 14 && this.m_actionID != 8 && this.m_actionID != 9 && this.m_actionID != 15 && this.m_actionID != 18 && this.m_actionID != 24 && this.m_actionID != 21 && this.m_actionID != 23 && this.m_actionID != 22 && this.m_actionID != 27 && this.m_actionID != 33 && (this.m_actionID != 28 || this.m_currAFrame >= 8);
    }

    void setFrisianDirection() {
        if (this.m_actionID != 3 && this.m_actionID != 2 && this.m_actionID != 4 && this.m_actionID != 24 && this.m_actionID != 23 && this.m_actionID != 25 && this.m_actionID != 30 && this.m_actionID != 28 && this.m_actionID != 29 && this.m_actionID != 5 && (this.m_actionID < 6 || this.m_actionID > 15)) {
            int n = Math.abs(this.m_destPosX - this.m_mapX);
            if (this.m_destPosX > 0 && n >= 24) {
                this.setFlag(1, this.m_mapX < this.m_destPosX);
            } else if (this.m_destPosX > 0 && n < 24 && CActor.m_hero.m_mapY - this.m_mapY > 120) {
                int n2 = this.getTheOtherUpperWayPointX();
                if (n2 > 0) {
                    this.setFlag(1, n2 > this.m_mapX);
                }
            } else {
                this.setFlag(1, this.m_isLeftToHero);
            }
        }
    }

    void initMother() {
        this.m_waitCount = 0;
        this.m_waitTime = 0;
        this.m_attackIdleCount = 0;
        this.m_hp = this.m_Parameters[4];
    }

    void motherDie() {
        CGame.clearBossHpBar();
        this.setAction(13);
        CActor.m_hero.addScore(this);
        this.setFlag(4096, true);
        this.setFlag(64, false);
        if (CHero.s_actionActor == this) {
            CHero.s_actionActor = null;
            CActor.m_hero.setAction(0);
        }
    }

    void updateMother() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        short s = this.m_Parameters[0];
        short s2 = this.m_Parameters[1];
        if (this.m_hp > 0 && this.m_actionID != 13) {
            n5 = 1;
            n4 = this.m_mapX;
            n3 = CActor.m_hero.m_mapX;
            n2 = this.m_mapY;
            n = CActor.m_hero.m_mapY;
            if (CGame.getDistance(n4 - n3, n2 - n) > 228) {
                n5 = 0;
            }
            if (n5 != 0) {
                this.SetAsHeroCombatActor();
            }
        }
        n5 = this.getAttackedHurt();
        if (s == 2 && CGame.s_difficult >= 2) {
            n5 -= n5 >> 1;
        }
        this.clearAttackedInfo();
        if (n5 > 0 && this.m_hp > 0 && this.m_actionID != 5 && this.m_actionID != 10 && this.m_actionID != 6 && this.m_actionID != 7 && this.m_actionID != 11) {
            this.setHurt(n5);
            if (this.IsAlive()) {
                this.m_attackIdleCount += n5;
                this.setAction(5);
            } else {
                this.motherDie();
            }
        }
        switch (this.m_actionID) {
            case 0: {
                if (this.testFlag(256)) {
                    this.setRealPosition(this.m_realX + this.m_vX, this.m_realY + this.m_vY);
                    n4 = this.m_Parameters[5];
                    if (Math.abs(CActor.s_actors[n4].m_realX - this.m_realX) > Math.abs(this.m_vX) || Math.abs(CActor.s_actors[n4].m_realY - this.m_realY) > Math.abs(this.m_vY)) break;
                    this.setFlag(256, false);
                    this.m_actorStatus = 4;
                    this.setFlag(4096, true);
                    this.setFlag(64, false);
                    break;
                }
                this.setFaceTo(CActor.m_hero);
                if (this.m_waitTime++ <= 15) break;
                this.m_waitTime = 0;
                if (s == 0) {
                    this.setAction(3);
                    break;
                }
                if (s == 1) {
                    this.setAction(1);
                    break;
                }
                if (s != 2) break;
                if (this.m_waitCount > 0 && this.m_waitCount <= this.getMotherBossBallNum() - 1 || CGame.Random(0, 1) == 0) {
                    this.setAction(this.m_hp >= this.m_Parameters[4] ? 3 : 12);
                    break;
                }
                this.setAction(1);
                break;
            }
            case 3: {
                if (!this.testFlag(16)) break;
                this.setAction(4);
                if (CActor.m_hero.m_canStand && s != 2) {
                    n4 = this.m_Parameters[2];
                    n2 = this.m_Parameters[3];
                    n3 = this.m_mapX;
                    n = this.m_mapX;
                    int n6 = this.m_mapY;
                    if (n4 >= 0) {
                        n3 = CActor.s_actors[n4].m_mapX;
                        n6 = CActor.s_actors[n4].m_mapY;
                    }
                    if (n2 >= 0) {
                        n = CActor.s_actors[n2].m_mapX;
                    }
                    int n7 = CGame.Random(n3, n);
                    CActor cActor = this.clone(52, this.m_mapX + (this.testFlag(1) ? -15 : 15), this.m_mapY + -45, 8);
                    int n8 = (n7 << 8) - cActor.m_realX;
                    int n9 = (n6 << 8) - cActor.m_realY;
                    cActor.m_vX = n8 / 10;
                    cActor.m_vY = n9 / 10;
                    cActor.m_state = this.m_actorID;
                } else {
                    CActor cActor = this.clone(52, this.m_mapX + (this.testFlag(1) ? -15 : 15), this.m_mapY + -45, 8);
                    n2 = CActor.m_hero.m_realX - cActor.m_realX;
                    n3 = CActor.m_hero.m_realY - cActor.m_realY;
                    cActor.m_vX = n2 / 10;
                    cActor.m_vY = n3 / 10;
                    cActor.m_state = this.m_actorID;
                    if (s == 2 && this.m_waitCount++ >= this.getMotherBossBallNum() - 1) {
                        this.m_waitCount = 0;
                    }
                }
                if (s == 2 || s2 <= 0 || ++this.m_waitCount < s2) break;
                this.m_waitCount = 0;
                this.motherFlyAway();
                break;
            }
            case 12: {
                if (!this.testFlag(16)) break;
                CActor cActor = null;
                for (n2 = 0; n2 < 2; ++n2) {
                    n3 = n2 == 0 ? 15 : -15;
                    n = n2 == 0 ? -45 : -45;
                    cActor = this.clone(52, this.m_mapX + (this.testFlag(1) ? -n3 : n3), this.m_mapY + n, 8);
                    int n10 = CActor.m_hero.m_realX - cActor.m_realX;
                    int n11 = CActor.m_hero.m_realY - cActor.m_realY;
                    cActor.m_vX = n10 / 10;
                    cActor.m_vY = n11 / 10;
                    cActor.m_state = this.m_actorID;
                }
                if (this.m_waitCount++ >= this.getMotherBossBallNum() - 1) {
                    this.m_waitCount = 0;
                    this.setAction(4);
                    break;
                }
                this.setAction(0);
                break;
            }
            case 4: {
                if (!this.testFlag(16)) break;
                if (s == 2) {
                    this.setAction(6);
                    break;
                }
                this.setAction(0);
                break;
            }
            case 5: {
                if (!this.testFlag(16)) break;
                if (this.m_prevActionID == 2) {
                    CActor.m_hero.stopBlow();
                }
                if (s != 2) {
                    this.motherFlyAway();
                    break;
                }
                if (this.m_attackIdleCount >= this.m_Parameters[4] / 5) {
                    this.m_attackIdleCount = 0;
                    this.setAction(10);
                    break;
                }
                this.setAction(0);
                break;
            }
            case 1: {
                if (!this.testFlag(16)) break;
                this.setAction(2);
                this.m_waitTime = 0;
                CHero.s_blowDir = this.testFlag(1) ? 1 : -1;
                CHero.s_blowedTimer = 0;
                CHero.s_blowSpeed = 512;
                break;
            }
            case 2: {
                if (this.m_waitTime++ <= 40) break;
                this.m_waitTime = 0;
                CActor.m_hero.stopBlow();
                if (s != 2 && s2 > 0 && ++this.m_waitCount >= s2) {
                    this.m_waitCount = 0;
                    this.motherFlyAway();
                    break;
                }
                if (s == 2) {
                    this.setAction(6);
                    break;
                }
                this.setAction(0);
                break;
            }
            case 6: {
                if (!this.testFlag(16)) break;
                this.m_waitTime = 0;
                this.setAction(11);
                break;
            }
            case 11: {
                if (this.m_waitTime++ <= this.getMotherBossInvisibleTime()) break;
                this.m_waitTime = 0;
                this.setAction(7);
                n4 = this.findMothrBossAimToGo();
                if (n4 < 0) break;
                this.setMapPosition(CActor.s_actors[n4].m_mapX, CActor.s_actors[n4].m_mapY);
                break;
            }
            case 7: {
                if (!this.testFlag(16)) break;
                if (this.m_waitCount++ >= this.getMotherBossTransCount() - 1) {
                    this.m_waitCount = 0;
                    this.setAction(0);
                    break;
                }
                this.setAction(6);
                break;
            }
            case 10: {
                if (!this.testFlag(16)) break;
                this.setAction(6);
            }
        }
    }

    private void motherFlyAway() {
        short s = this.m_Parameters[5];
        if (s >= 0) {
            this.setAction(0);
            int n = CActor.s_actors[s].m_realX - this.m_realX;
            int n2 = CActor.s_actors[s].m_realY - this.m_realY;
            this.m_vX = n / 15;
            this.m_vY = n2 / 15;
            this.setFlag(256, true);
        }
    }

    private int getMotherBossBallNum() {
        short s = this.m_Parameters[4];
        if (this.m_hp >= s * 2 / 3) {
            return 1;
        }
        return 2;
    }

    private int getMotherBossInvisibleTime() {
        short s = this.m_Parameters[4];
        if (this.m_hp >= s * 2 / 3) {
            return 10;
        }
        if (this.m_hp >= s / 3) {
            return 5;
        }
        return 2;
    }

    private int getMotherBossTransCount() {
        short s = this.m_Parameters[4];
        if (this.m_hp >= s * 2 / 3) {
            return 1;
        }
        if (this.m_hp >= s / 3) {
            return 2;
        }
        return 3;
    }

    private int findMothrBossAimToGo() {
        int n = this.m_Parameters[2];
        int n2 = this.m_Parameters[3];
        int n3 = this.m_Parameters[5];
        int n4 = -1;
        int n5 = CGame.Random(0, 2);
        if (n5 == 0) {
            n4 = n;
            if (n < 0 || CActor.s_actors[n].m_mapX == this.m_mapX && CActor.s_actors[n].m_mapY == this.m_mapY) {
                return CGame.Random(0, 1) == 0 ? n2 : n3;
            }
        } else if (n5 == 1) {
            n4 = n2;
            if (n2 < 0 || CActor.s_actors[n2].m_mapX == this.m_mapX && CActor.s_actors[n2].m_mapY == this.m_mapY) {
                return CGame.Random(0, 1) == 0 ? n : n3;
            }
        } else {
            n4 = n3;
            if (n3 < 0 || CActor.s_actors[n3].m_mapX == this.m_mapX && CActor.s_actors[n3].m_mapY == this.m_mapY) {
                return CGame.Random(0, 1) == 0 ? n : n2;
            }
        }
        return n4;
    }

    void initGoldDragon() {
        this.m_waitCount = 0;
        this.m_waitTime = 0;
        this.m_hp = this.m_Parameters[2];
        if (this.m_Parameters[0] == 1) {
            this.m_z = 90;
        }
        this.m_offset = 0;
    }

    void updateGoldDragon() {
        short s = this.m_Parameters[0];
        switch (s) {
            case 0: {
                this.updateGoldDragonAI_FireHead();
                break;
            }
            case 1: {
                this.updateGoldDragonAI_FireHeadFar();
                break;
            }
            case 3: {
                this.updateGoldDragonAI_Boss();
            }
        }
    }

    void updateGoldDragonAI_FireHead() {
        short s = this.m_Parameters[1];
        switch (this.m_actionID) {
            case 0: {
                int n = this.m_vX = this.testFlag(1) ? 1280 : -1280;
                if (this.testFlag(256)) {
                    this.m_vY = -2048;
                    if (this.m_waitTime++ <= 25) break;
                    this.setFlag(256, false);
                    this.m_actorStatus = 4;
                    this.setFlag(64, false);
                    this.setFlag(4096, true);
                    break;
                }
                if (this.m_waitTime++ <= 15) break;
                this.m_waitTime = 10;
                this.setAction(6);
                break;
            }
            case 6: {
                if (this.canPullCamera()) {
                    this.SetAsHeroCombatActor();
                }
                int n = this.m_vX = this.testFlag(1) ? 1792 : -1792;
                if (this.m_waitTime++ <= 10) break;
                this.m_waitTime = 0;
                if (this.m_waitCount >= s) {
                    this.m_waitCount = 0;
                    this.setAction(0);
                    this.setFlag(256, true);
                    break;
                }
                CActor cActor = this.clone(57, this.m_mapX, this.m_mapY, 3);
                cActor.m_vX = (this.testFlag(1) ? 1 : -1) * CGame.Random(0, 1536) + this.m_vX;
                cActor.m_vY = 3072;
                ++this.m_waitCount;
            }
        }
        this.setRealPosition(this.m_realX + this.m_vX, this.m_realY + this.m_vY);
    }

    void updateGoldDragonAI_FireHeadFar() {
        short s = this.m_Parameters[1];
        switch (this.m_actionID) {
            case 7: {
                int n = this.m_vX = this.testFlag(1) ? 1024 : -1024;
                if (this.testFlag(256)) {
                    this.m_vY = -2048;
                    if (this.m_waitTime++ <= 25) break;
                    this.setFlag(256, false);
                    this.m_actorStatus = 4;
                    this.setFlag(64, false);
                    this.setFlag(4096, true);
                    break;
                }
                if (this.m_waitTime++ <= 15) break;
                this.m_waitTime = 30;
                this.setAction(10);
                break;
            }
            case 10: {
                if (this.canPullCamera()) {
                    this.SetAsHeroCombatActor();
                }
                int n = this.m_vX = this.testFlag(1) ? 1024 : -1024;
                if (this.m_waitTime++ <= 30) break;
                this.m_waitTime = 0;
                if (this.m_waitCount >= s) {
                    this.m_waitCount = 0;
                    this.setAction(7);
                    this.setFlag(256, true);
                    break;
                }
                CActor cActor = this.clone(57, this.m_mapX, this.m_mapY, 2);
                cActor.m_vX = (this.testFlag(1) ? 1 : -1) * CGame.Random(512, 2048) + this.m_vX;
                cActor.m_vY = 1280;
                ++this.m_waitCount;
            }
        }
        this.setRealPosition(this.m_realX + this.m_vX, this.m_realY + this.m_vY);
    }

    void updateGoldDragonAI_Boss() {
        int n = this.getAttackedHurt();
        if (CGame.s_difficult >= 2) {
            n -= n >> 1;
        }
        this.clearAttackedInfo();
        if (this.m_offset > 0) {
            --this.m_offset;
        }
        if (n > 0 && this.m_hp > 0 && this.m_offset == 0 && this.m_actionID != 5) {
            this.setHurt(n);
            this.m_offset = 8;
            if (this.IsAlive()) {
                if (this.m_actionID == 0 || this.m_actionID == 6) {
                    this.setAction(5);
                }
            } else {
                if (this.m_state == 2) {
                    CActor.m_hero.setAction(8);
                    CActor.m_hero.m_aY = 1792;
                    CHero.s_actionActor = null;
                }
                if (this.m_actionID != 8) {
                    this.setAction(1);
                }
                this.m_state = 4;
                this.m_z = CActor.s_classesDefaultZ[this.m_classID];
                CActor.m_hero.addScore(this);
            }
        }
        if (this.m_actionID == 5) {
            if (this.testFlag(16)) {
                if (this.m_state == 1 && this.m_prevActionID == 6) {
                    this.setAction(0);
                } else {
                    this.setAction(this.m_prevActionID);
                }
            }
            return;
        }
        switch (this.m_state) {
            case 0: {
                if (this.m_actionID == 0) {
                    int n2 = this.m_vX = this.testFlag(1) ? 1280 : -1280;
                    if (this.m_waitCount < this.m_Parameters[1] && this.m_waitTime++ > 20) {
                        this.m_waitTime = 0;
                        CActor cActor = this.clone(57, this.m_mapX, this.m_mapY, 3);
                        cActor.m_vX = (this.testFlag(1) ? 1 : -1) * CGame.Random(0, 1536) + this.m_vX;
                        cActor.m_vY = 3072;
                        ++this.m_waitCount;
                        this.setAction(6);
                    }
                    if (this.isGoldDragonBossArriveAim()) {
                        this.m_waitCount = 0;
                        if (this.testFlag(256)) {
                            this.setFlag(256, false);
                            this.setAction(1);
                        } else {
                            this.setAction(11);
                        }
                    }
                } else if (this.m_actionID == 6) {
                    int n3 = this.m_vX = this.testFlag(1) ? 1280 : -1280;
                    if (this.testFlag(16)) {
                        this.setAction(0);
                    }
                    if (this.isGoldDragonBossArriveAim()) {
                        this.m_waitCount = 0;
                        if (this.testFlag(256)) {
                            this.setFlag(256, false);
                            this.setAction(1);
                        } else {
                            this.setAction(11);
                        }
                    }
                } else if (this.m_actionID == 11) {
                    if (this.testFlag(16)) {
                        this.setAction(0);
                        this.setFlag(1, !this.testFlag(1));
                        this.setFlag(256, true);
                    }
                } else if (this.m_actionID == 1) {
                    if (this.testFlag(16)) {
                        this.setFlag(1, !this.testFlag(1));
                        this.setAction(2);
                        this.m_state = 1;
                    }
                } else if (this.m_actionID == 8) {
                    if (this.testFlag(16)) {
                        short s = this.m_Parameters[3];
                        if (s >= 0) {
                            this.setMapPosition(CActor.s_actors[s].m_mapX, CActor.s_actors[s].m_mapY);
                        }
                        this.setAction(2);
                        this.setFlag(1, true);
                    }
                } else if (this.m_actionID == 2 && this.testFlag(16)) {
                    this.setAction(0);
                }
                this.setRealPosition(this.m_realX + this.m_vX, this.m_realY + this.m_vY);
                break;
            }
            case 1: {
                if (this.canPullCamera()) {
                    this.SetAsHeroCombatActor();
                }
                if (this.m_actionID == 2) {
                    if (!this.testFlag(16)) break;
                    this.setAction(0);
                    CHero.s_decorationID = this.clone(5, this.m_mapX + 60, this.m_mapY + -70, 0, 25);
                    break;
                }
                if (this.m_actionID == 0) {
                    if (this.m_waitTime++ > 10) {
                        this.m_waitTime = 0;
                        CActor cActor = this.clone(57, this.m_mapX, this.m_mapY, 3);
                        cActor.m_vX = (this.testFlag(1) ? 1 : -1) * CGame.Random(2048, 6400) + this.m_vX;
                        cActor.m_vY = 3072;
                        ++this.m_waitCount;
                        this.setAction(6);
                    }
                } else if (this.m_actionID == 6 && this.testFlag(16)) {
                    this.setAction(0);
                }
                this.getCollisionBox();
                if (CActor.m_hero.m_mapY >= this.m_mapY || CActor.m_hero.m_actionID != 8 || !CActor.m_hero.isTriggeredByHero(this.m_collisionBox, true)) break;
                if (CHero.s_decorationID != -1) {
                    CActor.s_actors[CHero.s_decorationID].invalidateActor();
                    CHero.s_decorationID = -1;
                }
                this.m_state = 2;
                this.setAction(12);
                this.m_waitTime = 0;
                this.m_waitCount = 0;
                CHero.s_actionActor = this;
                CActor.m_hero.setAction(141);
                CActor.m_hero.setFaceTo(this);
                CActor.m_hero.setMapPosition(this.m_mapX, this.m_mapY);
                break;
            }
            case 2: {
                if (this.m_actionID == 12) {
                    if (this.m_waitTime++ <= 20) break;
                    this.m_waitTime = 0;
                    this.setAction(14);
                    CActor.m_hero.setAction(143);
                    this.m_vY = -2560;
                    this.m_attackIdleCount = 0;
                    CHero.s_decorationID = this.clone(5, this.m_mapX + 0, this.m_mapY + -70, 0, CGame.Random(0, 1) == 0 ? 8 : 10);
                    break;
                }
                if (this.m_actionID == 13) {
                    if (!this.testFlag(16) || !this.IsAlive()) break;
                    this.setAction(12);
                    break;
                }
                if (this.m_actionID == 14) {
                    this.setRealPosition(this.m_realX, this.m_realY + this.m_vY);
                    CActor.m_hero.setMapPosition(this.m_mapX, this.m_mapY);
                    if (CHero.s_decorationID >= 0) {
                        CActor.s_actors[CHero.s_decorationID].setMapPosition(this.m_mapX + 0, this.m_mapY + -70);
                    }
                    if (++this.m_attackIdleCount > 10) {
                        this.m_vY = -this.m_vY;
                        this.m_attackIdleCount = 0;
                        if (this.m_vY < 0 && this.testFlag(256)) {
                            this.setFlag(256, false);
                            if (++this.m_waitCount > 2) {
                                this.m_waitCount = 0;
                                this.setAction(1);
                                this.m_state = 3;
                                this.m_z = 90;
                                CActor.m_hero.setAction(8);
                                CActor.m_hero.m_aY = 1792;
                                CHero.s_actionActor = null;
                                break;
                            }
                            this.setAction(12);
                            CActor.m_hero.setAction(141);
                            this.m_waitTime = 0;
                            break;
                        }
                    }
                    if (this.m_waitTime++ <= 20 || this.testFlag(256)) break;
                    this.m_waitTime = 0;
                    this.setAction(15);
                    CActor.m_hero.setAction(144);
                    CActor.m_hero.m_vY = -5632;
                    CActor.m_hero.m_aY = 256;
                    CHero.s_actionActor = null;
                    CActor.s_actors[CHero.s_decorationID].invalidateActor();
                    CHero.s_decorationID = -1;
                    break;
                }
                if (this.m_actionID != 15 || !this.testFlag(16)) break;
                this.setAction(1);
                this.m_state = 3;
                this.m_z = 90;
                short s = this.m_Parameters[3];
                if (s < 0) break;
                this.setMapPosition(this.m_mapX, CActor.s_actors[s].m_mapY);
                break;
            }
            case 3: {
                if (this.canPullCamera()) {
                    this.SetAsHeroCombatActor();
                }
                if (this.m_actionID == 1) {
                    if (!this.testFlag(16)) break;
                    this.setAction(9);
                    break;
                }
                if (this.m_actionID == 9) {
                    if (!this.testFlag(16)) break;
                    this.m_waitTime = 0;
                    this.setAction(7);
                    break;
                }
                if (this.m_actionID == 7) {
                    int n4 = this.m_vX = this.testFlag(1) ? 1024 : -1024;
                    if (this.isGoldDragonBossArriveAim()) {
                        this.setFlag(1, !this.testFlag(1));
                    } else if (this.m_waitTime++ > 30) {
                        this.m_waitTime = 0;
                        this.setAction(10);
                    }
                    this.setRealPosition(this.m_realX + this.m_vX, this.m_realY + this.m_vY);
                    if (!this.isGoldDragonBossBeAttackByBall()) break;
                    this.setAction(8);
                    this.m_state = 0;
                    this.m_z = CActor.s_classesDefaultZ[this.m_classID];
                    this.setAttacked(40, false);
                    break;
                }
                if (this.m_actionID != 10) break;
                this.m_vX = this.testFlag(1) ? 1024 : -1024;
                this.setRealPosition(this.m_realX + this.m_vX, this.m_realY + this.m_vY);
                if (this.testFlag(16)) {
                    CActor cActor = this.clone(57, this.m_mapX, this.m_mapY, 2);
                    cActor.m_vX = this.m_vX;
                    cActor.m_vY = 1280;
                    this.setAction(7);
                }
                if (!this.isGoldDragonBossBeAttackByBall()) break;
                this.setAction(8);
                this.m_state = 0;
                this.m_z = CActor.s_classesDefaultZ[this.m_classID];
                this.setAttacked(40, false);
                break;
            }
            case 4: {
                CGame.clearBossHpBar();
                if (!this.testFlag(16)) break;
                this.m_actorStatus = 4;
                this.setFlag(4096, true);
                this.setFlag(64, false);
                this.setFlag(8, false);
                this.m_state = 5;
            }
        }
    }

    private boolean isGoldDragonBossArriveAim() {
        int n;
        if (this.m_vX == 0) {
            return false;
        }
        int n2 = -1;
        n2 = this.m_vX > 0 ? this.m_Parameters[4] : this.m_Parameters[3];
        if (n2 < 0) {
            return false;
        }
        CActor cActor = CActor.s_actors[n2];
        int n3 = n = this.m_vX > 0 ? 1 : -1;
        if ((cActor.m_realX - this.m_realX) * n <= this.m_vX * n) {
            this.m_vX = 0;
            this.setMapPosition(cActor.m_mapX, this.m_mapY);
            return true;
        }
        return false;
    }

    private boolean isGoldDragonBossArriveAimH() {
        int n;
        if (this.m_vY == 0) {
            return false;
        }
        int n2 = -1;
        n2 = this.m_vY > 0 ? this.m_Parameters[4] : this.m_Parameters[3];
        if (n2 < 0) {
            return false;
        }
        CActor cActor = CActor.s_actors[n2];
        int n3 = n = this.m_vY > 0 ? 1 : -1;
        if ((cActor.m_realY - this.m_realY) * n <= this.m_vY * n) {
            this.m_vY = 0;
            this.setMapPosition(this.m_mapX, cActor.m_mapY);
            return true;
        }
        return false;
    }

    private boolean isGoldDragonBossBeAttackByBall() {
        if (CActor.s_steelBall == null || CActor.s_steelBall.m_actionID != 19 || CActor.s_steelBall.m_actorStatus == 4) {
            return false;
        }
        this.getCollisionBox();
        CActor.s_steelBall.getCollisionBox();
        return CActor.isCollide(CActor.s_steelBall.m_collisionBox, this.m_collisionBox);
    }
}

