/*
 * Decompiled with CFR 0.152.
 */
package z.playw.j2me;

import javax.microedition.lcdui.Graphics;
import z.playw.j2me.Const;
import z.playw.j2me.MainCanvas;
import z.playw.j2me.Sim;
import z.playw.j2me.util.FMath;
import z.playw.j2me.util.Utils;
import z.playw.j2me.util.ZedAnimation;

public class Car
implements Const {
    int hp;
    int maxHp;
    int[] half = new int[2];
    int weight;
    int fixBaseSpeedMax;
    int fixBaseAcc;
    int fixBaseAngleAcc;
    int posX;
    int posY;
    int angle;
    int speed;
    int[] fixPos = new int[2];
    int fixAngle;
    int fixAngleAcc;
    int fixSpeed;
    int fixSpeedMax;
    int fixAcc;
    ZedAnimation anim;
    int animId;
    int trans;
    public static final int DEFAULT_ENEMY_MAX_SPEED = FMath.fix(10);
    public static final int DEFAULT_ENEMY_ANG_ACC = FMath.fix(2);
    public static final int DEFAULT_MOVE_MAX_SPEED = FMath.fix(12);
    public static final int DEFAULT_ACC = 400;
    public static final int DEFAULT_ANG_ACC = FMath.fix(4);
    public static final int MODE0_DEC_SPEED = 200;
    public static final int MODE0_DEC_SPEED_EACH = 100;
    public static final int MODE1_DEC_SPEED = 700;
    public static final int MODE1_DEC_SPEED_EACH = 100;
    int fixSpeedX;
    int fixSpeedY;
    int fixLastSpeed;
    int fixLastAngle;
    boolean isBlink;
    long blinkToTime;
    public static final int UI_HP_WIDTH = 30;
    public static final int STATE_IDLE = 0;
    public static final int STATE_MOVE = 1;
    public static final int STATE_END = 2;
    public static final int STATE_COLLSION = 3;
    public static final int STATE_BACK_ROAD = 4;
    int state;
    boolean isPlayer;
    int aiMode;
    public static final int DECIDE_NONE = 0;
    public static final int DECIDE_COLL = 1;
    public static final int DECIDE_SPEED_UP = 2;
    public static final int DECIDE_WAITPLAYER = 3;
    int decision;
    long lastAvoidTime;
    int trgetAngle;
    public static final int LT = 0;
    public static final int LB = 1;
    public static final int RT = 2;
    public static final int RB = 3;
    int[][] carPoints = new int[4][2];
    public static final int COLL_HEAVY_SPEEDX = 1500;
    public static final int COLL_HEAVY_SPEEDY = 2000;
    public static final int COLL_SMALL_ANGLE0 = FMath.fix(5);
    public static final int COLL_SMALL_ANGLE1 = FMath.fix(10);
    public static final int COLL_BIG_ANGLE0 = FMath.fix(15);
    public static final int COLL_BIG_ANGLE1 = FMath.fix(20);
    long lastHitTime;
    static int[] points = new int[2];
    static int[] fixHalf = new int[2];
    boolean[] pointInMyCar = new boolean[4];
    boolean[] pointInOtherCar = new boolean[4];

    public void loadCarProp() {
        this.loadCarSpeedMax();
        this.loadCarAcc();
        this.loadCarAngAcc();
    }

    void loadCarSpeedMax() {
        this.fixBaseSpeedMax = this.aiMode == 0 ? (this.isPlayer ? DEFAULT_MOVE_MAX_SPEED : DEFAULT_ENEMY_MAX_SPEED + Sim.getCountry() * 100 - 200) : (this.isPlayer ? DEFAULT_MOVE_MAX_SPEED : DEFAULT_MOVE_MAX_SPEED + Sim.getCountry() * 100 - 700);
    }

    void loadCarAcc() {
        this.fixBaseAcc = 400 + (this.isPlayer ? 0 : 200);
    }

    void loadCarAngAcc() {
        this.fixBaseAngleAcc = this.isPlayer ? DEFAULT_ANG_ACC : DEFAULT_ENEMY_ANG_ACC;
    }

    public void setPos(int x, int y) {
        this.posX = x;
        this.posY = y;
        this.fixLastAngle = 0;
        this.fixAngle = 0;
        this.angle = 0;
        this.fixAngleAcc = 0;
        this.fixSpeedY = 0;
        this.fixSpeedX = 0;
        this.fixLastSpeed = -1;
        this.fixPos[0] = FMath.fix(x);
        this.fixPos[1] = FMath.fix(y);
    }

    public void initHp(int hp) {
        this.hp = this.maxHp = hp;
    }

    public void setHp(int hp) {
        this.hp = hp;
    }

    public void reset() {
        this.animId = 0;
        this.trans = 0;
        this.speed = 0;
        this.fixAcc = 0;
        this.fixLastSpeed = 0;
        this.fixSpeed = 0;
        this.fixSpeedY = 0;
        this.fixSpeedX = 0;
        this.fixSpeedMax = this.fixBaseSpeedMax;
        this.setState(0);
    }

    public void setAnim(ZedAnimation anim) {
        this.anim = anim;
        this.half[0] = anim.getFrameWidth(0) / 2;
        this.half[1] = anim.getFrameHeight(0) / 2;
        this.updateCollBox();
        this.weight = 100;
    }

    public void setPlayerCar(boolean isPlayer) {
        this.isPlayer = isPlayer;
        this.loadCarProp();
        this.reset();
        this.decision = 0;
    }

    public void process(long time) {
        if (this.state == 2 && this.speed == 0) {
            return;
        }
        if (this.posY < -260) {
            return;
        }
        if (this.isPlayer) {
            this.updatePlayerAI();
        } else {
            this.updateNPCAI(time);
        }
        this.updateState();
        this.updatePos();
    }

    void updatePos() {
        this.updateSpeed();
        this.fixPos[0] = this.fixPos[0] + this.fixSpeedX;
        this.fixPos[1] = this.fixPos[1] - this.fixSpeedY;
        this.posX = FMath.fix2int(this.fixPos[0]);
        this.posY = FMath.fix2int(this.fixPos[1]);
    }

    void updateSpeed() {
        this.fixAngle += this.fixAngleAcc;
        this.fixSpeed += this.fixAcc;
        if (this.fixSpeed != this.fixLastSpeed || this.fixAngle != this.fixLastAngle) {
            this.angle = FMath.fix2int(this.fixAngle);
            this.fixSpeedX = this.fixSpeed * FMath.sin(this.angle) >> 10;
            this.fixSpeedY = this.fixSpeed * FMath.cos(this.angle) >> 10;
            this.speed = FMath.fix2int(this.fixSpeed);
            if (this.fixAngle != this.fixLastAngle) {
                this.updateCollBox();
            }
            this.fixLastSpeed = this.fixSpeed;
            this.fixLastAngle = this.fixAngle;
        }
    }

    public void setBlink(long time) {
        this.isBlink = true;
        this.blinkToTime = time;
    }

    void updateBlink(long time) {
        if (time > this.blinkToTime) {
            this.isBlink = false;
        }
    }

    public void paint(Graphics g, int vpx, int vpy) {
        if (!Sim.isInCamera(this)) {
            return;
        }
        this.updateBlink(MainCanvas.processTime);
        this.getAnimByAngle();
        int x = Sim.getPaintPosX(this.posX);
        int y = this.posY - vpy;
        boolean paintCar = true;
        if (this.state == 2 && !this.isPlayer) {
            if (this.speed == 0) {
                paintCar = false;
            } else {
                boolean bl = paintCar = MainCanvas.processTime / 200L % 2L == 0L;
            }
        }
        if (paintCar && this.isBlink) {
            boolean bl = paintCar = MainCanvas.processTime / 200L % 2L == 0L;
        }
        if (paintCar) {
            this.anim.drawAnimation(g, this.animId, 0L, x, y, this.trans, true);
            g.setColor(0);
            int hpx = x - 15;
            int hpy = y + this.half[1] + 2;
            g.drawRect(hpx, hpy, 30, 4);
            g.setColor(0xFFFD00);
            int w = (this.hp * 30 - 1) / this.maxHp;
            g.fillRect(hpx + 1, hpy + 1, w, 3);
            g.setColor(16198400);
            g.fillRect(hpx + 1 + w, hpy + 1, 29 - w, 3);
            if (this.fixSpeedMax > this.fixBaseSpeedMax) {
                g.setColor(0xFFFFFF);
            }
        }
    }

    void getAnimByAngle() {
        int angle = FMath.fix2int(this.fixAngle);
        this.trans = angle < -4 ? 2 : 0;
        int absAngle = Math.abs(angle);
        this.animId = Math.abs((absAngle + 7) / 15);
    }

    void setState(int newState) {
        this.state = newState;
    }

    void updateState() {
        switch (this.state) {
            case 0: {
                break;
            }
            case 1: {
                this.fixAcc = this.adjustSpeed(this.fixSpeed, this.fixSpeedMax);
                if (this.fixAngle > FMath.FIX_60) {
                    this.fixAngle = FMath.FIX_60;
                    this.fixAngleAcc = 0;
                } else if (this.fixAngle < -FMath.FIX_60) {
                    this.fixAngle = -FMath.FIX_60;
                    this.fixAngleAcc = 0;
                }
                if (this.hp > 0) break;
                this.setState(2);
                break;
            }
            case 2: {
                this.fixAcc = this.adjustSpeed(this.fixSpeed, 0);
                if (this.fixAngle > FMath.FIX_60) {
                    this.fixAngle = FMath.FIX_60;
                    this.fixAngleAcc = 0;
                    break;
                }
                if (this.fixAngle >= -FMath.FIX_60) break;
                this.fixAngle = -FMath.FIX_60;
                this.fixAngleAcc = 0;
            }
        }
    }

    int adjustSpeed(int currSpeed, int maxSpeed) {
        int diff = maxSpeed - currSpeed;
        if (Math.abs(diff) < this.fixBaseAcc) {
            return diff;
        }
        return diff > 0 ? this.fixBaseAcc : -this.fixBaseAcc;
    }

    int adjustAngle(int currAngle, int currAnim) {
        int tarAbsAngle = currAnim * FMath.FIX_15;
        int tarAngle = currAngle > 0 ? tarAbsAngle : -tarAbsAngle;
        int diff = tarAngle - currAngle;
        int angAcc = this.fixBaseAngleAcc >> 3;
        return diff > angAcc ? angAcc : diff;
    }

    void turnLeft(boolean left) {
        this.fixAngleAcc = left ? -this.fixBaseAngleAcc : this.fixBaseAngleAcc;
    }

    void updatePlayerAI() {
        switch (this.state) {
            case 0: {
                break;
            }
            case 1: {
                if (Sim.curKey == 256) {
                    this.turnLeft(true);
                } else if (Sim.curKey == 1024) {
                    this.turnLeft(false);
                } else {
                    this.fixAngleAcc = this.adjustAngle(this.fixAngle, this.animId);
                }
                if (Sim.curKey == 4096) {
                    this.fixSpeedMax = 0;
                    break;
                }
                if (Sim.keyPressedOnce == 64) {
                    this.fixSpeed = this.fixBaseSpeedMax + (this.fixBaseSpeedMax >> 1);
                    break;
                }
                this.fixSpeedMax = this.fixBaseSpeedMax;
            }
        }
    }

    public void setAiMode(int mode) {
        this.aiMode = mode;
    }

    void setDecision(int decision) {
        this.decision = decision;
        switch (decision) {
            case 0: {
                this.fixSpeedMax = this.fixBaseSpeedMax;
                break;
            }
            case 2: {
                this.fixSpeedMax = this.fixBaseSpeedMax + (this.fixBaseSpeedMax >> 1);
            }
        }
    }

    void updateNPCAI(long time) {
        if (this.aiMode == 0) {
            if (Math.abs(this.fixAngle) < this.fixBaseAngleAcc) {
                this.fixAngleAcc = this.fixAngle > 0 ? -this.fixAngle : this.fixAngle;
            } else {
                this.turnLeft(this.fixAngle > 0);
            }
        } else if (this.aiMode == 1 || this.aiMode == 2) {
            switch (this.decision) {
                case 0: {
                    this.avoidActor(time);
                    break;
                }
                case 1: {
                    if (MainCanvas.processTime - MainCanvas.sim.lastDecideTime <= 5000L) break;
                    this.setDecision(0);
                    break;
                }
                case 2: {
                    this.avoidActor(time);
                    if (Sim.cars[0].posY - this.posY <= Utils.getRandNumber(0, 40) && MainCanvas.processTime - MainCanvas.sim.lastDecideTime <= 5000L) break;
                    this.setDecision(0);
                    break;
                }
                case 3: {
                    this.avoidActor(time);
                    if (Sim.cars[0].posY - this.posY > 130 && !Sim.isInCamera(this)) {
                        this.fixSpeedMax = this.fixBaseSpeedMax >> 1;
                        break;
                    }
                    this.setDecision(0);
                }
            }
        }
    }

    boolean canCollPlayer() {
        return false;
    }

    void avoidActor(long time) {
        Sim sim = MainCanvas.sim;
        if (sim.actorY + sim.actorHalfH < this.posY) {
            if (time - this.lastAvoidTime < 1000L) {
                this.turnTo(this.trgetAngle);
                return;
            }
            int tarXL = sim.actorX - sim.actorHalfW - this.half[0] - this.half[0];
            int tarXR = sim.actorX + sim.actorHalfW + this.half[0] + this.half[0];
            int limit = Sim.roadColWidth / 2 - this.half[0] * 2;
            if (this.posX + this.half[0] < tarXR && this.posX - this.half[0] > tarXL) {
                int yDiff = sim.actorY + sim.actorHalfH - this.posY;
                if (tarXL < -limit) {
                    int xDiff = tarXR - this.posX;
                    int angleRight = FMath.toDegrees(FMath.atan2(-yDiff, xDiff));
                    angleRight = 90 - angleRight;
                    this.turnTo(angleRight);
                    this.trgetAngle = angleRight;
                } else if (tarXR > limit) {
                    int xDiff = tarXL - this.posX;
                    int angleLeft = FMath.toDegrees(FMath.atan2(-yDiff, xDiff));
                    angleLeft = 90 - angleLeft;
                    this.turnTo(angleLeft);
                    this.trgetAngle = angleLeft;
                } else {
                    int xDiff = tarXL - this.posX;
                    int angleLeft = FMath.toDegrees(FMath.atan2(-yDiff, xDiff));
                    angleLeft = 90 - angleLeft;
                    xDiff = tarXR - this.posX;
                    int angleRight = FMath.toDegrees(FMath.atan2(-yDiff, xDiff));
                    angleRight = 90 - angleRight;
                    if (Math.abs(this.angle - angleLeft) > Math.abs(this.angle - angleRight)) {
                        this.turnTo(angleRight);
                        this.trgetAngle = angleRight;
                    } else {
                        this.turnTo(angleLeft);
                        this.trgetAngle = angleLeft;
                    }
                }
                this.lastAvoidTime = time;
            } else {
                this.turnTo(0);
            }
        } else {
            this.turnTo(0);
        }
    }

    void turnTo(int tarAngle) {
        int angFixDiff;
        if (tarAngle > 60) {
            tarAngle = 60;
        }
        if (tarAngle < -60) {
            tarAngle = -60;
        }
        this.fixAngleAcc = Math.abs(angFixDiff = FMath.fix(tarAngle - this.angle)) > this.fixBaseAngleAcc ? (angFixDiff > 0 ? this.fixBaseAngleAcc : -this.fixBaseAngleAcc) : angFixDiff;
    }

    void updateCollBox() {
        int right = FMath.fix(this.half[0]);
        int left = -right;
        int bottom = FMath.fix(this.half[1]);
        int top = -bottom;
        FMath.rotateV(left, top, this.angle, this.carPoints[0]);
        FMath.rotateV(left, bottom, this.angle, this.carPoints[1]);
        FMath.rotateV(right, top, this.angle, this.carPoints[2]);
        FMath.rotateV(right, bottom, this.angle, this.carPoints[3]);
    }

    void updateCollWithCars(long time) {
        if (this.posY < -260) {
            return;
        }
        if (this.hp <= 0 && !this.isPlayer) {
            return;
        }
        for (int i = 0; i < Sim.cars.length; ++i) {
            boolean isHighSpeed;
            boolean hitXDir;
            boolean isCollision;
            Car car = Sim.cars[i];
            if (car == this || !Sim.isInCamera(car) || car.hp <= 0 && !car.isPlayer || !(isCollision = this.isCollision(car))) continue;
            boolean meAtForward = this.posY < car.posY;
            boolean meAtLeft = this.posX < car.posX;
            int fixPosXDiff = this.fixPos[0] - car.fixPos[0];
            int fixSpeedXDiff = this.fixSpeedX - car.fixSpeedX;
            int fixPosYDiff = this.fixPos[1] - car.fixPos[1];
            int fixSpeedYDiff = this.fixSpeedY - car.fixSpeedY;
            boolean hitYDir = Math.abs(fixSpeedYDiff) > 2000;
            boolean bl = hitXDir = Math.abs(fixSpeedXDiff) > 1500;
            if (hitYDir && hitXDir) {
                int speedOff = fixSpeedYDiff;
                this.push(-speedOff / 3);
                car.push(speedOff / 3);
                int xHalfOff = FMath.fix(this.half[0]) + FMath.fix(car.half[0]) - Math.abs(fixPosXDiff);
                if (xHalfOff < 0) {
                    xHalfOff = 0;
                }
                if (meAtLeft) {
                    this.fixPos[0] = this.fixPos[0] - xHalfOff;
                    this.changeAngel(-COLL_BIG_ANGLE1);
                    car.fixPos[0] = car.fixPos[0] + xHalfOff;
                    car.changeAngel(COLL_BIG_ANGLE1);
                } else {
                    this.fixPos[0] = this.fixPos[0] + xHalfOff;
                    this.changeAngel(COLL_BIG_ANGLE1);
                    car.fixPos[0] = car.fixPos[0] - xHalfOff;
                    car.changeAngel(-COLL_BIG_ANGLE1);
                }
            } else if (hitYDir) {
                this.push(-fixSpeedYDiff / 2);
                car.push(fixSpeedYDiff);
                int angleDiff = Utils.getRandNumber(COLL_SMALL_ANGLE0, COLL_SMALL_ANGLE1);
                int angleDiff2 = Utils.getRandNumber(COLL_SMALL_ANGLE0, COLL_SMALL_ANGLE1);
                if (meAtForward ^ meAtLeft) {
                    this.changeAngel(angleDiff);
                    car.changeAngel(angleDiff2);
                } else {
                    this.changeAngel(-angleDiff);
                    car.changeAngel(-angleDiff2);
                }
            } else if (hitXDir) {
                int xHalfOff = (FMath.fix(this.half[0]) + FMath.fix(car.half[0]) - Math.abs(fixPosXDiff)) * 3 / 4;
                if (xHalfOff < 0) {
                    xHalfOff = 0;
                }
                if (meAtLeft) {
                    this.fixPos[0] = this.fixPos[0] - xHalfOff;
                    this.changeAngel(-COLL_BIG_ANGLE1);
                    car.fixPos[0] = car.fixPos[0] + xHalfOff;
                    car.changeAngel(COLL_BIG_ANGLE1);
                } else {
                    this.fixPos[0] = this.fixPos[0] + xHalfOff;
                    this.changeAngel(COLL_BIG_ANGLE1);
                    car.fixPos[0] = car.fixPos[0] - xHalfOff;
                    car.changeAngel(-COLL_BIG_ANGLE1);
                }
            } else {
                fixSpeedYDiff = fixSpeedYDiff > 0 ? (fixSpeedYDiff < 512 ? 512 : fixSpeedYDiff) : (fixSpeedYDiff > -512 ? -512 : fixSpeedYDiff);
                this.push(-fixSpeedYDiff);
                car.push(fixSpeedYDiff);
            }
            if (car.hp <= 0 || this.hp <= 0) continue;
            int damage = hitXDir || hitYDir ? 20 : 10;
            boolean bl2 = isHighSpeed = this.fixSpeed > car.fixSpeed;
            if (time - this.lastHitTime > 100L) {
                Sim.getScore(damage * 2);
            }
            this.beAttacked(time, isHighSpeed ? damage / 2 : damage);
            car.beAttacked(time, isHighSpeed ? damage : damage / 2);
        }
    }

    void beAttacked(long time, int damage) {
        if (this.hp == 0) {
            return;
        }
        if (time - this.lastHitTime > 100L) {
            this.hp -= damage;
            if (this.hp < 0) {
                this.hp = 0;
            }
            this.lastHitTime = time;
        }
        if (!this.isPlayer && this.hp == 0) {
            Sim.getScore(this.maxHp * 2);
        }
    }

    void push(int speedYDiff) {
        this.fixSpeed += speedYDiff;
        if (this.fixSpeed > DEFAULT_MOVE_MAX_SPEED + DEFAULT_MOVE_MAX_SPEED / 2) {
            this.fixSpeed = DEFAULT_MOVE_MAX_SPEED + DEFAULT_MOVE_MAX_SPEED / 2;
        } else if (this.fixSpeed < -DEFAULT_MOVE_MAX_SPEED / 2) {
            this.fixSpeed = -DEFAULT_MOVE_MAX_SPEED / 2;
        }
    }

    void changeAngel(int angle) {
        this.fixAngle += angle;
        if (this.fixAngle > FMath.FIX_60) {
            this.fixAngle = FMath.FIX_60;
        } else if (this.fixAngle < -FMath.FIX_60) {
            this.fixAngle = -FMath.FIX_60;
        }
    }

    boolean isCollision(Car car) {
        int i;
        boolean isCollision = false;
        Car.fixHalf[0] = FMath.fix(this.half[0]);
        Car.fixHalf[1] = FMath.fix(this.half[1]);
        int maxDis = this.half[0] + this.half[1] + car.half[0] + car.half[1];
        if (Math.abs(this.posX - car.posX) > maxDis && Math.abs(this.posY - car.posY) > maxDis) {
            return false;
        }
        for (i = 0; i < 4; ++i) {
            FMath.addV(car.carPoints[i], car.fixPos, points);
            this.pointInMyCar[i] = FMath.isPointInRect(points, this.fixPos, fixHalf, this.angle);
            if (!this.pointInMyCar[i]) continue;
            isCollision = true;
        }
        Car.fixHalf[0] = FMath.fix(car.half[0]);
        Car.fixHalf[1] = FMath.fix(car.half[1]);
        for (i = 0; i < 4; ++i) {
            FMath.addV(this.carPoints[i], this.fixPos, points);
            this.pointInOtherCar[i] = FMath.isPointInRect(points, car.fixPos, fixHalf, car.angle);
            if (!this.pointInOtherCar[i]) continue;
            isCollision = true;
        }
        return isCollision;
    }

    void updateCollWithWall() {
        if (this.posY < -260) {
            return;
        }
        boolean isCollLeft = false;
        boolean isCollRight = false;
        int fixRoadLeft = -FMath.fix(Sim.roadColWidth / 2);
        int fixRoadRight = -fixRoadLeft;
        int offset1 = 0;
        int offset2 = 0;
        if (this.carPoints[0][0] + this.fixPos[0] < fixRoadLeft) {
            offset1 = fixRoadLeft - this.carPoints[0][0] - this.fixPos[0];
            this.carPoints[0][0] = fixRoadLeft - this.fixPos[0];
            isCollLeft = true;
        }
        if (this.carPoints[1][0] + this.fixPos[0] < fixRoadLeft) {
            offset2 = fixRoadLeft - this.carPoints[1][0] - this.fixPos[0];
            this.carPoints[1][0] = fixRoadLeft - this.fixPos[0];
            isCollLeft = true;
        }
        if (this.carPoints[2][0] + this.fixPos[0] > fixRoadRight) {
            offset1 = fixRoadRight - this.carPoints[2][0] - this.fixPos[0];
            this.carPoints[2][0] = fixRoadRight - this.fixPos[0];
            isCollRight = true;
        }
        if (this.carPoints[3][0] + this.fixPos[0] > fixRoadRight) {
            offset2 = fixRoadRight - this.carPoints[3][0] - this.fixPos[0];
            this.carPoints[3][0] = fixRoadRight - this.fixPos[0];
            isCollRight = true;
        }
        if (isCollLeft) {
            int x = this.carPoints[0][0] - this.carPoints[1][0];
            int y = this.carPoints[0][1] - this.carPoints[1][1];
            int tAngle = FMath.toDegrees(FMath.atan2(-y, -x));
            this.angle = tAngle - 90;
            if (this.angle < -60) {
                this.angle = -60;
            }
            this.fixAngle = FMath.fix(this.angle);
            this.fixPos[0] = this.fixPos[0] + (offset1 + offset2) / 2;
            this.updateCollBox();
        } else if (isCollRight) {
            int x = this.carPoints[2][0] - this.carPoints[3][0];
            int y = this.carPoints[2][1] - this.carPoints[3][1];
            int tAngle = FMath.toDegrees(FMath.atan2(-y, -x));
            this.angle = tAngle - 90;
            if (this.angle > 60) {
                this.angle = 60;
            }
            this.fixAngle = FMath.fix(this.angle);
            this.fixPos[0] = this.fixPos[0] + (offset1 + offset2) / 2;
            this.updateCollBox();
        }
        if (isCollLeft || isCollRight) {
            this.fixBaseSpeedMax = DEFAULT_MOVE_MAX_SPEED / 2;
        } else {
            this.loadCarSpeedMax();
        }
    }
}

