/*
 * Decompiled with CFR 0.152.
 */
package z.playw.j2me.util;

import java.util.Vector;
import z.playw.j2me.Mid;

public class PWAdvancedKeyboard {
    public static final long TIME_REPEAT_KEY = 1000L;
    public static final char LEFT_BUTTON = '\u0000';
    public static final char RIGHT_BUTTON = '\u0001';
    public static final char FIRE_BUTTON = '\u0002';
    public static final char LEFT_ARROW = '\u0003';
    public static final char RIGHT_ARROW = '\u0004';
    public static final char UP_ARROW = '\u0005';
    public static final char DOWN_ARROW = '\u0006';
    public static final char ACTION_KEY_LIMIT = '\u0006';
    public static final char NO_KEY = '\b';
    public static final char DELETE = '\t';
    public static final char NO_PRINTABLE_LIMIT = '\n';
    public static final byte EVENT_NOEVENT = -100;
    public static final byte EVENT_KEYPRESSED = 0;
    public static final byte EVENT_KEYRELEASED = 1;
    public static final String EMPTY_CHARSET = "^^^^^^^^^^^";
    public static final String FULL_CHARSET_STRING = " 0^.-?!\\@:;/()1^abc\ufffd?^def\ufffd?^ghi\ufffd?^jkl5^mno\u5e3d\u8d386^pqrs7^tuv8^wxyz9^*^#";
    public static final String FULL_UPPERCASE_CHARSET_STRING = " 0^.-?!\\@:;/()1^ABC\ufffd?2^DEF\ufffd?^GHI\ufffd?4^JKL5^MNO\u8129\u812b6^PQRS7^TUV8^WXYZ9^*^#";
    public static final String EMAIL_UPPERCASE_CHARSET_STRING = "0^.@-_1^ABC2^DEF3^GHI4^JKL5^MNO6^PQRS7^TUV8^WXYZ9^*^#";
    public static final String REDUCED_CHARSET_STRING = "^^abc^def^ghi^jkl^mno\u5e3d^pqrs^tuv^wxyz^*^#";
    public static final String REDUCED_CHARSET_ANGLO_SAXON_STRING = "^^abc^def^ghi^jkl^mno^pqrs^tuv^wxyz^*^#";
    public static final String REDUCED_UPPERCASE_CHARSET_ANGLO_SAXON_WITHDIGITS_STRING = "0^1^ABC2^DEF3^GHI4^JKL5^MNO6^PQRS7^TUV8^WXYZ9";
    public static final String REDUCED_UPPERCASE_CHARSET_STRING = "^^ABC^DEF^GHI^JKL^MNO\u8129^PQRS^TUV^WXYZ^*^#";
    public static final String REDUCED_UPPERCASE_CHARSET_WITHDIGITS_STRING = "0^1^ABC2^DEF3^GHI4^JKL5^MNO\ufffd?^PQRS7^TUV8^WXYZ9^*^#";
    public static final String NUMBERS_CHARSET_STRING = "0^1^2^3^4^5^6^7^8^9^*^#";
    public static final String REDUCED_CHARSET_ANGLO_SAXON_WITHDIGITS_STRING = "0^1^abc2^def3^ghi4^jkl5^mno6^pqrs7^tuv8^wxyz9";
    public static final String REDUCED_UPPERCASE_CHARSET_WITHOUTDIGITS_STRING_TWO_VALUES = "0^QW^ER1^TY2^UI3^OP^AS^DF4^GH5^JK6^L^ZX^CV7^BN8^M9^";
    public static final String NUMBERS_CHARSET = "0123456789*#";
    public byte lastEvent;
    public char lastKey;
    private int multitapLastKey = -1;
    public boolean acceptKeyPressed = true;
    public boolean acceptKeyReleased = true;
    public boolean acceptKeyTyped = true;
    public boolean hasMoreKeys = false;
    public StringBuffer text;
    private char[][] charset;
    private String actualCharset;
    private short pointerRead;
    private short pointerWrite;
    private byte[] evtArray_type;
    private char[] evtArray_key;
    private boolean multitap = false;
    private int maxTextSize = 0;
    private int multitapChar = 0;
    private long multitapLastTime;

    public PWAdvancedKeyboard(String charsetString) {
        this.init(charsetString);
    }

    public void init(String charsetString) {
        this.actualCharset = charsetString;
        char[][] charset = new char[15][];
        String[] pwt = PWAdvancedKeyboard.slice(charsetString, '^');
        for (int i = 0; i < charset.length; ++i) {
            String key = pwt[i];
            if (key != null) {
                charset[i] = new char[key.length()];
                for (int j = 0; j < key.length(); ++j) {
                    charset[i][j] = key.charAt(j);
                }
                continue;
            }
            charset[i] = new char[0];
        }
        this.init(charset, 60);
        this.multitap = false;
        this.multitapChar = 0;
        this.text = null;
    }

    public PWAdvancedKeyboard(String[] charsetString) {
        this.init(charsetString);
    }

    public void init(String[] pwt) {
        char[][] charset = new char[10][];
        for (int i = 0; i < charset.length; ++i) {
            String key = pwt[i];
            if (key != null) {
                charset[i] = new char[key.length()];
                for (int j = 0; j < key.length(); ++j) {
                    charset[i][j] = key.charAt(j);
                }
                continue;
            }
            charset[i] = new char[0];
        }
        this.init(charset, 60);
        this.multitap = false;
        this.multitapChar = 0;
        this.text = null;
    }

    public synchronized void removeAlEvents() {
        this.pointerRead = this.pointerWrite;
        this.hasMoreKeys = false;
    }

    private void init(char[][] charset, int bufferSize) {
        this.charset = charset;
        this.pointerWrite = 0;
        this.pointerRead = 0;
        this.evtArray_type = new byte[bufferSize];
        this.evtArray_key = new char[bufferSize];
        this.hasMoreKeys = false;
    }

    public char nextChar() {
        if (!this.hasMoreKeys) {
            return '\b';
        }
        this.lastEvent = this.evtArray_type[this.pointerRead];
        this.lastKey = this.evtArray_key[this.pointerRead];
        this.elementReaded();
        return this.lastKey;
    }

    public synchronized void keyPressed(int keyCode) {
        if (!this.acceptKeyPressed) {
            return;
        }
        if (this.multitap) {
            this.addMultitap((byte)0, keyCode);
        } else {
            int keyNumber = this.getNumericKeyNumberForKeycode(keyCode);
            if (keyNumber != -1) {
                this.add((byte)0, NUMBERS_CHARSET.charAt(keyNumber));
            } else {
                char action = Mid.getActionByKeycode(keyCode);
                if (action != '\b') {
                    this.add((byte)0, action);
                }
            }
        }
    }

    public synchronized void keyReleased(int keyCode) {
        if (!this.acceptKeyReleased | this.multitap) {
            return;
        }
        int keyNumber = this.getNumericKeyNumberForKeycode(keyCode);
        if (keyNumber != -1) {
            this.add((byte)1, NUMBERS_CHARSET.charAt(keyNumber));
        } else {
            char action = Mid.getActionByKeycode(keyCode);
            if (action != '\b') {
                this.add((byte)1, action);
            }
        }
    }

    private synchronized void addMultitap(byte event, int keycode) {
        int keyNumber = this.getNumericKeyNumberForKeycode(keycode);
        keyNumber = -1;
        if (keyNumber != -1) {
            this.addMultitapKey(keyNumber);
        } else if (this.getLetterKeyForKeycode(keycode) != -1) {
            this.addMultitapKey(this.getLetterKeyForKeycode(keycode));
        } else {
            char action = Mid.getActionByKeycode(keycode);
            if (action != '\b') {
                this.add((byte)0, action);
            }
        }
    }

    private void addNumberKey(int keyPressed) {
        if (keyPressed >= 0 && keyPressed <= 9) {
            if (this.text.length() >= this.maxTextSize) {
                this.text.deleteCharAt(this.maxTextSize - 1);
            }
            this.text.append(keyPressed);
        }
    }

    private void addMultitapKey(int keyPressed) {
        long time = System.currentTimeMillis();
        if (keyPressed >= 0 && keyPressed < this.charset.length && this.charset[keyPressed].length > 0) {
            if (keyPressed == this.multitapLastKey && this.multitapLastTime + 1000L > time && this.charset[keyPressed].length > 1) {
                this.multitapDeleteLastChar();
                this.multitapChar = (this.multitapChar + 1) % this.charset[keyPressed].length;
            } else {
                this.multitapChar = 0;
                if (this.text.length() >= this.maxTextSize) {
                    this.text.deleteCharAt(this.maxTextSize - 1);
                }
            }
            this.text.append(this.charset[keyPressed][this.multitapChar]);
            this.multitapLastTime = time;
            this.multitapLastKey = keyPressed;
        }
    }

    private int getNumericKeyNumberForKeycode(int keycode) {
        switch (keycode) {
            case 49: 
            case 87: 
            case 119: {
                return 1;
            }
            case 50: 
            case 69: 
            case 101: {
                return 2;
            }
            case 51: 
            case 82: 
            case 114: {
                return 3;
            }
            case 52: 
            case 83: 
            case 115: {
                return 4;
            }
            case 53: 
            case 68: 
            case 100: {
                return 5;
            }
            case 54: 
            case 70: 
            case 102: {
                return 6;
            }
            case 55: 
            case 90: 
            case 122: {
                return 7;
            }
            case 56: 
            case 88: 
            case 120: {
                return 8;
            }
            case 57: 
            case 67: 
            case 99: {
                return 9;
            }
            case 48: {
                return 0;
            }
        }
        return -1;
    }

    private int getLetterKeyForKeycode(int keycode) {
        switch (keycode) {
            case 48: {
                return 0;
            }
            case 113: {
                return 1;
            }
            case 49: {
                return 2;
            }
            case 50: {
                return 3;
            }
            case 51: {
                return 4;
            }
            case 111: {
                return 5;
            }
            case 97: {
                return 6;
            }
            case 52: {
                return 7;
            }
            case 53: {
                return 8;
            }
            case 54: {
                return 9;
            }
            case 108: {
                return 10;
            }
            case 122: {
                return 11;
            }
            case 55: {
                return 12;
            }
            case 56: {
                return 13;
            }
            case 57: {
                return 14;
            }
        }
        return -1;
    }

    public void multitapDeleteLastChar() {
        if (this.text.length() > 0) {
            this.text.deleteCharAt(this.text.length() - 1);
        }
    }

    public void multitapDeleteAllChars() {
        this.text = new StringBuffer();
    }

    public void add(byte event, char key) {
        this.evtArray_type[this.pointerWrite] = event;
        this.evtArray_key[this.pointerWrite] = key;
        this.pointerWrite = (short)(this.pointerWrite + 1);
        if (this.pointerWrite == this.evtArray_key.length) {
            this.pointerWrite = 0;
        }
        this.hasMoreKeys = true;
    }

    private void elementReaded() {
        this.pointerRead = (short)(this.pointerRead + 1);
        if (this.pointerRead == this.evtArray_key.length) {
            this.pointerRead = 0;
        }
        this.hasMoreKeys = this.pointerRead != this.pointerWrite;
    }

    public void setMultitap(boolean flag, int maxTextSize) {
        this.multitap = flag;
        this.maxTextSize = maxTextSize;
        if (this.multitap) {
            this.text = new StringBuffer();
        }
    }

    public static String[] slice(String string, char separator) {
        Vector<String> v = new Vector<String>();
        int first = 0;
        int second = string.indexOf(separator);
        while (second >= 0) {
            String token = string.substring(first, second);
            if (token.equals("")) {
                token = null;
            }
            v.addElement(token);
            first = second + 1;
            second = string.indexOf(separator, first);
        }
        String last = string.substring(first, string.length());
        if (last.equals("")) {
            last = null;
        }
        v.addElement(last);
        String[] data = new String[v.size()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (String)v.elementAt(i);
        }
        return data;
    }
}

