/*
 * Decompiled with CFR 0.152.
 */
package z.playw.j2me.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import z.playw.j2me.util.ZedAnimation;

public class PWPiFont {
    ZedAnimation theZIF;
    public int charSpacing;
    public int fontHeight;
    public int lineSpacing;
    public int spaceSize;
    private short[] charFrames;
    private short[] charWidths;
    public char[] chars;
    static String drawText;
    static char[] drawChars;
    static short[][] lineDate;
    static char[] cacheText;
    Vector result = new Vector();

    public PWPiFont(byte[] data, int currentPalette, int poolID) {
        this.theZIF = new ZedAnimation(data, currentPalette, true);
        this.load(data);
    }

    private void load(byte[] data) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            DataInputStream dis = new DataInputStream(bais);
            dis.skipBytes(4);
            this.loadFontInfo(dis);
            this.initialize();
            this.charWidths = new short[this.charFrames.length];
            for (int i = 0; i < this.charFrames.length; ++i) {
                this.charWidths[i] = (short)this.theZIF.getFrameWidth(this.charFrames[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadFontInfo(DataInputStream dis) throws IOException {
        this.setFontHeight(dis.readByte());
        this.setLineSpacing(dis.readByte());
        this.charSpacing = dis.readByte();
        this.spaceSize = dis.readByte();
        int charQuantity = dis.readShort();
        this.chars = new char[charQuantity];
        this.charFrames = new short[charQuantity];
        for (int j = 0; j < charQuantity; ++j) {
            this.chars[j] = dis.readChar();
            this.charFrames[j] = dis.readShort();
        }
    }

    private void initialize() {
        this.sortChars(0, this.chars.length - 1);
    }

    private void sortChars(int low, int high) {
        int left = low;
        int right = high;
        char half = this.chars[(low + high) / 2];
        while (true) {
            if (this.chars[left] < half && left < high) {
                ++left;
                continue;
            }
            while (half < this.chars[right] && right > low) {
                --right;
            }
            if (left <= right) {
                char x = this.chars[left];
                short x2 = this.charFrames[left];
                this.chars[left] = this.chars[right];
                this.charFrames[left] = this.charFrames[right];
                this.chars[right] = x;
                this.charFrames[right] = x2;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (low < right) {
            this.sortChars(low, right);
        }
        if (left < high) {
            this.sortChars(left, high);
        }
    }

    public void selectColor(int number) {
        this.theZIF.setPalette(number);
    }

    public short[][] drawString(Graphics graphics, String text, int x, int y, int width, int height, int anchor) {
        char[] chars;
        if (drawText != null && drawText.equals(text)) {
            chars = drawChars;
        } else {
            chars = text.toCharArray();
            drawChars = chars;
            drawText = text;
        }
        return this.drawString(graphics, chars, x, y, width, height, anchor);
    }

    public short[][] drawString(Graphics graphics, char[] data, int x, int y, int width, int height, int anchor) {
        short[][] mLineData = this.getLineData(data, width);
        this.drawFastString(graphics, data, x, y, width, height, anchor, mLineData);
        return mLineData;
    }

    public int drawString(Graphics g, int intValue, int x, int y, int anchor) {
        int w = 0;
        y += this.fontHeight;
        if ((anchor & 8) != 0) {
            w = this.getCharacterWidth((char)(48 + intValue % 10));
            x -= w;
            if (intValue == 0) {
                this.drawChar(g, '0', x, y);
            } else {
                while (intValue != 0) {
                    this.drawChar(g, (char)(48 + intValue % 10), x, y);
                    w = this.getCharacterWidth((char)(48 + (intValue /= 10) % 10));
                    x -= w;
                }
            }
        }
        return 0;
    }

    public int drawString(Graphics graphics, String text, int x, int y, int anchor) {
        return this.drawString(graphics, text.toCharArray(), x, y, anchor);
    }

    public int drawString(Graphics graphics, char[] data, int x, int y, int anchor) {
        if ((anchor & 0x10) != 0) {
            y += this.getFontHeight();
        } else if ((anchor & 0x20) != 0) {
            y -= this.getLineSpacing();
        } else if ((anchor & 2) != 0) {
            y += this.getFontHeight() / 2;
        }
        int textWidth = 0;
        if ((anchor & 8) != 0) {
            textWidth = this.getLineWidth(data);
            x -= textWidth;
        } else if ((anchor & 1) != 0) {
            textWidth = this.getLineWidth(data);
            x -= textWidth / 2;
        }
        if (textWidth == 0) {
            for (int i = 0; i < data.length; ++i) {
                textWidth = textWidth + this.drawChar(graphics, data[i], x + textWidth, y) + this.charSpacing;
            }
        } else {
            for (int i = 0; i < data.length; ++i) {
                x = x + this.drawChar(graphics, data[i], x, y) + this.charSpacing;
            }
        }
        return textWidth;
    }

    public void drawFastString(Graphics graphics, char[] data, short[][] mLineData, int x, int y, int width, int anchor, int firstLine, int linesToDraw) {
        int maxLines = firstLine + linesToDraw;
        if (maxLines > mLineData.length) {
            maxLines = mLineData.length;
        }
        y += this.getFontHeight();
        if ((anchor & 8) != 0) {
            x += width;
        } else if ((anchor & 1) != 0) {
            x += width / 2;
        }
        for (int i = firstLine; i < maxLines; ++i) {
            if (mLineData[i][2] != 0) {
                this.drawFastString(graphics, data, x, y, anchor, mLineData[i]);
            }
            y = y + this.getLineSpacing() + this.getFontHeight();
        }
    }

    public short[][] drawFastString(Graphics graphics, char[] data, int x, int y, int width, int height, int anchor, short[][] mLineData) {
        int textHeight;
        int maxLines = height / this.getFontHeight();
        if (maxLines > 1 && height % this.getFontHeight() != 0) {
            --maxLines;
        }
        if (mLineData.length < maxLines) {
            maxLines = mLineData.length;
        }
        int n = textHeight = maxLines == 1 ? maxLines * this.getFontHeight() : maxLines * (this.getLineSpacing() + this.getFontHeight());
        y = (anchor & 0x20) != 0 ? (y -= textHeight) : ((anchor & 2) != 0 ? y + this.getFontHeight() + (height - textHeight >> 1) : (y += this.getFontHeight()));
        if ((anchor & 8) != 0) {
            x += width;
        } else if ((anchor & 1) != 0) {
            x += width / 2;
        }
        for (int i = 0; i < maxLines; ++i) {
            if (mLineData[i][2] != 0) {
                this.drawFastString(graphics, data, x, y, anchor, mLineData[i]);
            }
            y = y + this.getLineSpacing() + this.getFontHeight();
        }
        return mLineData;
    }

    public void drawFastString(Graphics graphics, char[] text, int x, int y, int anchor, short[] lineData) {
        if ((anchor & 8) != 0) {
            x -= lineData[2];
        } else if ((anchor & 1) != 0) {
            x -= lineData[2] / 2;
        }
        for (int i = lineData[0]; i < lineData[1] + 1; ++i) {
            x = x + this.drawChar(graphics, text[i], x, y) + this.charSpacing;
        }
    }

    public int drawChar(Graphics g, char character, int x, int y) {
        if (character == ' ') {
            return this.spaceSize;
        }
        int charIndex = this.binarySearchOnChars(character, 0, this.chars.length - 1);
        if (charIndex == -1) {
            return 0;
        }
        this.theZIF.drawFrame(g, this.charFrames[charIndex], x, y, 0);
        return this.charWidths[charIndex];
    }

    public short[][] getLineData(char[] text, int width) {
        if (cacheText != null && cacheText.length == text.length && cacheText.equals(text)) {
            return lineDate;
        }
        this.result.removeAllElements();
        short[] currentLine = new short[]{0, 0, 0};
        boolean lastNotSpecial = false;
        for (int index = 0; index < text.length; index = (int)((char)(index + 1))) {
            int lengthFix;
            int wordLength = 0;
            while (index < text.length && text[index] != '\n' && text[index] != ' ' && text[index] != '/' && text[index] != '.') {
                wordLength += this.getCharacterWidth(text[index]) + this.charSpacing;
                index = (char)(index + 1);
            }
            boolean notSpecial = index < text.length && (text[index] == '/' || text[index] == '.');
            int n = lengthFix = notSpecial ? this.getCharacterWidth(text[index]) : 0;
            if (currentLine[2] == 0) {
                currentLine[1] = (short)(index - 1);
                currentLine[2] = (short)(currentLine[2] + wordLength);
            } else if (currentLine[2] + this.spaceSize + this.charSpacing + wordLength < width) {
                currentLine[1] = (short)(notSpecial ? index : index - 1);
                currentLine[2] = (short)(currentLine[2] + (this.spaceSize + this.charSpacing + wordLength + lengthFix));
            } else {
                this.result.addElement(currentLine);
                currentLine = new short[]{(short)(((short[])this.result.elementAt(this.result.size() - 1))[1] + 2 + (lastNotSpecial ? -1 : 0)), (short)(notSpecial ? index : index - 1), (short)(wordLength + lengthFix)};
            }
            if (index < text.length && text[index] == '\n') {
                this.result.addElement(currentLine);
                currentLine = new short[]{(short)(index + 1), (short)(index + 1), 0};
            }
            lastNotSpecial = notSpecial;
        }
        if (currentLine[0] > text.length - 1) {
            currentLine[0] = (short)(text.length - 1);
        }
        if (currentLine[1] > text.length - 1) {
            currentLine[1] = (short)(text.length - 1);
        }
        if (currentLine[0] < 0) {
            currentLine[0] = 0;
        }
        if (currentLine[1] < 0) {
            currentLine[1] = 0;
        }
        this.result.addElement(currentLine);
        short[][] ret = new short[this.result.size()][];
        for (int i = 0; i < this.result.size(); ++i) {
            short[] data = (short[])this.result.elementAt(i);
            ret[i] = new short[3];
            ret[i][0] = data[0];
            ret[i][1] = data[1];
            ret[i][2] = data[2] >= this.charSpacing ? (short)(data[2] - this.charSpacing) : (short)0;
        }
        cacheText = text;
        lineDate = ret;
        return ret;
    }

    public int getLineWidth(char[] text) {
        if (text.length < 1) {
            return 0;
        }
        int totalWidth = 0;
        totalWidth += this.getCharacterWidth(text[0]);
        for (int i = 1; i < text.length; ++i) {
            char auxChar = text[i];
            totalWidth = totalWidth + this.getCharacterWidth(auxChar) + this.charSpacing;
        }
        return totalWidth;
    }

    public int getCharacterWidth(char character) {
        if (character == ' ') {
            return this.spaceSize;
        }
        int charIndex = this.binarySearchOnChars(character, 0, this.chars.length - 1);
        if (charIndex < 0) {
            return 0;
        }
        return this.charWidths[charIndex];
    }

    public int binarySearchOnChars(char character, int left, int right) {
        if (right < left) {
            return -1;
        }
        int mid = (left + right) / 2;
        if (this.chars[mid] == character) {
            return mid;
        }
        if (character < this.chars[mid]) {
            return this.binarySearchOnChars(character, left, mid - 1);
        }
        return this.binarySearchOnChars(character, mid + 1, right);
    }

    public void setFontHeight(int fontHeight) {
        this.fontHeight = fontHeight;
    }

    public int getFontHeight() {
        return this.fontHeight;
    }

    public void setLineSpacing(int lineSpacing) {
        this.lineSpacing = lineSpacing;
    }

    public int getLineSpacing() {
        return this.lineSpacing;
    }
}

