/*
 * Decompiled with CFR 0.152.
 */
package game;

import com.ea.nfs10.MonkeyApp;
import com.ea.sdkstandalone.SDKSoundManager;
import com.ea.sdkstandalone.SDKString;
import com.ea.sdkstandalone.SDKUtils;
import constants.AnimConstants;
import constants.CarConstants;
import constants.ColourConstants;
import constants.EventConstants;
import constants.ResourceConstants;
import constants.TrackConstants;
import constants.TunerShopConstants;
import game.GameObject;
import game.SceneGame;
import generic.ResourceManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreNotFoundException;
import net.rim.device.api.system.Application;
import net.rim.device.api.system.SystemListener;
import net.rim.device.api.system.SystemListener2;

public final class AppEngine
extends GameCanvas
implements TrackConstants,
EventConstants,
CarConstants,
TunerShopConstants,
ColourConstants,
SystemListener2 {
    public static final int sKEY_0 = 1;
    public static final int sKEY_1 = 2;
    public static final int sKEY_2 = 4;
    public static final int sKEY_3 = 8;
    public static final int sKEY_4 = 16;
    public static final int sKEY_5 = 32;
    public static final int sKEY_6 = 64;
    public static final int sKEY_7 = 128;
    public static final int sKEY_8 = 256;
    public static final int sKEY_9 = 512;
    public static final int sKEY_POUND = 1024;
    public static final int sKEY_STAR = 2048;
    public static final int sKEY_DPAD_FIRE = 4096;
    public static final int sKEY_DPAD_UP = 8192;
    public static final int sKEY_DPAD_DOWN = 16384;
    public static final int sKEY_DPAD_LEFT = 32768;
    public static final int sKEY_DPAD_RIGHT = 65536;
    public static final int sKEY_SOFTL = 131072;
    public static final int sKEY_SOFTR = 262144;
    public static final int sKEY_CLR = 524288;
    public static final int sGAMEKEY_FIRE = 4128;
    public static final int sGAMEKEY_UP = 8196;
    public static final int sGAMEKEY_DOWN = 16640;
    public static final int sGAMEKEY_LEFT = 32784;
    public static final int sGAMEKEY_RIGHT = 65600;
    public static final int sGAMEKEY_ARROW = 123220;
    public static final int sGAMEKEY_NUMBER = 1023;
    public static final int KEYCODE_BB_1 = 119;
    public static final int KEYCODE_BB_2 = 101;
    public static final int KEYCODE_BB_3 = 114;
    public static final int KEYCODE_BB_4 = 115;
    public static final int KEYCODE_BB_5 = 100;
    public static final int KEYCODE_BB_6 = 102;
    public static final int KEYCODE_BB_7 = 122;
    public static final int KEYCODE_BB_8 = 120;
    public static final int KEYCODE_BB_9 = 99;
    public static final int KEYCODE_BB_0 = 48;
    public static final int KEYCODE_BB_SPACE = 32;
    public static final int KEYCODE_QKEY_RIM = 113;
    public static final int KEYCODE_PKEY_RIM = 112;
    public static final int KEYCODE_TRACKBALLKEY_RIM = -8;
    public static final int KEYCODE_ESCAPE_RIM = 27;
    public static final byte KEYCODE_UP = 1;
    public static final byte KEYCODE_DOWN = 6;
    public static final byte KEYCODE_LEFT = 2;
    public static final byte KEYCODE_RIGHT = 5;
    public static final byte KEYCODE_FIRE = -8;
    public static final int KEYCODE_LSOFTKEY = -6;
    public static final int KEYCODE_RSOFTKEY = -7;
    public static final int KEYCODE_BACKKEY = 27;
    public static final int COMMAND_NONE = 0;
    public static final int COMMAND_MENU = 1;
    public static final int COMMAND_NEXT = 2;
    public static final int COMMAND_BACK = 3;
    public static final int COMMAND_OKAY = 4;
    public static final int COMMAND_GOTO = 5;
    public static final int COMMAND_SELECT = 6;
    public static final int COMMAND_EXIT = 7;
    public static final int COMMAND_GO = 8;
    public static final int COMMAND_YES = 9;
    public static final int COMMAND_NO = 10;
    public static final int COMMAND_SKIP = 11;
    public static final int COMMAND_MORE = 12;
    public static final byte SHAREDMENU_SECTION_SIZES = 25;
    public static final byte SHAREDMENU_NONE = 0;
    public static final byte SHAREDMENU_SPLASH_EA = 1;
    public static final byte SHAREDMENU_SPLASH_NFS = 2;
    public static final byte SHAREDMENU_CALL_TO_ACTION = 3;
    public static final byte SHAREDMENU_POSTRACE_STANDINGS = 4;
    public static final byte SHAREDMENU_PSA = 5;
    public static final byte SHAREDMENU_SECTION_SELECT = 1;
    public static final byte SHAREDMENU_SELECT_MAIN = 25;
    public static final byte SHAREDMENU_SELECT_RACE_HUB = 26;
    public static final byte SHAREDMENU_SELECT_RACE_EVENT = 27;
    public static final byte SHAREDMENU_SELECT_CAR = 28;
    public static final byte SHAREDMENU_SELECT_OPTIONS = 29;
    public static final byte SHAREDMENU_SELECT_LANGUAGE = 30;
    public static final byte SHAREDMENU_SELECT_LANGUAGE_OPT = 31;
    public static final byte SHAREDMENU_SECTION_TEXT = 2;
    public static final byte SHAREDMENU_TEXT_HELP = 50;
    public static final byte SHAREDMENU_TEXT_ABOUT = 51;
    public static final byte SHAREDMENU_SECTION_CONFIRM = 3;
    public static final byte SHAREDMENU_CONFIRM_SOUND = 75;
    public static final byte SHAREDMENU_CONFIRM_RESETDATA = 76;
    public static final byte SHAREDMENU_CONFIRM_RACE_NOT_FINISHED = 77;
    public static final byte SHAREDMENU_CONFIRM_RACE_COMPLETED = 78;
    public static final byte SHAREDMENU_CONFIRM_HUB_COMPLETED = 79;
    public static final byte SHAREDMENU_CONFIRM_GAME_COMPLETED = 80;
    public static final byte SHAREDMENU_CONFIRM_RESTART_RACE = 81;
    public static final byte SHAREDMENU_CONFIRM_RACE_AGAIN = 82;
    public static final byte SHAREDMENU_CONFIRM_EXIT_MAINMENU = 88;
    public static final byte SHAREDMENU_CONFIRM_EXIT = 89;
    public static SDKString BYTEARRAY_EMPTY = new SDKString();
    public static SDKString BYTEARRAY_COLON = new SDKString();
    public static SDKString BYTEARRAY_COLON_ZERO = new SDKString();
    private byte m_sharedMenuState;
    private int m_sharedMenuSelect;
    private int m_sharedMenuSelectAtMain = 0;
    private short m_sharedMenuTitle;
    private boolean m_sharedMenuRenderBackground = true;
    private boolean m_sharedMenuRunningScene = false;
    private short[] m_sharedMenuItems;
    private SDKString[] m_postRaceCarLabelStrings;
    private SDKString[] m_postRaceLapTimeStrings;
    private byte m_helpCurPage;
    private byte m_helpNumPages;
    private int m_cancelSoftkeyBeforeMenu = 0;
    private int m_selectSoftkeyBeforeMenu = 0;
    private int m_sharedMenuRenderPosX = 0;
    private int m_sharedMenuRenderPosY = 0;
    private int m_sharedMenuSplashTime;
    private boolean m_patrolModeSuccess;
    private int m_tunerShopSelection;
    public static final short GAMEDATA_EA_SPLASH_DURATION = 3000;
    public static final short GAMEDATA_TITLE_SPLASH_DURATION = 3000;
    public static final short GAMEDATA_CALL_TO_ACTION_DURATION = 3000;
    public static final short GAMEDATA_CALL_TO_ACTION_WRAP_LEADING = 2;
    public static final byte GAMEDATA_MIN_WIN_POS_GRIP = 1;
    public static final int GAMEDATA_SELECT_MENU_WIDTH = 130;
    public static byte GAMEDATA_HELP_LINES_PER_PAGE = (byte)10;
    public static final int GAMEDATA_HELP_WRAP_WIDTH = 200;
    public static final byte GAMEDATA_HELP_WRAP_MARGIN_SIDE = 5;
    public static final byte GAMEDATA_HELP_WRAP_MARGIN_TOPBOTTOM = 2;
    public static final byte GAMEDATA_HELP_WRAP_LEADING = 2;
    public static final int GAMEDATA_CONFIRM_WRAP_WIDTH = 200;
    public static final byte GAMEDATA_CONFIRM_WRAP_MARGIN_SIDE = 5;
    public static final byte GAMEDATA_CONFIRM_WRAP_MARGIN_TOPBOTTOM = 2;
    public static final byte GAMEDATA_CONFIRM_WRAP_LEADING = 2;
    public static final int GAMEDATA_POSTRACE_WIDTH = 130;
    public static final byte GAMEDATA_POSTRACE_POSITION_POSX = 5;
    public static final byte GAMEDATA_POSTRACE_MARGIN_ABOVE_BELOW = 2;
    public static final byte GAMEDATA_POSTRACE_LEFT_MARGIN = 5;
    public static final byte GAMEDATA_POSTRACE_RIGHT_MARGIN = 14;
    public static final byte GAMEDATA_POSTRACE_LEADING = 2;
    public static final byte GAMEDATA_POSTRACE_HALF_LEADING_SELECTED = 2;
    public static final int GAMEDATA_INFOBOX_COLOR_SLIPSTREAM = 13102885;
    public static final int GAMEDATA_INFOBOX_COLOR_GOODRACELINE = 13102885;
    public static final int GAMEDATA_INFOBOX_COLOR_DRIFT_SAFE = 16750080;
    public static final int GAMEDATA_INFOBOX_COLOR_DRIFT_DANGER = 0xFF0000;
    public static final int GAMEDATA_INFOBOX_COLOR_DRIFT_SUCCESS = 13102885;
    public static final short GAMEDATA_BOOST_BONUS_FLASH_DURATION = 200;
    public static final int GAMEDATA_MAX_STEERING_ACCEL_SPEED = 0x1E0000;
    public static final int NUM_PLAYER_CAR_ANGLES = 5;
    public static final int CAREER_INITIAL_WALLET = 200000;
    public static final int LOAD_FOREST = 1;
    public static final int LOAD_COAST = 2;
    public static final int CAR_MASK_SHIFT_OFFSET = 2;
    public static final int LOAD_PORSCHE = 64;
    public static final int LOAD_LAMBORGHINI = 16;
    public static final int LOAD_KOENIGSEGG = 4;
    public static final int LOAD_COP = 256;
    public static final int LOAD_OPP_PORSCHE = 128;
    public static final int LOAD_OPP_LAMBORGHINI = 32;
    public static final int LOAD_OPP_KOENIGSEGG = 8;
    public static final int LOAD_OPP_COP = 512;
    public static final int LOAD_SCENEGAME = 524287;
    public static final int LOAD_APPENGINE = 0x1000000;
    public final short IMAGE_COUNT;
    static final int[] IMAGE_IDS = new int[]{51, 0x1000000, 46, 0x1000000, 49, 1, 48, 2, 15, 4, 23, 0x1000004, 25, 64, 33, 0x1000040, 2, 256, 3, 256, 39, 256, 5, 16, 13, 0x1000010, 4, 524287, 15, 8, 16, 8, 17, 8, 18, 8, 19, 8, 20, 8, 21, 8, 22, 8, 25, 128, 26, 128, 27, 128, 28, 128, 29, 128, 30, 128, 31, 128, 32, 128, 5, 32, 6, 32, 7, 32, 8, 32, 9, 32, 10, 32, 11, 32, 12, 32, -1};
    public static final short VIBRATION_DURATION_CONFIRM_EVENT = 500;
    public static final short VIBRATION_DURATION_CAR_COLLISION = 100;
    public static final short VIBRATION_DURATION_CRASH_FLIP = 500;
    public static final byte ACC_ENGINE = 0;
    public static final byte ACC_TRANSMISSION = 1;
    public static final byte ACC_TYRES = 2;
    public static final byte ACC_NITRO = 3;
    public static final byte TUNERSHOP_NUM_ACC = 4;
    private static int CAR_VALUE_ACCEL_MIN_F;
    private static int CAR_VALUE_ACCEL_MULTIPLIER_F;
    private static int CAR_VALUE_HANDLING_MIN_F;
    private static int CAR_VALUE_HANDLING_MULTIPLIER_F;
    private static int CAR_VALUE_NITRO_MIN_F;
    private static int CAR_VALUE_NITRO_MULTIPLIER_F;
    private static int CARSELECT_LEVEL_BAR_WIDTH;
    private static int CARSELECT_LEVEL_BAR_MULTIPLIER_F;
    private static int PS_TO_MW_ACC_FACTOR;
    public static final byte NUM_OPPONENTS_CIRCUIT = 3;
    public static final byte NUM_OPPONENTS_SPRINT = 3;
    public static final byte NUM_OPPONENTS_PATROL = 0;
    public static final byte NUM_CRIMINALS_CIRCUIT = 0;
    public static final byte NUM_CRIMINALS_SPRINT = 0;
    public static final byte NUM_CRIMINALS_PATROL = 1;
    public static final byte NUM_CRIMINALS_TO_CATCH = 4;
    public static final int PATROL_MODE_TIME = 0x960000;
    private int TEMP_STRING_BUFFER_LENGTH = 10;
    private SDKString m_tempStringBuffer;
    public static int m_keysPressedDown;
    public static int m_commandPressedDown;
    private int[] m_keyBuffer;
    private int[] m_keyBufferSpare;
    private int m_keyBufferIndex;
    private static final byte SELECT_CAR_STATE_QUICKRACE = 0;
    private static final byte SELECT_CAR_STATE_CAREER = 1;
    private static final byte SELECT_CAR_STATE_SET_ACTIVE = 2;
    private static final byte SELECT_CAR_STATE_BUY = 3;
    private byte m_carSelectState;
    private int m_carSelectIndex;
    private boolean m_inCareer = false;
    private int m_selectCommandID;
    private int m_cancelCommandID;
    private MonkeyApp m_midlet;
    private boolean m_gameRunning;
    private SceneGame m_currentScene;
    private Random m_randomInstance;
    private boolean m_paused;
    private int m_lastPercentage = -1;
    public boolean m_splashDone;
    private static final int SETTINGS_VERSION = 166;
    private boolean m_rmsVibrationEnabled;
    public boolean m_rmsCarMarkersEnabled;
    public boolean m_rmsSpeedunitsMPH;
    public static int s_rmsLanguageIndex;
    public static int s_numLanguages;
    private boolean m_rmsGameExists;
    private int m_rmsCareerActiveCarIndex;
    private int m_rmsCareerMoney;
    private int m_rmsNumOwnedCars;
    private boolean[] m_rmsOwnedCar;
    private byte m_rmsHubUnlocked;
    private boolean m_curEventPreviouslyCompleted = true;
    private byte[][] m_rmsAccessoryLevel;
    private boolean m_hubRecentlyUnlocked = false;
    private boolean[][] m_rmsEventsCleared;
    private byte m_nextRaceNumLaps;
    private byte m_nextRaceType;
    private int m_playerCarIndex;
    private int[] m_raceStandingsLapTimes = null;
    private int m_raceStandingsPlayerPos = 0;
    private short[] m_carDescriptions;
    private int[] m_carParamTyres;
    private int[] m_carParamSteeringInc;
    private int[] m_carParamSteeringRecentreInc;
    private int[] m_carParamSteeringMax;
    private byte[] m_carNumGears;
    private int[][] m_carGearAccels;
    private int[][] m_carGearMaxSpeeds;
    private int[][] m_carGearMinSpeeds;
    private int[] m_carPrices;
    private int[] m_carFlags;
    private int[] m_carSelectAnimIDs;
    private int[] m_carSelectImageIDs;
    private int[] m_playerCarLoadMasks;
    private int[] m_oppCarLoadMasks;
    private int[][] m_playerCarAnimIDs;
    private int[] m_oppCarAnimIDs;
    private int[] m_playerCrashLeftAnimID;
    private int[] m_playerCrashRightAnimID;
    private int[] m_carScaledOncomingAnimIDs;
    private int m_carNowRacingParamTyresF;
    private int m_carNowRacingParamSteeringIncF;
    private int m_carNowRacingParamSteeringRecentreIncF;
    private int m_carNowRacingParamSteeringMaxF;
    private int[] m_carNowRacingGearAccelsF;
    private int[] m_carNowRacingGearMaxSpeedsF;
    private int[] m_carNowRacingGearMinSpeedsF;
    private int m_carNowRacingNitroMultF;
    private int m_carNowRacingHubIndex;
    private int m_carNowRacingEventIndex;
    private byte m_numEventHubs;
    private short[] m_eventHubNames;
    private short[] m_eventHubEventCounts;
    private short[][] m_eventTypes;
    private short[][] m_eventNumLaps;
    private short[][] m_eventNames;
    private short[][] m_eventTrackIDs;
    private byte[] m_stringChars;
    private int[] m_stringOffsets;
    private static SDKString s_pageFooterString;
    public ResourceManager m_resourceManager = null;
    private char[] m_percentString = new char[4];
    private int[] m_frameIntervals = new int[]{70, 70, 70, 70, 70, 70, 70, 70};
    private int m_frameIntervalIndex = 0;
    private byte[] m_trackInfoDataIDs;
    private byte[] m_trackInfoThemeIDs;
    private int m_currTrack;
    private int m_numTracks;
    private boolean m_runGarbageCollect;
    private static AppEngine m_singletonAppEngine;
    private static final String RMS_SETTINGS = "gamesett";
    private static final String RMS_DATA = "gamedata";
    private Timer m_gameTimer = null;
    private boolean m_paintScheduled = false;
    public static boolean light;
    public static boolean bBacklightOn;
    public static boolean appResumed;
    private static final int RIM_VOLUME_UP = -150;
    private static final int RIM_VOLUME_DOWN = -151;
    private static final int RIM_VOLUME_MAX = 100;
    private static final int RIM_VOLUME_MIN = 0;
    private static final int RIM_VOLUME_STEP = 20;
    private static final int RIM_VOLUME_MUTE = 273;
    private int soundVolumeBeforeMute = -1;
    private static final short WRAP_CHAR = 124;
    private static final int MAX_WRAP_OFFSETS = 255;
    private static final int MAX_WRAP_CHUNKS = 10;
    private static final int MAX_WRAP_CHUNK_OFFSETS = 5;
    private static short[] s_wrapOffsets;
    private static SDKString s_wrapString;
    private static short[][] s_wrapChunkOffsets;
    private static SDKString[] s_wrapChunkStrings;
    private Object font;
    private Object font1;
    private Image fontImage;
    private Image fontImage1;
    private static SDKString m_sdkString;
    private static final int MAX_BLOCK_SIZE = 10000;
    private static final byte[] blockBuf;
    public static final int SOFTKEYBAR_HEIGHT = 12;
    final SDKString LSK_LABEL = new SDKString("Q");
    final SDKString RSK_LABEL = new SDKString("P");
    private static final int INFOLINE_PADDING = 10;
    private static final int INFOLINE_HEIGHT = 14;
    public static final int M_PI_3 = 68629;
    public static final int M_2PI = 411775;
    public static final int M_PI_2 = 102944;
    public static final int M_PI_4 = 51472;
    public static final int M_PI_16 = 12868;
    private static final int M_PI_Q16 = 205887;
    private static final int M_PI_Q16_INV = 20861;
    public static final int M_ONE_FIXED = 65536;

    public boolean isCarNowRacingCareer() {
        return this.m_inCareer;
    }

    public MonkeyApp getMidlet() {
        return this.m_midlet;
    }

    public boolean isVibrationEnabled() {
        return this.m_rmsVibrationEnabled;
    }

    public void setVibrationEnabled(boolean bl) {
        this.m_rmsVibrationEnabled = bl;
    }

    public void setEventCleared() {
        if (this.m_carNowRacingHubIndex < this.m_rmsEventsCleared.length) {
            boolean[] blArray = this.m_rmsEventsCleared[this.m_carNowRacingHubIndex];
            boolean bl = blArray[this.m_carNowRacingEventIndex];
            blArray[this.m_carNowRacingEventIndex] = true;
            for (int i = blArray.length - 1; i != -1; --i) {
                if (blArray[i]) continue;
                this.saveRMSGameData();
                return;
            }
            this.m_rmsHubUnlocked = (byte)(this.m_rmsHubUnlocked + 1);
            this.m_hubRecentlyUnlocked = !bl;
            this.saveRMSGameData();
        }
    }

    private int getNthBuyableCar(int n) {
        for (int i = 0; i < this.m_carFlags.length; ++i) {
            if ((this.m_carFlags[i] & 1) == 0) continue;
            if (n == 0) {
                return i;
            }
            --n;
        }
        return -1;
    }

    private int getNthOwnedCar(int n) {
        for (int i = 0; i < this.m_rmsOwnedCar.length; ++i) {
            if (!this.m_rmsOwnedCar[i]) continue;
            if (n == 0) {
                return i;
            }
            --n;
        }
        return -1;
    }

    private int getNthNonOwnedCar(int n) {
        for (int i = 0; i < this.m_rmsOwnedCar.length; ++i) {
            if (this.m_rmsOwnedCar[i]) continue;
            if (n == 0) {
                return i;
            }
            --n;
        }
        return -1;
    }

    public void setNextRaceNumLaps(byte by) {
        this.m_nextRaceNumLaps = by;
    }

    public byte getNextRaceNumLaps() {
        return this.m_nextRaceNumLaps;
    }

    public void setNextRaceType(byte by) {
        this.m_nextRaceType = by;
    }

    public byte getNextRaceType() {
        return this.m_nextRaceType;
    }

    public int getTrackType(int n) {
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        while (!bl && n2 < this.m_eventTrackIDs.length) {
            n3 = 0;
            while (!bl && n3 < this.m_eventTrackIDs[n2].length) {
                if (this.m_eventTrackIDs[n2][n3] == n) {
                    bl = true;
                    continue;
                }
                ++n3;
            }
            if (bl) continue;
            ++n2;
        }
        if (bl) {
            return this.m_eventTypes[n2][n3];
        }
        return -1;
    }

    public void submitRaceStandings(GameObject[] gameObjectArray, boolean bl) {
        if (gameObjectArray == null) {
            this.m_raceStandingsLapTimes = null;
            return;
        }
        this.m_patrolModeSuccess = bl;
        int n = gameObjectArray.length;
        this.m_raceStandingsLapTimes = new int[n];
        int n2 = 0;
        for (int i = 0; i < gameObjectArray.length; ++i) {
            if (gameObjectArray[i].m_type == 1) {
                this.m_raceStandingsPlayerPos = n2;
            }
            this.m_raceStandingsLapTimes[n2] = gameObjectArray[i].m_cumulativeLapTimes;
            ++n2;
        }
    }

    public int[] getRaceStandings() {
        return this.m_raceStandingsLapTimes;
    }

    public int getPlayerRacePosition() {
        return this.m_raceStandingsPlayerPos;
    }

    public int getOpponentCarAnimID(int n) {
        return this.m_oppCarAnimIDs[n];
    }

    public int[] getPlayerCarAnimIDs(int n) {
        return this.m_playerCarAnimIDs[n];
    }

    public int getOpponentCarLoadMask(int n) {
        return this.m_oppCarLoadMasks[n] << 2;
    }

    public int getPlayerCarLoadMask(int n) {
        return this.m_playerCarLoadMasks[n] << 2;
    }

    public int getPlayerCarCrashLeftAnimID(int n) {
        return this.m_playerCrashLeftAnimID[n];
    }

    public int getPlayerCarCrashRightAnimID(int n) {
        return this.m_playerCrashRightAnimID[n];
    }

    public int getCurrTrack() {
        return this.m_currTrack;
    }

    public void setCurrTrack(int n) {
        this.m_currTrack = n;
    }

    public int getTrackDataResID(int n) {
        return this.m_trackInfoDataIDs[n];
    }

    public int getTrackThemeID(int n) {
        return this.m_trackInfoThemeIDs[n];
    }

    public int getNumTracks() {
        return this.m_numTracks;
    }

    public int getCarNowRacingHubIndex() {
        return this.m_carNowRacingHubIndex;
    }

    public int getCarNowRacingEventIndex() {
        return this.m_carNowRacingEventIndex;
    }

    public static void createAppEngine(MonkeyApp monkeyApp) {
        m_singletonAppEngine = new AppEngine(monkeyApp);
    }

    public static AppEngine getCanvas() {
        return m_singletonAppEngine;
    }

    private AppEngine(MonkeyApp monkeyApp) {
        super(false);
        ResourceManager resourceManager;
        this.setFullScreenMode(true);
        Application.getApplication().addSystemListener((SystemListener)this);
        this.m_midlet = monkeyApp;
        this.m_gameRunning = false;
        this.m_patrolModeSuccess = false;
        this.m_keyBuffer = new int[8];
        this.m_keyBufferSpare = new int[8];
        this.m_keyBufferIndex = 0;
        this.m_runGarbageCollect = false;
        this.m_resourceManager = resourceManager = new ResourceManager("");
        ResourceManager.initialiseSoundManager();
        this.m_randomInstance = new Random();
        s_pageFooterString = new SDKString(this.TEMP_STRING_BUFFER_LENGTH, 0);
        this.m_tempStringBuffer = new SDKString(this.TEMP_STRING_BUFFER_LENGTH, 0);
        this.m_resourceManager.loadAnimFile();
        this.m_resourceManager.loadSubimageFile();
        this.m_resourceManager.loadColorsFile();
        ResourceManager.loadSound(1, resourceManager);
        ResourceManager.loadSound(4, resourceManager);
        int n = 0;
        while (IMAGE_IDS[n << 1] != -1) {
            n = (short)(n + 1);
        }
        this.IMAGE_COUNT = (short)n;
        this.loadTrackInfo();
        this.loadCarData();
        this.calculateCarValues();
        this.loadEventHubData();
        this.loadRMSAppSettings();
        this.resetRMSGameData();
        this.loadRMSGameData();
        this.initWraps();
        this.loadTextSDKStrings();
        this.m_resourceManager.setSoundVolume(80);
        this.setSharedMenu(75);
        this.loadImages(0x1000000);
    }

    public int getHalfWidth() {
        return this.getWidth() >> 1;
    }

    public int getHalfHeight() {
        return this.getHeight() >> 1;
    }

    public ResourceManager getResourceManager() {
        return this.m_resourceManager;
    }

    public synchronized void start() {
        if (s_rmsLanguageIndex == -1) {
            this.setSharedMenu(30);
        }
        this.m_paused = false;
    }

    public void end() {
        int n;
        this.m_gameRunning = false;
        if (this.m_currentScene != null) {
            int n2 = n = !this.m_currentScene.isLoadingComplete() ? 1 : 0;
            while (n != 0) {
                try {
                    this.wait(20L);
                    n = !this.m_currentScene.isLoadingComplete() ? 1 : 0;
                }
                catch (Exception exception) {
                    n = 0;
                }
            }
            this.m_currentScene.end();
        }
        for (n = AnimConstants.IMAGE_RES_IDS.length - 1; n >= 0; --n) {
            this.m_resourceManager.unloadImage(AnimConstants.IMAGE_RES_IDS[n]);
        }
        this.requestGC(true);
        ResourceManager.stopAllSounds();
    }

    private void resetRMSAppSettings() {
        this.m_rmsVibrationEnabled = true;
        this.m_rmsCarMarkersEnabled = true;
        s_rmsLanguageIndex = -1;
        this.m_rmsSpeedunitsMPH = true;
    }

    public void resetRMSGameData() {
        int n;
        int n2;
        this.m_carNowRacingHubIndex = 0;
        this.m_sharedMenuSelect = 0;
        this.m_rmsGameExists = false;
        this.m_rmsCareerActiveCarIndex = 0;
        this.m_rmsCareerMoney = 200000;
        this.m_rmsNumOwnedCars = 1;
        this.m_rmsOwnedCar = new boolean[this.m_carDescriptions.length];
        this.m_rmsOwnedCar[0] = true;
        for (n2 = 1; n2 < this.m_rmsOwnedCar.length; ++n2) {
            this.m_rmsOwnedCar[n2] = false;
        }
        this.m_rmsHubUnlocked = 0;
        if (this.m_rmsEventsCleared == null) {
            this.m_rmsEventsCleared = new boolean[this.m_numEventHubs][];
        }
        for (n2 = 0; n2 < this.m_rmsEventsCleared.length; n2 = (int)((byte)(n2 + 1))) {
            if (this.m_rmsEventsCleared[n2] == null) {
                this.m_rmsEventsCleared[n2] = new boolean[this.m_eventHubEventCounts[n2]];
            }
            for (n = 0; n < this.getEventHubEventCount((byte)n2); n = (int)((byte)(n + 1))) {
                this.m_rmsEventsCleared[n2][n] = false;
            }
        }
        if (this.m_rmsAccessoryLevel == null) {
            this.m_rmsAccessoryLevel = new byte[this.getNumCars()][4];
        }
        for (n2 = 0; n2 < this.getNumCars(); ++n2) {
            for (n = 0; n < 4; ++n) {
                this.m_rmsAccessoryLevel[n2][n] = 0;
            }
        }
    }

    private void loadRMSAppSettings() {
        RecordStore recordStore = null;
        ByteArrayInputStream byteArrayInputStream = null;
        FilterInputStream filterInputStream = null;
        try {
            recordStore = RecordStore.openRecordStore((String)RMS_SETTINGS, (boolean)false);
            byte[] byArray = recordStore.getRecord(1);
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            filterInputStream = new DataInputStream(byteArrayInputStream);
            int n = ((DataInputStream)filterInputStream).readInt();
            if (n == 166) {
                this.m_rmsVibrationEnabled = ((DataInputStream)filterInputStream).readBoolean();
                this.m_rmsCarMarkersEnabled = ((DataInputStream)filterInputStream).readBoolean();
                s_rmsLanguageIndex = ((DataInputStream)filterInputStream).readByte();
                this.m_rmsSpeedunitsMPH = ((DataInputStream)filterInputStream).readBoolean();
            } else {
                this.resetRMSAppSettings();
                this.saveRMSAppSettings();
            }
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            this.resetRMSAppSettings();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            filterInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            byteArrayInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (recordStore != null) {
            try {
                recordStore.closeRecordStore();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void loadRMSGameData() {
        RecordStore recordStore = null;
        ByteArrayInputStream byteArrayInputStream = null;
        FilterInputStream filterInputStream = null;
        try {
            recordStore = RecordStore.openRecordStore((String)RMS_DATA, (boolean)false);
            byte[] byArray = recordStore.getRecord(1);
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            filterInputStream = new DataInputStream(byteArrayInputStream);
            int n = ((DataInputStream)filterInputStream).readInt();
            if (n == 166) {
                this.m_rmsHubUnlocked = ((DataInputStream)filterInputStream).readByte();
                for (int n2 = 0; n2 < this.m_rmsEventsCleared.length; n2 = (int)((byte)(n2 + 1))) {
                    short s = this.m_eventHubEventCounts[n2];
                    boolean[] blArray = this.m_rmsEventsCleared[n2];
                    for (short s2 = 0; s2 != s; s2 = (short)((byte)(s2 + 1))) {
                        blArray[s2] = ((DataInputStream)filterInputStream).readBoolean();
                    }
                }
            } else {
                this.resetRMSGameData();
                this.saveRMSGameData();
            }
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            this.resetRMSGameData();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            filterInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            byteArrayInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (recordStore != null) {
            try {
                recordStore.closeRecordStore();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean saveRMSAppSettings() {
        boolean bl = false;
        RecordStore recordStore = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(166);
            dataOutputStream.writeBoolean(this.m_rmsVibrationEnabled);
            dataOutputStream.writeBoolean(this.m_rmsCarMarkersEnabled);
            dataOutputStream.writeByte(s_rmsLanguageIndex);
            dataOutputStream.writeBoolean(this.m_rmsSpeedunitsMPH);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            recordStore = RecordStore.openRecordStore((String)RMS_SETTINGS, (boolean)true);
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(byArray, 0, byArray.length);
            } else {
                recordStore.setRecord(1, byArray, 0, byArray.length);
            }
        }
        catch (Exception exception) {
            bl = true;
        }
        try {
            dataOutputStream.close();
        }
        catch (Exception exception) {
            bl = true;
        }
        try {
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            bl = true;
        }
        if (recordStore != null) {
            try {
                recordStore.closeRecordStore();
            }
            catch (Exception exception) {
                bl = true;
            }
        }
        return !bl;
    }

    public boolean saveRMSGameData() {
        boolean bl = false;
        RecordStore recordStore = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(166);
            dataOutputStream.writeByte(this.m_rmsHubUnlocked);
            for (int n = 0; n < this.m_rmsEventsCleared.length; n = (int)((byte)(n + 1))) {
                for (int n2 = 0; n2 < this.m_rmsEventsCleared[n].length; n2 = (int)((byte)(n2 + 1))) {
                    dataOutputStream.writeBoolean(this.m_rmsEventsCleared[n][n2]);
                }
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            recordStore = RecordStore.openRecordStore((String)RMS_DATA, (boolean)true);
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(byArray, 0, byArray.length);
            } else {
                recordStore.setRecord(1, byArray, 0, byArray.length);
            }
        }
        catch (Exception exception) {
            bl = true;
        }
        try {
            dataOutputStream.close();
        }
        catch (Exception exception) {
            bl = true;
        }
        try {
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            bl = true;
        }
        if (recordStore != null) {
            try {
                recordStore.closeRecordStore();
            }
            catch (Exception exception) {
                bl = true;
            }
        }
        return !bl;
    }

    public void showNotify() {
        if (this.m_paused) {
            this.resumeGame();
            this.startThread();
        }
    }

    public void hideNotify() {
        this.pauseGame();
    }

    public void startThread() {
        this.m_gameRunning = true;
        if (this.m_gameTimer != null) {
            this.m_gameTimer.cancel();
            this.m_gameTimer = null;
            System.gc();
        }
        this.m_gameTimer = new Timer();
        this.m_gameTimer.schedule(new TimerTask(){
            long timeStartFrame = System.currentTimeMillis();

            public void run() {
                if (!AppEngine.this.m_gameRunning) {
                    try {
                        AppEngine.this.m_midlet.destroyApp(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
                if (!AppEngine.this.m_paused && !AppEngine.this.m_paintScheduled) {
                    AppEngine.this.m_paintScheduled = true;
                    long l = System.currentTimeMillis();
                    AppEngine.this.runLoop((int)(l - this.timeStartFrame));
                    this.timeStartFrame = l;
                    if (AppEngine.this.m_currentScene != null) {
                        AppEngine.this.m_currentScene.repaintScene();
                    }
                    AppEngine.this.repaint();
                }
            }
        }, 0L, 10L);
    }

    public void runLoop(int n) {
        int[] nArray = this.m_keyBuffer;
        int n2 = this.m_keyBufferIndex;
        this.m_keyBuffer = this.m_keyBufferSpare;
        this.m_keyBufferIndex = 0;
        this.m_keyBufferSpare = nArray;
        int n3 = m_keysPressedDown;
        int n4 = m_commandPressedDown;
        int n5 = n3;
        int n6 = n4;
        for (int i = 0; i != n2; ++i) {
            int n7 = nArray[i];
            if (n7 < 0) {
                n3 &= ~(-n7);
                if (-n7 != 131072 && -n7 != 262144 && -n7 != 524288) continue;
                n4 = 0;
                continue;
            }
            n3 |= n7;
            n5 |= n7;
            if (n7 == 262144) {
                n6 = n4 = this.m_cancelCommandID;
                continue;
            }
            if (n7 == 131072) {
                n6 = n4 = this.m_selectCommandID;
                continue;
            }
            if (n7 != 524288) continue;
            n6 = n4 = this.m_cancelCommandID;
        }
        m_keysPressedDown = n3;
        m_commandPressedDown = n4;
        this.update(n, n5, n6);
        if (this.m_runGarbageCollect) {
            System.gc();
            this.m_runGarbageCollect = false;
        }
    }

    public boolean endGame(String string) {
        try {
            if (string != null) {
                this.m_midlet.platformRequest(string);
            }
            this.endGame();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void endGame() {
        ResourceManager.stopAllSounds();
        this.m_gameRunning = false;
    }

    public void pauseGame() {
        this.clearCommandKeys();
        this.clearKeysPressedDown();
        ResourceManager.stopAllSounds();
        if (this.m_currentScene != null) {
            this.m_currentScene.pause();
        }
        this.m_paused = true;
    }

    public void resumeGame() {
        if (this.m_currentScene != null) {
            if (this.m_currentScene.isLoadingComplete()) {
                this.m_currentScene.resume();
                if (this.m_sharedMenuState == 0) {
                    this.setSharedMenu(this.m_currentScene.menuAfterInterrupt());
                }
            }
        } else {
            ResourceManager.startLastMusic();
        }
        this.clearCommandKeys();
        this.clearKeysPressedDown();
        this.m_keyBufferIndex = 0;
        this.m_paused = false;
    }

    public boolean isPaused() {
        return this.m_paused;
    }

    public boolean isGameEnded() {
        return !this.m_gameRunning;
    }

    public int rand(int n, int n2) {
        int n3 = this.m_randomInstance.nextInt() & Integer.MAX_VALUE;
        int n4 = n2 - n + 1;
        return n + n3 % n4;
    }

    public void vibrate(int n) {
        if (this.m_rmsVibrationEnabled) {
            try {
                SDKSoundManager.getManager().vibrate(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private final synchronized void update(int n, int n2, int n3) {
        byte by;
        if (!bBacklightOn) {
            light = true;
            this.pauseGame();
            if (this.m_sharedMenuState == 0) {
                this.resumeGame();
            }
        }
        if ((by = this.m_sharedMenuState) == 1 || by == 2 || by == 3 || by == 5) {
            this.m_sharedMenuSplashTime -= n;
            if (this.m_sharedMenuSplashTime < 0) {
                int n4 = 25;
                if (by == 1) {
                    n4 = 2;
                } else if (by == 2) {
                    n4 = 3;
                } else if (by == 3) {
                    n4 = 5;
                } else if (by == 5) {
                    this.saveRMSAppSettings();
                }
                this.setSharedMenu(n4);
            }
        }
        if (n > 250) {
            n = 250;
        }
        n = this.getAverageInterval(n);
        if (this.m_sharedMenuState == 0) {
            this.m_currentScene.processKeys(n2, n3);
            this.m_currentScene.update(n);
        } else {
            this.processKeysSharedMenu(n2, n3);
        }
    }

    public void backlightStateChange(boolean bl) {
        bBacklightOn = bl;
    }

    public void cradleMismatch(boolean bl) {
    }

    public void fastReset() {
    }

    public void powerOffRequested(int n) {
    }

    public void usbConnectionStateChange(int n) {
    }

    public void batteryStatusChange(int n) {
    }

    public void batteryGood() {
    }

    public void batteryLow() {
    }

    public void powerOff() {
    }

    public void powerUp() {
    }

    public final synchronized void paint(Graphics graphics) {
        SDKUtils.setGraphics(graphics);
        if (this.m_sharedMenuState != 0) {
            if (this.m_sharedMenuRenderBackground && this.m_currentScene != null) {
                this.m_currentScene.render(graphics);
            }
            this.renderSharedMenu(graphics);
        } else {
            this.m_currentScene.render(graphics);
        }
        this.m_paintScheduled = false;
    }

    public int toCanvasKey(int n) {
        int n2 = n;
        switch (n2) {
            case 113: {
                return -6;
            }
            case 112: {
                return -7;
            }
            case 10: {
                return -5;
            }
            case 81: {
                return -6;
            }
            case 27: {
                return 27;
            }
            case 80: {
                return -7;
            }
        }
        switch (n2) {
            case 87: {
                return 119;
            }
            case 69: {
                return 101;
            }
            case 82: {
                return 114;
            }
            case 83: {
                return 115;
            }
            case 68: {
                return 100;
            }
            case 70: {
                return 102;
            }
            case 90: {
                return 122;
            }
            case 88: {
                return 120;
            }
            case 67: {
                return 99;
            }
            case 48: {
                return 48;
            }
        }
        return n;
    }

    public void keyPressed(int n) {
        int n2;
        int n3;
        if (light && this.m_sharedMenuState != 0) {
            this.resumeGame();
            light = false;
        }
        if ((n3 = (n = this.toCanvasKey(n))) == -150) {
            int n4 = Math.min(this.m_resourceManager.getSoundVolume() + 20, 100);
            this.m_resourceManager.setSoundVolume(n4);
            return;
        }
        if (n3 == -151) {
            int n5 = Math.max(this.m_resourceManager.getSoundVolume() - 20, 0);
            this.m_resourceManager.setSoundVolume(n5);
            return;
        }
        if (n3 == 273) {
            if (this.soundVolumeBeforeMute == -1) {
                this.soundVolumeBeforeMute = this.m_resourceManager.getSoundVolume();
                this.m_resourceManager.setSoundVolume(0);
            } else {
                this.m_resourceManager.setSoundVolume(this.soundVolumeBeforeMute);
                this.soundVolumeBeforeMute = -1;
            }
        }
        if ((n2 = this.translateKeycode(n)) != -1 && this.m_keyBufferIndex < this.m_keyBuffer.length) {
            this.m_keyBuffer[this.m_keyBufferIndex++] = n2;
        }
    }

    public void keyReleased(int n) {
        int n2;
        if ((n = this.toCanvasKey(n)) == 27) {
            this.keyPressed(27);
        }
        if ((n2 = this.translateKeycode(n)) != -1 && this.m_keyBufferIndex < this.m_keyBuffer.length) {
            this.m_keyBuffer[this.m_keyBufferIndex++] = -n2;
        }
    }

    public int translateKeycode(int n) {
        try {
            switch (n) {
                case 49: {
                    return 2;
                }
                case 50: {
                    return 4;
                }
                case 51: {
                    return 8;
                }
                case 52: {
                    return 16;
                }
                case 53: {
                    return 32;
                }
                case 54: {
                    return 64;
                }
                case 55: {
                    return 128;
                }
                case 56: {
                    return 256;
                }
                case 57: {
                    return 512;
                }
                case 48: {
                    return 1;
                }
                case 35: {
                    return 1024;
                }
                case 42: {
                    return 2048;
                }
                case -6: {
                    return 131072;
                }
                case -7: {
                    return 262144;
                }
                case -273: {
                    return 0;
                }
                case 119: {
                    return 2;
                }
                case 101: {
                    return 4;
                }
                case 114: {
                    return 8;
                }
                case 115: {
                    return 16;
                }
                case 100: {
                    return 32;
                }
                case 102: {
                    return 64;
                }
                case 122: {
                    return 128;
                }
                case 120: {
                    return 256;
                }
                case 99: {
                    return 512;
                }
                case 27: {
                    return 524288;
                }
                case 1: {
                    return 8192;
                }
                case 6: {
                    return 16384;
                }
                case 2: {
                    return 32768;
                }
                case 5: {
                    return 65536;
                }
                case -8: {
                    return 4096;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    public void clearKeyBit(int n) {
        m_keysPressedDown &= ~n;
    }

    public void clearKeysPressedDown() {
        m_keysPressedDown = 0;
    }

    public void clearCommandKeys() {
        m_commandPressedDown = 0;
        this.clearKeyBit(524288);
    }

    public void setSoftKeys(int n, int n2) {
        this.m_selectCommandID = n2;
        this.m_cancelCommandID = n;
    }

    private int getCommandString(int n) {
        switch (n) {
            case 0: {
                return -1;
            }
            case 1: {
                return 21;
            }
            case 2: {
                return 9;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 12;
            }
            case 5: {
                return 7;
            }
            case 6: {
                return 15;
            }
            case 7: {
                return 5;
            }
            case 8: {
                return 6;
            }
            case 9: {
                return 18;
            }
            case 10: {
                return 10;
            }
            case 11: {
                return 16;
            }
            case 12: {
                return 22;
            }
        }
        return -1;
    }

    public int getSelectCommandID() {
        return this.m_selectCommandID;
    }

    public int getCancelCommandID() {
        return this.m_cancelCommandID;
    }

    private void initWraps() {
        s_wrapOffsets = new short[255];
        AppEngine.s_wrapOffsets[0] = 0;
        s_wrapChunkOffsets = new short[10][5];
        for (int i = 0; i < 10; ++i) {
            AppEngine.s_wrapChunkOffsets[i][0] = 0;
        }
        s_wrapChunkStrings = new SDKString[10];
    }

    public int wrapString(int n, int n2) {
        if (n <= 0) {
            return 0;
        }
        s_wrapString = this.getString(n);
        if (n == 33) {
            String string = this.m_midlet.getAppProperty("MIDlet-Version");
            s_wrapString = s_wrapString.replaceFirst(string);
        }
        SDKUtils.wrapString(s_wrapString, s_wrapOffsets, n2, (short)124);
        return s_wrapOffsets[0];
    }

    public int wrapString(SDKString sDKString, int n) {
        if (sDKString == null) {
            return 0;
        }
        s_wrapString = sDKString;
        SDKUtils.wrapString(s_wrapString, s_wrapOffsets, n, (short)124);
        return s_wrapOffsets[0];
    }

    int getNumWrappedLines() {
        return s_wrapOffsets[0];
    }

    public void drawWrappedString(Graphics graphics, int n, int n2, int n3) {
        SDKUtils.drawWrappedString(s_wrapString, s_wrapOffsets, 1, s_wrapOffsets[0], n, n2, n3);
    }

    public void drawPartWrappedString(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        n5 = Math.min(s_wrapOffsets[0] - n4, n5);
        if ((n3 & 2) != 0) {
            int n6 = SDKUtils.getLineSize();
            int n7 = n5 * n6;
            int n8 = n7 >> 1;
            n2 -= n8;
            n3 ^= 2;
            n3 |= 0x10;
        }
        SDKUtils.drawWrappedString(s_wrapString, s_wrapOffsets, n4 + 1, n5, n, n2, n3);
    }

    public int wrapStringChunk(int n, int n2, int n3) {
        if (n2 <= 0) {
            return 0;
        }
        AppEngine.s_wrapChunkStrings[n] = this.getString(n2);
        SDKUtils.wrapString(s_wrapChunkStrings[n], s_wrapChunkOffsets[n], n3, (short)124);
        return s_wrapChunkOffsets[n][0];
    }

    public int getNumWrappedLinesChunk(int n) {
        return s_wrapChunkOffsets[n][0];
    }

    public void drawWrappedStringChunk(int n, Graphics graphics, int n2, int n3, int n4) {
        SDKUtils.drawWrappedString(s_wrapChunkStrings[n], s_wrapChunkOffsets[n], 1, s_wrapChunkOffsets[n][0], n2, n3, n4);
    }

    public void drawString(Graphics graphics, int n, int n2, int n3, int n4) {
        if (n >= 0) {
            SDKString sDKString = this.getString(n);
            this.drawString(graphics, sDKString, n2, n3, n4);
        }
    }

    public void drawString(Graphics graphics, SDKString sDKString, int n, int n2, int n3) {
        if (sDKString != null) {
            if ((n3 & 2) != 0) {
                n2 -= SDKUtils.getBaselinePosition() >> 1;
            }
            SDKUtils.drawString(sDKString, n, n2, n3);
        }
    }

    public void drawMoveableString(Graphics graphics, int n, int n2, int n3, int n4) {
        if (n >= 0) {
            SDKString sDKString = this.getString(n);
            this.drawMoveableString(graphics, sDKString, n2, n3, n4);
        }
    }

    public void drawMoveableString(Graphics graphics, SDKString sDKString, int n, int n2, int n3) {
        if (sDKString != null) {
            int n4;
            int n5 = SDKUtils.getStringSize(sDKString);
            if (n5 <= (n4 = n2 - n + 1)) {
                this.drawString(graphics, sDKString, (n + n2) / 2, n3, 17);
            } else {
                int n6;
                int n7 = graphics.getClipX();
                int n8 = graphics.getClipY();
                int n9 = graphics.getClipWidth();
                int n10 = graphics.getClipHeight();
                graphics.setClip(n + 3, 0, n4 - 6, this.getHeight());
                long l = System.currentTimeMillis();
                int n11 = n2 - n5 - 3;
                int n12 = n + 3;
                int n13 = (int)(l % 1500L);
                int n14 = n6 = n13 >= 1000 ? n12 : n11 + (n12 - n11) * n13 / 1000;
                if (l % 3000L >= 1500L) {
                    n6 = -n6 + n11 + n12;
                }
                this.drawString(graphics, sDKString, n6, n3, 20);
                graphics.setClip(n7, n8, n9, n10);
            }
        }
    }

    public void loadTextSDKStrings() {
        Object object;
        Object object2;
        byte by;
        byte[] byArray = this.m_resourceManager.loadBinaryFileToByteArray(67);
        s_numLanguages = SDKUtils.loadTextHeader(byArray);
        byte by2 = by = (byte)SDKUtils.chooseLanguage(s_rmsLanguageIndex);
        if (by < 0) {
            by = 0;
        }
        try {
            object2 = ResourceConstants.RESOURCE_FILENAMES_LIST[56];
            this.fontImage = Image.createImage((String)object2);
            object = ResourceConstants.RESOURCE_FILENAMES_LIST[54];
            this.fontImage1 = Image.createImage((String)object);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        object2 = this.m_resourceManager.loadBinaryFileToByteArray(55);
        this.font1 = SDKUtils.loadFont(this.fontImage1, (byte[])object2);
        SDKUtils.setFont(this.font1);
        object = this.m_resourceManager.loadBinaryFileToByteArray(57);
        this.loadLanguageChunks(by);
        this.font = SDKUtils.loadFont(this.fontImage, (byte[])object);
        SDKUtils.setFont(this.font);
        s_rmsLanguageIndex = by2;
    }

    public boolean initMoreGames() {
        return false;
    }

    public void loadLanguageChunks(int n) {
        s_rmsLanguageIndex = n;
        SDKUtils.setCurrentLanguage(n);
        SDKUtils.loadStringsChunk(1);
    }

    private byte[] loadBlock(String string) {
        byte[] byArray = null;
        InputStream inputStream = null;
        try {
            inputStream = "".getClass().getResourceAsStream(string);
            if (inputStream != null) {
                int n = inputStream.read(blockBuf);
                int n2 = 0;
                int n3 = 10000;
                while (n > 0) {
                    n = inputStream.read(blockBuf, n2 += n, n3 -= n);
                }
                byArray = new byte[n2];
                System.arraycopy(blockBuf, 0, byArray, 0, n2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byArray;
    }

    public int getStringWidth(int n) {
        SDKString sDKString = SDKUtils.getString(n, null);
        return SDKUtils.getStringSize(sDKString);
    }

    public void intToSDKString(int n, boolean bl, SDKString sDKString) {
        boolean bl2;
        SDKString sDKString2 = this.getString(17);
        boolean bl3 = bl2 = n < 0;
        if (bl2) {
            n = -n;
        }
        int n2 = 0;
        if (n == 0) {
            sDKString.setCharAt(0, '0');
            n2 = 1;
        } else {
            int n3 = -1;
            boolean bl4 = false;
            for (int i = 1000000000; i > 0; i /= 10) {
                n3 = n / i;
                if (n3 != 0 || bl4) {
                    if (bl2 && !bl4) {
                        sDKString.setCharAt(0, '-');
                    }
                    bl4 = true;
                    sDKString.setCharAt(n2, (char)(48 + n3));
                    ++n2;
                    if (bl && (i == 1000000000 || i == 1000000 || i == 1000)) {
                        sDKString.setLength(n2);
                        sDKString.append(sDKString2);
                        n2 = sDKString.length();
                    }
                }
                n -= n3 * i;
            }
        }
        sDKString.setLength(n2);
    }

    public SDKString getString(int n) {
        if (n <= 1) {
            return SDKUtils.getHeaderString(SDKUtils.getCurrentLanguage(), n, null);
        }
        return SDKUtils.getString(n, null);
    }

    public final void copyString(SDKString sDKString, int n) {
        sDKString.setLength(0);
        this.appendString(sDKString, n);
    }

    public final void copyString(SDKString sDKString, SDKString sDKString2) {
        sDKString.setLength(0);
        this.appendString(sDKString, sDKString2);
    }

    public final void copyString(SDKString sDKString, String string) {
        sDKString.setLength(0);
        this.appendString(sDKString, string);
    }

    public final void appendString(SDKString sDKString, int n) {
        sDKString.append(this.getString(n));
    }

    public final void appendString(SDKString sDKString, SDKString sDKString2) {
        sDKString.append(sDKString2);
    }

    public final void appendString(SDKString sDKString, String string) {
        int n = string.length();
        int n2 = sDKString.length();
        for (int i = 0; i != n; ++i) {
            sDKString.setCharAt(n2 + i, string.charAt(i));
        }
        sDKString.setLength(n2 + n);
    }

    private String addLeadingZerosToTimePart(int n, boolean bl) {
        String string = n < 10 ? (bl ? "0" : "00") : "";
        return string;
    }

    public SDKString raceTimeToFormattedTime(long l, boolean bl) {
        String string = null;
        int n = (int)((l >>= 6) / 1000L);
        int n2 = 0;
        if (bl) {
            n2 = (int)l - n * 1000;
        }
        int n3 = n / 60;
        String string2 = this.addLeadingZerosToTimePart(n -= n3 * 60, true);
        String string3 = this.addLeadingZerosToTimePart(n2, false);
        if (!bl) {
            string = Integer.toString(n3) + ":" + string2 + Integer.toString(n);
        } else {
            String string4 = this.getString(90).toString();
            string = Integer.toString(n3) + ":" + string2 + Integer.toString(n) + string4 + string3 + Integer.toString(n2);
        }
        return new SDKString(string);
    }

    public void requestGC(boolean bl) {
        if (bl) {
            System.gc();
            this.m_runGarbageCollect = false;
        } else {
            this.m_runGarbageCollect = true;
        }
    }

    public void renderSoftKeys(Graphics graphics, boolean bl) {
        if (this.m_selectCommandID != 0 || this.m_cancelCommandID != 0) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            int n3 = n2 - 12;
            graphics.setClip(0, n3, n, 12);
            this.m_resourceManager.setColor(graphics, 44);
            graphics.fillRect(0, n3, n, 12);
            int n4 = 73;
            int n5 = 74;
            this.renderSoftKeyButton(graphics, this.m_selectCommandID, n4, 0, n2, 20, bl);
            this.renderSoftKeyButton(graphics, this.m_cancelCommandID, n5, n, n2, 24, bl);
        }
    }

    public void renderSoftKeyButton(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl) {
        if (n != 0) {
            int n6 = this.getCommandString(n);
            if (!bl) {
                this.m_resourceManager.drawAnimFrame(graphics, n2, 0, n3, n4);
            }
            this.drawString(graphics, n6, n3 + this.m_resourceManager.getAnimFrameFirePointX(n2, 0, 1), n4 + this.m_resourceManager.getAnimFrameFirePointY(n2, 0, 1), n5);
            SDKString sDKString = null;
            if ((n5 & 4) != 0) {
                sDKString = this.LSK_LABEL;
            } else if ((n5 & 8) != 0) {
                sDKString = this.RSK_LABEL;
            }
            if (sDKString != null) {
                this.drawString(graphics, sDKString, n3 + this.m_resourceManager.getAnimFrameFirePointX(n2, 0, 0), n4 + this.m_resourceManager.getAnimFrameFirePointY(n2, 0, 0), n5);
            }
        }
    }

    public void renderLoading(Graphics graphics, int n) {
        ResourceManager resourceManager = this.m_resourceManager;
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        int n4 = 8 + SDKUtils.getLineSize();
        int n5 = (n3 - n4 >> 1) - 2;
        int n6 = n3 + n4 >> 1;
        int n7 = n5 + 2 + 4;
        int n8 = n * n2 / 100;
        this.m_resourceManager.setColor(graphics, 43);
        graphics.fillRect(0, 0, n2, n3);
        this.drawString(graphics, 8, n2 >> 1, n7, 17);
        resourceManager.setColor(graphics, 46);
        graphics.fillRect(0, n5, n8, 2);
        graphics.fillRect(0, n6, n8, 2);
        this.m_resourceManager.setColor(graphics, 45);
        graphics.fillRect(n8, n5, n2 - n8, 2);
        graphics.fillRect(n8, n6, n2 - n8, 2);
    }

    private int getAverageInterval(int n) {
        this.m_frameIntervals[this.m_frameIntervalIndex] = n;
        if (++this.m_frameIntervalIndex > 7) {
            this.m_frameIntervalIndex = 0;
        }
        int n2 = this.m_frameIntervals[0] + this.m_frameIntervals[1] + this.m_frameIntervals[2] + this.m_frameIntervals[3] + this.m_frameIntervals[4] + this.m_frameIntervals[5] + this.m_frameIntervals[6] + this.m_frameIntervals[7];
        return n2 >>= 3;
    }

    private void loadTrackInfo() {
        try {
            InputStream inputStream = this.m_resourceManager.loadBinaryFile(52);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            this.m_numTracks = dataInputStream.readByte();
            this.m_trackInfoDataIDs = new byte[this.m_numTracks];
            this.m_trackInfoThemeIDs = new byte[this.m_numTracks];
            for (int i = 0; i < this.m_numTracks; ++i) {
                this.m_trackInfoThemeIDs[i] = dataInputStream.readByte();
                this.m_trackInfoDataIDs[i] = dataInputStream.readByte();
            }
            this.m_nextRaceType = 0;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void tryDefragMemory(int n) {
        if (n <= 0) {
            n = 20;
        }
        System.gc();
        try {
            Thread.sleep(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadCarData() {
        try {
            InputStream inputStream = this.m_resourceManager.loadBinaryFile(1);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            int n = dataInputStream.readByte();
            dataInputStream.close();
            dataInputStream = null;
            inputStream = null;
            System.gc();
            this.m_carDescriptions = new short[n];
            this.m_carParamTyres = new int[n];
            this.m_carParamSteeringInc = new int[n];
            this.m_carParamSteeringRecentreInc = new int[n];
            this.m_carParamSteeringMax = new int[n];
            this.m_carNumGears = new byte[n];
            this.m_carGearAccels = new int[n][];
            this.m_carGearMinSpeeds = new int[n][];
            this.m_carGearMaxSpeeds = new int[n][];
            this.m_carFlags = new int[n];
            this.m_carSelectAnimIDs = new int[n];
            this.m_carSelectImageIDs = new int[n];
            this.m_oppCarAnimIDs = new int[n];
            this.m_oppCarLoadMasks = new int[n];
            this.m_playerCarAnimIDs = new int[n][];
            this.m_playerCrashLeftAnimID = new int[n];
            this.m_playerCrashRightAnimID = new int[n];
            this.m_playerCarLoadMasks = new int[n];
            this.m_carScaledOncomingAnimIDs = new int[n];
            inputStream = this.m_resourceManager.loadBinaryFile(1);
            dataInputStream = new DataInputStream(inputStream);
            n = dataInputStream.readByte();
            for (int i = 0; i < n; ++i) {
                int n2;
                this.m_carDescriptions[i] = dataInputStream.readShort();
                this.m_playerCarLoadMasks[i] = dataInputStream.readInt();
                this.m_oppCarLoadMasks[i] = dataInputStream.readInt();
                this.m_oppCarAnimIDs[i] = dataInputStream.readShort();
                this.m_carScaledOncomingAnimIDs[i] = dataInputStream.readShort();
                this.m_carSelectAnimIDs[i] = dataInputStream.readShort();
                this.m_carSelectImageIDs[i] = dataInputStream.readShort();
                this.m_playerCarAnimIDs[i] = new int[5];
                for (n2 = 0; n2 < 5; ++n2) {
                    this.m_playerCarAnimIDs[i][n2] = dataInputStream.readShort();
                }
                this.m_playerCrashLeftAnimID[i] = dataInputStream.readShort();
                this.m_playerCrashRightAnimID[i] = dataInputStream.readShort();
                this.m_carFlags[i] = dataInputStream.readInt();
                this.m_carParamTyres[i] = dataInputStream.readInt();
                this.m_carParamSteeringInc[i] = dataInputStream.readInt();
                this.m_carParamSteeringRecentreInc[i] = dataInputStream.readInt();
                this.m_carParamSteeringMax[i] = dataInputStream.readInt();
                n2 = dataInputStream.readByte();
                this.m_carNumGears[i] = (byte)n2;
                int[] nArray = new int[n2];
                this.m_carGearAccels[i] = nArray;
                int[] nArray2 = new int[n2];
                this.m_carGearMinSpeeds[i] = nArray2;
                int[] nArray3 = new int[n2];
                this.m_carGearMaxSpeeds[i] = nArray3;
                for (int j = 0; j < this.m_carNumGears[i]; ++j) {
                    nArray[j] = dataInputStream.readInt() * PS_TO_MW_ACC_FACTOR;
                    nArray3[j] = dataInputStream.readInt() * PS_TO_MW_ACC_FACTOR;
                    nArray2[j] = j == 0 ? 0 : AppEngine.Fmul(nArray3[j - 1], 54591);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void calculateCarValues() {
        int n = this.getNumCars();
        int n2 = 0;
        int n3 = 0;
        CAR_VALUE_ACCEL_MIN_F = Integer.MAX_VALUE;
        CAR_VALUE_HANDLING_MIN_F = Integer.MAX_VALUE;
        for (int i = 0; i < n; ++i) {
            if ((this.m_carFlags[i] & 1) == 0) continue;
            n2 = Math.max(n2, this.m_carGearAccels[i][0]);
            CAR_VALUE_ACCEL_MIN_F = Math.min(CAR_VALUE_ACCEL_MIN_F, this.m_carGearAccels[i][0]);
            n3 = Math.max(n3, this.m_carParamTyres[i]);
            CAR_VALUE_HANDLING_MIN_F = Math.min(CAR_VALUE_HANDLING_MIN_F, this.m_carParamTyres[i]);
        }
        CAR_VALUE_ACCEL_MIN_F = AppEngine.Fmul(CAR_VALUE_ACCEL_MIN_F, 58982);
        CAR_VALUE_HANDLING_MIN_F = AppEngine.Fmul(CAR_VALUE_HANDLING_MIN_F, 58982);
        CAR_VALUE_ACCEL_MULTIPLIER_F = AppEngine.Fdiv(65536, n2 - CAR_VALUE_ACCEL_MIN_F);
        CAR_VALUE_HANDLING_MULTIPLIER_F = AppEngine.Fdiv(65536, n3 - CAR_VALUE_HANDLING_MIN_F);
        CAR_VALUE_NITRO_MIN_F = Short.MIN_VALUE;
        CAR_VALUE_NITRO_MULTIPLIER_F = AppEngine.Fdiv(65536, 262144 - CAR_VALUE_NITRO_MIN_F);
    }

    void loadImages(int n) {
        ResourceManager resourceManager = this.getResourceManager();
        int n2 = 0;
        while (IMAGE_IDS[n2 << 1] != -1) {
            if ((IMAGE_IDS[(n2 << 1) + 1] & n) != 0) {
                while (!resourceManager.loadImage(resourceManager, IMAGE_IDS[n2 << 1])) {
                    try {
                        Thread.sleep(16L);
                        System.gc();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            ++n2;
        }
        System.gc();
        try {
            Thread.sleep(16L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    void unloadImages(int n) {
        ResourceManager resourceManager = this.getResourceManager();
        int n2 = 0;
        while (IMAGE_IDS[n2 << 1] != -1) {
            if ((IMAGE_IDS[(n2 << 1) + 1] & n) != 0) {
                resourceManager.unloadImage(IMAGE_IDS[n2 << 1]);
            }
            ++n2;
        }
        System.gc();
        try {
            Thread.sleep(16L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public int getNumCars() {
        return this.m_carDescriptions.length;
    }

    public int getNumBuyableCars() {
        int n = 0;
        for (int i = 0; i < this.m_carFlags.length; ++i) {
            if ((this.m_carFlags[i] & 1) == 0) continue;
            ++n;
        }
        return n;
    }

    public int getNumCarsOwned() {
        return this.m_rmsNumOwnedCars;
    }

    public int getNumCarsNotOwned() {
        return this.getNumBuyableCars() - this.getNumCarsOwned();
    }

    public short getCarDescriptionStringID() {
        return this.getCarDescriptionStringID(this.m_playerCarIndex);
    }

    public short getCarDescriptionStringID(int n) {
        return this.m_carDescriptions[n];
    }

    public int getCarPrice(int n) {
        return this.m_carPrices[n];
    }

    public int getCarParamTyres() {
        return this.getCarParamTyres(this.m_playerCarIndex);
    }

    public int getCarParamTyres(int n) {
        return this.m_carParamTyres[n];
    }

    public int getCarParamSteeringInc() {
        return this.getCarParamSteeringInc(this.m_playerCarIndex);
    }

    public int getCarParamSteeringInc(int n) {
        return this.m_carParamSteeringInc[n];
    }

    public int getCarParamSteeringRecentreInc() {
        return this.getCarParamSteeringRecentreInc(this.m_playerCarIndex);
    }

    public int getCarParamSteeringRecentreInc(int n) {
        return this.m_carParamSteeringRecentreInc[n];
    }

    public int getCarParamSteeringMax() {
        return this.getCarParamSteeringMax(this.m_playerCarIndex);
    }

    public int getCarParamSteeringMax(int n) {
        return this.m_carParamSteeringMax[n];
    }

    public byte getCarNumGears() {
        return this.getCarNumGears(this.m_playerCarIndex);
    }

    public byte getCarNumGears(int n) {
        return this.m_carNumGears[n];
    }

    public int getCarGearAccel(byte by) {
        return this.getCarGearAccel(this.m_playerCarIndex, by);
    }

    public int getCarGearAccel(int n, byte by) {
        return this.m_carGearAccels[n][by];
    }

    public int[] getCarGearAccelData() {
        return this.getCarGearAccelData(this.m_playerCarIndex);
    }

    public int[] getCarGearAccelData(int n) {
        int[] nArray = new int[this.m_carGearAccels[n].length];
        System.arraycopy(this.m_carGearAccels[n], 0, nArray, 0, nArray.length);
        return nArray;
    }

    public int[] getCarGearMinSpeedData() {
        return this.getCarGearMinSpeedData(this.m_playerCarIndex);
    }

    public int[] getCarGearMinSpeedData(int n) {
        int[] nArray = new int[this.m_carGearMinSpeeds[n].length];
        System.arraycopy(this.m_carGearMinSpeeds[n], 0, nArray, 0, nArray.length);
        return nArray;
    }

    public int[] getCarGearMaxSpeedData() {
        return this.getCarGearMaxSpeedData(this.m_playerCarIndex);
    }

    public int[] getCarGearMaxSpeedData(int n) {
        int[] nArray = new int[this.m_carGearMaxSpeeds[n].length];
        System.arraycopy(this.m_carGearMaxSpeeds[n], 0, nArray, 0, nArray.length);
        return nArray;
    }

    public int getCarGearMinSpeed(byte by) {
        return this.getCarGearMinSpeed(this.m_playerCarIndex, by);
    }

    public int getCarGearMinSpeed(int n, byte by) {
        return this.m_carGearMinSpeeds[n][by];
    }

    public int getCarGearMaxSpeed(byte by) {
        return this.getCarGearMaxSpeed(this.m_playerCarIndex, by);
    }

    public int getCarGearMaxSpeed(int n, byte by) {
        return this.m_carGearMaxSpeeds[n][by];
    }

    public void setPlayerCarIndex(byte by) {
        this.m_playerCarIndex = by;
    }

    public int getPlayerCarIndex() {
        return this.m_playerCarIndex;
    }

    public int getCarValueAccelF(int n, int n2) {
        int n3 = this.getCarGearAccel(n, (byte)0);
        n3 -= CAR_VALUE_ACCEL_MIN_F;
        n3 = AppEngine.Fmul(n3, CAR_VALUE_ACCEL_MULTIPLIER_F);
        return n3;
    }

    public int getCarValueHandlingF(int n, int n2) {
        int n3 = this.getCarParamTyres(n);
        n3 -= CAR_VALUE_HANDLING_MIN_F;
        n3 = AppEngine.Fmul(n3, CAR_VALUE_HANDLING_MULTIPLIER_F);
        return n3;
    }

    public int getCarValueNitroF(int n, int n2) {
        int n3 = 0;
        n3 += -CAR_VALUE_NITRO_MIN_F;
        n3 = AppEngine.Fmul(n3, CAR_VALUE_NITRO_MULTIPLIER_F);
        return n3;
    }

    public int getCarValueF(int n, int n2, int n3) {
        switch (n2) {
            case 1: {
                return this.getCarValueAccelF(n, n3);
            }
            case 2: {
                return this.getCarValueHandlingF(n, n3);
            }
        }
        return this.getCarValueNitroF(n, n3);
    }

    private void loadEventHubData() {
        try {
            InputStream inputStream = this.m_resourceManager.loadBinaryFile(41);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            this.m_numEventHubs = dataInputStream.readByte();
            dataInputStream.close();
            dataInputStream = null;
            inputStream = null;
            System.gc();
            this.m_eventHubNames = new short[this.m_numEventHubs];
            this.m_eventHubEventCounts = new short[this.m_numEventHubs];
            this.m_eventTypes = new short[this.m_numEventHubs][];
            this.m_eventNumLaps = new short[this.m_numEventHubs][];
            this.m_eventNames = new short[this.m_numEventHubs][];
            this.m_eventTrackIDs = new short[this.m_numEventHubs][];
            inputStream = this.m_resourceManager.loadBinaryFile(41);
            dataInputStream = new DataInputStream(inputStream);
            dataInputStream.readByte();
            for (int i = 0; i < this.m_numEventHubs; ++i) {
                this.m_eventHubNames[i] = dataInputStream.readShort();
                int n = dataInputStream.readByte();
                this.m_eventHubEventCounts[i] = (short)n;
                this.m_eventTypes[i] = new short[n];
                this.m_eventNumLaps[i] = new short[n];
                this.m_eventNames[i] = new short[n];
                this.m_eventTrackIDs[i] = new short[n];
                for (int j = 0; j < n; ++j) {
                    this.m_eventTypes[i][j] = dataInputStream.readByte();
                    this.m_eventNumLaps[i][j] = dataInputStream.readByte();
                    this.m_eventNames[i][j] = (byte)dataInputStream.readShort();
                    this.m_eventTrackIDs[i][j] = dataInputStream.readByte();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public byte getNumEventHubs() {
        return this.m_numEventHubs;
    }

    public short getEventHubName(byte by) {
        return this.m_eventHubNames[by];
    }

    public short getEventHubEventCount(byte by) {
        return this.m_eventHubEventCounts[by];
    }

    public short getEventHubEventType(byte by, byte by2) {
        return this.m_eventTypes[by][by2];
    }

    private int getEventTypeName(byte by, byte by2) {
        switch (this.m_eventTypes[by][by2]) {
            case 1: {
                return 62;
            }
            case 0: {
                return 61;
            }
            case 2: {
                return 63;
            }
        }
        return -1;
    }

    public short getEventHubEventName(byte by, byte by2) {
        return this.m_eventNames[by][by2];
    }

    public short getEventHubEventTrackID(byte by, byte by2) {
        return this.m_eventTrackIDs[by][by2];
    }

    public short getNumLaps(byte by, byte by2) {
        return this.m_eventNumLaps[by][by2];
    }

    public void setCarNowRacingParameters() {
        this.m_carNowRacingParamTyresF = this.getCarParamTyres();
        this.m_carNowRacingParamSteeringIncF = this.getCarParamSteeringInc();
        this.m_carNowRacingParamSteeringRecentreIncF = this.getCarParamSteeringRecentreInc();
        this.m_carNowRacingParamSteeringMaxF = this.getCarParamSteeringMax();
        this.m_carNowRacingGearAccelsF = this.getCarGearAccelData();
        this.m_carNowRacingGearMinSpeedsF = this.getCarGearMinSpeedData();
        this.m_carNowRacingGearMaxSpeedsF = this.getCarGearMaxSpeedData();
        this.m_carNowRacingNitroMultF = 0;
    }

    public int getCarNowRacingParamTyres() {
        return this.m_carNowRacingParamTyresF;
    }

    public int getCarNowRacingParamSteeringInc() {
        return this.m_carNowRacingParamSteeringIncF;
    }

    public int getCarNowRacingParamSteeringRecentreInc() {
        return this.m_carNowRacingParamSteeringRecentreIncF;
    }

    public int getCarNowRacingParamSteeringMax() {
        return this.m_carNowRacingParamSteeringMaxF;
    }

    public int[] getCarNowRacingGearAccelData() {
        return this.m_carNowRacingGearAccelsF;
    }

    public int[] getCarNowRacingGearMinSpeedData() {
        return this.m_carNowRacingGearMinSpeedsF;
    }

    public int[] getCarNowRacingGearMaxSpeedData() {
        return this.m_carNowRacingGearMaxSpeedsF;
    }

    public int getCarNowRacingNitroMult() {
        return this.m_carNowRacingNitroMultF;
    }

    public final void setSharedMenu(int n) {
        this.m_sharedMenuRenderBackground = true;
        if (this.m_currentScene != null) {
            this.m_currentScene.repaintScene();
        }
        int n2 = n / 25;
        if (this.m_sharedMenuState == 0) {
            this.m_cancelSoftkeyBeforeMenu = this.m_cancelCommandID;
            this.m_selectSoftkeyBeforeMenu = this.m_selectCommandID;
        }
        if (n == 0) {
            if (this.m_sharedMenuRunningScene) {
                this.setSoftKeys(this.m_cancelSoftkeyBeforeMenu, this.m_selectSoftkeyBeforeMenu);
            }
            this.m_currentScene.resume();
            ResourceManager.startLastMusic();
        } else if (n2 == 1) {
            this.setSharedMenu_SelectMenu(n);
        } else if (n == 50) {
            this.m_sharedMenuTitle = (short)34;
            this.wrapString(35, 200);
        } else if (n == 51) {
            this.m_sharedMenuTitle = (short)32;
            this.wrapString(33, 200);
        } else if (n2 == 3) {
            this.setSharedMenu_ConfirmMenu(n);
        } else if (n == 1) {
            this.m_resourceManager.loadImage(this.m_resourceManager, 40);
            this.m_sharedMenuSplashTime = 3000;
            this.setSoftKeys(0, 0);
        } else if (n == 2) {
            this.m_resourceManager.unloadImage(40);
            this.m_resourceManager.loadImage(this.m_resourceManager, 47);
            this.m_sharedMenuSplashTime = 3000;
            this.setSoftKeys(0, 0);
        } else if (n == 3) {
            this.m_resourceManager.unloadImage(47);
            this.m_sharedMenuSplashTime = 3000;
            this.wrapString(3, this.getWidth() - 20);
            this.setSoftKeys(0, 0);
        } else if (n == 5) {
            this.m_sharedMenuSplashTime = 3000;
            this.wrapString(19, this.getWidth() - 20);
            this.setSoftKeys(0, 0);
        } else if (n == 4) {
            int n3;
            int[] nArray = this.m_raceStandingsLapTimes;
            int n4 = nArray.length;
            SDKString[] sDKStringArray = new SDKString[n4];
            SDKString[] sDKStringArray2 = new SDKString[n4];
            this.m_postRaceCarLabelStrings = sDKStringArray;
            this.m_postRaceLapTimeStrings = sDKStringArray2;
            for (n3 = 0; n3 != n4; ++n3) {
                SDKString sDKString = this.getString(53);
                sDKString = sDKString.concat(" ");
                sDKStringArray[n3] = sDKString = sDKString.concat(n3 + 1);
                sDKStringArray2[n3] = this.raceTimeToFormattedTime(nArray[n3], true);
            }
            n3 = this.getEventHubEventType((byte)this.getCarNowRacingHubIndex(), (byte)this.getCarNowRacingEventIndex());
            if (n3 == 2) {
                if (this.m_patrolModeSuccess) {
                    this.setEventCleared();
                }
            } else if (this.m_raceStandingsPlayerPos < 1) {
                this.setEventCleared();
            }
            this.m_sharedMenuTitle = (short)47;
            this.m_sharedMenuRunningScene = false;
            this.setSoftKeys(0, 4);
        }
        if (n2 == 2) {
            GAMEDATA_HELP_LINES_PER_PAGE = this.m_sharedMenuRunningScene ? (byte)7 : (byte)10;
            this.m_helpCurPage = 0;
            this.m_helpNumPages = (byte)((this.getNumWrappedLines() - 1) / GAMEDATA_HELP_LINES_PER_PAGE + 1);
            this.updatePageFooterString(1);
            this.setSoftKeys(3, this.m_helpNumPages == 1 ? 0 : 12);
        }
        this.m_sharedMenuState = (byte)n;
    }

    private final void setSharedMenu_SelectMenu(int n) {
        boolean bl = this.m_sharedMenuRunningScene;
        int n2 = 0;
        short[] sArray = null;
        int n3 = 3;
        if (n == 25) {
            this.saveRMSGameData();
            this.m_sharedMenuSelect = this.m_sharedMenuSelectAtMain;
            this.m_sharedMenuSelectAtMain = 0;
            int n4 = 5;
            if (bl) {
                n2 = 36;
                ResourceManager.stopAllSounds();
            } else {
                this.m_currentScene = null;
                n2 = 20;
                ResourceManager.startMusic(1);
            }
            sArray = new short[n4];
            int n5 = 0;
            sArray[n5] = bl ? 38 : 25;
            sArray[++n5] = 24;
            sArray[++n5] = 34;
            if (bl) {
                sArray[++n5] = 37;
                sArray[++n5] = 39;
                n3 = 3;
            } else {
                sArray[++n5] = 32;
                sArray[++n5] = 5;
                n3 = 7;
            }
        } else {
            if (this.m_sharedMenuState == 25) {
                this.m_sharedMenuSelectAtMain = this.m_sharedMenuSelect;
            }
            this.m_sharedMenuSelect = 0;
            if (n == 26) {
                n2 = 46;
                byte by = this.m_numEventHubs;
                int n6 = this.m_rmsHubUnlocked + 1;
                short[] sArray2 = this.m_eventHubNames;
                sArray = this.m_eventHubNames;
                this.m_sharedMenuSelect = this.m_carNowRacingHubIndex;
            } else if (n == 27) {
                n2 = this.m_eventHubNames[this.m_carNowRacingHubIndex];
                sArray = this.m_eventNames[this.m_carNowRacingHubIndex];
                for (byte by = 0; by < sArray.length; by = (byte)(by + 1)) {
                    sArray[by] = (short)this.getEventTypeName((byte)this.m_carNowRacingHubIndex, by);
                }
            } else if (n == 28) {
                int n7;
                int n8;
                if (this.m_carSelectState == 2) {
                    n8 = 0;
                    for (n7 = 0; n7 < this.m_rmsOwnedCar.length; ++n7) {
                        if (!this.m_rmsOwnedCar[n7]) continue;
                        if (n7 == this.m_rmsCareerActiveCarIndex) {
                            this.m_carSelectIndex = n8;
                            break;
                        }
                        ++n8;
                    }
                } else {
                    this.m_carSelectIndex = 0;
                }
                n8 = this.getRealCarIndex(this.m_carSelectIndex);
                n7 = this.m_carSelectImageIDs[n8];
                this.m_resourceManager.loadImage(this.m_resourceManager, n7);
            } else if (n == 29) {
                n2 = 24;
                int n9 = 5;
                if (!bl) {
                    ++n9;
                }
                sArray = new short[n9];
                int n10 = 0;
                sArray[n10] = 30;
                sArray[++n10] = 31;
                sArray[++n10] = 54;
                sArray[++n10] = 50;
                sArray[++n10] = 1;
                if (!bl) {
                    sArray[++n10] = 28;
                }
            } else if (n == 30 || n == 31) {
                n2 = 1;
                n3 = n == 30 ? 0 : 3;
            }
        }
        this.m_sharedMenuTitle = (short)n2;
        this.m_sharedMenuItems = sArray;
        this.setSoftKeys(n3, 6);
    }

    private final void setSharedMenu_ConfirmMenu(int n) {
        int n2 = -1;
        int n3 = 10;
        int n4 = 9;
        if (n == 78) {
            SDKString sDKString = this.getString(85);
            sDKString = sDKString.concat("|");
            sDKString = sDKString.concat(this.getString(this.m_eventHubNames[this.m_carNowRacingHubIndex]));
            sDKString = sDKString.concat("|");
            sDKString = sDKString.concat(this.getString(this.getEventTypeName((byte)this.m_carNowRacingHubIndex, (byte)this.m_carNowRacingEventIndex)));
            this.wrapString(sDKString, 200);
            n2 = 79;
            n3 = 0;
            n4 = 4;
        } else if (n == 79) {
            SDKString sDKString = this.getString(64);
            sDKString = sDKString.concat("|");
            sDKString = sDKString.concat(this.getString(this.m_eventHubNames[this.m_carNowRacingHubIndex]));
            this.wrapString(sDKString, 200);
            n2 = 79;
            n3 = 0;
            n4 = 4;
        } else if (n == 80) {
            this.wrapString(78, 200);
            n2 = 79;
            n3 = 0;
            n4 = 4;
        } else {
            int n5 = -1;
            if (n == 75) {
                n2 = 4;
                n5 = 45;
            } else if (n == 76) {
                n2 = 28;
                n5 = 29;
            } else if (n == 77) {
                n2 = 4;
                n5 = 80;
                n3 = 0;
                n4 = 4;
                this.m_sharedMenuRunningScene = false;
            } else if (n == 81) {
                n2 = 4;
                n5 = 42;
            } else if (n == 82) {
                n2 = 4;
                n5 = 84;
            } else if (n == 88) {
                n2 = 4;
                n5 = 43;
            } else if (n == 89) {
                n2 = 5;
                n5 = 44;
            }
            this.wrapString(n5, 200);
        }
        this.m_sharedMenuTitle = (short)n2;
        this.setSoftKeys(n3, n4);
    }

    private final void fillRectWithBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        this.m_resourceManager.setColor(graphics, n5);
        graphics.fillRect(n, n2, n3, n4);
        this.m_resourceManager.setColor(graphics, n6);
        graphics.drawLine(n, n2, n + n3, n2);
        graphics.drawLine(n + n3, n2, n + n3, n2 + n4);
        graphics.drawLine(n + n3, n2 + n4, n, n2 + n4);
        graphics.drawLine(n, n2 + n4, n, n2);
    }

    public final void renderSharedMenu(Graphics graphics) {
        int n = SDKUtils.getLineSize();
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        int n4 = n2 >> 1;
        int n5 = n3 >> 1;
        int n6 = n2 - 0;
        byte by = this.m_sharedMenuState;
        int n7 = by / 25;
        if (!this.m_sharedMenuRunningScene) {
            graphics.setClip(0, 0, n2, n3);
            this.m_resourceManager.setColor(graphics, 43);
            graphics.fillRect(0, 0, n2, n3);
            switch (by) {
                case 25: 
                case 29: 
                case 31: 
                case 75: 
                case 89: {
                    this.m_resourceManager.setColor(graphics, 45);
                    graphics.fillRect(0, 1, n2, 40);
                    this.m_resourceManager.setColor(graphics, 48);
                    graphics.fillRect(0, 0, n2, 40);
                    this.m_resourceManager.drawAnimFrame(graphics, 46, 0, n4, 6);
                }
            }
        }
        int n8 = 26;
        int n9 = 12;
        if (this.m_sharedMenuRunningScene) {
            n8 = 14;
            n9 += 30;
        }
        int n10 = n3 - n8 - n9;
        int n11 = n8 + (n10 >> 1);
        graphics.setClip(0, n8, n2, n10);
        if (n7 == 1) {
            if (by == 26) {
                int n12 = this.m_resourceManager.getAnimFrameWidth(69, 0);
                int n13 = this.m_resourceManager.getAnimFrameHeight(69, 0);
                int n14 = n4 - (n12 >> 1);
                int n15 = n14 + this.m_resourceManager.getAnimFrameFirePointX(69, 0, 0);
                int n16 = this.m_resourceManager.getAnimFrameFirePointY(69, 0, 0);
                int n17 = n14 + this.m_resourceManager.getAnimFrameFirePointX(69, 0, 1);
                int n18 = this.m_resourceManager.getAnimFrameFirePointY(69, 0, 1);
                int n19 = this.m_sharedMenuItems.length;
                int n20 = this.m_rmsHubUnlocked + 1;
                int n21 = Math.max(n8, n5 - n8 - (n13 >> 1));
                this.m_resourceManager.setColor(graphics, 3);
                this.fillRectWithBorder(graphics, n14, n21 - 2, n12, 13, 44, 46);
                this.drawString(graphics, 46, n14 + 2, n21 - 2, 20);
                this.m_resourceManager.setColor(graphics, 3);
                n21 += 14;
                int n22 = 0;
                while (n22 != n19) {
                    this.m_resourceManager.drawAnimFrame(graphics, 69, 0, n14, n21);
                    if (n22 == this.m_sharedMenuSelect) {
                        this.m_resourceManager.drawAnimFrame(graphics, 69, 1, n14, n21);
                    }
                    this.drawString(graphics, this.m_sharedMenuItems[n22], n15, n21 + n16, 20);
                    int n23 = n22 < n20 ? 81 : 82;
                    this.drawString(graphics, n23, n17, n21 + n18, 20);
                    ++n22;
                    n21 += n13 + 5;
                }
            } else if (by == 28) {
                this.renderSelectCar(graphics);
            } else if (by == 30 || by == 31) {
                this.renderLanguageMenu(graphics);
            } else {
                int n24 = this.m_resourceManager.getAnimFrameFirePointX(71, 0, 0);
                int n25 = this.m_resourceManager.getAnimFrameFirePointY(71, 0, 0);
                int n26 = this.m_resourceManager.getAnimFrameFirePointX(70, 0, 0);
                int n27 = this.m_resourceManager.getAnimFrameFirePointY(70, 0, 0);
                int n28 = this.m_sharedMenuItems.length;
                if (this.m_sharedMenuItems == this.m_carDescriptions) {
                    --n28;
                }
                int n29 = this.m_resourceManager.getAnimFrameWidth(71, 0);
                int n30 = this.m_resourceManager.getAnimFrameHeight(71, 0);
                int n31 = n28 * n30 + 1;
                if (by == 27) {
                    n31 <<= 1;
                }
                if (by == 27) {
                    this.renderSharedMenuBox(graphics, 153, n31, n4, n11 - 10);
                } else if (by == 29) {
                    this.renderSharedMenuBox(graphics, 153, n31, n4, n11);
                } else {
                    this.renderSharedMenuBox(graphics, 130, n31, n4, n11);
                }
                int n32 = this.m_sharedMenuRenderPosX;
                int n33 = this.m_sharedMenuRenderPosY;
                for (int i = 0; i != n28; ++i) {
                    short s = this.m_sharedMenuItems[i];
                    int n34 = -1;
                    if (s == 30) {
                        n34 = ResourceManager.getSoundEnabled() ? 13 : 11;
                    } else if (s == 31) {
                        n34 = this.m_rmsVibrationEnabled ? 13 : 11;
                    } else if (s == 54) {
                        n34 = this.m_rmsCarMarkersEnabled ? 13 : 11;
                    } else if (s == 50) {
                        int n35 = n34 = this.m_rmsSpeedunitsMPH ? 52 : 51;
                    }
                    if (i == this.m_sharedMenuSelect) {
                        int n36;
                        int n37 = n36 = n34 == -1 ? 0 : 1;
                        if ((by == 29 || by == 27) && n36 == 0) {
                            int n38 = n29 + -6;
                            int n39 = (n2 - 153 >> 1) + 153 - n38 + 5;
                            this.m_resourceManager.drawAnimFrame(graphics, 71, 0, n39, n33);
                        }
                        this.m_resourceManager.drawAnimFrame(graphics, 71, n36, n32, n33);
                    }
                    if (by == 27) {
                        this.drawString(graphics, s, n32 + n24 - 2, n33 + n25, 20);
                    } else {
                        this.drawString(graphics, s, n32 + n24, n33 + n25, 20);
                    }
                    if (n34 != -1) {
                        this.m_resourceManager.drawAnimFrame(graphics, 70, 0, n32 + 30, n33);
                        this.drawString(graphics, n34, n32 + n26 + 30, n33 + n27, 24);
                    }
                    if (by == 25 && s == 23) {
                        graphics.setColor(16365349);
                        graphics.drawRect((n2 - 130) / 2, n33 + 1, 129, n30 - 1);
                    }
                    n33 += n30;
                    if (by != 27) continue;
                    int n40 = this.m_rmsEventsCleared[this.m_carNowRacingHubIndex][i] ? 64 : 86;
                    this.drawString(graphics, n40, n32 + 130 + 23, n33 - n25 - 3, 24);
                    n33 += n30;
                }
            }
        } else if (n7 == 2) {
            n8 = 4;
            graphics.setClip(0, n8, n2, n3);
            int n41 = n5;
            int n42 = 0;
            int n43 = (GAMEDATA_HELP_LINES_PER_PAGE + 1) * (n + 2) + 2 + 4;
            this.renderSharedMenuBox(graphics, 222, n43 + n42, n4, n41);
            this.drawPartWrappedString(graphics, this.m_sharedMenuRenderPosX + 5, this.m_sharedMenuRenderPosY + 2, 20, this.m_helpCurPage * GAMEDATA_HELP_LINES_PER_PAGE, GAMEDATA_HELP_LINES_PER_PAGE);
            int n44 = this.m_sharedMenuRenderPosX + 210 - 5;
            int n45 = this.m_sharedMenuRenderPosY + n43 - 2 - n + n42;
            int n46 = this.m_resourceManager.getAnimFrameWidth(72, 0);
            int n47 = n44 - n46 - 4 - SDKUtils.getStringSize(s_pageFooterString);
            int n48 = n47 - 2 - n46;
            int n49 = n48 - 2 - this.getStringWidth(26);
            this.drawString(graphics, 26, n49, n45, 20);
            if (this.m_helpCurPage != 0) {
                this.m_resourceManager.drawAnimFrame(graphics, 72, 0, n48, n45);
            }
            this.drawString(graphics, s_pageFooterString, n47, n45, 20);
            if (this.m_helpCurPage < this.m_helpNumPages - 1) {
                this.m_resourceManager.drawAnimFrame(graphics, 72, 1, n44, n45);
            }
        } else if (n7 == 3) {
            int n50 = this.getNumWrappedLines() * (n + 2) - 2 + 4;
            this.renderSharedMenuBox(graphics, 210, n50, n4, n11);
            this.drawWrappedString(graphics, n4, this.m_sharedMenuRenderPosY + 2, 17);
        } else {
            if (by == 1) {
                graphics.setClip(0, 0, n2, n3);
                graphics.setColor(0);
                graphics.fillRect(0, 0, n2, n3);
                this.m_resourceManager.drawAnimFrame(graphics, 44, 0, n4, n5);
                return;
            }
            if (by == 2) {
                graphics.setClip(0, 0, n2, n3);
                graphics.setColor(10472395);
                graphics.fillRect(0, 0, n2, n3);
                this.m_resourceManager.drawAnimFrame(graphics, 45, 0, n4, n5);
                return;
            }
            if (by == 3) {
                graphics.setClip(0, 0, n2, n3);
                graphics.setColor(0);
                graphics.fillRect(0, 0, n2, n3);
                this.drawWrappedString(graphics, n4, n5, 3);
            } else if (by == 5) {
                graphics.setClip(0, 0, n2, n3);
                graphics.setColor(0);
                graphics.fillRect(0, 0, n2, n3);
                this.drawWrappedString(graphics, n4, n5, 3);
            } else if (by == 4) {
                short s = this.getEventHubEventType((byte)this.getCarNowRacingHubIndex(), (byte)this.getCarNowRacingEventIndex());
                int n51 = this.m_raceStandingsLapTimes.length;
                int n52 = n51 * (n + 2) - 2 + 8;
                int n53 = this.renderSharedMenuBox(graphics, 130, n52, n4, n11);
                int n54 = this.m_sharedMenuRenderPosX;
                int n55 = this.m_sharedMenuRenderPosY;
                n55 += 2;
                if (s == 2) {
                    if (this.m_patrolModeSuccess) {
                        this.drawString(graphics, 69, n54 + 5, n55, 20);
                    } else {
                        this.drawString(graphics, 70, n54 + 5, n55, 20);
                    }
                } else {
                    this.drawString(graphics, this.m_currentScene.getPosString(), n54 + 130, n53, 24);
                    for (int i = 0; i != n51; ++i) {
                        if (i == this.m_raceStandingsPlayerPos) {
                            this.m_resourceManager.drawAnimFrame(graphics, 71, 0, n54, n55 - 0);
                        }
                        this.drawString(graphics, this.m_postRaceCarLabelStrings[i], n54 + 5, n55 - 1, 20);
                        this.drawString(graphics, this.m_postRaceLapTimeStrings[i], n54 + 130 - 14, n55 - 1, 24);
                        n55 += n + 2;
                    }
                }
            }
        }
        this.renderSoftKeys(graphics, false);
    }

    private final void renderLanguageMenu(Graphics graphics) {
        int n;
        int n2 = 26;
        int n3 = 12;
        if (this.m_sharedMenuRunningScene) {
            n2 = 14;
            n3 += 30;
        }
        int n4 = this.getHeight() - n2 - n3 - 10;
        int n5 = n2 + (n4 >> 1);
        int n6 = this.m_resourceManager.getAnimFrameFirePointX(71, 0, 0);
        int n7 = this.m_resourceManager.getAnimFrameFirePointY(71, 0, 0);
        int n8 = this.m_resourceManager.getAnimFrameFirePointX(70, 0, 0);
        int n9 = this.m_resourceManager.getAnimFrameFirePointY(70, 0, 0);
        int n10 = s_numLanguages;
        int n11 = this.m_resourceManager.getAnimFrameHeight(71, 0) - 1;
        int n12 = n10 * n11 + 1;
        if (this.m_sharedMenuRunningScene) {
            n = 15;
            this.renderSharedMenuBox(graphics, 130, n12, this.getWidth() >> 1, n5 + n);
        } else {
            n = 2;
            this.renderSharedMenuBox(graphics, 130, n12, this.getWidth() >> 1, n5 + n);
        }
        int n13 = this.m_sharedMenuRenderPosX;
        int n14 = this.m_sharedMenuRenderPosY;
        for (int i = 0; i != n10; ++i) {
            SDKString sDKString = SDKUtils.getHeaderString(i, 0, null);
            if (i == this.m_sharedMenuSelect) {
                this.m_resourceManager.drawAnimFrame(graphics, 71, 0, n13, n14);
            }
            this.drawString(graphics, sDKString, n13 + n6, n14 + n7, 20);
            n14 += n11;
        }
    }

    private void renderTitleLine(Graphics graphics, int n) {
        int n2 = 4;
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        int n5 = this.getWidth() - 20;
        int n6 = this.getWidth() - n5 >> 1;
        graphics.setClip(0, n2, n3, n4);
        this.m_resourceManager.setColor(graphics, 42);
        graphics.fillRect(10, 10, n5, 14);
        this.drawString(graphics, n, this.getWidth() >> 1, 10, 17);
    }

    private int getRealCarIndex(int n) {
        switch (this.m_carSelectState) {
            case 0: {
                return this.getNthBuyableCar(this.m_carSelectIndex);
            }
        }
        return -1;
    }

    private void renderSelectCar(Graphics graphics) {
        ResourceManager resourceManager = this.m_resourceManager;
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = n >> 1;
        boolean bl = this.m_carSelectState == 3 || this.m_carSelectState == 1;
        int n4 = n3 - (n3 >> 6);
        int n5 = bl ? 5 : 4;
        int n6 = n - 20;
        int n7 = 13 * n5 - 8;
        int n8 = 10 + n6 - 3;
        int n9 = this.getRealCarIndex(this.m_carSelectIndex);
        int n10 = 0;
        switch (this.m_carSelectState) {
            case 0: {
                n10 = 89;
            }
        }
        this.renderTitleLine(graphics, n10);
        int n11 = 26;
        int n12 = n - 20;
        int n13 = n - n12 >> 1;
        this.m_resourceManager.setColor(graphics, 42);
        graphics.fillRect(n13, n11, n12, 13);
        int n14 = this.m_resourceManager.getAnimFrameWidth(72, 0);
        this.drawMoveableString(graphics, this.m_carDescriptions[n9], n13, n13 + n12, n11);
        this.m_resourceManager.drawAnimFrame(graphics, 72, 0, n3 - n4, n11);
        this.m_resourceManager.drawAnimFrame(graphics, 72, 1, n3 + n4, n11);
        n11 += 17;
        boolean bl2 = false;
        int n15 = 0;
        int n16 = 0;
        boolean bl3 = false;
        this.m_resourceManager.setColor(graphics, 42);
        graphics.fillRect(10, n11 - 2, n6, n7);
        int n17 = this.getCarGearMaxSpeed(n9, (byte)(this.getCarNumGears() - 1));
        this.intToSDKString(this.getSpeedInUnits(n17), false, this.m_tempStringBuffer);
        this.drawString(graphics, 75, 13, n11, 20);
        this.drawString(graphics, this.m_tempStringBuffer, n8, n11, 24);
        n17 = AppEngine.Fmul(this.getCarValueHandlingF(n9, n15), CARSELECT_LEVEL_BAR_MULTIPLIER_F);
        this.intToSDKString(n17 >> 16, false, this.m_tempStringBuffer);
        this.drawString(graphics, 76, 13, n11 += 13, 20);
        this.drawString(graphics, this.m_tempStringBuffer, n8, n11, 24);
        n17 = AppEngine.Fmul(this.getCarValueAccelF(n9, n16), CARSELECT_LEVEL_BAR_MULTIPLIER_F);
        this.intToSDKString(n17 >> 16, false, this.m_tempStringBuffer);
        this.drawString(graphics, 77, 13, n11 += 13, 20);
        this.drawString(graphics, this.m_tempStringBuffer, n8, n11, 24);
        int n18 = n2 - (n11 += 13) - 13 - 12;
        int n19 = n >> 1;
        int n20 = n11 + (n18 >> 1);
        this.m_resourceManager.drawAnimFrame(graphics, this.m_carSelectAnimIDs[n9], 0, n19, n20);
    }

    public final int renderSharedMenuBox(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n + 10;
        int n6 = n2 + 15 + 5;
        int n7 = n3 - (n5 >> 1);
        int n8 = n4 - (n6 >> 1);
        this.fillRectWithBorder(graphics, n7, n8, n5, n6, 44, 46);
        this.fillRectWithBorder(graphics, n7, n8, n5, 13, 44, 46);
        this.m_resourceManager.setColor(graphics, 45);
        graphics.fillRect(n7 + 5, n8 + 15 - 1, n5 - 10, n6 - 18);
        this.drawString(graphics, this.m_sharedMenuTitle, n7 + 5, n8, 20);
        this.m_sharedMenuRenderPosX = n7 + 5;
        this.m_sharedMenuRenderPosY = n8 + 15;
        return n8;
    }

    public final void processKeysSharedMenu(int n, int n2) {
        byte by = this.m_sharedMenuState;
        int n3 = by / 25;
        if (by == 1 || by == 2 || by == 5 || by == 3) {
            this.clearKeysPressedDown();
            this.clearCommandKeys();
            return;
        }
        if (n2 == 3) {
            int n4;
            switch (by) {
                case 25: {
                    n4 = 0;
                    break;
                }
                case 28: {
                    n4 = 27;
                    break;
                }
                case 26: {
                    this.m_carSelectState = 0;
                    n4 = 25;
                    break;
                }
                case 27: {
                    n4 = 26;
                    break;
                }
                case 31: {
                    n4 = 29;
                    break;
                }
                default: {
                    n4 = 25;
                }
            }
            this.setSharedMenu(n4);
        } else if (n2 == 7) {
            this.setSharedMenu(89);
        } else if (by == 28) {
            if ((n & 0x8010) != 0) {
                --this.m_carSelectIndex;
                if (this.m_carSelectIndex < 0) {
                    if (this.m_carSelectState == 0) {
                        this.m_carSelectIndex = this.getNumBuyableCars() - 1;
                    } else if (this.m_carSelectState == 2) {
                        System.out.println("cars: " + this.getNumCarsOwned());
                        this.m_carSelectIndex = this.getNumCarsOwned() - 1;
                    } else if (this.m_carSelectState == 3) {
                        this.m_carSelectIndex = this.getNumCarsNotOwned() - 1;
                    }
                }
                this.m_resourceManager.loadImage(this.m_resourceManager, this.m_carSelectImageIDs[this.getRealCarIndex(this.m_carSelectIndex)]);
            } else if ((n & 0x10040) != 0) {
                ++this.m_carSelectIndex;
                switch (this.m_carSelectState) {
                    case 0: {
                        if (this.m_carSelectIndex < this.getNumBuyableCars()) break;
                        this.m_carSelectIndex = 0;
                        break;
                    }
                    case 2: {
                        if (this.m_carSelectIndex < this.getNumCarsOwned()) break;
                        this.m_carSelectIndex = 0;
                        break;
                    }
                    case 3: {
                        if (this.m_carSelectIndex < this.getNumCarsNotOwned()) break;
                        this.m_carSelectIndex = 0;
                    }
                }
                this.m_resourceManager.loadImage(this.m_resourceManager, this.m_carSelectImageIDs[this.getRealCarIndex(this.m_carSelectIndex)]);
            } else if ((n & 0x1020) != 0 || n2 == 6) {
                switch (this.m_carSelectState) {
                    case 0: {
                        this.m_playerCarIndex = this.m_carSelectIndex;
                        this.startRace();
                        this.setSharedMenu(0);
                    }
                }
            }
        } else if (by == 30 || by == 31) {
            int n5 = s_numLanguages;
            if ((n & 0x2004) != 0) {
                this.m_sharedMenuSelect = (this.m_sharedMenuSelect + n5 - 1) % n5;
            } else if ((n & 0x4100) != 0) {
                this.m_sharedMenuSelect = (this.m_sharedMenuSelect + 1) % n5;
            } else if ((n & 0x1020) != 0 || n2 == 6) {
                this.loadLanguageChunks(this.m_sharedMenuSelect);
                this.saveRMSAppSettings();
                if (this.m_sharedMenuRunningScene) {
                    this.m_currentScene.updateLapString();
                }
                if (by == 30) {
                    this.setSharedMenu(75);
                } else {
                    this.setSharedMenu(29);
                }
            }
        } else if (n3 == 1) {
            if (by == 26) {
                int n6 = Math.min(this.m_sharedMenuItems.length, this.m_rmsHubUnlocked + 1);
                short s = this.m_sharedMenuItems[this.m_sharedMenuSelect];
                if ((n & 0x2004) != 0) {
                    this.m_sharedMenuSelect = (this.m_sharedMenuSelect + n6 - 1) % n6;
                } else if ((n & 0x4100) != 0) {
                    this.m_sharedMenuSelect = (this.m_sharedMenuSelect + 1) % n6;
                } else if ((n & 0x1020) != 0 || n2 == 6) {
                    this.processKeysSharedMenu_SelectMenuItem(by, s);
                }
            } else {
                int n7 = this.m_sharedMenuItems.length;
                short s = this.m_sharedMenuItems[this.m_sharedMenuSelect];
                if ((n & 0x2004) != 0) {
                    this.m_sharedMenuSelect = (this.m_sharedMenuSelect + n7 - 1) % n7;
                    if (this.m_sharedMenuItems[this.m_sharedMenuSelect] == -1) {
                        this.m_sharedMenuSelect = (this.m_sharedMenuSelect + n7 - 1) % n7;
                    }
                } else if ((n & 0x4100) != 0) {
                    this.m_sharedMenuSelect = (this.m_sharedMenuSelect + 1) % n7;
                    if (this.m_sharedMenuItems[this.m_sharedMenuSelect] == -1) {
                        this.m_sharedMenuSelect = (this.m_sharedMenuSelect + 1) % n7;
                    }
                } else if ((n & 0x1020) != 0 || n2 == 6) {
                    this.processKeysSharedMenu_SelectMenuItem(by, s);
                }
            }
        } else if (n3 == 2) {
            byte by2 = this.m_helpCurPage;
            if ((n & 0x8010) != 0 && by2 > 0) {
                this.m_helpCurPage = (byte)(this.m_helpCurPage - 1);
            }
            if (((n & 0x10040) != 0 || n2 == 12) && by2 < this.m_helpNumPages - 1) {
                this.m_helpCurPage = (byte)(this.m_helpCurPage + 1);
            }
            if (by2 != this.m_helpCurPage) {
                this.updatePageFooterString(this.m_helpCurPage + 1);
                this.setSoftKeys(3, this.m_helpCurPage == this.m_helpNumPages - 1 ? 0 : 12);
            }
        } else if (n3 == 3 && (n2 != 0 || n != 0)) {
            if ((n & 0x1020) != 0 || n2 == this.m_selectCommandID) {
                this.processKeysSharedMenu_ConfirmSoftkey(by, true);
            } else if (n2 == this.m_cancelCommandID) {
                this.processKeysSharedMenu_ConfirmSoftkey(by, false);
            }
        } else if (by == 4 && (n2 == 4 || (n & 0x1020) != 0)) {
            int n8 = 82;
            if (!this.m_curEventPreviouslyCompleted && this.m_rmsEventsCleared[this.m_carNowRacingHubIndex][this.m_carNowRacingEventIndex]) {
                n8 = 78;
            }
            this.setSharedMenu(n8);
        }
        this.clearKeysPressedDown();
        this.clearCommandKeys();
    }

    private void updatePageFooterString(int n) {
        this.intToSDKString(n, false, s_pageFooterString);
        s_pageFooterString = s_pageFooterString.append(ResourceManager.SLASH_STRING);
        s_pageFooterString = s_pageFooterString.append(this.m_helpNumPages);
    }

    private void startRace() {
        this.setCarNowRacingParameters();
        if (this.m_currentScene == null) {
            this.m_currentScene = new SceneGame();
        } else {
            this.m_currentScene.restartGame();
        }
        this.m_curEventPreviouslyCompleted = this.m_rmsEventsCleared[this.m_carNowRacingHubIndex][this.m_carNowRacingEventIndex];
        this.m_cancelSoftkeyBeforeMenu = 0;
        this.m_selectSoftkeyBeforeMenu = 0;
        this.m_sharedMenuRunningScene = true;
    }

    private final void processKeysSharedMenu_SelectMenuItem(int n, short s) {
        int n2 = -1;
        if (n == 26 && this.m_sharedMenuSelect == 0) {
            this.m_carNowRacingHubIndex = this.m_sharedMenuSelect;
            n2 = 27;
        } else if (n == 26 && this.m_sharedMenuSelect == 1) {
            if (this.m_rmsHubUnlocked >= 1) {
                this.m_carNowRacingHubIndex = this.m_sharedMenuSelect;
            } else {
                this.m_sharedMenuSelect = 0;
            }
            n2 = 27;
        } else if (n == 27) {
            int n3;
            int n4 = this.m_carNowRacingHubIndex;
            this.m_carNowRacingEventIndex = n3 = this.m_sharedMenuSelect;
            short s2 = this.m_eventTypes[n4][n3];
            this.setNextRaceType((byte)s2);
            this.setCurrTrack(this.m_eventTrackIDs[n4][n3]);
            this.setNextRaceNumLaps((byte)this.getNumLaps((byte)n4, (byte)n3));
            if (s2 == 2) {
                this.m_playerCarIndex = 3;
                this.startRace();
                this.setSharedMenu(0);
            } else {
                this.m_carSelectState = 0;
                n2 = 28;
            }
        } else if (s == 2) {
            n2 = 25;
        } else if (s == 5) {
            n2 = 89;
        } else if (s == 25) {
            n2 = 26;
        } else if (s == 38) {
            n2 = 0;
        } else if (s == 37) {
            n2 = 81;
        } else if (s == 24) {
            n2 = 29;
        } else if (s == 34) {
            n2 = 50;
        } else if (s == 32) {
            n2 = 51;
        } else if (s != 23) {
            if (s == 39) {
                n2 = 88;
            } else if (s == 30) {
                ResourceManager.setSoundEnabled(!ResourceManager.getSoundEnabled());
            } else if (s == 31) {
                this.m_rmsVibrationEnabled = !this.m_rmsVibrationEnabled;
                this.vibrate(500);
                this.saveRMSAppSettings();
            } else if (s == 54) {
                this.m_rmsCarMarkersEnabled = !this.m_rmsCarMarkersEnabled;
                this.saveRMSAppSettings();
            } else if (s == 50) {
                this.m_rmsSpeedunitsMPH = !this.m_rmsSpeedunitsMPH;
                this.saveRMSAppSettings();
            } else if (s == 28) {
                n2 = 76;
            } else if (s == 1) {
                n2 = 31;
            }
        }
        if (n2 != -1) {
            this.setSharedMenu(n2);
        }
    }

    private final void processKeysSharedMenu_ConfirmSoftkey(int n, boolean bl) {
        int n2 = -1;
        if (n == 75) {
            ResourceManager.setSoundEnabled(bl);
            n2 = 1;
        } else if (n == 76) {
            if (bl) {
                this.resetRMSGameData();
                this.saveRMSGameData();
            }
            n2 = 29;
        } else if (n == 77) {
            n2 = 82;
        } else if (n == 78) {
            if (bl) {
                if (this.m_hubRecentlyUnlocked) {
                    n2 = 79;
                    this.m_hubRecentlyUnlocked = false;
                } else {
                    n2 = 27;
                }
            } else {
                n2 = 78;
            }
        } else if (n == 79) {
            n2 = bl ? (this.m_rmsHubUnlocked >= this.m_rmsEventsCleared.length ? 80 : 26) : 79;
        } else if (n == 80) {
            n2 = bl ? 25 : 80;
        } else if (n == 81 || n == 82) {
            if (bl) {
                this.m_currentScene.restartGame();
                this.m_sharedMenuRunningScene = true;
                n2 = 0;
                this.m_cancelSoftkeyBeforeMenu = 0;
                this.m_selectSoftkeyBeforeMenu = 0;
            } else {
                n2 = this.m_sharedMenuRunningScene ? 25 : 26;
            }
        } else if (n == 88) {
            if (bl) {
                this.m_sharedMenuRunningScene = false;
            }
            n2 = 25;
        } else if (n == 89) {
            if (bl) {
                this.endGame();
            } else {
                n2 = 25;
            }
        }
        this.setSharedMenu(n2);
    }

    public static final int Fmul(int n, int n2) {
        return (int)((long)n * (long)n2 >> 16);
    }

    public static final int Fdiv(int n, int n2) {
        return (int)(((long)n << 16) / (long)n2);
    }

    public static final int smoothstepF(int n, int n2, int n3) {
        if (n3 < n) {
            return 0;
        }
        if (n3 >= n2) {
            return 65536;
        }
        int n4 = n3 - n;
        int n5 = n2 - n;
        int n6 = AppEngine.Fdiv(n4, n5);
        int n7 = AppEngine.Fmul(n6, n6);
        return -2 * AppEngine.Fmul(n7, n6) + 3 * n7;
    }

    public static final int powerF(int n, int n2) {
        int n3 = 65536;
        for (int i = 1; i <= n2; ++i) {
            n3 = AppEngine.Fmul(n3, n);
        }
        return n3;
    }

    public static final int Fcos(int n) {
        int n2 = n >= 0 ? 1 : -1;
        int n3 = AppEngine.Fmul(n2 * n << 1, 20861) & 0x3FFFF;
        int n4 = n3 >> 16;
        n3 &= 0xFFFF;
        n2 = 1;
        if (((n4 &= 3) & 1) != 0) {
            n2 = -n2;
            n3 = 65536 - n3;
        }
        if ((n4 & 2) != 0) {
            n2 = -n2;
        }
        n3 = AppEngine.Fmul(n3 >> 1, 205887);
        int n5 = 65536;
        int n6 = AppEngine.Fmul(n3, n3);
        int n7 = n6 >> 1;
        n5 -= n7;
        n7 = AppEngine.Fmul(AppEngine.Fmul(n6, n7), 5461);
        n5 += n7;
        n7 = AppEngine.Fmul(AppEngine.Fmul(n6, n7), 2185);
        n5 -= n7;
        n7 = AppEngine.Fmul(AppEngine.Fmul(n6, n7), 1170);
        n5 += n7;
        n7 = AppEngine.Fmul(AppEngine.Fmul(n6, n7), 728);
        n5 -= n7;
        return n5 *= n2;
    }

    public static final int Fsin(int n) {
        return AppEngine.Fcos(n - 102944);
    }

    public final int getSpeedInUnits(int n) {
        return this.m_rmsSpeedunitsMPH ? n : (n >>= 17) * 1609 / 1000;
    }

    static {
        CARSELECT_LEVEL_BAR_WIDTH = 100;
        CARSELECT_LEVEL_BAR_MULTIPLIER_F = CARSELECT_LEVEL_BAR_WIDTH << 16;
        PS_TO_MW_ACC_FACTOR = 30;
        m_keysPressedDown = 0;
        m_commandPressedDown = 0;
        m_singletonAppEngine = null;
        light = false;
        bBacklightOn = true;
        appResumed = true;
        m_sdkString = new SDKString();
        blockBuf = new byte[10000];
    }
}

