/*
 * Decompiled with CFR 0.152.
 */
package com.ea.vm;

import com.ea.sdk.SDKInputStream;
import com.ea.vm.XSVMConstants;
import com.ea.vm.XSVMInstructions;
import com.ea.vm.XSVMUInvokeInterface;

public class XScriptVirtualMachine
implements XSVMConstants,
XSVMInstructions {
    private static byte[][] scripts;
    private int[] scriptsList;
    private int scriptsNum;
    private int[][] stack;
    private int stackPointer;
    private int[] instances;
    private long memUsed;
    private int nInst;
    private int maxPid;
    private int vmFlags;
    public int[] gVars;
    private static final boolean TRACE_MODE = false;
    private static String debuggedScripts;
    private int cInst = -1;
    private boolean cInvoke = false;
    private XSVMUInvokeInterface uFunctions;
    private int execIdx;

    public XScriptVirtualMachine() {
        this.initScriptManager();
        this.initLocalVMVariables();
        this.doInit();
    }

    public void doInit() {
        this.initStack();
        this.initInstances(64);
        this.maxPid = 0;
        debuggedScripts = "[906]";
    }

    public int loadScript(int n) {
        int n2;
        if (this.scriptsNum >= scripts.length) {
            return -1;
        }
        XScriptVirtualMachine.scripts[this.scriptsNum] = SDKInputStream.loadResourceAsByteArray(n);
        int n3 = XScriptVirtualMachine.dByte2Short(scripts[this.scriptsNum][0], scripts[this.scriptsNum][1]);
        for (n2 = 0; n2 < this.scriptsNum && n3 > XScriptVirtualMachine.dByte2Short(scripts[this.scriptsList[n2]][0], scripts[this.scriptsList[n2]][1]); ++n2) {
        }
        for (int i = this.scriptsNum; i > n2; --i) {
            this.scriptsList[i] = this.scriptsList[i - 1];
        }
        this.scriptsList[n2] = this.scriptsNum;
        return this.scriptsNum++;
    }

    public void deleteScript(int n) {
        int n2 = -1;
        XScriptVirtualMachine.scripts[n] = scripts[this.scriptsNum];
        while (this.scriptsList[++n2] != n) {
        }
        for (int i = n2; i < this.scriptsNum; ++i) {
            this.scriptsList[i] = this.scriptsList[i + 1];
        }
        --this.scriptsNum;
    }

    public int getScriptIdx(int n) {
        return this.searchID(n, 0, this.scriptsNum - 1);
    }

    public void initLocalVMVariables() {
        this.memUsed = 0L;
        this.maxPid = 0;
        this.vmFlags = 0;
        this.gVars = null;
    }

    private void initInstances(int n) {
        this.instances = new int[n];
        this.nInst = 0;
        this.memUsed += (long)(this.instances.length * 4);
    }

    public int spawnInstanceByID(int n, int n2, int[] nArray) {
        int n3 = 0;
        n3 = this.spawnInstanceByID(n, n2);
        if (n3 == -1) {
            return n3;
        }
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                this.stack[this.instances[n3 - 1]][9 + i + 1] = nArray[i];
            }
        }
        return n3;
    }

    public int spawnInstanceByID(int n, int n2) {
        int n3 = this.getScriptIdx(n);
        return this.spawnInstance(n3, n2);
    }

    public void stopInstancesByID(int n) {
        int n2 = -1;
        while (++n2 < this.nInst) {
            if (this.stack[this.instances[n2]][1] != n) continue;
            int n3 = this.stack[this.instances[n2]][4];
            int n4 = -1;
            while (++n4 < this.nInst) {
                if (this.stack[this.instances[n4]][5] != n3) continue;
                this.deleteInstance(n4);
            }
            this.deleteInstance(n2);
        }
    }

    public void suspdendInstance(int n) {
        int[] nArray = this.stack[this.instances[n]];
        nArray[6] = nArray[6] | 1;
    }

    public void resumeInstance(int n) {
        int[] nArray = this.stack[this.instances[n]];
        nArray[6] = nArray[6] & 0xFFFFFFFE;
    }

    public int spawnInstance(int n, int n2) {
        if (n >= scripts.length || n < 0) {
            return -1;
        }
        if (this.nInst >= this.instances.length) {
            return -1;
        }
        int n3 = XScriptVirtualMachine.dByte2Short(scripts[n][2], scripts[n][3]);
        if (this.stackAlloc(n3 + scripts[n][4] + scripts[n][5]) == 0) {
            return -1;
        }
        this.instances[this.nInst] = this.stackPointer;
        this.stack[this.stackPointer][0] = 6;
        this.stack[this.stackPointer][2] = scripts[n][4];
        this.stack[this.stackPointer][3] = scripts[n][5];
        this.stack[this.stackPointer][1] = XScriptVirtualMachine.dByte2Short(scripts[n][0], scripts[n][1]);
        this.stack[this.stackPointer][4] = this.getNextPID();
        this.stack[this.stackPointer][5] = n2;
        this.stack[this.stackPointer][9] = 9 + this.stack[this.stackPointer][2] + this.stack[this.stackPointer][3];
        return ++this.nInst;
    }

    public int getIIDForPID(int n) {
        for (int i = 0; i < this.nInst; ++i) {
            if (this.stack[this.instances[i]] == null || this.stack[this.instances[i]][4] != n) continue;
            return i;
        }
        return -1;
    }

    public void deleteInstance(int n) {
        int n2;
        int n3 = this.instances[n];
        this.setInstanceFlag(n3, 3);
        this.suspdendInstance(n);
        if (this.stack[n3][5] != -1 && (n2 = this.getIIDForPID(this.stack[n3][5])) != -1) {
            this.resumeInstance(n2);
        }
    }

    public void actuallyDeleteInstance(int n) {
        int n2;
        int n3 = this.instances[n];
        if (this.stack[n3][5] != -1 && (n2 = this.getIIDForPID(this.stack[n3][5])) != -1) {
            this.resumeInstance(n2);
        }
        this.stack[n3] = null;
        n2 = -1;
        for (int i = 0; i <= this.nInst; ++i) {
            if (this.stackPointer != this.instances[i]) continue;
            n2 = i;
            break;
        }
        if (this.nInst > 0 && n3 != this.stackPointer) {
            this.stack[n3] = this.stack[this.stackPointer--];
            this.instances[n] = n3;
        }
        if (n2 != -1) {
            this.instances[n2] = n3;
        }
        --this.nInst;
    }

    public void deleteAllInstances() {
        this.doInit();
        if (this.gVars != null) {
            for (int i = 0; i < this.gVars.length; ++i) {
                this.gVars[i] = 0;
            }
        }
    }

    private void initScriptManager() {
        scripts = new byte[64][];
        for (int i = 0; i < 64; ++i) {
            XScriptVirtualMachine.scripts[i] = null;
        }
        this.scriptsList = new int[64];
        this.scriptsNum = 0;
        this.memUsed += (long)scripts.length;
    }

    private void initStack() {
        this.stack = new int[64][];
        for (int i = 0; i < 64; ++i) {
            this.stack[i] = null;
        }
        this.stackPointer = -1;
        this.memUsed += (long)(this.stack.length * 4);
    }

    private byte stackAlloc(int n) {
        if (this.stackPointer + 1 >= 64) {
            return 0;
        }
        this.stack[++this.stackPointer] = new int[n + 10];
        this.memUsed += (long)n;
        return 1;
    }

    private void stackPush(int n, int n2) {
        int[] nArray = this.stack[n];
        int n3 = nArray[9] + 1;
        nArray[9] = n3;
        this.stack[n][n3] = n2;
    }

    private int stackPop(int n) {
        if (this.stack[n][9] == 9 + this.stack[n][2] + this.stack[n][3]) {
            return -1;
        }
        int[] nArray = this.stack[n];
        int n2 = nArray[9];
        nArray[9] = n2 - 1;
        return this.stack[n][n2];
    }

    public void cycle() {
        int n;
        if (this.getFlag(this.vmFlags, 1)) {
            return;
        }
        this.setVMFlag((byte)1);
        for (n = this.nInst; n >= 0; --n) {
            if (this.stack[this.instances[n]] == null || !this.getFlag(this.stack[this.instances[n]][6], 0) || !this.getFlag(this.stack[this.instances[n]][6], 3)) continue;
            this.actuallyDeleteInstance(n);
        }
        n = this.nInst;
        this.execIdx = -1;
        while (++this.execIdx < n) {
            this.cInst = this.execIdx;
            if (this.stack[this.instances[this.execIdx]] == null) continue;
            if (this.getFlag(this.stack[this.instances[this.execIdx]][6], 2)) {
                int[] nArray = this.stack[this.instances[this.execIdx]];
                nArray[7] = nArray[7] - 1;
                if (nArray[7] <= 0) {
                    this.unsetInstanceFlag(this.instances[this.execIdx], 2);
                    this.resumeInstance(this.execIdx);
                }
            }
            if (this.stack[this.instances[this.execIdx]] == null || this.getFlag(this.stack[this.instances[this.execIdx]][6], 0)) continue;
            int n2 = this.stack[this.instances[this.execIdx]][1];
            this.unsetVMFlag((byte)2);
            this.execInst(this.execIdx);
            if (!this.getFlag(this.vmFlags, 2)) continue;
            n = this.nInst;
            if (this.nInst > 0) {
                --this.execIdx;
                continue;
            }
            this.execIdx = n;
        }
        this.unsetVMFlag((byte)1);
    }

    private void trace(int n, int n2, int n3, int[] nArray) {
        int n4;
        int n5 = this.stack[this.instances[this.execIdx]][1];
        if (debuggedScripts.length() > 0 && debuggedScripts.indexOf("[" + n5 + "]") == -1) {
            return;
        }
        String[] stringArray = new String[]{"", "PUSH8", "PUSH16", "PUSH32", "PUSHL", "POPL", "PUSHG", "POPG", "POP", "ADD", "SUB", "MUL", "DIV", "MOD", "JZ", "JNZ", "JMP", "CMPG", "CMPGE", "CMPL", "CMPLE", "CMPE", "CMPNE", "RUN", "START", "CUINVOKE", "UINVOKE", "PAUSE", "RET", "NOP", "WAIT", "UGET", "USET", "PRINT", "PRINTST", "BAND", "BOR", "BNOT", "BXOR", "XOR", "NOT", "SHL", "SHR", "SUSPEND", "SLEEP", "SLEEPF", "SWITCH", "RESUME", "KILL", "GETCSSID"};
        int n6 = this.stack[this.instances[n]][2] + this.stack[this.instances[n]][3];
        System.out.print(stringArray[n2] + "\t");
        for (int i = 0; i < n3; ++i) {
            System.out.print(nArray[i] + " ");
        }
        String string = new String();
        string = string + "\t\tIP: ";
        string = string + this.stack[this.instances[n]][0];
        string = string + "\tSP: ";
        string = string + this.stack[this.instances[n]][9];
        string = string + "\tL: ";
        for (n4 = 0; n4 < n6; ++n4) {
            string = string + this.stack[this.instances[n]][9 + n4 + 1];
            string = string + " ";
        }
        string = string + "\tG: ";
        for (n4 = 0; n4 < this.gVars.length; ++n4) {
            string = string + this.gVars[n4] + " ";
        }
        string = string + "\tS: ";
        for (n4 = 10 + n6; n4 < this.stack[this.instances[n]][9] + 1; ++n4) {
            string = string + this.stack[this.instances[n]][n4];
            string = string + " ";
        }
        System.out.println(string);
    }

    public int getParam() {
        int n = -1;
        int n2 = this.instances[this.cInst];
        int n3 = this.getScriptIdx(this.stack[n2][1]);
        if (this.cInvoke) {
            int[] nArray = this.stack[n2];
            int n4 = nArray[0];
            nArray[0] = n4 + 1;
            int n5 = n4;
            n = scripts[n3][n5];
        } else {
            n = this.stackPop(n2);
        }
        return n;
    }

    public int getParam16() {
        int n = -1;
        int n2 = this.instances[this.cInst];
        int n3 = this.getScriptIdx(this.stack[n2][1]);
        if (this.cInvoke) {
            int[] nArray = this.stack[n2];
            int n4 = nArray[0] + 2;
            nArray[0] = n4;
            int n5 = n4 - 1;
            n = XScriptVirtualMachine.dByte2Short(scripts[n3][n5 - 1], scripts[n3][n5]);
        } else {
            n = this.stackPop(n2);
        }
        return n;
    }

    public int getParam32() {
        int n = -1;
        int n2 = this.instances[this.cInst];
        int n3 = this.getScriptIdx(this.stack[n2][1]);
        if (this.cInvoke) {
            int[] nArray = this.stack[n2];
            int n4 = nArray[0] + 4;
            nArray[0] = n4;
            int n5 = n4 - 1;
            n = (scripts[n3][n5] & 0xFF) << 24 | (scripts[n3][n5 - 1] & 0xFF) << 16 | (scripts[n3][n5 - 2] & 0xFF) << 8 | scripts[n3][n5 - 3] & 0xFF;
        } else {
            n = this.stackPop(n2);
        }
        return n;
    }

    public void putParam(int n) {
        this.stackPush(this.instances[this.cInst], n);
    }

    private void execInst(int n) {
        int n2 = this.instances[n];
        int n3 = this.getScriptIdx(this.stack[n2][1]);
        int[] nArray = this.stack[n2];
        int n4 = nArray[0];
        nArray[0] = n4 + 1;
        int n5 = n4;
        int[] nArray2 = new int[2];
        if (n5 >= scripts[n3].length) {
            int[] nArray3 = this.stack[n2];
            nArray3[0] = nArray3[0] - 1;
            return;
        }
        int n6 = scripts[n3][n5];
        while (n6 != 27) {
            switch (n6) {
                case 29: {
                    break;
                }
                case 1: {
                    int[] nArray4 = this.stack[n2];
                    nArray4[0] = nArray4[0] + 1;
                    this.stackPush(n2, scripts[n3][n5]);
                    break;
                }
                case 2: {
                    int[] nArray5 = this.stack[n2];
                    int n7 = nArray5[0] + 2;
                    nArray5[0] = n7;
                    n5 = n7;
                    int n8 = (scripts[n3][n5 - 2] & 0xFF) << 8 | scripts[n3][n5 - 1] & 0xFF;
                    this.stackPush(n2, n8);
                    break;
                }
                case 3: {
                    int[] nArray6 = this.stack[n2];
                    int n9 = nArray6[0] + 4;
                    nArray6[0] = n9;
                    n5 = n9;
                    int n8 = (scripts[n3][n5 - 4] & 0xFF) << 24 | (scripts[n3][n5 - 3] & 0xFF) << 16 | (scripts[n3][n5 - 2] & 0xFF) << 8 | scripts[n3][n5 - 1] & 0xFF;
                    this.stackPush(n2, n8);
                    break;
                }
                case 4: {
                    int[] nArray7 = this.stack[n2];
                    nArray7[0] = nArray7[0] + 1;
                    int n8 = this.stack[n2][9 + scripts[n3][n5] + 1];
                    this.stackPush(n2, n8);
                    break;
                }
                case 5: {
                    int n8;
                    int[] nArray8 = this.stack[n2];
                    nArray8[0] = nArray8[0] + 1;
                    this.stack[n2][9 + XScriptVirtualMachine.scripts[n3][n5] + 1] = n8 = this.stackPop(n2);
                    break;
                }
                case 8: {
                    this.stackPop(n2);
                    break;
                }
                case 9: {
                    int n8 = 0;
                    n8 += this.stackPop(n2);
                    this.stackPush(n2, n8 += this.stackPop(n2));
                    break;
                }
                case 10: {
                    int n8 = 0;
                    n8 -= this.stackPop(n2);
                    this.stackPush(n2, n8 += this.stackPop(n2));
                    break;
                }
                case 11: {
                    int n8 = 1;
                    n8 *= this.stackPop(n2);
                    this.stackPush(n2, n8 *= this.stackPop(n2));
                    break;
                }
                case 12: {
                    int n10 = this.stackPop(n2);
                    if (n10 == 0) {
                        this.stackPop(n2);
                        this.stackPush(n2, 0xFFFFFFF);
                        break;
                    }
                    int n8 = this.stackPop(n2) / n10;
                    this.stackPush(n2, n8);
                    break;
                }
                case 13: {
                    int n8 = this.stackPop(n2);
                    int n10 = this.stackPop(n2);
                    this.stackPush(n2, n10 % n8);
                    break;
                }
                case 17: {
                    int n8 = this.stackPop(n2);
                    int n10 = this.stackPop(n2);
                    this.stackPush(n2, n10 > n8 ? 1 : 0);
                    break;
                }
                case 18: {
                    int n8 = this.stackPop(n2);
                    int n10 = this.stackPop(n2);
                    this.stackPush(n2, n10 >= n8 ? 1 : 0);
                    break;
                }
                case 19: {
                    int n8 = this.stackPop(n2);
                    int n10 = this.stackPop(n2);
                    this.stackPush(n2, n10 < n8 ? 1 : 0);
                    break;
                }
                case 20: {
                    int n8 = this.stackPop(n2);
                    int n10 = this.stackPop(n2);
                    this.stackPush(n2, n10 <= n8 ? 1 : 0);
                    break;
                }
                case 21: {
                    int n8 = this.stackPop(n2);
                    int n10 = this.stackPop(n2);
                    this.stackPush(n2, n10 == n8 ? 1 : 0);
                    break;
                }
                case 22: {
                    int n8 = this.stackPop(n2);
                    int n10 = this.stackPop(n2);
                    this.stackPush(n2, n10 != n8 ? 1 : 0);
                    break;
                }
                case 14: {
                    int n8 = this.stackPop(n2);
                    int[] nArray9 = this.stack[n2];
                    int n11 = nArray9[0] + 2;
                    nArray9[0] = n11;
                    n5 = n11;
                    int n10 = XScriptVirtualMachine.dByte2Short(scripts[n3][n5 - 2], scripts[n3][n5 - 1]);
                    if (n8 == 0) {
                        int[] nArray10 = this.stack[n2];
                        nArray10[0] = nArray10[0] + n10;
                    }
                    this.stackPush(n2, n8);
                    break;
                }
                case 15: {
                    int n8 = this.stackPop(n2);
                    int[] nArray11 = this.stack[n2];
                    int n12 = nArray11[0] + 2;
                    nArray11[0] = n12;
                    n5 = n12;
                    int n10 = XScriptVirtualMachine.dByte2Short(scripts[n3][n5 - 2], scripts[n3][n5 - 1]);
                    if (n8 != 0) {
                        int[] nArray12 = this.stack[n2];
                        nArray12[0] = nArray12[0] + n10;
                    }
                    this.stackPush(n2, n8);
                    break;
                }
                case 16: {
                    int[] nArray13 = this.stack[n2];
                    int n13 = nArray13[0] + 2;
                    nArray13[0] = n13;
                    n5 = n13;
                    int n10 = XScriptVirtualMachine.dByte2Short(scripts[n3][n5 - 2], scripts[n3][n5 - 1]);
                    int[] nArray14 = this.stack[n2];
                    nArray14[0] = nArray14[0] + n10;
                    break;
                }
                case 25: 
                case 26: {
                    if (this.uFunctions == null) {
                        System.out.println("WARNING: UINVOKE without registering the user class!!!");
                        break;
                    }
                    this.cInvoke = n6 == 25;
                    int[] nArray15 = this.stack[n2];
                    nArray15[0] = nArray15[0] + 1;
                    this.uFunctions.callFunction(scripts[n3][n5], this);
                    break;
                }
                case 31: {
                    int[] nArray16 = this.stack[n2];
                    nArray16[0] = nArray16[0] + 1;
                    this.stackPush(n2, this.uFunctions.getVariable(scripts[n3][n5]));
                    break;
                }
                case 32: {
                    int[] nArray17 = this.stack[n2];
                    nArray17[0] = nArray17[0] + 1;
                    this.uFunctions.setVariable(scripts[n3][n5], this.stackPop(n2));
                    break;
                }
                case 33: {
                    int n14;
                    int[] nArray18 = this.stack[n2];
                    nArray18[0] = nArray18[0] + 1;
                    int n8 = scripts[n3][n5];
                    for (n14 = 0; n14 < n8; ++n14) {
                        System.out.print((char)scripts[n3][this.stack[n2][0]] + "");
                        int[] nArray19 = this.stack[n2];
                        nArray19[0] = nArray19[0] + 1;
                    }
                    break;
                }
                case 34: {
                    int n8 = this.stackPop(n2);
                    System.out.print(n8);
                    break;
                }
                case 35: {
                    int n8 = this.stackPop(n2);
                    int n10 = this.stackPop(n2);
                    this.stackPush(n2, n8 & n10);
                    break;
                }
                case 36: {
                    int n8 = this.stackPop(n2);
                    int n10 = this.stackPop(n2);
                    this.stackPush(n2, n8 | n10);
                    break;
                }
                case 38: {
                    int n8 = this.stackPop(n2);
                    int n10 = this.stackPop(n2);
                    this.stackPush(n2, n8 ^ n10);
                    break;
                }
                case 37: {
                    int n8 = this.stackPop(n2);
                    this.stackPush(n2, ~n8);
                    break;
                }
                case 41: {
                    int n8 = this.stackPop(n2);
                    int n10 = this.stackPop(n2);
                    this.stackPush(n2, n10 << n8);
                    break;
                }
                case 42: {
                    int n8 = this.stackPop(n2);
                    int n10 = this.stackPop(n2);
                    this.stackPush(n2, n10 >> n8);
                    break;
                }
                case 39: {
                    int n8 = this.stackPop(n2);
                    int n10 = this.stackPop(n2);
                    if (n8 == 0 && n10 != 0 || n8 != 0 && n10 == 0) {
                        this.stackPush(n2, 1);
                        break;
                    }
                    this.stackPush(n2, 0);
                    break;
                }
                case 40: {
                    int n8 = this.stackPop(n2);
                    if (n8 != 0) {
                        this.stackPush(n2, 0);
                        break;
                    }
                    this.stackPush(n2, 1);
                    break;
                }
                case 6: {
                    int[] nArray20 = this.stack[n2];
                    nArray20[0] = nArray20[0] + 1;
                    int n8 = this.gVars[scripts[n3][n5]];
                    this.stackPush(n2, n8);
                    break;
                }
                case 7: {
                    int n8;
                    int[] nArray21 = this.stack[n2];
                    nArray21[0] = nArray21[0] + 1;
                    this.gVars[XScriptVirtualMachine.scripts[n3][n5]] = n8 = this.stackPop(n2);
                    break;
                }
                case 28: {
                    int n14;
                    int n10;
                    int n8 = this.stackPop(n2);
                    if (this.stack[n2][5] != -1) {
                        n10 = this.getIIDForPID(this.stack[n2][5]);
                        if (n10 != -1) {
                            this.stackPush(this.instances[n10], n8);
                            for (n14 = 0; n14 < this.stack[n2][2]; ++n14) {
                                this.stackPush(this.instances[n10], this.stack[n2][9 + n14 + 1]);
                            }
                        } else {
                            System.out.print("Could not find the instance for the caller script! ");
                            System.out.println(this.stack[n2][1]);
                        }
                    }
                    this.deleteInstance(n);
                    return;
                }
                case 23: {
                    this.suspdendInstance(n);
                    int[] nArray22 = this.stack[n2];
                    int n15 = nArray22[0] + 2;
                    nArray22[0] = n15;
                    n5 = n15 - 1;
                    int n8 = XScriptVirtualMachine.dByte2Short(scripts[n3][n5 - 1], scripts[n3][n5]);
                    int n10 = this.spawnInstanceByID(n8, this.stack[n2][4]);
                    if (n10 != -1) {
                        this.copyParamsToStack(this.instances[--n10]);
                    } else {
                        System.out.println("FATAL ERROR: Could not spawn instance for " + n8 + "!");
                    }
                    return;
                }
                case 24: {
                    int[] nArray23 = this.stack[n2];
                    int n16 = nArray23[0] + 2;
                    nArray23[0] = n16;
                    n5 = n16 - 1;
                    int n8 = XScriptVirtualMachine.dByte2Short(scripts[n3][n5 - 1], scripts[n3][n5]);
                    int n10 = this.spawnInstanceByID(n8, -1);
                    if (n10 != -1) {
                        this.copyParamsToStack(this.instances[--n10]);
                        break;
                    }
                    System.out.println("FATAL ERROR: Could not spawn instance for " + n8 + "!");
                    break;
                }
                case 46: {
                    int[] nArray24 = this.stack[n2];
                    nArray24[0] = nArray24[0] + 1;
                    int n8 = scripts[n3][n5];
                    nArray2[0] = this.stackPop(n2);
                    int n10 = n5;
                    int n14 = 0;
                    for (int i = n10 + 1; i < n10 + n8 + 1; ++i) {
                        int[] nArray25 = this.stack[n2];
                        nArray25[0] = nArray25[0] + 2;
                        n5 = nArray25[0] - 1;
                        if (nArray2[0] == XScriptVirtualMachine.dByte2Short(scripts[n3][n5 - 1], scripts[n3][n5])) {
                            int[] nArray26 = this.stack[n2];
                            nArray26[0] = nArray26[0] + (XScriptVirtualMachine.dByte2Short(scripts[n3][this.stack[n2][0]], scripts[n3][this.stack[n2][0] + 1]) + 1);
                            n14 = 1;
                            break;
                        }
                        int[] nArray27 = this.stack[n2];
                        nArray27[0] = nArray27[0] + 2;
                    }
                    if (n14 != 0) break;
                    int[] nArray28 = this.stack[n2];
                    nArray28[0] = nArray28[0] + 4;
                    int[] nArray29 = this.stack[n2];
                    nArray29[0] = nArray29[0] + XScriptVirtualMachine.dByte2Short(scripts[n3][this.stack[n2][0] - 2], scripts[n3][this.stack[n2][0] - 1]);
                    break;
                }
                case 43: {
                    int n8 = this.stackPop(n2);
                    int n10 = this.getIIDForPID(n8);
                    this.suspdendInstance(n10);
                    if (n8 != n) break;
                    return;
                }
                case 47: {
                    int n8 = this.stackPop(n2);
                    int n10 = this.getIIDForPID(n8);
                    this.resumeInstance(n10);
                    break;
                }
                case 48: {
                    int n8 = this.stackPop(n2);
                    int n10 = this.getIIDForPID(n8);
                    this.deleteInstance(n10);
                    if (n8 != n) break;
                    return;
                }
                case 49: {
                    this.stackPush(n2, this.stack[n2][4]);
                    break;
                }
                case 44: {
                    long l = System.currentTimeMillis() + (long)this.stackPop(n2);
                    this.stack[n2][7] = (int)(l >> 32 & 0xFFFFFFFFFFFFFFFFL);
                    this.stack[n2][8] = (int)(l & 0xFFFFFFFFFFFFFFFFL);
                    this.setInstanceFlag(n2, 1);
                    this.suspdendInstance(n);
                    return;
                }
                case 45: {
                    this.stack[n2][7] = this.stackPop(n2);
                    this.setInstanceFlag(n2, 2);
                    this.suspdendInstance(n);
                    return;
                }
                default: {
                    System.out.println("THIS OPERATION IS NOT IMPLEMENTED OR INVALID: " + n6);
                }
            }
            if (!this.getFlag(this.vmFlags, 0)) {
                int[] nArray30 = this.stack[n2];
                nArray30[0] = nArray30[0] + 1;
                if (n5 < scripts[n3].length) {
                    n6 = scripts[n3][n5];
                    continue;
                }
                n6 = 27;
                this.deleteInstance(n);
                continue;
            }
            n6 = 27;
        }
    }

    private void copyParamsToStack(int n) {
        for (int i = 0; i < this.stack[n][2]; ++i) {
            this.stack[n][9 + i + 1] = this.stackPop(this.instances[this.cInst]);
        }
    }

    public long getMemUsed() {
        return this.memUsed;
    }

    public void registerUserFunctions(XSVMUInvokeInterface xSVMUInvokeInterface) {
        this.uFunctions = xSVMUInvokeInterface;
        this.gVars = new int[this.uFunctions.getNumberOfGlobalVars()];
    }

    private static int dByte2Short(byte by, byte by2) {
        return (short)((by & 0xFF) << 8) | by2 & 0xFF;
    }

    private int getNextPID() {
        return ++this.maxPid;
    }

    private void setVMFlag(byte by) {
        this.vmFlags |= 1 << by;
    }

    private void unsetVMFlag(byte by) {
        this.vmFlags &= ~(1 << by);
    }

    private void setInstanceFlag(int n, int n2) {
        int[] nArray = this.stack[n];
        nArray[6] = nArray[6] | 1 << n2;
    }

    private void unsetInstanceFlag(int n, int n2) {
        int[] nArray = this.stack[n];
        nArray[6] = nArray[6] & ~(1 << n2);
    }

    private boolean getFlag(int n, int n2) {
        if (n2 > 31) {
            return false;
        }
        return (n & 1 << n2) != 0;
    }

    private int searchID(int n, int n2, int n3) {
        int n4 = n2 + (n3 - n2) / 2;
        if (n == XScriptVirtualMachine.dByte2Short(scripts[this.scriptsList[n4]][0], scripts[this.scriptsList[n4]][1])) {
            return this.scriptsList[n4];
        }
        if (n2 == n3) {
            return -1;
        }
        if (n < XScriptVirtualMachine.dByte2Short(scripts[this.scriptsList[n4]][0], scripts[this.scriptsList[n4]][1])) {
            return this.searchID(n, n2, n4);
        }
        return this.searchID(n, n4 + 1, n3);
    }

    public void unloadEverything() {
        this.scriptsNum = 0;
    }

    public void clean() {
        for (int i = this.nInst; i >= 0; --i) {
            if (this.stack[this.instances[i]] == null) continue;
            this.actuallyDeleteInstance(i);
        }
    }
}

