/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Constants;
import com.ea.game.GameImpl;
import com.ea.game.IStringConstants;
import com.ea.sdk.SDKInputStream;

public class Objective
implements Constants.ObjectiveConstants,
Constants,
IStringConstants {
    public int type;
    public int id;
    public int state;
    public int textActivate;
    public int textCompleted;
    public int textFailed;
    public int scriptCompleted;
    public int scriptFailed;
    public int posX;
    public int posY;
    public int numberIds;
    public short[] ids = null;
    public int followUpObjective = -1;

    public void load(SDKInputStream sDKInputStream) {
        try {
            this.id = sDKInputStream.readShort();
            this.type = sDKInputStream.read() & 0xFF;
            this.state = 0;
            this.textActivate = sDKInputStream.readShort();
            this.textCompleted = sDKInputStream.readShort();
            this.textFailed = sDKInputStream.readShort();
            this.followUpObjective = sDKInputStream.readShort();
            this.scriptCompleted = sDKInputStream.readShort();
            this.scriptFailed = sDKInputStream.readShort();
            this.posX = sDKInputStream.readShort() << 8;
            this.posY = sDKInputStream.readShort() << 8;
            this.numberIds = sDKInputStream.read() & 0xFF;
            if (this.numberIds > 0) {
                this.ids = new short[this.numberIds];
                for (int i = 0; i < this.numberIds; ++i) {
                    this.ids[i] = sDKInputStream.readShort();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setState(int n) {
        switch (n) {
            case 2: {
                if (this.type == 6 && this.state == 3) {
                    return;
                }
                if (this.textCompleted == -1) break;
                GameImpl.showMessage(80, this.textCompleted, 8);
                break;
            }
            case 3: {
                if (this.textFailed == -1) break;
                GameImpl.showMessage(81, this.textFailed, 8);
                break;
            }
            case 1: {
                if (!GameImpl.objectiveShowMsg || this.textActivate == -1) break;
                GameImpl.showMessage(79, this.textActivate, 8);
                break;
            }
        }
        this.state = n;
        if (this.state == 2) {
            if (this.followUpObjective != -1) {
                GameImpl.objectiveSetState(this.followUpObjective, 1);
            }
            if (this.scriptCompleted != -1) {
                GameImpl.vm.spawnInstanceByID(this.scriptCompleted, -1);
            }
            GameImpl.updateObjectives(4);
        }
        if (this.state == 3 && this.scriptFailed != -1) {
            GameImpl.vm.spawnInstanceByID(this.scriptFailed, -1);
        }
        if (this.state == 1) {
            GameImpl.setCurrentObjectiveById(this.id);
        }
    }

    public void clean() {
    }
}

