/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.AlliedCharacter;
import com.ea.game.AnimatedEntity;
import com.ea.game.Animator;
import com.ea.game.Camera;
import com.ea.game.Character;
import com.ea.game.Enemy;
import com.ea.game.Entity;
import com.ea.game.GameImpl;
import com.ea.game.Map;
import com.ea.game.Utils;
import com.ea.game.XSprite;
import com.ea.sdk.SDKCanvas;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKInputStream;

public class Machinegun
extends AnimatedEntity {
    public int orientation;
    public int extendedOrientation;
    public int targetPosX;
    public int targetPosY;
    public Character characterTarget;
    public Animator targetAnimator = new Animator();
    public Animator fiveAnimator;
    public int timer;
    public boolean callGunner = false;
    public boolean showTracer;
    public int startTracerX;
    public int startTracerY;
    public int endTracerX;
    public int endTracerY;
    public int tracerTimer;
    public short[] targetBulletPosX;
    public short[] targetBulletPosY;
    public short[] targetBulletFrame;
    public int playerPreviousPosX;
    public int playerPreviousPosY;
    static int[] X_GUNNER_MACHINEGUN_OFFSET = null;
    static int[] Y_GUNNER_MACHINEGUN_OFFSET = null;

    public Machinegun(int n) {
        super(n);
        this.targetAnimator._sprite = 8;
        this.fiveAnimator = new Animator();
        this.fiveAnimator._sprite = 7;
        this.fiveAnimator.SetCrtAnim(4);
        this.animator._sprite = 3;
        this.setState(0);
        this.targetBulletPosX = new short[8];
        this.targetBulletPosY = new short[8];
        this.targetBulletFrame = new short[8];
        this.timer = 0;
        this.tracerTimer = 0;
        this.showTracer = false;
    }

    public void load(SDKInputStream sDKInputStream) {
        try {
            this.posX = sDKInputStream.readShort() << 8;
            this.posY = sDKInputStream.readShort() << 8;
            this.sData[0] = sDKInputStream.readShort();
            this.bData[0] = (byte)sDKInputStream.read();
            this.orientation = this.bData[0];
            this.extendedOrientation = 2 * this.orientation;
            short s = sDKInputStream.readShort();
            if (s > 0) {
                for (int i = 0; i < GameImpl.numEnemies; ++i) {
                    if (GameImpl.enemies[i].id != s) continue;
                    this.sData[1] = (short)i;
                    this.callGunner = true;
                    this.timer = -Utils.random(2, 5);
                    break;
                }
            } else {
                this.sData[1] = -1;
            }
            this.animator.SetCrtAnim(this.extendedOrientation);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean isPlayerCloseAndUnder() {
        if (GameImpl.player != null) {
            int n = GameImpl.player.posX - this.posX >> 8;
            int n2 = GameImpl.player.posY - this.posY >> 8;
            return n > -25 && n < 25 && n2 > 15 && n2 < 85;
        }
        return false;
    }

    public void draw(SDKGraphics sDKGraphics) {
        int n = this.posX;
        int n2 = this.posY;
        if (this.state == 2 || this.state == 3) {
            this.animator.DrawCrtAnim(sDKGraphics, this.posX >> 8, this.posY >> 8);
            for (int i = 0; i < 8; ++i) {
                this.targetAnimator.DrawAnimFrame(sDKGraphics, 0, this.targetBulletFrame[i], this.targetBulletPosX[i], this.targetBulletPosY[i]);
            }
            if (this.state == 3 && (this.extendedOrientation < 6 || GameImpl.player.machinegun.extendedOrientation > 10) || this.isPlayerCloseAndUnder()) {
                GameImpl.player.draw(sDKGraphics);
            }
        } else {
            this.animator.DrawAnimFrame(sDKGraphics, this.extendedOrientation, 0, this.posX >> 8, this.posY >> 8);
            if (this.isPlayerCloseAndUnder()) {
                GameImpl.player.draw(sDKGraphics);
            }
        }
        if (GameImpl.gameMode == 1 && this.state == 0) {
            if (this.isPlayerInActivationRange()) {
                this.fiveAnimator.DrawCrtAnim(sDKGraphics, this.posX >> 8, this.posY >> 8);
            } else {
                GameImpl.sprites[7].DrawFrame(46, (this.posX >> 8) - Camera.posX, (this.posY >> 8) - Camera.posY, 0);
            }
        }
        if (this.showTracer) {
            sDKGraphics.setColor(0xFFFFFF);
            sDKGraphics.drawLine((this.startTracerX >> 8) - Camera.posX, (this.startTracerY >> 8) - Camera.posY, (this.endTracerX >> 8) - Camera.posX, (this.endTracerY >> 8) - Camera.posY);
        }
        this.posX = n;
        this.posY = n2;
    }

    public void update() {
        ++this.timer;
        if (this.callGunner) {
            if (this.timer < 0) {
                return;
            }
            this.callGunner = false;
            if (this.sData[1] > 0) {
                GameImpl.enemies[this.sData[1]].useMachinegun(this);
            }
        }
        if (this.showTracer && this.tracerTimer-- <= 0) {
            this.showTracer = false;
        }
        switch (this.state) {
            case 0: {
                if (this.sData[1] == -1 && this.searchCharacterTarget()) {
                    for (int i = 0; i < GameImpl.numEnemies; ++i) {
                        int n;
                        Enemy enemy = GameImpl.enemies[i];
                        if (enemy.state == 1 || enemy.state == 17 || enemy.state == 14 || enemy.state == 10 || enemy.machinegun != null || (enemy.flags & 8) == 0 || (n = Utils.Distance(this.posX - enemy.posX, this.posY - enemy.posY)) >> 8 >= 50) continue;
                        this.sData[1] = (short)i;
                        enemy.useMachinegun(this);
                        break;
                    }
                }
                if (!this.isPlayerInActivationRange()) break;
                this.fiveAnimator.UpdateCrtAnim();
                GameImpl.player.canUseMachinegun(this);
                break;
            }
            case 2: {
                if (this.searchCharacterTarget()) {
                    this.targetPosX += this.characterTarget.posX - this.targetPosX >> 5;
                    this.targetPosY += this.characterTarget.posY - this.targetPosY >> 5;
                    int n = this.getAcceptedTargetOrientation(this.targetPosX, this.targetPosY);
                    if (n == 8) break;
                    int n2 = this.animator._crt_aframe;
                    if (n != this.orientation) {
                        this.orientation = n;
                    }
                    this.extendedOrientation = GameImpl.getExtendedOrientation(this.targetPosX - this.posX, this.targetPosY - this.posY);
                    this.animator.SetCrtAnim(this.extendedOrientation);
                    this.animator.SetCrtAFrame(n2);
                    if (this.sData[1] != -1 && this.timer % 5 == 0) {
                        this.shootCharacter();
                    }
                    this.updateTargetAnimation();
                    this.animator.UpdateCrtAnim();
                    break;
                }
                this.setState(1);
                break;
            }
            case 3: {
                if (this.timer % 5 == 0) {
                    this.shootEnemy();
                }
                this.updateTargetAnimation();
                this.animator.UpdateCrtAnim();
                break;
            }
            case 1: {
                if (!this.searchCharacterTarget()) break;
                this.setState(2);
            }
        }
        if ((this.sData[1] == -1 || GameImpl.enemies[this.sData[1]].state != 10 && GameImpl.enemies[this.sData[1]].state != 11) && this.state != 3) {
            this.sData[1] = -1;
            this.setState(0);
        }
    }

    public void initTargetAnimation() {
        int n = 25;
        int n2 = (this.targetPosX - this.posX) / 15 >> 8;
        int n3 = (this.targetPosY - this.posY) / 15 >> 8;
        for (int i = 0; i < 8; ++i) {
            this.targetBulletPosX[i] = (short)((this.posX >> 8) + (i + 4) * n2 + Utils.random(-n, n));
            this.targetBulletPosY[i] = (short)((this.posY >> 8) + (i + 4) * n3 + Utils.random(-n, n));
            this.targetBulletFrame[i] = (short)Utils.random(5);
        }
    }

    public void updateTargetAnimation() {
        int n = 25;
        int n2 = (this.targetPosX - this.posX) / 15 >> 8;
        int n3 = (this.targetPosY - this.posY) / 15 >> 8;
        for (int i = 0; i < 8; ++i) {
            int n4 = i;
            short s = this.targetBulletFrame[n4];
            this.targetBulletFrame[n4] = (short)(s + 1);
            if (s <= 5) continue;
            this.targetBulletPosX[i] = (short)((this.posX >> 8) + (i + 4) * n2 + Utils.random(-n, n));
            this.targetBulletPosY[i] = (short)((this.posY >> 8) + (i + 4) * n3 + Utils.random(-n, n));
            this.targetBulletFrame[i] = 0;
        }
    }

    public void shootExplosives() {
        for (int i = 0; i < GameImpl.numEntities; ++i) {
            int n;
            Entity entity = GameImpl.entities[i];
            if (entity.type != 15 || entity.sData[1] == 1 || (n = Utils.Distance(((AnimatedEntity)entity).posX - this.targetPosX, ((AnimatedEntity)entity).posY - this.targetPosY)) >> 8 >= 50) continue;
            entity.sData[1] = 1;
            GameImpl.spawnBlastAnimation(((AnimatedEntity)entity).posX, ((AnimatedEntity)entity).posY, 9, Utils.random(1), 106, 100, (byte)0);
        }
    }

    public void shootEnemy() {
        this.shootExplosives();
        int n = Utils.Distance(this.targetPosX - this.posX, this.targetPosY - this.posY);
        int n2 = 6400;
        for (int i = 0; i < GameImpl.numAreaEnemies; ++i) {
            Enemy enemy = GameImpl.enemies[GameImpl.areaEnemies[i]];
            if (!enemy.isOnScreen() || enemy.state == 1 || enemy.state == 17) continue;
            int n3 = Utils.Distance(enemy.posX - this.posX, enemy.posY - this.posY);
            if (enemy.state == 0 && n3 >> 8 < this.sData[0]) {
                enemy.setOrientation(GameImpl.getOrientation(this.posX - enemy.posX, this.posY - enemy.posY));
            }
            if (n3 >= n) continue;
            int n4 = (this.targetPosX - this.posX >> 8) * (enemy.posY - this.posY >> 8) - (this.targetPosY - this.posY >> 8) * (enemy.posX - (this.posX - n2) >> 8);
            int n5 = (this.targetPosX - this.posX >> 8) * (enemy.posY - this.posY >> 8) - (this.targetPosY - this.posY >> 8) * (enemy.posX - (this.posX + n2) >> 8);
            int n6 = Utils.Distance(this.targetPosX - enemy.posX, this.targetPosY - enemy.posY);
            if (n4 * n5 > 0 || n6 >= n) continue;
            boolean bl = false;
            if (enemy.isCovered && !enemy.isJumping && (enemy.state != 2 || enemy.state == 2 && enemy.isShooting)) {
                bl = GameImpl.collideBulletWithCover(enemy.posX >> 8, enemy.posY >> 8, this.posX >> 8, this.posY >> 8, true);
            }
            if (bl || GameImpl.collideBullet(this.posX >> 8, this.posY >> 8, enemy.posX >> 8, enemy.posY >> 8)) continue;
            int n7 = enemy.life;
            enemy.takeDamage(100, this.posX, this.posY);
            if (enemy.life != n7) {
                GameImpl.spawnTempAnimation(this.targetPosX, this.targetPosY, 8, 16);
            }
            if (enemy.life > 0) continue;
            ++GameImpl.machinegunKillCount;
            GameImpl.shouldCheckAchievements = true;
        }
    }

    public void shootCharacter() {
        this.shootExplosives();
        if (!GameImpl.enemies[this.sData[1]].didMiss(Utils.Distance(this.posX - this.targetPosX, this.posY - this.targetPosY)) && Utils.Distance(this.targetPosX - this.characterTarget.posX, this.targetPosY - this.characterTarget.posY) >> 8 < 50) {
            boolean bl = false;
            if (this.characterTarget.isCovered && (this.characterTarget.state != 2 || this.characterTarget.getWeponType() == 3) && this.characterTarget.state != 7) {
                bl = GameImpl.collideBulletWithCover(this.characterTarget.posX >> 8, this.characterTarget.posY >> 8, this.posX >> 8, this.posY >> 8, true);
            }
            if (!bl && !GameImpl.collideBullet(this.posX >> 8, this.posY >> 8, this.characterTarget.posX >> 8, this.characterTarget.posY >> 8)) {
                int n = GameImpl.player.life;
                this.characterTarget.getShot(50, this.posX, this.posY);
                if (this.characterTarget.life != n) {
                    XSprite xSprite = GameImpl.sprites[this.characterTarget.turretAnimator._sprite];
                    short s = xSprite._aframes_id[xSprite._animations_af_offset[this.characterTarget.turretAnimator._crt_anim]];
                    short s2 = xSprite._fmodules_oy[xSprite._frames_fm_offset[s] + 1];
                    GameImpl.spawnTempAnimation(this.characterTarget.posX, this.characterTarget.posY + (s2 << 8), 8, 16);
                }
            }
        }
    }

    public void setState(int n) {
        if (this.state == 2 || this.state == 3) {
            GameImpl.soundManager.stopSounds();
            GameImpl.machineGunPlaying = false;
        }
        if (this.state == 3) {
            Camera.setShake(false);
        }
        if (this.state == n) {
            return;
        }
        switch (n) {
            case 0: {
                this.animator.SetCrtAnim(2 * this.bData[0]);
                this.orientation = this.bData[0];
                this.extendedOrientation = 2 * this.orientation;
                if (this.sData[1] != -1) {
                    GameImpl.enemies[this.sData[1]].machinegun = null;
                }
                this.sData[1] = -1;
                break;
            }
            case 1: {
                this.animator.SetCrtAnim(2 * this.bData[0]);
                break;
            }
            case 2: {
                this.targetPosX = GameImpl.player.posX + 3 * this.posX >> 2;
                this.targetPosY = GameImpl.player.posY + 3 * this.posY >> 2;
                this.extendedOrientation = GameImpl.getExtendedOrientation(this.targetPosX - this.posX, this.targetPosY - this.posY);
                this.animator.SetCrtAnim(this.extendedOrientation);
                GameImpl.playSoundRepeated(8);
                GameImpl.machineGunPlaying = true;
                this.initTargetAnimation();
                break;
            }
            case 3: {
                this.targetPosX = this.posX + GameImpl.X_ORIENTATION_DX_FACTOR[this.orientation] * (this.sData[0] << 8);
                this.targetPosY = this.posY + GameImpl.Y_ORIENTATION_DY_FACTOR[this.orientation] * (this.sData[0] << 8);
                this.extendedOrientation = GameImpl.getExtendedOrientation(this.targetPosX - this.posX, this.targetPosY - this.posY);
                this.animator.SetCrtAnim(this.extendedOrientation);
                GameImpl.playSoundRepeated(8);
                GameImpl.machineGunPlaying = true;
                this.initTargetAnimation();
                Camera.setShake(true);
            }
        }
        this.state = n;
    }

    public boolean isPlayerInActivationRange() {
        return Utils.Distance(GameImpl.player.posX - (3 * this.getGunnerPositionX() + this.posX >> 2), GameImpl.player.posY - (3 * this.getGunnerPositionY() + this.posY >> 2)) >> 8 < 30;
    }

    public boolean searchCharacterTarget() {
        this.characterTarget = null;
        if (GameImpl.player.state != 6 && Utils.Distance(GameImpl.player.posX - this.posX, GameImpl.player.posY - this.posY) >> 8 < this.sData[0] && this.getAcceptedTargetOrientation(GameImpl.player.posX, GameImpl.player.posY) != 8) {
            this.characterTarget = GameImpl.player;
            return true;
        }
        for (int i = 0; i < GameImpl.numAllies; ++i) {
            AlliedCharacter alliedCharacter = GameImpl.allies[i];
            if (alliedCharacter.state == 6 || alliedCharacter.state == 9 || alliedCharacter.state == 8 || Utils.Distance(alliedCharacter.posX - this.posX, alliedCharacter.posY - this.posY) >> 8 >= this.sData[0] || this.getAcceptedTargetOrientation(alliedCharacter.posX, alliedCharacter.posY) == 8) continue;
            this.characterTarget = alliedCharacter;
            return true;
        }
        return false;
    }

    public int getAcceptedTargetOrientation(int n, int n2) {
        return this.getAcceptedTargetOrientation(GameImpl.getOrientation(n - this.posX, n2 - this.posY));
    }

    public int getAcceptedTargetOrientation(int n) {
        int n2 = (this.bData[0] + 7) % 8;
        int n3 = (this.bData[0] + 1) % 8;
        if (n == n2 || n == n3 || n == this.bData[0]) {
            return n;
        }
        return 8;
    }

    public int getPlayerAcceptedExtendedOrientation(int n, int n2) {
        int n3 = GameImpl.getExtendedOrientation(n - this.posX, n2 - this.posY);
        int n4 = ((this.bData[0] << 1) + 15) % 16;
        int n5 = ((this.bData[0] << 1) + 1) % 16;
        int n6 = ((this.bData[0] << 1) + 14) % 16;
        int n7 = ((this.bData[0] << 1) + 2) % 16;
        int n8 = ((this.bData[0] << 1) + 13) % 16;
        int n9 = ((this.bData[0] << 1) + 3) % 16;
        int n10 = this.bData[0] << 1;
        if (n3 == n4 || n3 == n5 || n3 == n6 || n3 == n7 || n3 == n8 || n3 == n9 || n3 == n10) {
            return n3;
        }
        return 16;
    }

    public void activateMachinegun() {
        this.setState(1);
    }

    public boolean useMachinegun(boolean bl) {
        if (bl) {
            if (this.state == 0) {
                this.playerPreviousPosX = GameImpl.player.posX;
                this.playerPreviousPosY = GameImpl.player.posY;
                this.setState(3);
                return true;
            }
        } else {
            int n = GameImpl.findColision(this.playerPreviousPosX >> 8, this.playerPreviousPosY >> 8, 4, 15);
            if (n != -1) {
                GameImpl.player.posX = Map.collision_tile_h * (n & 0xFF) << 8;
                GameImpl.player.posY = Map.collision_tile_w * (n >> 16) << 8;
            } else {
                GameImpl.player.posX = this.playerPreviousPosX;
                GameImpl.player.posY = this.playerPreviousPosY;
            }
            this.setState(0);
            return true;
        }
        return false;
    }

    public int getGunnerPositionX() {
        if (GameImpl.gameMode == 1) {
            return this.posX + (X_GUNNER_MACHINEGUN_OFFSET[this.extendedOrientation] << 8);
        }
        return this.posX + (X_GUNNER_MACHINEGUN_OFFSET[this.extendedOrientation] << 7);
    }

    public int getGunnerPositionY() {
        if (GameImpl.gameMode == 1) {
            return this.posY + (Y_GUNNER_MACHINEGUN_OFFSET[this.extendedOrientation] << 8);
        }
        return this.posY + (Y_GUNNER_MACHINEGUN_OFFSET[this.extendedOrientation] << 7);
    }

    public void updateControl() {
        int n;
        int n2 = 8;
        for (n = 0; n < GameImpl.MAP_KP_ORIENTATION.length; ++n) {
            if (!SDKCanvas.isKeyPressed(GameImpl.MAP_KP_ORIENTATION[n][0]) || n2 != GameImpl.MAP_KP_ORIENTATION[n][1]) continue;
            n2 = GameImpl.MAP_KP_ORIENTATION[n][2];
        }
        if (n2 != 8) {
            int n3;
            int n4;
            int n5;
            n = this.targetPosX + GameImpl.X_ORIENTATION_FACTOR[n2] * 7;
            int n6 = this.targetPosY + GameImpl.Y_ORIENTATION_FACTOR[n2] * 7;
            if (Utils.Distance(this.posX - n, this.posY - n6) >> 8 > this.sData[0] && (n5 = Utils.Distance(n4 = this.posX + this.sData[0] * GameImpl.X_ORIENTATION_FACTOR[n2] - this.targetPosX, n3 = this.posY + this.sData[0] * GameImpl.Y_ORIENTATION_FACTOR[n2] - this.targetPosY)) >> 8 > 3) {
                n = this.targetPosX + 1792 * n4 / n5;
                n6 = this.targetPosY + 1792 * n3 / n5;
            }
            if ((n2 = this.getPlayerAcceptedExtendedOrientation(n, n6)) != 16) {
                n4 = this.animator._crt_aframe;
                this.targetPosX = n;
                this.targetPosY = n6;
                this.extendedOrientation = n2;
                this.animator.SetCrtAnim(this.extendedOrientation);
                this.animator.SetCrtAFrame(n4);
                n2 = GameImpl.getOrientation(this.targetPosX - this.posX, this.targetPosY - this.posY);
                if (this.orientation != n2) {
                    this.orientation = n2;
                }
            }
        }
    }
}

