/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Constants;
import com.ea.game.GameImpl;
import com.ea.game.Map;
import com.ea.game.Utils;

public class Camera
implements Constants,
Constants.CameraConstants {
    public static int posX;
    public static int posY;
    public static int fracPosX;
    public static int fracPosY;
    public static int state;
    public static int targetX;
    public static int targetY;
    private static int movingFrames;
    private static int speedFactor;
    private static boolean cameraShake;

    public static void setShake(boolean bl) {
        cameraShake = bl;
    }

    public static void update() {
        if (Utils.Distance(posX - GameImpl.areaCamX, posY - GameImpl.areaCamY) > 100) {
            GameImpl.constructVisibleEnemies();
        }
        switch (state) {
            case 1: {
                Camera.updateMove();
            }
        }
        if (cameraShake) {
            fracPosX += Utils.random(-2, 2) << 8;
            fracPosY += Utils.random(-2, 2) << 8;
        }
        posX = fracPosX >> 8;
        posY = fracPosY >> 8;
    }

    public static int getCenterX() {
        return fracPosX + 40960;
    }

    public static int getCenterY() {
        return fracPosY + 30720;
    }

    public static void setCenter(int n, int n2) {
        int n3 = n - 40960;
        int n4 = n2 - 30720;
        if (n3 < 0) {
            n3 = 0;
        }
        if ((n3 >> 8) + 320 > Map._map_w) {
            n3 = Map._map_w - 320 << 8;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if ((n4 >> 8) + 240 > Map._map_h) {
            n4 = Map._map_h - 240 << 8;
        }
        if (GameImpl.playAreaRightLimit != -1) {
            if ((n3 >> 8) + 320 > GameImpl.playAreaRightLimit) {
                n3 = GameImpl.playAreaRightLimit - 320 << 8;
            }
            if (n3 >> 8 < GameImpl.playAreaLeftLimit) {
                n3 = GameImpl.playAreaLeftLimit << 8;
            }
            if (n4 >> 8 < GameImpl.playAreaTopLimit) {
                n4 = GameImpl.playAreaTopLimit << 8;
            }
            if ((n4 >> 8) + 240 > GameImpl.playAreaBottomLimit) {
                n4 = GameImpl.playAreaBottomLimit - 240 << 8;
            }
        }
        fracPosX = n3;
        fracPosY = n4;
        targetX = fracPosX;
        targetY = fracPosY;
        posX = fracPosX >> 8;
        posY = fracPosY >> 8;
        Camera.setState(0);
    }

    public static void moveCenterTo(int n, int n2) {
        Camera.setTarget(n - 40960, n2 - 30720);
        Camera.setState(1);
    }

    public static void moveCenterToWithSpeed(int n, int n2, int n3) {
        Camera.setState(0);
        movingFrames = n3;
        Camera.moveCenterTo(n, n2);
    }

    public static void setState(int n) {
        if (state == 1) {
            movingFrames = 5;
        }
        if ((state = n) == 1) {
            speedFactor = 15;
        }
    }

    public static void setTarget(int n, int n2) {
        int n3 = Map._map_w;
        int n4 = 0;
        int n5 = 0;
        int n6 = Map._map_h;
        if (GameImpl.playAreaRightLimit != -1) {
            n3 = GameImpl.playAreaRightLimit;
            n4 = GameImpl.playAreaLeftLimit;
            n5 = GameImpl.playAreaTopLimit;
            n6 = GameImpl.playAreaBottomLimit;
        }
        targetX = n >> 8 >= n4 && (n >> 8) + 320 <= n3 ? n : (n >> 8 < n4 ? n4 << 8 : n3 - 320 << 8);
        targetY = n2 >> 8 >= n5 && (n2 >> 8) + 240 <= n6 ? n2 : (n2 >> 8 < n5 ? n5 << 8 : n6 - 240 << 8);
    }

    public static void updateMove() {
        if (Utils.Distance(targetX - (fracPosX += 3 * (targetX - fracPosX) / (movingFrames + (speedFactor >>= 1))), targetY - (fracPosY += 3 * (targetY - fracPosY) / (movingFrames + speedFactor))) <= 1280) {
            fracPosX = targetX;
            fracPosY = targetY;
            Camera.setState(0);
        }
    }

    static {
        movingFrames = 5;
        speedFactor = 15;
        cameraShake = false;
    }
}

