/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Camera;
import com.ea.game.Character;
import com.ea.game.Constants;
import com.ea.game.Enemy;
import com.ea.game.Entity;
import com.ea.game.GameImpl;
import com.ea.game.Utils;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKInputStream;
import java.io.IOException;

public class AlliedCharacter
extends Character
implements Constants.CharacterConstants,
Constants {
    public int numWaypoints;
    public int[] waypoints;
    public short[] waypointsFlags;
    public short[] waypointsScripts;
    public int currentWaypoint = -1;
    public byte flags;
    public byte teamID;
    public byte damage;
    public byte accuracy;
    public byte pbShoot;
    private boolean isShooting;
    private int scriptOnDeath = -1;

    public void load(SDKInputStream sDKInputStream) {
        try {
            super.load(sDKInputStream);
            this.teamID = (byte)(sDKInputStream.read() & 0xFF);
            this.flags = (byte)(sDKInputStream.read() & 0xFF);
            this.damage = (byte)(sDKInputStream.read() & 0xFF);
            this.accuracy = (byte)(sDKInputStream.read() & 0xFF);
            this.pbShoot = (byte)(sDKInputStream.read() & 0xFF);
            this.scriptOnDeath = sDKInputStream.readShort();
            this.posX = sDKInputStream.readShort() << 8;
            this.posY = sDKInputStream.readShort() << 8;
            this.numWaypoints = sDKInputStream.read();
            if (this.numWaypoints > 0) {
                this.waypoints = new int[this.numWaypoints << 1];
                this.waypointsFlags = new short[this.numWaypoints];
                this.waypointsScripts = new short[this.numWaypoints];
                for (int i = 0; i < this.numWaypoints; ++i) {
                    this.waypoints[2 * i] = sDKInputStream.readShort();
                    this.waypoints[2 * i + 1] = sDKInputStream.readShort();
                    this.waypointsFlags[i] = sDKInputStream.readShort();
                    this.waypointsScripts[i] = sDKInputStream.readShort();
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.type = 16;
        this.setModuleMapping(this.rifleModuleMapping);
        this.currentWaypoint = 0;
        this.currentWeapon = 0;
        this.orientation = 0;
    }

    public void init() {
        super.init();
        if (this.numWaypoints > 0 && this.currentWaypoint < this.numWaypoints && this.state != 6 && this.state != 13) {
            this.gotoXY(this.waypoints[2 * this.currentWaypoint], this.waypoints[2 * this.currentWaypoint + 1]);
        }
    }

    public void draw(SDKGraphics sDKGraphics) {
        if (this.state == 13) {
            return;
        }
        int n = this.posX >> 8;
        int n2 = this.posY >> 8;
        if (this.state == 11) {
            GameImpl.sprites[0].DrawFrame(297, n - Camera.posX, n2 - Camera.posY, 0);
            return;
        }
        if (this.state == 12) {
            this.baseAnimator.DrawCrtAnim(sDKGraphics, n, n2);
            this.turretAnimator.DrawCrtAnim(sDKGraphics, n, n2);
            return;
        }
        super.draw(sDKGraphics);
    }

    public void setState(int n) {
        this.setCoverState(GameImpl.canCover(this.posX >> 8, this.posY >> 8, this.orientation, this.isCovered));
        if (this.state == 5 && n == 0 && this.waypointsFlags != null && this.currentWaypoint < this.numWaypoints) {
            int n2 = -1;
            for (short s = (short)((this.waypointsFlags[this.currentWaypoint] & 0x1FE) >> 1); s != 0; s = (short)(s >> 1)) {
                ++n2;
            }
            if (n2 != -1) {
                this.setOrientation(n2);
            }
        }
        if (n == 6 && this.scriptOnDeath != -1) {
            GameImpl.vm.spawnInstanceByID(this.scriptOnDeath, -1);
        }
        super.setState(n);
    }

    public void update() {
        if (this.state == 13) {
            return;
        }
        ++this.timer;
        this.updateSpeech();
        this.weaponAmmunition[this.currentWeapon] = 10;
        if (this.state == 9) {
            return;
        }
        if (this.timer % this.regenerationInterval == 0) {
            this.life += this.regenerationAmount;
            if (this.life > this.maxLife) {
                this.life = this.maxLife;
            }
        }
        this.baseAnimator.UpdateCrtAnim();
        switch (this.state) {
            case 5: {
                this.updateTurretAnimation();
                if (this.turretAnimator._crt_anim != Character.A_TURRET_RUN[this.orientation]) {
                    this.turretAnimator.SetCrtAnim(Character.A_TURRET_RUN[this.orientation]);
                }
                this.turretAnimator.UpdateCrtAnim();
                this.updatePath();
                break;
            }
            case 0: {
                this.target.enemyTarget = null;
                this.updateTurretAnimation();
                this.turretAnimator.UpdateCrtAnim();
                this.target.state = 0;
                if ((this.flags & 1) == 0 && GameImpl.numAreaEnemies > 0) {
                    for (int i = 0; i < GameImpl.numAreaEnemies; ++i) {
                        boolean bl;
                        int n;
                        Enemy enemy = GameImpl.enemies[GameImpl.areaEnemies[i]];
                        if (enemy.state == 1 || enemy.state == 17 || enemy.state == 14 || (n = Utils.Distance(this.posX - enemy.posX, this.posY - enemy.posY) >> 8) >= 200 || !(bl = GameImpl.isVisible(this.posX >> 8, this.posY >> 8, enemy.posX >> 8, enemy.posY >> 8))) continue;
                        this.target.enemyTarget = enemy;
                        this.target.state = 2;
                        this.target.update();
                        this.setOrientation(this.getTurretOrientation());
                        this.setState(2);
                        break;
                    }
                }
                if (this.waypoints == null || this.waypointsFlags == null) break;
                if (this.currentWaypoint < this.numWaypoints && this.pathIndex < this.pathLength - 1) {
                    this.setState(5);
                }
                if (this.currentWaypoint < this.numWaypoints && (this.waypointsFlags[this.currentWaypoint] & 1) != 0) break;
                if (++this.currentWaypoint < this.numWaypoints) {
                    this.gotoXY(this.waypoints[2 * this.currentWaypoint], this.waypoints[2 * this.currentWaypoint + 1]);
                    break;
                }
                this.currentWaypoint = this.numWaypoints;
                break;
            }
            case 6: {
                if (this.baseAnimator.IsCrtAnimEnded()) {
                    this.setState(9);
                }
                this.turretAnimator.UpdateCrtAnim();
                break;
            }
            case 2: {
                if (!this.isShooting && this.turretAnimator.IsCrtAnimEnded()) {
                    this.timer = 0;
                    this.isShooting = true;
                    this.target.state = 2;
                    this.setOrientation(this.getTurretOrientation());
                    this.updateTurretAnimation();
                    this.turretAnimator.UpdateCrtAnim();
                    this.fire();
                }
                if (this.timer > this.pbShoot && this.isShooting) {
                    this.isShooting = false;
                    this.setState(this.currentWaypoint < this.numWaypoints ? (this.pathIndex >= this.pathLength - 1 ? 0 : 5) : 0);
                }
                if (this.isShooting) break;
                this.updateTurretAnimation();
                this.turretAnimator.UpdateCrtAnim();
                break;
            }
            case 3: {
                if (this.turretAnimator.IsCrtAnimEnded()) {
                    this.reload();
                    this.setState(0);
                }
                this.target.update();
                this.updateTurretAnimation();
                this.turretAnimator.UpdateCrtAnim();
                break;
            }
            case 1: {
                this.updateTurretAnimation();
                this.turretAnimator.UpdateCrtAnim();
                break;
            }
            case 7: {
                if (this.baseAnimator.IsCrtAnimEnded()) {
                    this.setCoverState(false);
                    if (this.isDyingAfterJump) {
                        this.setState(6);
                        break;
                    }
                    this.posX = this.jumpLandingX;
                    this.posY = this.jumpLandingY;
                    this.setState(0);
                    break;
                }
                if (this.baseAnimator._crt_aframe <= 3) break;
                int n = this.baseAnimator.GetCrtAnimLength() - this.baseAnimator._crt_aframe - 1;
                if (n > 0) {
                    this.posX += (this.jumpLandingX - this.posX) / n;
                    this.posY += (this.jumpLandingY - this.posY) / n;
                    break;
                }
                this.posX = this.jumpLandingX;
                this.posY = this.jumpLandingY;
                break;
            }
            case 12: {
                this.turretAnimator.UpdateCrtAnim();
            }
        }
        this.target.update();
    }

    public static boolean isCharacter(Entity entity) {
        return entity.type == 16;
    }
}

