/*
 * Decompiled with CFR 0.152.
 */
package generic;

import java.util.Vector;

public class Cache {
    public static final int CACHE_L0 = 0;
    public static final int CACHE_L1 = 1;
    public static final int CACHE_L2 = 2;
    public static final int CACHE_L3 = 3;
    public static final int CACHE_NUM = 4;
    private static Cache[] s_instances = new Cache[4];
    private short[] m_arrayShort = new short[10];
    private int[] m_arrayInt = new int[10];
    private float[] m_arrayFloat = new float[10];
    private Vector m_vector = new Vector(10);
    private int m_mutex = 0;
    private static final int ARRAY_SHORT_RESERVED = 1;
    private static final int ARRAY_INT_RESERVED = 2;
    private static final int ARRAY_FLOAT_RESERVED = 4;
    private static final int VECTOR_RESERVED = 8;

    public short[] acquireShortArray(int n) {
        Cache.ASSERT((this.m_mutex & 1) == 0);
        if (this.m_arrayShort.length < n) {
            this.m_arrayShort = new short[n];
        }
        this.m_mutex |= 1;
        return this.m_arrayShort;
    }

    public short[] acquireShortArray() {
        return this.acquireShortArray(0);
    }

    public void releaseShortArray(short[] sArray) {
        this.m_mutex &= 0xFFFFFFFE;
    }

    public int[] acquireIntArray(int n) {
        Cache.ASSERT((this.m_mutex & 2) == 0);
        if (this.m_arrayInt.length < n) {
            this.m_arrayInt = new int[n];
        }
        this.m_mutex |= 2;
        return this.m_arrayInt;
    }

    public int[] acquireIntArray() {
        return this.acquireIntArray(0);
    }

    public void releaseIntArray(int[] nArray) {
        this.m_mutex &= 0xFFFFFFFD;
    }

    public float[] acquireFloatArray(int n) {
        Cache.ASSERT((this.m_mutex & 4) == 0);
        if (this.m_arrayFloat.length < n) {
            this.m_arrayFloat = new float[n];
        }
        this.m_mutex |= 4;
        return this.m_arrayFloat;
    }

    public float[] acquireFloatArray() {
        return this.acquireFloatArray(0);
    }

    public void releaseFloatArray(float[] fArray) {
        this.m_mutex &= 0xFFFFFFFB;
    }

    public Vector acquireVector(int n) {
        Cache.ASSERT((this.m_mutex & 8) == 0);
        this.m_vector.setSize(n);
        this.m_mutex |= 8;
        return this.m_vector;
    }

    public Vector acquireVector() {
        return this.acquireVector(0);
    }

    public void releaseVector(Vector vector) {
        this.m_mutex &= 0xFFFFFFF7;
    }

    public static Cache getInstance(int n) {
        Cache.ASSERT(n >= 0 && n < 4);
        if (n >= 0 && n < 4) {
            Cache cache = s_instances[n];
            if (cache == null) {
                Cache.s_instances[n] = cache = new Cache();
            }
            return cache;
        }
        return null;
    }

    public static Cache getInstance() {
        return Cache.getInstance(0);
    }

    private static final void ASSERT(boolean bl) {
    }

    private Cache() {
    }
}

