/*
 * Decompiled with CFR 0.152.
 */
package game;

import com.ea.sdkstandalone.SDKString;
import com.ea.sdkstandalone.SDKUtils;
import game.AppEngine;
import game.GameObject;
import generic.AnimPlayer;
import generic.ResourceManager;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;

final class SceneGame {
    private static final byte LOADING_STATE_START = 0;
    private static final byte LOADING_STATE_START_GAME = 1;
    private static final byte LOADING_STATE_INIT_GAME = 2;
    private static final byte LOADING_STATE_INIT_LOAD_MASK = 3;
    private static final byte LOADING_STATE_LOAD_ANIMS = 4;
    private static final byte LOADING_STATE_LOAD_SOUNDS = 5;
    private static final byte LOADING_STATE_FINISH_UP = 6;
    private static final byte LOADING_STATE_FINISHED = 7;
    private int m_loadingState = 0;
    private static final byte LOADING_PROGRESS_START = 0;
    private static final byte LOADING_PROGRESS_FINISHED = 100;
    private int m_loadingProgress = 0;
    private boolean m_hasSceneStartedBefore = false;
    private static final int TRACK_LENGTH_MULTIPLIER = 1;
    public static final int ROAD_HEIGHT_VIEWPORT = 51;
    public static final int ROAD_BEND_SHIFT_DOWN = 4;
    public static final int CAM_SHIFT_DOWN = 5;
    public static final int SPEED_INC = 0x280000;
    public static final int SPEED_MAX = 0x1900000;
    public static final int SPEED_OFFTRACK = 0x640000;
    public static final int DEFAULT_BRAKING = 0xA00000;
    public static final int DEFAULT_POST_BOOST_SLOWING = 0x780000;
    public static final int NUM_CAR_ANGLES = 5;
    public static final int COLLISION_OFFSET = 1;
    private static final int AI_LATERAL_POS_STEER_THRESHOLD = 32768;
    public static final int AI_DISTANCE_STEER_THRESHOLD = 0xC80000;
    public static final int AI_DISTANCE_STEER_THRESHOLD_MIN = 0x430000;
    public static final int AI_KICK_IN_DELAY_MIN = 3;
    public static final int AI_KICK_IN_DELAY_MAX = 12;
    public static final int AI_CATCHUP_MULT_MIN = 55705;
    public static final int AI_CATCHUP_MULT_MAX = 65536;
    public static final int AI_RACE_START_BOOST = 86508;
    public static final int CAR_COLLISION_LENGTH_LEFT_04 = 524288;
    public static final int CAR_COLLISION_LENGTH_LEFT_03 = 524288;
    public static final int CAR_COLLISION_LENGTH_LEFT_02 = 524288;
    public static final int CAR_COLLISION_LENGTH_LEFT_01 = 524288;
    public static final int CAR_COLLISION_LENGTH_STRAIGHT = 524288;
    public static final int CAR_COLLISION_LENGTH_RIGHT_01 = 524288;
    public static final int CAR_COLLISION_LENGTH_RIGHT_02 = 524288;
    public static final int CAR_COLLISION_LENGTH_RIGHT_03 = 524288;
    public static final int CAR_COLLISION_LENGTH_RIGHT_04 = 524288;
    public static final int CAR_COLLISION_WIDTH_LEFT_04 = 13606;
    public static final int CAR_COLLISION_WIDTH_LEFT_03 = 13606;
    public static final int CAR_COLLISION_WIDTH_LEFT_02 = 13606;
    public static final int CAR_COLLISION_WIDTH_LEFT_01 = 13606;
    public static final int CAR_COLLISION_WIDTH_STRAIGHT = 13606;
    public static final int CAR_COLLISION_WIDTH_RIGHT_01 = 13606;
    public static final int CAR_COLLISION_WIDTH_RIGHT_02 = 13606;
    public static final int CAR_COLLISION_WIDTH_RIGHT_03 = 13606;
    public static final int CAR_COLLISION_WIDTH_RIGHT_04 = 13606;
    public static final int CAR_COLLISION_SPARK_OFFSET_FRONT_Y = -12;
    public static final int CAR_COLLISION_SPARK_OFFSET_BACK_Y = -9;
    private static final int CAMERA_DIST_F = 327680;
    public static final int VIEW_DISTANCE = 400;
    public static final int VIEW_LOD1 = 175;
    public static final int VIEW_LOD2 = 150;
    public static final int VIEW_LOD3 = 125;
    public static final int VIEW_LOD4 = 100;
    public static final int VIEW_LOD5 = 75;
    public static final int VIEW_OPPONENT_CAR_LOD1 = 340;
    public static final int VIEW_OPPONENT_CAR_LOD2 = 189;
    public static final int VIEW_OPPONENT_CAR_LOD3 = 105;
    public static final int VIEW_OPPONENT_CAR_LOD4 = 58;
    public static final int VIEW_OPPONENT_CAR_LOD5 = 32;
    public static final int VIEW_OPPONENT_CAR_LOD6 = 18;
    public static final int VIEW_OPPONENT_CAR_LOD7 = 10;
    public static final int VIEW_TREE_LOD1 = 340;
    public static final int VIEW_TREE_LOD2 = 290;
    public static final int VIEW_TREE_LOD3 = 240;
    public static final int VIEW_TREE_LOD4 = 190;
    public static final int VIEW_TREE_LOD5 = 140;
    public static final int VIEW_TREE_LOD6 = 90;
    public static final int VIEW_TREE_LOD7 = 40;
    public static final int LATERAL_POS_MAX = 91750;
    public static final int LATERAL_POS_MIN = -91750;
    public static final int LATERAL_POS_AI_MAX = 58982;
    public static final int LATERAL_POS_AI_MIN = -58982;
    public static final int NO_STEERING_SPEED_LOW = -524288;
    public static final int NO_STEERING_SPEED_HIGH = 524288;
    private static int VIEWPORT_LEFT;
    private static int VIEWPORT_TOP;
    private static int VIEWPORT_WIDTH;
    private static int VIEWPORT_HEIGHT;
    private static int VIEWPORT_CENTRE_X;
    private static int VIEWPORT_CENTRE_Y;
    private AppEngine m_engine;
    private boolean m_endScene = false;
    public static final int DEFAULT_STEERING_INC = 102944;
    public static final int DEFAULT_STEERING_MAX_BEND = 64340;
    public static final int DEFAULT_STEERING_MAX_STRAIGHT = 12868;
    public static final int DEFAULT_STEERING_RECENTRE_INC = 102944;
    public static final int DEFAULT_LATERAL_STEER_MAX = 85196;
    public static final int PERSPECTIVE_DIVIDE = 60293;
    public static final int HORIZON_OFFSET_INC = 4;
    public static final int HORIZON_OFFSET_MIN = 0;
    public static final int HORIZON_OFFSET_MAX = 64;
    public static final int TRACK_SCALE_MULF = 32768;
    public static final int TRACK_CURVE_INC_F = 3277;
    public static final int TRACK_CURVE_MIN_F = 0;
    public static final int TRACK_CURVE_MAX_F = 65536;
    public static final int TRACK_CURVE_WARNING_DISTANCE = 800;
    public static final int AI_HARD_CURVE_WARNING_DISTANCE = 640;
    public static final int AI_NORM_CURVE_WARNING_DISTANCE = 747;
    public static final int AI_SOFT_CURVE_WARNING_DISTANCE = 853;
    private static final int RACE_COMPLETE_DELAYTIME = 196608;
    private static final int LAPTIME_DISPLAY_DURATION = 131072;
    public static final int GC_SLEEP_TIME = 20;
    private static final int BOOST_GAUGE_MAX = 0x640000;
    private static final int BOOST_DEPLETE_RATE = 1091829;
    private static final int BOOST_RESTORE_RATE = 36044;
    private static final int BOOST_MIN_USABLE_AMOUNT = 0x140000;
    private static final int DEFAULT_MAX_BOOST_TIME = 196608;
    private static final int NUM_GEARS = 6;
    private static int HUD_TOP;
    private static final int HUD_MAP_LINE_LEFT_POSITION_X = 5;
    private static int HUD_MAP_LINE_RIGHT_POSITION_X;
    private static int HUD_MAP_LINE_POSITION_Y;
    public static final int HUD_HEIGHT = 30;
    private static int HUD_BOTTOM;
    private static int TRACK_VIEWPORT_HEIGHT;
    private static final int HUD_LAP_POSITION_X = 3;
    private static final int HUD_LAP_POSITION_Y = 0;
    private static final int HUD_TIME_POSITION_X = 90;
    private static final int HUD_TIME_POSITION_Y = 0;
    public static final int TOP_HUD_BAR_HEIGHT = 14;
    private static final int HUD_LAP_TIMES_POS_Y = 19;
    private static final int HUD_BUSTED_POS_Y = 29;
    private static int HUD_LAP_TIMES_TITLE_POS_Y;
    private static int HUD_LAP_TIMES_POSITION_POS_Y;
    private static int HUD_LAP_TIMES_LAP_POS_Y;
    private static int HUD_BUSTED_MSG_POS_Y;
    private static int HUD_SPEED_POSITION_X;
    private static int HUD_SPEED_POSITION_Y;
    private static int HUD_BOOST_PARTS;
    private static int HUD_BOOST_PART_WIDTH;
    private static int HUD_BOOST_PART_HEIGHT;
    private static int HUD_BOOST_PART_INNER_MARGIN;
    private static int HUD_BOOST_PART_OUTER_MARGIN;
    private static final int INTRO_CAMANIM_STAGE_TIME = 1500;
    private static final int COP_TAKEOUT_INTRO_CAMANIM_STAGE_TIME = 500;
    private static final int RACE_INTRO_SPEED_GRIP = 2000;
    private static final int RACE_INTRO_LIGHTS_OFF_POS = 917504;
    private static final int RACE_INTRO_GRIP_OFFSET_MAX = 0x220000;
    private static final int AI_DIFFICULTY_MIN_F = 49152;
    private static final int AI_DIFFICULTY_MAX_F = 65536;
    public static final int LATERAL_DRIFT_FADE_RATE = 14745;
    public static final int LATERAL_DRIFT_ACCUMULATE_RATE = 49152;
    public static final int LATERAL_DRIFT_STEER_MULT = 58982;
    private static final int OUTSIDE_TURN_SPEED_MULT = 52429;
    private static final int INSIDE_TURN_SPEED_MULT = 85197;
    private static final int MAX_DRIFT_ROTATION = 51472;
    private static final int MAX_DRIFT_ROTATION_SPEED = 200;
    private static final int DRIFT_RECENTRE_ROTATION_SPEED = 80;
    private static final int COP_LIGHTS_INIT_LENGTH = 0xB40000;
    private static final int[] TRACK1_WIDTHS;
    private boolean m_raceIntroDone;
    private int m_raceIntroCount;
    private int m_raceIntroTimer;
    private short m_raceIntroAnim;
    private int m_raceIntroSpeed;
    private int m_raceIntroOffsetY;
    private int m_raceIntroOffsetMax;
    private boolean m_isSteeringLeft;
    private boolean m_isSteeringRight;
    private int[] m_trackSectionCurvature;
    private int[] m_trackSectionAbsStart;
    private int[] m_trackSectionAbsEnd;
    private int[] m_trackSectionLength;
    private int[] m_trackSectionLengthInvF;
    private int m_trackNumSections;
    private int m_trackTotalDistance;
    private int m_currBendFactor = 0;
    private int[] m_trackBendOffsets;
    private int m_renderCityOffsetXF = 0;
    private int[] m_perspectiveRangesF = null;
    private int m_skylineColour;
    private int m_groundDarkColor;
    private int m_groundLightColor;
    private GameObject[] m_carsTrackOrder = null;
    private GameObject[] m_carsRaceOrder = null;
    private GameObject[] m_opponentCars = null;
    private GameObject[] m_raceEndStandings;
    private int m_firstCarRenderIndex = 0;
    private int m_currCarRenderIndex = 0;
    private int m_raceEndStandingsIndex = 0;
    private GameObject m_playerCar = null;
    private AnimPlayer m_playerCarAnimPlayer;
    private AnimPlayer m_copLightsPlayer;
    private short[] m_playerBrakesAnimIDs;
    private int m_crashLeftAnimID;
    private int m_crashRightAnimID;
    private int m_playerSteeringAngleF;
    private int m_playerSteeringIncF;
    private int m_playerSteeringMaxF;
    private int m_playerSteeringRecentreIncF;
    private int m_playerTyresF;
    private int m_playerTyresInvF;
    private int m_playerBoostMultF;
    private boolean m_playerOffTrack = false;
    private boolean m_playerIsBoosting = false;
    private boolean m_copLightsActivated = false;
    private boolean m_driftBoost = false;
    private int m_timeSinceLastBoost;
    private int m_playerCarLateralDriftF = 0;
    private int m_playerCarDriftDiffTargetF = 0;
    private int m_playerBoostTimeF = 196608;
    private int m_playerUpdateSteeringF = 0;
    private int m_playerCarDriftingAngleTargetF;
    private int m_playerCarDriftingAngleCurrentF;
    private AnimPlayer m_playerImpactSparkAnimPlayer;
    private boolean m_playerBumpedFront = false;
    private int m_playerImpactSparkX = 0;
    private int m_playerImpactSparkY = 0;
    private AnimPlayer m_smokeLeftAnimPlayer;
    private AnimPlayer m_smokeRightAnimPlayer;
    private boolean m_smokingLeftWheel = false;
    private boolean m_smokingRightWheel = false;
    private AnimPlayer m_speedlinesAnimPlayer;
    private int[] m_playerCarLowRevSpeedsF;
    private int[] m_playerCarRevDivsF;
    private int m_cornerOutsideSpeedMult = 52429;
    private int m_cornerInsideSpeedMult = 85197;
    private SDKString m_eolTitleString;
    private SDKString m_eolLapTimeString;
    private SDKString m_lapString;
    private SDKString m_eolPosString;
    private SDKString m_posString;
    private SDKString m_ticketsString;
    private SDKString m_timeString;
    private int TEMP_STRING_BUFFER_LENGTH = 20;
    private SDKString m_tempStringBuffer = new SDKString(this.TEMP_STRING_BUFFER_LENGTH, 0);
    private int m_bonusNitroBoostTimer;
    private int m_playerCarCollisionPushDiv = 0;
    private int m_viewPosF = 0;
    private int m_viewSection = 0;
    private int m_cameraShakeX = 0;
    private int m_cameraShakeXAmplitudeF = 0;
    private int m_cameraShakeXAmplitudeMaxF = 262144;
    private static int m_cameraShakeXAmplitudeInitialF;
    private int m_boostGaugeLevel;
    private AnimPlayer m_boostAnimPlayer;
    private GameObject m_chasedCar;
    private static final short[] EFFECTS_SMOKE_LEFT;
    private static final short[] EFFECTS_SMOKE_RIGHT;
    private static final short[] BRAKES_STD;
    private static final int COLLISION_BRAKE_TIMEOUT = 300;
    private int m_collisionBrakingTimeout;
    private int[] m_carCollisionLengthsF;
    private int[] m_carCollisionWidthsF;
    private int[] m_carAnimIDs;
    private int[] m_boostAnimIDs;
    private int m_numOpponentRacerCars;
    private int m_numCriminalCars;
    private int m_numDeadCriminalCars;
    private int m_numOpponentCars;
    private int m_eventTime;
    private long m_lastLapTime;
    private long m_bestLapTime = -1L;
    private int m_lastLapDisplayTimer = 0;
    private boolean m_lastLapTimeShowing = false;
    private int m_bestLapDisplayTimer = 0;
    private boolean m_bestLapTimeShowing = false;
    private int m_bustedDisplayTimer = 0;
    private boolean m_bustedShowing = false;
    private byte m_raceMaxLaps;
    private boolean m_raceComplete;
    private int m_raceCompleteTimer;
    private int m_eventType;
    private int m_eventMusicId = -1;
    private static final int SMOKE_TAKEOFF_TIMEOUT = 500;
    private int m_takeOffSmokeTimer;
    private int m_revPercentF;
    private int m_tachoRandomJump = 0;
    private boolean m_renderFullHUD;
    private boolean m_renderHUDTop;
    private static final int MAX_UPDATE_LOADING_TIME = 64;
    private int m_loadMask = 0;
    private int m_updateLoadingTime;
    private int m_loadedItems;
    private int m_opponentCarAnimID;
    private int m_criminalCarAnimID;
    private GameObject m_nextOpponentRaceOrder;
    private GameObject m_prevOpponentRaceOrder;
    public boolean m_triggerInterruptPause = false;
    private static final int CRASH_CUTSCENE_END_DELAY = 900;
    private boolean m_crashCutscenePlaying = false;
    private boolean m_crashCutsceneBridgingAnimDone = false;
    private boolean m_crashCutsceneEndAnimDone = false;
    private int m_crashCutsceneEndDelay = 0;
    private int musicID = -1;
    private static final int STARTING_LINE = -1310720;
    private static final int CORNER_CALIB_SPEED = 0x960000;
    private static final int CORNER_CALIB_SPEED_INV = 436;
    private static final int[] CORNER_VALUES;

    public final boolean isLoadingComplete() {
        return this.m_loadingState == 7;
    }

    public SDKString getPosString() {
        return this.m_posString;
    }

    public SceneGame() {
        this.m_engine = AppEngine.getCanvas();
    }

    public AppEngine getAppEngine() {
        return this.m_engine;
    }

    private void initialiseGameVariables() {
        this.m_raceMaxLaps = this.m_engine.getNextRaceNumLaps();
        this.m_trackBendOffsets = new int[51];
    }

    private void initGameStrings() {
        this.updateLapString(1);
        this.updateTicketsString(0);
        this.updateTimeString(this.m_eventTime);
        this.updatePosStrings(this.m_playerCar.getRacePos() + 1);
    }

    public void initGame() {
        this.m_bustedShowing = false;
        this.m_raceEndStandingsIndex = 0;
        this.m_raceIntroOffsetY = 917504;
        this.m_eventType = this.m_engine.getEventHubEventType((byte)this.m_engine.getCarNowRacingHubIndex(), (byte)this.m_engine.getCarNowRacingEventIndex());
        this.m_chasedCar = null;
        if (this.m_eventType == 0) {
            this.m_numOpponentRacerCars = 3;
            this.m_numCriminalCars = 0;
        } else if (this.m_eventType == 1) {
            this.m_numOpponentRacerCars = 3;
            this.m_numCriminalCars = 0;
        } else if (this.m_eventType == 2) {
            this.m_numOpponentRacerCars = 0;
            this.m_numCriminalCars = 1;
            this.m_eventTime = 0x960000;
        }
        this.m_numDeadCriminalCars = 0;
        this.m_numOpponentCars = this.m_numCriminalCars + this.m_numOpponentRacerCars;
        this.m_raceIntroAnim = (short)48;
        this.m_raceIntroSpeed = 2000;
        this.m_raceIntroOffsetMax = 0x220000;
        this.loadTrack(this.m_engine.getCurrTrack());
        this.initDisplayDimensionsAndOffsets();
        this.initPerspectiveRanges();
        this.initPlayerCar();
        this.initOpponentCars();
        this.initTrackOrderArray();
        this.initCar();
        this.sortCarsTrackOrder();
        this.sortCarsRaceOrder(false);
        this.initStaticObjects();
        this.sortStaticObjTrackOrder();
        this.initGameStrings();
        this.setCopLightsActivated(false);
        ResourceManager.stopAllSounds();
        this.startRaceIntro();
    }

    private void startGameInit() {
        ResourceManager resourceManager = this.m_engine.getResourceManager();
        this.m_playerImpactSparkAnimPlayer = resourceManager.createAnimPlayer();
        this.m_playerCarAnimPlayer = resourceManager.createAnimPlayer();
        this.m_copLightsPlayer = resourceManager.createAnimPlayer();
        this.m_boostAnimPlayer = resourceManager.createAnimPlayer();
        this.m_smokeLeftAnimPlayer = resourceManager.createAnimPlayer();
        this.m_smokeRightAnimPlayer = resourceManager.createAnimPlayer();
        this.m_speedlinesAnimPlayer = resourceManager.createAnimPlayer();
        this.initialiseGameVariables();
        System.gc();
    }

    private void restartGameInit() {
        this.initialiseGameVariables();
        this.m_playerImpactSparkAnimPlayer.setAnimating(false);
        this.setPlayerBoosting(false);
        this.m_endScene = false;
        this.m_raceComplete = false;
        this.m_crashCutscenePlaying = false;
        this.m_boostGaugeLevel = 0;
        this.m_playerCar.m_numLapsCompleted = 0;
        this.m_playerCar.m_currSection = 0;
        this.m_cameraShakeX = 0;
        this.m_cameraShakeXAmplitudeF = 0;
        this.m_takeOffSmokeTimer = 0;
        this.m_playerOffTrack = false;
        this.m_smokingLeftWheel = false;
        this.m_smokingRightWheel = false;
        this.hideLastLapTime();
    }

    public void restartGame() {
        this.m_loadingState = 0;
        this.m_loadingProgress = 0;
    }

    public void pause() {
        if (this.m_loadingState != 7) {
            this.m_triggerInterruptPause = true;
        }
    }

    public void resume() {
        this.m_renderFullHUD = true;
        this.m_renderHUDTop = true;
    }

    public void end() {
        this.m_engine.unloadImages(524287);
        if (this.m_eventMusicId >= 0) {
            ResourceManager resourceManager = this.m_engine.getResourceManager();
            ResourceManager.unloadSound(this.m_eventMusicId, resourceManager);
        }
    }

    public byte menuAfterInterrupt() {
        if (this.m_raceComplete) {
            this.updateRaceProgress(65536);
            return 4;
        }
        return 25;
    }

    public void repaintScene() {
        this.m_renderFullHUD = true;
        this.m_renderHUDTop = true;
    }

    public void update(int n) {
        int n2;
        int n3;
        int n4;
        GameObject gameObject = this.m_playerCar;
        if (this.m_loadingState != 7) {
            this.updateLoading(n);
            return;
        }
        if (this.m_triggerInterruptPause) {
            this.m_engine.resumeGame();
            this.m_triggerInterruptPause = false;
        }
        if (!this.m_raceIntroDone) {
            this.updateRaceIntro(n);
            n = 0;
        }
        int n5 = AppEngine.Fmul(n << 16, 66);
        this.m_revPercentF = 0;
        if (gameObject.m_speedF > this.m_playerCarLowRevSpeedsF[gameObject.m_currentGear]) {
            this.m_revPercentF = AppEngine.Fmul(gameObject.m_speedF - this.m_playerCarLowRevSpeedsF[gameObject.m_currentGear], this.m_playerCarRevDivsF[gameObject.m_currentGear]);
        }
        if (this.m_revPercentF > 72089) {
            this.m_revPercentF = 72089;
        }
        this.m_tachoRandomJump = this.m_engine.rand(0, 6144) - 3072;
        if (this.m_collisionBrakingTimeout > 0) {
            this.m_collisionBrakingTimeout -= n;
        }
        if (this.m_takeOffSmokeTimer > 0) {
            this.m_takeOffSmokeTimer -= n;
        }
        if (gameObject.m_finishedRace) {
            for (n4 = 0; n4 < this.m_opponentCars.length; ++n4) {
                this.m_opponentCars[n4].m_isBraking = true;
            }
            gameObject.m_isBraking = true;
            gameObject.setBoosting(false);
            this.m_smokingRightWheel = this.m_smokingLeftWheel = gameObject.m_speedF > 0;
        }
        n4 = this.m_trackSectionCurvature[gameObject.m_currSection];
        int n6 = this.m_playerCarDriftingAngleTargetF;
        n6 = this.m_raceComplete && gameObject.m_isBraking ? 51472 : 0;
        int n7 = n6 - this.m_playerCarDriftingAngleCurrentF;
        if (this.m_playerCarDriftingAngleCurrentF != 0) {
            n3 = 80;
            if (n7 < 0) {
                n3 = -n3;
            }
        } else {
            n3 = 200;
            if (n7 < 0) {
                n3 = -n3;
            }
        }
        this.m_playerCarDriftingAngleTargetF = n6;
        int n8 = AppEngine.Fmul(n3, n << 16);
        if (n3 > 0 && n8 > n7 || n3 < 0 && n8 < n7) {
            n8 = n7;
        }
        this.m_playerCarDriftingAngleCurrentF += n8;
        this.updateCollisions(n5);
        this.updateBoost(n5);
        if (this.m_bonusNitroBoostTimer > 0) {
            this.m_bonusNitroBoostTimer -= n;
            if (this.m_bonusNitroBoostTimer <= 0) {
                gameObject.setBoosting(false);
                this.m_playerIsBoosting = false;
            }
        }
        this.updateSteering(n5);
        this.updateCityScroll(n);
        this.updateAllCarsTrackPos(n5);
        this.m_currBendFactor = this.m_raceIntroDone ? this.calcBendFactor() : 0;
        this.calcTrackBendOffsets();
        if (this.m_raceIntroDone && this.m_raceIntroOffsetY > 917504) {
            this.m_raceIntroOffsetY -= this.m_raceIntroSpeed * n;
        }
        if (n5 > 0) {
            this.updateLateralPos(n5);
        }
        if (!gameObject.m_finishedRace) {
            this.updateSmoke(n5);
            this.updateOpponentCarsSteering(n5);
            this.updateOpponentCarsLateralPos(n5);
        }
        this.updateRaceProgress(n5);
        this.updateOnScreenDisplays(n5);
        this.updateAnims(n);
        int n9 = gameObject.getRacePos();
        this.sortCarsRaceOrder(true);
        this.sortCarsTrackOrder();
        for (n2 = 0; n2 < this.m_carsRaceOrder.length; ++n2) {
            GameObject gameObject2 = this.m_carsRaceOrder[n2];
            gameObject2.updateCatchupCode(n5);
        }
        if (gameObject.getRacePos() != n9 && !this.m_raceComplete) {
            n2 = gameObject.getRacePos() + 1;
            this.updatePosStrings(n2);
        }
        if (this.m_endScene) {
            this.m_engine.setSharedMenu(gameObject.m_finishedRace ? 4 : 77);
        }
        if (this.m_eventType == 2 && !this.m_raceComplete) {
            if (!this.m_copLightsActivated && !this.m_chasedCar.isDead()) {
                n2 = this.m_chasedCar.m_trackPosF - this.m_playerCar.m_trackPosF;
                if (n2 < 0) {
                    n2 += this.m_trackTotalDistance << 16;
                }
                if (n2 < 0xB40000) {
                    this.setCopLightsActivated(true);
                }
            }
            this.m_eventTime -= n5;
            if (this.m_eventTime <= 0) {
                this.m_eventTime = 0;
                this.endRace();
            }
            this.updateTimeString(this.m_eventTime);
        }
    }

    private boolean updateAllCarsTrackPos(int n) {
        boolean bl = true;
        for (int i = 0; i < this.m_carsTrackOrder.length; ++i) {
            int n2;
            int n3;
            GameObject gameObject = this.m_carsTrackOrder[i];
            if (!gameObject.m_finishedRace) {
                gameObject.m_currentLapTime += n;
                if (bl) {
                    bl = false;
                }
            }
            gameObject.updateSpeed(n);
            int n4 = gameObject.m_speedF;
            n4 = AppEngine.Fmul(n4, gameObject.m_catchupCodeMultCurrF);
            int n5 = this.m_trackSectionCurvature[gameObject.m_currSection];
            if (gameObject == this.m_playerCar && n5 != 0) {
                n3 = this.m_cornerInsideSpeedMult - this.m_cornerOutsideSpeedMult;
                n2 = gameObject.m_lateralPosF + 65536 >> 1;
                if (n5 < 0) {
                    n2 = 65536 - n2;
                }
                int n6 = this.m_cornerOutsideSpeedMult + AppEngine.Fmul(n2, n3);
                n4 = AppEngine.Fmul(n4, n6);
            }
            n4 = AppEngine.Fmul(n4, 111411);
            n3 = gameObject.m_trackPosF;
            gameObject.m_trackPosF += AppEngine.Fmul(n4, n);
            while (gameObject.m_trackPosF > this.m_trackSectionAbsEnd[gameObject.m_currSection] << 16) {
                n2 = this.m_trackSectionCurvature[gameObject.m_currSection];
                if (gameObject == this.m_playerCar && !gameObject.m_finishedRace && this.m_trackSectionCurvature[gameObject.m_currSection] != 0 && this.m_trackSectionCurvature[gameObject.m_nextSection] == 0) {
                    this.m_playerSteeringAngleF = 0;
                }
                ++gameObject.m_currSection;
                if (gameObject.m_currSection >= this.m_trackNumSections) {
                    gameObject.m_currSection -= this.m_trackNumSections;
                    gameObject.m_trackPosF -= this.m_trackTotalDistance << 16;
                    if (!gameObject.m_finishedRace) {
                        this.gameObjectFinishedLap(gameObject, n3 - (this.m_trackTotalDistance << 16), n);
                    }
                }
                gameObject.m_nextSection = gameObject.m_currSection + 1;
                if (gameObject.m_nextSection < this.m_trackNumSections) continue;
                gameObject.m_nextSection -= this.m_trackNumSections;
            }
        }
        return bl;
    }

    private void updateRaceProgress(int n) {
        if (this.m_raceComplete) {
            this.m_raceCompleteTimer += n;
            if (this.m_raceCompleteTimer >= 196608) {
                if (this.m_eventType != 2) {
                    this.m_playerCar.m_isBraking = false;
                    this.m_playerCar.m_isAccelerating = true;
                    for (int i = 0; i < this.m_opponentCars.length; ++i) {
                        this.m_opponentCars[i].m_isBraking = false;
                    }
                    while (!this.updateAllCarsTrackPos(n << 5)) {
                    }
                } else {
                    this.m_playerCar.m_finishedRace = true;
                    for (int i = 0; i < this.m_raceEndStandings.length; ++i) {
                        this.m_raceEndStandings[i] = this.m_carsTrackOrder[i];
                    }
                }
                this.m_engine.submitRaceStandings(this.m_raceEndStandings, 4 == this.m_numDeadCriminalCars && this.m_eventType == 2);
                this.m_endScene = true;
            }
        }
    }

    private void updatePosStrings(int n) {
        int n2 = 0;
        for (int i = this.m_carsRaceOrder.length - 1; i >= 0; --i) {
            if (this.m_carsRaceOrder[i].m_type == 3) {
                ++n2;
                continue;
            }
            if (this.m_carsRaceOrder[i] == this.m_playerCar) break;
        }
        this.m_engine.intToSDKString(n -= n2, false, this.m_tempStringBuffer);
        this.m_tempStringBuffer.append(ResourceManager.SLASH_STRING);
        this.m_tempStringBuffer.append(this.m_numOpponentRacerCars + 1);
        this.m_posString = this.m_engine.getString(83).concat(this.m_tempStringBuffer);
        this.m_eolPosString = this.m_engine.getString(88).concat(this.m_tempStringBuffer);
        this.m_renderHUDTop = true;
    }

    public void updateLapString() {
        this.updateLapString(this.m_playerCar.m_numLapsCompleted + 1);
    }

    private void updateLapString(int n) {
        this.m_engine.intToSDKString(n, false, this.m_tempStringBuffer);
        this.m_tempStringBuffer.append(ResourceManager.SLASH_STRING);
        this.m_tempStringBuffer.append(this.m_raceMaxLaps);
        this.m_lapString = this.m_engine.getString(48).concat(this.m_tempStringBuffer);
        this.m_renderHUDTop = true;
    }

    private void updateTicketsString(int n) {
        this.m_engine.intToSDKString(n, false, this.m_tempStringBuffer);
        this.m_tempStringBuffer.append(ResourceManager.SLASH_STRING);
        this.m_tempStringBuffer.append(4);
        this.m_ticketsString = this.m_engine.getString(74).concat(this.m_tempStringBuffer);
        this.m_renderHUDTop = true;
    }

    private void updateTimeString(int n) {
        this.m_timeString = this.m_engine.getString(73).concat(this.m_engine.raceTimeToFormattedTime(n, true));
        this.m_renderHUDTop = true;
    }

    public void gameObjectFinishedLap(GameObject gameObject, int n, int n2) {
        int n3;
        ++gameObject.m_numLapsCompleted;
        if (this.m_eventType == 2) {
            return;
        }
        if (gameObject == this.m_playerCar) {
            n3 = gameObject.m_numLapsCompleted + 1;
            if (n3 == 0) {
                n3 = 1;
            } else if (n3 > this.m_raceMaxLaps) {
                n3 = this.m_raceMaxLaps;
            }
            this.updateLapString(n3);
        }
        if (gameObject.m_numLapsCompleted > 0) {
            gameObject.m_cumulativeLapTimes += gameObject.m_currentLapTime;
        }
        if (gameObject.m_numLapsCompleted == this.m_raceMaxLaps) {
            gameObject.m_finishedRace = true;
            for (n3 = this.m_raceEndStandingsIndex; n3 != 0 && this.m_raceEndStandings[n3 - 1].m_cumulativeLapTimes > gameObject.m_cumulativeLapTimes; --n3) {
                this.m_raceEndStandings[n3] = this.m_raceEndStandings[n3 - 1];
            }
            this.m_raceEndStandings[n3] = gameObject;
            if (gameObject == this.m_playerCar) {
                this.updatePosStrings(n3 + 1);
            }
            ++this.m_raceEndStandingsIndex;
        }
        if (gameObject == this.m_playerCar && gameObject.m_numLapsCompleted != 0) {
            this.m_lastLapTime = gameObject.m_currentLapTime;
            this.m_eolLapTimeString = this.m_engine.getString(72).concat(this.m_engine.raceTimeToFormattedTime(this.m_lastLapTime, true));
            if (this.m_bestLapTime == -1L || this.m_lastLapTime < this.m_bestLapTime) {
                this.m_bestLapTime = this.m_lastLapTime;
                this.showBestLapTime();
            }
            this.showLastLapTime();
            if (gameObject.m_finishedRace) {
                this.endRace();
            }
        }
        if (gameObject.m_numLapsCompleted > 0) {
            gameObject.m_currentLapTime = 0;
        }
    }

    public void render(Graphics graphics) {
        if (this.m_loadingState != 7) {
            this.m_engine.renderLoading(graphics, this.m_loadingProgress);
            return;
        }
        if (this.m_raceComplete && this.m_raceCompleteTimer >= 196608) {
            return;
        }
        this.adjustViewpoint();
        this.renderSkyline(graphics);
        this.renderTrack(graphics);
        this.renderDrawList(graphics);
        if (this.m_engine.m_rmsCarMarkersEnabled) {
            this.renderRacePosIndicatorRear(graphics);
        }
        if ((this.m_raceIntroDone || this.m_raceIntroCount < 1) && this.m_lastLapTimeShowing && this.m_eventType != 2) {
            this.renderLapTimes(graphics);
        }
        if (this.m_bustedShowing) {
            this.renderBustedMessage(graphics);
        }
        if (!this.m_raceIntroDone || this.m_raceIntroOffsetY > 917504) {
            this.renderRaceIntroHUD(graphics);
            this.m_renderHUDTop = true;
        }
        this.renderHUD(graphics);
    }

    public void processKeys(int n, int n2) {
        if (n2 == 1) {
            this.m_engine.setSharedMenu(25);
        } else if (!this.m_raceIntroDone) {
            this.processKeysRaceIntro(n, n2);
        } else {
            this.processKeysDriving(n, n2);
        }
    }

    private void processKeysRaceIntro(int n, int n2) {
    }

    private void processKeysDriving(int n, int n2) {
        boolean bl = false;
        if (this.m_crashCutscenePlaying) {
            this.m_isSteeringLeft = false;
            this.m_isSteeringRight = false;
            bl = true;
        } else {
            this.m_isSteeringLeft = (n & 0x8010) != 0;
            boolean bl2 = this.m_isSteeringRight = (n & 0x10040) != 0;
            if (this.m_playerOffTrack && this.m_playerCar.m_speedF > 0x640000) {
                bl = true;
            }
            if ((n & 0x2004) != 0) {
                if (this.m_boostGaugeLevel >= 0x140000) {
                    this.m_driftBoost = false;
                    if (this.m_playerCar.m_isBraking) {
                        this.setPlayerBoosting(false);
                    } else {
                        this.setPlayerBoosting(true);
                    }
                }
                this.m_engine.clearKeyBit(8196);
            }
        }
        if (bl) {
            this.m_playerCar.m_isAccelerating = false;
            if (this.m_playerOffTrack && this.m_playerCar.m_speedF > 0x640000) {
                this.m_playerCar.m_isBraking = false;
                this.m_playerCar.m_isOffTrackBraking = true;
            } else {
                this.m_playerCar.m_isBraking = true;
                this.m_playerCar.m_isOffTrackBraking = false;
            }
        } else {
            this.m_playerCar.m_isBraking = (n & 0x4100) != 0;
            this.m_playerCar.m_isOffTrackBraking = false;
            this.m_playerCar.m_isAccelerating = !this.m_playerCar.m_isBraking;
        }
    }

    private void startCrashCutscene() {
        this.m_crashCutscenePlaying = true;
        this.m_crashCutsceneBridgingAnimDone = false;
        this.m_crashCutsceneEndAnimDone = false;
        this.crashCutsceneBeginBridgingAnim();
    }

    private void crashCutsceneBeginBridgingAnim() {
        int n = this.m_playerCarDriftingAngleCurrentF > 0 ? this.m_crashLeftAnimID : this.m_crashRightAnimID;
        this.m_playerCarAnimPlayer.startAnim(n, true, false);
    }

    private void crashCutsceneBeginFinalAnim() {
        this.m_crashCutsceneBridgingAnimDone = true;
        this.m_crashCutsceneEndAnimDone = false;
    }

    private void crashCutsceneEndFinalAnim() {
        this.m_crashCutsceneEndAnimDone = true;
        this.m_crashCutsceneEndDelay = 0;
        this.m_playerCarAnimPlayer.setAnimating(false);
        this.m_playerCar.m_speedF = 0;
    }

    private void updateCrashCutscene(int n) {
        if (!this.m_crashCutsceneBridgingAnimDone) {
            if (!this.m_playerCarAnimPlayer.isAnimating()) {
                this.crashCutsceneBeginFinalAnim();
            } else {
                int n2 = this.m_playerCarAnimPlayer.getCurrAnimFrame();
                this.m_playerCarAnimPlayer.updateAnim(n);
                int n3 = this.m_playerCarAnimPlayer.getCurrAnimFrame();
                if (n2 < 5 && 5 <= n3) {
                    this.m_engine.vibrate(500);
                }
            }
        } else if (!this.m_crashCutsceneEndAnimDone) {
            if (!this.m_playerCarAnimPlayer.isAnimating()) {
                this.crashCutsceneEndFinalAnim();
            } else {
                this.m_playerCarAnimPlayer.updateAnim(n);
            }
        } else if (this.m_crashCutsceneEndDelay < 900) {
            this.m_crashCutsceneEndDelay += n;
        } else {
            this.endCrashCutscene();
        }
    }

    private void endCrashCutscene() {
        this.m_playerCarAnimPlayer.startAnim(this.m_carAnimIDs[this.getPlayerCarAnimID()], true, true);
        this.m_crashCutscenePlaying = false;
        this.m_playerCar.m_lateralPosF = 0;
        this.m_playerCar.m_lateralPosTargetF = 0;
    }

    private static final void DEBUG_LOADING(String string) {
    }

    private void updateLoading(int n) {
        ResourceManager resourceManager = this.m_engine.getResourceManager();
        switch (this.m_loadingState) {
            case 0: {
                ++this.m_loadingState;
                this.m_loadingProgress = 5;
                break;
            }
            case 1: {
                if (this.m_hasSceneStartedBefore) {
                    this.restartGameInit();
                } else {
                    this.startGameInit();
                    this.m_hasSceneStartedBefore = true;
                }
                ++this.m_loadingState;
                this.m_loadingProgress = 10;
                break;
            }
            case 2: {
                this.initGame();
                ++this.m_loadingState;
                this.m_loadingProgress = 15;
                break;
            }
            case 3: {
                int n2 = this.m_loadMask;
                int n3 = this.createNewLoadMask();
                int n4 = n2 & ~n3;
                int n5 = 0;
                int n6 = AppEngine.IMAGE_IDS[0];
                while (n6 != -1) {
                    int n7;
                    if (((n7 = AppEngine.IMAGE_IDS[++n5]) & n4) != 0) {
                        resourceManager.unloadImage(n6);
                    }
                    n6 = AppEngine.IMAGE_IDS[++n5];
                }
                this.m_loadMask = n3;
                ++this.m_loadingState;
                this.m_loadingProgress = 20;
                this.m_updateLoadingTime = 64;
                this.m_loadedItems = 0;
                break;
            }
            case 4: {
                if (0 < this.m_updateLoadingTime) {
                    this.m_updateLoadingTime -= n;
                    break;
                }
                int n8 = this.m_loadedItems << 1;
                int n9 = AppEngine.IMAGE_IDS[n8 + 0];
                int n10 = AppEngine.IMAGE_IDS[n8 + 1];
                boolean bl = false;
                if ((n10 & this.m_loadMask) != 0) {
                    boolean bl2 = bl = !resourceManager.loadImage(resourceManager, n9);
                }
                if (!bl) {
                    ++this.m_loadedItems;
                }
                if (this.m_loadedItems == this.m_engine.IMAGE_COUNT) {
                    this.m_loadingProgress = 70;
                    this.m_updateLoadingTime = Integer.MAX_VALUE;
                    ++this.m_loadingState;
                    this.m_loadedItems = 0;
                    break;
                }
                this.m_loadingProgress = 20 + 50 * this.m_loadedItems / this.m_engine.IMAGE_COUNT;
                this.m_updateLoadingTime = 64;
                break;
            }
            case 5: {
                if (this.m_loadedItems == 1) {
                    ++this.m_loadingState;
                    this.m_loadingProgress = 90;
                    this.m_loadedItems = 0;
                    break;
                }
                if (this.m_loadedItems == 0) {
                    if (this.m_eventMusicId >= 0) {
                        ResourceManager.unloadSound(this.m_eventMusicId, resourceManager);
                    }
                    this.m_eventMusicId = this.getEventMusic();
                    ResourceManager.loadSound(this.m_eventMusicId, resourceManager);
                    ++this.m_loadedItems;
                }
                this.m_loadingProgress = 70 + 20 * this.m_loadedItems / 1;
                break;
            }
            case 6: {
                this.m_boostAnimPlayer.startAnim(62, true, true);
                this.changeSkyColour();
                this.m_engine.setSoftKeys(0, 1);
                this.m_loadingState = 7;
                this.m_loadingProgress = 100;
                ResourceManager.startMusic(this.m_eventMusicId);
            }
        }
    }

    private final int getEventMusic() {
        if (this.musicID != -1) {
            return this.musicID;
        }
        int n = this.m_engine.rand(0, 2);
        switch (n) {
            case 0: {
                this.musicID = 0;
                break;
            }
            case 1: {
                this.musicID = 3;
                break;
            }
            case 2: {
                this.musicID = 2;
                break;
            }
            default: {
                this.musicID = 0;
            }
        }
        return this.musicID;
    }

    private int createNewLoadMask() {
        int n;
        int n2;
        int n3 = 0;
        switch (this.m_engine.getTrackThemeID(this.m_engine.getCurrTrack())) {
            case 0: {
                n3 |= 1;
                break;
            }
            case 1: {
                n3 |= 2;
            }
        }
        int n4 = this.m_engine.getPlayerCarIndex();
        n3 |= this.m_engine.getPlayerCarLoadMask(n4);
        this.m_crashLeftAnimID = this.m_engine.getPlayerCarCrashLeftAnimID(n4);
        this.m_crashRightAnimID = this.m_engine.getPlayerCarCrashRightAnimID(n4);
        this.m_playerBrakesAnimIDs = BRAKES_STD;
        if (this.m_numCriminalCars > 0) {
            n2 = this.m_engine.getTrackThemeID(this.m_engine.getCurrTrack());
            n = n2 == 0 ? 1 : 2;
            this.m_criminalCarAnimID = this.m_engine.getOpponentCarAnimID(n);
            n3 |= this.m_engine.getOpponentCarLoadMask(n);
        }
        if (this.m_numOpponentRacerCars > 0) {
            n2 = this.m_eventType;
            n = this.m_engine.getTrackThemeID(this.m_engine.getCurrTrack());
            int n5 = -1;
            if (n == 0) {
                if (n2 == 0) {
                    n5 = 0;
                } else if (n2 == 1) {
                    n5 = 2;
                }
            } else if (n == 1) {
                if (n2 == 0) {
                    n5 = 1;
                } else if (n2 == 1) {
                    n5 = 0;
                }
            }
            this.m_opponentCarAnimID = this.m_engine.getOpponentCarAnimID(n5);
            n3 |= this.m_engine.getOpponentCarLoadMask(n5);
        }
        return n3;
    }

    private void updateAnims(int n) {
        if (this.m_crashCutscenePlaying) {
            this.updateCrashCutscene(n);
        } else if (this.m_playerCar.m_speedF != 0) {
            this.m_playerCarAnimPlayer.updateAnim(n);
        }
        if (this.m_playerIsBoosting) {
            this.m_boostAnimPlayer.updateAnim(n);
        }
        if (this.m_copLightsActivated) {
            this.m_copLightsPlayer.updateAnim(n);
        }
        if (this.m_playerImpactSparkAnimPlayer.isAnimating()) {
            this.m_playerImpactSparkAnimPlayer.updateAnim(n);
        }
        if (this.m_smokeLeftAnimPlayer.isAnimating()) {
            this.m_smokeLeftAnimPlayer.updateAnim(n);
        }
        if (this.m_smokeRightAnimPlayer.isAnimating()) {
            this.m_smokeRightAnimPlayer.updateAnim(n);
        }
        if (this.m_speedlinesAnimPlayer.isAnimating()) {
            this.m_speedlinesAnimPlayer.updateAnim(n);
        }
    }

    private void loadTrack(int n) {
        int n2;
        DataInputStream dataInputStream;
        InputStream inputStream;
        try {
            inputStream = this.m_engine.getResourceManager().loadBinaryFile(this.m_engine.getTrackDataResID(n));
            dataInputStream = new DataInputStream(inputStream);
            this.m_trackNumSections = dataInputStream.readShort();
            dataInputStream.close();
        }
        catch (IOException iOException) {
            return;
        }
        AppEngine.tryDefragMemory(20);
        this.m_trackSectionCurvature = new int[this.m_trackNumSections];
        this.m_trackSectionAbsStart = new int[this.m_trackNumSections];
        this.m_trackSectionAbsEnd = new int[this.m_trackNumSections];
        this.m_trackSectionLength = new int[this.m_trackNumSections];
        this.m_trackSectionLengthInvF = new int[this.m_trackNumSections];
        try {
            inputStream = this.m_engine.getResourceManager().loadBinaryFile(this.m_engine.getTrackDataResID(n));
            dataInputStream = new DataInputStream(inputStream);
            dataInputStream.skipBytes(2);
            for (int i = 0; i < this.m_trackNumSections; ++i) {
                this.m_trackSectionLength[i] = dataInputStream.readInt();
                this.m_trackSectionCurvature[i] = dataInputStream.readInt();
            }
            dataInputStream.close();
        }
        catch (IOException iOException) {
            return;
        }
        AppEngine.tryDefragMemory(20);
        for (n2 = 0; n2 < this.m_trackNumSections; ++n2) {
            int n3 = n2;
            this.m_trackSectionLength[n3] = this.m_trackSectionLength[n3] * 1;
            this.m_trackSectionAbsStart[n2] = n2 == 0 ? 0 : this.m_trackSectionAbsEnd[n2 - 1];
            this.m_trackSectionAbsEnd[n2] = this.m_trackSectionAbsStart[n2] + this.m_trackSectionLength[n2];
        }
        this.m_trackTotalDistance = this.m_trackSectionAbsEnd[this.m_trackNumSections - 1];
        for (n2 = 0; n2 < this.m_trackNumSections; ++n2) {
            this.m_trackSectionLengthInvF[n2] = AppEngine.Fdiv(65536, this.m_trackSectionLength[n2] << 16);
        }
    }

    private int calcBendFactor() {
        int n = 0;
        int n2 = 400;
        int n3 = this.m_viewPosF + 32768 >> 16;
        int n4 = this.m_viewSection;
        while (this.m_trackSectionAbsEnd[n4] - n3 < n2) {
            n2 -= this.m_trackSectionAbsEnd[n4] - n3;
            n += this.m_trackSectionCurvature[n4] * (this.m_trackSectionAbsEnd[n4] - n3);
            n3 += this.m_trackSectionAbsEnd[n4] - n3;
            if (++n4 < this.m_trackNumSections) continue;
            n4 -= this.m_trackNumSections;
            n3 -= this.m_trackTotalDistance;
        }
        return n += this.m_trackSectionCurvature[n4] * n2;
    }

    private void updateSteering(int n) {
        int n2;
        int n3 = this.m_playerSteeringMaxF;
        if (this.m_isSteeringLeft) {
            n2 = AppEngine.Fmul(this.m_playerSteeringIncF, n);
            this.m_playerSteeringAngleF -= n2;
            if (this.m_playerSteeringAngleF < -n3) {
                this.m_playerSteeringAngleF = -n3;
            }
        }
        if (this.m_isSteeringRight) {
            n2 = AppEngine.Fmul(this.m_playerSteeringIncF, n);
            this.m_playerSteeringAngleF += n2;
            if (this.m_playerSteeringAngleF > n3) {
                this.m_playerSteeringAngleF = n3;
            }
        }
        if (!this.m_isSteeringLeft && !this.m_isSteeringRight) {
            if (this.m_playerSteeringAngleF > 0) {
                this.m_playerSteeringAngleF -= AppEngine.Fmul(this.m_playerSteeringRecentreIncF, n);
                if (this.m_playerSteeringAngleF < 0) {
                    this.m_playerSteeringAngleF = 0;
                }
            } else if (this.m_playerSteeringAngleF < 0) {
                this.m_playerSteeringAngleF += AppEngine.Fmul(this.m_playerSteeringRecentreIncF, n);
                if (this.m_playerSteeringAngleF > 0) {
                    this.m_playerSteeringAngleF = 0;
                }
            }
        }
        if (this.m_playerCar.m_speedF > -524288 && this.m_playerCar.m_speedF < 524288) {
            this.m_playerSteeringAngleF = 0;
        }
    }

    public void setPlayerBoosting(boolean bl) {
        if (bl && this.m_playerBoostTimeF > 0) {
            this.m_playerIsBoosting = true;
            if (this.m_bonusNitroBoostTimer <= 0) {
                this.m_cameraShakeXAmplitudeF = m_cameraShakeXAmplitudeInitialF;
            }
            if (!this.m_playerCar.isMaximumGearAllowed()) {
                this.m_playerCar.setMaximumAllowedGear();
            }
        } else {
            this.m_playerIsBoosting = false;
            this.m_bonusNitroBoostTimer = 0;
            this.m_playerBoostTimeF = 196608;
        }
        this.m_playerCar.setBoosting(this.m_playerIsBoosting);
    }

    public void setCopLightsActivated(boolean bl) {
        if (bl) {
            this.m_copLightsActivated = true;
            this.m_copLightsPlayer.startAnim(3, true, true);
            this.m_copLightsPlayer.setAnimating(true);
        } else {
            this.m_copLightsActivated = false;
            this.m_copLightsPlayer.setAnimating(false);
        }
    }

    private void moveSkyLine(int n) {
        this.m_renderCityOffsetXF += n;
        int n2 = this.m_engine.m_resourceManager.getAnimFrameWidth(65, 0) << 16;
        while (this.m_renderCityOffsetXF < 0) {
            this.m_renderCityOffsetXF += n2;
        }
        while (this.m_renderCityOffsetXF >= n2) {
            this.m_renderCityOffsetXF -= n2;
        }
    }

    private void updateCityScroll(int n) {
        int n2 = AppEngine.Fmul(n << 16, 65);
        if (this.m_currBendFactor != 0 && this.m_playerCar.m_speedF > 0) {
            int n3 = 12;
            int n4 = AppEngine.Fmul(this.m_currBendFactor << n3, this.m_playerCar.getSpeedFactor());
            int n5 = AppEngine.Fmul(n4, n2);
            this.moveSkyLine(n5);
        }
    }

    private void setCarParameters() {
        AppEngine appEngine = this.m_engine;
        this.m_playerSteeringRecentreIncF = appEngine.getCarNowRacingParamSteeringRecentreInc();
        this.m_playerSteeringIncF = appEngine.getCarNowRacingParamSteeringInc();
        this.m_playerSteeringMaxF = appEngine.getCarNowRacingParamSteeringMax();
        this.m_playerTyresF = appEngine.getCarNowRacingParamTyres();
        this.m_playerTyresInvF = AppEngine.Fdiv(65536, this.m_playerTyresF);
        this.m_playerBoostMultF = appEngine.getCarNowRacingNitroMult();
        for (int i = 0; i < this.m_carsTrackOrder.length; ++i) {
            GameObject gameObject = this.m_carsTrackOrder[i];
            gameObject.setNumGears(appEngine.getCarNumGears());
            gameObject.setGearAccelData(appEngine.getCarNowRacingGearAccelData());
            gameObject.setGearMinSpeedData(appEngine.getCarNowRacingGearMinSpeedData());
            gameObject.setGearMaxSpeedData(appEngine.getCarNowRacingGearMaxSpeedData());
        }
    }

    private void startRaceIntro() {
        if (this.m_eventType != 2) {
            for (int i = 0; i < this.m_carsTrackOrder.length; ++i) {
                this.m_carsTrackOrder[i].m_isAccelerating = false;
            }
            this.m_raceIntroDone = false;
            this.m_raceIntroCount = 2;
            this.startNextIntroStage();
        } else {
            this.m_raceIntroCount = 0;
            this.m_raceIntroTimer = 500;
            this.m_raceIntroDone = false;
        }
        this.m_renderFullHUD = true;
        this.m_renderHUDTop = true;
    }

    private void updateRaceIntro(int n) {
        if (this.m_raceIntroCount == 2) {
            this.m_raceIntroOffsetY += this.m_raceIntroSpeed * n;
            if (this.m_raceIntroOffsetY > this.m_raceIntroOffsetMax) {
                this.m_raceIntroOffsetY = this.m_raceIntroOffsetMax;
            }
        }
        this.m_raceIntroTimer -= n;
        if (this.m_raceIntroTimer <= 0) {
            if (--this.m_raceIntroCount < 0) {
                this.endRaceIntro();
                this.startRace();
            } else {
                this.startNextIntroStage();
            }
        }
    }

    private void endRaceIntro() {
        this.m_raceIntroDone = true;
    }

    private void startNextIntroStage() {
        this.m_raceIntroTimer = 1500;
    }

    private void startRace() {
        this.m_takeOffSmokeTimer = 500;
        for (int i = 0; i < this.m_carsTrackOrder.length; ++i) {
            this.m_carsTrackOrder[i].m_isAccelerating = true;
        }
    }

    private void initCar() {
        int n;
        this.setCarParameters();
        this.m_playerCar.setBoostMultiplier(this.m_playerBoostMultF);
        this.m_boostGaugeLevel = !this.m_engine.isCarNowRacingCareer() || this.m_playerBoostMultF > 65536 ? 0x640000 : 0;
        this.m_playerSteeringAngleF = 0;
        this.m_playerCarLateralDriftF = 0;
        this.m_carAnimIDs = this.m_engine.getPlayerCarAnimIDs(this.m_engine.getPlayerCarIndex());
        int[] nArray = new int[5];
        this.m_boostAnimIDs = nArray;
        switch (this.m_engine.getPlayerCarIndex()) {
            case 0: {
                nArray[0] = 54;
                nArray[1] = 53;
                nArray[2] = 56;
                nArray[3] = 59;
                nArray[4] = 60;
                break;
            }
            case 2: {
                nArray[0] = 55;
                nArray[1] = 52;
                nArray[2] = 50;
                nArray[3] = 58;
                nArray[4] = 61;
                break;
            }
            default: {
                nArray[0] = 54;
                nArray[1] = 51;
                nArray[2] = 62;
                nArray[3] = 57;
                nArray[4] = 60;
            }
        }
        this.m_playerCarCollisionPushDiv = AppEngine.Fdiv(65536, AppEngine.Fmul(this.m_playerCar.getGearMaxSpeed(5), 32768));
        this.m_playerCarLowRevSpeedsF = new int[this.m_engine.getCarNumGears()];
        this.m_playerCarLowRevSpeedsF[0] = 0;
        this.m_playerCarLowRevSpeedsF[1] = 0;
        for (n = 2; n < this.m_playerCarLowRevSpeedsF.length; ++n) {
            this.m_playerCarLowRevSpeedsF[n] = this.m_playerCar.getGearMaxSpeed(n - 2);
        }
        this.m_playerCarRevDivsF = new int[this.m_engine.getCarNumGears()];
        for (n = 0; n < this.m_playerCarRevDivsF.length; ++n) {
            this.m_playerCarRevDivsF[n] = AppEngine.Fdiv(65536, this.m_playerCar.getGearMaxSpeed(n) - this.m_playerCarLowRevSpeedsF[n]);
        }
        int[] nArray2 = new int[5];
        this.m_carCollisionLengthsF = nArray2;
        int[] nArray3 = new int[5];
        this.m_carCollisionWidthsF = nArray3;
        nArray2[0] = 524288;
        nArray2[1] = 524288;
        nArray2[2] = 524288;
        nArray2[3] = 524288;
        nArray2[4] = 524288;
        nArray3[0] = 13606;
        nArray3[1] = 13606;
        nArray3[2] = 13606;
        nArray3[3] = 13606;
        nArray3[4] = 13606;
    }

    public void updateLateralPos(int n) {
        GameObject gameObject = this.m_playerCar;
        int n2 = 0;
        int n3 = AppEngine.Fdiv(this.m_playerSteeringAngleF, this.m_playerSteeringMaxF);
        n2 = AppEngine.Fmul(n3, 85196);
        n2 = AppEngine.Fmul(n2, n);
        int n4 = 0;
        int n5 = this.m_trackSectionCurvature[this.m_playerCar.m_currSection];
        n4 = AppEngine.Fmul(this.getLateralDrift(), n);
        if (n5 < 0 && this.m_isSteeringLeft || n5 > 0 && this.m_isSteeringRight) {
            n4 = AppEngine.Fmul(n4, this.m_playerTyresInvF);
            n4 = AppEngine.Fmul(n4, 58982);
        }
        int n6 = n5 == 0 ? 14745 : 49152;
        if (n4 < 0 && this.m_playerCarLateralDriftF > 0 || n4 > 0 && this.m_playerCarLateralDriftF < 0) {
            this.m_playerCarLateralDriftF = 0;
        }
        if (this.m_playerCarLateralDriftF < n4) {
            this.m_playerCarLateralDriftF += AppEngine.Fmul(n6, n);
            if (this.m_playerCarLateralDriftF > n4) {
                this.m_playerCarLateralDriftF = n4;
            }
        } else if (this.m_playerCarLateralDriftF > n4) {
            this.m_playerCarLateralDriftF -= AppEngine.Fmul(n6, n);
            if (this.m_playerCarLateralDriftF < n4) {
                this.m_playerCarLateralDriftF = n4;
            }
        }
        int n7 = n6 = gameObject.m_lateralPosF;
        n7 += n2;
        gameObject.m_lateralPosSpeedF = AppEngine.Fdiv((n7 += this.m_playerCarLateralDriftF) - n6, n);
        gameObject.m_lateralPosF = n7;
        this.moveSkyLine(gameObject.m_lateralPosSpeedF);
        if (this.m_playerCar.m_lateralPosF > 91750) {
            this.m_playerCar.m_lateralPosF = 91750;
        } else if (this.m_playerCar.m_lateralPosF < -91750) {
            this.m_playerCar.m_lateralPosF = -91750;
        }
        this.m_playerOffTrack = this.m_playerCar.m_lateralPosF < -65536 || this.m_playerCar.m_lateralPosF > 65536;
    }

    private void calcTrackBendOffsets() {
        int n = this.m_currBendFactor;
        for (int i = 0; i < 51; ++i) {
            this.m_trackBendOffsets[i] = n >> 4;
            n = (n >> 1) + (n >> 2) + (n >> 3);
        }
    }

    private void renderSkyline(Graphics graphics) {
        int n;
        ResourceManager resourceManager = this.m_engine.m_resourceManager;
        int n2 = resourceManager.getAnimFrameWidth(65, 0);
        int n3 = VIEWPORT_TOP + TRACK_VIEWPORT_HEIGHT - 51;
        for (n = -(this.m_renderCityOffsetXF >> 16) - this.m_cameraShakeX; n < 0; n += n2) {
        }
        while (n >= n2) {
            n -= n2;
        }
        int n4 = this.m_engine.getTrackThemeID(this.m_engine.getCurrTrack());
        resourceManager.drawAnimFrame(graphics, 65, n4, n, n3);
        if (n > 0) {
            resourceManager.drawAnimFrame(graphics, 65, n4, n - n2, n3);
        }
        graphics.setColor(this.m_skylineColour);
        n3 -= resourceManager.getAnimFrameHeight(65, 0);
        graphics.fillRect(VIEWPORT_LEFT, VIEWPORT_TOP + 14, VIEWPORT_WIDTH, n3 -= 14);
    }

    private void initPerspectiveRanges() {
        this.m_perspectiveRangesF = new int[51];
        for (int i = 51; i != 0; --i) {
            this.m_perspectiveRangesF[51 - i] = AppEngine.powerF(71970, i * 64 / 51) - 65536;
        }
    }

    private int getOpponentCarFrameFromDistance(int n) {
        if (n > 340) {
            return 0;
        }
        if (n > 189) {
            return 1;
        }
        if (n > 105) {
            return 2;
        }
        if (n > 58) {
            return 3;
        }
        if (n > 32) {
            return 4;
        }
        if (n > 18) {
            return 5;
        }
        if (n > 10) {
            return 6;
        }
        return 7;
    }

    private void changeSkyColour() {
        switch (this.m_engine.getTrackThemeID(this.m_engine.getCurrTrack())) {
            case 1: {
                this.m_skylineColour = 15705993;
                this.m_groundDarkColor = 11633507;
                this.m_groundLightColor = 9990486;
                break;
            }
            case 0: {
                this.m_skylineColour = 7183592;
                this.m_groundDarkColor = 6850074;
                this.m_groundLightColor = 6389271;
            }
        }
    }

    public void setCarAheadOfPlayer(GameObject gameObject) {
        int n = this.m_playerCar.m_trackPosF + (this.m_trackTotalDistance << 12);
        gameObject.m_trackPosF = n % (this.m_trackTotalDistance << 16);
        gameObject.m_currSection = this.getTrackSectionForTrackPos(gameObject.m_trackPosF);
        gameObject.m_nextSection = (gameObject.m_currSection + 1) % this.m_trackNumSections;
    }

    private void initOpponentCars() {
        int n = this.m_numOpponentRacerCars != 0 ? AppEngine.Fdiv(16384, this.m_numOpponentRacerCars << 16) : AppEngine.Fdiv(16384, 65536);
        this.m_opponentCars = new GameObject[this.m_numOpponentCars];
        for (int i = 0; i < this.m_numOpponentCars; ++i) {
            GameObject gameObject = new GameObject(this);
            gameObject.m_trackPosF = (this.m_trackTotalDistance << 16) + -1310720;
            gameObject.m_lateralPosTargetF = gameObject.m_lateralPosF = this.getCarStartingLatPosF(i + 1);
            gameObject.m_currSection = this.getTrackSectionForTrackPos(gameObject.m_trackPosF);
            gameObject.m_nextSection = (gameObject.m_currSection + 1) % this.m_trackNumSections;
            if (i < this.m_numCriminalCars) {
                gameObject.m_type = 3;
                gameObject.m_trackPosF = this.m_trackTotalDistance << 12;
                gameObject.m_currSection = this.getTrackSectionForTrackPos(gameObject.m_trackPosF);
                gameObject.m_nextSection = (gameObject.m_currSection + 1) % this.m_trackNumSections;
                this.m_chasedCar = gameObject;
            } else {
                gameObject.m_type = 2;
            }
            gameObject.m_ID = i;
            gameObject.m_speedF = 0;
            gameObject.m_difficultyMult = 49152 + AppEngine.Fmul(this.m_numOpponentCars - 1 - i << 16, n);
            gameObject.m_AITimeF = AppEngine.Fdiv(i << 16, this.m_numOpponentCars << 15) - (this.m_engine.rand(3, 12) << 16);
            if (gameObject.m_type == 3) {
                gameObject.m_mood = 1;
                gameObject.m_AILimitF >>= 0;
            } else {
                gameObject.m_mood = this.getRandomAIMood();
            }
            gameObject.m_catchupCodeMultCurrF = 86508;
            this.m_opponentCars[i] = gameObject;
        }
    }

    private int getTrackSectionForTrackPos(int n) {
        int n2 = 0;
        for (int i = 0; i < this.m_trackNumSections; ++i) {
            if ((n2 += this.m_trackSectionLength[i]) <= n) continue;
            return i;
        }
        return 0;
    }

    private final int getCarStartingLatPosF(int n) {
        int[] nArray = new int[]{16384, 49152, -16384, -49152};
        return nArray[n];
    }

    private void initPlayerCar() {
        GameObject gameObject = new GameObject(this);
        gameObject.m_lateralPosF = this.getCarStartingLatPosF(0);
        gameObject.m_trackPosF = (this.m_trackTotalDistance << 16) + -1310720;
        gameObject.m_currSection = this.getTrackSectionForTrackPos(gameObject.m_trackPosF);
        gameObject.m_nextSection = gameObject.m_currSection + 1;
        if (gameObject.m_nextSection >= this.m_trackNumSections) {
            gameObject.m_nextSection = 0;
        }
        gameObject.m_type = 1;
        gameObject.m_ID = 999;
        gameObject.m_speedF = 0;
        gameObject.m_speedMulF = 65536;
        gameObject.m_accelMulF = 65536;
        this.m_playerCarDriftingAngleCurrentF = 0;
        this.m_playerCar = gameObject;
    }

    private void initTrackOrderArray() {
        int n;
        int n2 = this.m_numOpponentCars + 1;
        this.m_carsTrackOrder = new GameObject[n2];
        this.m_carsRaceOrder = new GameObject[n2];
        this.m_carsTrackOrder[0] = this.m_playerCar;
        for (n = 1; n < n2; ++n) {
            this.m_carsTrackOrder[n] = this.m_opponentCars[n - 1];
        }
        for (n = 0; n < n2; ++n) {
            this.m_carsRaceOrder[n] = this.m_carsTrackOrder[n];
        }
        this.m_raceEndStandings = new GameObject[this.m_carsTrackOrder.length];
    }

    private void sortCarsTrackOrder() {
        boolean bl = false;
        int n = this.m_carsTrackOrder.length - 1;
        while (!bl) {
            bl = true;
            for (int i = 0; i < n; ++i) {
                if (this.m_carsTrackOrder[i + 1].m_trackPosF >= this.m_carsTrackOrder[i].m_trackPosF) continue;
                GameObject gameObject = this.m_carsTrackOrder[i];
                this.m_carsTrackOrder[i] = this.m_carsTrackOrder[i + 1];
                this.m_carsTrackOrder[i + 1] = gameObject;
                bl = false;
            }
            --n;
        }
    }

    private void sortCarsRaceOrder(boolean bl) {
        int n;
        boolean bl2 = false;
        int n2 = this.m_carsRaceOrder.length - 1;
        while (!bl2) {
            bl2 = true;
            for (n = 0; n < n2; ++n) {
                GameObject gameObject = this.m_carsRaceOrder[n];
                GameObject gameObject2 = this.m_carsRaceOrder[n + 1];
                int n3 = gameObject.m_trackPosF;
                int n4 = gameObject2.m_trackPosF;
                int n5 = gameObject2.m_numLapsCompleted;
                int n6 = gameObject.m_numLapsCompleted;
                if (n5 >= n6 && (n5 != n6 || n4 >= n3)) continue;
                int n7 = Math.abs(gameObject2.m_lateralPosF - gameObject.m_lateralPosF);
                int n8 = this.m_carCollisionWidthsF[this.getCarAnimIDIndex(this.m_trackSectionCurvature[gameObject.m_currSection])];
                int n9 = this.m_carCollisionWidthsF[this.getCarAnimIDIndex(this.m_trackSectionCurvature[gameObject2.m_currSection])];
                if (bl && n7 <= n8 + n9) {
                    gameObject.m_trackPosF = gameObject2.m_trackPosF - 1;
                    continue;
                }
                this.m_carsRaceOrder[n] = gameObject2;
                this.m_carsRaceOrder[n + 1] = gameObject;
                bl2 = false;
            }
            --n2;
        }
        for (n = 0; n < this.m_carsRaceOrder.length; ++n) {
            this.m_carsRaceOrder[n].setRacePos(this.m_carsRaceOrder.length - n - 1);
            if (this.m_carsRaceOrder[n].m_type == 1) {
                this.m_nextOpponentRaceOrder = null;
                if (this.m_carsRaceOrder[n].getRacePos() > 0) {
                    this.m_nextOpponentRaceOrder = this.m_carsRaceOrder[n + 1];
                }
                this.m_prevOpponentRaceOrder = null;
                if (n > 0) {
                    this.m_prevOpponentRaceOrder = this.m_carsRaceOrder[n - 1];
                }
            }
            this.m_carsRaceOrder[n].m_catchupCodeMultTargetF = 65536;
        }
        if (this.m_nextOpponentRaceOrder != null) {
            this.m_nextOpponentRaceOrder.m_catchupCodeMultTargetF = 55705;
        }
        if (this.m_prevOpponentRaceOrder != null) {
            this.m_prevOpponentRaceOrder.m_catchupCodeMultTargetF = 65536;
        }
    }

    private void initStaticObjects() {
    }

    private void sortStaticObjTrackOrder() {
    }

    private void adjustViewpoint() {
        this.m_viewPosF = this.m_playerCar.m_trackPosF - 327680;
        this.m_viewSection = this.m_playerCar.m_currSection;
        while (this.m_viewPosF < this.m_trackSectionAbsStart[this.m_viewSection]) {
            --this.m_viewSection;
            if (this.m_viewPosF >= 0) continue;
            this.m_viewPosF += this.m_trackTotalDistance << 16;
            this.m_viewSection += this.m_trackNumSections;
        }
    }

    private void renderTrack(Graphics graphics) {
        int n = this.m_trackTotalDistance << 16;
        int n2 = this.m_groundDarkColor;
        int n3 = this.m_groundLightColor;
        this.m_currCarRenderIndex = this.m_firstCarRenderIndex = this.getFurthestVisibileCarTrackOrder();
        int n4 = AppEngine.Fmul(this.m_playerCar.m_lateralPosF, TRACK1_WIDTHS[19] << 15) + 32768 >> 16;
        for (int i = 0; i < 51; ++i) {
            boolean bl;
            int n5 = VIEWPORT_CENTRE_X - n4 + this.m_cameraShakeX + this.m_trackBendOffsets[i];
            int n6 = this.m_perspectiveRangesF[i];
            int n7 = 0;
            if (i < 50) {
                n7 = this.m_perspectiveRangesF[i + 1];
            }
            int n8 = VIEWPORT_TOP + TRACK_VIEWPORT_HEIGHT - (51 - i);
            int n9 = this.m_viewPosF + n7;
            if (n9 > n) {
                n9 -= n;
            }
            boolean bl2 = bl = (n9 >> 22 & 1) != 1;
            if (655360 < n9 && n9 < 0x140000 && this.m_eventType != 2) {
                graphics.setColor(0xFFFFFF);
            } else if (bl) {
                graphics.setColor(0x606060);
            } else {
                graphics.setColor(0x505050);
            }
            int n10 = TRACK1_WIDTHS[i];
            int n11 = n5 - (n10 >> 1);
            graphics.fillRect(n11, n8, n10, 1);
            graphics.setColor(bl ? n3 : n2);
            if (n11 > VIEWPORT_LEFT) {
                graphics.fillRect(VIEWPORT_LEFT, n8, n11 - VIEWPORT_LEFT, 1);
            }
            if (n11 + n10 < VIEWPORT_LEFT + VIEWPORT_WIDTH) {
                graphics.fillRect(n11 + n10, n8, VIEWPORT_WIDTH - n11 + n10, 1);
            }
            this.renderCars(graphics, i, n8, n5, n7, n6);
        }
    }

    private void renderCars(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        GameObject[] gameObjectArray = this.m_carsTrackOrder;
        if (this.m_currCarRenderIndex < 0) {
            return;
        }
        int n6 = this.m_currCarRenderIndex;
        int n7 = this.calcDistance(this.m_viewPosF, gameObjectArray[this.m_currCarRenderIndex].m_trackPosF);
        if (n7 < 0x1900000) {
            while (n7 > n4 && n7 <= n5) {
                GameObject gameObject = gameObjectArray[this.m_currCarRenderIndex];
                int n8 = AppEngine.Fmul(gameObject.m_lateralPosF, TRACK1_WIDTHS[n] << 15) >> 16;
                gameObject.m_renderPosX = n3 + n8;
                gameObject.m_renderPosY = n2;
                gameObject.m_renderDistF = n7;
                if (--this.m_currCarRenderIndex < 0) {
                    this.m_currCarRenderIndex += gameObjectArray.length;
                }
                if (n6 == this.m_currCarRenderIndex) break;
                n7 = this.calcDistance(this.m_viewPosF, gameObjectArray[this.m_currCarRenderIndex].m_trackPosF);
            }
        }
    }

    private int getFurthestVisibileCarTrackOrder() {
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < this.m_carsTrackOrder.length; ++i) {
            int n3 = this.calcDistance(this.m_viewPosF, this.m_carsTrackOrder[i].m_trackPosF);
            if (n3 > this.m_perspectiveRangesF[0] || n3 < n) continue;
            n = n3;
            n2 = i;
        }
        return n2;
    }

    private int calcDistance(int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 0) {
            n3 += this.m_trackTotalDistance << 16;
        }
        return n3;
    }

    private void renderCar(Graphics graphics, GameObject gameObject) {
        ResourceManager resourceManager = this.m_engine.m_resourceManager;
        int n = this.getOpponentCarFrameFromDistance(gameObject.m_renderDistF + 32768 >> 16);
        int n2 = VIEWPORT_CENTRE_X + this.m_cameraShakeX - this.m_playerCar.m_renderPosX;
        int n3 = gameObject.m_renderPosX + n2;
        if (gameObject.m_type == 3) {
            resourceManager.drawAnimFrame(graphics, this.m_criminalCarAnimID, n, n3, gameObject.m_renderPosY);
            int n4 = resourceManager.getAnimFrameHeight(this.m_criminalCarAnimID, n);
            resourceManager.drawAnimFrame(graphics, 64, 0, n3, gameObject.m_renderPosY - n4);
        } else {
            resourceManager.drawAnimFrame(graphics, this.m_opponentCarAnimID, n, n3, gameObject.m_renderPosY);
            if (this.m_raceIntroDone && this.m_engine.m_rmsCarMarkersEnabled && (gameObject == this.m_nextOpponentRaceOrder || this.m_playerCar.m_numLapsCompleted != gameObject.m_numLapsCompleted)) {
                int n5 = resourceManager.getAnimFrameHeight(this.m_opponentCarAnimID, n);
                resourceManager.drawAnimFrame(graphics, 64, 0, n3, gameObject.m_renderPosY - n5);
                this.m_engine.intToSDKString(gameObject.getRacePos() + 1, false, this.m_tempStringBuffer);
                this.m_engine.drawString(graphics, this.m_tempStringBuffer, n3, gameObject.m_renderPosY - n5 - 8, 3);
            }
        }
    }

    private void renderHealthIndicator(Graphics graphics, GameObject gameObject) {
        int n;
        int n2 = this.m_engine.getHalfWidth() - 70;
        int n3 = 20 - gameObject.getCriminalCarHealth() * 20 / 4;
        for (n = 0; n < n3; ++n) {
            graphics.setColor(0xFF0000);
            graphics.fillRect(n2 + n * 7, 20, 6, 6);
        }
        for (n = n3; n < 20; ++n) {
            graphics.setColor(0x444444);
            graphics.fillRect(n2 + n * 7, 20, 6, 6);
        }
    }

    private void renderPlayerCar(Graphics graphics, int n) {
        int n2;
        ResourceManager resourceManager = this.m_engine.m_resourceManager;
        int n3 = VIEWPORT_CENTRE_X + this.m_cameraShakeX;
        int n4 = this.getPlayerCarAnimID();
        if (this.m_playerImpactSparkAnimPlayer.isAnimating() && this.m_playerBumpedFront) {
            this.m_playerImpactSparkAnimPlayer.drawAnim(graphics, this.m_playerImpactSparkX, this.m_playerImpactSparkY, false);
        }
        if (!this.m_crashCutscenePlaying) {
            this.m_playerCarAnimPlayer.startAnim(this.m_carAnimIDs[n4], false, true);
        }
        this.m_playerCarAnimPlayer.drawAnim(graphics, n3, n, false);
        if (this.m_copLightsActivated && !this.m_crashCutscenePlaying) {
            n2 = resourceManager.getAnimFrameFirePointX(this.m_playerCarAnimPlayer.getAnimID(), this.m_playerCarAnimPlayer.getCurrAnimFrame(), 0);
            int n5 = resourceManager.getAnimFrameFirePointY(this.m_playerCarAnimPlayer.getAnimID(), this.m_playerCarAnimPlayer.getCurrAnimFrame(), 0);
            this.m_copLightsPlayer.drawAnim(graphics, n3 + n2, n + n5, false);
        }
        if (!this.m_crashCutscenePlaying) {
            if (!this.m_playerCar.m_finishedRace && (this.m_playerCar.m_isBraking || this.m_collisionBrakingTimeout > 0) && this.m_playerBrakesAnimIDs[n4] != -1 && this.m_playerBrakesAnimIDs != null) {
                resourceManager.drawAnimFrame(graphics, this.m_playerBrakesAnimIDs[n4], this.m_playerCarAnimPlayer.getCurrAnimFrame(), n3, n);
            }
            if (this.m_playerIsBoosting) {
                this.m_boostAnimPlayer.startAnim(this.m_boostAnimIDs[n4], false, true);
                this.m_boostAnimPlayer.drawAnim(graphics, n3, n, false);
            }
        }
        if (this.m_smokingLeftWheel) {
            n2 = EFFECTS_SMOKE_LEFT[n4];
            if (n2 > -1) {
                this.m_smokeLeftAnimPlayer.startAnim(n2, false, true);
                this.m_smokeLeftAnimPlayer.drawAnim(graphics, n3, n, false);
            } else {
                this.m_smokeLeftAnimPlayer.setAnimating(false);
            }
        }
        if (this.m_smokingRightWheel) {
            n2 = EFFECTS_SMOKE_RIGHT[n4];
            if (n2 > -1) {
                this.m_smokeRightAnimPlayer.startAnim(n2, false, true);
                this.m_smokeRightAnimPlayer.drawAnim(graphics, n3, n, false);
            } else {
                this.m_smokeRightAnimPlayer.setAnimating(false);
            }
        }
        if (this.m_playerImpactSparkAnimPlayer.isAnimating() && !this.m_playerBumpedFront) {
            this.m_playerImpactSparkAnimPlayer.drawAnim(graphics, this.m_playerCar.m_renderPosX, this.m_playerImpactSparkY, false);
        }
    }

    private void renderDrawList(Graphics graphics) {
        int n = 0;
        int n2 = this.m_firstCarRenderIndex;
        int n3 = 0;
        int n4 = graphics.getClipX();
        int n5 = graphics.getClipY();
        int n6 = graphics.getClipWidth();
        int n7 = graphics.getClipHeight();
        graphics.setClip(VIEWPORT_LEFT, VIEWPORT_TOP, VIEWPORT_WIDTH, TRACK_VIEWPORT_HEIGHT);
        if (this.m_firstCarRenderIndex >= 0 && (n = this.m_firstCarRenderIndex - this.m_currCarRenderIndex) <= 0) {
            n += this.m_carsTrackOrder.length;
        }
        while (n > 0) {
            GameObject gameObject = null;
            gameObject = this.m_carsTrackOrder[n2];
            --n;
            if (--n2 < 0) {
                n2 += this.m_carsTrackOrder.length;
            }
            if (n3 != gameObject.m_renderClipY) {
                n3 = gameObject.m_renderClipY;
                graphics.setClip(VIEWPORT_LEFT, VIEWPORT_TOP, VIEWPORT_WIDTH, TRACK_VIEWPORT_HEIGHT - n3);
            }
            if (gameObject.m_type == 1) {
                this.renderPlayerCar(graphics, gameObject.m_renderPosY);
                continue;
            }
            this.renderCar(graphics, gameObject);
        }
        graphics.setClip(n4, n5, n6, n7);
    }

    void updateBoost(int n) {
        if (!this.m_playerIsBoosting) {
            if (!this.m_engine.isCarNowRacingCareer() || this.m_playerBoostMultF > 65536) {
                this.m_boostGaugeLevel += AppEngine.Fmul(36044, n);
                if (this.m_boostGaugeLevel >= 0x640000) {
                    this.m_boostGaugeLevel = 0x640000;
                }
            }
            this.m_timeSinceLastBoost += n;
            this.m_cameraShakeXAmplitudeF -= n << 3;
            if (this.m_cameraShakeXAmplitudeF < 0) {
                this.m_cameraShakeXAmplitudeF = 0;
            }
        } else if (this.m_playerIsBoosting && this.m_bonusNitroBoostTimer <= 0) {
            this.m_playerBoostTimeF -= n;
            if (this.m_playerBoostTimeF <= 0) {
                this.setPlayerBoosting(false);
                this.m_driftBoost = false;
            }
            if (!this.m_driftBoost) {
                this.m_boostGaugeLevel -= AppEngine.Fmul(1091829, n);
                if (this.m_boostGaugeLevel < 0) {
                    this.m_boostGaugeLevel = 0;
                    this.setPlayerBoosting(false);
                }
            }
            this.m_cameraShakeXAmplitudeF += n << 2;
            if (this.m_cameraShakeXAmplitudeF > this.m_cameraShakeXAmplitudeMaxF) {
                this.m_cameraShakeXAmplitudeF = this.m_cameraShakeXAmplitudeMaxF;
            }
        }
        this.m_cameraShakeX = this.m_engine.rand(-(this.m_cameraShakeXAmplitudeF >> 16), this.m_cameraShakeXAmplitudeF >> 16);
    }

    private void renderHUD(Graphics graphics) {
        ResourceManager resourceManager = this.m_engine.m_resourceManager;
        if (this.m_renderFullHUD) {
            resourceManager.setColor(graphics, 42);
            graphics.fillRect(0, HUD_TOP, this.m_engine.getWidth(), 30);
        }
        this.renderLineMiniMap(graphics);
        this.renderHUDSpeed(graphics);
        this.renderHUDBoost(graphics);
        if (this.m_eventType == 2) {
            if (this.m_copLightsActivated) {
                this.renderHealthIndicator(graphics, this.m_chasedCar);
            }
            if (this.m_raceComplete) {
                if (this.m_numDeadCriminalCars >= 4) {
                    this.renderBustedMessage(graphics);
                } else {
                    this.renderEscapedMessage(graphics);
                }
            }
        }
        if (this.m_renderHUDTop) {
            this.renderHUDTopBar(graphics);
        }
        if (this.m_renderFullHUD) {
            this.m_engine.renderSoftKeyButton(graphics, 1, 73, 0, this.m_engine.getHeight(), 20, false);
        }
        this.m_renderFullHUD = false;
    }

    private void renderHUDBoost(Graphics graphics) {
        int n;
        int n2 = HUD_BOOST_PARTS * this.m_boostGaugeLevel / 0x640000;
        int n3 = VIEWPORT_WIDTH - HUD_BOOST_PART_WIDTH - HUD_BOOST_PART_OUTER_MARGIN;
        int n4 = VIEWPORT_HEIGHT - HUD_BOOST_PART_HEIGHT - HUD_BOOST_PART_OUTER_MARGIN;
        for (n = n2; n < HUD_BOOST_PARTS; ++n) {
            graphics.setColor(0x444444);
            graphics.fillRect(n3, n4, HUD_BOOST_PART_WIDTH, HUD_BOOST_PART_HEIGHT);
            n3 -= HUD_BOOST_PART_WIDTH + HUD_BOOST_PART_INNER_MARGIN;
        }
        for (n = 0; n < n2; ++n) {
            graphics.setColor(0xFF8844);
            graphics.fillRect(n3, n4, HUD_BOOST_PART_WIDTH, HUD_BOOST_PART_HEIGHT);
            n3 -= HUD_BOOST_PART_WIDTH + HUD_BOOST_PART_INNER_MARGIN;
        }
    }

    private void renderHUDSpeed(Graphics graphics) {
        this.m_engine.intToSDKString(this.m_engine.getSpeedInUnits(this.m_playerCar.m_speedF), false, this.m_tempStringBuffer);
        int n = SDKUtils.getStringSize(this.m_tempStringBuffer);
        this.m_engine.drawString(graphics, this.m_tempStringBuffer, HUD_SPEED_POSITION_X, HUD_SPEED_POSITION_Y, 6);
        this.m_engine.drawString(graphics, this.m_engine.m_rmsSpeedunitsMPH ? 52 : 51, HUD_SPEED_POSITION_X + n + 5, HUD_SPEED_POSITION_Y, 6);
    }

    private void renderRaceIntroHUD(Graphics graphics) {
        ResourceManager resourceManager = this.m_engine.m_resourceManager;
        int n = 2 - this.m_raceIntroCount;
        if (this.m_raceIntroDone) {
            n = 3;
        }
        resourceManager.drawAnimFrame(graphics, this.m_raceIntroAnim, n, VIEWPORT_CENTRE_X, this.m_raceIntroOffsetY >> 16);
    }

    private void renderHUDTopBar(Graphics graphics) {
        ResourceManager resourceManager = this.m_engine.m_resourceManager;
        AppEngine appEngine = this.m_engine;
        resourceManager.setColor(graphics, 47);
        graphics.setClip(0, 0, VIEWPORT_WIDTH, VIEWPORT_HEIGHT);
        graphics.fillRect(0, 0, this.m_engine.getWidth(), 14);
        if (this.m_eventType == 0) {
            appEngine.drawString(graphics, this.m_lapString, 3, 0, 20);
        } else if (this.m_eventType == 2) {
            appEngine.drawString(graphics, this.m_timeString, 90, 0, 20);
            appEngine.drawString(graphics, this.m_ticketsString, 3, 0, 20);
        }
        this.m_renderHUDTop = false;
    }

    private int getCarAnimIDIndex(int n) {
        return 4;
    }

    private int getLateralDrift() {
        int n = this.m_trackSectionCurvature[this.m_playerCar.m_currSection];
        if (n == 0) {
            this.m_playerCarDriftDiffTargetF = 0;
            return 0;
        }
        int n2 = this.m_playerCar.m_speedF;
        n2 = AppEngine.Fmul(n2, 436);
        int n3 = AppEngine.Fmul(CORNER_VALUES[Math.abs(n)], n2);
        return n > 0 ? -n3 : n3;
    }

    private void renderLineMiniMap(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        AppEngine appEngine = this.m_engine;
        ResourceManager resourceManager = this.m_engine.m_resourceManager;
        int n5 = HUD_TOP;
        int n6 = HUD_MAP_LINE_RIGHT_POSITION_X - 5;
        resourceManager.setColor(graphics, 47);
        graphics.fillRect(0, n5, VIEWPORT_WIDTH + 90, appEngine.getHeight() - n5 - 12);
        resourceManager.setColor(graphics, 3);
        graphics.drawLine(0, n5, VIEWPORT_WIDTH, n5);
        int n7 = n6 / this.m_raceMaxLaps;
        resourceManager.setColor(graphics, 9);
        for (n4 = 0; n4 < this.m_raceMaxLaps; ++n4) {
            n3 = n4 * n7;
            graphics.drawLine(5 + n3, HUD_MAP_LINE_POSITION_Y, 5 + n3, HUD_MAP_LINE_POSITION_Y + 2);
        }
        resourceManager.setColor(graphics, 9);
        graphics.drawLine(5, HUD_MAP_LINE_POSITION_Y, HUD_MAP_LINE_RIGHT_POSITION_X, HUD_MAP_LINE_POSITION_Y);
        graphics.drawLine(5, HUD_MAP_LINE_POSITION_Y - 2, 5, HUD_MAP_LINE_POSITION_Y + 2);
        graphics.drawLine(HUD_MAP_LINE_RIGHT_POSITION_X, HUD_MAP_LINE_POSITION_Y - 2, HUD_MAP_LINE_RIGHT_POSITION_X, HUD_MAP_LINE_POSITION_Y + 2);
        n4 = -1;
        n3 = this.m_trackTotalDistance;
        int n8 = n3 * this.m_raceMaxLaps;
        for (n2 = 0; n2 < this.m_carsTrackOrder.length; ++n2) {
            int n9;
            GameObject gameObject = this.m_carsTrackOrder[n2];
            n = gameObject.m_type == 3 ? (gameObject.m_trackPosF >> 16) + this.m_playerCar.m_numLapsCompleted * n3 : (gameObject.m_trackPosF >> 16) + gameObject.m_numLapsCompleted * n3;
            if (n < 0) {
                n = 0;
            }
            if (this.m_eventType == 2) {
                n %= n8;
            }
            if ((n9 = 5 + n * n6 / n8) > HUD_MAP_LINE_RIGHT_POSITION_X) {
                n9 = HUD_MAP_LINE_RIGHT_POSITION_X;
            }
            if (gameObject == this.m_playerCar) {
                n4 = n9;
                continue;
            }
            if (gameObject.m_type == 3) {
                resourceManager.setColor(graphics, 8);
            } else {
                resourceManager.setColor(graphics, 6);
            }
            graphics.fillRect(n9, HUD_MAP_LINE_POSITION_Y - 2, 1, 2);
        }
        resourceManager.setColor(graphics, 16);
        n2 = 3;
        int n10 = 3;
        graphics.drawLine(n4, HUD_MAP_LINE_POSITION_Y - n2 - 1, n4, HUD_MAP_LINE_POSITION_Y - 1);
        for (n = 0; n < n10; ++n) {
            graphics.drawLine(n4 - n, HUD_MAP_LINE_POSITION_Y - n2 - 1 - n, n4 + n, HUD_MAP_LINE_POSITION_Y - n2 - 1 - n);
        }
    }

    private void initDisplayDimensionsAndOffsets() {
        ResourceManager resourceManager = this.m_engine.m_resourceManager;
        int n = this.m_engine.getWidth();
        int n2 = this.m_engine.getHeight();
        VIEWPORT_LEFT = 0;
        VIEWPORT_TOP = 0;
        VIEWPORT_WIDTH = n;
        VIEWPORT_HEIGHT = n2;
        VIEWPORT_CENTRE_X = VIEWPORT_LEFT + (VIEWPORT_WIDTH >> 1);
        VIEWPORT_CENTRE_Y = VIEWPORT_TOP + (VIEWPORT_HEIGHT >> 1);
        HUD_BOTTOM = n2;
        HUD_TOP = n2 - 30;
        HUD_MAP_LINE_RIGHT_POSITION_X = this.m_engine.getWidth() - 65 - 5;
        HUD_MAP_LINE_POSITION_Y = HUD_TOP + 10;
        TRACK_VIEWPORT_HEIGHT = HUD_TOP;
        HUD_SPEED_POSITION_X = HUD_MAP_LINE_RIGHT_POSITION_X + 5;
        HUD_SPEED_POSITION_Y = HUD_MAP_LINE_POSITION_Y - 2;
        HUD_LAP_TIMES_TITLE_POS_Y = 19 + resourceManager.getAnimFrameFirePointY(49, 0, 0);
        HUD_LAP_TIMES_POSITION_POS_Y = 19 + resourceManager.getAnimFrameFirePointY(49, 0, 1);
        HUD_LAP_TIMES_LAP_POS_Y = 19 + resourceManager.getAnimFrameFirePointY(49, 0, 2);
        HUD_BUSTED_MSG_POS_Y = 29 + resourceManager.getAnimFrameFirePointY(47, 0, 0);
    }

    private void renderBustedMessage(Graphics graphics) {
        ResourceManager resourceManager = this.m_engine.m_resourceManager;
        resourceManager.drawAnimFrame(graphics, 47, 0, VIEWPORT_CENTRE_X, 29);
        this.m_engine.drawString(graphics, 67, VIEWPORT_CENTRE_X, HUD_BUSTED_MSG_POS_Y, 17);
    }

    private void renderEscapedMessage(Graphics graphics) {
        ResourceManager resourceManager = this.m_engine.m_resourceManager;
        resourceManager.drawAnimFrame(graphics, 47, 0, VIEWPORT_CENTRE_X, 29);
        this.m_engine.drawString(graphics, 68, VIEWPORT_CENTRE_X, HUD_BUSTED_MSG_POS_Y, 17);
    }

    private void renderLapTimes(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        ResourceManager resourceManager = this.m_engine.m_resourceManager;
        resourceManager.drawAnimFrame(graphics, 49, 0, VIEWPORT_CENTRE_X, 19);
        if (this.m_playerCar.m_numLapsCompleted + 1 == this.m_raceMaxLaps) {
            appEngine.drawString(graphics, 71, VIEWPORT_CENTRE_X, HUD_LAP_TIMES_TITLE_POS_Y, 17);
        } else if (this.m_playerCar.m_numLapsCompleted == this.m_raceMaxLaps) {
            appEngine.drawString(graphics, 47, VIEWPORT_CENTRE_X, HUD_LAP_TIMES_TITLE_POS_Y, 17);
        } else {
            this.m_eolTitleString = appEngine.getString(87).concat(this.m_playerCar.m_numLapsCompleted + 1);
            appEngine.drawString(graphics, this.m_eolTitleString, VIEWPORT_CENTRE_X, HUD_LAP_TIMES_TITLE_POS_Y, 17);
        }
        appEngine.drawString(graphics, this.m_eolPosString, VIEWPORT_CENTRE_X, HUD_LAP_TIMES_POSITION_POS_Y, 17);
        appEngine.drawString(graphics, this.m_eolLapTimeString, VIEWPORT_CENTRE_X, HUD_LAP_TIMES_LAP_POS_Y, 17);
    }

    private void renderCriminalTakeOutMessage(Graphics graphics, boolean bl) {
        AppEngine appEngine = this.m_engine;
        ResourceManager resourceManager = this.m_engine.m_resourceManager;
        resourceManager.drawAnimFrame(graphics, 49, 0, VIEWPORT_CENTRE_X, 19);
        if (bl) {
            appEngine.drawString(graphics, 67, VIEWPORT_CENTRE_X, HUD_LAP_TIMES_TITLE_POS_Y, 17);
        } else {
            appEngine.drawString(graphics, 68, VIEWPORT_CENTRE_X, HUD_LAP_TIMES_TITLE_POS_Y, 17);
        }
    }

    private void showLastLapTime() {
        this.m_lastLapDisplayTimer = 0;
        this.m_lastLapTimeShowing = true;
    }

    private void hideLastLapTime() {
        this.m_lastLapTimeShowing = false;
    }

    private void showBustedMessage() {
        this.m_bustedDisplayTimer = 0;
        this.m_bustedShowing = true;
    }

    private void hideBustedMessage() {
        this.m_bustedShowing = false;
    }

    private void showBestLapTime() {
        this.m_bestLapDisplayTimer = 0;
        this.m_bestLapTimeShowing = true;
    }

    private void hideBestLapTime() {
        this.m_bestLapTimeShowing = false;
    }

    private void updateOnScreenDisplays(int n) {
        if (this.m_lastLapTimeShowing) {
            this.m_lastLapDisplayTimer += n;
            if (this.m_lastLapDisplayTimer >= 131072) {
                this.hideLastLapTime();
            }
        }
        if (this.m_bestLapTimeShowing) {
            this.m_bestLapDisplayTimer += n;
            if (this.m_bestLapDisplayTimer >= 131072) {
                this.hideBestLapTime();
            }
        }
        if (this.m_bustedShowing) {
            this.m_bustedDisplayTimer += n;
            if (this.m_bustedDisplayTimer >= 131072) {
                this.hideBustedMessage();
            }
        }
    }

    private void endRace() {
        this.m_raceComplete = true;
        this.m_raceCompleteTimer = 0;
        this.m_engine.setSoftKeys(0, 0);
        this.musicID = -1;
    }

    private void updateCollisions(int n) {
        for (int i = 0; i < this.m_carsTrackOrder.length - 1; ++i) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7 = (i + 1) % this.m_carsTrackOrder.length;
            if (this.m_carsTrackOrder[i].isDead() || this.m_carsTrackOrder[n7].isDead()) continue;
            GameObject gameObject = this.m_carsTrackOrder[i];
            GameObject gameObject2 = this.m_carsTrackOrder[n7];
            int n8 = gameObject2.m_trackPosF - gameObject.m_trackPosF;
            if (n8 < 0) {
                n8 += this.m_trackTotalDistance << 16;
            }
            if (n8 > (n6 = this.m_carCollisionLengthsF[gameObject == this.m_playerCar ? this.getPlayerCarAnimID() : 2]) + (n5 = this.m_carCollisionLengthsF[gameObject2 == this.m_playerCar ? this.getPlayerCarAnimID() : 2])) continue;
            int n9 = Math.abs(gameObject2.m_lateralPosF - gameObject.m_lateralPosF);
            if (n9 > (n4 = this.m_carCollisionWidthsF[gameObject == this.m_playerCar ? this.getPlayerCarAnimID() : 2]) + (n3 = this.m_carCollisionWidthsF[gameObject2 == this.m_playerCar ? this.getPlayerCarAnimID() : 2])) continue;
            gameObject.m_speedF = AppEngine.Fmul(gameObject2.m_speedF, 49152);
            if (gameObject.m_type == 1) {
                this.m_playerCar.setCurrentGear(this.getGearForSpeed(gameObject.m_speedF));
                this.m_collisionBrakingTimeout = 300;
            }
            if (gameObject.m_type != 1 && gameObject2.m_type != 1) continue;
            int n10 = 100;
            GameObject gameObject3 = null;
            GameObject gameObject4 = null;
            if (gameObject.m_type == 1) {
                gameObject3 = gameObject;
            } else if (gameObject.m_type == 3) {
                gameObject4 = gameObject;
            }
            if (gameObject2.m_type == 1) {
                gameObject3 = gameObject2;
            } else if (gameObject2.m_type == 3) {
                gameObject4 = gameObject2;
            }
            if (gameObject3 != null && gameObject4 != null && gameObject3.m_speedF >= 0x320000 && this.m_engine.rand(0, 99) < n10) {
                n2 = gameObject4.registerCriminalCarHit() ? 1 : 0;
                if (n2 != 0) {
                    ++this.m_numDeadCriminalCars;
                    this.updateTicketsString(this.m_numDeadCriminalCars);
                    this.showBustedMessage();
                    this.setCopLightsActivated(false);
                    this.m_boostGaugeLevel += 0x320000;
                    if (this.m_boostGaugeLevel >= 0x640000) {
                        this.m_boostGaugeLevel = 0x640000;
                    }
                }
                if (this.m_numDeadCriminalCars == 4 && this.m_eventType == 2) {
                    this.endRace();
                }
            }
            n2 = AppEngine.Fmul(gameObject.m_speedF, this.m_playerCarCollisionPushDiv);
            if ((n2 = AppEngine.Fmul(n2, this.m_playerSteeringMaxF)) > this.m_playerSteeringMaxF) {
                n2 = this.m_playerSteeringMaxF;
            }
            this.m_playerSteeringAngleF = gameObject.m_lateralPosF > gameObject2.m_lateralPosF ? n2 : -n2;
            if (!this.m_playerImpactSparkAnimPlayer.isAnimating()) {
                this.m_playerImpactSparkAnimPlayer.startAnim(63, true, false);
                this.m_playerImpactSparkX = gameObject2.m_renderPosX + gameObject.m_renderPosX >> 1;
                if (gameObject.m_type == 1) {
                    this.m_playerBumpedFront = true;
                    this.m_playerImpactSparkY = gameObject2.m_renderPosY + -12;
                } else {
                    this.m_playerBumpedFront = false;
                    this.m_playerImpactSparkY = gameObject.m_renderPosY + -9;
                }
            }
            this.m_engine.vibrate(100);
        }
    }

    private void updateOpponentCarsLateralPos(int n) {
        for (int i = 0; i < this.m_numOpponentCars; ++i) {
            GameObject gameObject = this.m_opponentCars[i];
            if (gameObject.m_lateralPosF < gameObject.m_lateralPosTargetF) {
                gameObject.m_lateralPosSpeedF = gameObject.m_lateralPosSpeedF < 0 ? 0 : (gameObject.m_lateralPosSpeedF += AppEngine.Fmul(gameObject.m_lateralPosAccelF, n));
                gameObject.m_lateralPosF += AppEngine.Fmul(gameObject.m_lateralPosSpeedF, n);
            } else if (gameObject.m_lateralPosF > gameObject.m_lateralPosTargetF) {
                gameObject.m_lateralPosSpeedF = gameObject.m_lateralPosSpeedF > 0 ? 0 : (gameObject.m_lateralPosSpeedF -= AppEngine.Fmul(gameObject.m_lateralPosAccelF, n));
                gameObject.m_lateralPosF += AppEngine.Fmul(gameObject.m_lateralPosSpeedF, n);
            }
            if (gameObject.isDead()) continue;
            if (gameObject.m_lateralPosF < -58982) {
                gameObject.m_lateralPosF = -58982;
                continue;
            }
            if (gameObject.m_lateralPosF <= 58982) continue;
            gameObject.m_lateralPosF = 58982;
        }
    }

    private int getRandomAIMood() {
        int n = this.m_engine.rand(0, 99);
        if (n < 10) {
            return 2;
        }
        if (n < 20) {
            return 1;
        }
        return 0;
    }

    private int getOvertakingPos(GameObject gameObject, GameObject gameObject2) {
        int n = 0;
        if (gameObject2.m_lateralPosF < gameObject.m_lateralPosF) {
            n = gameObject2.m_lateralPosF + 32768;
            if (n > 58982) {
                n = gameObject2.m_lateralPosF - 32768;
            }
        } else {
            n = gameObject2.m_lateralPosF - 32768;
            if (n < -58982) {
                n = gameObject2.m_lateralPosF + 32768;
            }
        }
        return n;
    }

    private int getAvoidingPos(GameObject gameObject, GameObject gameObject2) {
        int n = 0;
        if (gameObject2.m_lateralPosF < gameObject.m_lateralPosF) {
            n = gameObject.m_lateralPosF + 32768;
            if (n > 58982) {
                n = 58982;
            }
        } else {
            n = gameObject.m_lateralPosF - 32768;
            if (n < -58982) {
                n = -58982;
            }
        }
        return n;
    }

    private void updateOpponentCarsSteering(int n) {
        for (int i = 0; i < this.m_numOpponentCars + 1; ++i) {
            int n2;
            int n3;
            GameObject gameObject = this.m_carsTrackOrder[i];
            if (gameObject.m_type != 2 && gameObject.m_type != 3) continue;
            if (gameObject.m_type == 3) {
                if (gameObject.isDead() && (gameObject.m_lateralPosF >= 91750 || gameObject.m_lateralPosF <= -91750)) {
                    gameObject.m_isBraking = true;
                    return;
                }
                n3 = 60;
                int n4 = gameObject.m_trackPosF - this.m_playerCar.m_trackPosF;
                gameObject.m_isBraking = n4 > 0x640000 && gameObject.m_speedF > n3 << 16;
            }
            gameObject.m_AITimeF += n;
            if (gameObject.m_AITimeF <= gameObject.m_AILimitF) continue;
            if (gameObject.isDead()) {
                return;
            }
            gameObject.m_AITimeF = 0;
            n3 = i + 1;
            if (n3 >= this.m_numOpponentCars + 1) {
                n3 = 0;
            }
            GameObject gameObject2 = this.m_carsTrackOrder[n3];
            int n5 = i - 1;
            if (n5 < 0) {
                n5 = this.m_numOpponentCars;
            }
            GameObject gameObject3 = this.m_carsTrackOrder[n5];
            int n6 = gameObject2.m_trackPosF - gameObject.m_trackPosF;
            if (n6 > 0x430000 && n6 < 0xC80000) {
                n2 = gameObject2.m_lateralPosF - gameObject.m_lateralPosF;
                if (n2 < 0) {
                    n2 = -n2;
                }
                if (n2 < 32768) {
                    gameObject.m_lateralPosTargetF = this.getOvertakingPos(gameObject, gameObject2);
                    return;
                }
            }
            n2 = gameObject.m_trackPosF - gameObject3.m_trackPosF;
            if (gameObject.m_type == 3) {
                gameObject.m_lateralPosTargetF = this.m_playerCar.m_lateralPosF;
                return;
            }
            if (n2 > 0x430000 && n2 < 0xC80000) {
                if (gameObject.m_mood == 1) {
                    gameObject.m_lateralPosTargetF = gameObject3.m_lateralPosF;
                    return;
                }
                if (gameObject.m_mood == 2) {
                    gameObject.m_lateralPosTargetF = this.getAvoidingPos(gameObject, gameObject3);
                    return;
                }
            }
            gameObject.m_lateralPosTargetF = this.getAIRacingLineLateralPos(gameObject);
            if (gameObject.m_lateralPosTargetF == 0) {
                int n7 = gameObject.m_ID + gameObject.m_currSection & 3;
                switch (n7) {
                    case 0: {
                        gameObject.m_lateralPosTargetF = 39322;
                        break;
                    }
                    case 1: {
                        gameObject.m_lateralPosTargetF = 19661;
                        break;
                    }
                    case 2: {
                        gameObject.m_lateralPosTargetF = -19661;
                        break;
                    }
                    default: {
                        gameObject.m_lateralPosTargetF = -39322;
                    }
                }
            }
            gameObject.m_lateralPosTargetF += this.m_engine.rand(0, 13107) - 6554;
        }
    }

    private int getAIRacingLineLateralPos(GameObject gameObject) {
        int n = this.m_trackSectionCurvature[gameObject.m_currSection];
        if (n == 0 && !gameObject.isMaximumGearAllowed()) {
            int n2 = gameObject.m_currSection + 1;
            if (n2 >= this.m_trackNumSections) {
                n2 -= this.m_trackNumSections;
            }
            n = this.m_trackSectionCurvature[n2];
        }
        return this.getRacingLineLateralPosForCurvature(n);
    }

    private int getRacingLineLateralPosForCurvature(int n) {
        int n2 = n << 14;
        return n2;
    }

    private int getPlayerCarAnimID() {
        if (this.m_playerCar.m_finishedRace) {
            return 4;
        }
        int n = 2;
        if (this.m_isSteeringLeft) {
            n = 1;
        } else if (this.m_isSteeringRight) {
            n = 3;
        }
        int n2 = Math.abs(this.m_playerCarDriftingAngleCurrentF);
        if (this.m_playerCarDriftingAngleCurrentF != 0) {
            int n3 = this.m_playerCarDriftingAngleCurrentF < 0 ? 4 : 0;
            int n4 = n3 - n;
            int n5 = Math.abs(n4);
            int n6 = n4 > 0 ? 1 : -1;
            int n7 = this.m_playerCarDriftingAngleTargetF;
            int n8 = Math.abs(n7);
            if (n7 == 0) {
                n7 = n6 == 1 ? 51472 : -51472;
            }
            if (n5 == 1) {
                n = n3;
            } else if (n5 == 2) {
                n = n2 < n8 >> 1 ? (n += n6) : n3;
            } else if (n5 == 3) {
                int n9 = n8 / 3;
                n = n2 < n9 ? (n += n6) : (n2 < n9 << 1 ? (n += 2 * n6) : n3);
            } else if (n5 == 4) {
                int n10 = n8 >> 2;
                n = n2 < n10 ? (n += n6) : (n2 < n10 << 1 ? (n += 2 * n6) : (n2 < 3 * n10 ? (n += 3 * n6) : n3));
            }
        }
        return n;
    }

    private byte getGearForSpeed(int n) {
        int n2 = 0;
        for (int n3 = 0; n3 < 6; n3 = (int)((byte)(n3 + 1))) {
            if (n > this.m_playerCar.getGearMaxSpeed(n3)) continue;
            n2 = n3;
            break;
        }
        return (byte)n2;
    }

    private void updateSmoke(int n) {
        int n2 = this.m_trackSectionCurvature[this.m_playerCar.m_currSection];
        if (this.m_crashCutscenePlaying || this.m_playerCar.m_speedF == 0) {
            this.m_smokingLeftWheel = false;
            this.m_smokingRightWheel = false;
            return;
        }
        if (this.m_takeOffSmokeTimer > 0) {
            this.m_smokingLeftWheel = true;
            this.m_smokingRightWheel = true;
            return;
        }
        if (this.m_playerOffTrack) {
            if (this.m_playerCar.m_lateralPosF < 0) {
                this.m_smokingLeftWheel = true;
                this.m_smokingRightWheel = false;
            } else {
                this.m_smokingLeftWheel = false;
                this.m_smokingRightWheel = true;
            }
            return;
        }
        if (n2 == 0) {
            this.m_smokingLeftWheel = false;
            this.m_smokingRightWheel = false;
            return;
        }
        int n3 = this.m_playerCarLateralDriftF + this.m_playerUpdateSteeringF;
        if (n2 != 0) {
            boolean bl;
            this.m_smokingLeftWheel = bl = !(this.m_playerCar.m_speedF <= 0 || n3 < 0 && n2 > 0 || n3 > 0 && n2 < 0);
            this.m_smokingRightWheel = bl;
        }
    }

    private void renderRacePosIndicatorRear(Graphics graphics) {
        ResourceManager resourceManager = this.m_engine.m_resourceManager;
        int n = HUD_TOP;
        if (this.m_prevOpponentRaceOrder == null) {
            return;
        }
        int n2 = this.m_playerCar.m_trackPosF - this.m_prevOpponentRaceOrder.m_trackPosF >> 16;
        if (n2 < 0) {
            n2 += this.m_trackTotalDistance;
        }
        if (n2 <= 120) {
            if (this.m_playerCar.m_trackPosF - this.m_prevOpponentRaceOrder.m_trackPosF < 327680) {
                return;
            }
            int n3 = this.m_prevOpponentRaceOrder.m_lateralPosF - this.m_playerCar.m_lateralPosF;
            int n4 = AppEngine.Fmul(TRACK1_WIDTHS[50] << 15, n3) + 32768 >> 16;
            int n5 = (VIEWPORT_WIDTH >> 1) + n4;
            if (n5 < VIEWPORT_LEFT) {
                n5 = VIEWPORT_LEFT;
            } else if (n5 >= VIEWPORT_LEFT + VIEWPORT_WIDTH) {
                n5 = VIEWPORT_LEFT + VIEWPORT_WIDTH - 1;
            }
            resourceManager.drawAnimFrame(graphics, 64, 0, n5, n);
            if (this.m_prevOpponentRaceOrder.m_type != 3) {
                this.m_engine.intToSDKString(this.m_prevOpponentRaceOrder.getRacePos() + 1, false, this.m_tempStringBuffer);
                this.m_engine.drawString(graphics, this.m_tempStringBuffer, n5, n - 8, 3);
            }
        }
    }

    static {
        HUD_BOOST_PARTS = 10;
        HUD_BOOST_PART_WIDTH = 8;
        HUD_BOOST_PART_HEIGHT = 5;
        HUD_BOOST_PART_INNER_MARGIN = 2;
        HUD_BOOST_PART_OUTER_MARGIN = 3;
        TRACK1_WIDTHS = new int[]{46, 50, 52, 56, 58, 62, 64, 68, 70, 74, 76, 80, 82, 86, 88, 92, 94, 98, 100, 104, 106, 110, 112, 116, 118, 122, 124, 128, 130, 134, 136, 140, 142, 144, 148, 150, 154, 156, 160, 162, 166, 168, 172, 174, 178, 180, 184, 186, 190, 192, 196, 198, 202, 204, 208, 210, 214, 216, 220, 222, 226, 228, 232, 234};
        m_cameraShakeXAmplitudeInitialF = 131072;
        EFFECTS_SMOKE_LEFT = new short[]{40, 38, 67, 41, -1};
        EFFECTS_SMOKE_RIGHT = new short[]{-1, 39, 68, 42, 43};
        BRAKES_STD = new short[]{-1, 0, 2, 1, -1};
        CORNER_VALUES = new int[]{0, 32768, 45875, 58982};
    }
}

