/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Constants;
import com.ea.game.Debug;
import com.ea.game.GameImpl;
import com.ea.game.Utils;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKImage;
import com.ea.sdk.SDKInputStream;
import com.ea.sdk.SDKUtils;

public class XSprite
implements Constants {
    int _index;
    static int _op;
    public static boolean drawScaled;
    public static boolean lastDrawScaled;
    public static boolean saved;
    public int grayPercent = 0;
    static int[] _rect;
    static SDKGraphics _g;
    static final int[] _midp2_transform;
    int gameMode;
    int _modules;
    short[] _modules_x;
    short[] _modules_y;
    short[] _modules_w;
    short[] _modules_h;
    int _frames;
    short[] _frames_fm_offset;
    int _fmodules;
    short[] _fmodules_ox;
    short[] _fmodules_oy;
    short[] _fmodules_id;
    byte[] _fmodules_flags;
    int _animations;
    short[] _animations_af_offset;
    int _aframes;
    short[] _aframes_id;
    byte[] _aframes_time;
    public int _crt_pal;
    SDKImage[] _images;
    SDKImage[] _images_scaled;
    int _mmapping = -1;
    int _number_mmappings = 0;
    short[][] _mmappings;

    static void SetGraphics(SDKGraphics sDKGraphics) {
        _g = sDKGraphics;
    }

    static SDKGraphics GetGraphics() {
        return _g;
    }

    XSprite(int n) {
        this._index = n;
    }

    public static void setTempDrawScaled(boolean bl) {
        if (GameImpl.gameMode == 1) {
            bl = false;
        }
        if (saved) {
            XSprite.restoreDrawScaled();
        }
        lastDrawScaled = drawScaled;
        drawScaled = bl;
        saved = true;
    }

    public static void setDrawScaled(boolean bl) {
        if (GameImpl.gameMode == 1) {
            bl = false;
        }
        drawScaled = bl;
    }

    public static void restoreDrawScaled() {
        if (GameImpl.gameMode == 1) {
            drawScaled = false;
        } else {
            saved = false;
            drawScaled = lastDrawScaled;
        }
    }

    private static int CombineFlags(int n, int n2) {
        if ((n & 4) == 0) {
            return n ^ n2;
        }
        if ((n2 & 1) != 0) {
            n ^= 2;
        }
        if ((n2 & 2) != 0) {
            n ^= 1;
        }
        if ((n2 & 4) != 0) {
            n ^= 7;
        }
        return n;
    }

    void DrawAnimFrame(int n, int n2, int n3, int n4, int n5) {
        int n6 = this._animations_af_offset[n] + n2;
        this.DrawFrame(this._aframes_id[n6], n3, n4, XSprite.CombineFlags(0, n5));
    }

    void DrawFrame(int n, int n2, int n3, int n4) {
        if (!GameImpl.displayHints && n == 96 && this._index == 2) {
            return;
        }
        try {
            int n5 = this._frames_fm_offset[n + 1] - this._frames_fm_offset[n];
            for (int i = 0; i < n5; ++i) {
                this.DrawFrameModule(n, i, n2, n3, n4);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Debug.CatchException("DrawFrame sprite=" + this._index + ", frame=" + n, exception);
        }
    }

    private void DrawFrameModule(int n, int n2, int n3, int n4, int n5) {
        int n6 = this._frames_fm_offset[n] + n2;
        int n7 = this._fmodules_ox[n6];
        int n8 = this._fmodules_oy[n6];
        short s = this._fmodules_id[n6];
        int n9 = this._fmodules_flags[n6] & 0xFF;
        short s2 = this._modules_w[s];
        short s3 = this._modules_h[s];
        if ((n5 & 7) != 0) {
            short s4 = 0;
            short s5 = 0;
            if ((n9 & 4) == 0) {
                s4 = s2;
                s5 = s3;
            } else {
                s4 = s3;
                s5 = s2;
            }
            if ((n5 & 1) != 0) {
                n7 = -n7 - s4;
            }
            if ((n5 & 2) != 0) {
                n8 = -n8 - s5;
            }
            if ((n5 & 4) != 0) {
                int n10 = n7;
                n7 = -n8 - s5;
                n8 = n10;
            }
            n9 = XSprite.CombineFlags(n9, n5);
        }
        this.DrawModule(s, n3 + n7, n4 + n8, n9);
    }

    void DrawModule(int n, int n2, int n3, int n4) {
        if (this._mmapping >= 0) {
            n = this._mmappings[this._mmapping][n];
        }
        n4 &= 7;
        if (_op == 0) {
            SDKImage sDKImage = drawScaled ? this._images_scaled[this._crt_pal] : this._images[this._crt_pal];
            _g.drawRegion(sDKImage, this._modules_x[n], this._modules_y[n], this._modules_w[n], this._modules_h[n], _midp2_transform[n4], n2, n3, 20);
        } else if (_op == 1) {
            short s = this._modules_w[n];
            short s2 = this._modules_h[n];
            if ((n4 & 4) != 0) {
                s = this._modules_h[n];
                s2 = this._modules_w[n];
            }
            Utils.RectUnion(_rect, _rect, Utils.CreateRect(Utils.rect, n2, n3, s, s2));
        }
    }

    public int FilterColor(int n) {
        int n2 = n;
        int n3 = (n2 & 0xFF0000) >> 16;
        int n4 = (n2 & 0xFF00) >> 8;
        int n5 = n2 & 0xFF;
        n2 &= 0xFF000000;
        int n6 = (n3 * ((this.grayPercent & 0xFF0000) >> 16) + n4 * ((this.grayPercent & 0xFF00) >> 8) + n5 * (this.grayPercent & 0xFF)) / 100;
        if (n6 > 255) {
            n6 = 255;
        }
        return n2 |= n6 << 16 | n6 << 8 | n6;
    }

    public void LoadData(SDKInputStream sDKInputStream) {
        try {
            int n;
            int n2;
            sDKInputStream.read();
            this._modules = sDKInputStream.readShort() & 0xFFFF;
            this._modules_x = Utils.ReadShortArray(sDKInputStream, this._modules, null, 0);
            this._modules_y = Utils.ReadShortArray(sDKInputStream, this._modules, null, 0);
            this._modules_w = Utils.ReadShortArray(sDKInputStream, this._modules, null, 0);
            this._modules_h = Utils.ReadShortArray(sDKInputStream, this._modules, null, 0);
            this._frames = sDKInputStream.readShort() & 0xFFFF;
            this._frames_fm_offset = new short[this._frames + 1];
            this._frames_fm_offset[0] = 0;
            int n3 = 0;
            for (n2 = 1; n2 <= this._frames; ++n2) {
                this._frames_fm_offset[n2] = (short)(n3 += sDKInputStream.read() & 0xFF);
            }
            this._fmodules = sDKInputStream.readShort() & 0xFFFF;
            this._fmodules_ox = Utils.ReadShortArray(sDKInputStream, this._fmodules, null, 0);
            this._fmodules_oy = Utils.ReadShortArray(sDKInputStream, this._fmodules, null, 0);
            this._fmodules_id = this._modules > 255 ? Utils.ReadShortArray(sDKInputStream, this._fmodules, null, 0) : Utils.ReadByteArrayToShortArray(sDKInputStream, this._fmodules, null, 0);
            this._fmodules_flags = Utils.ReadByteArray(sDKInputStream, this._fmodules, null, 0);
            this._animations = sDKInputStream.readShort() & 0xFFFF;
            this._animations_af_offset = new short[this._animations + 1];
            this._animations_af_offset[0] = 0;
            n2 = 0;
            for (n = 1; n <= this._animations; ++n) {
                this._animations_af_offset[n] = (short)(n2 += sDKInputStream.read() & 0xFF);
            }
            this._aframes = sDKInputStream.readShort() & 0xFFFF;
            sDKInputStream.skip(this._aframes);
            sDKInputStream.skip(this._aframes);
            this._aframes_id = Utils.ReadShortArray(sDKInputStream, this._aframes, null, 0);
            this._aframes_time = Utils.ReadByteArray(sDKInputStream, this._aframes, null, 0);
            sDKInputStream.skip(this._aframes);
            this._number_mmappings = (short)(sDKInputStream.readShort() & 0xFFFF);
            if (this._number_mmappings > 0) {
                this._mmappings = new short[this._number_mmappings][];
                for (n = 0; n < this._number_mmappings; ++n) {
                    this._mmappings[n] = this._modules > 255 ? Utils.ReadShortArray(sDKInputStream, this._modules, null, 0) : Utils.ReadByteArrayToShortArray(sDKInputStream, this._modules, null, 0);
                }
            }
        }
        catch (Exception exception) {
            Debug.CatchException("XSprite::LoadData", exception);
        }
    }

    int[] RectFrame(int n, int n2, int n3, int n4) {
        Utils.CreateRect(_rect, 0x40000000, 0x40000000, -1073741824, -1073741824);
        int n5 = _op;
        _op = 1;
        this.DrawFrame(n, n2, n3, n4);
        _op = n5;
        return _rect;
    }

    int[] GetHotSpot(int n, int n2, int n3, int n4) {
        int n5 = this._frames_fm_offset[n] + n4;
        XSprite._rect[0] = this._fmodules_ox[n5] + n2;
        XSprite._rect[1] = this._fmodules_oy[n5] + n3;
        return _rect;
    }

    int[] GetRectFromHotSpots(int n, int n2, int n3, int n4, int n5) {
        int n6 = this._frames_fm_offset[n] + n4;
        XSprite._rect[0] = this._fmodules_ox[n6] + n2;
        XSprite._rect[1] = this._fmodules_oy[n6] + n3;
        n6 = this._frames_fm_offset[n] + n5;
        XSprite._rect[2] = this._fmodules_ox[n6] + n2;
        XSprite._rect[3] = this._fmodules_oy[n6] + n3;
        return _rect;
    }

    int GetAnimLength(int n) {
        return this._animations_af_offset[n + 1] - this._animations_af_offset[n];
    }

    int GetAnimFrameTime(int n, int n2) {
        return this._aframes_time[this._animations_af_offset[n] + n2] & 0xFF;
    }

    int GetAnimFrameId(int n, int n2) {
        return this._aframes_id[this._animations_af_offset[n] + n2];
    }

    int GetCurFrameInAnim(int n, int n2) {
        return this._aframes_id[this._animations_af_offset[n] + n2];
    }

    public void SetCurrentPalette(int n) {
        this._crt_pal = n;
    }

    public void scaleSniperImages(boolean bl, boolean bl2) {
        int n = this._images.length;
        this._images_scaled = new SDKImage[n];
        System.arraycopy(this._images, 0, this._images_scaled, 0, n);
    }

    public void scaleImages(boolean bl, boolean bl2) {
        int n;
        int n2 = this._images.length;
        this._images_scaled = new SDKImage[n2];
        int n3 = this._images[0].getWidth();
        int n4 = this._images[0].getHeight();
        int[] nArray = new int[n3 * n4];
        for (n = 0; n < n2; ++n) {
            this._images[n].getRGB(nArray, 0, n3, 0, 0, n3, n4);
            int n5 = 0;
            int n6 = n3 * n4;
            int n7 = 0;
            for (int i = 0; i < n6; i += n3 << 1) {
                int n8 = i + n3;
                for (n7 = i; n7 < n8; n7 += 2) {
                    nArray[n5++] = bl2 ? this.FilterColor(nArray[n7]) : nArray[n7];
                }
            }
            this._images_scaled[n] = SDKUtils.createRGBImage(nArray, (n3 >> 1) + (n3 & 1), (n4 >> 1) + (n4 & 1), 256);
            if (bl) continue;
            this._images[n] = null;
        }
        if (!bl) {
            this._images = null;
            if (this._index == 0) {
                for (n = 0; n < this._modules; ++n) {
                    this._modules_x[n] = (short)((this._modules_x[n] >> 1) + (this._modules_x[n] & 1));
                    this._modules_y[n] = (short)((this._modules_y[n] >> 1) + (this._modules_y[n] & 1));
                    this._modules_w[n] = (short)(this._modules_w[n] >> 1);
                    this._modules_h[n] = (short)(this._modules_h[n] >> 1);
                }
            } else {
                for (n = 0; n < this._modules; ++n) {
                    if (this._modules_x[n] % 2 == 1) {
                        int n9 = n;
                        this._modules_x[n9] = (short)(this._modules_x[n9] + 1);
                    }
                    if (this._modules_y[n] % 2 == 1) {
                        int n10 = n;
                        this._modules_y[n10] = (short)(this._modules_y[n10] + 1);
                    }
                    if (this._modules_w[n] % 2 == 1) {
                        int n11 = n;
                        this._modules_w[n11] = (short)(this._modules_w[n11] + 1);
                    }
                    if (this._modules_h[n] % 2 == 1) {
                        int n12 = n;
                        this._modules_h[n12] = (short)(this._modules_h[n12] + 1);
                    }
                    this._modules_x[n] = (short)(this._modules_x[n] >> 1);
                    this._modules_y[n] = (short)(this._modules_y[n] >> 1);
                    this._modules_w[n] = (short)((this._modules_w[n] >> 1) + (this._modules_w[n] & 1));
                    this._modules_h[n] = (short)((this._modules_h[n] >> 1) + (this._modules_h[n] & 1));
                }
            }
            n = 0;
            while (n < this._fmodules_ox.length) {
                int n13 = n;
                this._fmodules_ox[n13] = (short)(this._fmodules_ox[n13] >> 1);
                int n14 = n++;
                this._fmodules_oy[n14] = (short)(this._fmodules_oy[n14] >> 1);
            }
        }
    }

    public void clean() {
    }

    static {
        drawScaled = false;
        saved = false;
        _rect = new int[4];
        _midp2_transform = new int[]{0, 2, 1, 3, 5, 7, 4, 6};
    }
}

