/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Constants;
import com.ea.game.GameImpl;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKInputStream;
import java.io.IOException;

public class Utils
implements Constants {
    static int[] rect = new int[4];
    public static long _randomSeed = 0L;
    static int[] _qsort_w_array = null;
    static int[] _qsort_other_array = null;
    public static int soundVolume = 50;
    public static int[] iClip = new int[4];

    public static boolean isFlagSet(int n, int n2) {
        return (n & n2) != 0;
    }

    public static int clearFlag(int n, int n2) {
        return n &= ~n2;
    }

    public static int setFlag(int n, int n2) {
        return n |= n2;
    }

    public static byte[] ReadByteArray(SDKInputStream sDKInputStream, int n, byte[] byArray, int n2) throws IOException {
        if (n > 0) {
            if (byArray == null) {
                byArray = new byte[n];
            }
            for (int i = 0; i < n; ++i) {
                byArray[i] = (byte)sDKInputStream.read();
            }
        }
        return byArray;
    }

    public static short[] ReadShortArray(SDKInputStream sDKInputStream, int n, short[] sArray, int n2) throws IOException {
        if (n > 0) {
            if (sArray == null) {
                sArray = new short[n];
            }
            for (int i = n2; i < n; ++i) {
                sArray[i] = sDKInputStream.readShort();
            }
        }
        return sArray;
    }

    public static int[] ReadIntArray(SDKInputStream sDKInputStream, int n, int[] nArray, int n2) throws IOException {
        if (n > 0) {
            if (nArray == null) {
                nArray = new int[n];
            }
            for (int i = 0; i < n; ++i) {
                nArray[i] = sDKInputStream.read() & 0xFF | (sDKInputStream.read() & 0xFF) << 8 | (sDKInputStream.read() & 0xFF) << 16 | (sDKInputStream.read() & 0xFF) << 24;
            }
        }
        return nArray;
    }

    public static short[] ReadByteArrayToShortArray(SDKInputStream sDKInputStream, int n, short[] sArray, int n2) throws IOException {
        if (n > 0) {
            if (sArray == null) {
                sArray = new short[n];
            }
            for (int i = 0; i < n; ++i) {
                sArray[i] = (short)(sDKInputStream.read() & 0xFF);
            }
        }
        return sArray;
    }

    public static void MemSet(int[] nArray, int n) {
        int n2 = nArray.length;
        if (n2 > 0) {
            nArray[0] = n;
        }
        for (int i = 1; i < n2; i += i) {
            System.arraycopy(nArray, 0, nArray, i, n2 - i < i ? n2 - i : i);
        }
    }

    public static void RectCopy(int[] nArray, int[] nArray2) {
        for (int i = 0; i < 4; ++i) {
            nArray[i] = nArray2[i];
        }
    }

    public static int[] CreateRect(int[] nArray, int n, int n2, int n3, int n4) {
        nArray[0] = n;
        nArray[1] = n2;
        nArray[2] = n + n3;
        nArray[3] = n2 + n4;
        return nArray;
    }

    public static int[] RectAssign(int[] nArray, int n, int n2, int n3, int n4) {
        nArray[0] = n;
        nArray[1] = n2;
        nArray[2] = n3;
        nArray[3] = n4;
        return nArray;
    }

    public static void RectUnion(int[] nArray, int[] nArray2, int[] nArray3) {
        nArray[0] = Math.min(nArray2[0], nArray3[0]);
        nArray[1] = Math.min(nArray2[1], nArray3[1]);
        nArray[2] = Math.max(nArray2[2], nArray3[2]);
        nArray[3] = Math.max(nArray2[3], nArray3[3]);
    }

    public static boolean PointInRect(int[] nArray, int n, int n2) {
        return n >= nArray[0] && n2 >= nArray[1] && n <= nArray[2] && n2 <= nArray[3];
    }

    public static void RectExpand(int[] nArray, int[] nArray2, int n) {
        nArray[0] = nArray2[0] - n;
        nArray[1] = nArray2[1] - n;
        nArray[2] = nArray2[2] + n;
        nArray[3] = nArray2[3] + n;
    }

    public static boolean RectIntersect(int[] nArray, int[] nArray2) {
        int n = Math.max(nArray[0], nArray2[0]);
        int n2 = Math.max(nArray[1], nArray2[1]);
        int n3 = Math.min(nArray[2], nArray2[2]);
        int n4 = Math.min(nArray[3], nArray2[3]);
        if (n > n3) {
            return false;
        }
        return n2 <= n4;
    }

    public static boolean IsRectInRect(int[] nArray, int[] nArray2) {
        return nArray[0] >= nArray2[0] && nArray[2] <= nArray2[2] && nArray[1] >= nArray2[1] && nArray[3] <= nArray2[3];
    }

    public static void ResetRect(int[] nArray) {
        nArray[0] = 1024;
        nArray[1] = 1024;
        nArray[2] = -1024;
        nArray[3] = -1024;
    }

    public static final int randomInt() {
        _randomSeed = _randomSeed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        return (int)(_randomSeed >>> 16);
    }

    public static final int random(int n) {
        if (n != 0) {
            int n2 = Utils.randomInt();
            return Math.abs(n2) % n;
        }
        return 0;
    }

    public static int random(int n, int n2) {
        int n3 = Utils.randomInt();
        return n + Math.abs(n3) % (n2 - n + 1);
    }

    public static void setRandomSeed(long l) {
        _randomSeed = (l ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
    }

    public static void QuickSort(int[] nArray, int[] nArray2, int n, int n2) {
        _qsort_w_array = nArray;
        _qsort_other_array = nArray2;
        Utils.QuickSort(n, n2);
    }

    public static void QuickSort(int n, int n2) {
        if (n2 <= n) {
            return;
        }
        int n3 = n;
        int n4 = _qsort_w_array[n3];
        Utils.QuickSort_SwitchValues(n3, n2);
        n3 = n;
        for (int i = n; i < n2; ++i) {
            if (_qsort_w_array[i] > n4) continue;
            Utils.QuickSort_SwitchValues(n3, i);
            ++n3;
        }
        Utils.QuickSort_SwitchValues(n3, n2);
        Utils.QuickSort(n, n3 - 1);
        Utils.QuickSort(n3 + 1, n2);
    }

    public static void QuickSort_SwitchValues(int n, int n2) {
        int n3 = _qsort_w_array[n];
        Utils._qsort_w_array[n] = _qsort_w_array[n2];
        Utils._qsort_w_array[n2] = n3;
        if (_qsort_other_array != null) {
            n3 = _qsort_other_array[n];
            Utils._qsort_other_array[n] = _qsort_other_array[n2];
            Utils._qsort_other_array[n2] = n3;
        }
    }

    public static boolean isColliding(int n, int n2, byte[] byArray, int n3, int n4, byte[] byArray2) {
        byte by = byArray[0];
        byte by2 = byArray2[0];
        if (by == 0 || by2 == 0) {
            return false;
        }
        if (by == by2) {
            if (by == 2) {
                return Utils.collBoxBox(n + byArray[1], n2 + byArray[2], byArray[3] & 0xFF, byArray[3] & 0xFF, n3 + byArray2[1], n4 + byArray2[2], byArray2[3] & 0xFF, byArray2[3] & 0xFF);
            }
            return Utils.collCircles(n + byArray[1], n2 + byArray[2], (byArray[3] & 0xFF) >> 1, n3 + byArray2[1], n4 + byArray2[2], (byArray2[3] & 0xFF) >> 1);
        }
        if (by == 2) {
            return Utils.collBoxCircle(n + byArray[1], n2 + byArray[2], byArray[3] & 0xFF, byArray[4] & 0xFF, n3 + byArray2[1], n4 + byArray2[2], (byArray2[3] & 0xFF) >> 1);
        }
        return Utils.collBoxCircle(n3 + byArray2[1], n4 + byArray2[2], byArray2[3] & 0xFF, byArray2[4] & 0xFF, n + byArray[1], n2 + byArray[2], (byArray[3] & 0xFF) >> 1);
    }

    static boolean collBoxCircle(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = 0;
        int n9 = n + n3;
        int n10 = n5 - n;
        if (n5 > n9) {
            n8 += (n10 -= n3) * n10;
        } else if (n5 < n) {
            n8 += n10 * n10;
        }
        n9 = n2 + n4;
        n10 = n6 - n2;
        if (n6 > n9) {
            n8 += (n10 -= n4) * n10;
        } else if (n6 < n2) {
            n8 += n10 * n10;
        }
        return n8 <= n7 * n7;
    }

    static boolean collCircles(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n - n4;
        int n8 = n2 - n5;
        int n9 = n3 + n6;
        return n7 * n7 + n8 * n8 <= n9 * n9;
    }

    static boolean collBoxBox(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (n2 + n4 < n6) {
            return false;
        }
        if (n2 > n6 + n8) {
            return false;
        }
        if (n + n3 < n5) {
            return false;
        }
        return n <= n5 + n7;
    }

    static boolean pointInCircle(int n, int n2, int n3, int n4, int n5) {
        int n6 = n - n3;
        int n7 = n2 - n4;
        return n6 * n6 + n7 * n7 <= n5 * n5;
    }

    public static boolean collPointBox(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n < n3) {
            return false;
        }
        if (n > n3 + n5) {
            return false;
        }
        if (n2 < n4) {
            return false;
        }
        return n2 <= n4 + n6;
    }

    public static int Distance(int n, int n2) {
        int n3;
        int n4;
        if (n < 0) {
            n = -n;
        }
        if (n2 < 0) {
            n2 = -n2;
        }
        if (n < n2) {
            n4 = n;
            n3 = n2;
        } else {
            n4 = n2;
            n3 = n;
        }
        return (n3 << 8) + (n3 << 3) - (n3 << 4) - (n3 << 1) + (n4 << 7) - (n4 << 5) + (n4 << 3) - (n4 << 1) >> 8;
    }

    public static int determinant(int n, int n2, int n3, int n4, int n5, int n6) {
        return (n - n5) * (n4 - n6) - (n3 - n5) * (n2 - n6);
    }

    public static boolean pointsSameSemiplane(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return Utils.determinant(n, n2, n3, n4, n5, n6) * Utils.determinant(n, n2, n3, n4, n7, n8) >= 0;
    }

    static void soundVolumeUp() {
        if (soundVolume <= 90) {
            soundVolume += 10;
            try {
                GameImpl.soundManager.setSoundVolume(soundVolume);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static void soundVolumeDown() {
        if (soundVolume >= 10) {
            soundVolume -= 10;
            try {
                GameImpl.soundManager.setSoundVolume(soundVolume);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static void getClip(SDKGraphics sDKGraphics) {
        Utils.iClip[0] = sDKGraphics.getClipX();
        Utils.iClip[1] = sDKGraphics.getClipY();
        Utils.iClip[2] = sDKGraphics.getClipWidth();
        Utils.iClip[3] = sDKGraphics.getClipHeight();
    }

    static void setClip(SDKGraphics sDKGraphics, int[] nArray) {
        sDKGraphics.setClip(nArray[0], nArray[1], nArray[2], nArray[3]);
    }
}

