/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.AlliedCharacter;
import com.ea.game.AnimatedEntity;
import com.ea.game.Animator;
import com.ea.game.Camera;
import com.ea.game.Constants;
import com.ea.game.Debug;
import com.ea.game.Enemy;
import com.ea.game.Entity;
import com.ea.game.GameImpl;
import com.ea.game.IStringConstants;
import com.ea.game.Machinegun;
import com.ea.game.Map;
import com.ea.game.PathFinder;
import com.ea.game.SpriteConstants;
import com.ea.game.Target;
import com.ea.game.Utils;
import com.ea.game.XSprite;
import com.ea.sdk.SDKCanvas;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKInputStream;
import com.ea.sdk.SDKUtils;

public class Character
extends Entity
implements Constants,
SpriteConstants,
Constants.CharacterConstants,
IStringConstants {
    public int speed;
    public int orientation;
    public int life;
    public int maxLife;
    public int regenerationAmount;
    public int regenerationInterval;
    public int timer;
    public int lastShotTime;
    public int damageTimer;
    public int damageOrientation;
    public int lifeTimer;
    public int comboTimer;
    public Animator baseAnimator = new Animator();
    public Animator turretAnimator = new Animator();
    public int rifleModuleMapping;
    public int gunModuleMapping;
    public int stealthModuleMapping;
    public int shModuleMapping;
    public Target target;
    public Enemy silentKillEnemyTarget;
    boolean isCovered;
    boolean isBurst;
    boolean isBlasted;
    boolean isDyingAfterJump;
    boolean canStealthKill;
    boolean canComboStealthKill;
    boolean hasDoneComboStealthKill;
    public Entity[] weaponClass;
    public short[] weaponAmmunition;
    public byte[] weaponMagazine;
    public int numWeapons;
    public int currentWeapon;
    public int pathLength;
    public int pathIndex;
    public short[] pathX;
    public short[] pathY;
    byte pickUpPhase;
    byte counterDustFrames;
    public int jumpLandingX;
    public int jumpLandingY;
    public int enterCoverX;
    public int enterCoverY;
    public static boolean bigExpl = false;
    public Machinegun machinegun;
    public AnimatedEntity usableHidingPlace;
    public int speechStr;
    public int speechTimer;
    public short[] speechMessagesQueue;
    public int speechMessageStart;
    public int speechMessageEnd;
    public int speechInhibitor;
    boolean showTracer;
    public int startTracerX;
    public int startTracerY;
    public int endTracerX;
    public int endTracerY;
    public int weaponPosX;
    public int weaponPosY;
    public int orientationChangeTimer;
    public static int[] A_JUMP_OVER_COVER;
    public static int[] A_PUT_WEAPON_DOWN;
    public static int[] A_BROWSING;
    public static int[] A_BASE_STAND;
    public static int[] A_BASE_RUN;
    public static int[] A_BASE_AIM;
    public static int[] A_BASE_COVER_AIM;
    public static int[] A_BASE_COVER_STAND;
    public static int[] A_BASE_COVER_RUN;
    public static int[] A_TURRET_IDLE;
    public static int[] A_TURRET_RUN;
    public static int[] A_TURRET_RELOAD;
    public static int[] A_TURRET_COVER_RELOAD;
    public static int[] A_TURRET_AIM;
    public static int[] A_TURRET_COVER_AIM;
    public static int[] A_TURRET_SHOOT;
    public static int[] A_TURRET_COVER_SHOOT;
    public static int[] A_TURRET_SHOTGUN_AIM;
    public static int[] A_TURRET_SHOTGUN_COVER_AIM;
    public static int[] A_TURRET_SHOTGUN_SHOOT;
    public static int[] A_TURRET_SHOTGUN_COVER_SHOOT;
    public static int[] A_TURRET_SHOTGUN_RELOAD;
    public static int[] A_TURRET_SHOTGUN_COVER_RELOAD;
    public static int[] A_TURRET_GUN_AIM;
    public static int[] A_TURRET_GUN_COVER_AIM;
    public static int[] A_TURRET_GUN_SHOOT;
    public static int[] A_TURRET_GUN_COVER_SHOOT;
    public static int[] A_TURRET_GUN_RELOAD;
    public static int[] A_TURRET_GUN_COVER_RELOAD;
    public static int[] A_TURRET_GRENADE_AIM;
    public static int[] A_TURRET_GRENADE_COVER_AIM;
    public static int[] A_TURRET_GRENADE_SHOOT;
    public static int[] A_TURRET_GRENADE_COVER_SHOOT;
    public static int[] A_DELTA_ANIM_DIE_RIFLE;
    public static int[] A_DELTA_ANIM_DIE_EXPLOSION;
    public static int[] A_TURRET_MACHINEGUN_SHOOT;
    public static int[] A_DELTA_ANIM_DIE_RIFLE_BURST;
    public static int[] F_DAMAGE_SOURCE;
    public static int[] F_SHOTGUN_DAMAGE_AREA;
    public static int[] A_STEALTH_KILL;
    public static int[] A_STEALTH_COMBO_KILL;
    public static int[] A_SLIDE_IN_COVER;
    public static int[] F_SELECTION_PLAYER;
    long timePressed = 0L;
    private static final int[] LIFE_UNDER_ONE_HUNDRED;
    private static final int[] LIFE_UNDER_SIXTY;
    private static final int[] LIFE_UNDER_THIRTY;
    private static final int[] KILL_ENEMY;
    private static final int[] HIT_ENEMY;

    Character() {
        super(2);
        this.state = 0;
        this.orientation = 0;
        this.timer = 0;
        this.counterDustFrames = 0;
        this.isCovered = false;
        this.isBurst = false;
        this.isBlasted = false;
        this.showTracer = false;
        this.isDyingAfterJump = false;
        this.canStealthKill = false;
        this.canComboStealthKill = false;
        this.hasDoneComboStealthKill = false;
        this.pathLength = 0;
        this.pickUpPhase = 0;
        this.damageTimer = 0;
        this.comboTimer = 0;
        this.speechStr = 0;
        this.speechTimer = 0;
        this.speechMessagesQueue = new short[16];
        this.speechMessageStart = 0;
        this.speechMessageEnd = 0;
        this.speechInhibitor = 0;
        this.pathX = new short[96];
        this.pathY = new short[96];
        this.weaponClass = new Entity[5];
        for (int i = 0; i < 5; ++i) {
            this.weaponClass[i] = null;
        }
        this.weaponAmmunition = new short[5];
        this.weaponMagazine = new byte[5];
        this.machinegun = null;
        this.usableHidingPlace = null;
        this.silentKillEnemyTarget = null;
        this.currentWeapon = 0;
    }

    public void load(SDKInputStream sDKInputStream) {
        try {
            int n;
            this.id = sDKInputStream.read() & 0xFF;
            this.loadCollision(sDKInputStream);
            this.maxLife = this.life = sDKInputStream.readShort() & 0xFFFF;
            this.regenerationAmount = sDKInputStream.read() & 0xFF;
            this.regenerationInterval = sDKInputStream.read() & 0xFF;
            this.speed = sDKInputStream.read() & 0xFF;
            this.turretAnimator._sprite = this.baseAnimator._sprite = sDKInputStream.read();
            this.rifleModuleMapping = (byte)sDKInputStream.read();
            this.gunModuleMapping = (byte)sDKInputStream.read();
            this.shModuleMapping = (byte)sDKInputStream.read();
            this.stealthModuleMapping = (byte)sDKInputStream.read();
            for (n = 0; n < 3; ++n) {
                byte by = (byte)(sDKInputStream.read() & 0xFF);
                if (by != -1) {
                    this.weaponClass[this.numWeapons] = GameImpl.getWeaponClassByType(by);
                    this.weaponAmmunition[this.numWeapons] = sDKInputStream.readShort();
                    this.weaponMagazine[this.numWeapons] = (byte)Math.min(this.weaponAmmunition[this.numWeapons], this.weaponClass[this.numWeapons].bData[4]);
                    ++this.numWeapons;
                    continue;
                }
                sDKInputStream.readShort();
            }
            this.setWeapon(this.currentWeapon);
            n = 0;
            do {
                this.setNextWeapon();
            } while (this.weaponAmmunition[this.currentWeapon] <= 0 && ++n <= this.numWeapons);
            this.target.pistolHeadSpeed = sDKInputStream.readShort() & 0xFFFF;
            this.target.pistolBodySpeed = this.target.speed = sDKInputStream.readShort() & 0xFFFF;
            this.target.rifleHeadSpeed = sDKInputStream.readShort() & 0xFFFF;
            this.target.rifleBodySpeed = this.target.speed = sDKInputStream.readShort() & 0xFFFF;
            this.isBurst = false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setModuleMapping(int n) {
        int n2 = n;
        if (n == 10 || n == 11) {
            n2 = 7;
        }
        this.baseAnimator.SetModuleMapping(n2);
        this.turretAnimator.SetModuleMapping(n2);
        if (n == 2 || n == 3 || n == 4 || n == 8) {
            this.baseAnimator.SetPalette(0);
            this.turretAnimator.SetPalette(0);
        }
    }

    public void updateSpeech() {
        if (this.speechInhibitor > 0) {
            --this.speechInhibitor;
        }
        if (this.speechTimer > 0) {
            --this.speechTimer;
        } else {
            this.speechStr = this.getRemoveSpeechMessage();
            if (this.speechStr != -1) {
                this.speechTimer = 30;
            }
        }
    }

    public void addSpeechMessage(int n) {
        this.speechMessagesQueue[this.speechMessageEnd] = (short)n;
        this.speechMessageEnd = (this.speechMessageEnd + 1) % 16;
    }

    public int getRemoveSpeechMessage() {
        int n = -1;
        if (this.speechMessagesQueue[this.speechMessageStart] != 0) {
            n = this.speechMessagesQueue[this.speechMessageStart];
            this.speechMessagesQueue[this.speechMessageStart] = 0;
            this.speechMessageStart = (this.speechMessageStart + 1) % 16;
        }
        return n;
    }

    public void init() {
        this.baseAnimator.SetCrtAnim(A_BASE_STAND[this.orientation % 8]);
        this.turretAnimator.SetCrtAnim(A_TURRET_IDLE[this.orientation % 8]);
        this.target.targetRect = GameImpl.sprites[this.target.animator._sprite].RectFrame(15, 100, 100, 0);
    }

    public int getMovingOrientation() {
        int n = 8;
        for (int i = 0; i < GameImpl.MAP_KP_ORIENTATION.length; ++i) {
            if (!Character.playerIsKeyPressed(GameImpl.MAP_KP_ORIENTATION[i][0]) || n != GameImpl.MAP_KP_ORIENTATION[i][1]) continue;
            n = GameImpl.MAP_KP_ORIENTATION[i][2];
        }
        return n;
    }

    public void updateCharacter() {
        if (System.currentTimeMillis() - this.timePressed > 200L && Character.playerIsNewKeyPressed(4112)) {
            this.timePressed = System.currentTimeMillis();
            if (this.state == 13) {
                if (this.silentKillEnemyTarget != null) {
                    this.canStealthKill = true;
                    this.target.setUpdatedStealthAnimation();
                    this.setState(2);
                } else {
                    this.setState(15);
                }
                return;
            }
            if (this.canComboStealthKill) {
                if (this.silentKillEnemyTarget != null) {
                    ++GameImpl.currentConsecutiveStealthKills;
                    GameImpl.shouldCheckAchievements = true;
                    this.silentKillEnemyTarget.setState(1);
                    this.silentKillEnemyTarget = null;
                    this.setState(0);
                }
                this.setState(2);
                this.canStealthKill = false;
                this.hasDoneComboStealthKill = true;
                return;
            }
            if (this.state != 2 && this.state != 3 && this.state != 8 && this.canStealthKill) {
                this.setState(2);
                return;
            }
            if (this.target.state == 0) {
                if (this.usableHidingPlace != null) {
                    this.setState(14);
                    return;
                }
                for (int i = 0; i < GameImpl.numExplodables; ++i) {
                    if (!GameImpl.explodables[i].isPlayerInActivateExplodableRange()) continue;
                    this.setState(16);
                    return;
                }
            }
            if (this.state != 2 && this.state != 3 && this.state != 8) {
                if (this.weaponMagazine[this.currentWeapon] > 0) {
                    this.setState(2);
                    return;
                }
                if (this.weaponAmmunition[this.currentWeapon] > 0) {
                    this.setState(3);
                }
                return;
            }
        }
    }

    public void fire() {
        Debug.startTimer(1);
        if (this.weaponMagazine[this.currentWeapon] > 0) {
            this.shoot();
        } else if (this.weaponAmmunition[this.currentWeapon] > 0) {
            this.setState(3);
        } else {
            this.setState(0);
        }
        Debug.stopTimer(1);
    }

    public static boolean playerIsNewKeyPressed(int n) {
        if (GameImpl.playState == 1) {
            return false;
        }
        return SDKCanvas.isNewKeyPressed(n);
    }

    public static boolean playerIsKeyPressed(int n) {
        if (GameImpl.playState == 1) {
            return false;
        }
        return SDKCanvas.isKeyPressed(n);
    }

    /*
     * Unable to fully structure code
     */
    public void update() {
        super.update();
        if (this.orientationChangeTimer >= 0) {
            --this.orientationChangeTimer;
        }
        if (this.damageTimer > 0) {
            --this.damageTimer;
        }
        if (this.lifeTimer > 0) {
            --this.lifeTimer;
        }
        if (this.canComboStealthKill && this.comboTimer++ > 25 || this.hasDoneComboStealthKill) {
            this.canComboStealthKill = false;
            this.hasDoneComboStealthKill = false;
            this.comboTimer = 0;
        }
        this.updateSpeech();
        ++this.timer;
        if (this.timer % this.regenerationInterval == 0) {
            this.life += this.regenerationAmount;
            if (this.life > this.maxLife) {
                this.life = this.maxLife;
            }
        }
        if (this.state != 13 && this.state != 14 && this.state != 15) {
            this.usableHidingPlace = null;
            for (var1_1 = 0; var1_1 < GameImpl.numHidingPlaces; ++var1_1) {
                GameImpl.sprites[GameImpl.hidingPlaces[var1_1].bData[0]].RectFrame(GameImpl.hidingPlaces[var1_1].bData[1], 0, 0, 0);
                var2_2 = GameImpl.hidingPlaces[var1_1].posX + (XSprite._rect[0] + (XSprite._rect[2] - XSprite._rect[0] >> 1) << 8);
                if (Utils.Distance(var2_2 - this.posX, GameImpl.hidingPlaces[var1_1].posY - this.posY) >= GameImpl.hidingPlaces[var1_1].bData[4] << 8) continue;
                this.usableHidingPlace = GameImpl.hidingPlaces[var1_1];
                break;
            }
        }
        if (this.usableHidingPlace != null) {
            this.usableHidingPlace.update();
        }
        this.baseAnimator.UpdateCrtAnim();
        if (this.state != 6 && this.state != 13 && this.state != 4) {
            if (Character.playerIsNewKeyPressed(32)) {
                if (this.machinegun != null) {
                    if (this.state != 8) {
                        if (this.machinegun.useMachinegun(true)) {
                            this.setState(8);
                        }
                    } else {
                        this.setState(0);
                    }
                    return;
                }
                if (!GameImpl.player.canStealthKill && !GameImpl.player.canComboStealthKill) {
                    GameImpl.hudChangeToNextWeapon = false;
                    this.setNextWeapon();
                }
            }
            if (Character.playerIsNewKeyPressed(128) && this.state != 8 && !Utils.isFlagSet(GameImpl.levels[GameImpl.currentLevel][6], 2) && this.getWeponType() != 3) {
                this.setState(3);
            }
            this.turretAnimator.UpdateCrtAnim();
            if (this.isBurst) {
                for (var1_1 = 0; var1_1 < 4 && !this.turretAnimator.IsCrtAnimEnded(); ++var1_1) {
                    this.turretAnimator.UpdateCrtAnim();
                }
            }
        }
        switch (this.state) {
            case 13: {
                if (this.silentKillEnemyTarget == null) ** GOTO lbl56
                if (Utils.Distance(this.silentKillEnemyTarget.posX - this.usableHidingPlace.posX, this.silentKillEnemyTarget.posY - this.usableHidingPlace.posY) <= this.usableHidingPlace.bData[5] << 8) ** GOTO lbl64
                this.silentKillEnemyTarget = null;
                this.canStealthKill = false;
                ** GOTO lbl64
lbl56:
                // 2 sources

                for (var1_1 = 0; var1_1 < GameImpl.numAreaEnemies; ++var1_1) {
                    var2_3 = GameImpl.enemies[GameImpl.areaEnemies[var1_1]];
                    if (var2_3.state == 1 || var2_3.state == 17 || Utils.Distance(var2_3.posX - this.usableHidingPlace.posX, var2_3.posY - this.usableHidingPlace.posY) > this.usableHidingPlace.bData[5] << 8) continue;
                    this.target.enemyTarget = this.silentKillEnemyTarget = var2_3;
                    this.target.setState(2);
                    this.canStealthKill = true;
                    this.target.setUpdatedStealthAnimation();
                    break;
                }
lbl64:
                // 4 sources

                this.updateCharacter();
                break;
            }
            case 14: {
                if (!this.baseAnimator.IsCrtAnimEnded()) break;
                this.setState(13);
                break;
            }
            case 15: {
                if (!this.baseAnimator.IsCrtAnimEnded()) break;
                this.setState(0);
                break;
            }
            case 2: {
                this.updateCharacter();
                if (this.canStealthKill && !this.canComboStealthKill && this.baseAnimator._crt_aframe >= this.baseAnimator.GetCrtAnimLength() - 1) {
                    for (var1_1 = 0; var1_1 < GameImpl.numAreaEnemies; ++var1_1) {
                        var2_4 = GameImpl.enemies[GameImpl.areaEnemies[var1_1]];
                        if (!var2_4.isOnScreen() || var2_4.state == 1 || var2_4.state == 17 || var2_4 == this.target.enemyTarget || Utils.Distance(this.posX - var2_4.posX, this.posY - var2_4.posY) >= 17920) continue;
                        this.target.enemyTarget = var2_4;
                        this.setState(2);
                        this.canComboStealthKill = true;
                        this.target.setUpdatedStealthAnimation();
                        break;
                    }
                }
                if (this.silentKillEnemyTarget != null) {
                    if (!this.baseAnimator.IsCrtAnimEnded()) break;
                    ++GameImpl.currentConsecutiveStealthKills;
                    GameImpl.shouldCheckAchievements = true;
                    this.silentKillEnemyTarget.setState(1);
                    this.silentKillEnemyTarget = null;
                    this.canStealthKill = false;
                    this.setState(0);
                    break;
                }
                if (this.timer - this.lastShotTime == 3 && Character.playerIsKeyPressed(4112)) {
                    if (this.getWeponType() == 0) {
                        this.isBurst = true;
                        this.target.setBurst(true);
                        Camera.setShake(true);
                    }
                    this.fire();
                }
                if (this.turretAnimator.IsCrtAnimEnded() && !Character.playerIsKeyPressed(4112)) {
                    this.setState(0);
                }
                this.target.update();
                break;
            }
            case 3: {
                if (this.turretAnimator.IsCrtAnimEnded()) {
                    this.reload();
                    this.setState(0);
                }
                this.target.update();
                break;
            }
            case 0: {
                if (this.target.mode == 1) {
                    this.target.updateControl();
                    var1_1 = this.getTurretOrientation();
                    if (var1_1 != this.orientation) {
                        this.setOrientation(var1_1);
                    }
                } else {
                    var1_1 = this.getMovingOrientation();
                    if (var1_1 != 8) {
                        var2_2 = this.orientation;
                        this.setOrientation(var1_1);
                        if (var2_2 != var1_1) {
                            this.target.update();
                        }
                        this.setState(1);
                        break;
                    }
                }
                this.updateCharacter();
                this.updateTurretAnimation();
                this.target.update();
                break;
            }
            case 1: {
                var1_1 = this.getMovingOrientation();
                if (var1_1 == 8) {
                    this.setState(0);
                } else {
                    var2_2 = this.orientation;
                    if (this.orientationChangeTimer <= 0) {
                        this.setOrientation(var1_1);
                    }
                    if (var2_2 != var1_1) {
                        this.target.update();
                    }
                    this.updateMovement();
                }
                var2_2 = (int)this.isCovered;
                this.setCoverState(GameImpl.canCover(this.posX >> 8, this.posY >> 8, this.orientation, this.isCovered));
                if (this.isCovered && var2_2 == 0) {
                    this.setState(10);
                }
                this.updateTurretAnimation();
                this.target.update();
                this.updateCharacter();
                break;
            }
            case 5: {
                this.updatePath();
                break;
            }
            case 4: {
                if (this.baseAnimator.IsCrtAnimEnded() && this.pickUpPhase == 0) {
                    this.baseAnimator.SetCrtAnim(Character.A_BROWSING[this.orientation]);
                    this.pickUpPhase = 1;
                }
                if (!this.baseAnimator.IsCrtAnimEnded() || this.pickUpPhase != 2) break;
                this.baseAnimator._flags &= -4097;
                this.setState(0);
                break;
            }
            case 7: {
                if (this.baseAnimator.IsCrtAnimEnded()) {
                    this.setCoverState(false);
                    if (this.isDyingAfterJump) {
                        this.setState(6);
                        break;
                    }
                    this.posX = this.jumpLandingX;
                    this.posY = this.jumpLandingY;
                    this.setState(0);
                    break;
                }
                if (this.baseAnimator._crt_aframe <= 3) break;
                var3_5 = this.baseAnimator.GetCrtAnimLength() - this.baseAnimator._crt_aframe - 1;
                if (var3_5 > 0) {
                    this.posX += (this.jumpLandingX - this.posX) / var3_5;
                    this.posY += (this.jumpLandingY - this.posY) / var3_5;
                    break;
                }
                this.posX = this.jumpLandingX;
                this.posY = this.jumpLandingY;
                break;
            }
            case 10: {
                var3_6 = this.isCovered != false ? this.speed >> 1 : this.speed;
                var4_7 = this.posX + var3_6 * GameImpl.X_ORIENTATION_FACTOR[this.orientation];
                var5_8 = this.posY + var3_6 * GameImpl.Y_ORIENTATION_FACTOR[this.orientation];
                if (!GameImpl.isCollisionPassable(var4_7 >> 8, var5_8 >> 8)) {
                    this.setState(0);
                    return;
                }
                for (var6_9 = 0; var6_9 < GameImpl.numAreaEnemies; ++var6_9) {
                    var7_11 = GameImpl.enemies[GameImpl.areaEnemies[var6_9]];
                    if (var7_11.state == 1 || !Utils.isColliding(var4_7 >> 8, var5_8 >> 8, this.bData, var7_11.posX >> 8, var7_11.posY >> 8, var7_11.getEnemyClass().bData)) continue;
                    this.setState(0);
                    return;
                }
                this.posX = var4_7;
                this.posY = var5_8;
                break;
            }
            case 8: {
                this.updateCharacter();
                this.machinegun.updateControl();
                this.posX = this.machinegun.getGunnerPositionX();
                this.posY = this.machinegun.getGunnerPositionY();
                this.setOrientation(this.machinegun.orientation);
                break;
            }
            case 6: {
                if (!this.baseAnimator.IsCrtAnimEnded()) break;
                GameImpl.setPlayState(2);
                break;
            }
            case 16: {
                if (this.baseAnimator.IsCrtAnimEnded()) {
                    for (var6_10 = 0; var6_10 < GameImpl.numExplodables; ++var6_10) {
                        if (!GameImpl.explodables[var6_10].isPlayerInActivateExplodableRange()) continue;
                        GameImpl.explodables[var6_10].setState(1);
                        break;
                    }
                    this.setState(0);
                    break;
                }
                this.baseAnimator.UpdateCrtAnim();
            }
        }
        if (this.state != 2) {
            this.canStealthKill = false;
            if (!this.canComboStealthKill && !this.canStealthKill && this.target.isLocked() && this.target.mode != 1 && this.target.enemyTarget != null && this.target.enemyTarget.state != 1 && this.target.enemyTarget.state != 17 && Utils.Distance(this.posX - this.target.enemyTarget.posX, this.posY - this.target.enemyTarget.posY) < 10240) {
                this.canStealthKill = true;
                this.target.setUpdatedStealthAnimation();
            }
        }
        if (this.machinegun != null && this.machinegun.state == 0 && !this.machinegun.isPlayerInActivationRange()) {
            this.machinegun = null;
        }
    }

    public void reload() {
        byte by;
        this.weaponMagazine[this.currentWeapon] = by = (byte)Math.min(this.weaponAmmunition[this.currentWeapon], this.getWeponMagazine());
    }

    public boolean drawTurret() {
        switch (this.state) {
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: {
                return false;
            }
            case 2: {
                return !this.canStealthKill && !this.canComboStealthKill;
            }
            case 3: 
            case 8: {
                return true;
            }
        }
        return !this.isCovered;
    }

    public void draw(SDKGraphics sDKGraphics) {
        int n;
        if (this.state == 13) {
            return;
        }
        int n2 = this.posX >> 8;
        int n3 = this.posY >> 8;
        if (GameImpl.gameMode == 1 && this.state != 6 && this.state != 9 && this.type == 2) {
            n = GameImpl.currentObjective != -1 && GameImpl.objectiveOrientation < 16 ? (n = F_SELECTION_PLAYER[GameImpl.objectiveOrientation]) : 34;
            GameImpl.sprites[8].DrawFrame(n, (this.posX >> 8) - Camera.posX, (this.posY >> 8) - Camera.posY, 0);
        }
        this.baseAnimator.DrawCrtAnim(sDKGraphics, n2, n3);
        if (this.drawTurret()) {
            this.turretAnimator.DrawCrtAnim(sDKGraphics, n2, n3);
        }
        if (this.state == 6 || this.state == 9) {
            return;
        }
        if (GameImpl.gameMode == 1) {
            if (this.showTracer) {
                sDKGraphics.setColor(0xFFFFFF);
                sDKGraphics.drawLine((this.startTracerX >> 8) - Camera.posX, (this.startTracerY >> 8) - Camera.posY, (this.endTracerX >> 8) - Camera.posX, (this.endTracerY >> 8) - Camera.posY);
                this.showTracer = false;
            }
            if (GameImpl.playState != 1 && (this == GameImpl.player || this.life <= this.maxLife >> 1)) {
                if ((this.lifeTimer & 2) == 0) {
                    GameImpl.FillRect(sDKGraphics, 0, (this.posX >> 8) - Camera.posX - 20, (this.posY >> 8) - Camera.posY - 55, 40, 5);
                }
                n = 36 * this.life / this.maxLife;
                GameImpl.FillRect(sDKGraphics, 65280, (this.posX >> 8) - Camera.posX - 18, (this.posY >> 8) - Camera.posY - 54, n, 3);
            }
            if (this.damageTimer > 0 && GameImpl.player == this) {
                GameImpl.sprites[10].DrawFrame(F_DAMAGE_SOURCE[this.damageOrientation], (this.posX >> 8) - Camera.posX, (this.posY >> 8) - Camera.posY, 0);
            }
            if (this.speechTimer > 0) {
                SDKUtils.setFont(GameImpl.fonts[0]);
                SDKUtils.getString(this.speechStr, GameImpl.string);
                GameImpl.wrapOffsets = SDKUtils.wrapString(GameImpl.string, GameImpl.wrapOffsets, 160, (short)124);
                SDKUtils.drawWrappedString(GameImpl.string, GameImpl.wrapOffsets, 1, GameImpl.wrapOffsets[0], (this.posX >> 8) - Camera.posX, (this.posY >> 8) - Camera.posY - 55, 33);
            }
        }
    }

    public static int getWeaponPosXOrientation(int n) {
        if (n < 8) {
            XSprite xSprite = GameImpl.sprites[0];
            short s = xSprite._aframes_id[xSprite._animations_af_offset[A_TURRET_SHOOT[n]]];
            return xSprite._fmodules_ox[xSprite._frames_fm_offset[s + 1] - 1];
        }
        return 0;
    }

    public static int getWeaponPosYOrientation(int n) {
        if (n < 8) {
            XSprite xSprite = GameImpl.sprites[0];
            short s = xSprite._aframes_id[xSprite._animations_af_offset[A_TURRET_SHOOT[n]]];
            return xSprite._fmodules_oy[xSprite._frames_fm_offset[s + 1] - 1];
        }
        return 40;
    }

    void updateTurretAnimation() {
        int n = this.getTurretAnim(this.getTurretOrientation());
        if (n != this.turretAnimator._crt_anim) {
            this.turretAnimator.SetCrtAnim(n);
            if (this.turretAnimator.GetCrtAnimLength() != 0) {
                this.turretAnimator.SetCrtAFrame(this.baseAnimator._crt_aframe % this.turretAnimator.GetCrtAnimLength());
            }
            this.weaponPosX = Character.getWeaponPosXOrientation(this.getTurretOrientation());
            this.weaponPosY = Character.getWeaponPosYOrientation(this.getTurretOrientation());
        }
    }

    int getTurretAnim(int n) {
        switch (this.state) {
            case 8: {
                return A_TURRET_MACHINEGUN_SHOOT[n];
            }
            case 0: {
                if (!this.isCovered) {
                    if (this.target.isLocked() && !Utils.isFlagSet(GameImpl.levels[GameImpl.currentLevel][6], 2)) {
                        switch (this.getWeponType()) {
                            case 2: {
                                return A_TURRET_SHOTGUN_AIM[n];
                            }
                            case 3: {
                                return A_TURRET_GRENADE_AIM[n];
                            }
                            case 1: {
                                return A_TURRET_GUN_AIM[n];
                            }
                        }
                        return A_TURRET_AIM[n];
                    }
                    return A_TURRET_IDLE[n];
                }
                return A_TURRET_IDLE[n];
            }
            case 1: 
            case 5: {
                if (!this.isCovered) {
                    if (this.target.isLocked() && !Utils.isFlagSet(GameImpl.levels[GameImpl.currentLevel][6], 2)) {
                        switch (this.getWeponType()) {
                            case 2: {
                                return A_TURRET_SHOTGUN_AIM[n];
                            }
                            case 3: {
                                return A_TURRET_GRENADE_AIM[n];
                            }
                            case 1: {
                                return A_TURRET_GUN_AIM[n];
                            }
                        }
                        return A_TURRET_AIM[n];
                    }
                    return A_TURRET_RUN[n];
                }
                return A_TURRET_IDLE[n];
            }
            case 2: {
                if (!this.isCovered) {
                    switch (this.getWeponType()) {
                        case 2: {
                            return A_TURRET_SHOTGUN_SHOOT[n];
                        }
                        case 3: {
                            return A_TURRET_GRENADE_SHOOT[n];
                        }
                        case 1: {
                            return A_TURRET_GUN_SHOOT[n];
                        }
                    }
                    return A_TURRET_SHOOT[n];
                }
                switch (this.getWeponType()) {
                    case 2: {
                        return A_TURRET_SHOTGUN_COVER_SHOOT[n];
                    }
                    case 3: {
                        return A_TURRET_GRENADE_COVER_SHOOT[n];
                    }
                    case 1: {
                        return A_TURRET_GUN_COVER_SHOOT[n];
                    }
                }
                return A_TURRET_COVER_SHOOT[n];
            }
            case 3: {
                if (!this.isCovered) {
                    switch (this.getWeponType()) {
                        case 2: {
                            return A_TURRET_SHOTGUN_RELOAD[n];
                        }
                        case 1: {
                            return A_TURRET_GUN_RELOAD[n];
                        }
                    }
                    return A_TURRET_RELOAD[n];
                }
                switch (this.getWeponType()) {
                    case 2: {
                        return A_TURRET_SHOTGUN_COVER_RELOAD[n];
                    }
                    case 1: {
                        return A_TURRET_GUN_COVER_RELOAD[n];
                    }
                }
                return A_TURRET_COVER_RELOAD[n];
            }
            case 12: {
                if (!this.isCovered) {
                    switch (this.getWeponType()) {
                        case 2: {
                            return A_TURRET_SHOTGUN_SHOOT[n];
                        }
                        case 3: {
                            return A_TURRET_GRENADE_SHOOT[n];
                        }
                        case 1: {
                            return A_TURRET_GUN_SHOOT[n];
                        }
                    }
                    return A_TURRET_SHOOT[n];
                }
                switch (this.getWeponType()) {
                    case 2: {
                        return A_TURRET_SHOTGUN_COVER_SHOOT[n];
                    }
                    case 3: {
                        return A_TURRET_GRENADE_COVER_SHOOT[n];
                    }
                    case 1: {
                        return A_TURRET_GUN_COVER_SHOOT[n];
                    }
                }
                return A_TURRET_COVER_SHOOT[n];
            }
        }
        return A_TURRET_IDLE[n];
    }

    int getTurretOrientation() {
        if (this.state == 8 || this.getWeponType() == 2 || this.state == 5) {
            return this.orientation;
        }
        return this.target.getTurretOrientationToTarget();
    }

    public void setState(int n) {
        if (n == this.state) {
            return;
        }
        switch (this.state) {
            case 2: {
                this.target.blockTarget(false);
                if (!this.isBurst) break;
                this.isBurst = false;
                this.target.setBurst(false);
                Camera.setShake(false);
                break;
            }
            case 13: {
                this.usableHidingPlace.setState(0);
                break;
            }
            case 8: {
                if (this.machinegun == null) break;
                this.machinegun.useMachinegun(false);
            }
        }
        this.state = n;
        switch (this.state) {
            case 6: {
                this.setBaseAnimation();
                this.target.setState(6);
                break;
            }
            case 2: {
                if (this.canStealthKill || this.canComboStealthKill) {
                    this.silentKillEnemyTarget = this.target.enemyTarget;
                } else {
                    this.shoot();
                    this.target.blockTarget(true);
                }
                this.setBaseAnimation();
                break;
            }
            case 4: {
                this.pickUpPhase = 0;
                this.setBaseAnimation();
                break;
            }
            case 1: {
                this.counterDustFrames = 0;
                this.setBaseAnimation();
                break;
            }
            case 5: {
                this.isCovered = false;
                this.counterDustFrames = 0;
                this.setBaseAnimation();
                break;
            }
            case 13: {
                if (this.type != 2) break;
                this.usableHidingPlace.setState(1);
                this.setBaseAnimation();
                break;
            }
            default: {
                this.setBaseAnimation();
            }
        }
    }

    public void setOrientation(int n) {
        if (this.orientation == n) {
            return;
        }
        this.orientationChangeTimer = 6;
        this.orientation = n;
        this.setBaseAnimation();
    }

    public void setBaseAnimation() {
        this.baseAnimator._flags &= 0xFFFFF7FF;
        this.baseAnimator._flags &= 0xFFFFEFFF;
        switch (this.state) {
            case 3: {
                if (!this.isCovered) {
                    this.baseAnimator.SetCrtAnim(A_BASE_AIM[this.orientation]);
                    break;
                }
                this.baseAnimator.SetCrtAnim(A_BASE_COVER_AIM[this.orientation]);
                break;
            }
            case 8: {
                this.baseAnimator.SetCrtAnim(A_BASE_AIM[this.orientation]);
                break;
            }
            case 0: {
                if (!this.isCovered) {
                    if (this.target.isLocked()) {
                        this.baseAnimator.SetCrtAnim(A_BASE_AIM[this.orientation]);
                        break;
                    }
                    this.baseAnimator.SetCrtAnim(A_BASE_STAND[this.orientation]);
                    break;
                }
                this.baseAnimator.SetCrtAnim(A_BASE_COVER_STAND[this.orientation]);
                break;
            }
            case 1: {
                if (!this.isCovered) {
                    this.baseAnimator.SetCrtAnim(A_BASE_RUN[this.orientation]);
                    break;
                }
                this.baseAnimator.SetCrtAnim(A_BASE_COVER_RUN[this.orientation]);
                break;
            }
            case 2: {
                if (this.canComboStealthKill) {
                    this.baseAnimator.SetCrtAnim(A_STEALTH_COMBO_KILL[this.orientation]);
                    break;
                }
                if (this.canStealthKill) {
                    this.baseAnimator.SetCrtAnim(A_STEALTH_KILL[this.orientation]);
                    break;
                }
                if (!this.isCovered) {
                    this.baseAnimator.SetCrtAnim(A_BASE_AIM[this.orientation]);
                    break;
                }
                this.baseAnimator.SetCrtAnim(A_BASE_COVER_AIM[this.orientation]);
                break;
            }
            case 4: {
                switch (this.pickUpPhase) {
                    case 0: {
                        this.baseAnimator.SetCrtAnim(A_PUT_WEAPON_DOWN[this.orientation]);
                        break;
                    }
                    case 1: {
                        this.baseAnimator.SetCrtAnim(A_BROWSING[this.orientation]);
                        break;
                    }
                    case 2: {
                        this.baseAnimator._flags |= 0x1000;
                        this.baseAnimator.SetCrtAnim(A_PUT_WEAPON_DOWN[this.orientation]);
                    }
                }
                break;
            }
            case 7: {
                this.baseAnimator.SetCrtAnim(A_JUMP_OVER_COVER[this.orientation]);
                break;
            }
            case 10: {
                this.baseAnimator.SetCrtAnim(A_SLIDE_IN_COVER[this.orientation]);
                break;
            }
            case 5: {
                if (!this.isCovered) {
                    this.baseAnimator.SetCrtAnim(A_BASE_RUN[this.orientation]);
                    break;
                }
                this.baseAnimator.SetCrtAnim(A_BASE_COVER_RUN[this.orientation]);
                break;
            }
            case 12: {
                if (this.canStealthKill) {
                    this.baseAnimator.SetCrtAnim(A_BROWSING[this.orientation]);
                    break;
                }
                if (!this.isCovered) {
                    this.baseAnimator.SetCrtAnim(A_BASE_AIM[this.orientation]);
                    break;
                }
                this.baseAnimator.SetCrtAnim(A_BASE_COVER_AIM[this.orientation]);
                break;
            }
            case 14: {
                this.baseAnimator.SetCrtAnim(268);
                break;
            }
            case 15: {
                this.baseAnimator.SetCrtAnim(269);
                break;
            }
            case 16: {
                this.baseAnimator.SetCrtAnim(A_BROWSING[this.orientation]);
                this.baseAnimator._flags |= 0x800;
                break;
            }
            case 6: {
                if (this.isBlasted) {
                    this.baseAnimator.SetCrtAnim(A_DELTA_ANIM_DIE_EXPLOSION[this.orientation]);
                } else {
                    this.baseAnimator.SetCrtAnim(A_DELTA_ANIM_DIE_RIFLE[this.orientation]);
                }
                this.baseAnimator._flags |= 0x800;
            }
        }
        this.updateTurretAnimation();
    }

    public void setCoverState(boolean bl) {
        if (this.isCovered != bl) {
            this.isCovered = bl;
            this.setState(0);
        }
    }

    public void updateMovement() {
        int n;
        int n2 = this.isCovered ? this.speed >> 1 : this.speed;
        int n3 = this.posX + n2 * GameImpl.X_ORIENTATION_FACTOR[this.orientation];
        int n4 = this.posY + n2 * GameImpl.Y_ORIENTATION_FACTOR[this.orientation];
        for (n = 0; n < GameImpl.numAreaEnemies; ++n) {
            Enemy enemy = GameImpl.enemies[GameImpl.areaEnemies[n]];
            if (enemy.state == 1 || enemy.state == 17 || !Utils.isColliding(n3 >> 8, n4 >> 8, this.bData, enemy.posX >> 8, enemy.posY >> 8, enemy.getEnemyClass().bData) || Utils.isColliding(this.posX >> 8, this.posY >> 8, this.bData, enemy.posX >> 8, enemy.posY >> 8, enemy.getEnemyClass().bData)) continue;
            this.setState(0);
            return;
        }
        if (GameImpl.isCollisionCover(n3 >> 8, n4 >> 8) && this.canJump(n3, n4)) {
            this.setState(7);
        } else {
            n = 8;
            if (!GameImpl.isCollisionPassable(n3 >> 8, n4 >> 8)) {
                n = this.getSlidingOrientation(n3, n4, n3, n4);
                if (n != 8) {
                    n3 = this.posX + n2 * GameImpl.X_ORIENTATION_FACTOR[n];
                    n4 = this.posY + n2 * GameImpl.Y_ORIENTATION_FACTOR[n];
                } else {
                    n3 = this.posX;
                    n4 = this.posY;
                }
            } else if (!GameImpl.isCollisionPassable(n3 + n2 * GameImpl.X_ORIENTATION_FACTOR[this.orientation] >> 8, n4 + n2 * GameImpl.Y_ORIENTATION_FACTOR[this.orientation] >> 8) && (n = this.getSlidingOrientation(n3 + n2 * GameImpl.X_ORIENTATION_FACTOR[this.orientation], n4 + n2 * GameImpl.Y_ORIENTATION_FACTOR[this.orientation], n3, n4)) != 8) {
                n3 = this.posX + n2 * GameImpl.X_ORIENTATION_FACTOR[n];
                n4 = this.posY + n2 * GameImpl.Y_ORIENTATION_FACTOR[n];
            }
        }
        this.posX = n3;
        this.posY = n4;
        n = Map._map_w;
        int n5 = 0;
        int n6 = 0;
        int n7 = Map._map_h;
        if (GameImpl.playAreaRightLimit != -1) {
            n = GameImpl.playAreaRightLimit;
            n5 = GameImpl.playAreaLeftLimit;
            n6 = GameImpl.playAreaTopLimit;
            n7 = GameImpl.playAreaBottomLimit;
        }
        if (this.posY >> 8 < 10 + n6) {
            this.posY = 10 + n6 << 8;
        }
        if (this.posY >> 8 > n7 - 10) {
            this.posY = n7 - 10 << 8;
        }
        if (this.posX >> 8 < n5 + 10) {
            this.posX = n5 + 10 << 8;
        }
        if (this.posX >> 8 > n - 10) {
            this.posX = n - 10 << 8;
        }
    }

    private int getSlidingOrientation(int n, int n2, int n3, int n4) {
        int n5 = this.isCovered ? this.speed >> 1 : this.speed;
        int n6 = n;
        int n7 = n2;
        int n8 = (this.orientation + 6) % 8;
        int n9 = (this.orientation + 2) % 8;
        int n10 = (this.orientation + 7) % 8;
        int n11 = (this.orientation + 1) % 8;
        for (int i = 1; i < 4; ++i) {
            if (GameImpl.isCollisionPassable((n3 >> 8) + i * Map.collision_tile_h * GameImpl.X_ORIENTATION_DX_FACTOR[n8], (n4 >> 8) + i * Map.collision_tile_w * GameImpl.Y_ORIENTATION_DY_FACTOR[n8])) {
                n6 = this.posX + n5 * GameImpl.X_ORIENTATION_FACTOR[n10];
                n7 = this.posY + n5 * GameImpl.Y_ORIENTATION_FACTOR[n10];
                if (GameImpl.isCollisionPassable(n6 >> 8, n7 >> 8)) {
                    return n10;
                }
                n6 = this.posX + n5 * GameImpl.X_ORIENTATION_FACTOR[n8];
                n7 = this.posY + n5 * GameImpl.Y_ORIENTATION_FACTOR[n8];
                if (!GameImpl.isCollisionPassable(n6 >> 8, n7 >> 8)) continue;
                return n8;
            }
            if (!GameImpl.isCollisionPassable((n3 >> 8) + i * Map.collision_tile_h * GameImpl.X_ORIENTATION_DX_FACTOR[n9], (n4 >> 8) + i * Map.collision_tile_w * GameImpl.Y_ORIENTATION_DY_FACTOR[n9])) continue;
            n6 = this.posX + n5 * GameImpl.X_ORIENTATION_FACTOR[n11];
            n7 = this.posY + n5 * GameImpl.Y_ORIENTATION_FACTOR[n11];
            if (GameImpl.isCollisionPassable(n6 >> 8, n7 >> 8)) {
                return n11;
            }
            n6 = this.posX + n5 * GameImpl.X_ORIENTATION_FACTOR[n9];
            n7 = this.posY + n5 * GameImpl.Y_ORIENTATION_FACTOR[n9];
            if (!GameImpl.isCollisionPassable(n6 >> 8, n7 >> 8)) continue;
            return n9;
        }
        return 8;
    }

    int getMovementOrientation() {
        int n = 0;
        int n2 = 0;
        if (this.pathIndex < this.pathLength - 1) {
            n = this.pathX[this.pathIndex + 1] - this.pathX[this.pathIndex];
            n2 = this.pathY[this.pathIndex + 1] - this.pathY[this.pathIndex];
        } else if (this.pathIndex > 0) {
            n = this.pathX[this.pathIndex] - this.pathX[this.pathIndex - 1];
            n2 = this.pathY[this.pathIndex] - this.pathY[this.pathIndex - 1];
        } else {
            return this.getTurretOrientation();
        }
        return GameImpl.getOrientation(n << 8, n2 << 8);
    }

    public void updatePath() {
        if (this.pathIndex >= this.pathLength - 1) {
            this.pathIndex = 0;
            this.pathLength = 0;
            if (this.type == 16) {
                AlliedCharacter alliedCharacter = (AlliedCharacter)this;
                if ((alliedCharacter.waypointsFlags[alliedCharacter.currentWaypoint] & 0x200) != 0 && alliedCharacter.waypointsScripts[alliedCharacter.currentWaypoint] > 0) {
                    GameImpl.vm.spawnInstanceByID(alliedCharacter.waypointsScripts[alliedCharacter.currentWaypoint], -1);
                    alliedCharacter.waypointsScripts[alliedCharacter.currentWaypoint] = -1;
                }
            }
            this.setCoverState(GameImpl.canCover(this.posX >> 8, this.posY >> 8, this.orientation, this.isCovered));
            this.setState(0);
            this.setBaseAnimation();
            return;
        }
        if (this.pathIndex < this.pathLength - 3 && Map.getCollision(this.pathY[this.pathIndex + 1] * Map._coll_map_tw + this.pathX[this.pathIndex + 1]) == 1 && Map.getCollision(this.pathY[this.pathIndex + 2] * Map._coll_map_tw + this.pathX[this.pathIndex + 2]) == 15) {
            this.jumpLandingX = this.pathX[this.pathIndex + 2] * Map.collision_tile_h << 8;
            this.jumpLandingY = this.pathY[this.pathIndex + 2] * Map.collision_tile_w << 8;
            this.setOrientation(GameImpl.getOrientation(this.pathX[this.pathIndex + 2] - this.pathX[this.pathIndex] << 8, this.pathY[this.pathIndex + 2] - this.pathY[this.pathIndex] << 8));
            this.pathIndex += 2;
            this.setState(7);
        } else {
            int n = this.isCovered ? this.speed >> 1 : this.speed;
            int n2 = this.pathX[this.pathIndex + 1] - this.pathX[this.pathIndex];
            int n3 = this.pathY[this.pathIndex + 1] - this.pathY[this.pathIndex];
            this.setOrientation(this.getMovementOrientation());
            if (n2 * n3 != 0) {
                this.posX += n2 * n * 179;
                this.posY += n3 * n * 179;
            } else {
                this.posX += n2 * n << 8;
                this.posY += n3 * n << 8;
            }
            if (n2 > 0 && this.posX >> 8 > this.pathX[this.pathIndex + 1] * Map.collision_tile_h) {
                ++this.pathIndex;
            } else if (n2 < 0 && this.posX >> 8 < this.pathX[this.pathIndex + 1] * Map.collision_tile_h) {
                ++this.pathIndex;
            } else if (n3 > 0 && this.posY >> 8 > this.pathY[this.pathIndex + 1] * Map.collision_tile_w) {
                ++this.pathIndex;
            } else if (n3 < 0 && this.posY >> 8 < this.pathY[this.pathIndex + 1] * Map.collision_tile_w) {
                ++this.pathIndex;
            }
        }
        if (this.pathIndex >= this.pathLength - 1) {
            this.pathIndex = 0;
            this.pathLength = 0;
            if (this.type == 16) {
                AlliedCharacter alliedCharacter = (AlliedCharacter)this;
                if ((alliedCharacter.waypointsFlags[alliedCharacter.currentWaypoint] & 0x200) != 0 && alliedCharacter.waypointsScripts[alliedCharacter.currentWaypoint] > 0) {
                    GameImpl.vm.spawnInstanceByID(alliedCharacter.waypointsScripts[alliedCharacter.currentWaypoint], -1);
                    alliedCharacter.waypointsScripts[alliedCharacter.currentWaypoint] = -1;
                }
            }
            this.setCoverState(GameImpl.canCover(this.posX >> 8, this.posY >> 8, this.orientation, this.isCovered));
            this.setState(0);
            this.setBaseAnimation();
        }
    }

    public void gotoXY(int n, int n2) {
        int[] nArray = new int[]{15, 1};
        this.pathLength = PathFinder.FindPathOn((this.posX >> 8) / Map.collision_tile_w, (this.posY >> 8) / Map.collision_tile_h, n / Map.collision_tile_w, n2 / Map.collision_tile_h, this.pathX, this.pathY, nArray);
        this.pathIndex = 0;
        this.setState(5);
    }

    public void setNextWeapon() {
        this.setWeapon((this.currentWeapon + 1) % this.numWeapons);
    }

    public void setWeapon(int n) {
        this.currentWeapon = n;
        if (this.target != null) {
            this.target.weponChange();
        }
        if (Utils.isFlagSet(GameImpl.levels[GameImpl.currentLevel][6], 2)) {
            this.setModuleMapping(this.stealthModuleMapping);
        } else if (this.getWeponType() == 1) {
            this.setModuleMapping(this.gunModuleMapping);
        } else if (this.getWeponType() == 2) {
            this.setModuleMapping(this.shModuleMapping);
        } else {
            this.setModuleMapping(this.rifleModuleMapping);
        }
        if (GameImpl.playState != 1) {
            this.setState(0);
        }
    }

    public int getWeponType() {
        return this.weaponClass[this.currentWeapon].bData[0];
    }

    public int getWeponMagazine() {
        return this.weaponClass[this.currentWeapon].bData[4];
    }

    public int getWeponRange() {
        return this.weaponClass[this.currentWeapon].sData[0];
    }

    public int getWeponDamageArea() {
        return this.weaponClass[this.currentWeapon].bData[3];
    }

    public void shoot() {
        int n;
        int n2 = this.target.posX;
        int n3 = this.target.posY;
        this.shootDecreaseAmmo();
        this.lastShotTime = this.timer;
        for (n = 0; n < GameImpl.numAreaEnemies; ++n) {
            int n4 = Utils.Distance(this.posX - GameImpl.enemies[GameImpl.areaEnemies[n]].posX >> 8, this.posY - GameImpl.enemies[GameImpl.areaEnemies[n]].posY >> 8);
            if (n4 >= 210) continue;
            GameImpl.enemies[GameImpl.areaEnemies[n]].orientation = (this.orientation + 4) % 8;
        }
        if (this.getWeponType() == 0 || this.getWeponType() == 1) {
            this.target.shoot();
            if (Utils.collPointBox(this.posX >> 8, this.posY >> 8, Camera.posX - 160, Camera.posY - 120, 640, 480)) {
                switch (this.getWeponType()) {
                    case 1: {
                        GameImpl.playSound(7);
                        break;
                    }
                    case 0: {
                        if (this.isBurst) {
                            GameImpl.playSound(11);
                            break;
                        }
                        GameImpl.playSound(11);
                    }
                }
            }
            if (this.target.state == 2) {
                int n5;
                n = 1;
                boolean bl = Enemy.canEnemyBeShoot(this.posX >> 8, this.posY >> 8, this.target.enemyTarget.posX >> 8, this.target.enemyTarget.posY >> 8, this.target.enemyTarget, this);
                if (bl) {
                    Debug.startTimer(3);
                    GameImpl.collideBulletWithCover(this.target.enemyTarget.posX >> 8, this.target.enemyTarget.posY >> 8, this.posX >> 8, this.posY >> 8, true);
                    Debug.stopTimer(3);
                    n5 = this.target.enemyTarget.life;
                    int n6 = 0;
                    if (this.type == 2) {
                        n = this.target.getShootingMultiplicator();
                        if (this.target.isHeadshot()) {
                            ++GameImpl.currentConsecutiveHeadshots;
                            GameImpl.shouldCheckAchievements = true;
                        } else {
                            GameImpl.currentConsecutiveHeadshots = 0;
                        }
                    } else if (Utils.random(100) < ((AlliedCharacter)this).accuracy) {
                        n6 = ((AlliedCharacter)this).damage;
                    }
                    if (this.isBurst && n >= 1) {
                        this.target.enemyTarget.takeDamage(this.type == 2 ? this.weaponClass[this.currentWeapon].bData[2] : n6, this.posX, this.posY);
                    } else {
                        this.target.enemyTarget.takeDamage(this.type == 2 ? this.weaponClass[this.currentWeapon].bData[1] * n : n6, this.posX, this.posY);
                    }
                    if (this == GameImpl.player && this.getWeponType() == 1 && this.target.enemyTarget.life <= 0) {
                        ++GameImpl.pistolKillCount;
                        GameImpl.shouldCheckAchievements = true;
                    }
                    if (this != GameImpl.player) {
                        if (this.target.enemyTarget.life <= 0) {
                            this.addSpeechMessage(KILL_ENEMY[Utils.random(KILL_ENEMY.length)]);
                        } else if (this.target.enemyTarget.life != n5 && this.speechInhibitor == 0) {
                            this.addSpeechMessage(HIT_ENEMY[Utils.random(HIT_ENEMY.length)]);
                            this.speechInhibitor = 120;
                        }
                    }
                    if (this.target.enemyTarget.life != n5) {
                        GameImpl.spawnTempAnimation(this.target.posX, this.target.posY, 8, n > 1 ? 17 : 16);
                    }
                }
                if ((n5 = GameImpl.getCollisionPosition(this.posX >> 8, this.posY >> 8, this.target.enemyTarget.posX >> 8, this.target.enemyTarget.posY >> 8, 0)) != -1) {
                    n2 = Map.collision_tile_h * (n5 & 0xFF) << 8;
                    n3 = Map.collision_tile_w * (n5 >> 16) << 8;
                }
            } else {
                n2 = this.posX + (this.weaponPosX << 8) + GameImpl.X_ORIENTATION_FACTOR[this.orientation] * 160;
                n3 = this.posY + (this.weaponPosY << 8) + GameImpl.Y_ORIENTATION_FACTOR[this.orientation] * 120;
            }
            this.createTracer(this.posX + (this.weaponPosX << 8), this.posY + (this.weaponPosY << 8), n2, n3);
        }
        if (this.getWeponType() == 3) {
            this.shootGrenade();
        }
        if (this.getWeponType() == 2) {
            this.shootShotgun();
        }
    }

    private void shootShotgun() {
        GameImpl.playSound(10);
        for (int i = 0; i < GameImpl.numAreaEnemies; ++i) {
            Enemy enemy = GameImpl.enemies[GameImpl.areaEnemies[i]];
            if (enemy.state == 1 || enemy.state == 17 || !enemy.isOnScreen() || !this.isInShotgunShootArea(enemy) || !Enemy.canEnemyBeShoot(this.posX >> 8, this.posY >> 8, enemy.posX >> 8, enemy.posY >> 8, enemy, this)) continue;
            int n = enemy.life;
            enemy.takeDamage(this.weaponClass[this.currentWeapon].bData[1], this.posX, this.posY);
            if (enemy.life == n) continue;
            GameImpl.spawnTempAnimation(this.target.posX, this.target.posY, 8, 17);
        }
    }

    public boolean isInShotgunShootArea(Enemy enemy) {
        return this.isInShotgunArc(this.posX, this.posY, this.orientation, enemy.posX - 2560, enemy.posY - 3840) && this.isInShotgunArc(this.posX, this.posY, this.orientation, enemy.posX + 2560, enemy.posY - 3840);
    }

    public boolean isInShotgunArc(int n, int n2, int n3, int n4, int n5) {
        int n6;
        if (Utils.Distance(n4 - n, n5 - n2) >> 8 > this.getWeponRange()) {
            return false;
        }
        int n7 = GameImpl.getExtendedOrientation(n4 - n, n5 - n2);
        return n7 - (n6 = n3 << 1) == -2 || n7 - n6 == -1 || n7 - n6 == 0 || n7 - n6 == 1 || n7 - n6 == 2 || n7 - n6 == 15 || n7 - n6 == 14 || n7 - n6 == -15 || n7 - n6 == -14;
    }

    private void shootDecreaseAmmo() {
        int n = this.currentWeapon;
        this.weaponMagazine[n] = (byte)(this.weaponMagazine[n] - 1);
        if (this.getWeponType() != 1) {
            int n2 = this.currentWeapon;
            this.weaponAmmunition[n2] = (short)(this.weaponAmmunition[n2] - 1);
        }
    }

    public void shootGrenade() {
        GameImpl.createGrenade(this.posX, this.posY, this.target.posX, this.target.posY, -(this.weaponPosY << 7), this.orientation, 0);
    }

    public void getShot(int n, int n2, int n3) {
        if (GameImpl.godMode && this.type == 2) {
            return;
        }
        int n4 = this.life;
        this.life -= n;
        if (this == GameImpl.player) {
            GameImpl.updateObjectives(6);
        }
        this.damageTimer = 5;
        this.damageOrientation = GameImpl.getOrientation(n2 - this.posX, n3 - this.posY);
        if (this.life <= 0 && this.type == 16 && (((AlliedCharacter)this).flags & 2) != 0) {
            this.life = 1;
        }
        if (this.life <= 0) {
            if (this.state == 7) {
                this.isDyingAfterJump = true;
            } else {
                this.setState(6);
            }
        } else if (this != GameImpl.player) {
            this.displaySpeechDamageReceived(n4);
        }
        if (this.state == 14) {
            this.setState(0);
        }
    }

    public void getBlasted(int n) {
        if (GameImpl.godMode && this.type == 2) {
            return;
        }
        int n2 = this.life;
        this.life -= n;
        if (this.life <= 0 && this.type == 16 && (((AlliedCharacter)this).flags & 2) != 0) {
            this.life = 1;
        }
        if (this.life <= 0) {
            this.isBlasted = true;
            this.setState(6);
        } else if (this != GameImpl.player) {
            this.displaySpeechDamageReceived(n2);
        }
        if (this.state == 14) {
            this.setState(0);
        }
    }

    public void displaySpeechDamageReceived(int n) {
        if (this.life < this.maxLife * 3 / 10) {
            if (n >= this.maxLife * 3 / 10) {
                this.addSpeechMessage(LIFE_UNDER_THIRTY[Utils.random(LIFE_UNDER_THIRTY.length)]);
            }
        } else if (this.life < this.maxLife * 6 / 10) {
            if (n >= this.maxLife * 6 / 10) {
                this.addSpeechMessage(LIFE_UNDER_SIXTY[Utils.random(LIFE_UNDER_SIXTY.length)]);
            }
        } else if (n == this.maxLife) {
            this.addSpeechMessage(LIFE_UNDER_ONE_HUNDRED[Utils.random(LIFE_UNDER_ONE_HUNDRED.length)]);
        }
    }

    public void startPickUp() {
        this.pickUpPhase = 0;
        this.setState(4);
    }

    public void endPickUp() {
        this.pickUpPhase = (byte)2;
        this.baseAnimator.SetCrtAnim(A_PUT_WEAPON_DOWN[this.orientation]);
    }

    public boolean canJump(int n, int n2) {
        int n3 = n / Map.collision_tile_h >> 8;
        int n4 = n2 / Map.collision_tile_w >> 8;
        int n5 = n4 * Map._coll_map_tw + n3;
        int n6 = GameImpl.X_ORIENTATION_DX_FACTOR[this.orientation] + GameImpl.Y_ORIENTATION_DY_FACTOR[this.orientation] * Map._coll_map_tw;
        for (int i = 0; i < 6; ++i) {
            if ((n5 += n6) < 0 || n5 >= Map._coll_map_size || Map.getCollision(n5) == 0) {
                return false;
            }
            if (Map.getCollision(n5) != 15) continue;
            if ((n5 += n6) < 0 || n5 >= Map._coll_map_size || Map.getCollision(n5) != 15) {
                n5 -= n6;
            }
            this.jumpLandingY = n5 / Map._coll_map_tw * Map.collision_tile_h << 8;
            this.jumpLandingX = n5 % Map._coll_map_tw * Map.collision_tile_w << 8;
            return true;
        }
        return false;
    }

    public void canUseMachinegun(Machinegun machinegun) {
        if (this.machinegun == null) {
            this.machinegun = machinegun;
            GameImpl.hudModel[4] = (short)(GameImpl.hudModel[4] | 1);
            GameImpl.hudModel[5] = (short)(GameImpl.hudModel[5] + 28);
        }
    }

    public void createTracer(int n, int n2, int n3, int n4) {
        int n5 = Utils.Distance(n3 - n, n2 - n4);
        int n6 = 160 * n5 >> 8;
        int n7 = n6 * Utils.random(50, 200) >> 8;
        int n8 = (Utils.random(n6 - n7) << 8) / n5;
        int n9 = (n7 << 8) / n5;
        this.startTracerX = n - ((80 + n8) * (n - n3) >> 8);
        this.endTracerX = n - ((80 + n8 + n9) * (n - n3) >> 8);
        this.startTracerY = n2 - ((80 + n8) * (n2 - n4) >> 8);
        this.endTracerY = n2 - ((80 + n8 + n9) * (n2 - n4) >> 8);
        this.showTracer = true;
    }

    public void clean() {
    }

    static {
        LIFE_UNDER_ONE_HUNDRED = new int[]{83, 84, 85};
        LIFE_UNDER_SIXTY = new int[]{86, 87, 88};
        LIFE_UNDER_THIRTY = new int[]{89, 90, 91};
        KILL_ENEMY = new int[]{95, 96, 97};
        HIT_ENEMY = new int[]{92, 93, 94};
    }
}

