/*
 * Decompiled with CFR 0.152.
 */
package generic;

import com.ea.sdkstandalone.ResourceLoader;
import com.ea.sdkstandalone.SDKSoundManager;
import com.ea.sdkstandalone.SDKString;
import constants.AnimConstants;
import constants.CarConstants;
import constants.ColourConstants;
import constants.EventConstants;
import constants.IStringConstants;
import constants.ResourceConstants;
import constants.SoundEventConstants;
import constants.TrackConstants;
import game.AppEngine;
import generic.AnimPlayer;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class ResourceManager
implements AnimConstants,
EventConstants,
IStringConstants,
ResourceConstants,
ColourConstants,
SoundEventConstants,
TrackConstants,
ResourceLoader,
CarConstants {
    public static final SDKString SLASH_STRING = new SDKString("/");
    public static final byte NULL = -1;
    public static final byte STRING_NULL = -1;
    private static String mFileNamePrefix;
    private static StringBuffer mFileNameBuffer;
    private static final int PNG_SIGNATURE_SIZE = 8;
    private static final int CHUNK_LENGTH_SIZE = 4;
    private static final int CHUNK_TYPE_SIZE = 4;
    private static final int CHUNK_DATA_OFFSET = 8;
    private static final int CHUNK_CRC_SIZE = 4;
    private static final int CHUNK_OVERHEAD_SIZE = 12;
    private static final int ZLIB_HEADER_SIZE = 7;
    private static final int ADLER_SIZE = 4;
    private static final int CRC32_POLYNOMIAL = -306674912;
    private static final int CHUNK_TYPE_VAL_IHDR = 1229472850;
    private static final int CHUNK_TYPE_VAL_PLTE = 1347179589;
    private static final int CHUNK_TYPE_VAL_tRNS = 1951551059;
    private static final int CHUNK_TYPE_VAL_IDAT = 1229209940;
    private static final int CHUNK_TYPE_VAL_IEND = 1229278788;
    private int[] mCRCTable;
    public static final int SOUNDTYPE_OTT = 0;
    public static final int SOUNDTYPE_MID = 0;
    private static boolean m_soundEnabled;
    private static final int NO_SOUND_PLAYING = -1;
    private static int m_currentPlayingSound;
    private static SDKSoundManager m_soundManager;
    private static int[] m_sounds;
    private static int soundVolume;
    private static int musicID;
    private static final byte SUB_IMAGE_ID = 0;
    private static final byte SUB_IMAGE_X = 1;
    private static final byte SUB_IMAGE_Y = 2;
    private static final byte SUB_IMAGE_WIDTH = 3;
    private static final byte SUB_IMAGE_HEIGHT = 4;
    private static final byte NUM_SUB_IMAGE_FIELDS = 5;
    private static final byte PRIMITIVE_SPRITE_ENUM = 0;
    private static final byte PRIMITIVE_CLIP_ENUM = 1;
    private static final byte PRIMITIVE_COLL_BOX_ENUM = 2;
    private static final byte PRIMITIVE_HOLLOW_RECTANGLE_ENUM = 3;
    private static final byte PRIMITIVE_FILLED_RECTANGLE_ENUM = 4;
    private static final byte PRIMITIVE_HOLLOW_ELLIPSE_ENUM = 5;
    private static final byte PRIMITIVE_FILLED_ELLIPSE_ENUM = 6;
    private static final byte PRIMITIVE_FIRE_POINT_ENUM = 7;
    private static final byte PRIMITIVE_LINE_ENUM = 8;
    private static final byte PRIMITIVE_TEXT_ENUM = 9;
    private static final byte PRIMITIVE_COLOR_ENUM = 10;
    private static final byte PRIMITIVE_XFLIPPED_SPRITE_ENUM = 11;
    private static final byte PRIMITIVE_ATTRIB_TYPE = 0;
    private static final byte PRIMITIVE_ATTRIB_X = 1;
    private static final byte PRIMITIVE_ATTRIB_Y = 2;
    private static final byte PRIMITIVE_ATTRIB_X2 = 3;
    private static final byte PRIMITIVE_ATTRIB_Y2 = 4;
    private static final byte PRIMITIVE_ATTRIB_SUBIMAGE = 3;
    private static final byte PRIMITIVE_ATTRIB_WIDTH = 3;
    private static final byte PRIMITIVE_ATTRIB_HEIGHT = 4;
    private static final byte PRIMITIVE_ATTRIB_COLOUR_INDEX = 1;
    private byte[] m_colourData;
    private short[][] m_frameDuration;
    private static short[][][][] m_primitiveData;
    private static short[][] m_subImages;
    private static Image[] m_animImageArray;
    private short[] m_imageLoadCountArray;
    private static int m_isInIndex;

    public ResourceManager(String string) {
        mFileNamePrefix = string;
        this.buildLUT();
        Image[] imageArray = new Image[40];
        short[] sArray = new short[40];
        int n = 0;
        while (n < 40) {
            imageArray[n] = null;
            sArray[n++] = 0;
        }
        m_animImageArray = imageArray;
        this.m_imageLoadCountArray = sArray;
    }

    public byte[] loadResource(int n) {
        return this.loadFileIntoByteArray(SoundEventConstants.SOUND_DATA_SETS[n]);
    }

    public byte[] loadFileIntoByteArray(int n) {
        int n2 = ResourceConstants.RESOURCE_FILESIZE_LIST[n];
        byte[] byArray = new byte[n2];
        if (byArray == null) {
            return null;
        }
        try {
            DataInputStream dataInputStream = new DataInputStream(this.loadBinaryFile(n));
            if (dataInputStream == null) {
                return null;
            }
            dataInputStream.readFully(byArray);
            dataInputStream.close();
            dataInputStream = null;
        }
        catch (Exception exception) {
            return null;
        }
        return byArray;
    }

    public static final int ID_TO_FILESIZE(int n) {
        return ResourceConstants.RESOURCE_FILESIZE_LIST[n];
    }

    public static final String ID_TO_FILENAME(int n) {
        return ResourceConstants.RESOURCE_FILENAMES_LIST[n];
    }

    public final Image loadImage(int n) {
        try {
            mFileNameBuffer.delete(0, mFileNameBuffer.length());
            mFileNameBuffer.append(mFileNamePrefix);
            mFileNameBuffer.append(ResourceManager.ID_TO_FILENAME(n));
            return Image.createImage((String)mFileNameBuffer.toString());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public final InputStream loadBinaryFile(int n) {
        mFileNameBuffer.delete(0, mFileNameBuffer.length());
        mFileNameBuffer.append(mFileNamePrefix);
        mFileNameBuffer.append(ResourceManager.ID_TO_FILENAME(n));
        return this.getClass().getResourceAsStream(mFileNameBuffer.toString());
    }

    public byte[] loadBinaryFileToByteArray(int n) {
        byte[] byArray = new byte[ResourceConstants.RESOURCE_FILESIZE_LIST[n]];
        if (byArray == null) {
            return null;
        }
        try {
            InputStream inputStream = this.loadBinaryFile(n);
            if (inputStream == null) {
                return null;
            }
            inputStream.read(byArray);
            inputStream = null;
        }
        catch (Exception exception) {
            return null;
        }
        return byArray;
    }

    public Image loadImageScaled(int n, int n2, int n3) {
        byte[] byArray = this.loadBinaryFileToByteArray(n);
        if (byArray == null) {
            return null;
        }
        return this.loadPNGScaled(byArray, 0, n2, n3);
    }

    public Image loadPNGScaled(byte[] byArray, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        if (this.unsignedByteToInt(byArray[n++]) != 137 || this.unsignedByteToInt(byArray[n++]) != 80 || this.unsignedByteToInt(byArray[n++]) != 78 || this.unsignedByteToInt(byArray[n++]) != 71 || this.unsignedByteToInt(byArray[n++]) != 13 || this.unsignedByteToInt(byArray[n++]) != 10 || this.unsignedByteToInt(byArray[n++]) != 26 || this.unsignedByteToInt(byArray[n++]) != 10) {
            return null;
        }
        while (n < byArray.length) {
            n5 = this.readBigEndianInt(byArray, n);
            n4 = this.readBigEndianInt(byArray, n + 4);
            if (n4 == 1229472850) {
                n6 = n;
                n7 = n5;
            } else if (n4 == 1347179589) {
                n8 = n;
                n9 = n5;
            } else if (n4 == 1951551059) {
                n10 = n;
                n11 = n5;
            } else if (n4 == 1229209940) {
                n12 = n;
                n13 = n5;
            } else if (n4 == 1229278788) {
                n14 = n;
                n15 = n5;
            }
            n += 12 + n5;
        }
        n5 = this.readBigEndianInt(byArray, n6 + 8);
        n4 = this.readBigEndianInt(byArray, n6 + 8 + 4);
        int n16 = AppEngine.Fmul(n5 << 16, n2) + 32768 >> 16;
        int n17 = AppEngine.Fmul(n4 << 16, n3) + 32768 >> 16;
        if (n16 <= 0) {
            n16 = 1;
        }
        if (n17 <= 0) {
            n17 = 1;
        }
        int n18 = 7 + (n16 * n17 + n17) + 4;
        int n19 = 4;
        int n20 = n7 + n9 + n18 + n15;
        if (n11 > 0) {
            ++n19;
            n20 += n11;
        }
        n20 += 8;
        byte[] byArray2 = new byte[n20 += n19 * 12];
        int n21 = 0;
        System.arraycopy(byArray, 0, byArray2, n21, 8 + n7 + 8);
        this.writeBigEndianInt(n16, byArray2, 16);
        this.writeBigEndianInt(n17, byArray2, 20);
        int n22 = this.calcCRC32(byArray2, 12, n7 + 4);
        this.writeBigEndianInt(n22, byArray2, n21 += 8 + n7 + 8);
        System.arraycopy(byArray, n8, byArray2, n21 += 4, n9 + 12);
        n21 += n9 + 12;
        if (n11 > 0) {
            System.arraycopy(byArray, n10, byArray2, n21, n11 + 12);
            n21 += n11 + 12;
        }
        this.writeBigEndianInt(n18, byArray2, n21);
        this.writeBigEndianInt(1229209940, byArray2, n21 += 4);
        this.scaleIDAT(byArray, n12 + 8, n5, n4, byArray2, n21 += 4, n16, n17);
        int n23 = this.calcCRC32(byArray2, n21 - 4, n18 + 4);
        this.writeBigEndianInt(n23, byArray2, n21 += n18);
        System.arraycopy(byArray, n14, byArray2, n21 += 4, n15 + 12);
        return Image.createImage((byte[])byArray2, (int)0, (int)byArray2.length);
    }

    private void scaleIDAT(byte[] byArray, int n, int n2, int n3, byte[] byArray2, int n4, int n5, int n6) {
        int n7;
        int n8 = n4;
        System.arraycopy(byArray, n, byArray2, n8, 3);
        int n9 = n5 * n6 + n6;
        this.writeBigEndianShort((short)n9, byArray2, n8 += 3);
        this.writeBigEndianShort((short)(~n9), byArray2, n8 += 2);
        n8 += 2;
        n += 7;
        int n10 = n2 << 1;
        int n11 = n3 << 1;
        int n12 = 0;
        int n13 = n2 + 1;
        int n14 = n5 << 1;
        int n15 = n6 << 1;
        int n16 = 0;
        int n17 = n5 + 1;
        int n18 = n3;
        boolean bl = false;
        while (!bl) {
            n18 += n15;
            while (n18 > n11) {
                n18 -= n11;
                n7 = 0;
                int n19 = 0;
                int n20 = n2;
                boolean bl2 = false;
                while (!bl2) {
                    n20 += n14;
                    while (n20 > n10) {
                        n20 -= n10;
                        int n21 = n8 + n19 + n16 * n17 + 1;
                        int n22 = n + n7 + n12 * n13 + 1;
                        byArray2[n21] = byArray[n22];
                        if (++n19 < n5) continue;
                        bl2 = true;
                        break;
                    }
                    ++n7;
                }
                if (++n16 < n6) continue;
                bl = true;
                break;
            }
            ++n12;
        }
        n7 = this.updateAdler32(byArray2, 1, n4 + 7, n9);
        this.writeBigEndianInt(n7, byArray2, n8 += n9);
    }

    public Image loadImageMirroredPNG(int n) {
        int n2;
        int n3;
        byte[] byArray;
        int n4 = 5000;
        try {
            InputStream inputStream = this.loadBinaryFile(n);
            byArray = new byte[n4];
            n4 = inputStream.read(byArray);
            inputStream = null;
        }
        catch (IOException iOException) {
            return null;
        }
        if (this.unsignedByteToInt(byArray[0]) != 137 || this.unsignedByteToInt(byArray[1]) != 80 || this.unsignedByteToInt(byArray[2]) != 78 || this.unsignedByteToInt(byArray[3]) != 71 || this.unsignedByteToInt(byArray[4]) != 13 || this.unsignedByteToInt(byArray[5]) != 10 || this.unsignedByteToInt(byArray[6]) != 26 || this.unsignedByteToInt(byArray[7]) != 10) {
            return null;
        }
        int n5 = this.readBigEndianInt(byArray, 8);
        String string = this.readPNGChunkType(byArray, 12);
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        if (n5 > 0 && string.equals("IHDR")) {
            n6 = this.readBigEndianInt(byArray, 16);
            n7 = this.readBigEndianInt(byArray, 20);
            n8 = byArray[24];
            n9 = byArray[25];
        }
        if (n8 != 8 || n9 != 3) {
            return null;
        }
        int n10 = this.getChunkStartIndex(byArray, "IDAT");
        int n11 = n4;
        int n12 = n6 * n7 + n7 + 7 + 4;
        int n13 = n11;
        int n14 = n12;
        int n15 = n10 + 4 + 4;
        int n16 = n15 + n14;
        int n17 = n15 + 7 + 1;
        int n18 = n6 + 1;
        for (n3 = 0; n3 < n7; ++n3) {
            n2 = n17 + n3 * n18;
            int n19 = n2 + n6 - 1;
            byArray[n2 - 1] = 0;
            for (int i = 0; i < n6 >> 1; ++i) {
                byte by = byArray[n19 - i];
                byArray[n19 - i] = byArray[n2 + i];
                byArray[n2 + i] = by;
            }
        }
        n3 = this.updateAdler32(byArray, 1, n15 + 7, n6 * n7 + n7);
        this.writeBigEndianInt(n3, byArray, n16 - 4);
        n2 = this.calcCRC32(byArray, n10 + 4, 4 + n14);
        this.writeBigEndianInt(n2, byArray, n16);
        try {
            Image image = Image.createImage((byte[])byArray, (int)0, (int)n13);
            if (image != null) {
                return image;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void buildLUT() {
        this.mCRCTable = new int[256];
        for (int i = 0; i <= 255; ++i) {
            int n = i;
            for (int j = 8; j > 0; --j) {
                if ((n & 1) == 1) {
                    n = n >>> 1 ^ 0xEDB88320;
                    continue;
                }
                n >>>= 1;
            }
            this.mCRCTable[i] = n;
        }
    }

    public int updateAdler32(byte[] byArray, int n, int n2, int n3) {
        int n4 = n & 0xFFFF;
        int n5 = n >>> 16;
        while (n3-- > 0) {
            n4 = (n4 + (byArray[n2++] & 0xFF)) % 65521;
            n5 = (n5 + n4) % 65521;
        }
        n = n5 << 16 | n4;
        return n;
    }

    public int calcCRC32(byte[] byArray, int n, int n2) {
        int n3 = -1;
        for (int i = n; i < n + n2; ++i) {
            int n4 = 0xFF & byArray[i] ^ n3 & 0xFF;
            n3 = n3 >>> 8 ^ this.mCRCTable[n4];
        }
        return ~n3;
    }

    private int readBigEndianInt(byte[] byArray, int n) {
        int n2 = (byArray[n] & 0xFF) << 24;
        int n3 = (byArray[n + 1] & 0xFF) << 16;
        int n4 = (byArray[n + 2] & 0xFF) << 8;
        int n5 = byArray[n + 3] & 0xFF;
        int n6 = n2 | n3 | n4 | n5;
        return n6;
    }

    private void writeBigEndianInt(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >> 24 & 0xFF);
        byArray[n2 + 1] = (byte)(n >> 16 & 0xFF);
        byArray[n2 + 2] = (byte)(n >> 8 & 0xFF);
        byArray[n2 + 3] = (byte)(n & 0xFF);
    }

    private void writeBigEndianShort(short s, byte[] byArray, int n) {
        byArray[n] = (byte)(s & 0xFF);
        byArray[n + 1] = (byte)(s >> 8 & 0xFF);
    }

    private String readPNGChunkType(byte[] byArray, int n) {
        try {
            return new String(new Character((char)byArray[n]).toString() + new Character((char)byArray[n + 1]).toString() + new Character((char)byArray[n + 2]).toString() + new Character((char)byArray[n + 3]).toString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private int unsignedByteToInt(byte by) {
        return 0xFF & by;
    }

    private int getChunkStartIndex(byte[] byArray, String string) {
        int n;
        String string2;
        int n2 = 8;
        do {
            n = this.readBigEndianInt(byArray, n2);
        } while (!(string2 = this.readPNGChunkType(byArray, n2 + 4)).equals(string) && (n2 += 12 + n) < byArray.length);
        return n2;
    }

    public static final boolean getSoundEnabled() {
        return m_soundEnabled;
    }

    public static final void setSoundEnabled(boolean bl) {
        if (!bl) {
            ResourceManager.stopAllSounds();
        }
        m_soundEnabled = bl;
        m_soundManager.setSoundEnabled(m_soundEnabled);
        if (m_soundEnabled) {
            if (m_currentPlayingSound == -1) {
                ResourceManager.playSound(4);
                m_currentPlayingSound = -1;
            } else {
                ResourceManager.startLastMusic();
            }
        }
    }

    public static final int getNumSounds() {
        return SoundEventConstants.SOUND_DATA_SETS.length;
    }

    public static final void initialiseSoundManager() {
        m_soundManager = SDKSoundManager.getManager();
        m_soundManager.setPlaybackType(0);
        m_sounds = new int[SoundEventConstants.SOUND_DATA_SETS.length];
        for (int i = 0; i < m_sounds.length; ++i) {
            ResourceManager.m_sounds[i] = -1;
        }
    }

    public static void loadSound(int n, ResourceManager resourceManager) {
        m_soundManager.setLoader(resourceManager);
        if (SoundEventConstants.SOUND_DATA_SETS[n] >= 0 && m_sounds[n] < 0) {
            m_soundManager.loadSound(n);
            ResourceManager.m_sounds[n] = n;
        }
    }

    public static void unloadSound(int n, ResourceManager resourceManager) {
        m_soundManager.setLoader(resourceManager);
        if (SoundEventConstants.SOUND_DATA_SETS[n] >= 0 && m_sounds[n] >= 0) {
            m_soundManager.unloadSound(n);
            ResourceManager.m_sounds[n] = -1;
        }
    }

    public void setSoundVolume(int n) {
        if (n < 0) {
            return;
        }
        soundVolume = n;
        m_soundManager.setSoundVolume(soundVolume);
    }

    public int getSoundVolume() {
        return soundVolume;
    }

    public static void startLastMusic() {
        if (musicID != -1) {
            ResourceManager.startMusic(musicID);
        }
    }

    public static void startMusic(int n) {
        if (n != -1) {
            musicID = n;
        }
        if (SoundEventConstants.SOUND_DATA_SETS.length > n && SoundEventConstants.SOUND_DATA_SETS[n] >= 0 && m_soundEnabled && (m_currentPlayingSound == -1 || musicID == -1)) {
            m_soundManager.setPlaybackType(0);
            m_soundManager.setSoundVolume(soundVolume);
            m_soundManager.setCurrentLoop(-1);
            m_soundManager.playSound(n);
            m_currentPlayingSound = n;
        }
    }

    public static void playSound(int n) {
        if (SoundEventConstants.SOUND_DATA_SETS.length > n && SoundEventConstants.SOUND_DATA_SETS[n] >= 0 && m_soundEnabled) {
            m_soundManager.setPlaybackType(0);
            m_soundManager.setSoundVolume(soundVolume);
            m_soundManager.setCurrentLoop(1);
            m_soundManager.playSound(n);
            m_currentPlayingSound = n;
        }
    }

    public static void stopAllSounds() {
        if (m_soundEnabled && m_currentPlayingSound != -1) {
            m_soundManager.stopSound(m_currentPlayingSound);
            m_currentPlayingSound = -1;
        }
    }

    public boolean loadColorsFile() {
        DataInputStream dataInputStream = new DataInputStream(this.loadBinaryFile(38));
        this.m_colourData = new byte[ResourceManager.ID_TO_FILESIZE(38)];
        try {
            dataInputStream.read(this.m_colourData);
            dataInputStream.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    public void setColor(Graphics graphics, int n) {
        int n2 = n * 3;
        byte[] byArray = this.m_colourData;
        graphics.setColor(byArray[n2] & 0xFF, byArray[n2 + 1] & 0xFF, byArray[n2 + 2] & 0xFF);
    }

    public boolean loadSubimageFile() {
        try {
            short[][] sArray = new short[74][5];
            DataInputStream dataInputStream = new DataInputStream(this.loadBinaryFile(45));
            System.gc();
            for (int i = 0; i < 74; ++i) {
                short[] sArray2 = sArray[i];
                sArray2[0] = (short)dataInputStream.readUnsignedByte();
                sArray2[1] = dataInputStream.readShort();
                sArray2[2] = dataInputStream.readShort();
                sArray2[3] = dataInputStream.readShort();
                sArray2[4] = dataInputStream.readShort();
            }
            m_subImages = sArray;
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        catch (IOException iOException) {
            m_subImages = null;
            return false;
        }
        return true;
    }

    public boolean loadAnimFile() {
        try {
            short[][] sArrayArray = new short[75][];
            short[][][][] sArrayArray2 = new short[75][][][];
            DataInputStream dataInputStream = new DataInputStream(this.loadBinaryFile(0));
            for (int i = 0; i != 75; ++i) {
                int n = dataInputStream.readByte();
                short[] sArray = new short[n];
                sArrayArray[i] = sArray;
                short[][][] sArrayArray3 = new short[n][][];
                sArrayArray2[i] = sArrayArray3;
                for (int j = 0; j != n; ++j) {
                    sArray[j] = dataInputStream.readShort();
                    int n2 = dataInputStream.readByte();
                    short[][] sArrayArray4 = new short[n2][];
                    sArrayArray3[j] = sArrayArray4;
                    for (int k = 0; k != n2; ++k) {
                        byte by = dataInputStream.readByte();
                        short[] sArray2 = null;
                        switch (by) {
                            case 0: 
                            case 11: {
                                sArray2 = new short[4];
                                sArray2[3] = dataInputStream.readShort();
                                sArray2[1] = dataInputStream.readShort();
                                sArray2[2] = dataInputStream.readShort();
                                break;
                            }
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: {
                                sArray2 = new short[5];
                                sArray2[1] = dataInputStream.readShort();
                                sArray2[2] = dataInputStream.readShort();
                                sArray2[3] = dataInputStream.readShort();
                                sArray2[4] = dataInputStream.readShort();
                                break;
                            }
                            case 7: {
                                sArray2 = new short[3];
                                sArray2[1] = dataInputStream.readShort();
                                sArray2[2] = dataInputStream.readShort();
                                break;
                            }
                            case 8: {
                                sArray2 = new short[5];
                                sArray2[1] = dataInputStream.readShort();
                                sArray2[2] = dataInputStream.readShort();
                                sArray2[3] = dataInputStream.readShort();
                                sArray2[4] = dataInputStream.readShort();
                                break;
                            }
                            case 10: {
                                sArray2 = new short[2];
                                sArray2[1] = dataInputStream.readByte();
                            }
                        }
                        sArray2[0] = by;
                        sArrayArray4[k] = sArray2;
                    }
                }
            }
            this.m_frameDuration = sArrayArray;
            m_primitiveData = sArrayArray2;
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    private static final int imageSetGetIndex(int n, short[] sArray) {
        int n2 = sArray.length;
        for (int i = 0; i != n2; ++i) {
            if (n != sArray[i]) continue;
            return i;
        }
        return -1;
    }

    private boolean isElementInArray(int n, short[] sArray) {
        for (int i = 0; i < sArray.length; ++i) {
            if (sArray[i] != n) continue;
            return true;
        }
        return false;
    }

    public boolean loadImage(ResourceManager resourceManager, int n) {
        int n2;
        for (n2 = 0; n2 < 40 && n != AnimConstants.IMAGE_RES_IDS[n2]; ++n2) {
        }
        if (40 == n2) {
            return false;
        }
        short[] sArray = this.m_imageLoadCountArray;
        if (sArray[n2] == 0) {
            ResourceManager.m_animImageArray[n2] = resourceManager.loadImage(n);
            if (m_animImageArray[n2] == null) {
                return false;
            }
        }
        int n3 = n2;
        sArray[n3] = (short)(sArray[n3] + 1);
        return true;
    }

    public boolean unloadImage(int n) {
        int n2;
        for (n2 = 0; n2 < 40 && n != AnimConstants.IMAGE_RES_IDS[n2]; ++n2) {
        }
        if (40 == n2) {
            return false;
        }
        short s = this.m_imageLoadCountArray[n2];
        if (s > 0) {
            if (0 == (s = (short)(s - 1))) {
                ResourceManager.m_animImageArray[n2] = null;
                try {
                    Thread.sleep(16L);
                    System.gc();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.m_imageLoadCountArray[n2] = s;
        }
        return true;
    }

    public AnimPlayer createAnimPlayer() {
        return new AnimPlayer(this);
    }

    public void drawAnimFrame(Graphics graphics, int n, int n2, int n3, int n4) {
        if (n < 0) {
            return;
        }
        int n5 = graphics.getClipX();
        int n6 = graphics.getClipY();
        int n7 = graphics.getClipWidth();
        int n8 = graphics.getClipHeight();
        short[][] sArray = m_subImages;
        Image[] imageArray = m_animImageArray;
        short[][] sArray2 = m_primitiveData[n][n2];
        int n9 = sArray2.length;
        for (int i = 0; i != n9; ++i) {
            short[] sArray3 = sArray2[i];
            short s = sArray3[0];
            if (s == 0 || s == 11) {
                int n10 = n3 + sArray3[1];
                int n11 = n4 + sArray3[2];
                short[] sArray4 = sArray[sArray3[3]];
                int n12 = sArray4[0] & 0xFFFF;
                Image image = imageArray[n12];
                if (image == null) continue;
                int n13 = s == 0 ? 0 : 2;
                graphics.drawRegion(image, (int)sArray4[1], (int)sArray4[2], (int)sArray4[3], (int)sArray4[4], n13, n10, n11, 20);
                continue;
            }
            if (s == 2 || s == 7) continue;
            this.drawPrimitive(graphics, n3, n4, sArray3);
        }
        graphics.setClip(n5, n6, n7, n8);
    }

    public final void drawAnim(Graphics graphics, AnimPlayer animPlayer, int n, int n2) {
        this.drawAnimFrame(graphics, animPlayer.getAnimID(), animPlayer.getCurrAnimFrame(), n, n2);
    }

    private final void drawPrimitive(Graphics graphics, int n, int n2, short[] sArray) {
        switch (sArray[0]) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                int n3 = n + sArray[1];
                int n4 = n2 + sArray[2];
                short s = sArray[3];
                short s2 = sArray[4];
                switch (sArray[0]) {
                    case 3: {
                        graphics.drawRect(n3, n4, s - 1, s2 - 1);
                        break;
                    }
                    case 4: {
                        graphics.fillRect(n3, n4, (int)s, (int)s2);
                        break;
                    }
                    case 5: {
                        graphics.drawArc(n3, n4, s - 1, s2 - 1, 0, 360);
                        break;
                    }
                    case 6: {
                        graphics.fillArc(n3, n4, (int)s, (int)s2, 0, 360);
                    }
                }
                break;
            }
            case 8: {
                int n5 = n + sArray[1];
                int n6 = n2 + sArray[2];
                int n7 = n + sArray[3];
                int n8 = n2 + sArray[4];
                graphics.drawLine(n5, n6, n7, n8);
                break;
            }
            case 10: {
                this.setColor(graphics, sArray[1]);
                break;
            }
            case 1: {
                int n9 = n + sArray[1];
                int n10 = n2 + sArray[2];
                short s = sArray[3];
                short s3 = sArray[4];
                graphics.clipRect(n9, n10, (int)s, (int)s3);
                break;
            }
        }
    }

    public int animGetNumFrames(int n) {
        return this.m_frameDuration[n].length;
    }

    public short animFrameGetDuration(int n, int n2) {
        return this.m_frameDuration[n][n2];
    }

    private int getPrimitiveX(short[] sArray) {
        switch (sArray[0]) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                return sArray[1];
            }
            case 8: {
                short s = sArray[1];
                short s2 = sArray[3];
                return s < s2 ? s : s2;
            }
        }
        return 0;
    }

    private int getPrimitiveY(short[] sArray) {
        switch (sArray[0]) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                return sArray[2];
            }
            case 8: {
                short s = sArray[2];
                short s2 = sArray[4];
                return s < s2 ? s : s2;
            }
        }
        return 0;
    }

    private int getPrimitiveWidth(short[] sArray) {
        switch (sArray[0]) {
            case 0: 
            case 11: {
                int n = sArray[3];
                return m_subImages[n &= 0xFFFF][3];
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return sArray[3];
            }
            case 8: {
                int n = sArray[1] - sArray[3];
                return n < 0 ? -n : n;
            }
            case 9: {
                return 0;
            }
        }
        return 0;
    }

    private int getPrimitiveHeight(short[] sArray) {
        switch (sArray[0]) {
            case 0: 
            case 11: {
                int n = sArray[3];
                return m_subImages[n &= 0xFFFF][4];
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return sArray[4];
            }
            case 8: {
                int n = sArray[2] - sArray[4];
                return n < 0 ? -n : n;
            }
            case 9: {
                return 0;
            }
        }
        return 0;
    }

    public int getAnimFrameX(int n, int n2) {
        short[][] sArray = m_primitiveData[n][n2];
        int n3 = sArray.length;
        if (n3 == 0) {
            return 0;
        }
        int n4 = Integer.MAX_VALUE;
        for (int i = 0; i != n3; ++i) {
            int n5;
            if (sArray[i][0] == 10 || (n5 = this.getPrimitiveX(sArray[i])) >= n4) continue;
            n4 = n5;
        }
        return n4;
    }

    public int getAnimFrameY(int n, int n2) {
        short[][] sArray = m_primitiveData[n][n2];
        int n3 = sArray.length;
        if (n3 == 0) {
            return 0;
        }
        int n4 = Integer.MAX_VALUE;
        for (int i = 0; i != n3; ++i) {
            int n5;
            if (sArray[i][0] == 10 || (n5 = this.getPrimitiveY(sArray[i])) >= n4) continue;
            n4 = n5;
        }
        return n4;
    }

    public int getAnimFrameWidth(int n, int n2) {
        short[][] sArray = m_primitiveData[n][n2];
        int n3 = sArray.length;
        if (n3 == 0) {
            return 0;
        }
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MIN_VALUE;
        for (int i = 0; i != n3; ++i) {
            if (sArray[i][0] == 10) continue;
            int n6 = this.getPrimitiveX(sArray[i]);
            int n7 = n6 + this.getPrimitiveWidth(sArray[i]);
            if (n6 < n4) {
                n4 = n6;
            }
            if (n7 <= n5) continue;
            n5 = n7;
        }
        return n5 - n4;
    }

    public int getAnimFrameHeight(int n, int n2) {
        short[][] sArray = m_primitiveData[n][n2];
        int n3 = sArray.length;
        if (n3 == 0) {
            return 0;
        }
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MIN_VALUE;
        for (int i = 0; i != n3; ++i) {
            if (sArray[i][0] == 10) continue;
            int n6 = this.getPrimitiveY(sArray[i]);
            int n7 = n6 + this.getPrimitiveHeight(sArray[i]);
            if (n6 < n4) {
                n4 = n6;
            }
            if (n7 <= n5) continue;
            n5 = n7;
        }
        return n5 - n4;
    }

    public int getAnimFrameFirePointCount(int n, int n2) {
        short[][] sArray = m_primitiveData[n][n2];
        int n3 = 0;
        for (int i = sArray.length - 1; i != -1; --i) {
            if (sArray[i][0] != 7) continue;
            ++n3;
        }
        return n3;
    }

    public boolean getAnimFrameFirePoint(int[] nArray, int n, int n2, int n3) {
        short[][] sArray = m_primitiveData[n][n2];
        int n4 = 0;
        for (int i = sArray.length - 1; i != -1; --i) {
            if (sArray[i][0] != 7) continue;
            if (n4 == n3) {
                nArray[0] = sArray[i][1];
                nArray[1] = sArray[i][2];
                return true;
            }
            ++n4;
        }
        nArray[0] = 0;
        nArray[1] = 0;
        return false;
    }

    public int getAnimFrameFirePointX(int n, int n2, int n3) {
        int[] nArray = new int[2];
        this.getAnimFrameFirePoint(nArray, n, n2, n3);
        return nArray[0];
    }

    public int getAnimFrameFirePointY(int n, int n2, int n3) {
        int[] nArray = new int[2];
        this.getAnimFrameFirePoint(nArray, n, n2, n3);
        return nArray[1];
    }

    public boolean getAnimFrameCollisionBox(int[] nArray, int n, int n2) {
        short[][] sArray = m_primitiveData[n][n2];
        for (int i = sArray.length - 1; i != -1; --i) {
            if (sArray[i][0] != 2) continue;
            nArray[0] = sArray[i][1];
            nArray[1] = sArray[i][2];
            nArray[2] = sArray[i][3];
            nArray[3] = sArray[i][4];
            return true;
        }
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[3] = 0;
        return false;
    }

    public void getAnimFrameBox(int[] nArray, int n, int n2) {
        nArray[0] = this.getAnimFrameX(n, n2);
        nArray[1] = this.getAnimFrameY(n, n2);
        nArray[2] = this.getAnimFrameWidth(n, n2);
        nArray[3] = this.getAnimFrameHeight(n, n2);
    }

    static {
        mFileNameBuffer = new StringBuffer(80);
        m_soundEnabled = false;
        m_currentPlayingSound = -1;
        soundVolume = -1;
        musicID = -1;
        m_isInIndex = 0;
    }
}

