/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.AppEngine;
import game.SceneGame;

public class GameObject {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_CAR_PLAYER = 1;
    public static final int TYPE_CAR_AI = 2;
    public static final int TYPE_CRIMINAL = 3;
    public static final int TYPE_TREE = 4;
    public static final int TYPE_CONE = 5;
    public static final int AI_MOOD_NORMAL = 0;
    public static final int AI_MOOD_AGGRESSIVE = 1;
    public static final int AI_MOOD_SOFT = 2;
    private static final int DEFAULT_MAX_BOOST_TIME = 196608;
    private static final int DEFAULT_BOOST_SPEED_MULTIPLIER_F = 78643;
    private static final int DEFAULT_BOOST_ACCEL_MULTIPLIER_F = 196608;
    private static final int DEFAULT_GEARCHANGE_ACCEL_EASE_TIME = 39322;
    private static final int DEFAULT_BRAKING = 0xA00000;
    private static final int DEFAULT_BRAKING_OFFTRACK = 0x800000;
    private static final int DEFAULT_POST_BOOST_SLOWING = 0x780000;
    public static final int GEARCHANGE_DELAY_TIME = 16384;
    public static final short PLAYER_CAR_ID = 999;
    public static final int CRIMINAL_CAR_MAX_NUM_HITS = 4;
    public static final int CRIMINAL_MIN_HIT_INTERVAL = 65536;
    public static final int CRIMINAL_AI_TIME_LIMIT_SHIFT = 0;
    public static final int CRIMINAL_PLAYER_REACT_DISTANCE = 0x640000;
    public static final int CRIMINAL_MIN_HIT_SPEED = 0x320000;
    public static final int CRIMINAL_DEATH_TIME = 131072;
    public int m_type = 0;
    public int m_trackPosF = 0;
    public int m_lateralPosF = 0;
    public int m_renderPosX = 0;
    public int m_renderPosY = 0;
    public int m_renderDistF = 0;
    public int m_renderClipY = 0;
    public int m_numLapsCompleted = -1;
    public int m_currentLapTime;
    public int m_cumulativeLapTimes;
    public boolean m_finishedRace = false;
    public int m_currSection = 0;
    public int m_nextSection = 1;
    public int m_lateralPosTargetF = 0;
    public int m_lateralPosSpeedF = 0;
    public int m_lateralPosAccelF = 65536;
    public int m_lateralPosSpeedMaxF = 65536;
    public int m_speedF = 0;
    public int m_accelerationF;
    public int m_speedMulF = 0;
    public int m_accelMulF = 0;
    public int m_AITimeF = 0;
    public int m_AILimitF = 131072;
    public int m_ID = 0;
    public int m_mood = 0;
    public byte m_currentGear;
    public byte m_numGears = 1;
    public int[] m_gearAccels;
    public int[] m_gearMinSpeeds;
    public int[] m_gearMaxSpeeds;
    public boolean m_isAccelerating;
    public boolean m_isBraking;
    public boolean m_isOffTrackBraking;
    public int m_difficultyMult = 65536;
    public int m_catchupCodeMultTargetF = 65536;
    public int m_catchupCodeMultCurrF = 65536;
    public int m_lastCornerWarningSection = -1;
    public boolean m_showingSlowdownEffects;
    public SceneGame m_sceneGame;
    private boolean m_isBoosting;
    private int m_boostTimeF = 196608;
    private int m_boostMultiplierF = 65536;
    private int m_gearChangeAccelEaseTimeF;
    private int m_timeSinceGearChangeSecsF;
    private int m_curGearMinSpeedF;
    private int m_curGearMaxSpeedF;
    private int m_maxSpeedRangeMultiplierF;
    private int m_racePosition;
    private int m_gearChangeDelayTimerSecsF;
    private byte m_maximumAllowedGear;
    private int m_criminalCarHitCount;
    private int m_hitTimer;

    public GameObject(SceneGame sceneGame) {
        this.m_sceneGame = sceneGame;
        this.m_gearChangeAccelEaseTimeF = 39322;
        this.m_hitTimer = 65537;
    }

    public void updateSpeed(int n) {
        if (this.m_type == 3) {
            this.m_hitTimer += n;
            if (this.isDead() && this.m_hitTimer >= 131072) {
                this.m_criminalCarHitCount = 0;
                this.m_sceneGame.setCarAheadOfPlayer(this);
            }
        }
        this.updateBoost(n);
        this.updateAcceleration(n);
        this.updateBraking(n);
        this.updateTransmission(n);
    }

    public int getSpeedFactor() {
        return AppEngine.Fmul(this.m_speedF, this.m_maxSpeedRangeMultiplierF);
    }

    public int getSpeedFactor(int n) {
        return AppEngine.Fmul(n, this.m_maxSpeedRangeMultiplierF);
    }

    private void updateAcceleration(int n) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        if (this.m_isBoosting) {
            if (AppEngine.getCanvas().isCarNowRacingCareer()) {
                n2 = AppEngine.Fmul(196608, this.m_boostMultiplierF);
                n3 = AppEngine.Fmul(this.m_accelerationF, n2);
                n2 = AppEngine.Fmul(78643, this.m_boostMultiplierF);
                n4 = AppEngine.Fmul(this.m_curGearMaxSpeedF, n2);
            } else {
                n3 = AppEngine.Fmul(this.m_accelerationF, 196608);
                n4 = AppEngine.Fmul(this.m_curGearMaxSpeedF, 78643);
            }
        } else if (this.m_isAccelerating) {
            n3 = this.m_accelerationF;
            n4 = this.m_curGearMaxSpeedF;
        }
        if (n3 > 0 && this.m_speedF < n4) {
            if (this.m_currentGear > 0 && this.m_timeSinceGearChangeSecsF < this.m_gearChangeAccelEaseTimeF) {
                n2 = AppEngine.smoothstepF(0, this.m_gearChangeAccelEaseTimeF, this.m_timeSinceGearChangeSecsF);
                n3 = AppEngine.Fmul(n3, n2);
            }
            this.m_speedF += AppEngine.Fmul(n3, n);
            if (this.m_speedF > n4) {
                this.m_speedF = n4;
            }
        }
    }

    private void updateBraking(int n) {
        if (this.m_isBraking) {
            this.m_speedF -= AppEngine.Fmul(0xA00000, n);
            if (this.m_speedF < 0) {
                this.m_speedF = 0;
            }
        } else if (this.m_isOffTrackBraking) {
            this.m_speedF -= AppEngine.Fmul(0x800000, n);
            if (this.m_speedF < 0) {
                this.m_speedF = 0;
            }
        }
    }

    public boolean isBoosting() {
        return this.m_isBoosting;
    }

    public void setBoosting(boolean bl) {
        if (bl && this.m_boostTimeF > 0) {
            this.turnBoostOn();
        } else {
            this.turnBoostOff();
        }
    }

    public int getBoostTimeRemaining() {
        return this.m_boostTimeF;
    }

    public int getBoostTime() {
        return 196608 - this.m_boostTimeF;
    }

    public int getBoostMultiplier() {
        return this.m_boostMultiplierF;
    }

    public void setBoostMultiplier(int n) {
        this.m_boostMultiplierF = n;
    }

    private void updateBoost(int n) {
        if (this.m_isBoosting) {
            this.m_boostTimeF -= n;
            if (this.m_boostTimeF <= 0) {
                this.m_boostTimeF = 196608;
                this.setBoosting(false);
            }
        }
    }

    private void turnBoostOn() {
        this.m_isBoosting = true;
    }

    private void turnBoostOff() {
        this.m_boostTimeF = 196608;
        this.m_isBoosting = false;
    }

    public int getGearChangeAccelEaseTime() {
        return this.m_gearChangeAccelEaseTimeF;
    }

    public void setGearChangeAccelEaseTime(int n) {
        this.m_gearChangeAccelEaseTimeF = n;
    }

    public int getGearAccel(int n) {
        return this.m_gearAccels[n];
    }

    public int getGearMinSpeed(int n) {
        return this.m_gearMinSpeeds[n];
    }

    public int getGearMaxSpeed(int n) {
        return this.m_gearMaxSpeeds[n];
    }

    public int getCurGearMinSpeed() {
        return this.m_curGearMinSpeedF;
    }

    public void setCurGearMinSpeed(int n) {
        this.m_curGearMinSpeedF = n;
    }

    public int getCurGearMaxSpeed() {
        return this.m_curGearMaxSpeedF;
    }

    public void setCurGearMaxSpeed(int n) {
        this.m_curGearMaxSpeedF = n;
        if (n > 0 && this.m_currentGear == this.m_numGears - 1) {
            this.m_maxSpeedRangeMultiplierF = AppEngine.Fdiv(65536, n);
        } else if (this.m_currentGear == this.m_numGears - 1) {
            this.m_maxSpeedRangeMultiplierF = 0;
        }
    }

    public int getTopGearMaxSpeed() {
        return this.m_gearMaxSpeeds[this.m_numGears - 1];
    }

    public void setNumGears(byte by) {
        this.m_numGears = by;
        this.m_maximumAllowedGear = (byte)(this.m_numGears - 1);
    }

    public byte getNumGears() {
        return this.m_numGears;
    }

    public void setGearAccelData(int[] nArray) {
        this.m_gearAccels = new int[nArray.length];
        for (int i = 0; i < this.m_gearAccels.length; ++i) {
            this.m_gearAccels[i] = nArray[i];
        }
        this.m_accelerationF = this.m_gearAccels[this.m_currentGear];
    }

    public void setGearMinSpeedData(int[] nArray) {
        this.m_gearMinSpeeds = new int[nArray.length];
        for (int i = 0; i < this.m_gearMinSpeeds.length; ++i) {
            this.m_gearMinSpeeds[i] = nArray[i];
        }
        this.m_curGearMinSpeedF = this.m_gearMinSpeeds[this.m_currentGear];
    }

    public void setGearMaxSpeedData(int[] nArray) {
        this.m_gearMaxSpeeds = new int[nArray.length];
        for (int i = 0; i < this.m_gearMaxSpeeds.length; ++i) {
            this.m_gearMaxSpeeds[i] = nArray[i];
        }
        this.m_curGearMaxSpeedF = this.m_gearMaxSpeeds[this.m_currentGear];
        this.m_maxSpeedRangeMultiplierF = AppEngine.Fdiv(65536, this.getTopGearMaxSpeed());
    }

    private boolean updateTransmission(int n) {
        boolean bl = false;
        if (this.m_speedF >= this.m_curGearMaxSpeedF && this.m_currentGear < this.m_maximumAllowedGear) {
            if (this.m_ID == 999 || this.m_gearChangeDelayTimerSecsF >= 16384) {
                this.incrementGear();
                this.m_gearChangeDelayTimerSecsF = 0;
                bl = true;
            } else if (this.m_ID != 999) {
                this.m_gearChangeDelayTimerSecsF += n;
            }
        } else if (this.m_speedF < this.m_curGearMinSpeedF && this.m_currentGear > 0) {
            this.decrementGear();
            if (this.m_ID != 999) {
                this.m_gearChangeDelayTimerSecsF = 0;
            }
            bl = true;
        } else if (this.m_ID != 999 && this.m_gearChangeDelayTimerSecsF != 0) {
            this.m_gearChangeDelayTimerSecsF = 0;
        } else {
            this.m_timeSinceGearChangeSecsF += n;
        }
        if (!this.m_isBoosting && this.m_speedF > this.m_curGearMaxSpeedF && !this.m_isBoosting) {
            this.m_speedF -= AppEngine.Fmul(0x780000, n);
        }
        return bl;
    }

    public void incrementGear() {
        if (this.m_currentGear < this.m_numGears - 1) {
            this.setCurrentGear((byte)(this.m_currentGear + 1));
        }
    }

    public void decrementGear() {
        if (this.m_currentGear > 0) {
            this.setCurrentGear((byte)(this.m_currentGear - 1));
        }
    }

    public void setCurrentGear(byte by) {
        this.m_currentGear = by;
        this.m_curGearMinSpeedF = AppEngine.Fmul(this.m_gearMinSpeeds[this.m_currentGear], this.m_difficultyMult);
        this.m_curGearMaxSpeedF = AppEngine.Fmul(this.m_gearMaxSpeeds[this.m_currentGear], this.m_difficultyMult);
        this.m_accelerationF = AppEngine.Fmul(this.m_gearAccels[this.m_currentGear], this.m_difficultyMult);
        this.m_timeSinceGearChangeSecsF = 0;
    }

    public byte getCurrentGear() {
        return this.m_currentGear;
    }

    public void setMaximumAllowedGear() {
        this.setMaximumAllowedGear((byte)(this.m_numGears - 1));
    }

    public void setMaximumAllowedGear(byte by) {
        this.m_maximumAllowedGear = by;
        if (this.m_maximumAllowedGear < this.m_currentGear) {
            this.setCurrentGear(this.m_maximumAllowedGear);
        }
    }

    public byte getMaximumAllowedGear() {
        return this.m_maximumAllowedGear;
    }

    public boolean isMaximumGearAllowed() {
        return this.m_maximumAllowedGear == this.m_numGears - 1;
    }

    public int getRacePos() {
        return this.m_racePosition;
    }

    public void setRacePos(int n) {
        this.m_racePosition = n;
    }

    public void updateCatchupCode(int n) {
        if (this.m_catchupCodeMultCurrF < this.m_catchupCodeMultTargetF) {
            this.m_catchupCodeMultCurrF += AppEngine.Fmul(655, n);
            if (this.m_catchupCodeMultCurrF > this.m_catchupCodeMultTargetF) {
                this.m_catchupCodeMultCurrF = this.m_catchupCodeMultTargetF;
            }
        } else if (this.m_catchupCodeMultCurrF > this.m_catchupCodeMultTargetF) {
            this.m_catchupCodeMultCurrF -= AppEngine.Fmul(655, n);
            if (this.m_catchupCodeMultCurrF < this.m_catchupCodeMultTargetF) {
                this.m_catchupCodeMultCurrF = this.m_catchupCodeMultTargetF;
            }
        }
    }

    public boolean registerCriminalCarHit() {
        if (this.m_type != 3) {
            return false;
        }
        if (!this.criminalRecentlyHit() && !this.isDead()) {
            ++this.m_criminalCarHitCount;
            this.m_hitTimer = 0;
            if (this.isDead()) {
                this.m_lateralPosTargetF = this.m_lateralPosF >= 0 ? 91750 : -91750;
            }
        }
        return this.isDead();
    }

    public int getCriminalCarHealth() {
        return 4 - this.m_criminalCarHitCount;
    }

    public boolean isDead() {
        return this.m_criminalCarHitCount >= 4 && this.m_type == 3;
    }

    public boolean criminalRecentlyHit() {
        return this.m_hitTimer < 65536;
    }
}

