/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Animator;
import com.ea.game.Camera;
import com.ea.game.Character;
import com.ea.game.Constants;
import com.ea.game.Enemy;
import com.ea.game.GameImpl;
import com.ea.game.SpriteConstants;
import com.ea.game.Utils;
import com.ea.game.XSprite;
import com.ea.sdk.SDKCanvas;
import com.ea.sdk.SDKGraphics;

public class Target
implements Constants.TargetConstants,
Constants,
SpriteConstants {
    int state;
    int mode;
    public Character owner;
    Enemy enemyTarget;
    int posX;
    int posY;
    Animator animator = new Animator();
    Animator stealthAnimator;
    int[] targetRect;
    int sign = -1;
    public int pistolHeadSpeed;
    public int pistolBodySpeed;
    public int rifleHeadSpeed;
    public int rifleBodySpeed;
    public boolean isBurst;
    public int height;
    public int speed;
    public int previousSign = -1;
    public int head = 0;
    public int neck = 0;
    public int legs = 0;
    public int drawDeviationX;
    public int drawDeviationY;
    static final int[] WEPON_TARGET_MODE_MAPPING = new int[]{0, 0, 0, 1, 0};

    Target(Character character) {
        this.animator._sprite = 5;
        this.stealthAnimator = new Animator();
        this.stealthAnimator._sprite = 7;
        this.owner = character;
        this.posX = this.owner.posX;
        this.posY = this.owner.posY;
        this.isBurst = false;
        this.enemyTarget = null;
        this.setState(0);
        this.setMode(0);
    }

    public void update() {
        if (this.owner.state == 6) {
            return;
        }
        this.drawDeviationX >>= 1;
        this.drawDeviationY >>= 1;
        this.animator.UpdateCrtAnim();
        this.stealthAnimator.UpdateCrtAnim();
        switch (this.state) {
            case 0: {
                if (this.seekEnemyTarget()) break;
                this.posX = this.owner.posX + 80 * GameImpl.X_ORIENTATION_FACTOR[this.owner.orientation];
                this.posY = this.owner.posY + 80 * GameImpl.Y_ORIENTATION_FACTOR[this.owner.orientation];
                break;
            }
            case 1: {
                if (Utils.Distance(this.enemyTarget.posX - this.posX, this.enemyTarget.posY - 5120 - this.posY) >> 8 <= 7) {
                    this.setState(2);
                    break;
                }
                if (GameImpl.isInSight(this.owner.posX, this.owner.posY, this.owner.orientation, this.enemyTarget.posX, this.enemyTarget.posY) && this.enemyTarget.state != 1 && this.enemyTarget.state != 17 && this.enemyTarget.isOnScreen()) {
                    this.moveTo(this.enemyTarget.posX, this.enemyTarget.posY - 5120);
                    break;
                }
                this.setState(0);
                break;
            }
            case 2: {
                if (this.mode != 0) break;
                if (!(GameImpl.isInSight(this.owner.posX, this.owner.posY, this.owner.orientation, this.enemyTarget.posX, this.enemyTarget.posY) && this.isEnemyInRange(this.enemyTarget) && this.enemyTarget.state != 1 && this.enemyTarget.isOnScreen())) {
                    if (!this.seekEnemyTarget()) {
                        this.setState(0);
                    }
                    return;
                }
                this.height += this.sign * this.speed;
                if (this.height >> 8 <= this.head || this.height >> 8 >= this.legs) {
                    this.height = (this.sign > 0 ? this.legs : this.head) << 8;
                    this.sign = -this.sign;
                }
                this.speed = this.height >> 8 <= this.neck ? (this.owner.getWeponType() == 1 ? this.pistolHeadSpeed : this.rifleHeadSpeed) : (this.owner.getWeponType() == 1 ? this.pistolBodySpeed : this.rifleBodySpeed);
                this.posX = this.enemyTarget.posX;
                this.posY = this.enemyTarget.posY + this.height;
            }
        }
    }

    public boolean isHeadshot() {
        return this.posY <= this.enemyTarget.posY + (this.neck << 8);
    }

    public int getShootingMultiplicator() {
        int n = 1;
        if (this.isHeadshot()) {
            n = 30;
        }
        return n;
    }

    public void setUpdatedStealthAnimation() {
        if (this.owner.canComboStealthKill) {
            if (this.stealthAnimator._crt_anim != 5) {
                this.stealthAnimator.SetCrtAnim(5);
            }
        } else if (this.owner.canStealthKill && this.stealthAnimator._crt_anim != 0) {
            this.stealthAnimator.SetCrtAnim(0);
        }
    }

    public void draw(SDKGraphics sDKGraphics) {
        if (this.owner.state == 6 || this.owner.state == 8 || GameImpl.playState == 1) {
            return;
        }
        if (this.mode == 1) {
            this.animator.DrawCrtAnim(sDKGraphics, this.posX >> 8, this.posY >> 8);
            this.drawGrenadeTrajectory(sDKGraphics);
            return;
        }
        boolean bl = false;
        if (this.enemyTarget != null) {
            if (this.owner.getWeponType() != 2 && !Utils.isFlagSet(GameImpl.levels[GameImpl.currentLevel][6], 2)) {
                if (this.state != 0 && !this.owner.canStealthKill && !this.owner.canComboStealthKill && this.owner.state != 13 && !Utils.isFlagSet(GameImpl.levels[GameImpl.currentLevel][6], 2) && (bl = Enemy.canEnemyBeShoot(this.owner.posX >> 8, this.owner.posY >> 8, this.enemyTarget.posX >> 8, this.enemyTarget.posY >> 8, this.enemyTarget, GameImpl.player))) {
                    this.animator.DrawFrame(sDKGraphics, this.isHeadshot() ? 25 : 0, this.posX + (this.isBurst ? this.drawDeviationX >> 1 : this.drawDeviationX) >> 8, this.posY + (this.isBurst ? this.drawDeviationY >> 1 : this.drawDeviationY) >> 8);
                }
                if (this.state == 2) {
                    this.animator.DrawFrame(sDKGraphics, !bl || this.owner.state == 13 ? 15 : 14, this.enemyTarget.posX >> 8, this.enemyTarget.posY >> 8);
                }
            }
            if (this.enemyTarget.state != 1 && (this.owner.canStealthKill || this.owner.canComboStealthKill || this.enemyTarget == this.owner.silentKillEnemyTarget && this.owner.state == 13)) {
                if (this.owner.getWeponType() == 2 || Utils.isFlagSet(GameImpl.levels[GameImpl.currentLevel][6], 2)) {
                    this.animator.DrawFrame(sDKGraphics, 14, this.enemyTarget.posX >> 8, this.enemyTarget.posY >> 8);
                }
                this.stealthAnimator.DrawCrtAnim(sDKGraphics, (this.enemyTarget.posX >> 8) - 6, (this.enemyTarget.posY >> 8) - 70);
            }
        }
    }

    public void shoot() {
        this.drawDeviationX = Utils.random(-7168, 7168);
        this.drawDeviationY = Utils.random(-7168, 7168);
    }

    private void drawGrenadeTrajectory(SDKGraphics sDKGraphics) {
        int n = 0;
        int n2 = this.posX - (this.owner.posX + n);
        int n3 = -(GameImpl.player.weaponPosY << 7);
        int n4 = this.posY - (this.owner.posY - n3);
        int n5 = Utils.Distance(n2, n4);
        int n6 = n5 / 3000;
        if (n6 <= 0) {
            n6 = 1;
        }
        int n7 = 3515;
        int n8 = (n7 << 1) / n6;
        int n9 = 0;
        int n10 = 0;
        for (int i = 0; i <= n6; ++i) {
            n9 = this.owner.posX + n2 * i / n6 + n;
            n10 = this.owner.posY + n4 * i / n6 - (n3 += (n7 -= n8));
            if (i == 0) continue;
            sDKGraphics.setColor(0xF0000F);
            sDKGraphics.fillRect((n9 >> 8) - Camera.posX, (n10 >> 8) - Camera.posY, 2, 2);
        }
    }

    public void refreshLimits() {
        XSprite xSprite = GameImpl.sprites[this.enemyTarget.baseAnimator._sprite];
        short s = xSprite._aframes_id[xSprite._animations_af_offset[this.enemyTarget.baseAnimator._crt_anim]];
        if (this.enemyTarget.drawTurret()) {
            this.legs = xSprite._fmodules_oy[xSprite._frames_fm_offset[s]];
            xSprite = GameImpl.sprites[this.enemyTarget.turretAnimator._sprite];
            s = xSprite._aframes_id[xSprite._animations_af_offset[this.enemyTarget.turretAnimator._crt_anim]];
            this.head = xSprite._fmodules_oy[xSprite._frames_fm_offset[s]];
            this.neck = xSprite._fmodules_oy[xSprite._frames_fm_offset[s] + 1];
        } else {
            this.head = xSprite._fmodules_oy[xSprite._frames_fm_offset[s]];
            this.neck = xSprite._fmodules_oy[xSprite._frames_fm_offset[s] + 1];
            this.legs = xSprite._fmodules_oy[xSprite._frames_fm_offset[s] + 2];
        }
        this.height = this.legs + this.neck << 7;
    }

    public void setState(int n) {
        switch (n) {
            case 0: {
                this.height = 0;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (this.mode == 1) {
                    this.animator.SetCrtAnim(0);
                    break;
                }
                this.moveTo(this.enemyTarget.posX, this.enemyTarget.posY);
                XSprite xSprite = GameImpl.sprites[this.enemyTarget.baseAnimator._sprite];
                short s = xSprite._aframes_id[xSprite._animations_af_offset[this.enemyTarget.baseAnimator._crt_anim]];
                if (this.enemyTarget.drawTurret()) {
                    this.legs = xSprite._fmodules_oy[xSprite._frames_fm_offset[s]];
                    xSprite = GameImpl.sprites[this.enemyTarget.turretAnimator._sprite];
                    s = xSprite._aframes_id[xSprite._animations_af_offset[this.enemyTarget.turretAnimator._crt_anim]];
                    this.head = xSprite._fmodules_oy[xSprite._frames_fm_offset[s]];
                    this.neck = xSprite._fmodules_oy[xSprite._frames_fm_offset[s] + 1];
                } else {
                    this.head = xSprite._fmodules_oy[xSprite._frames_fm_offset[s]];
                    this.neck = xSprite._fmodules_oy[xSprite._frames_fm_offset[s] + 1];
                    this.legs = xSprite._fmodules_oy[xSprite._frames_fm_offset[s] + 2];
                }
                this.height = this.legs + this.neck << 7;
                this.sign = -1;
                this.speed = 0;
            }
        }
        this.state = n;
    }

    public void moveTo(int n, int n2) {
        int n3 = n - this.posX >> 8;
        int n4 = n2 - this.posY >> 8;
        int n5 = Utils.Distance(n3, n4);
        if (n5 != 0) {
            int n6 = n5 >> 1;
            this.posX += n6 * n3 / n5 << 8;
            this.posY += n6 * n4 / n5 << 8;
        } else {
            this.posX = n;
            this.posY = n2;
        }
    }

    public boolean seekEnemyTarget() {
        int n = (Utils.isFlagSet(GameImpl.levels[GameImpl.currentLevel][6], 2) ? 80 : this.owner.getWeponRange()) << 8;
        int n2 = -1;
        for (int i = 0; i < GameImpl.numAreaEnemies; ++i) {
            int n3;
            Enemy enemy = GameImpl.enemies[GameImpl.areaEnemies[i]];
            if (!GameImpl.isInSight(this.owner.posX, this.owner.posY, this.owner.orientation, enemy.posX, enemy.posY) || enemy.state == 1 || enemy.state == 17 || !enemy.isOnScreen() || (n3 = Utils.Distance(enemy.posX - this.owner.posX, enemy.posY - this.owner.posY)) >= n) continue;
            n2 = i;
            n = n3;
        }
        if (n2 != -1) {
            this.enemyTarget = GameImpl.enemies[GameImpl.areaEnemies[n2]];
            this.setState(1);
            return true;
        }
        return false;
    }

    public boolean isEnemyInRange(Enemy enemy) {
        int n = this.owner.getWeponRange();
        return Utils.Distance((enemy.posX >> 8) - (this.owner.posX >> 8), (enemy.posY >> 8) - (this.owner.posY >> 8)) <= n;
    }

    public boolean isLocked() {
        return this.state == 2;
    }

    public void weponChange() {
        int n = this.owner.getWeponType();
        if (n >= WEPON_TARGET_MODE_MAPPING.length) {
            this.setMode(0);
        } else {
            this.setMode(WEPON_TARGET_MODE_MAPPING[n]);
        }
    }

    public void setMode(int n) {
        if (n != this.mode) {
            this.mode = n;
            if (n == 1) {
                this.moveTo(this.owner.posX + 80 * GameImpl.X_ORIENTATION_FACTOR[this.owner.orientation], this.owner.posY + 80 * GameImpl.Y_ORIENTATION_FACTOR[this.owner.orientation]);
                this.setState(2);
            } else {
                this.setState(0);
            }
        }
    }

    public void updateControl() {
        int n;
        int n2 = 8;
        for (n = 0; n < GameImpl.MAP_KP_ORIENTATION.length; ++n) {
            if (!SDKCanvas.isKeyPressed(GameImpl.MAP_KP_ORIENTATION[n][0]) || n2 != GameImpl.MAP_KP_ORIENTATION[n][1]) continue;
            n2 = GameImpl.MAP_KP_ORIENTATION[n][2];
        }
        if (n2 != 8) {
            n = this.posX + GameImpl.X_ORIENTATION_FACTOR[n2] * 8;
            int n3 = this.posY + GameImpl.Y_ORIENTATION_FACTOR[n2] * 8;
            if (Utils.Distance(this.owner.posX - n, this.owner.posY - n3) >> 8 < this.owner.getWeponRange()) {
                this.posX = n;
                this.posY = n3;
            } else {
                int n4;
                int n5 = this.owner.posX + this.owner.getWeponRange() * GameImpl.X_ORIENTATION_FACTOR[n2] - this.posX;
                int n6 = Utils.Distance(n5, n4 = this.owner.posY + this.owner.getWeponRange() * GameImpl.Y_ORIENTATION_FACTOR[n2] - this.posY);
                if (n6 >> 8 > 4) {
                    this.posX += 2048 * n5 / n6;
                    this.posY += 2048 * n4 / n6;
                }
            }
        }
    }

    public void setBurst(boolean bl) {
        if (bl != this.isBurst) {
            this.isBurst = bl;
        }
    }

    public void blockTarget(boolean bl) {
        if (bl) {
            this.previousSign = this.sign;
            this.sign = 0;
        } else {
            this.sign = this.previousSign;
        }
    }

    public int getTurretOrientationToTarget() {
        int n;
        int n2;
        if (this.enemyTarget != null && this.state == 2 && this.mode == 0) {
            n2 = this.enemyTarget.posX - this.owner.posX;
            n = this.enemyTarget.posY - this.owner.posY;
        } else {
            n2 = this.posX - this.owner.posX;
            n = this.posY - this.owner.posY;
        }
        return GameImpl.getOrientation(n2, n);
    }
}

